/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompilationException;
import gnu.jel.Library;
import gnu.jel.Parser;
import junit.framework.TestCase;

public class ParserTest
extends TestCase {
    Library lib;

    public ParserTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        this.lib = new Library(null, null, null, null, null);
    }

    @Override
    public void tearDown() throws Exception {
    }

    public void testEOF() throws Exception {
        Parser tok = new Parser("", this.lib);
        tok.nextToken();
        ParserTest.assertEquals(-1, tok.type);
    }

    public void testOneSymTokens() throws Exception {
        String stokens = "+ -  * / % & | \n ^ < >   [ ] ~  ! ? : . ( ) ,";
        Parser tok = new Parser(stokens, this.lib);
        tok.nextToken();
        ParserTest.assertEquals(0, tok.type);
        ParserTest.assertEquals(1, tok.ct_column);
        tok.nextToken();
        ParserTest.assertEquals(1, tok.type);
        ParserTest.assertEquals(3, tok.ct_column);
        ParserTest.assertEquals(1, tok.ct_line);
        tok.nextToken();
        ParserTest.assertEquals(2, tok.type);
        ParserTest.assertEquals(6, tok.ct_column);
        String[] part1 = new String[]{"/", "%", "&", "|"};
        for (int i = 0; i < part1.length; ++i) {
            tok.nextToken();
            ParserTest.assertEquals(3 + i, tok.type);
        }
        tok.nextToken();
        ParserTest.assertEquals(7, tok.type);
        ParserTest.assertEquals(2, tok.ct_column);
        ParserTest.assertEquals(2, tok.ct_line);
        String[] part2Str = new String[]{"<", ">", "[", "]", "~", "!", "?", ":", ".", "(", ")", ","};
        int[] part2Int = new int[]{10, 12, 19, 20, 30, 31, 35, 36, 40, 41, 42, 43};
        for (int i = 0; i < part2Str.length; ++i) {
            tok.nextToken();
            ParserTest.assertEquals(part2Int[i], tok.type);
        }
        tok.nextToken();
        ParserTest.assertEquals(-1, tok.type);
        ParserTest.assertEquals(30, tok.ct_column);
    }

    public void testSimpleMultiSymTokens() throws Exception {
        String mtokens = "== != >= <= << >> && || >>>";
        Parser tok = new Parser(mtokens, this.lib);
        String[] part3Str = new String[]{"==", "!=", ">=", "<=", "<<", ">>", "&&", "||", ">>>"};
        int[] part3Int = new int[]{8, 9, 11, 13, 14, 15, 17, 18, 16};
        for (int i = 0; i < part3Str.length; ++i) {
            tok.nextToken();
            ParserTest.assertEquals(part3Int[i], tok.type);
        }
    }

    public void testMultiSymTokensSeparation() throws Exception {
        String mctokens = "=! !! >! <! &! |! >!> >>!";
        Parser tok = new Parser(mctokens, this.lib);
        try {
            tok.nextToken();
            ParserTest.assertTrue(false);
        }
        catch (CompilationException e) {
            ParserTest.assertTrue(true);
        }
        String[] part4Str = new String[]{"!", "!", "!", ">", "!", "<", "!", "&", "!", "|", "!", ">", "!", ">", ">>", "!"};
        int[] part4Int = new int[]{31, 31, 31, 12, 31, 10, 31, 5, 31, 6, 31, 12, 31, 12, 15, 31};
        for (int i = 0; i < part4Str.length; ++i) {
            tok.nextToken();
            ParserTest.assertEquals(part4Int[i], tok.type);
        }
        tok.nextToken();
        ParserTest.assertEquals(-1, tok.type);
    }

    public void testCharTokens() throws Exception {
        String chartokens = "' ' '\\n' 'a' '\\052' '\\\\' '\n' '\\'";
        char[] char1 = new char[]{' ', '\n', 'a', '*', '\\'};
        Parser tok = new Parser(chartokens, this.lib);
        for (int i = 0; i < char1.length; ++i) {
            tok.nextToken();
            ParserTest.assertEquals(new Character(char1[i]), tok.val);
        }
        try {
            tok.nextToken();
            ParserTest.assertTrue(false);
        }
        catch (CompilationException e) {
            ParserTest.assertTrue(true);
            ParserTest.assertEquals(27, e.col);
        }
    }

    public void testCharTokensErrors() throws Exception {
        Parser tok = new Parser("'\\'", this.lib);
        try {
            tok.nextToken();
            ParserTest.assertTrue(false);
        }
        catch (CompilationException e) {
            ParserTest.assertEquals(3, e.col);
        }
        tok = new Parser("'  '", this.lib);
        try {
            tok.nextToken();
            ParserTest.assertTrue(false);
        }
        catch (CompilationException e) {
            ParserTest.assertEquals(3, e.col);
        }
    }

    public void testStrTokens() throws Exception {
        String strtokens = "\"\" \" \" \"ab\\052c\"";
        String[] str1 = new String[]{"", " ", "ab*c"};
        Parser tok = new Parser(strtokens, this.lib);
        for (int i = 0; i < str1.length; ++i) {
            tok.nextToken();
            ParserTest.assertEquals((Object)str1[i], tok.val);
        }
    }

    public void testNameTokens() throws Exception {
        Parser tok = new Parser("a+bba", this.lib);
        tok.nextToken();
        ParserTest.assertEquals((Object)"a", tok.val);
        tok.nextToken();
        ParserTest.assertEquals(0, tok.type);
        tok.nextToken();
        ParserTest.assertEquals((Object)"bba", tok.val);
        tok.nextToken();
        ParserTest.assertEquals(-1, tok.type);
    }

    public void testIntegralTokens() throws Exception {
        String i1tokens = "1 011 258   0xFF 67000 456890L";
        Object[] i1 = new Object[]{new Byte(1), new Byte(9), new Short(258), new Short(255), new Integer(67000), new Long(456890L)};
        Parser tok = new Parser(i1tokens, this.lib);
        for (int i = 0; i < i1.length; ++i) {
            tok.nextToken();
            ParserTest.assertEquals(i1[i], tok.val);
        }
        tok.nextToken();
        ParserTest.assertEquals(-1, tok.type);
    }

    public void testIntegralLimit() throws Exception {
        Parser tok = new Parser("0xFFFFFFFF 2147483647", this.lib);
        tok.nextToken();
        ParserTest.assertEquals(60, tok.type);
        ParserTest.assertEquals(new Integer(-1), tok.val);
        tok.nextToken();
        ParserTest.assertEquals(60, tok.type);
        ParserTest.assertEquals(new Integer(Integer.MAX_VALUE), tok.val);
    }

    public void testRealTokens() throws Exception {
        String d1tokens = ".1 0.1 0.1E1 001.0E-1 001.0E-1F 1F";
        Object[] d1 = new Object[]{new Double(0.1), new Double(0.1), new Double(1.0), new Double(0.1), new Float(0.1), new Float(1.0)};
        Parser tok = new Parser(d1tokens, this.lib);
        for (int i = 0; i < d1.length; ++i) {
            tok.nextToken();
            ParserTest.assertEquals(d1[i], tok.val);
        }
        tok.nextToken();
        ParserTest.assertEquals(-1, tok.type);
    }

    public void testNoCast() throws Exception {
        Parser tok = new Parser("1", this.lib);
        tok.nextToken();
        ParserTest.assertTrue(!tok.isCast());
        tok.nextToken();
        ParserTest.assertEquals(new Byte(1), tok.val);
        tok.nextToken();
        ParserTest.assertEquals(-1, tok.type);
    }

    public void testFalseCasts() throws Exception {
        String[] fcasts = new String[]{"1", "(", "()", "(a", "(a[", "(a)", "(a)-"};
        for (int i = 0; i < fcasts.length; ++i) {
            Parser tok = new Parser(fcasts[i], this.lib);
            ParserTest.assertTrue(!tok.isCast());
        }
    }

    public void testTrueCasts() throws Exception {
        String[] tcasts = new String[]{"(a)(", "(a.b.c)0", "(a.b.c[]", " ( a ) ( ", " ( a . b . c ) 0 ", " ( a .  b . c [  ] "};
        for (int i = 0; i < tcasts.length; ++i) {
            Parser tok = new Parser(tcasts[i], this.lib);
            tok.nextToken();
            ParserTest.assertTrue(tok.isCast());
        }
    }

    public void testTab() throws Exception {
        Parser tok = new Parser("5*\t7", this.lib);
        tok.nextToken();
        ParserTest.assertEquals(60, tok.type);
        ParserTest.assertEquals(new Byte(5), tok.val);
        tok.nextToken();
        ParserTest.assertEquals(2, tok.type);
        tok.nextToken();
        ParserTest.assertEquals(60, tok.type);
        ParserTest.assertEquals(new Byte(7), tok.val);
        tok.nextToken();
        ParserTest.assertEquals(-1, tok.type);
    }

    public void testDoubleBndry() throws Exception {
        Parser tok = new Parser("1.0-+1.0", this.lib);
        tok.nextToken();
        ParserTest.assertEquals(60, tok.type);
        ParserTest.assertEquals(new Double(1.0), tok.val);
    }

    public void testFNCall() throws Exception {
        Parser tok = new Parser("sin(1)", this.lib);
        tok.nextToken();
        ParserTest.assertEquals(50, tok.type);
        ParserTest.assertEquals((Object)"sin", tok.val);
        ParserTest.assertTrue(!tok.isCast());
        tok.nextToken();
        ParserTest.assertEquals(41, tok.type);
        tok.nextToken();
        ParserTest.assertEquals(60, tok.type);
        ParserTest.assertEquals(new Byte(1), tok.val);
        tok.nextToken();
        ParserTest.assertEquals(42, tok.type);
        tok.nextToken();
        ParserTest.assertEquals(-1, tok.type);
    }

    public void testCast() throws Exception {
        Parser tok = new Parser("(float)4", this.lib);
        tok.nextToken();
        ParserTest.assertTrue(tok.isCast());
    }
}

