/*
 *  Copyright (C) 2004-2022 Savoir-faire Linux Inc.
 *
 *  Author: Guillaume Roguez <Guillaume.Roguez@savoirfairelinux.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA.
 */

#ifndef __LIBAV_DEPS_H__
#define __LIBAV_DEPS_H__

// NOTE versions of FFmpeg's librairies can be checked using something like this:
// #if LIBAVCODEC_VERSION_INT >= AV_VERSION_INT( major, minor, micro )

extern "C" {
#include <libavcodec/avcodec.h>
#include <libavfilter/avfilter.h>
#include <libavformat/avformat.h>
#include <libavdevice/avdevice.h>
#include <libswscale/swscale.h>
#include <libavutil/avutil.h>
#include <libavutil/time.h>
#include <libavutil/pixdesc.h>
#include <libavutil/opt.h>
#include <libavutil/channel_layout.h>
#include <libavutil/imgutils.h>
#include <libavutil/intreadwrite.h>
#include <libavutil/log.h>
#include <libavutil/samplefmt.h>

#if LIBAVUTIL_VERSION_MAJOR < 56
AVFrameSideData* av_frame_new_side_data_from_buf(AVFrame* frame,
                                                 enum AVFrameSideDataType type,
                                                 AVBufferRef* buf);
#endif
}

#include "libav_utils.h"

#endif // __LIBAV_DEPS_H__
