/*  gnutrition - a nutrition and diet analysis program.
 *  Copyright(C) 2000, 2001 Edgar Denny(e.denny@ic.ac.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>

#include "text_util.h"
#include "food.h"
#include "recipe.h"
#include "wrap_mysql.h"

/* save a recipe. */
void
gnutr_save_recipe( GList *list_ingr, 
                   char *recipe_name, 
                   char *no_serv,
                   char *category_no,
                   int no_ingredients)
{
	char *query;
	gboolean success;
	GList *ptr;
	char **elm;
	char *msre_no;
	GHashTable *htbl;

	g_return_if_fail( list_ingr);
	g_return_if_fail( recipe_name);
	g_return_if_fail( category_no);
	g_return_if_fail( no_serv);

	htbl = get_htbl_msre_desc_msre_no();

	/* save the recipe name to the recipe table. */
	query = g_strconcat( "INSERT INTO recipe VALUES ",
		"( NULL, '", recipe_name, "', '", no_serv, "', '",
		itoa( no_ingredients), "', '", category_no, "')", NULL);
	success = no_ret_val_query_db( query);
	g_free( query);
	g_assert( success);

	/* save each ingredient to the ingredient table. */
	for ( ptr = list_ingr; ptr; ptr = ptr->next) {
		elm = (char **)ptr->data;
		/* elm[0] = amount, elm[1] = msre_desc, elm[2] = food_no. */
		if ( strcmp( elm[1], "gm") == 0) {
			msre_no = g_strdup( "99999");
		} else {
			msre_no = (char *)g_hash_table_lookup( htbl, 
				(gpointer)elm[1]);
		}

		query = g_strconcat( "INSERT INTO ingredient VALUES ",
			"( LAST_INSERT_ID(), '",
			elm[0], "', '", msre_no, "', '", elm[2], "')", NULL);
		success = no_ret_val_query_db( query);
		g_free( query);
		g_assert( success);
	}
}

/* delete a recipe. */
void
gnutr_delete_recipe( char *recipe_no)
{
	char *query;
	gboolean success;

	g_return_if_fail( recipe_no);

	query = g_strconcat( "DELETE FROM recipe WHERE ",
		"recipe_no = '", recipe_no, "'", NULL);
	success = no_ret_val_query_db( query);
	g_free( query);
	g_assert( success);

	query = g_strconcat( "DELETE FROM ingredient WHERE ",
		"recipe_no = '", recipe_no, "'", NULL);
	success = no_ret_val_query_db( query);
	g_free( query);
	g_assert( success);
}

/* see if the recipe is already in the database. */
char *
gnutr_check_recipe_exists( char *recipe_name)
{
	char *query;
	char *recipe_no = NULL;

	g_return_val_if_fail( recipe_name, FALSE);

	query = g_strconcat( "SELECT recipe_no FROM recipe ",
		"WHERE recipe_name='", recipe_name, "'", NULL);
	recipe_no = single_ret_val_query_db( query);
	g_free( query);

	if ( recipe_no) return recipe_no;
	return NULL;
}

/* a hash table where the category description is the key and the
 * the category number is the value. */
static GHashTable *cat_desc_cat_no_htbl = NULL;

/* a hash table where the category no is the key and the
 * the category desc is the value. */
static GHashTable *cat_no_cat_desc_htbl = NULL;

/* a GList which contains the category descriptions. */
static GList *cat_desc_list = NULL;

/* create two hash tables which associate between the category
 * description and the category number. Also create a list of
 * category descriptions. */
static void
create_htbl_cat_desc_cat_no()
{
	GList *list = NULL, *ptr;
	char *query;
	char **pair;

	cat_desc_cat_no_htbl = g_hash_table_new( g_str_hash, g_str_equal);
	cat_no_cat_desc_htbl = g_hash_table_new( g_str_hash, g_str_equal);

	query = g_strdup( "SELECT category_desc, category_no FROM category");
	list = rows_glist_ret_val_query_db( query);
	g_assert( list);
	g_free( query);

	for (ptr = list; ptr; ptr = ptr->next) {
		pair = (char **)ptr->data;
		g_hash_table_insert( cat_desc_cat_no_htbl,
			(gpointer)pair[0], (gpointer)pair[1]);

		g_hash_table_insert( cat_no_cat_desc_htbl,
			(gpointer)pair[1], (gpointer)pair[0]);

		/* the list of category descriptions. */
		cat_desc_list = g_list_append( cat_desc_list, 
			(gpointer)pair[0]);
	}
}

/* return a hash table where the category description is the key and the
 * the category number is the value. */
GHashTable *
get_htbl_cat_desc_cat_no()
{
	if ( !cat_desc_cat_no_htbl) create_htbl_cat_desc_cat_no();

	g_assert( cat_desc_cat_no_htbl);
	return cat_desc_cat_no_htbl;
}

/* return a hash table where the category nunmber is the key and the
 * the category description is the value. */
GHashTable *
get_htbl_cat_no_cat_desc()
{
	if ( !cat_no_cat_desc_htbl) create_htbl_cat_desc_cat_no();

	g_assert( cat_no_cat_desc_htbl);
	return cat_no_cat_desc_htbl;
}

GList *
get_cat_desc_list()
{
	if ( !cat_desc_list) create_htbl_cat_desc_cat_no();

	g_assert( cat_desc_list);
	return cat_desc_list;
}
