/*  gnutrition - a nutrition and diet analysis program.
 *  Copyright( C) 2000, 2001 Edgar Denny( e.denny@ic.ac.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 * ( at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>
#include <ctype.h>

#include "text_util.h"
#include "food.h"
#include "recipe.h"
#include "plan.h"
#include "load_data.h"
#include "base_win.h"
#include "plan_win.h"
#include "recipe_win.h"
#include "food_win.h"
#include "support.h"
#include "nutr_comp_dlg.h"

static GladeXML *xml = NULL;
static void load_xml( void);
static void connect_signals( void);

/* private callbacks. */
static gint on_delete_event( GtkWidget *, GdkEvent *, gpointer);
static void on_destroy( GtkWidget *, gpointer);
static void on_plan_view_button_released( GtkButton *, gpointer);
static void on_recipe_view_button_released( GtkButton *, gpointer);
static void on_food_view_button_released( GtkButton *, gpointer);

/* load the glade xml if not already loaded. */
static void
load_xml()
{
	static gboolean loaded_xml = FALSE;

	/* load the glade interface. */
	if( !loaded_xml) {
		xml = glade_xml_new( 
			GNUTRITION_GLADEDIR "/base_win.glade", NULL);
		loaded_xml = TRUE;
		if( xml) {
			connect_signals();
		} else {
			g_log( "Gnutrition", G_LOG_LEVEL_ERROR,
				"cannot load glade file: base_win.glade\n");
			return;
		}
	}
}

/* connect the signals. */
static void
connect_signals()
{
	gtk_signal_connect( GTK_OBJECT( 
		glade_xml_get_widget( xml, "base_win")), 
		"delete_event", GTK_SIGNAL_FUNC(  on_delete_event), NULL); 
	gtk_signal_connect( GTK_OBJECT( 
		glade_xml_get_widget(  xml, "base_win")), 
		"destroy", GTK_SIGNAL_FUNC(  on_destroy), NULL);
	gtk_signal_connect( GTK_OBJECT( 
		glade_xml_get_widget(  xml, "plan_button")), "released", 
		GTK_SIGNAL_FUNC(  on_plan_view_button_released), NULL);
	gtk_signal_connect( GTK_OBJECT( 
		glade_xml_get_widget(  xml, "recipe_button")), "released", 
		GTK_SIGNAL_FUNC(  on_recipe_view_button_released), NULL);
	gtk_signal_connect( GTK_OBJECT( 
		glade_xml_get_widget(  xml, "food_button")), "released", 
		GTK_SIGNAL_FUNC(  on_food_view_button_released), NULL);
}

/* show the base window. */
void
gnutr_show_base_win()
{
	GtkWidget *recipe_menubar, *recipe_toolbar, *recipe_table, 
		*recipe_appbar;
	GtkWidget *plan_menubar, *plan_toolbar, *plan_table, *plan_appbar;
	GtkWidget *food_menubar, *food_toolbar, *food_table, *food_appbar;
	GtkWidget *base_menubar_box, *base_toolbar_box;
	GtkWidget *base_app_box, *base_appbar_box;
	GtkWidget *base_win;
	GtkWidget *base_recipe_button, *base_plan_button, *base_food_button;
	GtkWidget *plan_pixmap, *recipe_pixmap, *food_pixmap;
	char *fn_plan_pixmap, *fn_recipe_pixmap, *fn_food_pixmap;

	/* load the glade_xml if it hasn't already been done. */
	if(  !xml) load_xml( );

	/* get the buttons in the vertical "shortcuts" toolbar. */
	base_plan_button = glade_xml_get_widget( xml, "plan_button");
	base_recipe_button = glade_xml_get_widget( xml, "recipe_button");
	base_food_button = glade_xml_get_widget( xml, "food_button");

	/* set the button reliefs. */
	gtk_button_set_relief( GTK_BUTTON( base_plan_button), GTK_RELIEF_NONE);
	gtk_button_set_relief( GTK_BUTTON( base_recipe_button), 
		GTK_RELIEF_NONE);
	gtk_button_set_relief( GTK_BUTTON( base_food_button), GTK_RELIEF_NONE);

	/* add the pixmaps to the buttons. glade puts them relative to
	 * where gnome is stored - which is tricky if gnutrition is
	 * not installed in the same place as gnome. This way, gnutrition
	 * can be stored anywhere and the pixmaps will be found.*/
	plan_pixmap = gtk_type_new( gnome_pixmap_get_type());
	fn_plan_pixmap = g_strdup( GNUTRITION_ICONDIR "/plan.png");
	if ( fn_plan_pixmap) {
		gnome_pixmap_load_file( GNOME_PIXMAP( plan_pixmap), 
			fn_plan_pixmap);
	} else {
		g_warning (_("Couldn't find pixmap file: %s"), "plan.png");
	}
	g_free (fn_plan_pixmap);
	gtk_widget_show( plan_pixmap);
	gtk_container_add( GTK_CONTAINER( base_plan_button), plan_pixmap);

	recipe_pixmap = gtk_type_new( gnome_pixmap_get_type());
	fn_recipe_pixmap = g_strdup( GNUTRITION_ICONDIR "/cake.png");
	if ( fn_recipe_pixmap) {
		gnome_pixmap_load_file( GNOME_PIXMAP( recipe_pixmap), 
			fn_recipe_pixmap);
	} else {
		g_warning (_("Couldn't find pixmap file: %s"), "cake.png");
	}
	g_free (fn_recipe_pixmap);
	gtk_widget_show( recipe_pixmap);
	gtk_container_add( GTK_CONTAINER( base_recipe_button), recipe_pixmap);

	food_pixmap = gtk_type_new( gnome_pixmap_get_type());
	fn_food_pixmap = g_strdup( GNUTRITION_ICONDIR "/banana.png");
	if ( fn_food_pixmap) {
		gnome_pixmap_load_file( GNOME_PIXMAP( food_pixmap), 
			fn_food_pixmap);
	} else {
		g_warning (_("Couldn't find pixmap file: %s"), "banana.png");
	}
	g_free (fn_food_pixmap);
	gtk_widget_show( food_pixmap);
	gtk_container_add( GTK_CONTAINER( base_food_button), food_pixmap);

	/* get recipe window widgets. */
	recipe_menubar = gnutr_get_recipe_win_menubar();
	recipe_toolbar = gnutr_get_recipe_win_toolbar();
	recipe_table = gnutr_get_recipe_win_table();
	recipe_appbar = gnutr_get_recipe_win_appbar();

	/* get planner window widgets. */
	plan_menubar = gnutr_get_plan_win_menubar();
	plan_toolbar = gnutr_get_plan_win_toolbar();
	plan_table = gnutr_get_plan_win_table();
	plan_appbar = gnutr_get_plan_win_appbar();

	/* get food window widgets. */
	food_menubar = gnutr_get_food_win_menubar();
	food_toolbar = gnutr_get_food_win_toolbar();
	food_table = gnutr_get_food_win_table();
	food_appbar = gnutr_get_food_win_appbar();

	/* get the base widgets. */
	base_win = glade_xml_get_widget( xml, "base_win");

	base_menubar_box = glade_xml_get_widget( xml, "base_menubar_box");
	base_toolbar_box = glade_xml_get_widget( xml, "base_toolbar_box");
	base_app_box = glade_xml_get_widget( xml, "base_app_box");
	base_appbar_box = glade_xml_get_widget( xml, "base_appbar_box");

	/* reparent or add the recipe_win widgets into the base window and
	 * show the base window. */
	gtk_widget_reparent( recipe_menubar, base_menubar_box);
	gtk_widget_reparent( recipe_toolbar, base_toolbar_box);
	gtk_widget_reparent( recipe_table, base_app_box);
	gtk_widget_reparent( recipe_appbar, base_appbar_box);

	/* reparent or add the plan_win widgets into the base window and
	 * show the base window. */
	gtk_widget_reparent( plan_menubar, base_menubar_box);
	gtk_widget_reparent( plan_toolbar, base_toolbar_box);
	gtk_widget_reparent( plan_table, base_app_box);
	gtk_widget_reparent( plan_appbar, base_appbar_box);

	/* reparent or add the recipe_win widgets into the base window and
	 * show the base window. */
	gtk_widget_reparent( food_menubar, base_menubar_box);
	gtk_widget_reparent( food_toolbar, base_toolbar_box);
	gtk_widget_reparent( food_table, base_app_box);
	gtk_widget_reparent( food_appbar, base_appbar_box);

	/* show the plan_win widgets. */
	gtk_widget_show( plan_menubar);
	gtk_widget_show( plan_toolbar);
	gtk_widget_show( plan_table);
	gtk_widget_show( plan_appbar);

	/* hide the recipe_win widgets. */
	gtk_widget_hide( recipe_menubar);
	gtk_widget_hide( recipe_toolbar);
	gtk_widget_hide( recipe_table);
	gtk_widget_hide( recipe_appbar);

	/* hide the food_win widgets. */
	gtk_widget_hide( food_menubar);
	gtk_widget_hide( food_toolbar);
	gtk_widget_hide( food_table);
	gtk_widget_hide( food_appbar);

	gtk_widget_show( base_win);

	/* set the clist for the plan window. */
	gnutr_set_plan_clist_position();
}

/* switch to the "Recipe" view. */
void
gnutr_switch_to_recipe_view()
{
	GtkWidget *base_win = glade_xml_get_widget( xml, "base_win");

	/* get recipe window widgets. */
	GtkWidget *recipe_menubar = gnutr_get_recipe_win_menubar();
	GtkWidget *recipe_toolbar = gnutr_get_recipe_win_toolbar();
	GtkWidget *recipe_table = gnutr_get_recipe_win_table();
	GtkWidget *recipe_appbar = gnutr_get_recipe_win_appbar();

	/* get planner window widgets. */
	GtkWidget *plan_menubar = gnutr_get_plan_win_menubar();
	GtkWidget *plan_toolbar = gnutr_get_plan_win_toolbar();
	GtkWidget *plan_table = gnutr_get_plan_win_table();
	GtkWidget *plan_appbar = gnutr_get_plan_win_appbar();

	/* get food window widgets. */
	GtkWidget *food_menubar = gnutr_get_food_win_menubar();
	GtkWidget *food_toolbar = gnutr_get_food_win_toolbar();
	GtkWidget *food_table = gnutr_get_food_win_table();
	GtkWidget *food_appbar = gnutr_get_food_win_appbar();

	/* hide the plan_win widgets. */
	gtk_widget_hide( plan_menubar);
	gtk_widget_hide( plan_toolbar);
	gtk_widget_hide( plan_table);
	gtk_widget_hide( plan_appbar);

	/* show the recipe_win widgets. */
	gtk_widget_show( recipe_menubar);
	gtk_widget_show( recipe_toolbar);
	gtk_widget_show( recipe_table);
	gtk_widget_show( recipe_appbar);

	/* hide the food_win widgets. */
	gtk_widget_hide( food_menubar);
	gtk_widget_hide( food_toolbar);
	gtk_widget_hide( food_table);
	gtk_widget_hide( food_appbar);

	gtk_widget_show( base_win);
}

/* when the "Recipe" button is released in the "View" toolbar box. */
static void
on_recipe_view_button_released( GtkButton *button,
                                gpointer   data)
{
	gnutr_switch_to_recipe_view();
}

/* switch to the "Meal Plan" view. */
void
gnutr_switch_to_meal_plan_view()
{
	GtkWidget *base_win = glade_xml_get_widget( xml, "base_win");

	/* get recipe window widgets. */
	GtkWidget *recipe_menubar = gnutr_get_recipe_win_menubar();
	GtkWidget *recipe_toolbar = gnutr_get_recipe_win_toolbar();
	GtkWidget *recipe_table = gnutr_get_recipe_win_table();
	GtkWidget *recipe_appbar = gnutr_get_recipe_win_appbar();

	/* get planner window widgets. */
	GtkWidget *plan_menubar = gnutr_get_plan_win_menubar();
	GtkWidget *plan_toolbar = gnutr_get_plan_win_toolbar();
	GtkWidget *plan_table = gnutr_get_plan_win_table();
	GtkWidget *plan_appbar = gnutr_get_plan_win_appbar();

	/* get food window widgets. */
	GtkWidget *food_menubar = gnutr_get_food_win_menubar();
	GtkWidget *food_toolbar = gnutr_get_food_win_toolbar();
	GtkWidget *food_table = gnutr_get_food_win_table();
	GtkWidget *food_appbar = gnutr_get_food_win_appbar();

	/* show the plan_win widgets. */
	gtk_widget_show( plan_menubar);
	gtk_widget_show( plan_toolbar);
	gtk_widget_show( plan_table);
	gtk_widget_show( plan_appbar);

	/* hide the recipe_win widgets. */
	gtk_widget_hide( recipe_menubar);
	gtk_widget_hide( recipe_toolbar);
	gtk_widget_hide( recipe_table);
	gtk_widget_hide( recipe_appbar);

	/* hide the food_win widgets. */
	gtk_widget_hide( food_menubar);
	gtk_widget_hide( food_toolbar);
	gtk_widget_hide( food_table);
	gtk_widget_hide( food_appbar);

	gtk_widget_show( base_win);

	/* set the clist for the plan window. */
	gnutr_set_plan_clist_position();
}

/* when the "Meal Plan" button is released in the "View" toolbar box. */
static void
on_plan_view_button_released( GtkButton *button,
                              gpointer   data)
{
	gnutr_switch_to_meal_plan_view();
}

/* switch to the "Food" view. */
void
gnutr_switch_to_food_view()
{
	GtkWidget *base_win = glade_xml_get_widget( xml, "base_win");
	GtkWidget *food_win_notebook_container = 
		gnutr_get_food_win_notebook_container();
	GtkWidget *notebook = gnutr_get_comp_notebook();

	/* get recipe window widgets. */
	GtkWidget *recipe_menubar = gnutr_get_recipe_win_menubar();
	GtkWidget *recipe_toolbar = gnutr_get_recipe_win_toolbar();
	GtkWidget *recipe_table = gnutr_get_recipe_win_table();
	GtkWidget *recipe_appbar = gnutr_get_recipe_win_appbar();

	/* get planner window widgets. */
	GtkWidget *plan_menubar = gnutr_get_plan_win_menubar();
	GtkWidget *plan_toolbar = gnutr_get_plan_win_toolbar();
	GtkWidget *plan_table = gnutr_get_plan_win_table();
	GtkWidget *plan_appbar = gnutr_get_plan_win_appbar();

	/* get food window widgets. */
	GtkWidget *food_menubar = gnutr_get_food_win_menubar();
	GtkWidget *food_toolbar = gnutr_get_food_win_toolbar();
	GtkWidget *food_table = gnutr_get_food_win_table();
	GtkWidget *food_appbar = gnutr_get_food_win_appbar();

	g_assert( notebook);
	g_assert( food_win_notebook_container);

	/* hide the plan_win widgets. */
	/* FIXME: when the plan is closed, need to check
	 * if the popup calendar also needs to be closed. */
	gtk_widget_hide( plan_menubar);
	gtk_widget_hide( plan_toolbar);
	gtk_widget_hide( plan_table);
	gtk_widget_hide( plan_appbar);

	/* hide the recipe_win widgets. */
	gtk_widget_hide( recipe_menubar);
	gtk_widget_hide( recipe_toolbar);
	gtk_widget_hide( recipe_table);
	gtk_widget_hide( recipe_appbar);

	/* reset all the entries in the food nutrient composition
	 * notebook pages to zero. */
	gnutr_reset_nutr_comp();

	/* show the food_win widgets. */
	gtk_widget_show( food_menubar);
	gtk_widget_show( food_toolbar);
	gtk_widget_show( food_table);
	gtk_widget_show( food_appbar);
	/* reparent the nutr_comp_dlg notebook to the food_win notebook 
	 * container so it can be re-used here. */
	gtk_widget_reparent( notebook, food_win_notebook_container);

	gtk_widget_show( base_win);
}

/* when the "Food" button is released in the "View" toolbar box. */
static void
on_food_view_button_released( GtkButton *button,
                              gpointer   data)
{
	gnutr_switch_to_food_view();
}

/* callback when window is destroyed by the window manager, or FALSE
 * is returned from the delete_event. */
static void
on_destroy( GtkWidget *widget,
            gpointer   data)
{
	gtk_main_quit();
}

/* callback usually given when window is closed by window manager. */
static gint
on_delete_event( GtkWidget *widget,
                 GdkEvent  *event,
                 gpointer   data)
{
	return FALSE;
}

GtkWidget *
gnutr_get_base_win()
{
	return glade_xml_get_widget( xml, "base_win");
}

GtkWidget *
gnutr_get_base_win_container()
{
	return glade_xml_get_widget( xml, "base_widget");
}

GtkWidget *
gnutr_get_base_toolbar_container()
{
	return glade_xml_get_widget( xml, "base_toolbar_box");
}

GtkWidget *
gnutr_get_base_menubar_container()
{
	return glade_xml_get_widget( xml, "base_menubar_box");
}

GtkWidget *
gnutr_get_base_app_container()
{
	return glade_xml_get_widget( xml, "base_app_box");
}
