/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GROSCOPESINKX_H_
#define _GROSCOPESINKX_H_

#include <GrSink.h>
#include <gr_TriggerMode.h>

class gr_OscopeGuts;


/*!
 * \brief building block for python oscilloscope module
 */

class GrOscopeSinkX : public GrSink
{
protected:
  gr_OscopeGuts		*d_guts;

public:
  GrOscopeSinkX (int input_itemsize);
  ~GrOscopeSinkX ();

  bool setUpdateRate (double update_rate);
  bool setDecimationCount (int decimation_count);
  bool setTriggerChannel (int channel);
  bool setTriggerMode (gr_TriggerMode mode);
  bool setTriggerLevel (double trigger_level);
  bool setTriggerLevelAuto ();				// set to 50% level


  // ACCESSORS
  int getNumChannels () const;
  double getSamplingRate () const;
  double getUpdateRate () const;
  int getDecimationCount () const;
  int getTriggerChannel () const;
  gr_TriggerMode getTriggerMode () const;
  double getTriggerLevel () const;

  // # of samples written to each output record.
  int getSamplesPerOutputRecord () const;
  
};

#endif /* _GROSCOPESINKX_H_ */
