/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef _GRHILBERT_H_
#define _GRHILBERT_H_

#include <VrHistoryProc.h>
#include <VrComplex.h>
#include <gr_fir.h>
#include <gr_firdes.h>

template<class iType> 
class GrHilbert : public VrHistoryProc<iType,VrComplex> {
private:
  gr_fir<float,iType,float> hilb;
  unsigned int taps;
public: 
  virtual const char *name() { return "GrHilbert"; }
  virtual int work(VrSampleRange output, void *o[],
		   VrSampleRange inputs[], void *i[]);
  GrHilbert(unsigned int taps);
};

template<class iType> int
GrHilbert<iType>::work(VrSampleRange output, void *ao[],
			      VrSampleRange inputs[], void *ai[])
{
  iType **i = (iType **)ai;
  VrComplex **o = (VrComplex **)ao;
  int size = output.size;
  for(int x = 0; x<size; x++)
    {
      o[0][x].real(i[0][x+taps/2]);
      o[0][x].imag(hilb.filter(&i[0][x]));
    }
  return output.size;
}

template<class iType> 
GrHilbert<iType>::GrHilbert(unsigned int taps)
  : VrHistoryProc<iType,VrComplex>(1), 
    hilb(gr_firdes::hilbert(taps)),taps(taps)
{ 
  history = taps;
}
#endif
