/* Check that legacy shadow stack code in init_array won't trigger
   segfault.
   Copyright (C) 2023-2024 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */

#include <stdlib.h>
#include <support/test-driver.h>

/* Check that legacy shadow stack code in init_array won't trigger
   segfault.  */
extern void legacy (void);
int done;

void
legacy_1 (void)
{
  legacy ();
  done = 1;
}

void (*init_array []) (void)
     __attribute__ ((section (".init_array"), aligned (sizeof (void *)))) =
{
  &legacy_1
};

static int
do_test (void)
{
  return EXIT_SUCCESS;
}

#include <support/test-driver.c>
