/* Test for labels and VM declarations: bug 12913.
   goto statements must not jump into the scope of VM declarations.

   This tests all combinations of label and goto locations in a given
   function.

   c99-vla-jump-1.c tests with just that label and goto, VLAs.
   c99-vla-jump-2.c tests with many other labels and gotos, VLAs.
   c99-vla-jump-3.c tests with just that label and goto, VM.
   c99-vla-jump-4.c tests with many other labels and gotos, VM.
   c99-vla-jump-5.c tests with switch statements.  */

/* Origin: Joseph Myers <joseph@codesourcery.com> */
/* { dg-do compile } */
/* { dg-options "-std=iso9899:1999 -pedantic-errors" } */

void fc0 (int n) {  goto a; a:{ typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc1 (int n) {  goto a; { typedef int (*b)[n]; a:{ typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc2 (int n) {  goto a; { typedef int (*b)[n]; { typedef int (*c)[n]; a:0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc3 (int n) {  goto a; { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} a:{ typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc4 (int n) {  goto a; { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; a:0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc5 (int n) {  goto a; { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} a:; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc6 (int n) {  goto a; { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; a:0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc7 (int n) {  goto a; { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; a:{ typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc8 (int n) {  goto a; { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; a:{ typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc9 (int n) {  goto a; { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; a:0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc10 (int n) {  goto a; { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; a:{ typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc11 (int n) {  goto a; { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; a:0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc12 (int n) {  goto a; { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; a:; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc13 (int n) {  goto a; { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; a:0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc14 (int n) {  goto a; { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; a:; typedef int (*j)[n]; 0; }
void fc15 (int n) {  goto a; { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; a:0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc16 (int n) { a: goto a; { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc17 (int n) { a:{ typedef int (*b)[n];  goto a; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc18 (int n) { { typedef int (*b)[n];  goto a; a:{ typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc19 (int n) { { typedef int (*b)[n];  goto a; { typedef int (*c)[n]; a:0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc20 (int n) { { typedef int (*b)[n];  goto a; { typedef int (*c)[n]; 0;} a:{ typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc21 (int n) { { typedef int (*b)[n];  goto a; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; a:0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc22 (int n) { { typedef int (*b)[n];  goto a; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} a:; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc23 (int n) { { typedef int (*b)[n];  goto a; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; a:0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc24 (int n) { { typedef int (*b)[n];  goto a; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; a:{ typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc25 (int n) { { typedef int (*b)[n];  goto a; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; a:{ typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc26 (int n) { { typedef int (*b)[n];  goto a; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; a:0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc27 (int n) { { typedef int (*b)[n];  goto a; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; a:{ typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc28 (int n) { { typedef int (*b)[n];  goto a; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; a:0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc29 (int n) { { typedef int (*b)[n];  goto a; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; a:; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc30 (int n) { { typedef int (*b)[n];  goto a; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; a:0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc31 (int n) { { typedef int (*b)[n];  goto a; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; a:; typedef int (*j)[n]; 0; }
void fc32 (int n) { { typedef int (*b)[n];  goto a; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; a:0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc33 (int n) { { typedef int (*b)[n]; a: goto a; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc34 (int n) { a:{ typedef int (*b)[n]; { typedef int (*c)[n];  goto a; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc35 (int n) { { typedef int (*b)[n]; a:{ typedef int (*c)[n];  goto a; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc36 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n];  goto a; a:0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc37 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n];  goto a; 0;} a:{ typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc38 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n];  goto a; 0;} { typedef int (*d)[n]; a:0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc39 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n];  goto a; 0;} { typedef int (*d)[n]; 0;} a:; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc40 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n];  goto a; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; a:0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc41 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n];  goto a; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; a:{ typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc42 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n];  goto a; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; a:{ typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc43 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n];  goto a; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; a:0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc44 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n];  goto a; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; a:{ typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc45 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n];  goto a; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; a:0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc46 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n];  goto a; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; a:; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc47 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n];  goto a; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; a:0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc48 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n];  goto a; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; a:; typedef int (*j)[n]; 0; }
void fc49 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n];  goto a; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; a:0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc50 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; a: goto a; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc51 (int n) { a:{ typedef int (*b)[n]; { typedef int (*c)[n]; 0;}  goto a; { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc52 (int n) { { typedef int (*b)[n]; a:{ typedef int (*c)[n]; 0;}  goto a; { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc53 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; a:0;}  goto a; { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc54 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;}  goto a; a:{ typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc55 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;}  goto a; { typedef int (*d)[n]; a:0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc56 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;}  goto a; { typedef int (*d)[n]; 0;} a:; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc57 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;}  goto a; { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; a:0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc58 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;}  goto a; { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; a:{ typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc59 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;}  goto a; { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; a:{ typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc60 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;}  goto a; { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; a:0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc61 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;}  goto a; { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; a:{ typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc62 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;}  goto a; { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; a:0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc63 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;}  goto a; { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; a:; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc64 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;}  goto a; { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; a:0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc65 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;}  goto a; { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; a:; typedef int (*j)[n]; 0; }
void fc66 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;}  goto a; { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; a:0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc67 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} a: goto a; { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc68 (int n) { a:{ typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n];  goto a; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc69 (int n) { { typedef int (*b)[n]; a:{ typedef int (*c)[n]; 0;} { typedef int (*d)[n];  goto a; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc70 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; a:0;} { typedef int (*d)[n];  goto a; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc71 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} a:{ typedef int (*d)[n];  goto a; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc72 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n];  goto a; a:0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc73 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n];  goto a; 0;} a:; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc74 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n];  goto a; 0;} ; typedef int (*e)[n]; a:0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc75 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n];  goto a; 0;} ; typedef int (*e)[n]; 0;}; a:{ typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc76 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n];  goto a; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; a:{ typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc77 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n];  goto a; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; a:0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc78 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n];  goto a; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; a:{ typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc79 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n];  goto a; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; a:0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc80 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n];  goto a; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; a:; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc81 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n];  goto a; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; a:0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc82 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n];  goto a; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; a:; typedef int (*j)[n]; 0; }
void fc83 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n];  goto a; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; a:0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc84 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; a: goto a; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc85 (int n) { a:{ typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;}  goto a; ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc86 (int n) { { typedef int (*b)[n]; a:{ typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;}  goto a; ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc87 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; a:0;} { typedef int (*d)[n]; 0;}  goto a; ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc88 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} a:{ typedef int (*d)[n]; 0;}  goto a; ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc89 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; a:0;}  goto a; ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc90 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;}  goto a; a:; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc91 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;}  goto a; ; typedef int (*e)[n]; a:0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc92 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;}  goto a; ; typedef int (*e)[n]; 0;}; a:{ typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc93 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;}  goto a; ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; a:{ typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc94 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;}  goto a; ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; a:0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc95 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;}  goto a; ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; a:{ typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc96 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;}  goto a; ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; a:0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc97 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;}  goto a; ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; a:; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc98 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;}  goto a; ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; a:0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc99 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;}  goto a; ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; a:; typedef int (*j)[n]; 0; }
void fc100 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;}  goto a; ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; a:0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc101 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} a: goto a; ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc102 (int n) { a:{ typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n];  goto a; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc103 (int n) { { typedef int (*b)[n]; a:{ typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n];  goto a; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc104 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; a:0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n];  goto a; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc105 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} a:{ typedef int (*d)[n]; 0;} ; typedef int (*e)[n];  goto a; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc106 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; a:0;} ; typedef int (*e)[n];  goto a; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc107 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} a:; typedef int (*e)[n];  goto a; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc108 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n];  goto a; a:0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc109 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n];  goto a; 0;}; a:{ typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc110 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n];  goto a; 0;}; { typedef int (*f)[n]; a:{ typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc111 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n];  goto a; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; a:0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc112 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n];  goto a; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; a:{ typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc113 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n];  goto a; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; a:0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc114 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n];  goto a; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; a:; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc115 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n];  goto a; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; a:0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc116 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n];  goto a; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; a:; typedef int (*j)[n]; 0; }
void fc117 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n];  goto a; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; a:0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc118 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; a: goto a; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc119 (int n) { a:{ typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;};  goto a; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc120 (int n) { { typedef int (*b)[n]; a:{ typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;};  goto a; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc121 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; a:0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;};  goto a; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc122 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} a:{ typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;};  goto a; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc123 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; a:0;} ; typedef int (*e)[n]; 0;};  goto a; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc124 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} a:; typedef int (*e)[n]; 0;};  goto a; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc125 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; a:0;};  goto a; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc126 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;};  goto a; a:{ typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc127 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;};  goto a; { typedef int (*f)[n]; a:{ typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc128 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;};  goto a; { typedef int (*f)[n]; { typedef int (*g)[n]; a:0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc129 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;};  goto a; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; a:{ typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc130 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;};  goto a; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; a:0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc131 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;};  goto a; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; a:; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc132 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;};  goto a; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; a:0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc133 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;};  goto a; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; a:; typedef int (*j)[n]; 0; }
void fc134 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;};  goto a; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; a:0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc135 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; a: goto a; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc136 (int n) { a:{ typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n];  goto a; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc137 (int n) { { typedef int (*b)[n]; a:{ typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n];  goto a; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc138 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; a:0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n];  goto a; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc139 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} a:{ typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n];  goto a; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc140 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; a:0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n];  goto a; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc141 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} a:; typedef int (*e)[n]; 0;}; { typedef int (*f)[n];  goto a; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc142 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; a:0;}; { typedef int (*f)[n];  goto a; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc143 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; a:{ typedef int (*f)[n];  goto a; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc144 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n];  goto a; a:{ typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc145 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n];  goto a; { typedef int (*g)[n]; a:0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc146 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n];  goto a; { typedef int (*g)[n]; 0;}; a:{ typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc147 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n];  goto a; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; a:0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc148 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n];  goto a; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; a:; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc149 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n];  goto a; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; a:0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc150 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n];  goto a; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; a:; typedef int (*j)[n]; 0; }
void fc151 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n];  goto a; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; a:0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc152 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; a: goto a; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc153 (int n) { a:{ typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n];  goto a; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc154 (int n) { { typedef int (*b)[n]; a:{ typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n];  goto a; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc155 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; a:0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n];  goto a; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc156 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} a:{ typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n];  goto a; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc157 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; a:0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n];  goto a; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc158 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} a:; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n];  goto a; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc159 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; a:0;}; { typedef int (*f)[n]; { typedef int (*g)[n];  goto a; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc160 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; a:{ typedef int (*f)[n]; { typedef int (*g)[n];  goto a; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc161 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; a:{ typedef int (*g)[n];  goto a; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc162 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n];  goto a; a:0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc163 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n];  goto a; 0;}; a:{ typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc164 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n];  goto a; 0;}; { typedef int (*h)[n]; a:0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc165 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n];  goto a; 0;}; { typedef int (*h)[n]; 0;}; a:; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc166 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n];  goto a; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; a:0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc167 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n];  goto a; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; a:; typedef int (*j)[n]; 0; }
void fc168 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n];  goto a; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; a:0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc169 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; a: goto a; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc170 (int n) { a:{ typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;};  goto a; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc171 (int n) { { typedef int (*b)[n]; a:{ typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;};  goto a; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc172 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; a:0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;};  goto a; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc173 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} a:{ typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;};  goto a; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc174 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; a:0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;};  goto a; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc175 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} a:; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;};  goto a; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc176 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; a:0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;};  goto a; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc177 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; a:{ typedef int (*f)[n]; { typedef int (*g)[n]; 0;};  goto a; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc178 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; a:{ typedef int (*g)[n]; 0;};  goto a; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc179 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; a:0;};  goto a; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc180 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;};  goto a; a:{ typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc181 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;};  goto a; { typedef int (*h)[n]; a:0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc182 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;};  goto a; { typedef int (*h)[n]; 0;}; a:; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc183 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;};  goto a; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; a:0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc184 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;};  goto a; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; a:; typedef int (*j)[n]; 0; }
void fc185 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;};  goto a; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; a:0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc186 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; a: goto a; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc187 (int n) { a:{ typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n];  goto a; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc188 (int n) { { typedef int (*b)[n]; a:{ typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n];  goto a; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc189 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; a:0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n];  goto a; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc190 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} a:{ typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n];  goto a; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc191 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; a:0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n];  goto a; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc192 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} a:; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n];  goto a; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc193 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; a:0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n];  goto a; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc194 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; a:{ typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n];  goto a; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc195 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; a:{ typedef int (*g)[n]; 0;}; { typedef int (*h)[n];  goto a; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc196 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; a:0;}; { typedef int (*h)[n];  goto a; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc197 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; a:{ typedef int (*h)[n];  goto a; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc198 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n];  goto a; a:0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc199 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n];  goto a; 0;}; a:; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc200 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n];  goto a; 0;}; ; typedef int (*i)[n]; a:0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc201 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n];  goto a; 0;}; ; typedef int (*i)[n]; 0;}; a:; typedef int (*j)[n]; 0; }
void fc202 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n];  goto a; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; a:0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc203 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; a: goto a; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc204 (int n) { a:{ typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;};  goto a; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc205 (int n) { { typedef int (*b)[n]; a:{ typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;};  goto a; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc206 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; a:0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;};  goto a; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc207 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} a:{ typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;};  goto a; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc208 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; a:0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;};  goto a; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc209 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} a:; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;};  goto a; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc210 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; a:0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;};  goto a; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc211 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; a:{ typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;};  goto a; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc212 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; a:{ typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;};  goto a; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc213 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; a:0;}; { typedef int (*h)[n]; 0;};  goto a; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc214 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; a:{ typedef int (*h)[n]; 0;};  goto a; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc215 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; a:0;};  goto a; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc216 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;};  goto a; a:; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc217 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;};  goto a; ; typedef int (*i)[n]; a:0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc218 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;};  goto a; ; typedef int (*i)[n]; 0;}; a:; typedef int (*j)[n]; 0; }
void fc219 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;};  goto a; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; a:0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc220 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; a: goto a; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; }
void fc221 (int n) { a:{ typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n];  goto a; 0;}; ; typedef int (*j)[n]; 0; }
void fc222 (int n) { { typedef int (*b)[n]; a:{ typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n];  goto a; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc223 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; a:0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n];  goto a; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc224 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} a:{ typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n];  goto a; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc225 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; a:0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n];  goto a; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc226 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} a:; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n];  goto a; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc227 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; a:0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n];  goto a; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc228 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; a:{ typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n];  goto a; 0;}; ; typedef int (*j)[n]; 0; }
void fc229 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; a:{ typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n];  goto a; 0;}; ; typedef int (*j)[n]; 0; }
void fc230 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; a:0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n];  goto a; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc231 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; a:{ typedef int (*h)[n]; 0;}; ; typedef int (*i)[n];  goto a; 0;}; ; typedef int (*j)[n]; 0; }
void fc232 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; a:0;}; ; typedef int (*i)[n];  goto a; 0;}; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc233 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; a:; typedef int (*i)[n];  goto a; 0;}; ; typedef int (*j)[n]; 0; }
void fc234 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n];  goto a; a:0;}; ; typedef int (*j)[n]; 0; }
void fc235 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n];  goto a; 0;}; a:; typedef int (*j)[n]; 0; }
void fc236 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n];  goto a; 0;}; ; typedef int (*j)[n]; a:0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc237 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; a: goto a; 0;}; ; typedef int (*j)[n]; 0; }
void fc238 (int n) { a:{ typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;};  goto a; ; typedef int (*j)[n]; 0; }
void fc239 (int n) { { typedef int (*b)[n]; a:{ typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;};  goto a; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc240 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; a:0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;};  goto a; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc241 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} a:{ typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;};  goto a; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc242 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; a:0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;};  goto a; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc243 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} a:; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;};  goto a; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc244 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; a:0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;};  goto a; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc245 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; a:{ typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;};  goto a; ; typedef int (*j)[n]; 0; }
void fc246 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; a:{ typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;};  goto a; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc247 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; a:0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;};  goto a; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc248 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; a:{ typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;};  goto a; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc249 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; a:0;}; ; typedef int (*i)[n]; 0;};  goto a; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc250 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; a:; typedef int (*i)[n]; 0;};  goto a; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc251 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; a:0;};  goto a; ; typedef int (*j)[n]; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc252 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;};  goto a; a:; typedef int (*j)[n]; 0; }
void fc253 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;};  goto a; ; typedef int (*j)[n]; a:0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc254 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; a: goto a; ; typedef int (*j)[n]; 0; }
void fc255 (int n) { a:{ typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n];  goto a; 0; }
void fc256 (int n) { { typedef int (*b)[n]; a:{ typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n];  goto a; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc257 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; a:0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n];  goto a; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc258 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} a:{ typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n];  goto a; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc259 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; a:0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n];  goto a; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc260 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} a:; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n];  goto a; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc261 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; a:0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n];  goto a; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc262 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; a:{ typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n];  goto a; 0; }
void fc263 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; a:{ typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n];  goto a; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc264 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; a:0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n];  goto a; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc265 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; a:{ typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n];  goto a; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc266 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; a:0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n];  goto a; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc267 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; a:; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n];  goto a; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc268 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; a:0;}; ; typedef int (*j)[n];  goto a; 0; } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc269 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; a:; typedef int (*j)[n];  goto a; 0; }
void fc270 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n];  goto a; a:0; }
void fc271 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; a: goto a; 0; }
void fc272 (int n) { a:{ typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; goto a;  }
void fc273 (int n) { { typedef int (*b)[n]; a:{ typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; goto a;  } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc274 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; a:0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; goto a;  } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc275 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} a:{ typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; goto a;  } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc276 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; a:0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; goto a;  } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc277 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} a:; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; goto a;  } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc278 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; a:0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; goto a;  } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc279 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; a:{ typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; goto a;  }
void fc280 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; a:{ typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; goto a;  } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc281 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; a:0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; goto a;  } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc282 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; a:{ typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; goto a;  } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc283 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; a:0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; goto a;  } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc284 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; a:; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0; goto a;  } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc285 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; a:0;}; ; typedef int (*j)[n]; 0; goto a;  } /* { dg-error "error: jump into scope of identifier with variably modified type" } */
void fc286 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; a:; typedef int (*j)[n]; 0; goto a;  }
void fc287 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; a:0; goto a;  }
void fc288 (int n) { { typedef int (*b)[n]; { typedef int (*c)[n]; 0;} { typedef int (*d)[n]; 0;} ; typedef int (*e)[n]; 0;}; { typedef int (*f)[n]; { typedef int (*g)[n]; 0;}; { typedef int (*h)[n]; 0;}; ; typedef int (*i)[n]; 0;}; ; typedef int (*j)[n]; 0;a: goto a;  }
