/*
 *  DO NOT EDIT THIS FILE - it has been generated
 *
 * Install modified versions of certain ANSI-incompatible system header
 * files which are fixed to work correctly with ANSI C and placed in a
 * directory that GNU C will search.
 *
 * This file contains 103 fixup descriptions.
 *
 * See README-fixinc for more information.
 *
 *  inclhack copyright (c) 1999 The Free Software Foundation, Inc.
 *
 *  inclhack is free software.
 *  
 *  You may redistribute it and/or modify it under the terms of the
 *  GNU General Public License, as published by the Free Software
 *  Foundation; either version 2, or (at your option) any later version.
 *  
 *  inclhack is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with inclhack.  See the file "COPYING".  If not,
 *  write to:  The Free Software Foundation, Inc.,
 *             59 Temple Place - Suite 330,
 *             Boston,  MA  02111-1307, USA.
 *
 *
 *  Description   1 - Aix_Syswait fix
 */
tSCC zAix_SyswaitName[] =
     "Aix_Syswait";
/*
 *  File name selection pattern
 */
tSCC zAix_SyswaitList[] =
  "|sys/wait.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzAix_SyswaitMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zAix_SyswaitSelect0[] =
       "bos325,";

#define    AIX_SYSWAIT_TEST_CT  1
#define    AIX_SYSWAIT_RE_CT    1
tTestDesc aAix_SyswaitTests[] = {
  { TT_EGREP,  zAix_SyswaitSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Aix_Syswait
 */
const char* apzAix_SyswaitPatch[] = { "sed",
    "-e", "/^extern pid_t wait3();$/i\\\n\
struct rusage;\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description   2 - Aix_Volatile fix
 */
tSCC zAix_VolatileName[] =
     "Aix_Volatile";
/*
 *  File name selection pattern
 */
tSCC zAix_VolatileList[] =
  "|sys/signal.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzAix_VolatileMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zAix_VolatileSelect0[] =
       "typedef volatile int sig_atomic_t";

#define    AIX_VOLATILE_TEST_CT  1
#define    AIX_VOLATILE_RE_CT    1
tTestDesc aAix_VolatileTests[] = {
  { TT_EGREP,  zAix_VolatileSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Aix_Volatile
 */
const char* apzAix_VolatilePatch[] = { "sed",
    "-e", "s/typedef volatile int sig_atomic_t/typedef int sig_atomic_t/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description   3 - Alpha_Getopt fix
 */
tSCC zAlpha_GetoptName[] =
     "Alpha_Getopt";
/*
 *  File name selection pattern
 */
tSCC zAlpha_GetoptList[] =
  "|stdio.h|stdlib.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzAlpha_GetoptMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zAlpha_GetoptSelect0[] =
       "getopt\\(int, char \\*\\[";

#define    ALPHA_GETOPT_TEST_CT  1
#define    ALPHA_GETOPT_RE_CT    1
tTestDesc aAlpha_GetoptTests[] = {
  { TT_EGREP,  zAlpha_GetoptSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Alpha_Getopt
 */
const char* apzAlpha_GetoptPatch[] = { "sed",
    "-e", "s/getopt(int, char \\*\\[\\],[ ]*char \\*)/getopt(int, char *const[], const char *)/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description   4 - Alpha_Parens fix
 */
tSCC zAlpha_ParensName[] =
     "Alpha_Parens";
/*
 *  File name selection pattern
 */
tSCC zAlpha_ParensList[] =
  "|sym.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzAlpha_ParensMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zAlpha_ParensSelect0[] =
       "#ifndef\\(__mips64\\)";

#define    ALPHA_PARENS_TEST_CT  1
#define    ALPHA_PARENS_RE_CT    1
tTestDesc aAlpha_ParensTests[] = {
  { TT_EGREP,  zAlpha_ParensSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Alpha_Parens
 */
const char* apzAlpha_ParensPatch[] = { "sed",
    "-e", "s/#ifndef(__mips64)/#ifndef __mips64/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description   5 - Alpha_Sbrk fix
 */
tSCC zAlpha_SbrkName[] =
     "Alpha_Sbrk";
/*
 *  File name selection pattern
 */
tSCC zAlpha_SbrkList[] =
  "|unistd.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzAlpha_SbrkMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zAlpha_SbrkSelect0[] =
       "char[ \t]*\\*[\t ]*sbrk[ \t]*\\(";

#define    ALPHA_SBRK_TEST_CT  1
#define    ALPHA_SBRK_RE_CT    1
tTestDesc aAlpha_SbrkTests[] = {
  { TT_EGREP,  zAlpha_SbrkSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Alpha_Sbrk
 */
const char* apzAlpha_SbrkPatch[] = { "sed",
    "-e", "s/char\\([ \t]*\\*[\t ]*sbrk[ \t]*(\\)/void\\1/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description   6 - Arm_Norcroft_Hint fix
 */
tSCC zArm_Norcroft_HintName[] =
     "Arm_Norcroft_Hint";
/*
 *  File name selection pattern
 */
tSCC zArm_Norcroft_HintList[] =
  "|X11/Intrinsic.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzArm_Norcroft_HintMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zArm_Norcroft_HintSelect0[] =
       "___type p_type";

#define    ARM_NORCROFT_HINT_TEST_CT  1
#define    ARM_NORCROFT_HINT_RE_CT    1
tTestDesc aArm_Norcroft_HintTests[] = {
  { TT_EGREP,  zArm_Norcroft_HintSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Arm_Norcroft_Hint
 */
const char* apzArm_Norcroft_HintPatch[] = { "sed",
    "-e", "s/___type p_type/p_type/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description   7 - Arm_Wchar fix
 */
tSCC zArm_WcharName[] =
     "Arm_Wchar";
/*
 *  File name selection pattern
 */
tSCC zArm_WcharList[] =
  "|stdlib.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzArm_WcharMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zArm_WcharSelect0[] =
       "#[ \t]*define[ \t]*__wchar_t";

#define    ARM_WCHAR_TEST_CT  1
#define    ARM_WCHAR_RE_CT    1
tTestDesc aArm_WcharTests[] = {
  { TT_EGREP,  zArm_WcharSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Arm_Wchar
 */
const char* apzArm_WcharPatch[] = { "sed",
    "-e", "s/\\(#[ \t]*ifndef[ \t]*\\)__wchar_t/\\1_GCC_WCHAR_T/",
    "-e", "s/\\(#[ \t]*define[ \t]*\\)__wchar_t/\\1_GCC_WCHAR_T/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description   8 - Aux_Asm fix
 */
tSCC zAux_AsmName[] =
     "Aux_Asm";
/*
 *  File name selection pattern
 */
tSCC zAux_AsmList[] =
  "|sys/param.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzAux_AsmMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zAux_AsmSelect0[] =
       "#ifndef NOINLINE";

#define    AUX_ASM_TEST_CT  1
#define    AUX_ASM_RE_CT    1
tTestDesc aAux_AsmTests[] = {
  { TT_EGREP,  zAux_AsmSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Aux_Asm
 */
const char* apzAux_AsmPatch[] = { "sed",
    "-e", "s|#ifndef NOINLINE|#if !defined(NOINLINE) \\&\\& !defined(__GNUC__)|",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description   9 - Avoid_Bool fix
 */
tSCC zAvoid_BoolName[] =
     "Avoid_Bool";
/*
 *  File name selection pattern
 */
tSCC zAvoid_BoolList[] =
  "|curses.h|curses_colr/curses.h|term.h|tinfo.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzAvoid_BoolMachs (const char**)NULL
#define AVOID_BOOL_TEST_CT  0
#define AVOID_BOOL_RE_CT    0
#define aAvoid_BoolTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Avoid_Bool
 */
const char* apzAvoid_BoolPatch[] = { "sed",
    "-e", "/^#[ \t]*define[ \t][ \t]*bool[ \t][ \t]*char[ \t]*$/i\\\n\
#ifndef __cplusplus\n",
    "-e", "/^#[ \t]*define[ \t][ \t]*bool[ \t][ \t]*char[ \t]*$/a\\\n\
#endif\n",
    "-e", "/^typedef[ \t][ \t]*char[ \t][ \t]*bool[ \t]*;/i\\\n\
#ifndef __cplusplus\n",
    "-e", "/^typedef[ \t][ \t]*char[ \t][ \t]*bool[ \t]*;/a\\\n\
#endif\n",
    "-e", "/^[ ]*typedef[ \t][ \t]*unsigned char[ \t][ \t]*bool[ \t]*;/i\\\n\
#ifndef __cplusplus\n",
    "-e", "/^[ ]*typedef[ \t][ \t]*unsigned char[ \t][ \t]*bool[ \t]*;/a\\\n\
#endif\n",
    "-e", "/^typedef[ \t][ \t]*int[ \t][ \t]*bool[ \t]*;/i\\\n\
#ifndef __cplusplus\n",
    "-e", "/^typedef[ \t][ \t]*int[ \t][ \t]*bool[ \t]*;/a\\\n\
#endif\n",
    "-e", "/^[ ]*typedef[ \t][ \t]*unsigned int[ \t][ \t]*bool[ \t]*;/i\\\n\
#ifndef __cplusplus\n",
    "-e", "/^[ ]*typedef[ \t][ \t]*unsigned int[ \t][ \t]*bool[ \t]*;/a\\\n\
#endif\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  10 - Bad_Struct_Term fix
 */
tSCC zBad_Struct_TermName[] =
     "Bad_Struct_Term";
/*
 *  File name selection pattern
 */
tSCC zBad_Struct_TermList[] =
  "|curses.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzBad_Struct_TermMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zBad_Struct_TermSelect0[] =
       "^[ \t]*typedef[ \t]+struct[ \t]+term[ \t]*;";

#define    BAD_STRUCT_TERM_TEST_CT  1
#define    BAD_STRUCT_TERM_RE_CT    1
tTestDesc aBad_Struct_TermTests[] = {
  { TT_EGREP,  zBad_Struct_TermSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Bad_Struct_Term
 */
const char* apzBad_Struct_TermPatch[] = { "sed",
    "-e", "s/^[ \t]*typedef[ \t][ \t]*\\(struct[ \t][ \t]*term[ \t]*;[ \t]*\\)$/\\1/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  11 - Badquote fix
 */
tSCC zBadquoteName[] =
     "Badquote";
/*
 *  File name selection pattern
 */
tSCC zBadquoteList[] =
  "|sundev/vuid_event.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzBadquoteMachs (const char**)NULL
#define BADQUOTE_TEST_CT  0
#define BADQUOTE_RE_CT    0
#define aBadquoteTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Badquote
 */
const char* apzBadquotePatch[] = { "sed",
    "-e", "s/doesn't/does not/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  12 - Bad_Lval fix
 */
tSCC zBad_LvalName[] =
     "Bad_Lval";
/*
 *  File name selection pattern
 */
tSCC zBad_LvalList[] =
  "|libgen.h|dirent.h|ftw.h|grp.h|ndbm.h|pthread.h|pwd.h|signal.h|standards.h|stdlib.h|string.h|stropts.h|time.h|unistd.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzBad_LvalMachs (const char**)NULL
#define BAD_LVAL_TEST_CT  0
#define BAD_LVAL_RE_CT    0
#define aBad_LvalTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Bad_Lval
 */
const char* apzBad_LvalPatch[] = { "sed",
    "-e", "s/^[ \t]*#[ \t]*define[ \t]*\\([^(]*\\)\\(([^)]*)\\)[ \t]*\\(_.\\)\\1\\2[ \t]*$/#define \\1 \\3\\1/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  13 - Broken_Assert_Stdio fix
 */
tSCC zBroken_Assert_StdioName[] =
     "Broken_Assert_Stdio";
/*
 *  File name selection pattern
 */
tSCC zBroken_Assert_StdioList[] =
  "|assert.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzBroken_Assert_StdioMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zBroken_Assert_StdioSelect0[] =
       "stderr";

/*
 *  content bypass pattern - skip fix if pattern found
 */
tSCC zBroken_Assert_StdioBypass0[] =
       "include.*stdio.h";

#define    BROKEN_ASSERT_STDIO_TEST_CT  2
#define    BROKEN_ASSERT_STDIO_RE_CT    2
tTestDesc aBroken_Assert_StdioTests[] = {
  { TT_NEGREP, zBroken_Assert_StdioBypass0,   (regex_t*)NULL },
  { TT_EGREP,  zBroken_Assert_StdioSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Broken_Assert_Stdio
 */
const char* apzBroken_Assert_StdioPatch[] = { "sed",
    "-e", "1i\\\n\
#include <stdio.h>\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  14 - Broken_Assert_Stdlib fix
 */
tSCC zBroken_Assert_StdlibName[] =
     "Broken_Assert_Stdlib";
/*
 *  File name selection pattern
 */
tSCC zBroken_Assert_StdlibList[] =
  "|assert.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzBroken_Assert_StdlibMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zBroken_Assert_StdlibSelect0[] =
       "exit *\\(|abort *\\(";

/*
 *  content bypass pattern - skip fix if pattern found
 */
tSCC zBroken_Assert_StdlibBypass0[] =
       "include.*stdlib.h";

#define    BROKEN_ASSERT_STDLIB_TEST_CT  2
#define    BROKEN_ASSERT_STDLIB_RE_CT    2
tTestDesc aBroken_Assert_StdlibTests[] = {
  { TT_NEGREP, zBroken_Assert_StdlibBypass0,   (regex_t*)NULL },
  { TT_EGREP,  zBroken_Assert_StdlibSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Broken_Assert_Stdlib
 */
const char* apzBroken_Assert_StdlibPatch[] = { "sed",
    "-e", "1i\\\n\
#ifdef __cplusplus\\\n\
#include <stdlib.h>\\\n\
#endif\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  15 - Bsd43_Io_Macros fix
 */
tSCC zBsd43_Io_MacrosName[] =
     "Bsd43_Io_Macros";
/*
 *  File name selection pattern
 */
#define zBsd43_Io_MacrosList (char*)NULL
/*
 *  Machine/OS name selection pattern
 */
#define apzBsd43_Io_MacrosMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zBsd43_Io_MacrosSelect0[] =
       "BSD43__IO";

#define    BSD43_IO_MACROS_TEST_CT  1
#define    BSD43_IO_MACROS_RE_CT    1
tTestDesc aBsd43_Io_MacrosTests[] = {
  { TT_EGREP,  zBsd43_Io_MacrosSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Bsd43_Io_Macros
 */
const char* apzBsd43_Io_MacrosPatch[] = { "sed",
    "-e", "/[ \t]BSD43__IO[A-Z]*[ \t]*(/s/(\\(.\\),/('\\1',/",
    "-e", "/#[ \t]*define[ \t]*[ \t]BSD43__IO/s/'\\([cgx]\\)'/\\1/g",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  16 - Dec_Intern_Asm fix
 */
tSCC zDec_Intern_AsmName[] =
     "Dec_Intern_Asm";
/*
 *  File name selection pattern
 */
tSCC zDec_Intern_AsmList[] =
  "|c_asm.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzDec_Intern_AsmMachs (const char**)NULL
#define DEC_INTERN_ASM_TEST_CT  0
#define DEC_INTERN_ASM_RE_CT    0
#define aDec_Intern_AsmTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Dec_Intern_Asm
 */
const char* apzDec_Intern_AsmPatch[] = { "sed",
    "-e", "/^[ \t]*float[ \t]*fasm/i\\\n\
#ifdef __DECC\n",
    "-e", "/^[ \t]*#[ \t]*pragma[ \t]*intrinsic([ \t]*dasm/a\\\n\
#endif\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  17 - No_Double_Slash fix
 */
tSCC zNo_Double_SlashName[] =
     "No_Double_Slash";
/*
 *  File name selection pattern
 */
#define zNo_Double_SlashList (char*)NULL
/*
 *  Machine/OS name selection pattern
 */
#define apzNo_Double_SlashMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zNo_Double_SlashSelect0[] =
       "(^|[^:])//[^\"*]";

/*
 *  perform the 'test' shell command - do fix on success
 */
tSCC zNo_Double_SlashTest0[] =
       " -z \"`echo ${file} | egrep '(CC|cxx|\\+\\+)/'`\"";

#define    NO_DOUBLE_SLASH_TEST_CT  2
#define    NO_DOUBLE_SLASH_RE_CT    1
tTestDesc aNo_Double_SlashTests[] = {
  { TT_TEST,   zNo_Double_SlashTest0,     0 /* unused */ },
  { TT_EGREP,  zNo_Double_SlashSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for No_Double_Slash
 */
const char* apzNo_Double_SlashPatch[] = { "sed",
    "-e", "s,^//.*$,,",
    "-e", "s,[^:]//[^\"].*$,,",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  18 - Ecd_Cursor fix
 */
tSCC zEcd_CursorName[] =
     "Ecd_Cursor";
/*
 *  File name selection pattern
 */
tSCC zEcd_CursorList[] =
  "|sunwindow/win_lock.h|sunwindow/win_cursor.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzEcd_CursorMachs (const char**)NULL
#define ECD_CURSOR_TEST_CT  0
#define ECD_CURSOR_RE_CT    0
#define aEcd_CursorTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Ecd_Cursor
 */
const char* apzEcd_CursorPatch[] = { "sed",
    "-e", "s/ecd.cursor/ecd_cursor/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  19 - Sco5_Stat_Wrappers fix
 */
tSCC zSco5_Stat_WrappersName[] =
     "Sco5_Stat_Wrappers";
/*
 *  File name selection pattern
 */
tSCC zSco5_Stat_WrappersList[] =
  "|sys/stat.h|";
/*
 *  Machine/OS name selection pattern
 */
tSCC* apzSco5_Stat_WrappersMachs[] = {
        "i*86-*-sco3.2v5*",
        (const char*)NULL };
#define SCO5_STAT_WRAPPERS_TEST_CT  0
#define SCO5_STAT_WRAPPERS_RE_CT    0
#define aSco5_Stat_WrappersTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Sco5_Stat_Wrappers
 */
const char* apzSco5_Stat_WrappersPatch[] = { "sed",
    "-e", "/^static int[ \t]*[a-z]*stat(/i\\\n\
#ifdef __cplusplus\\\n\
extern \"C\"\\\n\
{\\\n\
#endif\\\n",
    "-e", "/^}$/a\\\n\
#ifdef __cplusplus\\\n\
}\\\n\
#endif /* __cplusplus */\\\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  20 - End_Else_Label fix
 */
tSCC zEnd_Else_LabelName[] =
     "End_Else_Label";
/*
 *  File name selection pattern
 */
#define zEnd_Else_LabelList (char*)NULL
/*
 *  Machine/OS name selection pattern
 */
#define apzEnd_Else_LabelMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zEnd_Else_LabelSelect0[] =
       "^[ \t]*#[ \t]*(else|endif)[ \t]+([!-.0-z\\{\\|\\}\\~]|/[^\\*])";

#define    END_ELSE_LABEL_TEST_CT  1
#define    END_ELSE_LABEL_RE_CT    1
tTestDesc aEnd_Else_LabelTests[] = {
  { TT_EGREP,  zEnd_Else_LabelSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for End_Else_Label
 */
const char* apzEnd_Else_LabelPatch[] = { "sed",
    "-e", ":loop\n\
/\\\\$/N\n\
s/\\\\$/\\\\+++fixinc_eol+++/\n\
/\\\\$/b loop\n\
s/\\\\+++fixinc_eol+++/\\\\/g\n\
s%^\\([ \t]*#[ \t]*else\\)[ \t][ \t]*/[^*].*%\\1%\n\
s%^\\([ \t]*#[ \t]*else\\)[ \t][ \t]*[^/ \t].*%\\1%\n\
s%^\\([ \t]*#[ \t]*endif\\)[ \t][ \t]*/[^*].*%\\1%\n\
s%^\\([ \t]*#[ \t]*endif\\)[ \t][ \t]**[^/].*%\\1%\n\
s%^\\([ \t]*#[ \t]*endif\\)[ \t][ \t]*[^/* \t].*%\\1%",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  21 - Hp_Inline fix
 */
tSCC zHp_InlineName[] =
     "Hp_Inline";
/*
 *  File name selection pattern
 */
tSCC zHp_InlineList[] =
  "|sys/spinlock.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzHp_InlineMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zHp_InlineSelect0[] =
       "include.*\"\\.\\./machine/";

#define    HP_INLINE_TEST_CT  1
#define    HP_INLINE_RE_CT    1
tTestDesc aHp_InlineTests[] = {
  { TT_EGREP,  zHp_InlineSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Hp_Inline
 */
const char* apzHp_InlinePatch[] = { "sed",
    "-e", "s,\"../machine/inline.h\",<machine/inline.h>,",
    "-e", "s,\"../machine/psl.h\",<machine/psl.h>,",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  22 - Hp_Sysfile fix
 */
tSCC zHp_SysfileName[] =
     "Hp_Sysfile";
/*
 *  File name selection pattern
 */
tSCC zHp_SysfileList[] =
  "|sys/file.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzHp_SysfileMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zHp_SysfileSelect0[] =
       "HPUX_SOURCE";

#define    HP_SYSFILE_TEST_CT  1
#define    HP_SYSFILE_RE_CT    1
tTestDesc aHp_SysfileTests[] = {
  { TT_EGREP,  zHp_SysfileSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Hp_Sysfile
 */
const char* apzHp_SysfilePatch[] = { "sed",
    "-e", "s/(\\.\\.\\.)/(struct file * ...)/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  23 - Cxx_Unready fix
 */
tSCC zCxx_UnreadyName[] =
     "Cxx_Unready";
/*
 *  File name selection pattern
 */
tSCC zCxx_UnreadyList[] =
  "|sys/mman.h|rpc/types.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzCxx_UnreadyMachs (const char**)NULL

/*
 *  content bypass pattern - skip fix if pattern found
 */
tSCC zCxx_UnreadyBypass0[] =
       "\"C\"|__BEGIN_DECLS";

#define    CXX_UNREADY_TEST_CT  1
#define    CXX_UNREADY_RE_CT    1
tTestDesc aCxx_UnreadyTests[] = {
  { TT_NEGREP, zCxx_UnreadyBypass0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Cxx_Unready
 */
const char* apzCxx_UnreadyPatch[] = { "sed",
    "-e", "1i\\\n\
#ifdef __cplusplus\\\n\
extern \"C\" {\\\n\
#endif\\\n\
\n",
    "-e", "$a\\\n\
#ifdef __cplusplus\\\n\
}\\\n\
#endif\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  24 - Hpux_Maxint fix
 */
tSCC zHpux_MaxintName[] =
     "Hpux_Maxint";
/*
 *  File name selection pattern
 */
tSCC zHpux_MaxintList[] =
  "|sys/param.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzHpux_MaxintMachs (const char**)NULL
#define HPUX_MAXINT_TEST_CT  0
#define HPUX_MAXINT_RE_CT    0
#define aHpux_MaxintTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Hpux_Maxint
 */
const char* apzHpux_MaxintPatch[] = { "sed",
    "-e", "/^#[ \t]*define[ \t]*MAXINT[ \t]/i\\\n\
#ifndef MAXINT\n",
    "-e", "/^#[ \t]*define[ \t]*MAXINT[ \t]/a\\\n\
#endif\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  25 - Hpux_Systime fix
 */
tSCC zHpux_SystimeName[] =
     "Hpux_Systime";
/*
 *  File name selection pattern
 */
tSCC zHpux_SystimeList[] =
  "|sys/time.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzHpux_SystimeMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zHpux_SystimeSelect0[] =
       "^extern struct sigevent;";

#define    HPUX_SYSTIME_TEST_CT  1
#define    HPUX_SYSTIME_RE_CT    1
tTestDesc aHpux_SystimeTests[] = {
  { TT_EGREP,  zHpux_SystimeSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Hpux_Systime
 */
const char* apzHpux_SystimePatch[] = { "sed",
    "-e", "s/^extern struct sigevent;/struct sigevent;/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  26 - Interactv_Add1 fix
 */
tSCC zInteractv_Add1Name[] =
     "Interactv_Add1";
/*
 *  File name selection pattern
 */
tSCC zInteractv_Add1List[] =
  "|stdio.h|math.h|ctype.h|sys/limits.h|sys/fcntl.h|sys/dirent.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzInteractv_Add1Machs (const char**)NULL

/*
 *  perform the 'test' shell command - do fix on success
 */
tSCC zInteractv_Add1Test0[] =
       " -d /etc/conf/kconfig.d";
tSCC zInteractv_Add1Test1[] =
       " -n \"`grep _POSIX_VERSION /usr/include/sys/unistd.h`\"";

#define    INTERACTV_ADD1_TEST_CT  2
#define    INTERACTV_ADD1_RE_CT    0
tTestDesc aInteractv_Add1Tests[] = {
  { TT_TEST,   zInteractv_Add1Test0,     0 /* unused */ },
  { TT_TEST,   zInteractv_Add1Test1,     0 /* unused */ }, };

/*
 *  Fix Command Arguments for Interactv_Add1
 */
const char* apzInteractv_Add1Patch[] = { "sed",
    "-e", "s/!defined(__STDC__) && !defined(_POSIX_SOURCE)/!defined(_POSIX_SOURCE)/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  27 - Interactv_Add2 fix
 */
tSCC zInteractv_Add2Name[] =
     "Interactv_Add2";
/*
 *  File name selection pattern
 */
tSCC zInteractv_Add2List[] =
  "|math.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzInteractv_Add2Machs (const char**)NULL

/*
 *  perform the 'test' shell command - do fix on success
 */
tSCC zInteractv_Add2Test0[] =
       " -d /etc/conf/kconfig.d";
tSCC zInteractv_Add2Test1[] =
       " -n \"`grep _POSIX_VERSION /usr/include/sys/unistd.h`\"";

#define    INTERACTV_ADD2_TEST_CT  2
#define    INTERACTV_ADD2_RE_CT    0
tTestDesc aInteractv_Add2Tests[] = {
  { TT_TEST,   zInteractv_Add2Test0,     0 /* unused */ },
  { TT_TEST,   zInteractv_Add2Test1,     0 /* unused */ }, };

/*
 *  Fix Command Arguments for Interactv_Add2
 */
const char* apzInteractv_Add2Patch[] = { "sed",
    "-e", "s/fmod(double)/fmod(double, double)/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  28 - Interactv_Add3 fix
 */
tSCC zInteractv_Add3Name[] =
     "Interactv_Add3";
/*
 *  File name selection pattern
 */
tSCC zInteractv_Add3List[] =
  "|sys/limits.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzInteractv_Add3Machs (const char**)NULL

/*
 *  perform the 'test' shell command - do fix on success
 */
tSCC zInteractv_Add3Test0[] =
       " -d /etc/conf/kconfig.d";
tSCC zInteractv_Add3Test1[] =
       " -n \"`grep _POSIX_VERSION /usr/include/sys/unistd.h`\"";

#define    INTERACTV_ADD3_TEST_CT  2
#define    INTERACTV_ADD3_RE_CT    0
tTestDesc aInteractv_Add3Tests[] = {
  { TT_TEST,   zInteractv_Add3Test0,     0 /* unused */ },
  { TT_TEST,   zInteractv_Add3Test1,     0 /* unused */ }, };

/*
 *  Fix Command Arguments for Interactv_Add3
 */
const char* apzInteractv_Add3Patch[] = { "sed",
    "-e", "/CHILD_MAX/s,/\\* Max, Max,",
    "-e", "/OPEN_MAX/s,/\\* Max, Max,",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  29 - Io_Def_Quotes fix
 */
tSCC zIo_Def_QuotesName[] =
     "Io_Def_Quotes";
/*
 *  File name selection pattern
 */
#define zIo_Def_QuotesList (char*)NULL
/*
 *  Machine/OS name selection pattern
 */
#define apzIo_Def_QuotesMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zIo_Def_QuotesSelect0[] =
       "[ \t]*[ \t](_|DES)IO[A-Z]*[ \t]*\\( *[^,']";

#define    IO_DEF_QUOTES_TEST_CT  1
#define    IO_DEF_QUOTES_RE_CT    1
tTestDesc aIo_Def_QuotesTests[] = {
  { TT_EGREP,  zIo_Def_QuotesSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Io_Def_Quotes
 */
const char* apzIo_Def_QuotesPatch[] = { "sed",
    "-e", "s/\\([ \t]*[ \t]_IO[A-Z]*[ \t]*(\\)\\([^,']\\),/\\1'\\2',/",
    "-e", "s/\\([ \t]*[ \t]DESIO[A-Z]*[ \t]*(\\)\\([^,']\\),/\\1'\\2',/",
    "-e", "/#[ \t]*define[ \t]*[ \t]_IO/s/'\\([cgxtf]\\)'/\\1/g",
    "-e", "/#[ \t]*define[ \t]*[ \t]DESIOC/s/'\\([cdgx]\\)'/\\1/g",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  30 - Ioctl_Fix_Ctrl fix
 */
tSCC zIoctl_Fix_CtrlName[] =
     "Ioctl_Fix_Ctrl";
/*
 *  File name selection pattern
 */
#define zIoctl_Fix_CtrlList (char*)NULL
/*
 *  Machine/OS name selection pattern
 */
#define apzIoctl_Fix_CtrlMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zIoctl_Fix_CtrlSelect0[] =
       "CTRL[ \t]*\\(";

#define    IOCTL_FIX_CTRL_TEST_CT  1
#define    IOCTL_FIX_CTRL_RE_CT    1
tTestDesc aIoctl_Fix_CtrlTests[] = {
  { TT_EGREP,  zIoctl_Fix_CtrlSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Ioctl_Fix_Ctrl
 */
const char* apzIoctl_Fix_CtrlPatch[] = { "sed",
    "-e", "/[^A-Z0-9_]CTRL[ \t]*(/s/\\([^']\\))/'\\1')/",
    "-e", "/[^A-Z0-9]_CTRL[ \t]*(/s/\\([^']\\))/'\\1')/",
    "-e", "/#[ \t]*define[ \t]*[ \t]CTRL/s/'\\([cgx]\\)'/\\1/g",
    "-e", "/#[ \t]*define[ \t]*[ \t]_CTRL/s/'\\([cgx]\\)'/\\1/g",
    "-e", "/#[ \t]*define[ \t]*[ \t]BSD43_CTRL/s/'\\([cgx]\\)'/\\1/g",
    "-e", "/#[ \t]*define[ \t]*[ \t]_*ISCTRL/s/'\\([cgx]\\)'/\\1/g",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  31 - Ip_Missing_Semi fix
 */
tSCC zIp_Missing_SemiName[] =
     "Ip_Missing_Semi";
/*
 *  File name selection pattern
 */
tSCC zIp_Missing_SemiList[] =
  "|netinet/ip.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzIp_Missing_SemiMachs (const char**)NULL
#define IP_MISSING_SEMI_TEST_CT  0
#define IP_MISSING_SEMI_RE_CT    0
#define aIp_Missing_SemiTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Ip_Missing_Semi
 */
const char* apzIp_Missing_SemiPatch[] = { "sed",
    "-e", "/^struct/,/^};/s/}$/};/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  32 - Irix_Multiline_Cmnt fix
 */
tSCC zIrix_Multiline_CmntName[] =
     "Irix_Multiline_Cmnt";
/*
 *  File name selection pattern
 */
tSCC zIrix_Multiline_CmntList[] =
  "|sys/types.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzIrix_Multiline_CmntMachs (const char**)NULL
#define IRIX_MULTILINE_CMNT_TEST_CT  0
#define IRIX_MULTILINE_CMNT_RE_CT    0
#define aIrix_Multiline_CmntTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Irix_Multiline_Cmnt
 */
const char* apzIrix_Multiline_CmntPatch[] = { "sed",
    "-e", "s@type of the result@type of the result */@",
    "-e", "s@of the sizeof@/* of the sizeof@",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  33 - Irix_Sockaddr fix
 */
tSCC zIrix_SockaddrName[] =
     "Irix_Sockaddr";
/*
 *  File name selection pattern
 */
tSCC zIrix_SockaddrList[] =
  "|rpc/auth.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzIrix_SockaddrMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zIrix_SockaddrSelect0[] =
       "authdes_create.*struct sockaddr";

#define    IRIX_SOCKADDR_TEST_CT  1
#define    IRIX_SOCKADDR_RE_CT    1
tTestDesc aIrix_SockaddrTests[] = {
  { TT_EGREP,  zIrix_SockaddrSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Irix_Sockaddr
 */
const char* apzIrix_SockaddrPatch[] = { "sed",
    "-e", "/authdes_create.*struct sockaddr/i\\\n\
struct sockaddr;\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  34 - Irix_Struct__File fix
 */
tSCC zIrix_Struct__FileName[] =
     "Irix_Struct__File";
/*
 *  File name selection pattern
 */
tSCC zIrix_Struct__FileList[] =
  "|rpc/xdr.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzIrix_Struct__FileMachs (const char**)NULL
#define IRIX_STRUCT__FILE_TEST_CT  0
#define IRIX_STRUCT__FILE_RE_CT    0
#define aIrix_Struct__FileTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Irix_Struct__File
 */
const char* apzIrix_Struct__FilePatch[] = { "sed",
    "-e", "/xdrstdio_create.*struct __file_s/i\\\n\
struct __file_s;\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  35 - Isc_Fmod fix
 */
tSCC zIsc_FmodName[] =
     "Isc_Fmod";
/*
 *  File name selection pattern
 */
tSCC zIsc_FmodList[] =
  "|math.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzIsc_FmodMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zIsc_FmodSelect0[] =
       "fmod\\(double\\)";

#define    ISC_FMOD_TEST_CT  1
#define    ISC_FMOD_RE_CT    1
tTestDesc aIsc_FmodTests[] = {
  { TT_EGREP,  zIsc_FmodSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Isc_Fmod
 */
const char* apzIsc_FmodPatch[] = { "sed",
    "-e", "s/fmod(double)/fmod(double, double)/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  36 - Motorola_Nested fix
 */
tSCC zMotorola_NestedName[] =
     "Motorola_Nested";
/*
 *  File name selection pattern
 */
tSCC zMotorola_NestedList[] =
  "|limits.h|sys/limits.h|";
/*
 *  Machine/OS name selection pattern
 */
tSCC* apzMotorola_NestedMachs[] = {
        "m68k-motorola-sysv*",
        (const char*)NULL };
#define MOTOROLA_NESTED_TEST_CT  0
#define MOTOROLA_NESTED_RE_CT    0
#define aMotorola_NestedTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Motorola_Nested
 */
const char* apzMotorola_NestedPatch[] = { "sed",
    "-e", "s@^\\(#undef[ \t][ \t]*PIPE_BUF[ \t]*/\\* max # bytes atomic in write to a\\)$@\\1 */@",
    "-e", "s@\\(/\\*#define\tHUGE_VAL\t3.40282346638528860e+38 \\)\\(/\\*error value returned by Math lib\\*/\\)$@\\1*/ \\2@",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  37 - Isc_Sys_Limits fix
 */
tSCC zIsc_Sys_LimitsName[] =
     "Isc_Sys_Limits";
/*
 *  File name selection pattern
 */
tSCC zIsc_Sys_LimitsList[] =
  "|sys/limits.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzIsc_Sys_LimitsMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zIsc_Sys_LimitsSelect0[] =
       "CHILD_MAX";

#define    ISC_SYS_LIMITS_TEST_CT  1
#define    ISC_SYS_LIMITS_RE_CT    1
tTestDesc aIsc_Sys_LimitsTests[] = {
  { TT_EGREP,  zIsc_Sys_LimitsSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Isc_Sys_Limits
 */
const char* apzIsc_Sys_LimitsPatch[] = { "sed",
    "-e", "/CHILD_MAX/s,/\\* Max, Max,",
    "-e", "/OPEN_MAX/s,/\\* Max, Max,",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  38 - Kandr_Concat fix
 */
tSCC zKandr_ConcatName[] =
     "Kandr_Concat";
/*
 *  File name selection pattern
 */
tSCC zKandr_ConcatList[] =
  "|sparc/asm_linkage.h|sun3/asm_linkage.h|sun3x/asm_linkage.h|sun4/asm_linkage.h|sun4c/asm_linkage.h|sun4m/asm_linkage.h|sun4c/debug/asm_linkage.h|sun4m/debug/asm_linkage.h|arm/as_support.h|arm/mc_type.h|arm/xcb.h|dev/chardefmac.h|dev/ps_irq.h|dev/screen.h|dev/scsi.h|sys/tty.h|Xm.acorn/XmP.h|bsd43/bsd43_.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzKandr_ConcatMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zKandr_ConcatSelect0[] =
       "/\\*\\*/";

#define    KANDR_CONCAT_TEST_CT  1
#define    KANDR_CONCAT_RE_CT    1
tTestDesc aKandr_ConcatTests[] = {
  { TT_EGREP,  zKandr_ConcatSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Kandr_Concat
 */
const char* apzKandr_ConcatPatch[] = { "sed",
    "-e", "s|/\\*\\*/|##|g",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  39 - Limits_Ifndefs fix
 */
tSCC zLimits_IfndefsName[] =
     "Limits_Ifndefs";
/*
 *  File name selection pattern
 */
tSCC zLimits_IfndefsList[] =
  "|limits.h|sys/limits.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzLimits_IfndefsMachs (const char**)NULL

/*
 *  content bypass pattern - skip fix if pattern found
 */
tSCC zLimits_IfndefsBypass0[] =
       "ifndef[ \t]+FLT_MIN";

#define    LIMITS_IFNDEFS_TEST_CT  1
#define    LIMITS_IFNDEFS_RE_CT    1
tTestDesc aLimits_IfndefsTests[] = {
  { TT_NEGREP, zLimits_IfndefsBypass0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Limits_Ifndefs
 */
const char* apzLimits_IfndefsPatch[] = { "sed",
    "-e", "/[ \t]FLT_MIN[ \t]/i\\\n\
#ifndef FLT_MIN\n",
    "-e", "/[ \t]FLT_MIN[ \t]/a\\\n\
#endif\n",
    "-e", "/[ \t]FLT_MAX[ \t]/i\\\n\
#ifndef FLT_MAX\n",
    "-e", "/[ \t]FLT_MAX[ \t]/a\\\n\
#endif\n",
    "-e", "/[ \t]FLT_DIG[ \t]/i\\\n\
#ifndef FLT_DIG\n",
    "-e", "/[ \t]FLT_DIG[ \t]/a\\\n\
#endif\n",
    "-e", "/[ \t]DBL_MIN[ \t]/i\\\n\
#ifndef DBL_MIN\n",
    "-e", "/[ \t]DBL_MIN[ \t]/a\\\n\
#endif\n",
    "-e", "/[ \t]DBL_MAX[ \t]/i\\\n\
#ifndef DBL_MAX\n",
    "-e", "/[ \t]DBL_MAX[ \t]/a\\\n\
#endif\n",
    "-e", "/[ \t]DBL_DIG[ \t]/i\\\n\
#ifndef DBL_DIG\n",
    "-e", "/[ \t]DBL_DIG[ \t]/a\\\n\
#endif\n",
    "-e", "/^\\(\\/\\*#define\tHUGE_VAL\t3\\.[0-9e+]* *\\)\\/\\*/s//\\1/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  40 - Lynx_Void_Int fix
 */
tSCC zLynx_Void_IntName[] =
     "Lynx_Void_Int";
/*
 *  File name selection pattern
 */
tSCC zLynx_Void_IntList[] =
  "|curses.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzLynx_Void_IntMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zLynx_Void_IntSelect0[] =
       "#[ \t]*define[ \t]+void[ \t]+int";

#define    LYNX_VOID_INT_TEST_CT  1
#define    LYNX_VOID_INT_RE_CT    1
tTestDesc aLynx_Void_IntTests[] = {
  { TT_EGREP,  zLynx_Void_IntSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Lynx_Void_Int
 */
const char* apzLynx_Void_IntPatch[] = { "sed",
    "-e", "/#[ \t]*define[ \t][ \t]*void[ \t]int/d",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  41 - Lynxos_Fcntl_Proto fix
 */
tSCC zLynxos_Fcntl_ProtoName[] =
     "Lynxos_Fcntl_Proto";
/*
 *  File name selection pattern
 */
tSCC zLynxos_Fcntl_ProtoList[] =
  "|fcntl.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzLynxos_Fcntl_ProtoMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zLynxos_Fcntl_ProtoSelect0[] =
       "fcntl.*\\(int, int, int\\)";

#define    LYNXOS_FCNTL_PROTO_TEST_CT  1
#define    LYNXOS_FCNTL_PROTO_RE_CT    1
tTestDesc aLynxos_Fcntl_ProtoTests[] = {
  { TT_EGREP,  zLynxos_Fcntl_ProtoSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Lynxos_Fcntl_Proto
 */
const char* apzLynxos_Fcntl_ProtoPatch[] = { "sed",
    "-e", "s/\\(fcntl.*(int, int, \\)int)/\\1...)/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  42 - M88k_Bad_Hypot_Opt fix
 */
tSCC zM88k_Bad_Hypot_OptName[] =
     "M88k_Bad_Hypot_Opt";
/*
 *  File name selection pattern
 */
tSCC zM88k_Bad_Hypot_OptList[] =
  "|math.h|";
/*
 *  Machine/OS name selection pattern
 */
tSCC* apzM88k_Bad_Hypot_OptMachs[] = {
        "m88k-motorola-sysv3*",
        (const char*)NULL };
#define M88K_BAD_HYPOT_OPT_TEST_CT  0
#define M88K_BAD_HYPOT_OPT_RE_CT    0
#define aM88k_Bad_Hypot_OptTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for M88k_Bad_Hypot_Opt
 */
const char* apzM88k_Bad_Hypot_OptPatch[] = { "sed",
    "-e", "s/extern double floor(), ceil(), fmod(), fabs();/extern double floor(), ceil(), fmod(), fabs _PARAMS((double));/",
    "-e", "/^extern double hypot();$/a\\\n\
\\/* Workaround a stupid Motorola optimization if one\\\n\
   of x or y is 0.0 and the other is negative!  *\\/\\\n\
#ifdef __STDC__\\\n\
static __inline__ double fake_hypot (double x, double y)\\\n\
#else\\\n\
static __inline__ double fake_hypot (x, y)\\\n\
\tdouble x, y;\\\n\
#endif\\\n\
{\\\n\
\treturn fabs (hypot (x, y));\\\n\
}\\\n\
#define hypot\tfake_hypot\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  43 - M88k_Bad_S_If fix
 */
tSCC zM88k_Bad_S_IfName[] =
     "M88k_Bad_S_If";
/*
 *  File name selection pattern
 */
tSCC zM88k_Bad_S_IfList[] =
  "|sys/stat.h|";
/*
 *  Machine/OS name selection pattern
 */
tSCC* apzM88k_Bad_S_IfMachs[] = {
        "m88k-*-sysv3*",
        (const char*)NULL };

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zM88k_Bad_S_IfSelect0[] =
       "#define[ \t]+S_IS[A-Z]*(m)[ \t]";

#define    M88K_BAD_S_IF_TEST_CT  1
#define    M88K_BAD_S_IF_RE_CT    1
tTestDesc aM88k_Bad_S_IfTests[] = {
  { TT_EGREP,  zM88k_Bad_S_IfSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for M88k_Bad_S_If
 */
const char* apzM88k_Bad_S_IfPatch[] = { "sed",
    "-e", "s/^\\(#define[ \t]*S_IS[A-Z]*(m)\\)[ \t]*(m[ \t]*&[ \t]*\\(S_IF[A-Z][A-Z][A-Z][A-Z]*\\)[ \t]*)/\\1 (((m)\\&S_IFMT)==\\2)/",
    "-e", "s/^\\(#define[ \t]*S_IS[A-Z]*(m)\\)[ \t]*(m[ \t]*&[ \t]*\\(0[0-9]*\\)[ \t]*)/\\1 (((m)\\&S_IFMT)==\\2)/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  44 - M88k_Multi_Incl fix
 */
tSCC zM88k_Multi_InclName[] =
     "M88k_Multi_Incl";
/*
 *  File name selection pattern
 */
tSCC zM88k_Multi_InclList[] =
  "|time.h|";
/*
 *  Machine/OS name selection pattern
 */
tSCC* apzM88k_Multi_InclMachs[] = {
        "m88k-tektronix-sysv3*",
        (const char*)NULL };

/*
 *  content bypass pattern - skip fix if pattern found
 */
tSCC zM88k_Multi_InclBypass0[] =
       "#ifndef";

#define    M88K_MULTI_INCL_TEST_CT  1
#define    M88K_MULTI_INCL_RE_CT    1
tTestDesc aM88k_Multi_InclTests[] = {
  { TT_NEGREP, zM88k_Multi_InclBypass0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for M88k_Multi_Incl
 */
const char* apzM88k_Multi_InclPatch[] = { "sh", "-c",
    "echo Fixing $file, to protect against multiple inclusion. >&2\n\
      cpp_wrapper=`echo $file | sed -e 's,\\.,_,g' -e 's,/,_,g'`\n\
      echo \"#ifndef __GCC_GOT_${cpp_wrapper}_\"\n\
      echo \"#define __GCC_GOT_${cpp_wrapper}_\"\n\
      cat\n\
      echo \"#endif /* ! __GCC_GOT_${cpp_wrapper}_ */\"",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  45 - Machine_Name fix
 */
tSCC zMachine_NameName[] =
     "Machine_Name";
/*
 *  File name selection pattern
 */
#define zMachine_NameList (char*)NULL
/*
 *  Machine/OS name selection pattern
 */
#define apzMachine_NameMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 *  This is a special pattern that not all egrep commands
 *  are capable of coping with.  We use the GNU library, tho :)
 */
tSCC zMachine_NameSelect0[] =
       "^#[ \t]*(if|elif).*[^a-zA-Z0-9_](M32|_*MIPSE[LB]|_*SYSTYPE_[A-Z0-9]|_*[Rr][34]000|_*host_mips|_*i386|_*mips|bsd4|is68k|m[68]8k|mc680|news|ns32000|pdp11|pyr|sel|sony_news|sparc|sun|tahoe|tower|u370|u3b|unix|vax)";

#define    MACHINE_NAME_TEST_CT  1
#define    MACHINE_NAME_RE_CT    1
tTestDesc aMachine_NameTests[] = {
  { TT_EGREP,  zMachine_NameSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Machine_Name
 */
const char* apzMachine_NamePatch[] = { "sed",
    "-e", ":loop\n\
/\\\\$/N\n\
s/\\\\$/\\\\+++fixinc_eol+++/\n\
/\\\\$/b loop\n\
s/\\\\+++fixinc_eol+++/\\\\/g\n\
/#[\t ]*[el]*if/ {\n\
\ts/[a-zA-Z0-9_][a-zA-Z0-9_]*/ & /g\n\
\ts/ M32 / __M32__ /g\n\
\ts/ _*MIPSE\\([LB]\\) / __MIPSE\\1__ /g\n\
\ts/ _*SYSTYPE_\\([A-Z0-9]*\\) / __SYSTYPE_\\1__ /g\n\
\ts/ _*\\([Rr][34]\\)000 / __\\1000__ /g\n\
\ts/ _*host_mips / __host_mips__ /g\n\
\ts/ _*i386 / __i386__ /g\n\
\ts/ _*mips / __mips__ /g\n\
\ts/ bsd4\\([0-9]\\) / __bsd4\\1__ /g\n\
\ts/ is68k / __is68k__ /g\n\
\ts/ m68k / __m68k__ /g\n\
\ts/ m88k / __m88k__ /g\n\
\ts/ mc680\\([0-9]\\)0 / __mc680\\10__ /g\n\
\ts/ news\\([0-9]*\\) / __news\\1__ /g\n\
\ts/ ns32000 / __ns32000__ /g\n\
\ts/ pdp11 / __pdp11__ /g\n\
\ts/ pyr / __pyr__ /g\n\
\ts/ sel / __sel__ /g\n\
\ts/ sony_news / __sony_news__ /g\n\
\ts/ sparc / __sparc__ /g\n\
\ts/ sun\\([a-z0-9]*\\) / __sun\\1__ /g\n\
\ts/ tahoe / __tahoe__ /g\n\
\ts/ tower\\([_0-9]*\\) / __tower\\1__ /g\n\
\ts/ u370 / __u370__ /g\n\
\ts/ u3b\\([0-9]*\\) / __u3b\\1__ /g\n\
\ts/ unix / __unix__ /g\n\
\ts/ vax / __vax__ /g\n\
\ts/ \\([a-zA-Z0-9_][a-zA-Z0-9_]*\\) /\\1/g\n\
\t}",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  46 - Math_Exception fix
 */
tSCC zMath_ExceptionName[] =
     "Math_Exception";
/*
 *  File name selection pattern
 */
tSCC zMath_ExceptionList[] =
  "|math.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzMath_ExceptionMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zMath_ExceptionSelect0[] =
       "struct exception";

#define    MATH_EXCEPTION_TEST_CT  1
#define    MATH_EXCEPTION_RE_CT    1
tTestDesc aMath_ExceptionTests[] = {
  { TT_EGREP,  zMath_ExceptionSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Math_Exception
 */
const char* apzMath_ExceptionPatch[] = { "sed",
    "-e", "/struct exception/i\\\n\
#ifdef __cplusplus\\\n\
#define exception __math_exception\\\n\
#endif\n",
    "-e", "/struct exception/a\\\n\
#ifdef __cplusplus\\\n\
#undef exception\\\n\
#endif\n",
    "-e", "/matherr/i\\\n\
#ifdef __cplusplus\\\n\
#define exception __math_exception\\\n\
#endif\n",
    "-e", "/matherr/a\\\n\
#ifdef __cplusplus\\\n\
#undef exception\\\n\
#endif\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  47 - Math_Gcc_Ifndefs fix
 */
tSCC zMath_Gcc_IfndefsName[] =
     "Math_Gcc_Ifndefs";
/*
 *  File name selection pattern
 */
tSCC zMath_Gcc_IfndefsList[] =
  "|math.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzMath_Gcc_IfndefsMachs (const char**)NULL
#define MATH_GCC_IFNDEFS_TEST_CT  0
#define MATH_GCC_IFNDEFS_RE_CT    0
#define aMath_Gcc_IfndefsTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Math_Gcc_Ifndefs
 */
const char* apzMath_Gcc_IfndefsPatch[] = { "sh", "-c",
    "\tdbl_max_def=`egrep 'define[ \t]+DBL_MAX[ \t]+.*' float.h 2>/dev/null`\n\
\n\
\tif ( test -n \"${dbl_max_def}\" \\\n\
\t\t-a -n \"`egrep '#define[ \t]*HUGE_VAL[ \t]+DBL_MAX' $file`\" \\\n\
\t\t-a -z \"`egrep '#define[ \t]+DBL_MAX[ \t]+' $file`\"\n\
\t   ) > /dev/null 2>&1\n\
\tthen sed -e '/define[ \t]HUGE_VAL[ \t]DBL_MAX/s/DBL_MAX/$dbl_max_def/'\n\
\telse cat ; fi |\n\
\tsed -e '/define[ \t]HUGE_VAL[ \t]/i\\\n\
#ifndef HUGE_VAL\n\
' -e '/define[ \t]HUGE_VAL[ \t]/a\\\n\
#endif\n\
'",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  48 - Nested_Comment fix
 */
tSCC zNested_CommentName[] =
     "Nested_Comment";
/*
 *  File name selection pattern
 */
tSCC zNested_CommentList[] =
  "|rpc/rpc.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzNested_CommentMachs (const char**)NULL
#define NESTED_COMMENT_TEST_CT  0
#define NESTED_COMMENT_RE_CT    0
#define aNested_CommentTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Nested_Comment
 */
const char* apzNested_CommentPatch[] = { "sed",
    "-e", "s@^\\(/\\*.*rpc/auth_des.h>.*\\)/\\*@\\1*/ /*@",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  49 - News_Os_Recursion fix
 */
tSCC zNews_Os_RecursionName[] =
     "News_Os_Recursion";
/*
 *  File name selection pattern
 */
tSCC zNews_Os_RecursionList[] =
  "|stdlib.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzNews_Os_RecursionMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zNews_Os_RecursionSelect0[] =
       "#include <stdlib.h>";

#define    NEWS_OS_RECURSION_TEST_CT  1
#define    NEWS_OS_RECURSION_RE_CT    1
tTestDesc aNews_Os_RecursionTests[] = {
  { TT_EGREP,  zNews_Os_RecursionSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for News_Os_Recursion
 */
const char* apzNews_Os_RecursionPatch[] = { "sed",
    "-e", "/^#include <stdlib.h>/i\\\n\
#ifdef BOGUS_RECURSION\n",
    "-e", "/^#include <stdlib.h>/a\\\n\
#endif\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  50 - Next_Math_Prefix fix
 */
tSCC zNext_Math_PrefixName[] =
     "Next_Math_Prefix";
/*
 *  File name selection pattern
 */
tSCC zNext_Math_PrefixList[] =
  "|ansi/math.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzNext_Math_PrefixMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zNext_Math_PrefixSelect0[] =
       "^extern.*double.*__const__.*";

#define    NEXT_MATH_PREFIX_TEST_CT  1
#define    NEXT_MATH_PREFIX_RE_CT    1
tTestDesc aNext_Math_PrefixTests[] = {
  { TT_EGREP,  zNext_Math_PrefixSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Next_Math_Prefix
 */
const char* apzNext_Math_PrefixPatch[] = { "sed",
    "-e", "/^extern.*double.*__const__.*sqrt(/s/__const__//",
    "-e", "/^extern.*double.*__const__.*fabs(/s/__const__//",
    "-e", "/^extern.*double.*__const__.*cos(/s/__const__//",
    "-e", "/^extern.*double.*__const__.*hypot(/s/__const__//",
    "-e", "/^extern.*double.*__const__.*sin(/s/__const__//",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  51 - Next_Template fix
 */
tSCC zNext_TemplateName[] =
     "Next_Template";
/*
 *  File name selection pattern
 */
tSCC zNext_TemplateList[] =
  "|bsd/libc.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzNext_TemplateMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zNext_TemplateSelect0[] =
       "template";

#define    NEXT_TEMPLATE_TEST_CT  1
#define    NEXT_TEMPLATE_RE_CT    1
tTestDesc aNext_TemplateTests[] = {
  { TT_EGREP,  zNext_TemplateSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Next_Template
 */
const char* apzNext_TemplatePatch[] = { "sed",
    "-e", "/\\(.*template\\)/s/template//",
    "-e", "/extern.*volatile.*void.*abort/s/volatile//",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  52 - Next_Volitile fix
 */
tSCC zNext_VolitileName[] =
     "Next_Volitile";
/*
 *  File name selection pattern
 */
tSCC zNext_VolitileList[] =
  "|ansi/stdlib.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzNext_VolitileMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zNext_VolitileSelect0[] =
       "volatile";

#define    NEXT_VOLITILE_TEST_CT  1
#define    NEXT_VOLITILE_RE_CT    1
tTestDesc aNext_VolitileTests[] = {
  { TT_EGREP,  zNext_VolitileSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Next_Volitile
 */
const char* apzNext_VolitilePatch[] = { "sed",
    "-e", "/extern.*volatile.*void.*exit/s/volatile//",
    "-e", "/extern.*volatile.*void.*abort/s/volatile//",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  53 - Next_Wait_Union fix
 */
tSCC zNext_Wait_UnionName[] =
     "Next_Wait_Union";
/*
 *  File name selection pattern
 */
tSCC zNext_Wait_UnionList[] =
  "|sys/wait.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzNext_Wait_UnionMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zNext_Wait_UnionSelect0[] =
       "wait\\(union wait";

#define    NEXT_WAIT_UNION_TEST_CT  1
#define    NEXT_WAIT_UNION_RE_CT    1
tTestDesc aNext_Wait_UnionTests[] = {
  { TT_EGREP,  zNext_Wait_UnionSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Next_Wait_Union
 */
const char* apzNext_Wait_UnionPatch[] = { "sed",
    "-e", "s@wait(union wait@wait(void@",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  54 - Nodeent_Syntax fix
 */
tSCC zNodeent_SyntaxName[] =
     "Nodeent_Syntax";
/*
 *  File name selection pattern
 */
tSCC zNodeent_SyntaxList[] =
  "|netdnet/dnetdb.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzNodeent_SyntaxMachs (const char**)NULL
#define NODEENT_SYNTAX_TEST_CT  0
#define NODEENT_SYNTAX_RE_CT    0
#define aNodeent_SyntaxTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Nodeent_Syntax
 */
const char* apzNodeent_SyntaxPatch[] = { "sed",
    "-e", "s/char.*na_addr *$/char *na_addr;/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  55 - Osf_Namespace_A fix
 */
tSCC zOsf_Namespace_AName[] =
     "Osf_Namespace_A";
/*
 *  File name selection pattern
 */
tSCC zOsf_Namespace_AList[] =
  "|reg_types.h|sys/lc_core.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzOsf_Namespace_AMachs (const char**)NULL

/*
 *  perform the 'test' shell command - do fix on success
 */
tSCC zOsf_Namespace_ATest0[] =
       " -r reg_types.h";
tSCC zOsf_Namespace_ATest1[] =
       " -r sys/lc_core.h";
tSCC zOsf_Namespace_ATest2[] =
       " -n \"`grep '} regex_t;' reg_types.h`\"";
tSCC zOsf_Namespace_ATest3[] =
       " -z \"`grep __regex_t regex.h`\"";

#define    OSF_NAMESPACE_A_TEST_CT  4
#define    OSF_NAMESPACE_A_RE_CT    0
tTestDesc aOsf_Namespace_ATests[] = {
  { TT_TEST,   zOsf_Namespace_ATest0,     0 /* unused */ },
  { TT_TEST,   zOsf_Namespace_ATest1,     0 /* unused */ },
  { TT_TEST,   zOsf_Namespace_ATest2,     0 /* unused */ },
  { TT_TEST,   zOsf_Namespace_ATest3,     0 /* unused */ }, };

/*
 *  Fix Command Arguments for Osf_Namespace_A
 */
const char* apzOsf_Namespace_APatch[] = { "sed",
    "-e", "s/regex_t/__regex_t/g",
    "-e", "s/regoff_t/__regoff_t/g",
    "-e", "s/regmatch_t/__regmatch_t/g",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  56 - Osf_Namespace_B fix
 */
tSCC zOsf_Namespace_BName[] =
     "Osf_Namespace_B";
/*
 *  File name selection pattern
 */
tSCC zOsf_Namespace_BList[] =
  "|regex.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzOsf_Namespace_BMachs (const char**)NULL

/*
 *  perform the 'test' shell command - do fix on success
 */
tSCC zOsf_Namespace_BTest0[] =
       " -r reg_types.h";
tSCC zOsf_Namespace_BTest1[] =
       " -r sys/lc_core.h";
tSCC zOsf_Namespace_BTest2[] =
       " -n \"`grep '} regex_t;' reg_types.h`\"";
tSCC zOsf_Namespace_BTest3[] =
       " -z \"`grep __regex_t regex.h`\"";

#define    OSF_NAMESPACE_B_TEST_CT  4
#define    OSF_NAMESPACE_B_RE_CT    0
tTestDesc aOsf_Namespace_BTests[] = {
  { TT_TEST,   zOsf_Namespace_BTest0,     0 /* unused */ },
  { TT_TEST,   zOsf_Namespace_BTest1,     0 /* unused */ },
  { TT_TEST,   zOsf_Namespace_BTest2,     0 /* unused */ },
  { TT_TEST,   zOsf_Namespace_BTest3,     0 /* unused */ }, };

/*
 *  Fix Command Arguments for Osf_Namespace_B
 */
const char* apzOsf_Namespace_BPatch[] = { "sed",
    "-e", "/#include <reg_types.h>/a\\\n\
typedef __regex_t\tregex_t;\\\n\
typedef __regoff_t\tregoff_t;\\\n\
typedef __regmatch_t\tregmatch_t;\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  57 - Pthread_Page_Size fix
 */
tSCC zPthread_Page_SizeName[] =
     "Pthread_Page_Size";
/*
 *  File name selection pattern
 */
tSCC zPthread_Page_SizeList[] =
  "|pthread.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzPthread_Page_SizeMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zPthread_Page_SizeSelect0[] =
       "^int __page_size";

#define    PTHREAD_PAGE_SIZE_TEST_CT  1
#define    PTHREAD_PAGE_SIZE_RE_CT    1
tTestDesc aPthread_Page_SizeTests[] = {
  { TT_EGREP,  zPthread_Page_SizeSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Pthread_Page_Size
 */
const char* apzPthread_Page_SizePatch[] = { "sed",
    "-e", "s/^int __page_size/extern int __page_size/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  58 - Rs6000_Double fix
 */
tSCC zRs6000_DoubleName[] =
     "Rs6000_Double";
/*
 *  File name selection pattern
 */
tSCC zRs6000_DoubleList[] =
  "|math.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzRs6000_DoubleMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zRs6000_DoubleSelect0[] =
       "[^a-zA-Z_]class\\(";

#define    RS6000_DOUBLE_TEST_CT  1
#define    RS6000_DOUBLE_RE_CT    1
tTestDesc aRs6000_DoubleTests[] = {
  { TT_EGREP,  zRs6000_DoubleSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Rs6000_Double
 */
const char* apzRs6000_DoublePatch[] = { "sed",
    "-e", "/class[(]/i\\\n\
#ifndef __cplusplus\n",
    "-e", "/class[(]/a\\\n\
#endif\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  59 - Rs6000_Fchmod fix
 */
tSCC zRs6000_FchmodName[] =
     "Rs6000_Fchmod";
/*
 *  File name selection pattern
 */
tSCC zRs6000_FchmodList[] =
  "|sys/stat.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzRs6000_FchmodMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zRs6000_FchmodSelect0[] =
       "fchmod\\(char";

#define    RS6000_FCHMOD_TEST_CT  1
#define    RS6000_FCHMOD_RE_CT    1
tTestDesc aRs6000_FchmodTests[] = {
  { TT_EGREP,  zRs6000_FchmodSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Rs6000_Fchmod
 */
const char* apzRs6000_FchmodPatch[] = { "sed",
    "-e", "s/fchmod(char \\*/fchmod(int/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  60 - Rs6000_Param fix
 */
tSCC zRs6000_ParamName[] =
     "Rs6000_Param";
/*
 *  File name selection pattern
 */
tSCC zRs6000_ParamList[] =
  "|stdio.h|unistd.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzRs6000_ParamMachs (const char**)NULL
#define RS6000_PARAM_TEST_CT  0
#define RS6000_PARAM_RE_CT    0
#define aRs6000_ParamTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Rs6000_Param
 */
const char* apzRs6000_ParamPatch[] = { "sed",
    "-e", "s@rename(const char \\*old, const char \\*new)@rename(const char *_old, const char *_new)@",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  61 - Sony_Include fix
 */
tSCC zSony_IncludeName[] =
     "Sony_Include";
/*
 *  File name selection pattern
 */
tSCC zSony_IncludeList[] =
  "|machine/machparam.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzSony_IncludeMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zSony_IncludeSelect0[] =
       "\"\\.\\./machine/endian.h\"";

#define    SONY_INCLUDE_TEST_CT  1
#define    SONY_INCLUDE_RE_CT    1
tTestDesc aSony_IncludeTests[] = {
  { TT_EGREP,  zSony_IncludeSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Sony_Include
 */
const char* apzSony_IncludePatch[] = { "sed",
    "-e", "s@\"../machine/endian.h\"@<machine/endian.h>@",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  62 - Statsswtch fix
 */
tSCC zStatsswtchName[] =
     "Statsswtch";
/*
 *  File name selection pattern
 */
tSCC zStatsswtchList[] =
  "|rpcsvc/rstat.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzStatsswtchMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zStatsswtchSelect0[] =
       "boottime$";

#define    STATSSWTCH_TEST_CT  1
#define    STATSSWTCH_RE_CT    1
tTestDesc aStatsswtchTests[] = {
  { TT_EGREP,  zStatsswtchSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Statsswtch
 */
const char* apzStatsswtchPatch[] = { "sed",
    "-e", "s/boottime$/boottime;/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  63 - Stdio_Va_List fix
 */
tSCC zStdio_Va_ListName[] =
     "Stdio_Va_List";
/*
 *  File name selection pattern
 */
tSCC zStdio_Va_ListList[] =
  "|stdio.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzStdio_Va_ListMachs (const char**)NULL
#define STDIO_VA_LIST_TEST_CT  0
#define STDIO_VA_LIST_RE_CT    0
#define aStdio_Va_ListTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Stdio_Va_List
 */
const char* apzStdio_Va_ListPatch[] = { "sh", "-c",
    "if ( egrep \"__need___va_list\" $file ) > /dev/null 2>&1 ; then\n\
    :\n\
  else\n\
    echo \"#define __need___va_list\"\n\
    echo \"#include <stdarg.h>\"\n\
  fi\n\
\n\
  sed -e 's@ va_list @ __gnuc_va_list @' \\\n\
      -e 's@ va_list)@ __gnuc_va_list)@' \\\n\
      -e 's@ _BSD_VA_LIST_));@ __gnuc_va_list));@' \\\n\
      -e 's@ _VA_LIST_));@ __gnuc_va_list));@' \\\n\
      -e 's@ va_list@ __va_list__@' \\\n\
      -e 's@\\*va_list@*__va_list__@' \\\n\
      -e 's@ __va_list)@ __gnuc_va_list)@' \\\n\
      -e 's@GNUC_VA_LIST@GNUC_Va_LIST@' \\\n\
      -e 's@_NEED___VA_LIST@_NEED___Va_LIST@' \\\n\
      -e 's@VA_LIST@DUMMY_VA_LIST@' \\\n\
      -e 's@_Va_LIST@_VA_LIST@'",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  64 - Sun_Bogus_Ifdef fix
 */
tSCC zSun_Bogus_IfdefName[] =
     "Sun_Bogus_Ifdef";
/*
 *  File name selection pattern
 */
tSCC zSun_Bogus_IfdefList[] =
  "|hsfs/hsfs_spec.h|hsfs/iso_spec.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzSun_Bogus_IfdefMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zSun_Bogus_IfdefSelect0[] =
       "#ifdef __i386__ || __vax__";

#define    SUN_BOGUS_IFDEF_TEST_CT  1
#define    SUN_BOGUS_IFDEF_RE_CT    1
tTestDesc aSun_Bogus_IfdefTests[] = {
  { TT_EGREP,  zSun_Bogus_IfdefSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Sun_Bogus_Ifdef
 */
const char* apzSun_Bogus_IfdefPatch[] = { "sed",
    "-e", "s/\\#ifdef __i386__ || __vax__/\\#if __i386__ || __vax__/g",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  65 - Sun_Bogus_Ifdef_Sun4c fix
 */
tSCC zSun_Bogus_Ifdef_Sun4cName[] =
     "Sun_Bogus_Ifdef_Sun4c";
/*
 *  File name selection pattern
 */
tSCC zSun_Bogus_Ifdef_Sun4cList[] =
  "|hsfs/hsnode.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzSun_Bogus_Ifdef_Sun4cMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zSun_Bogus_Ifdef_Sun4cSelect0[] =
       "#ifdef __i386__ || __sun4c__";

#define    SUN_BOGUS_IFDEF_SUN4C_TEST_CT  1
#define    SUN_BOGUS_IFDEF_SUN4C_RE_CT    1
tTestDesc aSun_Bogus_Ifdef_Sun4cTests[] = {
  { TT_EGREP,  zSun_Bogus_Ifdef_Sun4cSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Sun_Bogus_Ifdef_Sun4c
 */
const char* apzSun_Bogus_Ifdef_Sun4cPatch[] = { "sed",
    "-e", "s/\\#ifdef __i386__ || __sun4c__/\\#if __i386__ || __sun4c__/g",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  66 - Sun_Catmacro fix
 */
tSCC zSun_CatmacroName[] =
     "Sun_Catmacro";
/*
 *  File name selection pattern
 */
tSCC zSun_CatmacroList[] =
  "|pixrect/memvar.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzSun_CatmacroMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zSun_CatmacroSelect0[] =
       "^#define[ \t]+CAT\\(a,b\\)";

#define    SUN_CATMACRO_TEST_CT  1
#define    SUN_CATMACRO_RE_CT    1
tTestDesc aSun_CatmacroTests[] = {
  { TT_EGREP,  zSun_CatmacroSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Sun_Catmacro
 */
const char* apzSun_CatmacroPatch[] = { "sed",
    "-e", "/^#define[ \t]CAT(a,b)/ i\\\n\
#ifdef __STDC__ \\\n\
#define CAT(a,b) a##b\\\n\
#else\n",
    "-e", "/^#define[ \t]CAT(a,b)/ a\\\n\
#endif\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  67 - Sun_Malloc fix
 */
tSCC zSun_MallocName[] =
     "Sun_Malloc";
/*
 *  File name selection pattern
 */
tSCC zSun_MallocList[] =
  "|malloc.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzSun_MallocMachs (const char**)NULL
#define SUN_MALLOC_TEST_CT  0
#define SUN_MALLOC_RE_CT    0
#define aSun_MallocTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Sun_Malloc
 */
const char* apzSun_MallocPatch[] = { "sed",
    "-e", "s/typedef[ \t]char \\*\tmalloc_t/typedef void \\*\tmalloc_t/g",
    "-e", "s/int[ \t][ \t]*free/void\tfree/g",
    "-e", "s/char\\([ \t]*\\*[ \t]*malloc\\)/void\\1/g",
    "-e", "s/char\\([ \t]*\\*[ \t]*realloc\\)/void\\1/g",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  68 - Sun_Memcpy fix
 */
tSCC zSun_MemcpyName[] =
     "Sun_Memcpy";
/*
 *  File name selection pattern
 */
tSCC zSun_MemcpyList[] =
  "|memory.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzSun_MemcpyMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zSun_MemcpySelect0[] =
       "/\\*\t@\\(#\\)(head/memory.h\t50.1\t |memory\\.h 1\\.[2-4] 8./../.. SMI; from S5R2 1\\.2\t)\\*/";

#define    SUN_MEMCPY_TEST_CT  1
#define    SUN_MEMCPY_RE_CT    1
tTestDesc aSun_MemcpyTests[] = {
  { TT_EGREP,  zSun_MemcpySelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Sun_Memcpy
 */
const char* apzSun_MemcpyPatch[] = { "sed",
    "-e", "1i\\\n\
/* This file was generated by fixincludes */\\\n\
#ifndef __memory_h__\\\n\
#define __memory_h__\\\n\
\\\n\
#ifdef __STDC__\\\n\
extern void *memccpy();\\\n\
extern void *memchr();\\\n\
extern void *memcpy();\\\n\
extern void *memset();\\\n\
#else\\\n\
extern char *memccpy();\\\n\
extern char *memchr();\\\n\
extern char *memcpy();\\\n\
extern char *memset();\\\n\
#endif /* __STDC__ */\\\n\
\\\n\
extern int memcmp();\\\n\
\\\n\
#endif /* __memory_h__ */\n",
    "-e", "1,$d",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  69 - Sun_Rusers_Semi fix
 */
tSCC zSun_Rusers_SemiName[] =
     "Sun_Rusers_Semi";
/*
 *  File name selection pattern
 */
tSCC zSun_Rusers_SemiList[] =
  "|rpcsvc/rusers.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzSun_Rusers_SemiMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zSun_Rusers_SemiSelect0[] =
       "_cnt$";

#define    SUN_RUSERS_SEMI_TEST_CT  1
#define    SUN_RUSERS_SEMI_RE_CT    1
tTestDesc aSun_Rusers_SemiTests[] = {
  { TT_EGREP,  zSun_Rusers_SemiSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Sun_Rusers_Semi
 */
const char* apzSun_Rusers_SemiPatch[] = { "sed",
    "-e", "/^struct/,/^};/s/_cnt$/_cnt;/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  70 - Sun_Signal fix
 */
tSCC zSun_SignalName[] =
     "Sun_Signal";
/*
 *  File name selection pattern
 */
tSCC zSun_SignalList[] =
  "|sys/signal.h|signal.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzSun_SignalMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zSun_SignalSelect0[] =
       "^void\t\\(\\*signal\\(\\)\\)\\(\\);";

#define    SUN_SIGNAL_TEST_CT  1
#define    SUN_SIGNAL_RE_CT    1
tTestDesc aSun_SignalTests[] = {
  { TT_EGREP,  zSun_SignalSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Sun_Signal
 */
const char* apzSun_SignalPatch[] = { "sed",
    "-e", "/^void\t(\\*signal())();$/i\\\n\
#ifdef __cplusplus\\\n\
void\t(*signal(...))(...);\\\n\
#else\n",
    "-e", "/^void\t(\\*signal())();$/a\\\n\
#endif\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  71 - Sun_Auth_Proto fix
 */
tSCC zSun_Auth_ProtoName[] =
     "Sun_Auth_Proto";
/*
 *  File name selection pattern
 */
tSCC zSun_Auth_ProtoList[] =
  "|rpc/auth.h|rpc/clnt.h|rpc/svc.h|rpc/xdr.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzSun_Auth_ProtoMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zSun_Auth_ProtoSelect0[] =
       "\\(\\*[a-z][a-z_]*\\)\\(\\)";

#define    SUN_AUTH_PROTO_TEST_CT  1
#define    SUN_AUTH_PROTO_RE_CT    1
tTestDesc aSun_Auth_ProtoTests[] = {
  { TT_EGREP,  zSun_Auth_ProtoSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Sun_Auth_Proto
 */
const char* apzSun_Auth_ProtoPatch[] = { "sed",
    "-e", "s/^\\(.*(\\*[a-z][a-z_]*)(\\)\\();.*\\)/\\\n\
#ifdef __cplusplus\\\n\
\\1...\\2\\\n\
#else\\\n\
\\1\\2\\\n\
#endif/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  72 - Sunos_Matherr_Decl fix
 */
tSCC zSunos_Matherr_DeclName[] =
     "Sunos_Matherr_Decl";
/*
 *  File name selection pattern
 */
tSCC zSunos_Matherr_DeclList[] =
  "|math.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzSunos_Matherr_DeclMachs (const char**)NULL
#define SUNOS_MATHERR_DECL_TEST_CT  0
#define SUNOS_MATHERR_DECL_RE_CT    0
#define aSunos_Matherr_DeclTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Sunos_Matherr_Decl
 */
const char* apzSunos_Matherr_DeclPatch[] = { "sed",
    "-e", "/^struct exception/,$b",
    "-e", "/matherr/i\\\n\
struct exception;\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  73 - Sunos_Strlen fix
 */
tSCC zSunos_StrlenName[] =
     "Sunos_Strlen";
/*
 *  File name selection pattern
 */
tSCC zSunos_StrlenList[] =
  "|strings.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzSunos_StrlenMachs (const char**)NULL
#define SUNOS_STRLEN_TEST_CT  0
#define SUNOS_STRLEN_RE_CT    0
#define aSunos_StrlenTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Sunos_Strlen
 */
const char* apzSunos_StrlenPatch[] = { "sed",
    "-e", "s/int[ \t]*strlen();/__SIZE_TYPE__ strlen();/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  74 - Systypes fix
 */
tSCC zSystypesName[] =
     "Systypes";
/*
 *  File name selection pattern
 */
tSCC zSystypesList[] =
  "|sys/types.h|stdlib.h|sys/stdtypes.h|stddef.h|memory.h|unistd.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzSystypesMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zSystypesSelect0[] =
       "typedef[ \t]+[a-z_][ \ta-z_]*[ \t](size|ptrdiff|wchar)_t";

#define    SYSTYPES_TEST_CT  1
#define    SYSTYPES_RE_CT    1
tTestDesc aSystypesTests[] = {
  { TT_EGREP,  zSystypesSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Systypes
 */
const char* apzSystypesPatch[] = { "sed",
    "-e", "/^[ \t]*\\*[ \t]*typedef unsigned int size_t;/N",
    "-e", "s/^\\([ \t]*\\*[ \t]*typedef unsigned int size_t;\\n[ \t]*\\*\\/\\)/\\1\\\n\
#ifndef __SIZE_TYPE__\\\n\
#define __SIZE_TYPE__ long unsigned int\\\n\
#endif\\\n\
typedef __SIZE_TYPE__ size_t;\\\n\
/",
    "-e", "/typedef[ \t][ \t]*[a-z_][ \ta-z_]*[ \t]size_t/i\\\n\
#ifndef __SIZE_TYPE__\\\n\
#define __SIZE_TYPE__ long unsigned int\\\n\
#endif\n",
    "-e", "s/typedef[ \t][ \t]*[a-z_][ \ta-z_]*[ \t]size_t/typedef __SIZE_TYPE__ size_t/",
    "-e", "/typedef[ \t][ \t]*[a-z_][ \ta-z_]*[ \t]ptrdiff_t/i\\\n\
#ifndef __PTRDIFF_TYPE__\\\n\
#define __PTRDIFF_TYPE__ long int\\\n\
#endif\n",
    "-e", "s/typedef[ \t][ \t]*[a-z_][ \ta-z_]*[ \t]ptrdiff_t/typedef __PTRDIFF_TYPE__ ptrdiff_t/",
    "-e", "/typedef[ \t][ \t]*[a-z_][ \ta-z_]*[ \t]wchar_t/i\\\n\
#ifndef __WCHAR_TYPE__\\\n\
#define __WCHAR_TYPE__ int\\\n\
#endif\\\n\
#ifndef __cplusplus\n",
    "-e", "/typedef[ \t][ \t]*[a-z_][ \ta-z_]*[ \t]wchar_t/a\\\n\
#endif\n",
    "-e", "s/typedef[ \t][ \t]*[a-z_][ \ta-z_]*[ \t]wchar_t/typedef __WCHAR_TYPE__ wchar_t/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  75 - Systypes_For_Aix fix
 */
tSCC zSystypes_For_AixName[] =
     "Systypes_For_Aix";
/*
 *  File name selection pattern
 */
tSCC zSystypes_For_AixList[] =
  "|sys/types.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzSystypes_For_AixMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zSystypes_For_AixSelect0[] =
       "typedef[ \t][ \t]*[A-Za-z_][ \tA-Za-z_]*[ \t]size_t";

/*
 *  content bypass pattern - skip fix if pattern found
 */
tSCC zSystypes_For_AixBypass0[] =
       "_GCC_SIZE_T";

#define    SYSTYPES_FOR_AIX_TEST_CT  2
#define    SYSTYPES_FOR_AIX_RE_CT    2
tTestDesc aSystypes_For_AixTests[] = {
  { TT_NEGREP, zSystypes_For_AixBypass0,   (regex_t*)NULL },
  { TT_EGREP,  zSystypes_For_AixSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Systypes_For_Aix
 */
const char* apzSystypes_For_AixPatch[] = { "sed",
    "-e", "/typedef[ \t][ \t]*[A-Za-z_][ \tA-Za-z_]*[ \t]size_t/i\\\n\
#ifndef _GCC_SIZE_T\\\n\
#define _GCC_SIZE_T\n",
    "-e", "/typedef[ \t][ \t]*[A-Za-z_][ \tA-Za-z_]*[ \t]size_t/a\\\n\
#endif\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  76 - Sysv68_String fix
 */
tSCC zSysv68_StringName[] =
     "Sysv68_String";
/*
 *  File name selection pattern
 */
tSCC zSysv68_StringList[] =
  "|string.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzSysv68_StringMachs (const char**)NULL
#define SYSV68_STRING_TEST_CT  0
#define SYSV68_STRING_RE_CT    0
#define aSysv68_StringTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Sysv68_String
 */
const char* apzSysv68_StringPatch[] = { "sed",
    "-e", "s/extern[ \t]*int[ \t]*strlen();/extern unsigned int strlen();/",
    "-e", "s/extern[ \t]*int[ \t]*ffs[ \t]*(long);/extern int ffs(int);/",
    "-e", "s/strdup(char \\*s1);/strdup(const char *s1);/",
    "-e", "/^extern char$/N",
    "-e", "s/^extern char\\(\\n\t\\*memccpy(),\\)$/extern void\\1/",
    "-e", "/^\tstrncmp(),$/N",
    "-e", "s/^\\(\tstrncmp()\\),\\n\\(\tstrlen(),\\)$/\\1;\\\n\
extern unsigned int\\\n\
\\2/",
    "-e", "/^extern int$/N",
    "-e", "s/^extern int\\(\\n\tstrlen(),\\)/extern size_t\\1/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  77 - Sysz_Stdlib_For_Sun fix
 */
tSCC zSysz_Stdlib_For_SunName[] =
     "Sysz_Stdlib_For_Sun";
/*
 *  File name selection pattern
 */
tSCC zSysz_Stdlib_For_SunList[] =
  "|stdlib.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzSysz_Stdlib_For_SunMachs (const char**)NULL
#define SYSZ_STDLIB_FOR_SUN_TEST_CT  0
#define SYSZ_STDLIB_FOR_SUN_RE_CT    0
#define aSysz_Stdlib_For_SunTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Sysz_Stdlib_For_Sun
 */
const char* apzSysz_Stdlib_For_SunPatch[] = { "sed",
    "-e", "s/int\tabort/void\tabort/g",
    "-e", "s/int\tfree/void\tfree/g",
    "-e", "s/char[ \t]*\\*[ \t]*calloc/void \\*\tcalloc/g",
    "-e", "s/char[ \t]*\\*[ \t]*malloc/void \\*\tmalloc/g",
    "-e", "s/char[ \t]*\\*[ \t]*realloc/void \\*\trealloc/g",
    "-e", "s/char[ \t]*\\*[ \t]*bsearch/void \\*\tbsearch/g",
    "-e", "s/int[ \t][ \t]*exit/void\texit/g",
    "-e", "/typedef[ \ta-zA-Z_]*[ \t]size_t[ \t]*;/i\\\n\
#ifndef _GCC_SIZE_T\\\n\
#define _GCC_SIZE_T\n",
    "-e", "/typedef[ \ta-zA-Z_]*[ \t]size_t[ \t]*;/a\\\n\
#endif\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  78 - Sysz_Stdtypes_For_Sun fix
 */
tSCC zSysz_Stdtypes_For_SunName[] =
     "Sysz_Stdtypes_For_Sun";
/*
 *  File name selection pattern
 */
tSCC zSysz_Stdtypes_For_SunList[] =
  "|sys/stdtypes.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzSysz_Stdtypes_For_SunMachs (const char**)NULL
#define SYSZ_STDTYPES_FOR_SUN_TEST_CT  0
#define SYSZ_STDTYPES_FOR_SUN_RE_CT    0
#define aSysz_Stdtypes_For_SunTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Sysz_Stdtypes_For_Sun
 */
const char* apzSysz_Stdtypes_For_SunPatch[] = { "sed",
    "-e", "/[\t ]size_t.*;/i\\\n\
#ifndef _GCC_SIZE_T\\\n\
#define _GCC_SIZE_T\n",
    "-e", "/[\t ]size_t.*;/a\\\n\
#endif\n",
    "-e", "/[\t ]ptrdiff_t.*;/i\\\n\
#ifndef _GCC_PTRDIFF_T\\\n\
#define _GCC_PTRDIFF_T\n",
    "-e", "/[\t ]ptrdiff_t.*;/a\\\n\
#endif\n",
    "-e", "/[\t ]wchar_t.*;/i\\\n\
#ifndef _GCC_WCHAR_T\\\n\
#define _GCC_WCHAR_T\n",
    "-e", "/[\t ]wchar_t.*;/a\\\n\
#endif\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  79 - Tinfo_Cplusplus fix
 */
tSCC zTinfo_CplusplusName[] =
     "Tinfo_Cplusplus";
/*
 *  File name selection pattern
 */
tSCC zTinfo_CplusplusList[] =
  "|tinfo.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzTinfo_CplusplusMachs (const char**)NULL
#define TINFO_CPLUSPLUS_TEST_CT  0
#define TINFO_CPLUSPLUS_RE_CT    0
#define aTinfo_CplusplusTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Tinfo_Cplusplus
 */
const char* apzTinfo_CplusplusPatch[] = { "sed",
    "-e", "s/[ \t]_cplusplus/ __cplusplus/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  80 - Ultrix_Ansi_Compat fix
 */
tSCC zUltrix_Ansi_CompatName[] =
     "Ultrix_Ansi_Compat";
/*
 *  File name selection pattern
 */
tSCC zUltrix_Ansi_CompatList[] =
  "|ansi_compat.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzUltrix_Ansi_CompatMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zUltrix_Ansi_CompatSelect0[] =
       "ULTRIX";

#define    ULTRIX_ANSI_COMPAT_TEST_CT  1
#define    ULTRIX_ANSI_COMPAT_RE_CT    1
tTestDesc aUltrix_Ansi_CompatTests[] = {
  { TT_EGREP,  zUltrix_Ansi_CompatSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Ultrix_Ansi_Compat
 */
const char* apzUltrix_Ansi_CompatPatch[] = { "sed",
    "-e", "1i\\\n\
/* This file intentionally left blank. */\n",
    "-e", "1,$d",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  81 - Ultrix_Fix_Fixproto fix
 */
tSCC zUltrix_Fix_FixprotoName[] =
     "Ultrix_Fix_Fixproto";
/*
 *  File name selection pattern
 */
tSCC zUltrix_Fix_FixprotoList[] =
  "|sys/utsname.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzUltrix_Fix_FixprotoMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zUltrix_Fix_FixprotoSelect0[] =
       "ULTRIX";

#define    ULTRIX_FIX_FIXPROTO_TEST_CT  1
#define    ULTRIX_FIX_FIXPROTO_RE_CT    1
tTestDesc aUltrix_Fix_FixprotoTests[] = {
  { TT_EGREP,  zUltrix_Fix_FixprotoSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Ultrix_Fix_Fixproto
 */
const char* apzUltrix_Fix_FixprotoPatch[] = { "sed",
    "-e", "/^[ \t]*extern[ \t]*int[ \t]*uname();$/i\\\n\
struct utsname;\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  82 - Ultrix_Atof_Param fix
 */
tSCC zUltrix_Atof_ParamName[] =
     "Ultrix_Atof_Param";
/*
 *  File name selection pattern
 */
tSCC zUltrix_Atof_ParamList[] =
  "|math.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzUltrix_Atof_ParamMachs (const char**)NULL
#define ULTRIX_ATOF_PARAM_TEST_CT  0
#define ULTRIX_ATOF_PARAM_RE_CT    0
#define aUltrix_Atof_ParamTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Ultrix_Atof_Param
 */
const char* apzUltrix_Atof_ParamPatch[] = { "sed",
    "-e", "s@atof(\\([ \t]*char[ \t]*\\*[^)]*\\))@atof(const \\1)@",
    "-e", "s@inline int abs(int [a-z][a-z]*) {.*}@extern \"C\" int abs(int);@",
    "-e", "s@inline double abs(double [a-z][a-z]*) {.*}@@",
    "-e", "s@inline int sqr(int [a-z][a-z]*) {.*}@@",
    "-e", "s@inline double sqr(double [a-z][a-z]*) {.*}@@",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  83 - Ultrix_Const fix
 */
tSCC zUltrix_ConstName[] =
     "Ultrix_Const";
/*
 *  File name selection pattern
 */
tSCC zUltrix_ConstList[] =
  "|stdio.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzUltrix_ConstMachs (const char**)NULL
#define ULTRIX_CONST_TEST_CT  0
#define ULTRIX_CONST_RE_CT    0
#define aUltrix_ConstTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Ultrix_Const
 */
const char* apzUltrix_ConstPatch[] = { "sed",
    "-e", "s@perror( char \\*__s );@perror( const char *__s );@",
    "-e", "s@fputs( char \\*__s,@fputs( const char *__s,@",
    "-e", "s@fopen( char \\*__filename, char \\*__type );@fopen( const char *__filename, const char *__type );@",
    "-e", "s@fwrite( void \\*__ptr,@fwrite( const void *__ptr,@",
    "-e", "s@fscanf( FILE \\*__stream, char \\*__format,@fscanf( FILE *__stream, const char *__format,@",
    "-e", "s@scanf( char \\*__format,@scanf( const char *__format,@",
    "-e", "s@sscanf( char \\*__s, char \\*__format,@sscanf( const char *__s, const char *__format,@",
    "-e", "s@popen(char \\*, char \\*);@popen(const char *, const char *);@",
    "-e", "s@tempnam(char\\*,char\\*);@tempnam(const char*,const char*);@",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  84 - Ultrix_Ifdef fix
 */
tSCC zUltrix_IfdefName[] =
     "Ultrix_Ifdef";
/*
 *  File name selection pattern
 */
tSCC zUltrix_IfdefList[] =
  "|sys/file.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzUltrix_IfdefMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zUltrix_IfdefSelect0[] =
       "#ifdef KERNEL";

#define    ULTRIX_IFDEF_TEST_CT  1
#define    ULTRIX_IFDEF_RE_CT    1
tTestDesc aUltrix_IfdefTests[] = {
  { TT_EGREP,  zUltrix_IfdefSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Ultrix_Ifdef
 */
const char* apzUltrix_IfdefPatch[] = { "sed",
    "-e", "s/#ifdef KERNEL/#if defined(KERNEL)/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  85 - Ultrix_Nested_Cmnt fix
 */
tSCC zUltrix_Nested_CmntName[] =
     "Ultrix_Nested_Cmnt";
/*
 *  File name selection pattern
 */
tSCC zUltrix_Nested_CmntList[] =
  "|rpc/svc.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzUltrix_Nested_CmntMachs (const char**)NULL
#define ULTRIX_NESTED_CMNT_TEST_CT  0
#define ULTRIX_NESTED_CMNT_RE_CT    0
#define aUltrix_Nested_CmntTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Ultrix_Nested_Cmnt
 */
const char* apzUltrix_Nested_CmntPatch[] = { "sed",
    "-e", "s@^\\( \\*\tint protocol;  \\)/\\*@\\1*/ /*@",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  86 - Ultrix_Static fix
 */
tSCC zUltrix_StaticName[] =
     "Ultrix_Static";
/*
 *  File name selection pattern
 */
tSCC zUltrix_StaticList[] =
  "|machine/cpu.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzUltrix_StaticMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zUltrix_StaticSelect0[] =
       "#include \"r[34]_cpu";

#define    ULTRIX_STATIC_TEST_CT  1
#define    ULTRIX_STATIC_RE_CT    1
tTestDesc aUltrix_StaticTests[] = {
  { TT_EGREP,  zUltrix_StaticSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Ultrix_Static
 */
const char* apzUltrix_StaticPatch[] = { "sed",
    "-e", "s/^static struct tlb_pid_state/struct tlb_pid_state/",
    "-e", "s/^#include \"r3_cpu\\.h\"$/#include <machine\\/r3_cpu\\.h>/",
    "-e", "s/^#include \"r4_cpu\\.h\"$/#include <machine\\/r4_cpu\\.h>/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  87 - Undefine_Null fix
 */
tSCC zUndefine_NullName[] =
     "Undefine_Null";
/*
 *  File name selection pattern
 */
#define zUndefine_NullList (char*)NULL
/*
 *  Machine/OS name selection pattern
 */
#define apzUndefine_NullMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zUndefine_NullSelect0[] =
       "^#[ \t]*define[ \t]*[ \t]NULL[ \t]";

/*
 *  content bypass pattern - skip fix if pattern found
 */
tSCC zUndefine_NullBypass0[] =
       "#[ \t]*(ifn|un)def[ \t]*[ \t]NULL($|[ \t])";

#define    UNDEFINE_NULL_TEST_CT  2
#define    UNDEFINE_NULL_RE_CT    2
tTestDesc aUndefine_NullTests[] = {
  { TT_NEGREP, zUndefine_NullBypass0,   (regex_t*)NULL },
  { TT_EGREP,  zUndefine_NullSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Undefine_Null
 */
const char* apzUndefine_NullPatch[] = { "sed",
    "-e", "/^#[ \t]*define[ \t][ \t]*NULL[ \t]/i\\\n\
#undef NULL\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  88 - Va_I960_Macro fix
 */
tSCC zVa_I960_MacroName[] =
     "Va_I960_Macro";
/*
 *  File name selection pattern
 */
tSCC zVa_I960_MacroList[] =
  "|arch/i960/archI960.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzVa_I960_MacroMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zVa_I960_MacroSelect0[] =
       "__(vsiz|vali|vpad|alignof__)";

#define    VA_I960_MACRO_TEST_CT  1
#define    VA_I960_MACRO_RE_CT    1
tTestDesc aVa_I960_MacroTests[] = {
  { TT_EGREP,  zVa_I960_MacroSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Va_I960_Macro
 */
const char* apzVa_I960_MacroPatch[] = { "sed",
    "-e", "s/__vsiz/__vxvsiz/",
    "-e", "s/__vali/__vxvali/",
    "-e", "s/__vpad/__vxvpad/",
    "-e", "s/__alignof__/__vxalignof__/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  89 - Void_Null fix
 */
tSCC zVoid_NullName[] =
     "Void_Null";
/*
 *  File name selection pattern
 */
tSCC zVoid_NullList[] =
  "|curses.h|dbm.h|locale.h|stdio.h|stdlib.h|string.h|time.h|unistd.h|sys/dir.h|sys/param.h|sys/types.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzVoid_NullMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zVoid_NullSelect0[] =
       "#[ \t]*define[ \t][ \t]*NULL[ \t].*void";

#define    VOID_NULL_TEST_CT  1
#define    VOID_NULL_RE_CT    1
tTestDesc aVoid_NullTests[] = {
  { TT_EGREP,  zVoid_NullSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Void_Null
 */
const char* apzVoid_NullPatch[] = { "sed",
    "-e", "s/^#[ \t]*define[ \t]*NULL[ \t]*((void[ \t]*\\*)0)/#define NULL 0/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  90 - Vxworks_Gcc_Problem fix
 */
tSCC zVxworks_Gcc_ProblemName[] =
     "Vxworks_Gcc_Problem";
/*
 *  File name selection pattern
 */
tSCC zVxworks_Gcc_ProblemList[] =
  "|types/vxTypesBase.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzVxworks_Gcc_ProblemMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zVxworks_Gcc_ProblemSelect0[] =
       "__GNUC_TYPEOF_FEATURE_BROKEN_USE_DEFAULT_UNTIL_FIXED__";

#define    VXWORKS_GCC_PROBLEM_TEST_CT  1
#define    VXWORKS_GCC_PROBLEM_RE_CT    1
tTestDesc aVxworks_Gcc_ProblemTests[] = {
  { TT_EGREP,  zVxworks_Gcc_ProblemSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Vxworks_Gcc_Problem
 */
const char* apzVxworks_Gcc_ProblemPatch[] = { "sed",
    "-e", "s/#ifdef __GNUC_TYPEOF_FEATURE_BROKEN_USE_DEFAULT_UNTIL_FIXED__/#if 1/",
    "-e", "/[ \t]size_t/i\\\n\
#ifndef _GCC_SIZE_T\\\n\
#define _GCC_SIZE_T\n",
    "-e", "/[ \t]size_t/a\\\n\
#endif\n",
    "-e", "/[ \t]ptrdiff_t/i\\\n\
#ifndef _GCC_PTRDIFF_T\\\n\
#define _GCC_PTRDIFF_T\n",
    "-e", "/[ \t]ptrdiff_t/a\\\n\
#endif\n",
    "-e", "/[ \t]wchar_t/i\\\n\
#ifndef _GCC_WCHAR_T\\\n\
#define _GCC_WCHAR_T\n",
    "-e", "/[ \t]wchar_t/a\\\n\
#endif\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  91 - Vxworks_Needs_Vxtypes fix
 */
tSCC zVxworks_Needs_VxtypesName[] =
     "Vxworks_Needs_Vxtypes";
/*
 *  File name selection pattern
 */
tSCC zVxworks_Needs_VxtypesList[] =
  "|time.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzVxworks_Needs_VxtypesMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zVxworks_Needs_VxtypesSelect0[] =
       "uint_t[ \t][ \t]*_clocks_per_sec";

#define    VXWORKS_NEEDS_VXTYPES_TEST_CT  1
#define    VXWORKS_NEEDS_VXTYPES_RE_CT    1
tTestDesc aVxworks_Needs_VxtypesTests[] = {
  { TT_EGREP,  zVxworks_Needs_VxtypesSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Vxworks_Needs_Vxtypes
 */
const char* apzVxworks_Needs_VxtypesPatch[] = { "sed",
    "-e", "s/uint_t/unsigned int/",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  92 - Vxworks_Needs_Vxworks fix
 */
tSCC zVxworks_Needs_VxworksName[] =
     "Vxworks_Needs_Vxworks";
/*
 *  File name selection pattern
 */
tSCC zVxworks_Needs_VxworksList[] =
  "|sys/stat.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzVxworks_Needs_VxworksMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zVxworks_Needs_VxworksSelect0[] =
       "#[ \t]define[ \t][ \t]*__INCstath";

/*
 *  perform the 'test' shell command - do fix on success
 */
tSCC zVxworks_Needs_VxworksTest0[] =
       " -r types/vxTypesOld.h";
tSCC zVxworks_Needs_VxworksTest1[] =
       " -n \"`egrep '#include' $file`\"";
tSCC zVxworks_Needs_VxworksTest2[] =
       " -n \"`egrep ULONG $file`\"";

#define    VXWORKS_NEEDS_VXWORKS_TEST_CT  4
#define    VXWORKS_NEEDS_VXWORKS_RE_CT    1
tTestDesc aVxworks_Needs_VxworksTests[] = {
  { TT_TEST,   zVxworks_Needs_VxworksTest0,     0 /* unused */ },
  { TT_TEST,   zVxworks_Needs_VxworksTest1,     0 /* unused */ },
  { TT_TEST,   zVxworks_Needs_VxworksTest2,     0 /* unused */ },
  { TT_EGREP,  zVxworks_Needs_VxworksSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Vxworks_Needs_Vxworks
 */
const char* apzVxworks_Needs_VxworksPatch[] = { "sed",
    "-e", "/#[ \t]define[ \t][ \t]*__INCstath/a\\\n\
#include <types/vxTypesOld.h>\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  93 - Vxworks_Time fix
 */
tSCC zVxworks_TimeName[] =
     "Vxworks_Time";
/*
 *  File name selection pattern
 */
tSCC zVxworks_TimeList[] =
  "|time.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzVxworks_TimeMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zVxworks_TimeSelect0[] =
       "VOIDFUNCPTR";

/*
 *  perform the 'test' shell command - do fix on success
 */
tSCC zVxworks_TimeTest0[] =
       " -r vxWorks.h";

#define    VXWORKS_TIME_TEST_CT  2
#define    VXWORKS_TIME_RE_CT    1
tTestDesc aVxworks_TimeTests[] = {
  { TT_TEST,   zVxworks_TimeTest0,     0 /* unused */ },
  { TT_EGREP,  zVxworks_TimeSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Vxworks_Time
 */
const char* apzVxworks_TimePatch[] = { "sed",
    "-e", "/VOIDFUNCPTR/i\\\n\
#ifndef __gcc_VOIDFUNCPTR_defined\\\n\
#ifdef __cplusplus\\\n\
typedef void (*__gcc_VOIDFUNCPTR) (...);\\\n\
#else\\\n\
typedef void (*__gcc_VOIDFUNCPTR) ();\\\n\
#endif\\\n\
#define __gcc_VOIDFUNCPTR_defined\\\n\
#endif\n",
    "-e", "s/VOIDFUNCPTR/__gcc_VOIDFUNCPTR/g",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  94 - X11_Class fix
 */
tSCC zX11_ClassName[] =
     "X11_Class";
/*
 *  File name selection pattern
 */
tSCC zX11_ClassList[] =
  "|X11/ShellP.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzX11_ClassMachs (const char**)NULL

/*
 *  content bypass pattern - skip fix if pattern found
 */
tSCC zX11_ClassBypass0[] =
       "__cplusplus";

#define    X11_CLASS_TEST_CT  1
#define    X11_CLASS_RE_CT    1
tTestDesc aX11_ClassTests[] = {
  { TT_NEGREP, zX11_ClassBypass0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for X11_Class
 */
const char* apzX11_ClassPatch[] = { "sed",
    "-e", "/char \\*class;/i\\\n\
#ifdef __cplusplus\\\n\
\tchar *c_class;\\\n\
#else\n",
    "-e", "/char \\*class;/a\\\n\
#endif\n",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  95 - X11_Class_Usage fix
 */
tSCC zX11_Class_UsageName[] =
     "X11_Class_Usage";
/*
 *  File name selection pattern
 */
tSCC zX11_Class_UsageList[] =
  "|Xm/BaseClassI.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzX11_Class_UsageMachs (const char**)NULL

/*
 *  content bypass pattern - skip fix if pattern found
 */
tSCC zX11_Class_UsageBypass0[] =
       "__cplusplus";

#define    X11_CLASS_USAGE_TEST_CT  1
#define    X11_CLASS_USAGE_RE_CT    1
tTestDesc aX11_Class_UsageTests[] = {
  { TT_NEGREP, zX11_Class_UsageBypass0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for X11_Class_Usage
 */
const char* apzX11_Class_UsagePatch[] = { "sed",
    "-e", "s/ class[)]/ c_class)/g",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  96 - X11_New fix
 */
tSCC zX11_NewName[] =
     "X11_New";
/*
 *  File name selection pattern
 */
tSCC zX11_NewList[] =
  "|Xm/Traversal.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzX11_NewMachs (const char**)NULL

/*
 *  content bypass pattern - skip fix if pattern found
 */
tSCC zX11_NewBypass0[] =
       "__cplusplus";

#define    X11_NEW_TEST_CT  1
#define    X11_NEW_RE_CT    1
tTestDesc aX11_NewTests[] = {
  { TT_NEGREP, zX11_NewBypass0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for X11_New
 */
const char* apzX11_NewPatch[] = { "sed",
    "-e", "/Widget\told, new;/i\\\n\
#ifdef __cplusplus\\\n\
\tWidget\told, c_new;\\\n\
#else\n",
    "-e", "/Widget\told, new;/a\\\n\
#endif\n",
    "-e", "s/Widget new,/Widget c_new,/g",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  97 - X11_Sprintf fix
 */
tSCC zX11_SprintfName[] =
     "X11_Sprintf";
/*
 *  File name selection pattern
 */
tSCC zX11_SprintfList[] =
  "|X11*/Xmu.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzX11_SprintfMachs (const char**)NULL
#define X11_SPRINTF_TEST_CT  0
#define X11_SPRINTF_RE_CT    0
#define aX11_SprintfTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for X11_Sprintf
 */
const char* apzX11_SprintfPatch[] = { "sed",
    "-e", "s,^extern char \\*\tsprintf();$,#ifndef __STDC__\\\n\
extern char *\tsprintf();\\\n\
#endif /* !defined __STDC__ */,",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  98 - Zzz_Ki_Iface fix
 */
tSCC zZzz_Ki_IfaceName[] =
     "Zzz_Ki_Iface";
/*
 *  File name selection pattern
 */
tSCC zZzz_Ki_IfaceList[] =
  "|sys/ki_iface.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzZzz_Ki_IfaceMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zZzz_Ki_IfaceSelect0[] =
       "These definitions are for HP Internal developers";

#define    ZZZ_KI_IFACE_TEST_CT  1
#define    ZZZ_KI_IFACE_RE_CT    1
tTestDesc aZzz_Ki_IfaceTests[] = {
  { TT_EGREP,  zZzz_Ki_IfaceSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Zzz_Ki_Iface
 */
const char* apzZzz_Ki_IfacePatch[] = { "sh", "-c",
    "echo \"Removing incorrect fix to <$file>\" >&2\n\
rm -f ${DESTDIR}/$file ${DESTDIR}/fixinc.tmp\n\
cat > /dev/null",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description  99 - Zzz_Ki fix
 */
tSCC zZzz_KiName[] =
     "Zzz_Ki";
/*
 *  File name selection pattern
 */
tSCC zZzz_KiList[] =
  "|sys/ki.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzZzz_KiMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zZzz_KiSelect0[] =
       "11.00 HP-UX LP64";

#define    ZZZ_KI_TEST_CT  1
#define    ZZZ_KI_RE_CT    1
tTestDesc aZzz_KiTests[] = {
  { TT_EGREP,  zZzz_KiSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Zzz_Ki
 */
const char* apzZzz_KiPatch[] = { "sh", "-c",
    "echo \"Removing incorrect fix to <$file>\" >&2\n\
rm -f ${DESTDIR}/$file ${DESTDIR}/fixinc.tmp\n\
cat > /dev/null",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description 100 - Zzz_Ki_Calls fix
 */
tSCC zZzz_Ki_CallsName[] =
     "Zzz_Ki_Calls";
/*
 *  File name selection pattern
 */
tSCC zZzz_Ki_CallsList[] =
  "|sys/ki_calls.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzZzz_Ki_CallsMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zZzz_Ki_CallsSelect0[] =
       "kthread_create_caller_t";

#define    ZZZ_KI_CALLS_TEST_CT  1
#define    ZZZ_KI_CALLS_RE_CT    1
tTestDesc aZzz_Ki_CallsTests[] = {
  { TT_EGREP,  zZzz_Ki_CallsSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Zzz_Ki_Calls
 */
const char* apzZzz_Ki_CallsPatch[] = { "sh", "-c",
    "echo \"Removing incorrect fix to <$file>\" >&2\n\
rm -f ${DESTDIR}/$file ${DESTDIR}/fixinc.tmp\n\
cat > /dev/null",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description 101 - Zzz_Ki_Defs fix
 */
tSCC zZzz_Ki_DefsName[] =
     "Zzz_Ki_Defs";
/*
 *  File name selection pattern
 */
tSCC zZzz_Ki_DefsList[] =
  "|sys/ki_defs.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzZzz_Ki_DefsMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zZzz_Ki_DefsSelect0[] =
       "Kernel Instrumentation Definitions";

#define    ZZZ_KI_DEFS_TEST_CT  1
#define    ZZZ_KI_DEFS_RE_CT    1
tTestDesc aZzz_Ki_DefsTests[] = {
  { TT_EGREP,  zZzz_Ki_DefsSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Zzz_Ki_Defs
 */
const char* apzZzz_Ki_DefsPatch[] = { "sh", "-c",
    "echo \"Removing incorrect fix to <$file>\" >&2\n\
rm -f ${DESTDIR}/$file ${DESTDIR}/fixinc.tmp\n\
cat > /dev/null",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description 102 - Zzz_Bad_Fixes fix
 */
tSCC zZzz_Bad_FixesName[] =
     "Zzz_Bad_Fixes";
/*
 *  File name selection pattern
 */
tSCC zZzz_Bad_FixesList[] =
  "|sundev/ipi_error.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzZzz_Bad_FixesMachs (const char**)NULL
#define ZZZ_BAD_FIXES_TEST_CT  0
#define ZZZ_BAD_FIXES_RE_CT    0
#define aZzz_Bad_FixesTests   (tTestDesc*)NULL

/*
 *  Fix Command Arguments for Zzz_Bad_Fixes
 */
const char* apzZzz_Bad_FixesPatch[] = { "sh", "-c",
    "echo \"Removing incorrect fix to <$file>\" >&2\n\
rm -f ${DESTDIR}/$file ${DESTDIR}/fixinc.tmp\n\
cat > /dev/null",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Description 103 - Zzz_Time fix
 */
tSCC zZzz_TimeName[] =
     "Zzz_Time";
/*
 *  File name selection pattern
 */
tSCC zZzz_TimeList[] =
  "|sys/time.h|";
/*
 *  Machine/OS name selection pattern
 */
#define apzZzz_TimeMachs (const char**)NULL

/*
 *  content selection pattern - do fix if pattern found
 */
tSCC zZzz_TimeSelect0[] =
       "11.0 and later representation of ki time";

#define    ZZZ_TIME_TEST_CT  1
#define    ZZZ_TIME_RE_CT    1
tTestDesc aZzz_TimeTests[] = {
  { TT_EGREP,  zZzz_TimeSelect0,   (regex_t*)NULL }, };

/*
 *  Fix Command Arguments for Zzz_Time
 */
const char* apzZzz_TimePatch[] = { "sh", "-c",
    "echo \"Removing incorrect fix to <$file>\" >&2\n\
rm -f ${DESTDIR}/$file ${DESTDIR}/fixinc.tmp\n\
cat > /dev/null",
    (char*)NULL };

/* * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  List of all fixes
 */
#define  REGEX_COUNT  73
#define  FIX_COUNT    103
tFixDesc fixDescList[ FIX_COUNT ] = {
  {  zAix_SyswaitName,    zAix_SyswaitList,
     apzAix_SyswaitMachs, (regex_t*)NULL,
     AIX_SYSWAIT_TEST_CT, FD_MACH_ONLY,
     aAix_SyswaitTests,   apzAix_SyswaitPatch },

  {  zAix_VolatileName,    zAix_VolatileList,
     apzAix_VolatileMachs, (regex_t*)NULL,
     AIX_VOLATILE_TEST_CT, FD_MACH_ONLY,
     aAix_VolatileTests,   apzAix_VolatilePatch },

  {  zAlpha_GetoptName,    zAlpha_GetoptList,
     apzAlpha_GetoptMachs, (regex_t*)NULL,
     ALPHA_GETOPT_TEST_CT, FD_MACH_ONLY,
     aAlpha_GetoptTests,   apzAlpha_GetoptPatch },

  {  zAlpha_ParensName,    zAlpha_ParensList,
     apzAlpha_ParensMachs, (regex_t*)NULL,
     ALPHA_PARENS_TEST_CT, FD_MACH_ONLY,
     aAlpha_ParensTests,   apzAlpha_ParensPatch },

  {  zAlpha_SbrkName,    zAlpha_SbrkList,
     apzAlpha_SbrkMachs, (regex_t*)NULL,
     ALPHA_SBRK_TEST_CT, FD_MACH_ONLY,
     aAlpha_SbrkTests,   apzAlpha_SbrkPatch },

  {  zArm_Norcroft_HintName,    zArm_Norcroft_HintList,
     apzArm_Norcroft_HintMachs, (regex_t*)NULL,
     ARM_NORCROFT_HINT_TEST_CT, FD_MACH_ONLY,
     aArm_Norcroft_HintTests,   apzArm_Norcroft_HintPatch },

  {  zArm_WcharName,    zArm_WcharList,
     apzArm_WcharMachs, (regex_t*)NULL,
     ARM_WCHAR_TEST_CT, FD_MACH_ONLY,
     aArm_WcharTests,   apzArm_WcharPatch },

  {  zAux_AsmName,    zAux_AsmList,
     apzAux_AsmMachs, (regex_t*)NULL,
     AUX_ASM_TEST_CT, FD_MACH_ONLY,
     aAux_AsmTests,   apzAux_AsmPatch },

  {  zAvoid_BoolName,    zAvoid_BoolList,
     apzAvoid_BoolMachs, (regex_t*)NULL,
     AVOID_BOOL_TEST_CT, FD_MACH_ONLY,
     aAvoid_BoolTests,   apzAvoid_BoolPatch },

  {  zBad_Struct_TermName,    zBad_Struct_TermList,
     apzBad_Struct_TermMachs, (regex_t*)NULL,
     BAD_STRUCT_TERM_TEST_CT, FD_MACH_ONLY,
     aBad_Struct_TermTests,   apzBad_Struct_TermPatch },

  {  zBadquoteName,    zBadquoteList,
     apzBadquoteMachs, (regex_t*)NULL,
     BADQUOTE_TEST_CT, FD_MACH_ONLY,
     aBadquoteTests,   apzBadquotePatch },

  {  zBad_LvalName,    zBad_LvalList,
     apzBad_LvalMachs, (regex_t*)NULL,
     BAD_LVAL_TEST_CT, FD_MACH_ONLY,
     aBad_LvalTests,   apzBad_LvalPatch },

  {  zBroken_Assert_StdioName,    zBroken_Assert_StdioList,
     apzBroken_Assert_StdioMachs, (regex_t*)NULL,
     BROKEN_ASSERT_STDIO_TEST_CT, FD_MACH_ONLY,
     aBroken_Assert_StdioTests,   apzBroken_Assert_StdioPatch },

  {  zBroken_Assert_StdlibName,    zBroken_Assert_StdlibList,
     apzBroken_Assert_StdlibMachs, (regex_t*)NULL,
     BROKEN_ASSERT_STDLIB_TEST_CT, FD_MACH_ONLY,
     aBroken_Assert_StdlibTests,   apzBroken_Assert_StdlibPatch },

  {  zBsd43_Io_MacrosName,    zBsd43_Io_MacrosList,
     apzBsd43_Io_MacrosMachs, (regex_t*)NULL,
     BSD43_IO_MACROS_TEST_CT, FD_MACH_ONLY,
     aBsd43_Io_MacrosTests,   apzBsd43_Io_MacrosPatch },

  {  zDec_Intern_AsmName,    zDec_Intern_AsmList,
     apzDec_Intern_AsmMachs, (regex_t*)NULL,
     DEC_INTERN_ASM_TEST_CT, FD_MACH_ONLY,
     aDec_Intern_AsmTests,   apzDec_Intern_AsmPatch },

  {  zNo_Double_SlashName,    zNo_Double_SlashList,
     apzNo_Double_SlashMachs, (regex_t*)NULL,
     NO_DOUBLE_SLASH_TEST_CT, FD_MACH_ONLY,
     aNo_Double_SlashTests,   apzNo_Double_SlashPatch },

  {  zEcd_CursorName,    zEcd_CursorList,
     apzEcd_CursorMachs, (regex_t*)NULL,
     ECD_CURSOR_TEST_CT, FD_MACH_ONLY,
     aEcd_CursorTests,   apzEcd_CursorPatch },

  {  zSco5_Stat_WrappersName,    zSco5_Stat_WrappersList,
     apzSco5_Stat_WrappersMachs, (regex_t*)NULL,
     SCO5_STAT_WRAPPERS_TEST_CT, FD_MACH_ONLY,
     aSco5_Stat_WrappersTests,   apzSco5_Stat_WrappersPatch },

  {  zEnd_Else_LabelName,    zEnd_Else_LabelList,
     apzEnd_Else_LabelMachs, (regex_t*)NULL,
     END_ELSE_LABEL_TEST_CT, FD_MACH_ONLY,
     aEnd_Else_LabelTests,   apzEnd_Else_LabelPatch },

  {  zHp_InlineName,    zHp_InlineList,
     apzHp_InlineMachs, (regex_t*)NULL,
     HP_INLINE_TEST_CT, FD_MACH_ONLY,
     aHp_InlineTests,   apzHp_InlinePatch },

  {  zHp_SysfileName,    zHp_SysfileList,
     apzHp_SysfileMachs, (regex_t*)NULL,
     HP_SYSFILE_TEST_CT, FD_MACH_ONLY,
     aHp_SysfileTests,   apzHp_SysfilePatch },

  {  zCxx_UnreadyName,    zCxx_UnreadyList,
     apzCxx_UnreadyMachs, (regex_t*)NULL,
     CXX_UNREADY_TEST_CT, FD_MACH_ONLY,
     aCxx_UnreadyTests,   apzCxx_UnreadyPatch },

  {  zHpux_MaxintName,    zHpux_MaxintList,
     apzHpux_MaxintMachs, (regex_t*)NULL,
     HPUX_MAXINT_TEST_CT, FD_MACH_ONLY,
     aHpux_MaxintTests,   apzHpux_MaxintPatch },

  {  zHpux_SystimeName,    zHpux_SystimeList,
     apzHpux_SystimeMachs, (regex_t*)NULL,
     HPUX_SYSTIME_TEST_CT, FD_MACH_ONLY,
     aHpux_SystimeTests,   apzHpux_SystimePatch },

  {  zInteractv_Add1Name,    zInteractv_Add1List,
     apzInteractv_Add1Machs, (regex_t*)NULL,
     INTERACTV_ADD1_TEST_CT, FD_MACH_ONLY,
     aInteractv_Add1Tests,   apzInteractv_Add1Patch },

  {  zInteractv_Add2Name,    zInteractv_Add2List,
     apzInteractv_Add2Machs, (regex_t*)NULL,
     INTERACTV_ADD2_TEST_CT, FD_MACH_ONLY,
     aInteractv_Add2Tests,   apzInteractv_Add2Patch },

  {  zInteractv_Add3Name,    zInteractv_Add3List,
     apzInteractv_Add3Machs, (regex_t*)NULL,
     INTERACTV_ADD3_TEST_CT, FD_MACH_ONLY,
     aInteractv_Add3Tests,   apzInteractv_Add3Patch },

  {  zIo_Def_QuotesName,    zIo_Def_QuotesList,
     apzIo_Def_QuotesMachs, (regex_t*)NULL,
     IO_DEF_QUOTES_TEST_CT, FD_MACH_ONLY,
     aIo_Def_QuotesTests,   apzIo_Def_QuotesPatch },

  {  zIoctl_Fix_CtrlName,    zIoctl_Fix_CtrlList,
     apzIoctl_Fix_CtrlMachs, (regex_t*)NULL,
     IOCTL_FIX_CTRL_TEST_CT, FD_MACH_ONLY,
     aIoctl_Fix_CtrlTests,   apzIoctl_Fix_CtrlPatch },

  {  zIp_Missing_SemiName,    zIp_Missing_SemiList,
     apzIp_Missing_SemiMachs, (regex_t*)NULL,
     IP_MISSING_SEMI_TEST_CT, FD_MACH_ONLY,
     aIp_Missing_SemiTests,   apzIp_Missing_SemiPatch },

  {  zIrix_Multiline_CmntName,    zIrix_Multiline_CmntList,
     apzIrix_Multiline_CmntMachs, (regex_t*)NULL,
     IRIX_MULTILINE_CMNT_TEST_CT, FD_MACH_ONLY,
     aIrix_Multiline_CmntTests,   apzIrix_Multiline_CmntPatch },

  {  zIrix_SockaddrName,    zIrix_SockaddrList,
     apzIrix_SockaddrMachs, (regex_t*)NULL,
     IRIX_SOCKADDR_TEST_CT, FD_MACH_ONLY,
     aIrix_SockaddrTests,   apzIrix_SockaddrPatch },

  {  zIrix_Struct__FileName,    zIrix_Struct__FileList,
     apzIrix_Struct__FileMachs, (regex_t*)NULL,
     IRIX_STRUCT__FILE_TEST_CT, FD_MACH_ONLY,
     aIrix_Struct__FileTests,   apzIrix_Struct__FilePatch },

  {  zIsc_FmodName,    zIsc_FmodList,
     apzIsc_FmodMachs, (regex_t*)NULL,
     ISC_FMOD_TEST_CT, FD_MACH_ONLY,
     aIsc_FmodTests,   apzIsc_FmodPatch },

  {  zMotorola_NestedName,    zMotorola_NestedList,
     apzMotorola_NestedMachs, (regex_t*)NULL,
     MOTOROLA_NESTED_TEST_CT, FD_MACH_ONLY,
     aMotorola_NestedTests,   apzMotorola_NestedPatch },

  {  zIsc_Sys_LimitsName,    zIsc_Sys_LimitsList,
     apzIsc_Sys_LimitsMachs, (regex_t*)NULL,
     ISC_SYS_LIMITS_TEST_CT, FD_MACH_ONLY,
     aIsc_Sys_LimitsTests,   apzIsc_Sys_LimitsPatch },

  {  zKandr_ConcatName,    zKandr_ConcatList,
     apzKandr_ConcatMachs, (regex_t*)NULL,
     KANDR_CONCAT_TEST_CT, FD_MACH_ONLY,
     aKandr_ConcatTests,   apzKandr_ConcatPatch },

  {  zLimits_IfndefsName,    zLimits_IfndefsList,
     apzLimits_IfndefsMachs, (regex_t*)NULL,
     LIMITS_IFNDEFS_TEST_CT, FD_MACH_ONLY,
     aLimits_IfndefsTests,   apzLimits_IfndefsPatch },

  {  zLynx_Void_IntName,    zLynx_Void_IntList,
     apzLynx_Void_IntMachs, (regex_t*)NULL,
     LYNX_VOID_INT_TEST_CT, FD_MACH_ONLY,
     aLynx_Void_IntTests,   apzLynx_Void_IntPatch },

  {  zLynxos_Fcntl_ProtoName,    zLynxos_Fcntl_ProtoList,
     apzLynxos_Fcntl_ProtoMachs, (regex_t*)NULL,
     LYNXOS_FCNTL_PROTO_TEST_CT, FD_MACH_ONLY,
     aLynxos_Fcntl_ProtoTests,   apzLynxos_Fcntl_ProtoPatch },

  {  zM88k_Bad_Hypot_OptName,    zM88k_Bad_Hypot_OptList,
     apzM88k_Bad_Hypot_OptMachs, (regex_t*)NULL,
     M88K_BAD_HYPOT_OPT_TEST_CT, FD_MACH_ONLY,
     aM88k_Bad_Hypot_OptTests,   apzM88k_Bad_Hypot_OptPatch },

  {  zM88k_Bad_S_IfName,    zM88k_Bad_S_IfList,
     apzM88k_Bad_S_IfMachs, (regex_t*)NULL,
     M88K_BAD_S_IF_TEST_CT, FD_MACH_ONLY,
     aM88k_Bad_S_IfTests,   apzM88k_Bad_S_IfPatch },

  {  zM88k_Multi_InclName,    zM88k_Multi_InclList,
     apzM88k_Multi_InclMachs, (regex_t*)NULL,
     M88K_MULTI_INCL_TEST_CT, FD_MACH_ONLY | FD_SHELL_SCRIPT,
     aM88k_Multi_InclTests,   apzM88k_Multi_InclPatch },

  {  zMachine_NameName,    zMachine_NameList,
     apzMachine_NameMachs, (regex_t*)NULL,
     MACHINE_NAME_TEST_CT, FD_MACH_ONLY,
     aMachine_NameTests,   apzMachine_NamePatch },

  {  zMath_ExceptionName,    zMath_ExceptionList,
     apzMath_ExceptionMachs, (regex_t*)NULL,
     MATH_EXCEPTION_TEST_CT, FD_MACH_ONLY,
     aMath_ExceptionTests,   apzMath_ExceptionPatch },

  {  zMath_Gcc_IfndefsName,    zMath_Gcc_IfndefsList,
     apzMath_Gcc_IfndefsMachs, (regex_t*)NULL,
     MATH_GCC_IFNDEFS_TEST_CT, FD_MACH_ONLY | FD_SHELL_SCRIPT,
     aMath_Gcc_IfndefsTests,   apzMath_Gcc_IfndefsPatch },

  {  zNested_CommentName,    zNested_CommentList,
     apzNested_CommentMachs, (regex_t*)NULL,
     NESTED_COMMENT_TEST_CT, FD_MACH_ONLY,
     aNested_CommentTests,   apzNested_CommentPatch },

  {  zNews_Os_RecursionName,    zNews_Os_RecursionList,
     apzNews_Os_RecursionMachs, (regex_t*)NULL,
     NEWS_OS_RECURSION_TEST_CT, FD_MACH_ONLY,
     aNews_Os_RecursionTests,   apzNews_Os_RecursionPatch },

  {  zNext_Math_PrefixName,    zNext_Math_PrefixList,
     apzNext_Math_PrefixMachs, (regex_t*)NULL,
     NEXT_MATH_PREFIX_TEST_CT, FD_MACH_ONLY,
     aNext_Math_PrefixTests,   apzNext_Math_PrefixPatch },

  {  zNext_TemplateName,    zNext_TemplateList,
     apzNext_TemplateMachs, (regex_t*)NULL,
     NEXT_TEMPLATE_TEST_CT, FD_MACH_ONLY,
     aNext_TemplateTests,   apzNext_TemplatePatch },

  {  zNext_VolitileName,    zNext_VolitileList,
     apzNext_VolitileMachs, (regex_t*)NULL,
     NEXT_VOLITILE_TEST_CT, FD_MACH_ONLY,
     aNext_VolitileTests,   apzNext_VolitilePatch },

  {  zNext_Wait_UnionName,    zNext_Wait_UnionList,
     apzNext_Wait_UnionMachs, (regex_t*)NULL,
     NEXT_WAIT_UNION_TEST_CT, FD_MACH_ONLY,
     aNext_Wait_UnionTests,   apzNext_Wait_UnionPatch },

  {  zNodeent_SyntaxName,    zNodeent_SyntaxList,
     apzNodeent_SyntaxMachs, (regex_t*)NULL,
     NODEENT_SYNTAX_TEST_CT, FD_MACH_ONLY,
     aNodeent_SyntaxTests,   apzNodeent_SyntaxPatch },

  {  zOsf_Namespace_AName,    zOsf_Namespace_AList,
     apzOsf_Namespace_AMachs, (regex_t*)NULL,
     OSF_NAMESPACE_A_TEST_CT, FD_MACH_ONLY,
     aOsf_Namespace_ATests,   apzOsf_Namespace_APatch },

  {  zOsf_Namespace_BName,    zOsf_Namespace_BList,
     apzOsf_Namespace_BMachs, (regex_t*)NULL,
     OSF_NAMESPACE_B_TEST_CT, FD_MACH_ONLY,
     aOsf_Namespace_BTests,   apzOsf_Namespace_BPatch },

  {  zPthread_Page_SizeName,    zPthread_Page_SizeList,
     apzPthread_Page_SizeMachs, (regex_t*)NULL,
     PTHREAD_PAGE_SIZE_TEST_CT, FD_MACH_ONLY,
     aPthread_Page_SizeTests,   apzPthread_Page_SizePatch },

  {  zRs6000_DoubleName,    zRs6000_DoubleList,
     apzRs6000_DoubleMachs, (regex_t*)NULL,
     RS6000_DOUBLE_TEST_CT, FD_MACH_ONLY,
     aRs6000_DoubleTests,   apzRs6000_DoublePatch },

  {  zRs6000_FchmodName,    zRs6000_FchmodList,
     apzRs6000_FchmodMachs, (regex_t*)NULL,
     RS6000_FCHMOD_TEST_CT, FD_MACH_ONLY,
     aRs6000_FchmodTests,   apzRs6000_FchmodPatch },

  {  zRs6000_ParamName,    zRs6000_ParamList,
     apzRs6000_ParamMachs, (regex_t*)NULL,
     RS6000_PARAM_TEST_CT, FD_MACH_ONLY,
     aRs6000_ParamTests,   apzRs6000_ParamPatch },

  {  zSony_IncludeName,    zSony_IncludeList,
     apzSony_IncludeMachs, (regex_t*)NULL,
     SONY_INCLUDE_TEST_CT, FD_MACH_ONLY,
     aSony_IncludeTests,   apzSony_IncludePatch },

  {  zStatsswtchName,    zStatsswtchList,
     apzStatsswtchMachs, (regex_t*)NULL,
     STATSSWTCH_TEST_CT, FD_MACH_ONLY,
     aStatsswtchTests,   apzStatsswtchPatch },

  {  zStdio_Va_ListName,    zStdio_Va_ListList,
     apzStdio_Va_ListMachs, (regex_t*)NULL,
     STDIO_VA_LIST_TEST_CT, FD_MACH_ONLY | FD_SHELL_SCRIPT,
     aStdio_Va_ListTests,   apzStdio_Va_ListPatch },

  {  zSun_Bogus_IfdefName,    zSun_Bogus_IfdefList,
     apzSun_Bogus_IfdefMachs, (regex_t*)NULL,
     SUN_BOGUS_IFDEF_TEST_CT, FD_MACH_ONLY,
     aSun_Bogus_IfdefTests,   apzSun_Bogus_IfdefPatch },

  {  zSun_Bogus_Ifdef_Sun4cName,    zSun_Bogus_Ifdef_Sun4cList,
     apzSun_Bogus_Ifdef_Sun4cMachs, (regex_t*)NULL,
     SUN_BOGUS_IFDEF_SUN4C_TEST_CT, FD_MACH_ONLY,
     aSun_Bogus_Ifdef_Sun4cTests,   apzSun_Bogus_Ifdef_Sun4cPatch },

  {  zSun_CatmacroName,    zSun_CatmacroList,
     apzSun_CatmacroMachs, (regex_t*)NULL,
     SUN_CATMACRO_TEST_CT, FD_MACH_ONLY,
     aSun_CatmacroTests,   apzSun_CatmacroPatch },

  {  zSun_MallocName,    zSun_MallocList,
     apzSun_MallocMachs, (regex_t*)NULL,
     SUN_MALLOC_TEST_CT, FD_MACH_ONLY,
     aSun_MallocTests,   apzSun_MallocPatch },

  {  zSun_MemcpyName,    zSun_MemcpyList,
     apzSun_MemcpyMachs, (regex_t*)NULL,
     SUN_MEMCPY_TEST_CT, FD_MACH_ONLY,
     aSun_MemcpyTests,   apzSun_MemcpyPatch },

  {  zSun_Rusers_SemiName,    zSun_Rusers_SemiList,
     apzSun_Rusers_SemiMachs, (regex_t*)NULL,
     SUN_RUSERS_SEMI_TEST_CT, FD_MACH_ONLY,
     aSun_Rusers_SemiTests,   apzSun_Rusers_SemiPatch },

  {  zSun_SignalName,    zSun_SignalList,
     apzSun_SignalMachs, (regex_t*)NULL,
     SUN_SIGNAL_TEST_CT, FD_MACH_ONLY,
     aSun_SignalTests,   apzSun_SignalPatch },

  {  zSun_Auth_ProtoName,    zSun_Auth_ProtoList,
     apzSun_Auth_ProtoMachs, (regex_t*)NULL,
     SUN_AUTH_PROTO_TEST_CT, FD_MACH_ONLY,
     aSun_Auth_ProtoTests,   apzSun_Auth_ProtoPatch },

  {  zSunos_Matherr_DeclName,    zSunos_Matherr_DeclList,
     apzSunos_Matherr_DeclMachs, (regex_t*)NULL,
     SUNOS_MATHERR_DECL_TEST_CT, FD_MACH_ONLY,
     aSunos_Matherr_DeclTests,   apzSunos_Matherr_DeclPatch },

  {  zSunos_StrlenName,    zSunos_StrlenList,
     apzSunos_StrlenMachs, (regex_t*)NULL,
     SUNOS_STRLEN_TEST_CT, FD_MACH_ONLY,
     aSunos_StrlenTests,   apzSunos_StrlenPatch },

  {  zSystypesName,    zSystypesList,
     apzSystypesMachs, (regex_t*)NULL,
     SYSTYPES_TEST_CT, FD_MACH_ONLY,
     aSystypesTests,   apzSystypesPatch },

  {  zSystypes_For_AixName,    zSystypes_For_AixList,
     apzSystypes_For_AixMachs, (regex_t*)NULL,
     SYSTYPES_FOR_AIX_TEST_CT, FD_MACH_ONLY,
     aSystypes_For_AixTests,   apzSystypes_For_AixPatch },

  {  zSysv68_StringName,    zSysv68_StringList,
     apzSysv68_StringMachs, (regex_t*)NULL,
     SYSV68_STRING_TEST_CT, FD_MACH_ONLY,
     aSysv68_StringTests,   apzSysv68_StringPatch },

  {  zSysz_Stdlib_For_SunName,    zSysz_Stdlib_For_SunList,
     apzSysz_Stdlib_For_SunMachs, (regex_t*)NULL,
     SYSZ_STDLIB_FOR_SUN_TEST_CT, FD_MACH_ONLY,
     aSysz_Stdlib_For_SunTests,   apzSysz_Stdlib_For_SunPatch },

  {  zSysz_Stdtypes_For_SunName,    zSysz_Stdtypes_For_SunList,
     apzSysz_Stdtypes_For_SunMachs, (regex_t*)NULL,
     SYSZ_STDTYPES_FOR_SUN_TEST_CT, FD_MACH_ONLY,
     aSysz_Stdtypes_For_SunTests,   apzSysz_Stdtypes_For_SunPatch },

  {  zTinfo_CplusplusName,    zTinfo_CplusplusList,
     apzTinfo_CplusplusMachs, (regex_t*)NULL,
     TINFO_CPLUSPLUS_TEST_CT, FD_MACH_ONLY,
     aTinfo_CplusplusTests,   apzTinfo_CplusplusPatch },

  {  zUltrix_Ansi_CompatName,    zUltrix_Ansi_CompatList,
     apzUltrix_Ansi_CompatMachs, (regex_t*)NULL,
     ULTRIX_ANSI_COMPAT_TEST_CT, FD_MACH_ONLY,
     aUltrix_Ansi_CompatTests,   apzUltrix_Ansi_CompatPatch },

  {  zUltrix_Fix_FixprotoName,    zUltrix_Fix_FixprotoList,
     apzUltrix_Fix_FixprotoMachs, (regex_t*)NULL,
     ULTRIX_FIX_FIXPROTO_TEST_CT, FD_MACH_ONLY,
     aUltrix_Fix_FixprotoTests,   apzUltrix_Fix_FixprotoPatch },

  {  zUltrix_Atof_ParamName,    zUltrix_Atof_ParamList,
     apzUltrix_Atof_ParamMachs, (regex_t*)NULL,
     ULTRIX_ATOF_PARAM_TEST_CT, FD_MACH_ONLY,
     aUltrix_Atof_ParamTests,   apzUltrix_Atof_ParamPatch },

  {  zUltrix_ConstName,    zUltrix_ConstList,
     apzUltrix_ConstMachs, (regex_t*)NULL,
     ULTRIX_CONST_TEST_CT, FD_MACH_ONLY,
     aUltrix_ConstTests,   apzUltrix_ConstPatch },

  {  zUltrix_IfdefName,    zUltrix_IfdefList,
     apzUltrix_IfdefMachs, (regex_t*)NULL,
     ULTRIX_IFDEF_TEST_CT, FD_MACH_ONLY,
     aUltrix_IfdefTests,   apzUltrix_IfdefPatch },

  {  zUltrix_Nested_CmntName,    zUltrix_Nested_CmntList,
     apzUltrix_Nested_CmntMachs, (regex_t*)NULL,
     ULTRIX_NESTED_CMNT_TEST_CT, FD_MACH_ONLY,
     aUltrix_Nested_CmntTests,   apzUltrix_Nested_CmntPatch },

  {  zUltrix_StaticName,    zUltrix_StaticList,
     apzUltrix_StaticMachs, (regex_t*)NULL,
     ULTRIX_STATIC_TEST_CT, FD_MACH_ONLY,
     aUltrix_StaticTests,   apzUltrix_StaticPatch },

  {  zUndefine_NullName,    zUndefine_NullList,
     apzUndefine_NullMachs, (regex_t*)NULL,
     UNDEFINE_NULL_TEST_CT, FD_MACH_ONLY,
     aUndefine_NullTests,   apzUndefine_NullPatch },

  {  zVa_I960_MacroName,    zVa_I960_MacroList,
     apzVa_I960_MacroMachs, (regex_t*)NULL,
     VA_I960_MACRO_TEST_CT, FD_MACH_ONLY,
     aVa_I960_MacroTests,   apzVa_I960_MacroPatch },

  {  zVoid_NullName,    zVoid_NullList,
     apzVoid_NullMachs, (regex_t*)NULL,
     VOID_NULL_TEST_CT, FD_MACH_ONLY,
     aVoid_NullTests,   apzVoid_NullPatch },

  {  zVxworks_Gcc_ProblemName,    zVxworks_Gcc_ProblemList,
     apzVxworks_Gcc_ProblemMachs, (regex_t*)NULL,
     VXWORKS_GCC_PROBLEM_TEST_CT, FD_MACH_ONLY,
     aVxworks_Gcc_ProblemTests,   apzVxworks_Gcc_ProblemPatch },

  {  zVxworks_Needs_VxtypesName,    zVxworks_Needs_VxtypesList,
     apzVxworks_Needs_VxtypesMachs, (regex_t*)NULL,
     VXWORKS_NEEDS_VXTYPES_TEST_CT, FD_MACH_ONLY,
     aVxworks_Needs_VxtypesTests,   apzVxworks_Needs_VxtypesPatch },

  {  zVxworks_Needs_VxworksName,    zVxworks_Needs_VxworksList,
     apzVxworks_Needs_VxworksMachs, (regex_t*)NULL,
     VXWORKS_NEEDS_VXWORKS_TEST_CT, FD_MACH_ONLY,
     aVxworks_Needs_VxworksTests,   apzVxworks_Needs_VxworksPatch },

  {  zVxworks_TimeName,    zVxworks_TimeList,
     apzVxworks_TimeMachs, (regex_t*)NULL,
     VXWORKS_TIME_TEST_CT, FD_MACH_ONLY,
     aVxworks_TimeTests,   apzVxworks_TimePatch },

  {  zX11_ClassName,    zX11_ClassList,
     apzX11_ClassMachs, (regex_t*)NULL,
     X11_CLASS_TEST_CT, FD_MACH_ONLY,
     aX11_ClassTests,   apzX11_ClassPatch },

  {  zX11_Class_UsageName,    zX11_Class_UsageList,
     apzX11_Class_UsageMachs, (regex_t*)NULL,
     X11_CLASS_USAGE_TEST_CT, FD_MACH_ONLY,
     aX11_Class_UsageTests,   apzX11_Class_UsagePatch },

  {  zX11_NewName,    zX11_NewList,
     apzX11_NewMachs, (regex_t*)NULL,
     X11_NEW_TEST_CT, FD_MACH_ONLY,
     aX11_NewTests,   apzX11_NewPatch },

  {  zX11_SprintfName,    zX11_SprintfList,
     apzX11_SprintfMachs, (regex_t*)NULL,
     X11_SPRINTF_TEST_CT, FD_MACH_ONLY,
     aX11_SprintfTests,   apzX11_SprintfPatch },

  {  zZzz_Ki_IfaceName,    zZzz_Ki_IfaceList,
     apzZzz_Ki_IfaceMachs, (regex_t*)NULL,
     ZZZ_KI_IFACE_TEST_CT, FD_MACH_ONLY | FD_SHELL_SCRIPT,
     aZzz_Ki_IfaceTests,   apzZzz_Ki_IfacePatch },

  {  zZzz_KiName,    zZzz_KiList,
     apzZzz_KiMachs, (regex_t*)NULL,
     ZZZ_KI_TEST_CT, FD_MACH_ONLY | FD_SHELL_SCRIPT,
     aZzz_KiTests,   apzZzz_KiPatch },

  {  zZzz_Ki_CallsName,    zZzz_Ki_CallsList,
     apzZzz_Ki_CallsMachs, (regex_t*)NULL,
     ZZZ_KI_CALLS_TEST_CT, FD_MACH_ONLY | FD_SHELL_SCRIPT,
     aZzz_Ki_CallsTests,   apzZzz_Ki_CallsPatch },

  {  zZzz_Ki_DefsName,    zZzz_Ki_DefsList,
     apzZzz_Ki_DefsMachs, (regex_t*)NULL,
     ZZZ_KI_DEFS_TEST_CT, FD_MACH_ONLY | FD_SHELL_SCRIPT,
     aZzz_Ki_DefsTests,   apzZzz_Ki_DefsPatch },

  {  zZzz_Bad_FixesName,    zZzz_Bad_FixesList,
     apzZzz_Bad_FixesMachs, (regex_t*)NULL,
     ZZZ_BAD_FIXES_TEST_CT, FD_MACH_ONLY | FD_SHELL_SCRIPT,
     aZzz_Bad_FixesTests,   apzZzz_Bad_FixesPatch },

  {  zZzz_TimeName,    zZzz_TimeList,
     apzZzz_TimeMachs, (regex_t*)NULL,
     ZZZ_TIME_TEST_CT, FD_MACH_ONLY | FD_SHELL_SCRIPT,
     aZzz_TimeTests,   apzZzz_TimePatch }
};
