/**
 * Various string functions mainly used for controlling text output

 * Copyright (C) 2003  Shawn Betts
 * Copyright (C) 2004  Sylvain Beucler
 * Copyright (C) 1997, 1998, 1999, 2002, 2003  Seth A. Robinson

 * This file is part of GNU FreeDink

 * GNU FreeDink is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.

 * GNU FreeDink is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.

 * $Header: /cvsroot/dink/dink/src/string_util.c,v 1.3 2004/01/16 19:55:45 Beuc Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "functions.h"
#include "string_util.h"
#include "globals.h"

/**
 * Upcase the string
 */
void
strupper (char *s)
{
  for (; *s; s++)
    *s = toupper (*s);
}

/**
 * Downcase the string
 */
void
strdown (char *s)
{
  for (; *s; s++)
    *s = tolower (*s);
}

/*bool*/int
seperate_string (char str[255], int num, char liney, char *return1)
{
  int l;
  int k;

  l = 1;
  strcpy (return1, "");

  for (k = 0; k <= strlen (str); k++)
    {

      if (str[k] == liney)
	{
	  l++;
	  if (l == num + 1)
	    goto done;

	  if (k < strlen (str))
	    strcpy (return1, "");
	}
      if (str[k] != liney)
	sprintf (return1, "%s%c", return1, str[k]);
    }
  if (l < num)
    strcpy (return1, "");

  /* Take the \n and \r off it. */
  replace ("\r", "", return1);
  replace ("\n", "", return1);

  return (0);

done:

  if (l < num)
    strcpy (return1, "");

  /* Take the \n and \r off it. */
  replace ("\r", "", return1);
  replace ("\n", "", return1);

  /* Msg("Took %s and turned it to %s.",str, return1); */
  return (1);
}



void replace (const char *this1, char *that, char *line)
{

  char hold[500];
  char thisup[200], lineup[500];
  int u, i;
  int checker;

start:
  strcpy (hold, "");

  strcpy (lineup, line);
  strcpy (thisup, this1);

  strupper (lineup);
  strupper (thisup);
  if (strstr (lineup, thisup) == NULL)
    return;
  checker = -1;
  strcpy (hold, "");
  for (u = 0; u < strlen (line); u++)
    {
      if (checker > -1)
	{
	  if (toupper (line[u]) == toupper (this1[checker]))
	    {
	      if (checker + 1 == strlen (this1))
		{
		doit:
		  u = u - strlen (this1);
		  u++;
		  for (i = 0; i < u; i++)
		    hold[i] = line[i];
		  for (i = 0; i < strlen (that); i++)
		    hold[(u) + i] = that[i];
		  hold[strlen (that) + u] = 0;
		  for (i = 0; i < (strlen (line) - u) - strlen (this1); i++)
		    {
		      hold[(u + strlen (that)) + i] =
			line[(u + strlen (this1)) + i];
		    }
		  hold[(strlen (line) - strlen (this1)) + strlen (that)] = 0;
		  strcpy (line, hold);
		  goto start;
		}
	      checker++;
	    }
	  else
	    {
	      checker = -1;
	    }
	}
      if (checker == -1)
	{
	  if (toupper (line[u]) == toupper (this1[0]))
	    {

	      /* if (line[u] < 97) that[0] = toupper(that[0]); */
	      checker = 1;
	      if (strlen (this1) == 1)
		goto doit;
	    }
	}
    }
}






void
clear_talk (void)
{
  memset (&talk, 0, sizeof (talk));
  play.mouse = 0;
}



void
reverse (char *st)
{
  int i, ii;
  char don[255];

  don[0] = 0;
  ii = strlen (st);
  for (i = ii; i > -1; i--)
    {
      strchar (don, st[i]);
    }
  strcpy (st, don);
}


char *
lmon (long money, char *dest)
{
  char ho[30];
  int k, c;
  char lmon1[30];
  char buffer[30];
  /*BOOL*/int quit1;

  quit1 = 0;

  strcpy (lmon1, ltoa (money, buffer, 10));
  /* prf("ORG IS '%s'",lmon1); */

  if (strlen (lmon1) < 4)
    {
      strcpy (dest, lmon1);
      return (dest);
    }

  strcpy (ho, ltoa (money, buffer, 10));
  k = strlen (ho);
  c = -1;
  lmon1[0] = 0;
  do
    {
      strchar (lmon1, ho[k]);
      k--;
      c++;
      if (c == 3)
	{
	  if (k > -1)
	    {
	      strchar (lmon1, ',');
	      c = 0;
	    }
	}
      if (k < 0)
	quit1 = 1;
    }
  while (quit1 == 0);
  reverse (lmon1);

  strcpy (dest, lmon1);
  return (dest);
}


/**
 * Compare two strings ignoring case
 */
int
string_compare (char *s1, char *s2)
{
  while (*s1 && *s2 && toupper (*s1) == toupper (*s2))
    {
      s1++;
      s2++;
    }

  return *s1 - *s2;
}

/*bool*/int
compare (char *orig, char *comp)
{
  int len;

  /* strcpy(comp, _strupr(comp)); */
  /* strcpy(orig, _strupr(orig)); */

  len = strlen (comp);
  if (strlen (orig) != len)
    return (0);

  if (string_compare (orig, comp) == 0)
    {
      return (1);
    }
  /* Msg("I'm sorry, but %s does not equal %s.",orig, comp); */

  return (0);
}

/*bool*/int
exist (char name[255])
{
  FILE *fp;

  fp = fopen (name, "rb");
  if (!fp)
    {
      /* fclose(fp); */
      return (0);
    }

  fclose (fp);
  return (1);
}



void
add_text (char *tex, char *filename)
{
  FILE *fp;

  if (strlen (tex) < 1)
    return;

  if (exist (filename) == 0)
    {

      fp = fopen (filename, "wb");
      fwrite (tex, strlen (tex), 1, fp);	/* current player */
      fclose (fp);
      return;
    }
  else
    {
      fp = fopen (filename, "ab");
      fwrite (tex, strlen (tex), 1, fp);	/* current player */
      fclose (fp);
    }
}


/**
 * This acts in the same way as strcat except it combines a string and
 * a single character, updating the null at the end.
 */
void
strchar (char *string, char ch)
{
  int last;

  last = strlen (string);
  string[last] = ch;
  string[last + 1] = 0;

}

/*bool*/int
read_next_line (int script, char *line)
{
  int k;
  if ((rinfo[script] == NULL) || (rbuf == NULL))
    {

      Msg (("  ERROR:  Tried to read script %d, it doesn't exist.", script));
      return (0);
    }

  if (rinfo[script]->current >= rinfo[script]->end)
    {
      /* at end of buffer */
      return (0);
    }

/*   if (rinfo[script]->current < -1); */
/*   { */
/*     /\* something errored out, why did it go negetive? *\/ */
/*     return(0); */
/*   } */
     

  strcpy (line, "");

  for (k = rinfo[script]->current; (k < rinfo[script]->end); k++)
    {


      /* Msg(("..%d",k)); */
      strchar (line, rbuf[script][k]);
      rinfo[script]->current++;

      if ((rbuf[script][k] == '\n') || (rbuf[script][k] == '\r'))
	{
	  return (1);
	}

      if (rinfo[script]->current >= rinfo[script]->end)
	{
	  return (0);
	}

    }

  return (0);
}

void
strip_beginning_spaces (char *s)
{


  char *h;

  h = s;


  if (s[0] != 32)
    {
      return;
    }

  while (h[0] == 32)
    {
      h = &h[1];
    }


  strcpy (s, h);

}


/*bool*/int
locate (int script, char proc[20])
{
  int saveme;
  char line[200];
  char ev[3][100];
  char temp[100];


  if (rinfo[script] == NULL)
    {
      return (0);

    }
  saveme = rinfo[script]->current;

  rinfo[script]->current = 0;

  /* Msg(("locate is looking for %s in %s", proc, rinfo[script]->name)); */

  while (read_next_line (script, line))
    {
      strip_beginning_spaces (line);
/* ZeroMemory (&ev, sizeof (ev)); */
      memset (&ev, 0, sizeof (ev));

      get_word (line, 1, ev[1]);
      if (compare (ev[1], "VOID"))
	{
	  get_word (line, 2, ev[2]);

	  seperate_string (ev[2], 1, '(', temp);

	  /* Msg(("Found procedure %s.",temp)); */
	  if (compare (temp, proc))
	    {
	      /* Msg(("Located %s",proc)); */
	      /* clean up vars so it is ready to run */
	      if (rinfo[script]->sprite != 1000)
		{
		  spr[rinfo[script]->sprite].move_active = 0;

		}
	      rinfo[script]->skipnext = 0;
	      rinfo[script]->onlevel = 0;
	      rinfo[script]->level = 0;

	      return (1);
	      /* this is desired proc */

	    }
	}

    }

  /* Msg(("Locate ended on %d.", saveme)); */
  rinfo[script]->current = saveme;
  return (0);

}

/*bool*/int
locate_goto (char proc[50], int script)
{
  char line[200];
  char ev[3][100];
/* UNREFERENCED   char temp[100]; */
  rinfo[script]->current = 0;

  replace (";", "", proc);
  strchar (proc, ':');
  /* Msg(("locate is looking for %s", proc)); */

  while (read_next_line (script, line))
    {
      strip_beginning_spaces (line);

      get_word (line, 1, ev[1]);
      replace ("\n", "", ev[1]);

      if (compare (ev[1], proc))
	{
	  if (debug_mode)
	    Msg (("Found goto : Line is %s, word is %s.", line, ev[1]));

	  rinfo[script]->skipnext = 0;
	  rinfo[script]->onlevel = 0;
	  rinfo[script]->level = 0;


	  return (1);
	  /* this is desired proc */
	}

    }
  Msg (("ERROR:  Cannot goto %s in %s.", proc, rinfo[script]->name));
  return (0);

}


void
decipher (char *crap, int script)
{
  int i;

  if (compare (crap, "&current_sprite"))
    {

      sprintf (crap, "%d", rinfo[script]->sprite);
      /* Msg(("cur sprite returning %s, ",crap)); */
      return;
    }

  if (compare (crap, "&current_script"))
    {
      sprintf (crap, "%d", script);
      return;
    }





  for (i = 1; i < MAX_VARS; i++)
    {


      if (play.var[i].active == 1)
	if ((play.var[i].scope == 0) | (play.var[i].scope == script))
	  if (compare (play.var[i].name, crap))
	    {


	      sprintf (crap, "%d", play.var[i].var);
	      /* check_for_real_vars(crap, i); */

	      return;
	    }

    }


}

void
decipher_string (char line[200], int script)
{
  char crap[20];
  char buffer[20];
  char crab[100];
  int mytime;
  int i;

  for (i = 1; i < MAX_VARS; i++)
    {

      if (play.var[i].active == 1)
	if ((play.var[i].scope == 0) | (play.var[i].scope == script))
	  {
	    sprintf (crap, "%d", play.var[i].var);
	    replace (play.var[i].name, crap, line);
	    /* check_for_real_vars(crap, i); */


	  }

    }

  if ((strchr (line, '&') != NULL) && (script != 0))
    {
      replace ("&current_sprite", ltoa (rinfo[script]->sprite, buffer, 10),
	       line);
      replace ("&current_script", ltoa (script, buffer, 10), line);


      if (decipher_savegame != 0)
	{
	  if (play.button[decipher_savegame] == 1)
	    replace ("&buttoninfo", "Attack", line);
	  else if (play.button[decipher_savegame] == 2)
	    replace ("&buttoninfo", "Talk/Examine", line);
	  if (play.button[decipher_savegame] == 3)
	    replace ("&buttoninfo", "Magic", line);
	  if (play.button[decipher_savegame] == 4)
	    replace ("&buttoninfo", "Item Screen", line);
	  if (play.button[decipher_savegame] == 5)
	    replace ("&buttoninfo", "Main Menu", line);
	  if (play.button[decipher_savegame] == 6)
	    replace ("&buttoninfo", "Map", line);
	  if (play.button[decipher_savegame] == 7)
	    replace ("&buttoninfo", "Unused", line);
	  if (play.button[decipher_savegame] == 8)
	    replace ("&buttoninfo", "Unused", line);
	  if (play.button[decipher_savegame] == 9)
	    replace ("&buttoninfo", "Unused", line);
	  if (play.button[decipher_savegame] == 10)
	    replace ("&buttoninfo", "Unused", line);


	}

    }


  if (decipher_savegame != 0)
    if (compare (line, "&savegameinfo"))
      {
	sprintf (crap, "save%d.dat", decipher_savegame);
	if (exist (crap))
	  {
	    load_game_small (decipher_savegame, crab, &mytime);
	    sprintf (line, "Slot %d - %d:%d - %s", decipher_savegame,
		     (mytime / 60), mytime - ((mytime / 60) * 60), crab);
	    /* sprintf(line, "In Use"); */
	  }
	else
	  {

#ifdef __GERMAN
	    sprintf (line, "Slot %d - Ungebraucht", decipher_savegame);
#endif

#ifdef __ENGLISH
	    sprintf (line, "Slot %d - Empty", decipher_savegame);
#endif


	  }

      }


}



/*bool*/int
get_parms (char proc_name[20], int script, char *h, int p[10])
{
  char crap[100];
  int i;

  strip_beginning_spaces (h);
  if (h[0] == '(')
    {
      /* Msg(("Found first (.")); */
      h = &h[1];

    }
  else
    {
      Msg (("Missing ( in %s, offset %ld.", rinfo[script]->name,
	    rinfo[script]->current));


      return (0);
    }



  for (i = 0; i < 10; i++)
    {

      strip_beginning_spaces (h);


      if (p[i] == 1)
	{
	  /* Msg(("Checking for number..")); */


	  if (strchr (h, ',') != NULL)
	    seperate_string (h, 1, ',', crap);
	  else if (strchr (h, ')') != NULL)
	    seperate_string (h, 1, ')', crap);


	  h = &h[strlen (crap)];


	  if (crap[0] == '&')
	    {
	      replace (" ", "", crap);
	      /* Msg(("Found %s, 1st is %c",crap, crap[0])); */
	      decipher (crap, script);


	    }

	  nlist[i] = atol (crap);

	}
      else if (p[i] == 2)
	{
	  /* Msg(("Checking for string..")); */
	  seperate_string (h, 2, '"', crap);
	  h = &h[strlen (crap) + 2];

	  /* Msg(("Found %s",crap)); */
	  strcpy (slist[i], crap);

	}


      if (p[i + 1] == 0)
	{
	  /* finish */
	  strip_beginning_spaces (h);

	  if (h[0] == ')')
	    {
	      h = &h[1];
	    }
	  else
	    {

	      Msg (("Missing ) in %s, offset %ld.", rinfo[script]->name,
		    rinfo[script]->current));
	      h = &h[1];

	      return (0);
	    }

	  strip_beginning_spaces (h);

	  if (h[0] == ';')
	    {
	      /* Msg(("Found ending ;")); */
	      h = &h[1];

	    }
	  else
	    {
	      /* Msg(("Missing ; in %s, offset %d.", rinfo[script]->name, rinfo[script]->current)); */
	      /* h = &h[1]; */

	      return (1);
	    }





	  return (1);
	}

      /* got a parm, but there is more to get, lets make sure there is a comma there */
      strip_beginning_spaces (h);

      if (h[0] == ',')
	{
	  /* Msg(("Found expected ,")); */
	  h = &h[1];

	}
      else
	{
	  Msg (("Procedure %s does not take %d parms in %s, offset %ld. (%s?)",
		proc_name, i + 1, rinfo[script]->name, rinfo[script]->current,
		h));

	  return (0);
	}

    }


  return (1);
}
