;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT -*-
;;;_____________________________________________________________________________
;;;
;;;                       System: XIT
;;;                       Module: SIMPLE SOUNDS
;;;                       Version: 1.0
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/kernel/simple-sounds.lisp
;;; File Creation Date: 05/21/91 17:32:19
;;; Last Modification Time: 06/11/91 13:17:55
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;;_____________________________________________________________________________

(in-package :xlib)

(defvar *same-host-p* t) ; to be moved to system file

(defparameter *sound-directory* '("." "/usr/demo/SOUND/sounds/")) ; to be moved to system file

(defparameter *sound-extensions* '("au")) ; to be moved to system file

(defun init-sound-for-display (display)
  ; to be called whenever a display-connection is opened
  (declare (special *same-host-p*))
  (setq *same-host-p* (string= (display-host display) (system:getenv "HOST"))))

(defun display-host-name ()
  ; this function has to be adapted to the underlying system
  #+clue
  clue::*default-host*)

(defun find-file (filename directory extensions)
  (let (foundpath dirpath)
      (dolist (dir (if (listp directory)
		       directory
		     (list directory)))
	(setq dirpath (make-pathname :name filename
				     :type "dummy"
				     :defaults dir))
	(dolist (extension extensions)
	  (when (setq foundpath
		    (probe-file
		     (make-pathname :type extension
				    :defaults dirpath)))
	    (return-from find-file foundpath)))))
  nil)

(defun find-sound-file (filename)
  (declare (special *sound-directory* *sound-extensions*))
  (find-file filename *sound-directory* *sound-extensions*))

(defun play-sound (sound)
  (declare (special *same-host-p*))
  (let ((sound-file (find-sound-file sound)))
    (when sound-file
      (let ((command-string (format nil "cat ~S > /dev/audio"
				    (namestring sound-file))))
	(unless *same-host-p*
	  (setq command-string
	      (format nil "rsh ~S ~S" (display-host-name) command-string)))
    #+excl
    (excl::run-shell-command
	   command-string
	   :wait t)))))
  