/* LocaleInformation_mn.java --
   Copyright (C) 2005  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_mn extends ListResourceBundle
{
  private static final String[] shortMonths = {
    "\u0445\u0443\u043b",
    "\u04af\u0445\u044d",
    "\u0431\u0430\u0440",
    "\u0442\u0443\u0443",
    "\u043b\u0443\u0443",
    "\u043c\u043e\u0433",
    "\u043c\u043e\u0440",
    "\u0445\u043e\u043d",
    "\u0431\u0438\u0447",
    "\u0442\u0430\u0445",
    "\u043d\u043e\u0445",
    "\u0433\u0430\u0445",
    null,
  };

  private static final String[] months = {
    "\u0425\u0443\u043b\u0433\u0430\u043d\u0430",
    "\u04ae\u0445\u044d\u0440",
    "\u0411\u0430\u0440",
    "\u0422\u0443\u0443\u043b\u0430\u0439",
    "\u041b\u0443\u0443",
    "\u041c\u043e\u0433\u043e\u0439",
    "\u041c\u043e\u0440\u044c",
    "\u0425\u043e\u043d\u044c",
    "\u0411\u0438\u0447",
    "\u0422\u0430\u0445\u0438\u0430",
    "\u041d\u043e\u0445\u043e\u0439",
    "\u0413\u0430\u0445\u0430\u0439",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "\u041d\u044f",
    "\u0414\u0430",
    "\u041c\u044f",
    "\u041b\u0445",
    "\u041f\u04af",
    "\u0411\u0430",
    "\u0411\u044f",
  };

  private static final String[] weekdays = {
    null,
    "\u043d\u044f\u043c",
    "\u0434\u0430\u0432\u0430\u0430",
    "\u043c\u044f\u0433\u043c\u0430\u0440",
    "\u043b\u0445\u0430\u0433\u0432\u0430",
    "\u043f\u04af\u0440\u044d\u0432",
    "\u0431\u0430\u0430\u0441\u0430\u043d",
    "\u0431\u044f\u043c\u0431\u0430",
  };

  private static final String[] eras = {
    "\u043c.\u044d.\u04e9",
    "\u043c.\u044d.",
  };

  private static final String[] ampms = {
    "AM",
    "PM",
  };

  private static final String territoriesKeys = "MN";

  private static final String territoriesValues = "\u041c\u043e\u043d\u0433\u043e\u043b \u0443\u043b\u0441";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(territoriesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "mn";

  private static final String languagesValues = "\u041c\u043e\u043d\u0433\u043e\u043b \u0445\u044d\u043b";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(languagesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "\u00a0" },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "minNumberOfDaysInFirstWeek", "4" },
    { "firstDayOfWeek", "mon" },
    { "eras", eras },
    { "ampms", ampms },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
