/* define neccsary constants/contructs for CGI scripts
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

/* ==================================================================== */


#ifndef   CAPA_CGI_H
#define   CAPA_CGI_H

#ifdef CAPA_ARG
#undef CAPA_ARG
#define CAPA_ARG(x)  x
#endif

/*
 #ifdef __STDC__
 #define CAPA_ARG(x)  x
 #else
 #define CAPA_ARG(x)  ()
 #endif
*/

#ifdef   _MAIN_PROGRAM_

#define  GLOBAL_VAR(xx)   xx
#else 
#define  GLOBAL_VAR(xx)   extern  xx
#endif


#define   MAX_ENTRIES                 10000    /* maximal number of entries in a web page form */
#define   DEFAULT_STATUS_LINE_LENGTH  50
#define   MAX_PROBLEM_CNT             1024
#define   MAX_ANSWER_CHAR             32
#define   MAX_CLASS_CHAR              16       /* officially, it is 8, since the account name won't allow */
                                      /* more than 8 characters. */

                                     /* ----------------------------- various mode used in print_quizz() */
#define   TRY_SET_MODE        1
#define   CHECK_ANSWER_MODE   2
#define   VIEW_PREVIOUS_MODE  3


#define   TEXT_BUF_SIZE      1
/*(128*1024)*/
#define   STATUS_BUF_SIZE    1
/*(32*1024)*/

typedef struct _form_entry {
    char *name;
    char *val;
} FormEntry_t;

typedef struct _student_answer {
    int                       a_idx;
    char                     *a_str;
    struct _student_answer   *a_next;
} StudentAnswer_t;

#define     M_CHECKIN         1
#define     M_TRYSET          2
#define     M_CHECKANS        3
#define     M_VIEWPREV        4
#define     M_VIEWSUMM        5
#define     M_EXAMSUMM        6
#define     M_QUIZSUMM        7
#define     M_TERMSCORE       8
#define     LF                10
#define     CR                13


/* --------- default parameter values when something mis-specified in capa.config -------- */

#define     DEFAULT_HW_W          0.3
#define     DEFAULT_QZ_W          0.07
#define     DEFAULT_EX_W          0.3
#define     DEFAULT_FE_W          0.35
#define     DEFAULT_PC_W          0.3
#define     DEFAULT_HW_COUNT      12
#define     DEFAULT_QZ_COUNT      24
#define     DEFAULT_FE_NUMBER     4
#define     DEFAULT_WIDTH        600 /* for score extrapolation applet*/
#define     DEFAULT_HEIGHT       750 /* for score extrapolation applet*/
/* ============ function prototype in capaCgiUtils.c ===================== */

void        getword            CAPA_ARG((char *word, char *line, char stop));
char       *makeword           CAPA_ARG((char *line, char stop));
char       *fmakeword          CAPA_ARG((FILE *f, char stop, int *cl));
char        x2c                CAPA_ARG((char *what));
void        unescape_url       CAPA_ARG((char *url));
void        plustospace        CAPA_ARG((char *str));
int         rind               CAPA_ARG((char *s, char c));
int         getline            CAPA_ARG((char *s, int n, FILE *f));
void        send_fd            CAPA_ARG((FILE *f, FILE *fd));
int         ind                CAPA_ARG((char *s, char c));
void        escape_shell_cmd   CAPA_ARG((char *cmd));

int         web_log            CAPA_ARG((char *log_str));
/*
void        file_log           CAPA_ARG((char *filename, char *log_str));
*/
int         w_log_timing       CAPA_ARG((char *student_number,int set,int section,char *log_string));
int         w_log_attempt      CAPA_ARG((char *student_number,int set,char *log_string));
int         w_log_submissions  CAPA_ARG((char *student_number,int set,char *log_string));
int         w_get_input        CAPA_ARG(());
void        print_mainmenu     CAPA_ARG((char *class,char *sn, int pin));
void        print_page_header  CAPA_ARG((int mode,int num_quest));
void        print_quizz        CAPA_ARG((char *class_dir, char *c_owner,char *class,char *sn,int pin,int set,int mode));
void        print_response     CAPA_ARG((char pcr,char u_db,int q_idx,Problem_t *p));
void        print_inhibited_response CAPA_ARG((char pcr,char u_db,int q_idx,Problem_t *p));
void        check_user_ans     CAPA_ARG((int q_idx,Problem_t *p));
void        check_inhibited_user_ans     CAPA_ARG((int q_idx,Problem_t *p));
void        get_response       CAPA_ARG((char pcr,char u_db,int q_idx,Problem_t *p));
void        log_user_ans       CAPA_ARG((int q_idx,Problem_t *p));
int         check_class_get_maxset CAPA_ARG((char  *dir_path));
int         check_exam_quiz_path CAPA_ARG(());
void        print_summary  CAPA_ARG((char *class_dir,char *class, char *student_number,int pin,int set)); 
void        print_termscore_page  CAPA_ARG((char *class_dir,char *class, char *student_number,int pin,int set,FILE *out)); 
void        get_tscore_width_height CAPA_ARG((int *width,int *height));
int         get_termscore_params CAPA_ARG((float *hw,float *qw,float *ew,float *fw,float *pw,int *hc,int *qc,int *fs));
int         web_getclassdir  CAPA_ARG((char **cpath_p, char **cown_p, char *class));
char       *c_getpath        CAPA_ARG((FILE *f));
void        append_qtext     CAPA_ARG((char *new_str));
void        append_stext     CAPA_ARG((char *new_str));
void        process_mode     CAPA_ARG((int  mode));
void        process_summary  CAPA_ARG((int mode));
void        web_printheader  CAPA_ARG((FILE*));
void        web_printfooter  CAPA_ARG((FILE*));
void        preserve_last_answer CAPA_ARG((int q_idx,int print));
/* ======================================================================= */
GLOBAL_VAR(char           *g_question_txt);
GLOBAL_VAR(int             g_qchar_cnt);
GLOBAL_VAR(int             g_qsize);
GLOBAL_VAR(char           *g_status_txt);
GLOBAL_VAR(int             g_schar_cnt);
GLOBAL_VAR(int             g_ssize);
GLOBAL_VAR(int             g_run_mode);
GLOBAL_VAR(int             g_start_question);
#define ALL_QUESTIONS -1
GLOBAL_VAR(int             g_num_questions_per_page);
GLOBAL_VAR(int             g_inhibit_response);
GLOBAL_VAR(char            g_prog_name[FILE_NAME_LENGTH]);
GLOBAL_VAR(char            g_class_fullpath[FILE_NAME_LENGTH]);
GLOBAL_VAR(FormEntry_t     g_entries[MAX_ENTRIES] );
GLOBAL_VAR(char            g_student_number[MAX_STUDENT_NUMBER+4]);
GLOBAL_VAR(char            g_student_name[MAX_NAME_CHAR+1]);
GLOBAL_VAR(T_student       g_student_data);
GLOBAL_VAR(char            g_class_name[MAX_CLASS_CHAR]);
GLOBAL_VAR(char            g_class_fullpath[FILE_NAME_LENGTH]);
GLOBAL_VAR(char           *g_cpath);
GLOBAL_VAR(char           *g_cowner);
GLOBAL_VAR(int             g_entered_pin);
GLOBAL_VAR(int             g_login_set);
GLOBAL_VAR(int             g_set);
GLOBAL_VAR(int             g_vset);
GLOBAL_VAR(StudentAnswer_t *g_stu_ans_pp[MAX_PROBLEM_CNT]);
GLOBAL_VAR(StudentAnswer_t *g_last_ans_pp[MAX_PROBLEM_CNT]);
/*GLOBAL_VAR(char           *g_student_answer[MAX_PROBLEM_CNT]);
  GLOBAL_VAR(char           *g_last_answer[MAX_PROBLEM_CNT]);*/
GLOBAL_VAR(char            g_new_answerdb[MAX_PROBLEM_CNT]);
GLOBAL_VAR(char            g_log_string[MAX_PROBLEM_CNT]);
GLOBAL_VAR(int             g_modified[MAX_PROBLEM_CNT]);
GLOBAL_VAR(int             g_passdue);
GLOBAL_VAR(int             g_tried[MAX_PROBLEM_CNT]);
GLOBAL_VAR(int             g_smode);
GLOBAL_VAR(int             g_skind);
GLOBAL_VAR(char            g_cwd[FILE_NAME_LENGTH]);
#ifdef __alpha 
GLOBAL_VAR(struct timespec g_ats);
GLOBAL_VAR(struct timespec g_bts);
#endif
GLOBAL_VAR(FILE           *g_cgi);
GLOBAL_VAR(int             g_exam_set);
GLOBAL_VAR(int             g_quiz_set);
GLOBAL_VAR(char            g_exam_path[FILE_NAME_LENGTH]);
GLOBAL_VAR(char            g_quiz_path[FILE_NAME_LENGTH]);
GLOBAL_VAR(char           *g_cgibin_path);
/* ======================================================================= */


#endif   /* CAPA_CGI_H */

