/*
   This file is part of TALER
   Copyright (C) 2024 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_lookup_donau_keys.c
 * @brief Implementation of the lookup_donau_keys function for Postgres
 * @author Bohdan Potuzhnyi
 * @author Vlada Svirsh
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "donau/donau_service.h"
#include "pg_lookup_donau_keys.h"
#include "pg_helper.h"

enum GNUNET_DB_QueryStatus
TMH_PG_lookup_donau_keys (void *cls,
                          const char *donau_url,
                          struct GNUNET_TIME_Absolute *first_retry,
                          struct DONAU_Keys **keys)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_string (donau_url),
    GNUNET_PQ_query_param_end
  };
  json_t *jkeys;
  struct GNUNET_PQ_ResultSpec rs[] = {
    GNUNET_PQ_result_spec_absolute_time ("first_retry",
                                         first_retry),
    TALER_PQ_result_spec_json ("keys_json",
                               &jkeys),
    GNUNET_PQ_result_spec_end
  };
  enum GNUNET_DB_QueryStatus qs;

  check_connection (pg);
  PREPARE (pg,
           "lookup_donau_keys",
           "SELECT"
           " first_retry"
           ",keys_json"
           " FROM merchant_donau_keys"
           " WHERE donau_url=$1;");
  qs = GNUNET_PQ_eval_prepared_singleton_select (pg->conn,
                                                 "lookup_donau_keys",
                                                 params,
                                                 rs);
  if (qs <= 0)
    return qs;
  *keys = DONAU_keys_from_json (jkeys);
  json_decref (jkeys);
  if (NULL == *keys)
  {
    GNUNET_break (0);
    return GNUNET_DB_STATUS_HARD_ERROR;
  }
  return qs;
}