/* This code is machine-generated.  See its source for license
   information. This software is derived from software
   distributed under the GNU GPL version 3 or later. */

/* User-specified code, initial vm1 part: beginning. */

/* User-specified code, initial vm1 part: end */

/* VM library: main VM C file template.

   Copyright (C) 2016, 2017, 2018, 2019, 2020 Luca Saiu
   Written by Luca Saiu

   This file is part of Jitter.

   Jitter is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   Jitter is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jitter.  If not, see <http://www.gnu.org/licenses/>. */


/* Generated file warning.
 * ************************************************************************** */

/* Unless this file is named exactly "vm1.c" , without any prefix, you are
   looking at a machine-generated derived file.  The original source is the vm.c
   template from Jitter, with added code implementing the structuredvm VM. */




#include <assert.h>
#include <string.h>

#include <jitter/jitter.h>

#if defined (JITTER_PROFILE_SAMPLE)
#include <sys/time.h>
#endif // #if defined (JITTER_PROFILE_SAMPLE)

#include <jitter/jitter-hash.h>
#include <jitter/jitter-instruction.h>
#include <jitter/jitter-mmap.h>
#include <jitter/jitter-mutable-routine.h>
#include <jitter/jitter-print.h>
#include <jitter/jitter-rewrite.h>
#include <jitter/jitter-routine.h>
#include <jitter/jitter-routine-parser.h>
#include <jitter/jitter-specialize.h>
#include <jitter/jitter-defect.h>
#include <jitter/jitter-patch-in.h>

/* I don't need to include <jitter/jitter-executor.h> here, nor to define
   JITTER_THIS_CAN_INCLUDE_JITTER_EXECUTOR_H ; doing so carelessly might
   lead to subtle bugs, that it is better to prevent.
   Of course I can reconsider this decision in the future. */

#include <jitter/jitter-data-locations.h>

#include "structuredvm-vm.h"
//#include "structuredvm-specialized-instructions.h"
//#include "structuredvm-meta-instructions.h"
#include <jitter/jitter-fatal.h>




/* Check requirements for particular features.
 * ************************************************************************** */

/* VM sample-profiling is only supported with GCC.  Do not bother activating it
   with other compilers, if the numbers are unreliable in the end. */
#if  defined (JITTER_PROFILE_SAMPLE)        \
     && ! defined (JITTER_HAVE_ACTUAL_GCC)
# error "Sample-profiling is only reliable with GCC: it requires (machine-independent)"
# error "GNU C extended asm, and it is not worth supporting other compilers if"
# error "the numbers turn out to be unreliable in the end."
#endif




/* Machine-generated data structures.
 * ************************************************************************** */

/* Machine-generated data structures defining this VM.  Initializing a static
   struct is problematic, as it requires constant expressions for each field --
   and const pointers don't qualify.  This is why we initialize the struct
   fields below in structuredvm_initialize. */
static struct jitter_vm
the_structuredvm_vm;

struct jitter_vm * const
structuredvm_vm = & the_structuredvm_vm;

struct jitter_list_header * const
structuredvm_states = & the_structuredvm_vm.states;

/* It is convenient to have this initialised at start up, even before calling
   any initialisation function.  This makes it reliable to read this when, for
   example, handling --version . */
static const struct jitter_vm_configuration
structuredvm_vm_the_configuration
  = {
      STRUCTUREDVM_LOWER_CASE_PREFIX /* lower_case_prefix */,
      STRUCTUREDVM_UPPER_CASE_PREFIX /* upper_case_prefix */,
      STRUCTUREDVM_MAX_FAST_REGISTER_NO_PER_CLASS
        /* max_fast_register_no_per_class */,
      STRUCTUREDVM_MAX_NONRESIDUAL_LITERAL_NO /* max_nonresidual_literal_no */,
      STRUCTUREDVM_DISPATCH_HUMAN_READABLE /* dispatch_human_readable */,
      /* The instrumentation field can be seen as a bit map.  See the comment
         in jitter/jitter-vm.h . */
      (jitter_vm_instrumentation_none
#if defined (JITTER_PROFILE_COUNT)
       | jitter_vm_instrumentation_count
#endif
#if defined (JITTER_PROFILE_SAMPLE)
       | jitter_vm_instrumentation_sample
#endif
       ) /* instrumentation */
    };

const struct jitter_vm_configuration * const
structuredvm_vm_configuration
  = & structuredvm_vm_the_configuration;




/* Initialization and finalization: internal functions, not for the user.
 * ************************************************************************** */

/* Initialize threads.  This only needs to be called once at initialization, and
   the user doesn't need to bother with it.  Defined along with the executor. */
void
structuredvm_initialize_threads (void);

/* Check that the encodings in enum jitter_specialized_instruction_opcode (as
   used in the specializer) are coherent with machine-generated code.  Making a
   mistake here would introduce subtle bugs, so it's better to be defensive. */
static void
structuredvm_check_specialized_instruction_opcode_once (void)
{
  static bool already_checked = false;
  if (already_checked)
    return;

  assert (((enum jitter_specialized_instruction_opcode)
           structuredvm_specialized_instruction_opcode__eINVALID)
          == jitter_specialized_instruction_opcode_INVALID);
  assert (((enum jitter_specialized_instruction_opcode)
           structuredvm_specialized_instruction_opcode__eBEGINBASICBLOCK)
          == jitter_specialized_instruction_opcode_BEGINBASICBLOCK);
  assert (((enum jitter_specialized_instruction_opcode)
           structuredvm_specialized_instruction_opcode__eEXITVM)
          == jitter_specialized_instruction_opcode_EXITVM);
  assert (((enum jitter_specialized_instruction_opcode)
           structuredvm_specialized_instruction_opcode__eDATALOCATIONS)
          == jitter_specialized_instruction_opcode_DATALOCATIONS);
  assert (((enum jitter_specialized_instruction_opcode)
           structuredvm_specialized_instruction_opcode__eNOP)
          == jitter_specialized_instruction_opcode_NOP);
  assert (((enum jitter_specialized_instruction_opcode)
           structuredvm_specialized_instruction_opcode__eUNREACHABLE0)
          == jitter_specialized_instruction_opcode_UNREACHABLE0);
  assert (((enum jitter_specialized_instruction_opcode)
           structuredvm_specialized_instruction_opcode__eUNREACHABLE1)
          == jitter_specialized_instruction_opcode_UNREACHABLE1);
  assert (((enum jitter_specialized_instruction_opcode)
           structuredvm_specialized_instruction_opcode__eUNREACHABLE2)
          == jitter_specialized_instruction_opcode_UNREACHABLE2);

  already_checked = true;
}

/* A prototype for a machine-generated function not needing a public
   declaration, only called thru a pointer within struct jitter_vm . */
int
structuredvm_specialize_instruction (struct jitter_mutable_routine *p,
                                 const struct jitter_instruction *ins);

/* Initialize the pointed special-purpose data structure. */
static void
structuredvm_initialize_special_purpose_data
   (volatile struct jitter_special_purpose_state_data *d)
{
  d->pending_notifications = 0;
  jitter_initialize_pending_signal_notifications
     (& d->pending_signal_notifications);

  /* Initialise profiling fields. */
  jitter_profile_runtime_initialize (structuredvm_vm,
                                     (struct jitter_profile_runtime *)
                                     & d->profile_runtime);
}

/* Finalize the pointed special-purpose data structure. */
static void
structuredvm_finalize_special_purpose_data
   (volatile struct jitter_special_purpose_state_data *d)
{
  jitter_finalize_pending_signal_notifications
     (d->pending_signal_notifications);

  jitter_profile_runtime_finalize (structuredvm_vm,
                                   (struct jitter_profile_runtime *)
                                   & d->profile_runtime);
}




/* Check that we link with the correct Jitter library.
 * ************************************************************************** */

/* It is possible to make a mistake at link time, and link a VM compiled with
   some threading model with the Jitter runtime for a different model.  That
   would cause crashes, that is better to prevent.  This is a way to detect such
   mistakes very early, by causing a link-time failure in case of mismatch. */
extern volatile const bool
JITTER_DISPATCH_DEPENDENT_GLOBAL_NAME;




/* Low-level debugging features relying on assembly: data locations.
 * ************************************************************************** */

#if defined (JITTER_HAVE_KNOWN_BINARY_FORMAT) && ! defined (JITTER_DISPATCH_SWITCH)
/* A declaration for data locations, as visible from C.  The global is defined in
   assembly in its own separate section thru the machinery in
   jitter/jitter-sections.h . */
extern const char
JITTER_DATA_LOCATION_NAME(structuredvm) [];
#endif // #if ...

void
structuredvm_dump_data_locations (jitter_print_context output)
{
#ifndef JITTER_DISPATCH_SWITCH
  jitter_dump_data_locations (output, & the_structuredvm_vm);
#else
  jitter_print_char_star (output,
                          "VM data location information unavailable\n");
#endif // #ifndef JITTER_DISPATCH_SWITCH
}




/* Initialization and finalization.
 * ************************************************************************** */

#ifdef JITTER_HAVE_PATCH_IN
JITTER_DEFECT_DESCRIPTOR_DECLARATIONS_(structuredvm)
JITTER_PATCH_IN_DESCRIPTOR_DECLARATIONS_(structuredvm)
#endif // #ifdef JITTER_HAVE_PATCH_IN

#ifndef JITTER_DISPATCH_SWITCH
/* True iff thread sizes are all non-negative and non-huge.  We refuse to
   disassemble otherwise, and when replication is enabled we refuse to run
   altogether.  See the comment right below. */
static bool
structuredvm_threads_validated = false;
#endif // #ifndef JITTER_DISPATCH_SWITCH

/* Omit structuredvm_validate_thread_sizes_once for switch-dispatching, as threads
   don't exist at all in that case.*/
#ifndef JITTER_DISPATCH_SWITCH
/* Check that VM instruction sizes are all non-negative, and that no thread
   starts before the end of the previous one.  Even one violation of such
   conditions is a symptom that the code has not been compiled with
   -fno-reorder-blocks , which would have disastrous effects with replication.
   It's better to validate threads at startup and fail immediately than to crash
   at run time.

   If even one thread appears to be wrong then refuse to disassemble when
   replication is disabled, and refuse to run altogether if replication is
   enabled. */
static void
structuredvm_validate_threads_once (void)
{
  /* Return if this is not the first time we got here. */
  static bool already_validated = false;
  if (already_validated)
    return;

#ifdef JITTER_REPLICATE
# define JITTER_FAIL(error_text)                                             \
    do                                                                       \
      {                                                                      \
        fprintf (stderr,                                                     \
                 "About specialized instruction %i (%s) at %p, size %liB\n", \
                 i, structuredvm_specialized_instruction_names [i],              \
                 structuredvm_threads [i],                                       \
                 structuredvm_thread_sizes [i]);                                 \
        jitter_fatal ("%s: you are not compiling with -fno-reorder-blocks",  \
                      error_text);                                           \
      }                                                                      \
    while (false)
#else
# define JITTER_FAIL(ignored_error_text)  \
    do                                    \
      {                                   \
        everything_valid = false;         \
        goto out;                         \
      }                                   \
    while (false)
#endif // #ifdef JITTER_REPLICATE

  /* The minimum address the next instruction code has to start at.

     This relies on NULL being zero, or in general lower in magnitude than any
     valid pointer.  It is not worth the trouble to be pedantic, as this will be
     true on every architecture where I can afford low-level tricks. */
  jitter_thread lower_bound = NULL;

  /* Check every thread.  We rely on the order here, following specialized
     instruction opcodes. */
  int i;
  bool everything_valid = true;
  for (i = 0; i < STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO; i ++)
    {
      jitter_thread thread = structuredvm_threads [i];
      long size = structuredvm_thread_sizes [i];

      /* Check that the current thread has non-negative non-huge size and
         doesn't start before the end of the previous one.  If this is true for
         all threads we can conclude that they are non-overlapping as well. */
      if (__builtin_expect (size < 0, false))
        JITTER_FAIL("a specialized instruction has negative code size");
      if (__builtin_expect (size > (1 << 24), false))
        JITTER_FAIL("a specialized instruction has huge code size");
      if (__builtin_expect (lower_bound > thread, false))
        JITTER_FAIL("non-sequential thread");

      /* The next thread cannot start before the end of the current one. */
      lower_bound = ((char*) thread) + size;
    }

#undef JITTER_FAIL

#ifndef JITTER_REPLICATE
 out:
#endif // #ifndef JITTER_REPLICATE

  /* If we have validated every thread size then disassembling appears safe. */
  if (everything_valid)
    structuredvm_threads_validated = true;

  /* We have checked the thread sizes, once and for all.  If this function gets
     called again, thru a second structuredvm initialization, it will immediately
     return. */
  already_validated = true;
}
#endif // #ifndef JITTER_DISPATCH_SWITCH

#ifdef JITTER_HAVE_PATCH_IN
/* The actual defect table.  We only need it when patch-ins are in use. */
jitter_uint
structuredvm_defect_table [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO];
#endif // #ifdef JITTER_HAVE_PATCH_IN

void
structuredvm_initialize (void)
{
  /* Check that the Jitter library we linked is the right one.  This check
     actually only useful to force the global to be used.  I prefer not to use
     an assert, because assertions can be disabled. */
  if (! JITTER_DISPATCH_DEPENDENT_GLOBAL_NAME)
    jitter_fatal ("impossible to reach: the thing should fail at link time");

#ifdef JITTER_REPLICATE
  /* Initialize the executable-memory subsystem. */
  jitter_initialize_executable ();
#endif // #ifdef JITTER_REPLICATE

  /* Initialise the print-context machinery. */
  jitter_print_initialize ();

  /* Perform some sanity checks which only need to be run once. */
  structuredvm_check_specialized_instruction_opcode_once ();

  /* We have to initialize threads before structuredvm_threads , since the struct
     needs threads. */
  structuredvm_initialize_threads ();

#ifndef JITTER_DISPATCH_SWITCH
  /* Validate threads, to make sure the generated code was not compiled with
     incorrect options.  This only needs to be done once. */
  structuredvm_validate_threads_once ();
#endif // ifndef JITTER_DISPATCH_SWITCH

  /* Initialize the object pointed by structuredvm_vm (see the comment above as to
     why we do it here).  Before actually setting the fields to valid data, fill
     the whole struct with a -- hopefully -- invalid pattern, just to catch
     bugs. */
  static bool vm_struct_initialized = false;
  if (! vm_struct_initialized)
    {
      memset (& the_structuredvm_vm, 0xff, sizeof (struct jitter_vm));

      /* Make the configuration struct reachable from the VM struct. */
      the_structuredvm_vm.configuration = structuredvm_vm_configuration;
      //structuredvm_print_vm_configuration (stdout, & the_structuredvm_vm.configuration);

      /* Initialize meta-instruction pointers for implicit instructions.
         VM-independent program specialization relies on those, so they have to
         be accessible to the Jitter library, out of generated code.  Since
         meta-instructions are sorted alphabetically in the array, the index
         is not fixed. */
      the_structuredvm_vm.exitvm_meta_instruction
        = (structuredvm_meta_instructions + structuredvm_meta_instruction_id_exitvm);
      the_structuredvm_vm.unreachable_meta_instruction
        = (structuredvm_meta_instructions
           + structuredvm_meta_instruction_id_unreachable);

      /* Threads or pointers to native code blocks of course don't exist with
   switch-dispatching. */
#ifndef JITTER_DISPATCH_SWITCH
      the_structuredvm_vm.threads = (jitter_thread *)structuredvm_threads;
      the_structuredvm_vm.thread_sizes = (long *) structuredvm_thread_sizes;
      the_structuredvm_vm.threads_validated = structuredvm_threads_validated;
#if defined (JITTER_HAVE_KNOWN_BINARY_FORMAT)
      the_structuredvm_vm.data_locations = JITTER_DATA_LOCATION_NAME(structuredvm);
#else
      the_structuredvm_vm.data_locations = NULL;
#endif // #if defined (JITTER_HAVE_KNOWN_BINARY_FORMAT)
#endif // #ifndef JITTER_DISPATCH_SWITCH

      the_structuredvm_vm.specialized_instruction_residual_arities
        = structuredvm_specialized_instruction_residual_arities;
      the_structuredvm_vm.specialized_instruction_label_bitmasks
        = structuredvm_specialized_instruction_label_bitmasks;
#ifdef JITTER_HAVE_PATCH_IN
      the_structuredvm_vm.specialized_instruction_fast_label_bitmasks
        = structuredvm_specialized_instruction_fast_label_bitmasks;
      the_structuredvm_vm.patch_in_descriptors =
        JITTER_PATCH_IN_DESCRIPTORS_NAME(structuredvm);
      const size_t patch_in_descriptor_size
        = sizeof (struct jitter_patch_in_descriptor);
      the_structuredvm_vm.patch_in_descriptor_no
        = (JITTER_PATCH_IN_DESCRIPTORS_SIZE_IN_BYTES_NAME(structuredvm)
           / patch_in_descriptor_size);
      /* Cheap sanity check: if the size in bytes is not a multiple of
         the element size, we're doing something very wrong. */
      if (JITTER_PATCH_IN_DESCRIPTORS_SIZE_IN_BYTES_NAME(structuredvm)
          % patch_in_descriptor_size != 0)
        jitter_fatal ("patch-in descriptors total size not a multiple "
                      "of the element size");
      /* Initialize the patch-in table for this VM. */
      the_structuredvm_vm.patch_in_table
        = jitter_make_patch_in_table (the_structuredvm_vm.patch_in_descriptors,
                                      the_structuredvm_vm.patch_in_descriptor_no,
                                      STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO);
#else
      the_structuredvm_vm.specialized_instruction_fast_label_bitmasks = NULL;
#endif // #ifdef JITTER_HAVE_PATCH_IN

      /* FIXME: I might want to conditionalize this. */
      the_structuredvm_vm.specialized_instruction_relocatables
        = structuredvm_specialized_instruction_relocatables;

      the_structuredvm_vm.specialized_instruction_callers
        = structuredvm_specialized_instruction_callers;
      the_structuredvm_vm.specialized_instruction_callees
        = structuredvm_specialized_instruction_callees;

      the_structuredvm_vm.specialized_instruction_names
        = structuredvm_specialized_instruction_names;
      the_structuredvm_vm.specialized_instruction_no
        = STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO;

      the_structuredvm_vm.meta_instruction_string_hash
        = & structuredvm_meta_instruction_hash;
      the_structuredvm_vm.meta_instructions
        = (struct jitter_meta_instruction *) structuredvm_meta_instructions;
      the_structuredvm_vm.meta_instruction_no = STRUCTUREDVM_META_INSTRUCTION_NO;
      the_structuredvm_vm.max_meta_instruction_name_length
        = STRUCTUREDVM_MAX_META_INSTRUCTION_NAME_LENGTH;
      the_structuredvm_vm.specialized_instruction_to_unspecialized_instruction
        = structuredvm_specialized_instruction_to_unspecialized_instruction;
      the_structuredvm_vm.register_class_character_to_register_class
        = structuredvm_register_class_character_to_register_class;
      the_structuredvm_vm.specialize_instruction = structuredvm_specialize_instruction;
      the_structuredvm_vm.rewrite = structuredvm_rewrite;

#ifdef JITTER_HAVE_PATCH_IN
      /* Fill the defect table.  Since the array in question is a global with a
         fixed size, this needs to be done only once. */
      jitter_fill_defect_table (structuredvm_defect_table,
                                & the_structuredvm_vm,
                                structuredvm_worst_case_defect_table,
                                JITTER_DEFECT_DESCRIPTORS_NAME (structuredvm),
                                (JITTER_DEFECT_DESCRIPTORS_SIZE_IN_BYTES_NAME
                                    (structuredvm)
                                 / sizeof (struct jitter_defect_descriptor)));
#endif // #ifdef JITTER_HAVE_PATCH_IN

      /* Initialize the empty list of states. */
      JITTER_LIST_INITIALIZE_HEADER (& the_structuredvm_vm.states);

      vm_struct_initialized = true;
    }

  jitter_initialize_meta_instructions (& structuredvm_meta_instruction_hash,
                                         structuredvm_meta_instructions,
                                         STRUCTUREDVM_META_INSTRUCTION_NO);

#ifdef JITTER_HAVE_PATCH_IN
  jitter_dump_defect_table (stderr, structuredvm_defect_table, & the_structuredvm_vm);
#endif // #ifdef JITTER_HAVE_PATCH_IN
}

void
structuredvm_finalize (void)
{
  /* There's no need to touch the_structuredvm_vm ; we can keep it as it is, as it
     contains no dynamically-allocated fields. */
  /* Threads need no finalization. */
  jitter_finalize_meta_instructions (& structuredvm_meta_instruction_hash);

#ifdef JITTER_HAVE_PATCH_IN
  /* Destroy the patch-in table for this VM. */
  jitter_destroy_patch_in_table (the_structuredvm_vm.patch_in_table,
                                 STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO);
#endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
  /* Finalize the executable-memory subsystem. */
  jitter_finalize_executable ();
#endif // #ifdef JITTER_REPLICATE

  /* Finalize the state list.  If it is not empty then something has gone
     wrong earlier. */
  if (the_structuredvm_vm.states.first != NULL
      || the_structuredvm_vm.states.last != NULL)
    jitter_fatal ("not every state structure was destroyed before STRUCTUREDVM "
                  "finalisation.");
}




/* VM-dependant mutable routine initialization.
 * ************************************************************************** */

struct jitter_mutable_routine*
structuredvm_make_mutable_routine (void)
{
  return jitter_make_mutable_routine (structuredvm_vm);
}




/* Sample profiling: internal API.
 * ************************************************************************** */

#if defined (JITTER_PROFILE_SAMPLE)

/* Sample profiling depends on some system features: fail immediately if they
   are not available */
#if ! defined (JITTER_HAVE_SIGACTION) || ! defined (JITTER_HAVE_SETITIMER)
# jitter_fatal "sample-profiling depends on sigaction and setitimer"
#endif

static struct itimerval
structuredvm_timer_interval;

static struct itimerval
structuredvm_timer_disabled_interval;

/* The sampling data, currently global.  The current implementation does not
   play well with threads, but it can be changed later keeping the same user
   API. */
struct structuredvm_sample_profile_state
{
  /* The state currently sample-profiling.  Since such a state can be only one
     right now this field is useful for printing error messages in case the user
     sets up sample-profiling from two states at the same time by mistake.
     This field is also useful for temporarily suspending and then reenabling
     sampling, when The Array is being resized: if the signal handler sees that
     this field is NULL it will not touch the fields. */
  struct structuredvm_state *state_p;

  /* A pointer to the counts field within the sample_profile_runtime struct. */
  uint32_t *counts;

  /* A pointer to the current specialised instruction opcode within the
     sample_profile_runtime struct. */
  volatile jitter_int * specialized_opcode_p;

  /* A pointer to the field counting the number of samples, again within the
     sample_profile_runtime struct. */
  unsigned int *sample_no_p;
};

/* The (currently) one and only global state for sample-profiling. */
static struct structuredvm_sample_profile_state
structuredvm_sample_profile_state;

static void
structuredvm_sigprof_handler (int signal)
{
#if 0
  assert (structuredvm_sample_profile_state.state_p != NULL);
#endif

  jitter_int specialized_opcode
    = * structuredvm_sample_profile_state.specialized_opcode_p;
  if (__builtin_expect ((specialized_opcode >= 0
                         && (specialized_opcode
                             < STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO)),
                        true))
    structuredvm_sample_profile_state.counts [specialized_opcode] ++;

  (* structuredvm_sample_profile_state.sample_no_p) ++;
}

void
structuredvm_profile_sample_initialize (void)
{
  /* Perform a sanity check over the sampling period. */
  if (JITTER_PROFILE_SAMPLE_PERIOD_IN_MILLISECONDS <= 0 ||
      JITTER_PROFILE_SAMPLE_PERIOD_IN_MILLISECONDS >= 1000)
    jitter_fatal ("invalid JITTER_PROFILE_SAMPLE_PERIOD_IN_MILLISECONDS: %f",
                  (double) JITTER_PROFILE_SAMPLE_PERIOD_IN_MILLISECONDS);
  struct sigaction action;
  sigaction (SIGPROF, NULL, & action);
  action.sa_handler = structuredvm_sigprof_handler;
  sigaction (SIGPROF, & action, NULL);

  long microseconds
    = (long) (JITTER_PROFILE_SAMPLE_PERIOD_IN_MILLISECONDS * 1000);
  structuredvm_timer_interval.it_interval.tv_sec = 0;
  structuredvm_timer_interval.it_interval.tv_usec = microseconds;
  structuredvm_timer_interval.it_value = structuredvm_timer_interval.it_interval;

  structuredvm_sample_profile_state.state_p = NULL;
  structuredvm_timer_disabled_interval.it_interval.tv_sec = 0;
  structuredvm_timer_disabled_interval.it_interval.tv_usec = 0;
  structuredvm_timer_disabled_interval.it_value
    = structuredvm_timer_disabled_interval.it_interval;
}

void
structuredvm_profile_sample_start (struct structuredvm_state *state_p)
{
  struct jitter_sample_profile_runtime *spr
    = ((struct jitter_sample_profile_runtime *)
       & STRUCTUREDVM_STATE_TO_SPECIAL_PURPOSE_STATE_DATA (state_p)
           ->profile_runtime.sample_profile_runtime);

  if (structuredvm_sample_profile_state.state_p != NULL)
    {
      if (state_p != structuredvm_sample_profile_state.state_p)
        jitter_fatal ("currently it is only possible to sample-profile from "
                      "one state at the time: trying to sample-profile from "
                      "the state %p when already sample-profiling from the "
                      "state %p",
                      state_p, structuredvm_sample_profile_state.state_p);
      else
        {
          /* This situation is a symptom of a bug, but does not need to lead
             to a fatal error. */
          printf ("WARNING: starting profile on the state %p when profiling "
                  "was already active in the same state.\n"
                  "Did you call longjmp from VM code?", state_p);
          fflush (stdout);
        }
    }
  structuredvm_sample_profile_state.state_p = state_p;
  structuredvm_sample_profile_state.sample_no_p = & spr->sample_no;
  structuredvm_sample_profile_state.counts = spr->counts;
  structuredvm_sample_profile_state.specialized_opcode_p
    = & spr->current_specialized_instruction_opcode;
  //fprintf (stderr, "SAMPLE START\n"); fflush (NULL);
  if (setitimer (ITIMER_PROF, & structuredvm_timer_interval, NULL) != 0)
    jitter_fatal ("setitimer failed when establishing a timer");
}

void
structuredvm_profile_sample_stop (void)
{
  if (setitimer (ITIMER_PROF, & structuredvm_timer_disabled_interval, NULL) != 0)
    jitter_fatal ("setitimer failed when disabling a timer");

  structuredvm_sample_profile_state.state_p = NULL;

  /* The rest is just for defenisveness' sake. */
  * structuredvm_sample_profile_state.specialized_opcode_p = -1;
  structuredvm_sample_profile_state.sample_no_p = NULL;
  structuredvm_sample_profile_state.counts = NULL;
  structuredvm_sample_profile_state.specialized_opcode_p = NULL;
}
#endif // #if defined (JITTER_PROFILE_SAMPLE)




/* Array re-allocation.
 * ************************************************************************** */

char *
structuredvm_make_place_for_slow_registers (struct structuredvm_state *s,
                                        jitter_int new_slow_register_no_per_class)
{
  if (new_slow_register_no_per_class < 0)
    jitter_fatal ("structuredvm_make_place_for_slow_registers: negative slow "
                  "register number");
  jitter_int old_slow_register_no_per_class
    = s->structuredvm_state_backing.jitter_slow_register_no_per_class;
  /* Change nothing if we already have enough space for the required number of
     slow registers.  The no-change case will be the most common one, and
     this function might be worth optimizing. */
  if (__builtin_expect (new_slow_register_no_per_class
                        > old_slow_register_no_per_class,
                        false))
    {
#if defined (JITTER_PROFILE_SAMPLE)
      /* If sample-profiling is currently in progress on this state suspend it
         temporarily. */
      bool suspending_sample_profiling
        = (structuredvm_sample_profile_state.state_p == s);
      if (suspending_sample_profiling)
        structuredvm_profile_sample_stop ();
#endif // #if defined (JITTER_PROFILE_SAMPLE)

#if 0
      printf ("Increasing slow register-no (per class) from %li to %li\n", (long) old_slow_register_no_per_class, (long)new_slow_register_no_per_class);
      printf ("Array size %li -> %li\n", (long) STRUCTUREDVM_ARRAY_SIZE(old_slow_register_no_per_class), (long) STRUCTUREDVM_ARRAY_SIZE(new_slow_register_no_per_class));
#endif
      /* Save the new value for new_slow_register_no_per_class in the state
         structure; reallocate the Array. */
      s->structuredvm_state_backing.jitter_slow_register_no_per_class
        = new_slow_register_no_per_class;
      s->structuredvm_state_backing.jitter_array
        = jitter_xrealloc ((void *) s->structuredvm_state_backing.jitter_array,
                           STRUCTUREDVM_ARRAY_SIZE(new_slow_register_no_per_class));

      /* Initialise the slow registers we have just added, for every class. */
      union structuredvm_any_register *first_slow_register
        = ((union structuredvm_any_register *)
           ((char *) s->structuredvm_state_backing.jitter_array
            + STRUCTUREDVM_FIRST_SLOW_REGISTER_UNBIASED_OFFSET));
      jitter_int i;
      for (i = old_slow_register_no_per_class;
           i < new_slow_register_no_per_class;
           i ++)
        {
          /* A pointer to the i-th rank of slow registers.  Every register
             in the rank is new and in general (according to its class) may
             need initialisation. */
          union structuredvm_any_register *rank
            = first_slow_register + (i * STRUCTUREDVM_REGISTER_CLASS_NO);
          STRUCTUREDVM_INITIALIZE_SLOW_REGISTER_RANK (rank);
        }
#if defined (JITTER_PROFILE_SAMPLE)
      /* Now we can resume sample-profiling on this state if we suspended it. */
      if (suspending_sample_profiling)
        structuredvm_profile_sample_start (s);
#endif // #if defined (JITTER_PROFILE_SAMPLE)
#if 0
      printf ("Done resizing The Array\n");
#endif
    }

  /* Return the new (or unchanged) base, by simply adding the bias to the
     Array as it is now. */
  return s->structuredvm_state_backing.jitter_array + JITTER_ARRAY_BIAS;
}

void
structuredvm_ensure_enough_slow_registers_for_executable_routine
   (const struct jitter_executable_routine *er, struct structuredvm_state *s)
{
  structuredvm_make_place_for_slow_registers (s, er->slow_register_per_class_no);
}




/* Program text frontend.
 * ************************************************************************** */

void
structuredvm_parse_mutable_routine_from_file_star (FILE *input_file,
                                               struct jitter_mutable_routine *p)
{
  jitter_parse_mutable_routine_from_file_star (input_file, p, structuredvm_vm);
}

void
structuredvm_parse_mutable_routine_from_file (const char *input_file_name,
                                          struct jitter_mutable_routine *p)
{
  jitter_parse_mutable_routine_from_file (input_file_name, p, structuredvm_vm);
}

void
structuredvm_parse_mutable_routine_from_string (const char *string,
                                            struct jitter_mutable_routine *p)
{
  jitter_parse_mutable_routine_from_string (string, p, structuredvm_vm);
}




/* Executing code: unified routine API.
 * ************************************************************************** */

void
structuredvm_ensure_enough_slow_registers_for_routine
   (jitter_routine r, struct structuredvm_state *s)
{
  struct jitter_executable_routine *e
    = jitter_routine_make_executable_if_needed (r);
  structuredvm_ensure_enough_slow_registers_for_executable_routine (e, s);
}

void
structuredvm_execute_routine (jitter_routine r,
                          struct structuredvm_state *s)
{
  struct jitter_executable_routine *e
    = jitter_routine_make_executable_if_needed (r);
  structuredvm_execute_executable_routine (e, s);
}




/* Profiling: user API.
 * ************************************************************************** */

/* These functions are all trivial wrappers around the functionality declared
   in jitter/jitter-profile.h, hiding the VM pointer. */

struct structuredvm_profile_runtime *
structuredvm_state_profile_runtime (struct structuredvm_state *s)
{
  volatile struct jitter_special_purpose_state_data *spd
    = STRUCTUREDVM_ARRAY_TO_SPECIAL_PURPOSE_STATE_DATA
        (s->structuredvm_state_backing.jitter_array);
  return (struct structuredvm_profile_runtime *) & spd->profile_runtime;
}

struct structuredvm_profile_runtime *
structuredvm_profile_runtime_make (void)
{
  return jitter_profile_runtime_make (structuredvm_vm);
}

void
structuredvm_profile_runtime_clear (struct structuredvm_profile_runtime * p)
{
  jitter_profile_runtime_clear (structuredvm_vm, p);
}

void
structuredvm_profile_runtime_merge_from (struct structuredvm_profile_runtime *to,
                                     const struct structuredvm_profile_runtime *from)
{
  jitter_profile_runtime_merge_from (structuredvm_vm, to, from);
}

void
structuredvm_profile_runtime_merge_from_state (struct structuredvm_profile_runtime *to,
                                           const struct structuredvm_state *from_state)
{
  const struct structuredvm_profile_runtime* from
    = structuredvm_state_profile_runtime ((struct structuredvm_state *) from_state);
  jitter_profile_runtime_merge_from (structuredvm_vm, to, from);
}

void
structuredvm_profile_runtime_print_unspecialized
   (jitter_print_context ct,
    const struct structuredvm_profile_runtime *p)
{
  jitter_profile_runtime_print_unspecialized (ct, structuredvm_vm, p);
}

void
structuredvm_profile_runtime_print_specialized (jitter_print_context ct,
                                            const struct structuredvm_profile_runtime
                                            *p)
{
  jitter_profile_runtime_print_specialized (ct, structuredvm_vm, p);
}

struct structuredvm_profile *
structuredvm_profile_unspecialized_from_runtime
   (const struct structuredvm_profile_runtime *p)
{
  return jitter_profile_unspecialized_from_runtime (structuredvm_vm, p);
}

struct structuredvm_profile *
structuredvm_profile_specialized_from_runtime (const struct structuredvm_profile_runtime
                                           *p)
{
  return jitter_profile_specialized_from_runtime (structuredvm_vm, p);
}




/* Evrything following this point is machine-generated.
 * ************************************************************************** */

/* What follows could be conceptually split into several generated C files, but
   having too many of them would be inconvenient for the user to compile and
   link.  For this reason we currently generate just three files: one is this,
   which also contains the specializer, another is for the executor, and then a
   header -- a main module is optional.  The executor will be potentially very
   large, so it is best compiled separately.  The specializer might be large as
   well at this stage, even if its compilation is usually much less
   expensive. */
/* These two macros are convenient for making VM-specific identifiers
   using VM-independent macros from a public header, without polluting
   the global namespace. */
#define JITTER_VM_PREFIX_LOWER_CASE structuredvm
#define JITTER_VM_PREFIX_UPPER_CASE STRUCTUREDVM

/* User-specified code, printer part: beginning. */

static void
structured_literal_printer (jitter_print_context out, jitter_uint u)
{
  jitter_print_begin_class (out, "structuredvm-number");
  jitter_print_jitter_uint (out, 10, u);
  jitter_print_end_class (out);
}
  
/* User-specified code, printer part: end */

//#include <stdbool.h>

//#include <jitter/jitter.h>
//#include <jitter/jitter-instruction.h>

//#include "structuredvm-meta-instructions.h"

// FIXME: comment.
struct jitter_hash_table
structuredvm_meta_instruction_hash;


static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_b_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_be_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_beqi_mstack_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_beqr_mstack_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_bf_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_bg_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_bge_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_bger_mstack_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_bl_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_ble_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_bne_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_bneqi_mstack_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_bneqr_mstack_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_bt_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_copy_mto_mr_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_differenti_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, structured_literal_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_divided_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_equali_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, structured_literal_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_input_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_minus_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_minusi_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, structured_literal_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_minusr_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_mov_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_plus_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_plusi_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, structured_literal_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_pop_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_print_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_push_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum_or_literal_label, & structuredvm_register_class_r, structured_literal_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_pushr_mbeqr_mstack_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_pushr_mbger_mstack_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_pushr_mminusr_mpop_mstack_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_remainder_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_times_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_uminus_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };


const struct jitter_meta_instruction
structuredvm_meta_instructions [STRUCTUREDVM_META_INSTRUCTION_NO]
  = {
      { 0, "b", 1, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_b_meta_instruction_parameter_types },
      { 1, "be", 3, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_be_meta_instruction_parameter_types },
      { 2, "beqi-stack", 2, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_beqi_mstack_meta_instruction_parameter_types },
      { 3, "beqr-stack", 2, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_beqr_mstack_meta_instruction_parameter_types },
      { 4, "bf-stack", 1, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_bf_mstack_meta_instruction_parameter_types },
      { 5, "bg", 3, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_bg_meta_instruction_parameter_types },
      { 6, "bge", 3, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_bge_meta_instruction_parameter_types },
      { 7, "bger-stack", 2, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_bger_mstack_meta_instruction_parameter_types },
      { 8, "bl", 3, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_bl_meta_instruction_parameter_types },
      { 9, "ble", 3, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_ble_meta_instruction_parameter_types },
      { 10, "bne", 3, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_bne_meta_instruction_parameter_types },
      { 11, "bneqi-stack", 2, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_bneqi_mstack_meta_instruction_parameter_types },
      { 12, "bneqr-stack", 2, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_bneqr_mstack_meta_instruction_parameter_types },
      { 13, "bt-stack", 1, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_bt_mstack_meta_instruction_parameter_types },
      { 14, "copy-to-r-stack", 1, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_copy_mto_mr_mstack_meta_instruction_parameter_types },
      { 15, "different-stack", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL },
      { 16, "differenti-stack", 1, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_differenti_mstack_meta_instruction_parameter_types },
      { 17, "divided", 3, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_divided_meta_instruction_parameter_types },
      { 18, "divided-stack", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL },
      { 19, "drop-stack", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL },
      { 20, "dup-stack", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL },
      { 21, "equal-stack", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL },
      { 22, "equali-stack", 1, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_equali_mstack_meta_instruction_parameter_types },
      { 23, "exitvm", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL },
      { 24, "greater-stack", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL },
      { 25, "greaterorequal-stack", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL },
      { 26, "input", 1, false, false, false  /* FIXME: this may be wrong with replacements. */, structuredvm_input_meta_instruction_parameter_types },
      { 27, "input-stack", 0, false, false, false  /* FIXME: this may be wrong with replacements. */, NULL },
      { 28, "isnonzero-stack", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL },
      { 29, "less-stack", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL },
      { 30, "lessorequal-stack", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL },
      { 31, "logicaland-stack", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL },
      { 32, "logicalnot-stack", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL },
      { 33, "logicalor-stack", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL },
      { 34, "minus", 3, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_minus_meta_instruction_parameter_types },
      { 35, "minus-stack", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL },
      { 36, "minusi-stack", 1, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_minusi_mstack_meta_instruction_parameter_types },
      { 37, "minusr-stack", 1, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_minusr_mstack_meta_instruction_parameter_types },
      { 38, "mov", 2, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_mov_meta_instruction_parameter_types },
      { 39, "plus", 3, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_plus_meta_instruction_parameter_types },
      { 40, "plus-stack", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL },
      { 41, "plusi-stack", 1, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_plusi_mstack_meta_instruction_parameter_types },
      { 42, "pop-stack", 1, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_pop_mstack_meta_instruction_parameter_types },
      { 43, "print", 1, false, false, false  /* FIXME: this may be wrong with replacements. */, structuredvm_print_meta_instruction_parameter_types },
      { 44, "print-stack", 0, false, false, false  /* FIXME: this may be wrong with replacements. */, NULL },
      { 45, "push-stack", 1, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_push_mstack_meta_instruction_parameter_types },
      { 46, "pushr-beqr-stack", 3, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_pushr_mbeqr_mstack_meta_instruction_parameter_types },
      { 47, "pushr-bger-stack", 3, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_pushr_mbger_mstack_meta_instruction_parameter_types },
      { 48, "pushr-minusr-pop-stack", 3, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_pushr_mminusr_mpop_mstack_meta_instruction_parameter_types },
      { 49, "remainder", 3, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_remainder_meta_instruction_parameter_types },
      { 50, "remainder-stack", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL },
      { 51, "times", 3, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_times_meta_instruction_parameter_types },
      { 52, "times-stack", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL },
      { 53, "uminus", 2, false, false, true /* FIXME: this may be wrong with replacements. */, structuredvm_uminus_meta_instruction_parameter_types },
      { 54, "uminus-stack", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL },
      { 55, "unreachable", 0, false, false, true /* FIXME: this may be wrong with replacements. */, NULL }
    };

/* The register class descriptor for r registers. */
const struct jitter_register_class
structuredvm_register_class_r
  = {
      structuredvm_register_class_id_r,
      'r',
      "general_register",
      "GENERAL_REGISTER",
      STRUCTUREDVM_REGISTER_r_FAST_REGISTER_NO,
      1 /* Use slow registers */
    };


/* A pointer to every existing register class descriptor. */
const struct jitter_register_class * const
structuredvm_regiter_classes []
  = {
      & structuredvm_register_class_r
    };

const struct jitter_register_class *
structuredvm_register_class_character_to_register_class (char c)
{
  switch (c)
    {
    case 'r': return & structuredvm_register_class_r;
    default:  return NULL;
    }
}

//#include "structuredvm-specialized-instructions.h"

const char * const
structuredvm_specialized_instruction_names [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO]
  = {
      "!INVALID",
      "!BEGINBASICBLOCK",
      "!EXITVM",
      "!DATALOCATIONS",
      "!NOP",
      "!UNREACHABLE0",
      "!UNREACHABLE1",
      "!UNREACHABLE2",
      "b/fR",
      "be/%r0/%r0/fR",
      "be/%r0/%r1/fR",
      "be/%r0/%rR/fR",
      "be/%r0/n0/fR",
      "be/%r0/nR/fR",
      "be/%r1/%r0/fR",
      "be/%r1/%r1/fR",
      "be/%r1/%rR/fR",
      "be/%r1/n0/fR",
      "be/%r1/nR/fR",
      "be/%rR/%r0/fR",
      "be/%rR/%r1/fR",
      "be/%rR/%rR/fR",
      "be/%rR/n0/fR",
      "be/%rR/nR/fR",
      "be/n0/%r0/fR",
      "be/n0/%r1/fR",
      "be/n0/%rR/fR",
      "be/n0/n0/fR",
      "be/n0/nR/fR",
      "be/nR/%r0/fR",
      "be/nR/%r1/fR",
      "be/nR/%rR/fR",
      "be/nR/n0/fR",
      "be/nR/nR/fR",
      "beqi-stack/n-1/fR",
      "beqi-stack/n0/fR",
      "beqi-stack/n1/fR",
      "beqi-stack/n2/fR",
      "beqi-stack/nR/fR",
      "beqr-stack/%r0/fR",
      "beqr-stack/%r1/fR",
      "beqr-stack/%rR/fR",
      "bf-stack/fR",
      "bg/%r0/%r0/fR",
      "bg/%r0/%r1/fR",
      "bg/%r0/%rR/fR",
      "bg/%r0/n0/fR",
      "bg/%r0/nR/fR",
      "bg/%r1/%r0/fR",
      "bg/%r1/%r1/fR",
      "bg/%r1/%rR/fR",
      "bg/%r1/n0/fR",
      "bg/%r1/nR/fR",
      "bg/%rR/%r0/fR",
      "bg/%rR/%r1/fR",
      "bg/%rR/%rR/fR",
      "bg/%rR/n0/fR",
      "bg/%rR/nR/fR",
      "bg/n0/%r0/fR",
      "bg/n0/%r1/fR",
      "bg/n0/%rR/fR",
      "bg/n0/n0/fR",
      "bg/n0/nR/fR",
      "bg/nR/%r0/fR",
      "bg/nR/%r1/fR",
      "bg/nR/%rR/fR",
      "bg/nR/n0/fR",
      "bg/nR/nR/fR",
      "bge/%r0/%r0/fR",
      "bge/%r0/%r1/fR",
      "bge/%r0/%rR/fR",
      "bge/%r0/n0/fR",
      "bge/%r0/nR/fR",
      "bge/%r1/%r0/fR",
      "bge/%r1/%r1/fR",
      "bge/%r1/%rR/fR",
      "bge/%r1/n0/fR",
      "bge/%r1/nR/fR",
      "bge/%rR/%r0/fR",
      "bge/%rR/%r1/fR",
      "bge/%rR/%rR/fR",
      "bge/%rR/n0/fR",
      "bge/%rR/nR/fR",
      "bge/n0/%r0/fR",
      "bge/n0/%r1/fR",
      "bge/n0/%rR/fR",
      "bge/n0/n0/fR",
      "bge/n0/nR/fR",
      "bge/nR/%r0/fR",
      "bge/nR/%r1/fR",
      "bge/nR/%rR/fR",
      "bge/nR/n0/fR",
      "bge/nR/nR/fR",
      "bger-stack/%r0/fR",
      "bger-stack/%r1/fR",
      "bger-stack/%rR/fR",
      "bl/%r0/%r0/fR",
      "bl/%r0/%r1/fR",
      "bl/%r0/%rR/fR",
      "bl/%r0/n0/fR",
      "bl/%r0/nR/fR",
      "bl/%r1/%r0/fR",
      "bl/%r1/%r1/fR",
      "bl/%r1/%rR/fR",
      "bl/%r1/n0/fR",
      "bl/%r1/nR/fR",
      "bl/%rR/%r0/fR",
      "bl/%rR/%r1/fR",
      "bl/%rR/%rR/fR",
      "bl/%rR/n0/fR",
      "bl/%rR/nR/fR",
      "bl/n0/%r0/fR",
      "bl/n0/%r1/fR",
      "bl/n0/%rR/fR",
      "bl/n0/n0/fR",
      "bl/n0/nR/fR",
      "bl/nR/%r0/fR",
      "bl/nR/%r1/fR",
      "bl/nR/%rR/fR",
      "bl/nR/n0/fR",
      "bl/nR/nR/fR",
      "ble/%r0/%r0/fR",
      "ble/%r0/%r1/fR",
      "ble/%r0/%rR/fR",
      "ble/%r0/n0/fR",
      "ble/%r0/nR/fR",
      "ble/%r1/%r0/fR",
      "ble/%r1/%r1/fR",
      "ble/%r1/%rR/fR",
      "ble/%r1/n0/fR",
      "ble/%r1/nR/fR",
      "ble/%rR/%r0/fR",
      "ble/%rR/%r1/fR",
      "ble/%rR/%rR/fR",
      "ble/%rR/n0/fR",
      "ble/%rR/nR/fR",
      "ble/n0/%r0/fR",
      "ble/n0/%r1/fR",
      "ble/n0/%rR/fR",
      "ble/n0/n0/fR",
      "ble/n0/nR/fR",
      "ble/nR/%r0/fR",
      "ble/nR/%r1/fR",
      "ble/nR/%rR/fR",
      "ble/nR/n0/fR",
      "ble/nR/nR/fR",
      "bne/%r0/%r0/fR",
      "bne/%r0/%r1/fR",
      "bne/%r0/%rR/fR",
      "bne/%r0/n0/fR",
      "bne/%r0/nR/fR",
      "bne/%r1/%r0/fR",
      "bne/%r1/%r1/fR",
      "bne/%r1/%rR/fR",
      "bne/%r1/n0/fR",
      "bne/%r1/nR/fR",
      "bne/%rR/%r0/fR",
      "bne/%rR/%r1/fR",
      "bne/%rR/%rR/fR",
      "bne/%rR/n0/fR",
      "bne/%rR/nR/fR",
      "bne/n0/%r0/fR",
      "bne/n0/%r1/fR",
      "bne/n0/%rR/fR",
      "bne/n0/n0/fR",
      "bne/n0/nR/fR",
      "bne/nR/%r0/fR",
      "bne/nR/%r1/fR",
      "bne/nR/%rR/fR",
      "bne/nR/n0/fR",
      "bne/nR/nR/fR",
      "bneqi-stack/n-1/fR",
      "bneqi-stack/n0/fR",
      "bneqi-stack/n1/fR",
      "bneqi-stack/n2/fR",
      "bneqi-stack/nR/fR",
      "bneqr-stack/%r0/fR",
      "bneqr-stack/%r1/fR",
      "bneqr-stack/%rR/fR",
      "bt-stack/fR",
      "copy-to-r-stack/%r0",
      "copy-to-r-stack/%r1",
      "copy-to-r-stack/%rR",
      "different-stack",
      "differenti-stack/n0",
      "differenti-stack/n1",
      "differenti-stack/n2",
      "differenti-stack/nR",
      "divided/%r0/%r0/%r0",
      "divided/%r0/%r0/%r1",
      "divided/%r0/%r0/%rR",
      "divided/%r0/%r1/%r0",
      "divided/%r0/%r1/%r1",
      "divided/%r0/%r1/%rR",
      "divided/%r0/%rR/%r0",
      "divided/%r0/%rR/%r1",
      "divided/%r0/%rR/%rR",
      "divided/%r0/n2/%r0",
      "divided/%r0/n2/%r1",
      "divided/%r0/n2/%rR",
      "divided/%r0/nR/%r0",
      "divided/%r0/nR/%r1",
      "divided/%r0/nR/%rR",
      "divided/%r1/%r0/%r0",
      "divided/%r1/%r0/%r1",
      "divided/%r1/%r0/%rR",
      "divided/%r1/%r1/%r0",
      "divided/%r1/%r1/%r1",
      "divided/%r1/%r1/%rR",
      "divided/%r1/%rR/%r0",
      "divided/%r1/%rR/%r1",
      "divided/%r1/%rR/%rR",
      "divided/%r1/n2/%r0",
      "divided/%r1/n2/%r1",
      "divided/%r1/n2/%rR",
      "divided/%r1/nR/%r0",
      "divided/%r1/nR/%r1",
      "divided/%r1/nR/%rR",
      "divided/%rR/%r0/%r0",
      "divided/%rR/%r0/%r1",
      "divided/%rR/%r0/%rR",
      "divided/%rR/%r1/%r0",
      "divided/%rR/%r1/%r1",
      "divided/%rR/%r1/%rR",
      "divided/%rR/%rR/%r0",
      "divided/%rR/%rR/%r1",
      "divided/%rR/%rR/%rR",
      "divided/%rR/n2/%r0",
      "divided/%rR/n2/%r1",
      "divided/%rR/n2/%rR",
      "divided/%rR/nR/%r0",
      "divided/%rR/nR/%r1",
      "divided/%rR/nR/%rR",
      "divided/nR/%r0/%r0",
      "divided/nR/%r0/%r1",
      "divided/nR/%r0/%rR",
      "divided/nR/%r1/%r0",
      "divided/nR/%r1/%r1",
      "divided/nR/%r1/%rR",
      "divided/nR/%rR/%r0",
      "divided/nR/%rR/%r1",
      "divided/nR/%rR/%rR",
      "divided/nR/n2/%r0",
      "divided/nR/n2/%r1",
      "divided/nR/n2/%rR",
      "divided/nR/nR/%r0",
      "divided/nR/nR/%r1",
      "divided/nR/nR/%rR",
      "divided-stack",
      "drop-stack",
      "dup-stack",
      "equal-stack",
      "equali-stack/n0",
      "equali-stack/n1",
      "equali-stack/n2",
      "equali-stack/nR",
      "exitvm",
      "greater-stack",
      "greaterorequal-stack",
      "input/%r0/retR",
      "input/%r1/retR",
      "input/%rR/retR",
      "input-stack/retR",
      "isnonzero-stack",
      "less-stack",
      "lessorequal-stack",
      "logicaland-stack",
      "logicalnot-stack",
      "logicalor-stack",
      "minus/%r0/%r0/%r0",
      "minus/%r0/%r0/%r1",
      "minus/%r0/%r0/%rR",
      "minus/%r0/%r1/%r0",
      "minus/%r0/%r1/%r1",
      "minus/%r0/%r1/%rR",
      "minus/%r0/%rR/%r0",
      "minus/%r0/%rR/%r1",
      "minus/%r0/%rR/%rR",
      "minus/%r0/n1/%r0",
      "minus/%r0/n1/%r1",
      "minus/%r0/n1/%rR",
      "minus/%r0/n2/%r0",
      "minus/%r0/n2/%r1",
      "minus/%r0/n2/%rR",
      "minus/%r0/nR/%r0",
      "minus/%r0/nR/%r1",
      "minus/%r0/nR/%rR",
      "minus/%r1/%r0/%r0",
      "minus/%r1/%r0/%r1",
      "minus/%r1/%r0/%rR",
      "minus/%r1/%r1/%r0",
      "minus/%r1/%r1/%r1",
      "minus/%r1/%r1/%rR",
      "minus/%r1/%rR/%r0",
      "minus/%r1/%rR/%r1",
      "minus/%r1/%rR/%rR",
      "minus/%r1/n1/%r0",
      "minus/%r1/n1/%r1",
      "minus/%r1/n1/%rR",
      "minus/%r1/n2/%r0",
      "minus/%r1/n2/%r1",
      "minus/%r1/n2/%rR",
      "minus/%r1/nR/%r0",
      "minus/%r1/nR/%r1",
      "minus/%r1/nR/%rR",
      "minus/%rR/%r0/%r0",
      "minus/%rR/%r0/%r1",
      "minus/%rR/%r0/%rR",
      "minus/%rR/%r1/%r0",
      "minus/%rR/%r1/%r1",
      "minus/%rR/%r1/%rR",
      "minus/%rR/%rR/%r0",
      "minus/%rR/%rR/%r1",
      "minus/%rR/%rR/%rR",
      "minus/%rR/n1/%r0",
      "minus/%rR/n1/%r1",
      "minus/%rR/n1/%rR",
      "minus/%rR/n2/%r0",
      "minus/%rR/n2/%r1",
      "minus/%rR/n2/%rR",
      "minus/%rR/nR/%r0",
      "minus/%rR/nR/%r1",
      "minus/%rR/nR/%rR",
      "minus/nR/%r0/%r0",
      "minus/nR/%r0/%r1",
      "minus/nR/%r0/%rR",
      "minus/nR/%r1/%r0",
      "minus/nR/%r1/%r1",
      "minus/nR/%r1/%rR",
      "minus/nR/%rR/%r0",
      "minus/nR/%rR/%r1",
      "minus/nR/%rR/%rR",
      "minus/nR/n1/%r0",
      "minus/nR/n1/%r1",
      "minus/nR/n1/%rR",
      "minus/nR/n2/%r0",
      "minus/nR/n2/%r1",
      "minus/nR/n2/%rR",
      "minus/nR/nR/%r0",
      "minus/nR/nR/%r1",
      "minus/nR/nR/%rR",
      "minus-stack",
      "minusi-stack/n1",
      "minusi-stack/n2",
      "minusi-stack/nR",
      "minusr-stack/%r0",
      "minusr-stack/%r1",
      "minusr-stack/%rR",
      "mov/%r0/%r0",
      "mov/%r0/%r1",
      "mov/%r0/%rR",
      "mov/%r1/%r0",
      "mov/%r1/%r1",
      "mov/%r1/%rR",
      "mov/%rR/%r0",
      "mov/%rR/%r1",
      "mov/%rR/%rR",
      "mov/n0/%r0",
      "mov/n0/%r1",
      "mov/n0/%rR",
      "mov/n1/%r0",
      "mov/n1/%r1",
      "mov/n1/%rR",
      "mov/n-1/%r0",
      "mov/n-1/%r1",
      "mov/n-1/%rR",
      "mov/n2/%r0",
      "mov/n2/%r1",
      "mov/n2/%rR",
      "mov/nR/%r0",
      "mov/nR/%r1",
      "mov/nR/%rR",
      "plus/%r0/%r0/%r0",
      "plus/%r0/%r0/%r1",
      "plus/%r0/%r0/%rR",
      "plus/%r0/%r1/%r0",
      "plus/%r0/%r1/%r1",
      "plus/%r0/%r1/%rR",
      "plus/%r0/%rR/%r0",
      "plus/%r0/%rR/%r1",
      "plus/%r0/%rR/%rR",
      "plus/%r0/n1/%r0",
      "plus/%r0/n1/%r1",
      "plus/%r0/n1/%rR",
      "plus/%r0/n2/%r0",
      "plus/%r0/n2/%r1",
      "plus/%r0/n2/%rR",
      "plus/%r0/nR/%r0",
      "plus/%r0/nR/%r1",
      "plus/%r0/nR/%rR",
      "plus/%r1/%r0/%r0",
      "plus/%r1/%r0/%r1",
      "plus/%r1/%r0/%rR",
      "plus/%r1/%r1/%r0",
      "plus/%r1/%r1/%r1",
      "plus/%r1/%r1/%rR",
      "plus/%r1/%rR/%r0",
      "plus/%r1/%rR/%r1",
      "plus/%r1/%rR/%rR",
      "plus/%r1/n1/%r0",
      "plus/%r1/n1/%r1",
      "plus/%r1/n1/%rR",
      "plus/%r1/n2/%r0",
      "plus/%r1/n2/%r1",
      "plus/%r1/n2/%rR",
      "plus/%r1/nR/%r0",
      "plus/%r1/nR/%r1",
      "plus/%r1/nR/%rR",
      "plus/%rR/%r0/%r0",
      "plus/%rR/%r0/%r1",
      "plus/%rR/%r0/%rR",
      "plus/%rR/%r1/%r0",
      "plus/%rR/%r1/%r1",
      "plus/%rR/%r1/%rR",
      "plus/%rR/%rR/%r0",
      "plus/%rR/%rR/%r1",
      "plus/%rR/%rR/%rR",
      "plus/%rR/n1/%r0",
      "plus/%rR/n1/%r1",
      "plus/%rR/n1/%rR",
      "plus/%rR/n2/%r0",
      "plus/%rR/n2/%r1",
      "plus/%rR/n2/%rR",
      "plus/%rR/nR/%r0",
      "plus/%rR/nR/%r1",
      "plus/%rR/nR/%rR",
      "plus/nR/%r0/%r0",
      "plus/nR/%r0/%r1",
      "plus/nR/%r0/%rR",
      "plus/nR/%r1/%r0",
      "plus/nR/%r1/%r1",
      "plus/nR/%r1/%rR",
      "plus/nR/%rR/%r0",
      "plus/nR/%rR/%r1",
      "plus/nR/%rR/%rR",
      "plus/nR/n1/%r0",
      "plus/nR/n1/%r1",
      "plus/nR/n1/%rR",
      "plus/nR/n2/%r0",
      "plus/nR/n2/%r1",
      "plus/nR/n2/%rR",
      "plus/nR/nR/%r0",
      "plus/nR/nR/%r1",
      "plus/nR/nR/%rR",
      "plus-stack",
      "plusi-stack/n-1",
      "plusi-stack/n1",
      "plusi-stack/n2",
      "plusi-stack/nR",
      "pop-stack/%r0",
      "pop-stack/%r1",
      "pop-stack/%rR",
      "print/%r0/retR",
      "print/%r1/retR",
      "print/%rR/retR",
      "print/nR/retR",
      "print-stack/retR",
      "push-stack/%r0",
      "push-stack/%r1",
      "push-stack/%rR",
      "push-stack/n0",
      "push-stack/n1",
      "push-stack/n-1",
      "push-stack/n2",
      "push-stack/nR",
      "push-stack/lR",
      "pushr-beqr-stack/%r0/%r0/fR",
      "pushr-beqr-stack/%r0/%r1/fR",
      "pushr-beqr-stack/%r0/%rR/fR",
      "pushr-beqr-stack/%r1/%r0/fR",
      "pushr-beqr-stack/%r1/%r1/fR",
      "pushr-beqr-stack/%r1/%rR/fR",
      "pushr-beqr-stack/%rR/%r0/fR",
      "pushr-beqr-stack/%rR/%r1/fR",
      "pushr-beqr-stack/%rR/%rR/fR",
      "pushr-bger-stack/%r0/%r0/fR",
      "pushr-bger-stack/%r0/%r1/fR",
      "pushr-bger-stack/%r0/%rR/fR",
      "pushr-bger-stack/%r1/%r0/fR",
      "pushr-bger-stack/%r1/%r1/fR",
      "pushr-bger-stack/%r1/%rR/fR",
      "pushr-bger-stack/%rR/%r0/fR",
      "pushr-bger-stack/%rR/%r1/fR",
      "pushr-bger-stack/%rR/%rR/fR",
      "pushr-minusr-pop-stack/%r0/%r0/%r0",
      "pushr-minusr-pop-stack/%r0/%r0/%r1",
      "pushr-minusr-pop-stack/%r0/%r0/%rR",
      "pushr-minusr-pop-stack/%r0/%r1/%r0",
      "pushr-minusr-pop-stack/%r0/%r1/%r1",
      "pushr-minusr-pop-stack/%r0/%r1/%rR",
      "pushr-minusr-pop-stack/%r0/%rR/%r0",
      "pushr-minusr-pop-stack/%r0/%rR/%r1",
      "pushr-minusr-pop-stack/%r0/%rR/%rR",
      "pushr-minusr-pop-stack/%r1/%r0/%r0",
      "pushr-minusr-pop-stack/%r1/%r0/%r1",
      "pushr-minusr-pop-stack/%r1/%r0/%rR",
      "pushr-minusr-pop-stack/%r1/%r1/%r0",
      "pushr-minusr-pop-stack/%r1/%r1/%r1",
      "pushr-minusr-pop-stack/%r1/%r1/%rR",
      "pushr-minusr-pop-stack/%r1/%rR/%r0",
      "pushr-minusr-pop-stack/%r1/%rR/%r1",
      "pushr-minusr-pop-stack/%r1/%rR/%rR",
      "pushr-minusr-pop-stack/%rR/%r0/%r0",
      "pushr-minusr-pop-stack/%rR/%r0/%r1",
      "pushr-minusr-pop-stack/%rR/%r0/%rR",
      "pushr-minusr-pop-stack/%rR/%r1/%r0",
      "pushr-minusr-pop-stack/%rR/%r1/%r1",
      "pushr-minusr-pop-stack/%rR/%r1/%rR",
      "pushr-minusr-pop-stack/%rR/%rR/%r0",
      "pushr-minusr-pop-stack/%rR/%rR/%r1",
      "pushr-minusr-pop-stack/%rR/%rR/%rR",
      "remainder/%r0/%r0/%r0",
      "remainder/%r0/%r0/%r1",
      "remainder/%r0/%r0/%rR",
      "remainder/%r0/%r1/%r0",
      "remainder/%r0/%r1/%r1",
      "remainder/%r0/%r1/%rR",
      "remainder/%r0/%rR/%r0",
      "remainder/%r0/%rR/%r1",
      "remainder/%r0/%rR/%rR",
      "remainder/%r0/n2/%r0",
      "remainder/%r0/n2/%r1",
      "remainder/%r0/n2/%rR",
      "remainder/%r0/nR/%r0",
      "remainder/%r0/nR/%r1",
      "remainder/%r0/nR/%rR",
      "remainder/%r1/%r0/%r0",
      "remainder/%r1/%r0/%r1",
      "remainder/%r1/%r0/%rR",
      "remainder/%r1/%r1/%r0",
      "remainder/%r1/%r1/%r1",
      "remainder/%r1/%r1/%rR",
      "remainder/%r1/%rR/%r0",
      "remainder/%r1/%rR/%r1",
      "remainder/%r1/%rR/%rR",
      "remainder/%r1/n2/%r0",
      "remainder/%r1/n2/%r1",
      "remainder/%r1/n2/%rR",
      "remainder/%r1/nR/%r0",
      "remainder/%r1/nR/%r1",
      "remainder/%r1/nR/%rR",
      "remainder/%rR/%r0/%r0",
      "remainder/%rR/%r0/%r1",
      "remainder/%rR/%r0/%rR",
      "remainder/%rR/%r1/%r0",
      "remainder/%rR/%r1/%r1",
      "remainder/%rR/%r1/%rR",
      "remainder/%rR/%rR/%r0",
      "remainder/%rR/%rR/%r1",
      "remainder/%rR/%rR/%rR",
      "remainder/%rR/n2/%r0",
      "remainder/%rR/n2/%r1",
      "remainder/%rR/n2/%rR",
      "remainder/%rR/nR/%r0",
      "remainder/%rR/nR/%r1",
      "remainder/%rR/nR/%rR",
      "remainder/nR/%r0/%r0",
      "remainder/nR/%r0/%r1",
      "remainder/nR/%r0/%rR",
      "remainder/nR/%r1/%r0",
      "remainder/nR/%r1/%r1",
      "remainder/nR/%r1/%rR",
      "remainder/nR/%rR/%r0",
      "remainder/nR/%rR/%r1",
      "remainder/nR/%rR/%rR",
      "remainder/nR/n2/%r0",
      "remainder/nR/n2/%r1",
      "remainder/nR/n2/%rR",
      "remainder/nR/nR/%r0",
      "remainder/nR/nR/%r1",
      "remainder/nR/nR/%rR",
      "remainder-stack",
      "times/%r0/%r0/%r0",
      "times/%r0/%r0/%r1",
      "times/%r0/%r0/%rR",
      "times/%r0/%r1/%r0",
      "times/%r0/%r1/%r1",
      "times/%r0/%r1/%rR",
      "times/%r0/%rR/%r0",
      "times/%r0/%rR/%r1",
      "times/%r0/%rR/%rR",
      "times/%r0/n2/%r0",
      "times/%r0/n2/%r1",
      "times/%r0/n2/%rR",
      "times/%r0/nR/%r0",
      "times/%r0/nR/%r1",
      "times/%r0/nR/%rR",
      "times/%r1/%r0/%r0",
      "times/%r1/%r0/%r1",
      "times/%r1/%r0/%rR",
      "times/%r1/%r1/%r0",
      "times/%r1/%r1/%r1",
      "times/%r1/%r1/%rR",
      "times/%r1/%rR/%r0",
      "times/%r1/%rR/%r1",
      "times/%r1/%rR/%rR",
      "times/%r1/n2/%r0",
      "times/%r1/n2/%r1",
      "times/%r1/n2/%rR",
      "times/%r1/nR/%r0",
      "times/%r1/nR/%r1",
      "times/%r1/nR/%rR",
      "times/%rR/%r0/%r0",
      "times/%rR/%r0/%r1",
      "times/%rR/%r0/%rR",
      "times/%rR/%r1/%r0",
      "times/%rR/%r1/%r1",
      "times/%rR/%r1/%rR",
      "times/%rR/%rR/%r0",
      "times/%rR/%rR/%r1",
      "times/%rR/%rR/%rR",
      "times/%rR/n2/%r0",
      "times/%rR/n2/%r1",
      "times/%rR/n2/%rR",
      "times/%rR/nR/%r0",
      "times/%rR/nR/%r1",
      "times/%rR/nR/%rR",
      "times/nR/%r0/%r0",
      "times/nR/%r0/%r1",
      "times/nR/%r0/%rR",
      "times/nR/%r1/%r0",
      "times/nR/%r1/%r1",
      "times/nR/%r1/%rR",
      "times/nR/%rR/%r0",
      "times/nR/%rR/%r1",
      "times/nR/%rR/%rR",
      "times/nR/n2/%r0",
      "times/nR/n2/%r1",
      "times/nR/n2/%rR",
      "times/nR/nR/%r0",
      "times/nR/nR/%r1",
      "times/nR/nR/%rR",
      "times-stack",
      "uminus/%r0/%r0",
      "uminus/%r0/%r1",
      "uminus/%r0/%rR",
      "uminus/%r1/%r0",
      "uminus/%r1/%r1",
      "uminus/%r1/%rR",
      "uminus/%rR/%r0",
      "uminus/%rR/%r1",
      "uminus/%rR/%rR",
      "uminus/nR/%r0",
      "uminus/nR/%r1",
      "uminus/nR/%rR",
      "uminus-stack",
      "unreachable",
      "*b/fR*-no-fast-branches",
      "*be/%r0/%r0/fR*-no-fast-branches",
      "*be/%r0/%r1/fR*-no-fast-branches",
      "*be/%r0/%rR/fR*-no-fast-branches",
      "*be/%r0/n0/fR*-no-fast-branches",
      "*be/%r0/nR/fR*-no-fast-branches",
      "*be/%r1/%r0/fR*-no-fast-branches",
      "*be/%r1/%r1/fR*-no-fast-branches",
      "*be/%r1/%rR/fR*-no-fast-branches",
      "*be/%r1/n0/fR*-no-fast-branches",
      "*be/%r1/nR/fR*-no-fast-branches",
      "*be/%rR/%r0/fR*-no-fast-branches",
      "*be/%rR/%r1/fR*-no-fast-branches",
      "*be/%rR/%rR/fR*-no-fast-branches",
      "*be/%rR/n0/fR*-no-fast-branches",
      "*be/%rR/nR/fR*-no-fast-branches",
      "*be/n0/%r0/fR*-no-fast-branches",
      "*be/n0/%r1/fR*-no-fast-branches",
      "*be/n0/%rR/fR*-no-fast-branches",
      "*be/n0/n0/fR*-no-fast-branches",
      "*be/n0/nR/fR*-no-fast-branches",
      "*be/nR/%r0/fR*-no-fast-branches",
      "*be/nR/%r1/fR*-no-fast-branches",
      "*be/nR/%rR/fR*-no-fast-branches",
      "*be/nR/n0/fR*-no-fast-branches",
      "*be/nR/nR/fR*-no-fast-branches",
      "*beqi-stack/n-1/fR*-no-fast-branches",
      "*beqi-stack/n0/fR*-no-fast-branches",
      "*beqi-stack/n1/fR*-no-fast-branches",
      "*beqi-stack/n2/fR*-no-fast-branches",
      "*beqi-stack/nR/fR*-no-fast-branches",
      "*beqr-stack/%r0/fR*-no-fast-branches",
      "*beqr-stack/%r1/fR*-no-fast-branches",
      "*beqr-stack/%rR/fR*-no-fast-branches",
      "*bf-stack/fR*-no-fast-branches",
      "*bg/%r0/%r0/fR*-no-fast-branches",
      "*bg/%r0/%r1/fR*-no-fast-branches",
      "*bg/%r0/%rR/fR*-no-fast-branches",
      "*bg/%r0/n0/fR*-no-fast-branches",
      "*bg/%r0/nR/fR*-no-fast-branches",
      "*bg/%r1/%r0/fR*-no-fast-branches",
      "*bg/%r1/%r1/fR*-no-fast-branches",
      "*bg/%r1/%rR/fR*-no-fast-branches",
      "*bg/%r1/n0/fR*-no-fast-branches",
      "*bg/%r1/nR/fR*-no-fast-branches",
      "*bg/%rR/%r0/fR*-no-fast-branches",
      "*bg/%rR/%r1/fR*-no-fast-branches",
      "*bg/%rR/%rR/fR*-no-fast-branches",
      "*bg/%rR/n0/fR*-no-fast-branches",
      "*bg/%rR/nR/fR*-no-fast-branches",
      "*bg/n0/%r0/fR*-no-fast-branches",
      "*bg/n0/%r1/fR*-no-fast-branches",
      "*bg/n0/%rR/fR*-no-fast-branches",
      "*bg/n0/n0/fR*-no-fast-branches",
      "*bg/n0/nR/fR*-no-fast-branches",
      "*bg/nR/%r0/fR*-no-fast-branches",
      "*bg/nR/%r1/fR*-no-fast-branches",
      "*bg/nR/%rR/fR*-no-fast-branches",
      "*bg/nR/n0/fR*-no-fast-branches",
      "*bg/nR/nR/fR*-no-fast-branches",
      "*bge/%r0/%r0/fR*-no-fast-branches",
      "*bge/%r0/%r1/fR*-no-fast-branches",
      "*bge/%r0/%rR/fR*-no-fast-branches",
      "*bge/%r0/n0/fR*-no-fast-branches",
      "*bge/%r0/nR/fR*-no-fast-branches",
      "*bge/%r1/%r0/fR*-no-fast-branches",
      "*bge/%r1/%r1/fR*-no-fast-branches",
      "*bge/%r1/%rR/fR*-no-fast-branches",
      "*bge/%r1/n0/fR*-no-fast-branches",
      "*bge/%r1/nR/fR*-no-fast-branches",
      "*bge/%rR/%r0/fR*-no-fast-branches",
      "*bge/%rR/%r1/fR*-no-fast-branches",
      "*bge/%rR/%rR/fR*-no-fast-branches",
      "*bge/%rR/n0/fR*-no-fast-branches",
      "*bge/%rR/nR/fR*-no-fast-branches",
      "*bge/n0/%r0/fR*-no-fast-branches",
      "*bge/n0/%r1/fR*-no-fast-branches",
      "*bge/n0/%rR/fR*-no-fast-branches",
      "*bge/n0/n0/fR*-no-fast-branches",
      "*bge/n0/nR/fR*-no-fast-branches",
      "*bge/nR/%r0/fR*-no-fast-branches",
      "*bge/nR/%r1/fR*-no-fast-branches",
      "*bge/nR/%rR/fR*-no-fast-branches",
      "*bge/nR/n0/fR*-no-fast-branches",
      "*bge/nR/nR/fR*-no-fast-branches",
      "*bger-stack/%r0/fR*-no-fast-branches",
      "*bger-stack/%r1/fR*-no-fast-branches",
      "*bger-stack/%rR/fR*-no-fast-branches",
      "*bl/%r0/%r0/fR*-no-fast-branches",
      "*bl/%r0/%r1/fR*-no-fast-branches",
      "*bl/%r0/%rR/fR*-no-fast-branches",
      "*bl/%r0/n0/fR*-no-fast-branches",
      "*bl/%r0/nR/fR*-no-fast-branches",
      "*bl/%r1/%r0/fR*-no-fast-branches",
      "*bl/%r1/%r1/fR*-no-fast-branches",
      "*bl/%r1/%rR/fR*-no-fast-branches",
      "*bl/%r1/n0/fR*-no-fast-branches",
      "*bl/%r1/nR/fR*-no-fast-branches",
      "*bl/%rR/%r0/fR*-no-fast-branches",
      "*bl/%rR/%r1/fR*-no-fast-branches",
      "*bl/%rR/%rR/fR*-no-fast-branches",
      "*bl/%rR/n0/fR*-no-fast-branches",
      "*bl/%rR/nR/fR*-no-fast-branches",
      "*bl/n0/%r0/fR*-no-fast-branches",
      "*bl/n0/%r1/fR*-no-fast-branches",
      "*bl/n0/%rR/fR*-no-fast-branches",
      "*bl/n0/n0/fR*-no-fast-branches",
      "*bl/n0/nR/fR*-no-fast-branches",
      "*bl/nR/%r0/fR*-no-fast-branches",
      "*bl/nR/%r1/fR*-no-fast-branches",
      "*bl/nR/%rR/fR*-no-fast-branches",
      "*bl/nR/n0/fR*-no-fast-branches",
      "*bl/nR/nR/fR*-no-fast-branches",
      "*ble/%r0/%r0/fR*-no-fast-branches",
      "*ble/%r0/%r1/fR*-no-fast-branches",
      "*ble/%r0/%rR/fR*-no-fast-branches",
      "*ble/%r0/n0/fR*-no-fast-branches",
      "*ble/%r0/nR/fR*-no-fast-branches",
      "*ble/%r1/%r0/fR*-no-fast-branches",
      "*ble/%r1/%r1/fR*-no-fast-branches",
      "*ble/%r1/%rR/fR*-no-fast-branches",
      "*ble/%r1/n0/fR*-no-fast-branches",
      "*ble/%r1/nR/fR*-no-fast-branches",
      "*ble/%rR/%r0/fR*-no-fast-branches",
      "*ble/%rR/%r1/fR*-no-fast-branches",
      "*ble/%rR/%rR/fR*-no-fast-branches",
      "*ble/%rR/n0/fR*-no-fast-branches",
      "*ble/%rR/nR/fR*-no-fast-branches",
      "*ble/n0/%r0/fR*-no-fast-branches",
      "*ble/n0/%r1/fR*-no-fast-branches",
      "*ble/n0/%rR/fR*-no-fast-branches",
      "*ble/n0/n0/fR*-no-fast-branches",
      "*ble/n0/nR/fR*-no-fast-branches",
      "*ble/nR/%r0/fR*-no-fast-branches",
      "*ble/nR/%r1/fR*-no-fast-branches",
      "*ble/nR/%rR/fR*-no-fast-branches",
      "*ble/nR/n0/fR*-no-fast-branches",
      "*ble/nR/nR/fR*-no-fast-branches",
      "*bne/%r0/%r0/fR*-no-fast-branches",
      "*bne/%r0/%r1/fR*-no-fast-branches",
      "*bne/%r0/%rR/fR*-no-fast-branches",
      "*bne/%r0/n0/fR*-no-fast-branches",
      "*bne/%r0/nR/fR*-no-fast-branches",
      "*bne/%r1/%r0/fR*-no-fast-branches",
      "*bne/%r1/%r1/fR*-no-fast-branches",
      "*bne/%r1/%rR/fR*-no-fast-branches",
      "*bne/%r1/n0/fR*-no-fast-branches",
      "*bne/%r1/nR/fR*-no-fast-branches",
      "*bne/%rR/%r0/fR*-no-fast-branches",
      "*bne/%rR/%r1/fR*-no-fast-branches",
      "*bne/%rR/%rR/fR*-no-fast-branches",
      "*bne/%rR/n0/fR*-no-fast-branches",
      "*bne/%rR/nR/fR*-no-fast-branches",
      "*bne/n0/%r0/fR*-no-fast-branches",
      "*bne/n0/%r1/fR*-no-fast-branches",
      "*bne/n0/%rR/fR*-no-fast-branches",
      "*bne/n0/n0/fR*-no-fast-branches",
      "*bne/n0/nR/fR*-no-fast-branches",
      "*bne/nR/%r0/fR*-no-fast-branches",
      "*bne/nR/%r1/fR*-no-fast-branches",
      "*bne/nR/%rR/fR*-no-fast-branches",
      "*bne/nR/n0/fR*-no-fast-branches",
      "*bne/nR/nR/fR*-no-fast-branches",
      "*bneqi-stack/n-1/fR*-no-fast-branches",
      "*bneqi-stack/n0/fR*-no-fast-branches",
      "*bneqi-stack/n1/fR*-no-fast-branches",
      "*bneqi-stack/n2/fR*-no-fast-branches",
      "*bneqi-stack/nR/fR*-no-fast-branches",
      "*bneqr-stack/%r0/fR*-no-fast-branches",
      "*bneqr-stack/%r1/fR*-no-fast-branches",
      "*bneqr-stack/%rR/fR*-no-fast-branches",
      "*bt-stack/fR*-no-fast-branches",
      "*pushr-beqr-stack/%r0/%r0/fR*-no-fast-branches",
      "*pushr-beqr-stack/%r0/%r1/fR*-no-fast-branches",
      "*pushr-beqr-stack/%r0/%rR/fR*-no-fast-branches",
      "*pushr-beqr-stack/%r1/%r0/fR*-no-fast-branches",
      "*pushr-beqr-stack/%r1/%r1/fR*-no-fast-branches",
      "*pushr-beqr-stack/%r1/%rR/fR*-no-fast-branches",
      "*pushr-beqr-stack/%rR/%r0/fR*-no-fast-branches",
      "*pushr-beqr-stack/%rR/%r1/fR*-no-fast-branches",
      "*pushr-beqr-stack/%rR/%rR/fR*-no-fast-branches",
      "*pushr-bger-stack/%r0/%r0/fR*-no-fast-branches",
      "*pushr-bger-stack/%r0/%r1/fR*-no-fast-branches",
      "*pushr-bger-stack/%r0/%rR/fR*-no-fast-branches",
      "*pushr-bger-stack/%r1/%r0/fR*-no-fast-branches",
      "*pushr-bger-stack/%r1/%r1/fR*-no-fast-branches",
      "*pushr-bger-stack/%r1/%rR/fR*-no-fast-branches",
      "*pushr-bger-stack/%rR/%r0/fR*-no-fast-branches",
      "*pushr-bger-stack/%rR/%r1/fR*-no-fast-branches",
      "*pushr-bger-stack/%rR/%rR/fR*-no-fast-branches"
    };
// #include <stdlib.h>

// #include "structuredvm-specialized-instructions.h"
const size_t
structuredvm_specialized_instruction_residual_arities [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO]
  = {
      0, /* !INVALID */
      1, /* !BEGINBASICBLOCK */
      0, /* !EXITVM */
      0, /* !DATALOCATIONS */
      0, /* !NOP */
      0, /* !UNREACHABLE0 */
      0, /* !UNREACHABLE1 */
      0, /* !UNREACHABLE2 */
      1, /* b/fR */
      1, /* be/%r0/%r0/fR */
      1, /* be/%r0/%r1/fR */
      2, /* be/%r0/%rR/fR */
      1, /* be/%r0/n0/fR */
      2, /* be/%r0/nR/fR */
      1, /* be/%r1/%r0/fR */
      1, /* be/%r1/%r1/fR */
      2, /* be/%r1/%rR/fR */
      1, /* be/%r1/n0/fR */
      2, /* be/%r1/nR/fR */
      2, /* be/%rR/%r0/fR */
      2, /* be/%rR/%r1/fR */
      3, /* be/%rR/%rR/fR */
      2, /* be/%rR/n0/fR */
      3, /* be/%rR/nR/fR */
      1, /* be/n0/%r0/fR */
      1, /* be/n0/%r1/fR */
      2, /* be/n0/%rR/fR */
      1, /* be/n0/n0/fR */
      2, /* be/n0/nR/fR */
      2, /* be/nR/%r0/fR */
      2, /* be/nR/%r1/fR */
      3, /* be/nR/%rR/fR */
      2, /* be/nR/n0/fR */
      3, /* be/nR/nR/fR */
      1, /* beqi-stack/n-1/fR */
      1, /* beqi-stack/n0/fR */
      1, /* beqi-stack/n1/fR */
      1, /* beqi-stack/n2/fR */
      2, /* beqi-stack/nR/fR */
      1, /* beqr-stack/%r0/fR */
      1, /* beqr-stack/%r1/fR */
      2, /* beqr-stack/%rR/fR */
      1, /* bf-stack/fR */
      1, /* bg/%r0/%r0/fR */
      1, /* bg/%r0/%r1/fR */
      2, /* bg/%r0/%rR/fR */
      1, /* bg/%r0/n0/fR */
      2, /* bg/%r0/nR/fR */
      1, /* bg/%r1/%r0/fR */
      1, /* bg/%r1/%r1/fR */
      2, /* bg/%r1/%rR/fR */
      1, /* bg/%r1/n0/fR */
      2, /* bg/%r1/nR/fR */
      2, /* bg/%rR/%r0/fR */
      2, /* bg/%rR/%r1/fR */
      3, /* bg/%rR/%rR/fR */
      2, /* bg/%rR/n0/fR */
      3, /* bg/%rR/nR/fR */
      1, /* bg/n0/%r0/fR */
      1, /* bg/n0/%r1/fR */
      2, /* bg/n0/%rR/fR */
      1, /* bg/n0/n0/fR */
      2, /* bg/n0/nR/fR */
      2, /* bg/nR/%r0/fR */
      2, /* bg/nR/%r1/fR */
      3, /* bg/nR/%rR/fR */
      2, /* bg/nR/n0/fR */
      3, /* bg/nR/nR/fR */
      1, /* bge/%r0/%r0/fR */
      1, /* bge/%r0/%r1/fR */
      2, /* bge/%r0/%rR/fR */
      1, /* bge/%r0/n0/fR */
      2, /* bge/%r0/nR/fR */
      1, /* bge/%r1/%r0/fR */
      1, /* bge/%r1/%r1/fR */
      2, /* bge/%r1/%rR/fR */
      1, /* bge/%r1/n0/fR */
      2, /* bge/%r1/nR/fR */
      2, /* bge/%rR/%r0/fR */
      2, /* bge/%rR/%r1/fR */
      3, /* bge/%rR/%rR/fR */
      2, /* bge/%rR/n0/fR */
      3, /* bge/%rR/nR/fR */
      1, /* bge/n0/%r0/fR */
      1, /* bge/n0/%r1/fR */
      2, /* bge/n0/%rR/fR */
      1, /* bge/n0/n0/fR */
      2, /* bge/n0/nR/fR */
      2, /* bge/nR/%r0/fR */
      2, /* bge/nR/%r1/fR */
      3, /* bge/nR/%rR/fR */
      2, /* bge/nR/n0/fR */
      3, /* bge/nR/nR/fR */
      1, /* bger-stack/%r0/fR */
      1, /* bger-stack/%r1/fR */
      2, /* bger-stack/%rR/fR */
      1, /* bl/%r0/%r0/fR */
      1, /* bl/%r0/%r1/fR */
      2, /* bl/%r0/%rR/fR */
      1, /* bl/%r0/n0/fR */
      2, /* bl/%r0/nR/fR */
      1, /* bl/%r1/%r0/fR */
      1, /* bl/%r1/%r1/fR */
      2, /* bl/%r1/%rR/fR */
      1, /* bl/%r1/n0/fR */
      2, /* bl/%r1/nR/fR */
      2, /* bl/%rR/%r0/fR */
      2, /* bl/%rR/%r1/fR */
      3, /* bl/%rR/%rR/fR */
      2, /* bl/%rR/n0/fR */
      3, /* bl/%rR/nR/fR */
      1, /* bl/n0/%r0/fR */
      1, /* bl/n0/%r1/fR */
      2, /* bl/n0/%rR/fR */
      1, /* bl/n0/n0/fR */
      2, /* bl/n0/nR/fR */
      2, /* bl/nR/%r0/fR */
      2, /* bl/nR/%r1/fR */
      3, /* bl/nR/%rR/fR */
      2, /* bl/nR/n0/fR */
      3, /* bl/nR/nR/fR */
      1, /* ble/%r0/%r0/fR */
      1, /* ble/%r0/%r1/fR */
      2, /* ble/%r0/%rR/fR */
      1, /* ble/%r0/n0/fR */
      2, /* ble/%r0/nR/fR */
      1, /* ble/%r1/%r0/fR */
      1, /* ble/%r1/%r1/fR */
      2, /* ble/%r1/%rR/fR */
      1, /* ble/%r1/n0/fR */
      2, /* ble/%r1/nR/fR */
      2, /* ble/%rR/%r0/fR */
      2, /* ble/%rR/%r1/fR */
      3, /* ble/%rR/%rR/fR */
      2, /* ble/%rR/n0/fR */
      3, /* ble/%rR/nR/fR */
      1, /* ble/n0/%r0/fR */
      1, /* ble/n0/%r1/fR */
      2, /* ble/n0/%rR/fR */
      1, /* ble/n0/n0/fR */
      2, /* ble/n0/nR/fR */
      2, /* ble/nR/%r0/fR */
      2, /* ble/nR/%r1/fR */
      3, /* ble/nR/%rR/fR */
      2, /* ble/nR/n0/fR */
      3, /* ble/nR/nR/fR */
      1, /* bne/%r0/%r0/fR */
      1, /* bne/%r0/%r1/fR */
      2, /* bne/%r0/%rR/fR */
      1, /* bne/%r0/n0/fR */
      2, /* bne/%r0/nR/fR */
      1, /* bne/%r1/%r0/fR */
      1, /* bne/%r1/%r1/fR */
      2, /* bne/%r1/%rR/fR */
      1, /* bne/%r1/n0/fR */
      2, /* bne/%r1/nR/fR */
      2, /* bne/%rR/%r0/fR */
      2, /* bne/%rR/%r1/fR */
      3, /* bne/%rR/%rR/fR */
      2, /* bne/%rR/n0/fR */
      3, /* bne/%rR/nR/fR */
      1, /* bne/n0/%r0/fR */
      1, /* bne/n0/%r1/fR */
      2, /* bne/n0/%rR/fR */
      1, /* bne/n0/n0/fR */
      2, /* bne/n0/nR/fR */
      2, /* bne/nR/%r0/fR */
      2, /* bne/nR/%r1/fR */
      3, /* bne/nR/%rR/fR */
      2, /* bne/nR/n0/fR */
      3, /* bne/nR/nR/fR */
      1, /* bneqi-stack/n-1/fR */
      1, /* bneqi-stack/n0/fR */
      1, /* bneqi-stack/n1/fR */
      1, /* bneqi-stack/n2/fR */
      2, /* bneqi-stack/nR/fR */
      1, /* bneqr-stack/%r0/fR */
      1, /* bneqr-stack/%r1/fR */
      2, /* bneqr-stack/%rR/fR */
      1, /* bt-stack/fR */
      0, /* copy-to-r-stack/%r0 */
      0, /* copy-to-r-stack/%r1 */
      1, /* copy-to-r-stack/%rR */
      0, /* different-stack */
      0, /* differenti-stack/n0 */
      0, /* differenti-stack/n1 */
      0, /* differenti-stack/n2 */
      1, /* differenti-stack/nR */
      0, /* divided/%r0/%r0/%r0 */
      0, /* divided/%r0/%r0/%r1 */
      1, /* divided/%r0/%r0/%rR */
      0, /* divided/%r0/%r1/%r0 */
      0, /* divided/%r0/%r1/%r1 */
      1, /* divided/%r0/%r1/%rR */
      1, /* divided/%r0/%rR/%r0 */
      1, /* divided/%r0/%rR/%r1 */
      2, /* divided/%r0/%rR/%rR */
      0, /* divided/%r0/n2/%r0 */
      0, /* divided/%r0/n2/%r1 */
      1, /* divided/%r0/n2/%rR */
      1, /* divided/%r0/nR/%r0 */
      1, /* divided/%r0/nR/%r1 */
      2, /* divided/%r0/nR/%rR */
      0, /* divided/%r1/%r0/%r0 */
      0, /* divided/%r1/%r0/%r1 */
      1, /* divided/%r1/%r0/%rR */
      0, /* divided/%r1/%r1/%r0 */
      0, /* divided/%r1/%r1/%r1 */
      1, /* divided/%r1/%r1/%rR */
      1, /* divided/%r1/%rR/%r0 */
      1, /* divided/%r1/%rR/%r1 */
      2, /* divided/%r1/%rR/%rR */
      0, /* divided/%r1/n2/%r0 */
      0, /* divided/%r1/n2/%r1 */
      1, /* divided/%r1/n2/%rR */
      1, /* divided/%r1/nR/%r0 */
      1, /* divided/%r1/nR/%r1 */
      2, /* divided/%r1/nR/%rR */
      1, /* divided/%rR/%r0/%r0 */
      1, /* divided/%rR/%r0/%r1 */
      2, /* divided/%rR/%r0/%rR */
      1, /* divided/%rR/%r1/%r0 */
      1, /* divided/%rR/%r1/%r1 */
      2, /* divided/%rR/%r1/%rR */
      2, /* divided/%rR/%rR/%r0 */
      2, /* divided/%rR/%rR/%r1 */
      3, /* divided/%rR/%rR/%rR */
      1, /* divided/%rR/n2/%r0 */
      1, /* divided/%rR/n2/%r1 */
      2, /* divided/%rR/n2/%rR */
      2, /* divided/%rR/nR/%r0 */
      2, /* divided/%rR/nR/%r1 */
      3, /* divided/%rR/nR/%rR */
      1, /* divided/nR/%r0/%r0 */
      1, /* divided/nR/%r0/%r1 */
      2, /* divided/nR/%r0/%rR */
      1, /* divided/nR/%r1/%r0 */
      1, /* divided/nR/%r1/%r1 */
      2, /* divided/nR/%r1/%rR */
      2, /* divided/nR/%rR/%r0 */
      2, /* divided/nR/%rR/%r1 */
      3, /* divided/nR/%rR/%rR */
      1, /* divided/nR/n2/%r0 */
      1, /* divided/nR/n2/%r1 */
      2, /* divided/nR/n2/%rR */
      2, /* divided/nR/nR/%r0 */
      2, /* divided/nR/nR/%r1 */
      3, /* divided/nR/nR/%rR */
      0, /* divided-stack */
      0, /* drop-stack */
      0, /* dup-stack */
      0, /* equal-stack */
      0, /* equali-stack/n0 */
      0, /* equali-stack/n1 */
      0, /* equali-stack/n2 */
      1, /* equali-stack/nR */
      0, /* exitvm */
      0, /* greater-stack */
      0, /* greaterorequal-stack */
      1, /* input/%r0/retR */
      1, /* input/%r1/retR */
      2, /* input/%rR/retR */
      1, /* input-stack/retR */
      0, /* isnonzero-stack */
      0, /* less-stack */
      0, /* lessorequal-stack */
      0, /* logicaland-stack */
      0, /* logicalnot-stack */
      0, /* logicalor-stack */
      0, /* minus/%r0/%r0/%r0 */
      0, /* minus/%r0/%r0/%r1 */
      1, /* minus/%r0/%r0/%rR */
      0, /* minus/%r0/%r1/%r0 */
      0, /* minus/%r0/%r1/%r1 */
      1, /* minus/%r0/%r1/%rR */
      1, /* minus/%r0/%rR/%r0 */
      1, /* minus/%r0/%rR/%r1 */
      2, /* minus/%r0/%rR/%rR */
      0, /* minus/%r0/n1/%r0 */
      0, /* minus/%r0/n1/%r1 */
      1, /* minus/%r0/n1/%rR */
      0, /* minus/%r0/n2/%r0 */
      0, /* minus/%r0/n2/%r1 */
      1, /* minus/%r0/n2/%rR */
      1, /* minus/%r0/nR/%r0 */
      1, /* minus/%r0/nR/%r1 */
      2, /* minus/%r0/nR/%rR */
      0, /* minus/%r1/%r0/%r0 */
      0, /* minus/%r1/%r0/%r1 */
      1, /* minus/%r1/%r0/%rR */
      0, /* minus/%r1/%r1/%r0 */
      0, /* minus/%r1/%r1/%r1 */
      1, /* minus/%r1/%r1/%rR */
      1, /* minus/%r1/%rR/%r0 */
      1, /* minus/%r1/%rR/%r1 */
      2, /* minus/%r1/%rR/%rR */
      0, /* minus/%r1/n1/%r0 */
      0, /* minus/%r1/n1/%r1 */
      1, /* minus/%r1/n1/%rR */
      0, /* minus/%r1/n2/%r0 */
      0, /* minus/%r1/n2/%r1 */
      1, /* minus/%r1/n2/%rR */
      1, /* minus/%r1/nR/%r0 */
      1, /* minus/%r1/nR/%r1 */
      2, /* minus/%r1/nR/%rR */
      1, /* minus/%rR/%r0/%r0 */
      1, /* minus/%rR/%r0/%r1 */
      2, /* minus/%rR/%r0/%rR */
      1, /* minus/%rR/%r1/%r0 */
      1, /* minus/%rR/%r1/%r1 */
      2, /* minus/%rR/%r1/%rR */
      2, /* minus/%rR/%rR/%r0 */
      2, /* minus/%rR/%rR/%r1 */
      3, /* minus/%rR/%rR/%rR */
      1, /* minus/%rR/n1/%r0 */
      1, /* minus/%rR/n1/%r1 */
      2, /* minus/%rR/n1/%rR */
      1, /* minus/%rR/n2/%r0 */
      1, /* minus/%rR/n2/%r1 */
      2, /* minus/%rR/n2/%rR */
      2, /* minus/%rR/nR/%r0 */
      2, /* minus/%rR/nR/%r1 */
      3, /* minus/%rR/nR/%rR */
      1, /* minus/nR/%r0/%r0 */
      1, /* minus/nR/%r0/%r1 */
      2, /* minus/nR/%r0/%rR */
      1, /* minus/nR/%r1/%r0 */
      1, /* minus/nR/%r1/%r1 */
      2, /* minus/nR/%r1/%rR */
      2, /* minus/nR/%rR/%r0 */
      2, /* minus/nR/%rR/%r1 */
      3, /* minus/nR/%rR/%rR */
      1, /* minus/nR/n1/%r0 */
      1, /* minus/nR/n1/%r1 */
      2, /* minus/nR/n1/%rR */
      1, /* minus/nR/n2/%r0 */
      1, /* minus/nR/n2/%r1 */
      2, /* minus/nR/n2/%rR */
      2, /* minus/nR/nR/%r0 */
      2, /* minus/nR/nR/%r1 */
      3, /* minus/nR/nR/%rR */
      0, /* minus-stack */
      0, /* minusi-stack/n1 */
      0, /* minusi-stack/n2 */
      1, /* minusi-stack/nR */
      0, /* minusr-stack/%r0 */
      0, /* minusr-stack/%r1 */
      1, /* minusr-stack/%rR */
      0, /* mov/%r0/%r0 */
      0, /* mov/%r0/%r1 */
      1, /* mov/%r0/%rR */
      0, /* mov/%r1/%r0 */
      0, /* mov/%r1/%r1 */
      1, /* mov/%r1/%rR */
      1, /* mov/%rR/%r0 */
      1, /* mov/%rR/%r1 */
      2, /* mov/%rR/%rR */
      0, /* mov/n0/%r0 */
      0, /* mov/n0/%r1 */
      1, /* mov/n0/%rR */
      0, /* mov/n1/%r0 */
      0, /* mov/n1/%r1 */
      1, /* mov/n1/%rR */
      0, /* mov/n-1/%r0 */
      0, /* mov/n-1/%r1 */
      1, /* mov/n-1/%rR */
      0, /* mov/n2/%r0 */
      0, /* mov/n2/%r1 */
      1, /* mov/n2/%rR */
      1, /* mov/nR/%r0 */
      1, /* mov/nR/%r1 */
      2, /* mov/nR/%rR */
      0, /* plus/%r0/%r0/%r0 */
      0, /* plus/%r0/%r0/%r1 */
      1, /* plus/%r0/%r0/%rR */
      0, /* plus/%r0/%r1/%r0 */
      0, /* plus/%r0/%r1/%r1 */
      1, /* plus/%r0/%r1/%rR */
      1, /* plus/%r0/%rR/%r0 */
      1, /* plus/%r0/%rR/%r1 */
      2, /* plus/%r0/%rR/%rR */
      0, /* plus/%r0/n1/%r0 */
      0, /* plus/%r0/n1/%r1 */
      1, /* plus/%r0/n1/%rR */
      0, /* plus/%r0/n2/%r0 */
      0, /* plus/%r0/n2/%r1 */
      1, /* plus/%r0/n2/%rR */
      1, /* plus/%r0/nR/%r0 */
      1, /* plus/%r0/nR/%r1 */
      2, /* plus/%r0/nR/%rR */
      0, /* plus/%r1/%r0/%r0 */
      0, /* plus/%r1/%r0/%r1 */
      1, /* plus/%r1/%r0/%rR */
      0, /* plus/%r1/%r1/%r0 */
      0, /* plus/%r1/%r1/%r1 */
      1, /* plus/%r1/%r1/%rR */
      1, /* plus/%r1/%rR/%r0 */
      1, /* plus/%r1/%rR/%r1 */
      2, /* plus/%r1/%rR/%rR */
      0, /* plus/%r1/n1/%r0 */
      0, /* plus/%r1/n1/%r1 */
      1, /* plus/%r1/n1/%rR */
      0, /* plus/%r1/n2/%r0 */
      0, /* plus/%r1/n2/%r1 */
      1, /* plus/%r1/n2/%rR */
      1, /* plus/%r1/nR/%r0 */
      1, /* plus/%r1/nR/%r1 */
      2, /* plus/%r1/nR/%rR */
      1, /* plus/%rR/%r0/%r0 */
      1, /* plus/%rR/%r0/%r1 */
      2, /* plus/%rR/%r0/%rR */
      1, /* plus/%rR/%r1/%r0 */
      1, /* plus/%rR/%r1/%r1 */
      2, /* plus/%rR/%r1/%rR */
      2, /* plus/%rR/%rR/%r0 */
      2, /* plus/%rR/%rR/%r1 */
      3, /* plus/%rR/%rR/%rR */
      1, /* plus/%rR/n1/%r0 */
      1, /* plus/%rR/n1/%r1 */
      2, /* plus/%rR/n1/%rR */
      1, /* plus/%rR/n2/%r0 */
      1, /* plus/%rR/n2/%r1 */
      2, /* plus/%rR/n2/%rR */
      2, /* plus/%rR/nR/%r0 */
      2, /* plus/%rR/nR/%r1 */
      3, /* plus/%rR/nR/%rR */
      1, /* plus/nR/%r0/%r0 */
      1, /* plus/nR/%r0/%r1 */
      2, /* plus/nR/%r0/%rR */
      1, /* plus/nR/%r1/%r0 */
      1, /* plus/nR/%r1/%r1 */
      2, /* plus/nR/%r1/%rR */
      2, /* plus/nR/%rR/%r0 */
      2, /* plus/nR/%rR/%r1 */
      3, /* plus/nR/%rR/%rR */
      1, /* plus/nR/n1/%r0 */
      1, /* plus/nR/n1/%r1 */
      2, /* plus/nR/n1/%rR */
      1, /* plus/nR/n2/%r0 */
      1, /* plus/nR/n2/%r1 */
      2, /* plus/nR/n2/%rR */
      2, /* plus/nR/nR/%r0 */
      2, /* plus/nR/nR/%r1 */
      3, /* plus/nR/nR/%rR */
      0, /* plus-stack */
      0, /* plusi-stack/n-1 */
      0, /* plusi-stack/n1 */
      0, /* plusi-stack/n2 */
      1, /* plusi-stack/nR */
      0, /* pop-stack/%r0 */
      0, /* pop-stack/%r1 */
      1, /* pop-stack/%rR */
      1, /* print/%r0/retR */
      1, /* print/%r1/retR */
      2, /* print/%rR/retR */
      2, /* print/nR/retR */
      1, /* print-stack/retR */
      0, /* push-stack/%r0 */
      0, /* push-stack/%r1 */
      1, /* push-stack/%rR */
      0, /* push-stack/n0 */
      0, /* push-stack/n1 */
      0, /* push-stack/n-1 */
      0, /* push-stack/n2 */
      1, /* push-stack/nR */
      1, /* push-stack/lR */
      1, /* pushr-beqr-stack/%r0/%r0/fR */
      1, /* pushr-beqr-stack/%r0/%r1/fR */
      2, /* pushr-beqr-stack/%r0/%rR/fR */
      1, /* pushr-beqr-stack/%r1/%r0/fR */
      1, /* pushr-beqr-stack/%r1/%r1/fR */
      2, /* pushr-beqr-stack/%r1/%rR/fR */
      2, /* pushr-beqr-stack/%rR/%r0/fR */
      2, /* pushr-beqr-stack/%rR/%r1/fR */
      3, /* pushr-beqr-stack/%rR/%rR/fR */
      1, /* pushr-bger-stack/%r0/%r0/fR */
      1, /* pushr-bger-stack/%r0/%r1/fR */
      2, /* pushr-bger-stack/%r0/%rR/fR */
      1, /* pushr-bger-stack/%r1/%r0/fR */
      1, /* pushr-bger-stack/%r1/%r1/fR */
      2, /* pushr-bger-stack/%r1/%rR/fR */
      2, /* pushr-bger-stack/%rR/%r0/fR */
      2, /* pushr-bger-stack/%rR/%r1/fR */
      3, /* pushr-bger-stack/%rR/%rR/fR */
      0, /* pushr-minusr-pop-stack/%r0/%r0/%r0 */
      0, /* pushr-minusr-pop-stack/%r0/%r0/%r1 */
      1, /* pushr-minusr-pop-stack/%r0/%r0/%rR */
      0, /* pushr-minusr-pop-stack/%r0/%r1/%r0 */
      0, /* pushr-minusr-pop-stack/%r0/%r1/%r1 */
      1, /* pushr-minusr-pop-stack/%r0/%r1/%rR */
      1, /* pushr-minusr-pop-stack/%r0/%rR/%r0 */
      1, /* pushr-minusr-pop-stack/%r0/%rR/%r1 */
      2, /* pushr-minusr-pop-stack/%r0/%rR/%rR */
      0, /* pushr-minusr-pop-stack/%r1/%r0/%r0 */
      0, /* pushr-minusr-pop-stack/%r1/%r0/%r1 */
      1, /* pushr-minusr-pop-stack/%r1/%r0/%rR */
      0, /* pushr-minusr-pop-stack/%r1/%r1/%r0 */
      0, /* pushr-minusr-pop-stack/%r1/%r1/%r1 */
      1, /* pushr-minusr-pop-stack/%r1/%r1/%rR */
      1, /* pushr-minusr-pop-stack/%r1/%rR/%r0 */
      1, /* pushr-minusr-pop-stack/%r1/%rR/%r1 */
      2, /* pushr-minusr-pop-stack/%r1/%rR/%rR */
      1, /* pushr-minusr-pop-stack/%rR/%r0/%r0 */
      1, /* pushr-minusr-pop-stack/%rR/%r0/%r1 */
      2, /* pushr-minusr-pop-stack/%rR/%r0/%rR */
      1, /* pushr-minusr-pop-stack/%rR/%r1/%r0 */
      1, /* pushr-minusr-pop-stack/%rR/%r1/%r1 */
      2, /* pushr-minusr-pop-stack/%rR/%r1/%rR */
      2, /* pushr-minusr-pop-stack/%rR/%rR/%r0 */
      2, /* pushr-minusr-pop-stack/%rR/%rR/%r1 */
      3, /* pushr-minusr-pop-stack/%rR/%rR/%rR */
      0, /* remainder/%r0/%r0/%r0 */
      0, /* remainder/%r0/%r0/%r1 */
      1, /* remainder/%r0/%r0/%rR */
      0, /* remainder/%r0/%r1/%r0 */
      0, /* remainder/%r0/%r1/%r1 */
      1, /* remainder/%r0/%r1/%rR */
      1, /* remainder/%r0/%rR/%r0 */
      1, /* remainder/%r0/%rR/%r1 */
      2, /* remainder/%r0/%rR/%rR */
      0, /* remainder/%r0/n2/%r0 */
      0, /* remainder/%r0/n2/%r1 */
      1, /* remainder/%r0/n2/%rR */
      1, /* remainder/%r0/nR/%r0 */
      1, /* remainder/%r0/nR/%r1 */
      2, /* remainder/%r0/nR/%rR */
      0, /* remainder/%r1/%r0/%r0 */
      0, /* remainder/%r1/%r0/%r1 */
      1, /* remainder/%r1/%r0/%rR */
      0, /* remainder/%r1/%r1/%r0 */
      0, /* remainder/%r1/%r1/%r1 */
      1, /* remainder/%r1/%r1/%rR */
      1, /* remainder/%r1/%rR/%r0 */
      1, /* remainder/%r1/%rR/%r1 */
      2, /* remainder/%r1/%rR/%rR */
      0, /* remainder/%r1/n2/%r0 */
      0, /* remainder/%r1/n2/%r1 */
      1, /* remainder/%r1/n2/%rR */
      1, /* remainder/%r1/nR/%r0 */
      1, /* remainder/%r1/nR/%r1 */
      2, /* remainder/%r1/nR/%rR */
      1, /* remainder/%rR/%r0/%r0 */
      1, /* remainder/%rR/%r0/%r1 */
      2, /* remainder/%rR/%r0/%rR */
      1, /* remainder/%rR/%r1/%r0 */
      1, /* remainder/%rR/%r1/%r1 */
      2, /* remainder/%rR/%r1/%rR */
      2, /* remainder/%rR/%rR/%r0 */
      2, /* remainder/%rR/%rR/%r1 */
      3, /* remainder/%rR/%rR/%rR */
      1, /* remainder/%rR/n2/%r0 */
      1, /* remainder/%rR/n2/%r1 */
      2, /* remainder/%rR/n2/%rR */
      2, /* remainder/%rR/nR/%r0 */
      2, /* remainder/%rR/nR/%r1 */
      3, /* remainder/%rR/nR/%rR */
      1, /* remainder/nR/%r0/%r0 */
      1, /* remainder/nR/%r0/%r1 */
      2, /* remainder/nR/%r0/%rR */
      1, /* remainder/nR/%r1/%r0 */
      1, /* remainder/nR/%r1/%r1 */
      2, /* remainder/nR/%r1/%rR */
      2, /* remainder/nR/%rR/%r0 */
      2, /* remainder/nR/%rR/%r1 */
      3, /* remainder/nR/%rR/%rR */
      1, /* remainder/nR/n2/%r0 */
      1, /* remainder/nR/n2/%r1 */
      2, /* remainder/nR/n2/%rR */
      2, /* remainder/nR/nR/%r0 */
      2, /* remainder/nR/nR/%r1 */
      3, /* remainder/nR/nR/%rR */
      0, /* remainder-stack */
      0, /* times/%r0/%r0/%r0 */
      0, /* times/%r0/%r0/%r1 */
      1, /* times/%r0/%r0/%rR */
      0, /* times/%r0/%r1/%r0 */
      0, /* times/%r0/%r1/%r1 */
      1, /* times/%r0/%r1/%rR */
      1, /* times/%r0/%rR/%r0 */
      1, /* times/%r0/%rR/%r1 */
      2, /* times/%r0/%rR/%rR */
      0, /* times/%r0/n2/%r0 */
      0, /* times/%r0/n2/%r1 */
      1, /* times/%r0/n2/%rR */
      1, /* times/%r0/nR/%r0 */
      1, /* times/%r0/nR/%r1 */
      2, /* times/%r0/nR/%rR */
      0, /* times/%r1/%r0/%r0 */
      0, /* times/%r1/%r0/%r1 */
      1, /* times/%r1/%r0/%rR */
      0, /* times/%r1/%r1/%r0 */
      0, /* times/%r1/%r1/%r1 */
      1, /* times/%r1/%r1/%rR */
      1, /* times/%r1/%rR/%r0 */
      1, /* times/%r1/%rR/%r1 */
      2, /* times/%r1/%rR/%rR */
      0, /* times/%r1/n2/%r0 */
      0, /* times/%r1/n2/%r1 */
      1, /* times/%r1/n2/%rR */
      1, /* times/%r1/nR/%r0 */
      1, /* times/%r1/nR/%r1 */
      2, /* times/%r1/nR/%rR */
      1, /* times/%rR/%r0/%r0 */
      1, /* times/%rR/%r0/%r1 */
      2, /* times/%rR/%r0/%rR */
      1, /* times/%rR/%r1/%r0 */
      1, /* times/%rR/%r1/%r1 */
      2, /* times/%rR/%r1/%rR */
      2, /* times/%rR/%rR/%r0 */
      2, /* times/%rR/%rR/%r1 */
      3, /* times/%rR/%rR/%rR */
      1, /* times/%rR/n2/%r0 */
      1, /* times/%rR/n2/%r1 */
      2, /* times/%rR/n2/%rR */
      2, /* times/%rR/nR/%r0 */
      2, /* times/%rR/nR/%r1 */
      3, /* times/%rR/nR/%rR */
      1, /* times/nR/%r0/%r0 */
      1, /* times/nR/%r0/%r1 */
      2, /* times/nR/%r0/%rR */
      1, /* times/nR/%r1/%r0 */
      1, /* times/nR/%r1/%r1 */
      2, /* times/nR/%r1/%rR */
      2, /* times/nR/%rR/%r0 */
      2, /* times/nR/%rR/%r1 */
      3, /* times/nR/%rR/%rR */
      1, /* times/nR/n2/%r0 */
      1, /* times/nR/n2/%r1 */
      2, /* times/nR/n2/%rR */
      2, /* times/nR/nR/%r0 */
      2, /* times/nR/nR/%r1 */
      3, /* times/nR/nR/%rR */
      0, /* times-stack */
      0, /* uminus/%r0/%r0 */
      0, /* uminus/%r0/%r1 */
      1, /* uminus/%r0/%rR */
      0, /* uminus/%r1/%r0 */
      0, /* uminus/%r1/%r1 */
      1, /* uminus/%r1/%rR */
      1, /* uminus/%rR/%r0 */
      1, /* uminus/%rR/%r1 */
      2, /* uminus/%rR/%rR */
      1, /* uminus/nR/%r0 */
      1, /* uminus/nR/%r1 */
      2, /* uminus/nR/%rR */
      0, /* uminus-stack */
      0, /* unreachable */
      1, /* *b/fR*-no-fast-branches */
      1, /* *be/%r0/%r0/fR*-no-fast-branches */
      1, /* *be/%r0/%r1/fR*-no-fast-branches */
      2, /* *be/%r0/%rR/fR*-no-fast-branches */
      1, /* *be/%r0/n0/fR*-no-fast-branches */
      2, /* *be/%r0/nR/fR*-no-fast-branches */
      1, /* *be/%r1/%r0/fR*-no-fast-branches */
      1, /* *be/%r1/%r1/fR*-no-fast-branches */
      2, /* *be/%r1/%rR/fR*-no-fast-branches */
      1, /* *be/%r1/n0/fR*-no-fast-branches */
      2, /* *be/%r1/nR/fR*-no-fast-branches */
      2, /* *be/%rR/%r0/fR*-no-fast-branches */
      2, /* *be/%rR/%r1/fR*-no-fast-branches */
      3, /* *be/%rR/%rR/fR*-no-fast-branches */
      2, /* *be/%rR/n0/fR*-no-fast-branches */
      3, /* *be/%rR/nR/fR*-no-fast-branches */
      1, /* *be/n0/%r0/fR*-no-fast-branches */
      1, /* *be/n0/%r1/fR*-no-fast-branches */
      2, /* *be/n0/%rR/fR*-no-fast-branches */
      1, /* *be/n0/n0/fR*-no-fast-branches */
      2, /* *be/n0/nR/fR*-no-fast-branches */
      2, /* *be/nR/%r0/fR*-no-fast-branches */
      2, /* *be/nR/%r1/fR*-no-fast-branches */
      3, /* *be/nR/%rR/fR*-no-fast-branches */
      2, /* *be/nR/n0/fR*-no-fast-branches */
      3, /* *be/nR/nR/fR*-no-fast-branches */
      1, /* *beqi-stack/n-1/fR*-no-fast-branches */
      1, /* *beqi-stack/n0/fR*-no-fast-branches */
      1, /* *beqi-stack/n1/fR*-no-fast-branches */
      1, /* *beqi-stack/n2/fR*-no-fast-branches */
      2, /* *beqi-stack/nR/fR*-no-fast-branches */
      1, /* *beqr-stack/%r0/fR*-no-fast-branches */
      1, /* *beqr-stack/%r1/fR*-no-fast-branches */
      2, /* *beqr-stack/%rR/fR*-no-fast-branches */
      1, /* *bf-stack/fR*-no-fast-branches */
      1, /* *bg/%r0/%r0/fR*-no-fast-branches */
      1, /* *bg/%r0/%r1/fR*-no-fast-branches */
      2, /* *bg/%r0/%rR/fR*-no-fast-branches */
      1, /* *bg/%r0/n0/fR*-no-fast-branches */
      2, /* *bg/%r0/nR/fR*-no-fast-branches */
      1, /* *bg/%r1/%r0/fR*-no-fast-branches */
      1, /* *bg/%r1/%r1/fR*-no-fast-branches */
      2, /* *bg/%r1/%rR/fR*-no-fast-branches */
      1, /* *bg/%r1/n0/fR*-no-fast-branches */
      2, /* *bg/%r1/nR/fR*-no-fast-branches */
      2, /* *bg/%rR/%r0/fR*-no-fast-branches */
      2, /* *bg/%rR/%r1/fR*-no-fast-branches */
      3, /* *bg/%rR/%rR/fR*-no-fast-branches */
      2, /* *bg/%rR/n0/fR*-no-fast-branches */
      3, /* *bg/%rR/nR/fR*-no-fast-branches */
      1, /* *bg/n0/%r0/fR*-no-fast-branches */
      1, /* *bg/n0/%r1/fR*-no-fast-branches */
      2, /* *bg/n0/%rR/fR*-no-fast-branches */
      1, /* *bg/n0/n0/fR*-no-fast-branches */
      2, /* *bg/n0/nR/fR*-no-fast-branches */
      2, /* *bg/nR/%r0/fR*-no-fast-branches */
      2, /* *bg/nR/%r1/fR*-no-fast-branches */
      3, /* *bg/nR/%rR/fR*-no-fast-branches */
      2, /* *bg/nR/n0/fR*-no-fast-branches */
      3, /* *bg/nR/nR/fR*-no-fast-branches */
      1, /* *bge/%r0/%r0/fR*-no-fast-branches */
      1, /* *bge/%r0/%r1/fR*-no-fast-branches */
      2, /* *bge/%r0/%rR/fR*-no-fast-branches */
      1, /* *bge/%r0/n0/fR*-no-fast-branches */
      2, /* *bge/%r0/nR/fR*-no-fast-branches */
      1, /* *bge/%r1/%r0/fR*-no-fast-branches */
      1, /* *bge/%r1/%r1/fR*-no-fast-branches */
      2, /* *bge/%r1/%rR/fR*-no-fast-branches */
      1, /* *bge/%r1/n0/fR*-no-fast-branches */
      2, /* *bge/%r1/nR/fR*-no-fast-branches */
      2, /* *bge/%rR/%r0/fR*-no-fast-branches */
      2, /* *bge/%rR/%r1/fR*-no-fast-branches */
      3, /* *bge/%rR/%rR/fR*-no-fast-branches */
      2, /* *bge/%rR/n0/fR*-no-fast-branches */
      3, /* *bge/%rR/nR/fR*-no-fast-branches */
      1, /* *bge/n0/%r0/fR*-no-fast-branches */
      1, /* *bge/n0/%r1/fR*-no-fast-branches */
      2, /* *bge/n0/%rR/fR*-no-fast-branches */
      1, /* *bge/n0/n0/fR*-no-fast-branches */
      2, /* *bge/n0/nR/fR*-no-fast-branches */
      2, /* *bge/nR/%r0/fR*-no-fast-branches */
      2, /* *bge/nR/%r1/fR*-no-fast-branches */
      3, /* *bge/nR/%rR/fR*-no-fast-branches */
      2, /* *bge/nR/n0/fR*-no-fast-branches */
      3, /* *bge/nR/nR/fR*-no-fast-branches */
      1, /* *bger-stack/%r0/fR*-no-fast-branches */
      1, /* *bger-stack/%r1/fR*-no-fast-branches */
      2, /* *bger-stack/%rR/fR*-no-fast-branches */
      1, /* *bl/%r0/%r0/fR*-no-fast-branches */
      1, /* *bl/%r0/%r1/fR*-no-fast-branches */
      2, /* *bl/%r0/%rR/fR*-no-fast-branches */
      1, /* *bl/%r0/n0/fR*-no-fast-branches */
      2, /* *bl/%r0/nR/fR*-no-fast-branches */
      1, /* *bl/%r1/%r0/fR*-no-fast-branches */
      1, /* *bl/%r1/%r1/fR*-no-fast-branches */
      2, /* *bl/%r1/%rR/fR*-no-fast-branches */
      1, /* *bl/%r1/n0/fR*-no-fast-branches */
      2, /* *bl/%r1/nR/fR*-no-fast-branches */
      2, /* *bl/%rR/%r0/fR*-no-fast-branches */
      2, /* *bl/%rR/%r1/fR*-no-fast-branches */
      3, /* *bl/%rR/%rR/fR*-no-fast-branches */
      2, /* *bl/%rR/n0/fR*-no-fast-branches */
      3, /* *bl/%rR/nR/fR*-no-fast-branches */
      1, /* *bl/n0/%r0/fR*-no-fast-branches */
      1, /* *bl/n0/%r1/fR*-no-fast-branches */
      2, /* *bl/n0/%rR/fR*-no-fast-branches */
      1, /* *bl/n0/n0/fR*-no-fast-branches */
      2, /* *bl/n0/nR/fR*-no-fast-branches */
      2, /* *bl/nR/%r0/fR*-no-fast-branches */
      2, /* *bl/nR/%r1/fR*-no-fast-branches */
      3, /* *bl/nR/%rR/fR*-no-fast-branches */
      2, /* *bl/nR/n0/fR*-no-fast-branches */
      3, /* *bl/nR/nR/fR*-no-fast-branches */
      1, /* *ble/%r0/%r0/fR*-no-fast-branches */
      1, /* *ble/%r0/%r1/fR*-no-fast-branches */
      2, /* *ble/%r0/%rR/fR*-no-fast-branches */
      1, /* *ble/%r0/n0/fR*-no-fast-branches */
      2, /* *ble/%r0/nR/fR*-no-fast-branches */
      1, /* *ble/%r1/%r0/fR*-no-fast-branches */
      1, /* *ble/%r1/%r1/fR*-no-fast-branches */
      2, /* *ble/%r1/%rR/fR*-no-fast-branches */
      1, /* *ble/%r1/n0/fR*-no-fast-branches */
      2, /* *ble/%r1/nR/fR*-no-fast-branches */
      2, /* *ble/%rR/%r0/fR*-no-fast-branches */
      2, /* *ble/%rR/%r1/fR*-no-fast-branches */
      3, /* *ble/%rR/%rR/fR*-no-fast-branches */
      2, /* *ble/%rR/n0/fR*-no-fast-branches */
      3, /* *ble/%rR/nR/fR*-no-fast-branches */
      1, /* *ble/n0/%r0/fR*-no-fast-branches */
      1, /* *ble/n0/%r1/fR*-no-fast-branches */
      2, /* *ble/n0/%rR/fR*-no-fast-branches */
      1, /* *ble/n0/n0/fR*-no-fast-branches */
      2, /* *ble/n0/nR/fR*-no-fast-branches */
      2, /* *ble/nR/%r0/fR*-no-fast-branches */
      2, /* *ble/nR/%r1/fR*-no-fast-branches */
      3, /* *ble/nR/%rR/fR*-no-fast-branches */
      2, /* *ble/nR/n0/fR*-no-fast-branches */
      3, /* *ble/nR/nR/fR*-no-fast-branches */
      1, /* *bne/%r0/%r0/fR*-no-fast-branches */
      1, /* *bne/%r0/%r1/fR*-no-fast-branches */
      2, /* *bne/%r0/%rR/fR*-no-fast-branches */
      1, /* *bne/%r0/n0/fR*-no-fast-branches */
      2, /* *bne/%r0/nR/fR*-no-fast-branches */
      1, /* *bne/%r1/%r0/fR*-no-fast-branches */
      1, /* *bne/%r1/%r1/fR*-no-fast-branches */
      2, /* *bne/%r1/%rR/fR*-no-fast-branches */
      1, /* *bne/%r1/n0/fR*-no-fast-branches */
      2, /* *bne/%r1/nR/fR*-no-fast-branches */
      2, /* *bne/%rR/%r0/fR*-no-fast-branches */
      2, /* *bne/%rR/%r1/fR*-no-fast-branches */
      3, /* *bne/%rR/%rR/fR*-no-fast-branches */
      2, /* *bne/%rR/n0/fR*-no-fast-branches */
      3, /* *bne/%rR/nR/fR*-no-fast-branches */
      1, /* *bne/n0/%r0/fR*-no-fast-branches */
      1, /* *bne/n0/%r1/fR*-no-fast-branches */
      2, /* *bne/n0/%rR/fR*-no-fast-branches */
      1, /* *bne/n0/n0/fR*-no-fast-branches */
      2, /* *bne/n0/nR/fR*-no-fast-branches */
      2, /* *bne/nR/%r0/fR*-no-fast-branches */
      2, /* *bne/nR/%r1/fR*-no-fast-branches */
      3, /* *bne/nR/%rR/fR*-no-fast-branches */
      2, /* *bne/nR/n0/fR*-no-fast-branches */
      3, /* *bne/nR/nR/fR*-no-fast-branches */
      1, /* *bneqi-stack/n-1/fR*-no-fast-branches */
      1, /* *bneqi-stack/n0/fR*-no-fast-branches */
      1, /* *bneqi-stack/n1/fR*-no-fast-branches */
      1, /* *bneqi-stack/n2/fR*-no-fast-branches */
      2, /* *bneqi-stack/nR/fR*-no-fast-branches */
      1, /* *bneqr-stack/%r0/fR*-no-fast-branches */
      1, /* *bneqr-stack/%r1/fR*-no-fast-branches */
      2, /* *bneqr-stack/%rR/fR*-no-fast-branches */
      1, /* *bt-stack/fR*-no-fast-branches */
      1, /* *pushr-beqr-stack/%r0/%r0/fR*-no-fast-branches */
      1, /* *pushr-beqr-stack/%r0/%r1/fR*-no-fast-branches */
      2, /* *pushr-beqr-stack/%r0/%rR/fR*-no-fast-branches */
      1, /* *pushr-beqr-stack/%r1/%r0/fR*-no-fast-branches */
      1, /* *pushr-beqr-stack/%r1/%r1/fR*-no-fast-branches */
      2, /* *pushr-beqr-stack/%r1/%rR/fR*-no-fast-branches */
      2, /* *pushr-beqr-stack/%rR/%r0/fR*-no-fast-branches */
      2, /* *pushr-beqr-stack/%rR/%r1/fR*-no-fast-branches */
      3, /* *pushr-beqr-stack/%rR/%rR/fR*-no-fast-branches */
      1, /* *pushr-bger-stack/%r0/%r0/fR*-no-fast-branches */
      1, /* *pushr-bger-stack/%r0/%r1/fR*-no-fast-branches */
      2, /* *pushr-bger-stack/%r0/%rR/fR*-no-fast-branches */
      1, /* *pushr-bger-stack/%r1/%r0/fR*-no-fast-branches */
      1, /* *pushr-bger-stack/%r1/%r1/fR*-no-fast-branches */
      2, /* *pushr-bger-stack/%r1/%rR/fR*-no-fast-branches */
      2, /* *pushr-bger-stack/%rR/%r0/fR*-no-fast-branches */
      2, /* *pushr-bger-stack/%rR/%r1/fR*-no-fast-branches */
      3 /* *pushr-bger-stack/%rR/%rR/fR*-no-fast-branches */
    };
const unsigned long // FIXME: shall I use a shorter type when possible?
structuredvm_specialized_instruction_label_bitmasks [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO]
  = {
      /* It's important that !BEGINBASICBLOCK has a zero here: it does not need residual patching. */
      0, /* !INVALID */
      0, /* !BEGINBASICBLOCK */
      0, /* !EXITVM */
      0, /* !DATALOCATIONS */
      0, /* !NOP */
      0, /* !UNREACHABLE0 */
      0, /* !UNREACHABLE1 */
      0, /* !UNREACHABLE2 */
      0 | (1UL << 0), /* b/fR */
      0 | (1UL << 0), /* be/%r0/%r0/fR */
      0 | (1UL << 0), /* be/%r0/%r1/fR */
      0 | (1UL << 1), /* be/%r0/%rR/fR */
      0 | (1UL << 0), /* be/%r0/n0/fR */
      0 | (1UL << 1), /* be/%r0/nR/fR */
      0 | (1UL << 0), /* be/%r1/%r0/fR */
      0 | (1UL << 0), /* be/%r1/%r1/fR */
      0 | (1UL << 1), /* be/%r1/%rR/fR */
      0 | (1UL << 0), /* be/%r1/n0/fR */
      0 | (1UL << 1), /* be/%r1/nR/fR */
      0 | (1UL << 1), /* be/%rR/%r0/fR */
      0 | (1UL << 1), /* be/%rR/%r1/fR */
      0 | (1UL << 2), /* be/%rR/%rR/fR */
      0 | (1UL << 1), /* be/%rR/n0/fR */
      0 | (1UL << 2), /* be/%rR/nR/fR */
      0 | (1UL << 0), /* be/n0/%r0/fR */
      0 | (1UL << 0), /* be/n0/%r1/fR */
      0 | (1UL << 1), /* be/n0/%rR/fR */
      0 | (1UL << 0), /* be/n0/n0/fR */
      0 | (1UL << 1), /* be/n0/nR/fR */
      0 | (1UL << 1), /* be/nR/%r0/fR */
      0 | (1UL << 1), /* be/nR/%r1/fR */
      0 | (1UL << 2), /* be/nR/%rR/fR */
      0 | (1UL << 1), /* be/nR/n0/fR */
      0 | (1UL << 2), /* be/nR/nR/fR */
      0 | (1UL << 0), /* beqi-stack/n-1/fR */
      0 | (1UL << 0), /* beqi-stack/n0/fR */
      0 | (1UL << 0), /* beqi-stack/n1/fR */
      0 | (1UL << 0), /* beqi-stack/n2/fR */
      0 | (1UL << 1), /* beqi-stack/nR/fR */
      0 | (1UL << 0), /* beqr-stack/%r0/fR */
      0 | (1UL << 0), /* beqr-stack/%r1/fR */
      0 | (1UL << 1), /* beqr-stack/%rR/fR */
      0 | (1UL << 0), /* bf-stack/fR */
      0 | (1UL << 0), /* bg/%r0/%r0/fR */
      0 | (1UL << 0), /* bg/%r0/%r1/fR */
      0 | (1UL << 1), /* bg/%r0/%rR/fR */
      0 | (1UL << 0), /* bg/%r0/n0/fR */
      0 | (1UL << 1), /* bg/%r0/nR/fR */
      0 | (1UL << 0), /* bg/%r1/%r0/fR */
      0 | (1UL << 0), /* bg/%r1/%r1/fR */
      0 | (1UL << 1), /* bg/%r1/%rR/fR */
      0 | (1UL << 0), /* bg/%r1/n0/fR */
      0 | (1UL << 1), /* bg/%r1/nR/fR */
      0 | (1UL << 1), /* bg/%rR/%r0/fR */
      0 | (1UL << 1), /* bg/%rR/%r1/fR */
      0 | (1UL << 2), /* bg/%rR/%rR/fR */
      0 | (1UL << 1), /* bg/%rR/n0/fR */
      0 | (1UL << 2), /* bg/%rR/nR/fR */
      0 | (1UL << 0), /* bg/n0/%r0/fR */
      0 | (1UL << 0), /* bg/n0/%r1/fR */
      0 | (1UL << 1), /* bg/n0/%rR/fR */
      0 | (1UL << 0), /* bg/n0/n0/fR */
      0 | (1UL << 1), /* bg/n0/nR/fR */
      0 | (1UL << 1), /* bg/nR/%r0/fR */
      0 | (1UL << 1), /* bg/nR/%r1/fR */
      0 | (1UL << 2), /* bg/nR/%rR/fR */
      0 | (1UL << 1), /* bg/nR/n0/fR */
      0 | (1UL << 2), /* bg/nR/nR/fR */
      0 | (1UL << 0), /* bge/%r0/%r0/fR */
      0 | (1UL << 0), /* bge/%r0/%r1/fR */
      0 | (1UL << 1), /* bge/%r0/%rR/fR */
      0 | (1UL << 0), /* bge/%r0/n0/fR */
      0 | (1UL << 1), /* bge/%r0/nR/fR */
      0 | (1UL << 0), /* bge/%r1/%r0/fR */
      0 | (1UL << 0), /* bge/%r1/%r1/fR */
      0 | (1UL << 1), /* bge/%r1/%rR/fR */
      0 | (1UL << 0), /* bge/%r1/n0/fR */
      0 | (1UL << 1), /* bge/%r1/nR/fR */
      0 | (1UL << 1), /* bge/%rR/%r0/fR */
      0 | (1UL << 1), /* bge/%rR/%r1/fR */
      0 | (1UL << 2), /* bge/%rR/%rR/fR */
      0 | (1UL << 1), /* bge/%rR/n0/fR */
      0 | (1UL << 2), /* bge/%rR/nR/fR */
      0 | (1UL << 0), /* bge/n0/%r0/fR */
      0 | (1UL << 0), /* bge/n0/%r1/fR */
      0 | (1UL << 1), /* bge/n0/%rR/fR */
      0 | (1UL << 0), /* bge/n0/n0/fR */
      0 | (1UL << 1), /* bge/n0/nR/fR */
      0 | (1UL << 1), /* bge/nR/%r0/fR */
      0 | (1UL << 1), /* bge/nR/%r1/fR */
      0 | (1UL << 2), /* bge/nR/%rR/fR */
      0 | (1UL << 1), /* bge/nR/n0/fR */
      0 | (1UL << 2), /* bge/nR/nR/fR */
      0 | (1UL << 0), /* bger-stack/%r0/fR */
      0 | (1UL << 0), /* bger-stack/%r1/fR */
      0 | (1UL << 1), /* bger-stack/%rR/fR */
      0 | (1UL << 0), /* bl/%r0/%r0/fR */
      0 | (1UL << 0), /* bl/%r0/%r1/fR */
      0 | (1UL << 1), /* bl/%r0/%rR/fR */
      0 | (1UL << 0), /* bl/%r0/n0/fR */
      0 | (1UL << 1), /* bl/%r0/nR/fR */
      0 | (1UL << 0), /* bl/%r1/%r0/fR */
      0 | (1UL << 0), /* bl/%r1/%r1/fR */
      0 | (1UL << 1), /* bl/%r1/%rR/fR */
      0 | (1UL << 0), /* bl/%r1/n0/fR */
      0 | (1UL << 1), /* bl/%r1/nR/fR */
      0 | (1UL << 1), /* bl/%rR/%r0/fR */
      0 | (1UL << 1), /* bl/%rR/%r1/fR */
      0 | (1UL << 2), /* bl/%rR/%rR/fR */
      0 | (1UL << 1), /* bl/%rR/n0/fR */
      0 | (1UL << 2), /* bl/%rR/nR/fR */
      0 | (1UL << 0), /* bl/n0/%r0/fR */
      0 | (1UL << 0), /* bl/n0/%r1/fR */
      0 | (1UL << 1), /* bl/n0/%rR/fR */
      0 | (1UL << 0), /* bl/n0/n0/fR */
      0 | (1UL << 1), /* bl/n0/nR/fR */
      0 | (1UL << 1), /* bl/nR/%r0/fR */
      0 | (1UL << 1), /* bl/nR/%r1/fR */
      0 | (1UL << 2), /* bl/nR/%rR/fR */
      0 | (1UL << 1), /* bl/nR/n0/fR */
      0 | (1UL << 2), /* bl/nR/nR/fR */
      0 | (1UL << 0), /* ble/%r0/%r0/fR */
      0 | (1UL << 0), /* ble/%r0/%r1/fR */
      0 | (1UL << 1), /* ble/%r0/%rR/fR */
      0 | (1UL << 0), /* ble/%r0/n0/fR */
      0 | (1UL << 1), /* ble/%r0/nR/fR */
      0 | (1UL << 0), /* ble/%r1/%r0/fR */
      0 | (1UL << 0), /* ble/%r1/%r1/fR */
      0 | (1UL << 1), /* ble/%r1/%rR/fR */
      0 | (1UL << 0), /* ble/%r1/n0/fR */
      0 | (1UL << 1), /* ble/%r1/nR/fR */
      0 | (1UL << 1), /* ble/%rR/%r0/fR */
      0 | (1UL << 1), /* ble/%rR/%r1/fR */
      0 | (1UL << 2), /* ble/%rR/%rR/fR */
      0 | (1UL << 1), /* ble/%rR/n0/fR */
      0 | (1UL << 2), /* ble/%rR/nR/fR */
      0 | (1UL << 0), /* ble/n0/%r0/fR */
      0 | (1UL << 0), /* ble/n0/%r1/fR */
      0 | (1UL << 1), /* ble/n0/%rR/fR */
      0 | (1UL << 0), /* ble/n0/n0/fR */
      0 | (1UL << 1), /* ble/n0/nR/fR */
      0 | (1UL << 1), /* ble/nR/%r0/fR */
      0 | (1UL << 1), /* ble/nR/%r1/fR */
      0 | (1UL << 2), /* ble/nR/%rR/fR */
      0 | (1UL << 1), /* ble/nR/n0/fR */
      0 | (1UL << 2), /* ble/nR/nR/fR */
      0 | (1UL << 0), /* bne/%r0/%r0/fR */
      0 | (1UL << 0), /* bne/%r0/%r1/fR */
      0 | (1UL << 1), /* bne/%r0/%rR/fR */
      0 | (1UL << 0), /* bne/%r0/n0/fR */
      0 | (1UL << 1), /* bne/%r0/nR/fR */
      0 | (1UL << 0), /* bne/%r1/%r0/fR */
      0 | (1UL << 0), /* bne/%r1/%r1/fR */
      0 | (1UL << 1), /* bne/%r1/%rR/fR */
      0 | (1UL << 0), /* bne/%r1/n0/fR */
      0 | (1UL << 1), /* bne/%r1/nR/fR */
      0 | (1UL << 1), /* bne/%rR/%r0/fR */
      0 | (1UL << 1), /* bne/%rR/%r1/fR */
      0 | (1UL << 2), /* bne/%rR/%rR/fR */
      0 | (1UL << 1), /* bne/%rR/n0/fR */
      0 | (1UL << 2), /* bne/%rR/nR/fR */
      0 | (1UL << 0), /* bne/n0/%r0/fR */
      0 | (1UL << 0), /* bne/n0/%r1/fR */
      0 | (1UL << 1), /* bne/n0/%rR/fR */
      0 | (1UL << 0), /* bne/n0/n0/fR */
      0 | (1UL << 1), /* bne/n0/nR/fR */
      0 | (1UL << 1), /* bne/nR/%r0/fR */
      0 | (1UL << 1), /* bne/nR/%r1/fR */
      0 | (1UL << 2), /* bne/nR/%rR/fR */
      0 | (1UL << 1), /* bne/nR/n0/fR */
      0 | (1UL << 2), /* bne/nR/nR/fR */
      0 | (1UL << 0), /* bneqi-stack/n-1/fR */
      0 | (1UL << 0), /* bneqi-stack/n0/fR */
      0 | (1UL << 0), /* bneqi-stack/n1/fR */
      0 | (1UL << 0), /* bneqi-stack/n2/fR */
      0 | (1UL << 1), /* bneqi-stack/nR/fR */
      0 | (1UL << 0), /* bneqr-stack/%r0/fR */
      0 | (1UL << 0), /* bneqr-stack/%r1/fR */
      0 | (1UL << 1), /* bneqr-stack/%rR/fR */
      0 | (1UL << 0), /* bt-stack/fR */
      0, /* copy-to-r-stack/%r0 */
      0, /* copy-to-r-stack/%r1 */
      0, /* copy-to-r-stack/%rR */
      0, /* different-stack */
      0, /* differenti-stack/n0 */
      0, /* differenti-stack/n1 */
      0, /* differenti-stack/n2 */
      0, /* differenti-stack/nR */
      0, /* divided/%r0/%r0/%r0 */
      0, /* divided/%r0/%r0/%r1 */
      0, /* divided/%r0/%r0/%rR */
      0, /* divided/%r0/%r1/%r0 */
      0, /* divided/%r0/%r1/%r1 */
      0, /* divided/%r0/%r1/%rR */
      0, /* divided/%r0/%rR/%r0 */
      0, /* divided/%r0/%rR/%r1 */
      0, /* divided/%r0/%rR/%rR */
      0, /* divided/%r0/n2/%r0 */
      0, /* divided/%r0/n2/%r1 */
      0, /* divided/%r0/n2/%rR */
      0, /* divided/%r0/nR/%r0 */
      0, /* divided/%r0/nR/%r1 */
      0, /* divided/%r0/nR/%rR */
      0, /* divided/%r1/%r0/%r0 */
      0, /* divided/%r1/%r0/%r1 */
      0, /* divided/%r1/%r0/%rR */
      0, /* divided/%r1/%r1/%r0 */
      0, /* divided/%r1/%r1/%r1 */
      0, /* divided/%r1/%r1/%rR */
      0, /* divided/%r1/%rR/%r0 */
      0, /* divided/%r1/%rR/%r1 */
      0, /* divided/%r1/%rR/%rR */
      0, /* divided/%r1/n2/%r0 */
      0, /* divided/%r1/n2/%r1 */
      0, /* divided/%r1/n2/%rR */
      0, /* divided/%r1/nR/%r0 */
      0, /* divided/%r1/nR/%r1 */
      0, /* divided/%r1/nR/%rR */
      0, /* divided/%rR/%r0/%r0 */
      0, /* divided/%rR/%r0/%r1 */
      0, /* divided/%rR/%r0/%rR */
      0, /* divided/%rR/%r1/%r0 */
      0, /* divided/%rR/%r1/%r1 */
      0, /* divided/%rR/%r1/%rR */
      0, /* divided/%rR/%rR/%r0 */
      0, /* divided/%rR/%rR/%r1 */
      0, /* divided/%rR/%rR/%rR */
      0, /* divided/%rR/n2/%r0 */
      0, /* divided/%rR/n2/%r1 */
      0, /* divided/%rR/n2/%rR */
      0, /* divided/%rR/nR/%r0 */
      0, /* divided/%rR/nR/%r1 */
      0, /* divided/%rR/nR/%rR */
      0, /* divided/nR/%r0/%r0 */
      0, /* divided/nR/%r0/%r1 */
      0, /* divided/nR/%r0/%rR */
      0, /* divided/nR/%r1/%r0 */
      0, /* divided/nR/%r1/%r1 */
      0, /* divided/nR/%r1/%rR */
      0, /* divided/nR/%rR/%r0 */
      0, /* divided/nR/%rR/%r1 */
      0, /* divided/nR/%rR/%rR */
      0, /* divided/nR/n2/%r0 */
      0, /* divided/nR/n2/%r1 */
      0, /* divided/nR/n2/%rR */
      0, /* divided/nR/nR/%r0 */
      0, /* divided/nR/nR/%r1 */
      0, /* divided/nR/nR/%rR */
      0, /* divided-stack */
      0, /* drop-stack */
      0, /* dup-stack */
      0, /* equal-stack */
      0, /* equali-stack/n0 */
      0, /* equali-stack/n1 */
      0, /* equali-stack/n2 */
      0, /* equali-stack/nR */
      0, /* exitvm */
      0, /* greater-stack */
      0, /* greaterorequal-stack */
      0, /* input/%r0/retR */
      0, /* input/%r1/retR */
      0, /* input/%rR/retR */
      0, /* input-stack/retR */
      0, /* isnonzero-stack */
      0, /* less-stack */
      0, /* lessorequal-stack */
      0, /* logicaland-stack */
      0, /* logicalnot-stack */
      0, /* logicalor-stack */
      0, /* minus/%r0/%r0/%r0 */
      0, /* minus/%r0/%r0/%r1 */
      0, /* minus/%r0/%r0/%rR */
      0, /* minus/%r0/%r1/%r0 */
      0, /* minus/%r0/%r1/%r1 */
      0, /* minus/%r0/%r1/%rR */
      0, /* minus/%r0/%rR/%r0 */
      0, /* minus/%r0/%rR/%r1 */
      0, /* minus/%r0/%rR/%rR */
      0, /* minus/%r0/n1/%r0 */
      0, /* minus/%r0/n1/%r1 */
      0, /* minus/%r0/n1/%rR */
      0, /* minus/%r0/n2/%r0 */
      0, /* minus/%r0/n2/%r1 */
      0, /* minus/%r0/n2/%rR */
      0, /* minus/%r0/nR/%r0 */
      0, /* minus/%r0/nR/%r1 */
      0, /* minus/%r0/nR/%rR */
      0, /* minus/%r1/%r0/%r0 */
      0, /* minus/%r1/%r0/%r1 */
      0, /* minus/%r1/%r0/%rR */
      0, /* minus/%r1/%r1/%r0 */
      0, /* minus/%r1/%r1/%r1 */
      0, /* minus/%r1/%r1/%rR */
      0, /* minus/%r1/%rR/%r0 */
      0, /* minus/%r1/%rR/%r1 */
      0, /* minus/%r1/%rR/%rR */
      0, /* minus/%r1/n1/%r0 */
      0, /* minus/%r1/n1/%r1 */
      0, /* minus/%r1/n1/%rR */
      0, /* minus/%r1/n2/%r0 */
      0, /* minus/%r1/n2/%r1 */
      0, /* minus/%r1/n2/%rR */
      0, /* minus/%r1/nR/%r0 */
      0, /* minus/%r1/nR/%r1 */
      0, /* minus/%r1/nR/%rR */
      0, /* minus/%rR/%r0/%r0 */
      0, /* minus/%rR/%r0/%r1 */
      0, /* minus/%rR/%r0/%rR */
      0, /* minus/%rR/%r1/%r0 */
      0, /* minus/%rR/%r1/%r1 */
      0, /* minus/%rR/%r1/%rR */
      0, /* minus/%rR/%rR/%r0 */
      0, /* minus/%rR/%rR/%r1 */
      0, /* minus/%rR/%rR/%rR */
      0, /* minus/%rR/n1/%r0 */
      0, /* minus/%rR/n1/%r1 */
      0, /* minus/%rR/n1/%rR */
      0, /* minus/%rR/n2/%r0 */
      0, /* minus/%rR/n2/%r1 */
      0, /* minus/%rR/n2/%rR */
      0, /* minus/%rR/nR/%r0 */
      0, /* minus/%rR/nR/%r1 */
      0, /* minus/%rR/nR/%rR */
      0, /* minus/nR/%r0/%r0 */
      0, /* minus/nR/%r0/%r1 */
      0, /* minus/nR/%r0/%rR */
      0, /* minus/nR/%r1/%r0 */
      0, /* minus/nR/%r1/%r1 */
      0, /* minus/nR/%r1/%rR */
      0, /* minus/nR/%rR/%r0 */
      0, /* minus/nR/%rR/%r1 */
      0, /* minus/nR/%rR/%rR */
      0, /* minus/nR/n1/%r0 */
      0, /* minus/nR/n1/%r1 */
      0, /* minus/nR/n1/%rR */
      0, /* minus/nR/n2/%r0 */
      0, /* minus/nR/n2/%r1 */
      0, /* minus/nR/n2/%rR */
      0, /* minus/nR/nR/%r0 */
      0, /* minus/nR/nR/%r1 */
      0, /* minus/nR/nR/%rR */
      0, /* minus-stack */
      0, /* minusi-stack/n1 */
      0, /* minusi-stack/n2 */
      0, /* minusi-stack/nR */
      0, /* minusr-stack/%r0 */
      0, /* minusr-stack/%r1 */
      0, /* minusr-stack/%rR */
      0, /* mov/%r0/%r0 */
      0, /* mov/%r0/%r1 */
      0, /* mov/%r0/%rR */
      0, /* mov/%r1/%r0 */
      0, /* mov/%r1/%r1 */
      0, /* mov/%r1/%rR */
      0, /* mov/%rR/%r0 */
      0, /* mov/%rR/%r1 */
      0, /* mov/%rR/%rR */
      0, /* mov/n0/%r0 */
      0, /* mov/n0/%r1 */
      0, /* mov/n0/%rR */
      0, /* mov/n1/%r0 */
      0, /* mov/n1/%r1 */
      0, /* mov/n1/%rR */
      0, /* mov/n-1/%r0 */
      0, /* mov/n-1/%r1 */
      0, /* mov/n-1/%rR */
      0, /* mov/n2/%r0 */
      0, /* mov/n2/%r1 */
      0, /* mov/n2/%rR */
      0, /* mov/nR/%r0 */
      0, /* mov/nR/%r1 */
      0, /* mov/nR/%rR */
      0, /* plus/%r0/%r0/%r0 */
      0, /* plus/%r0/%r0/%r1 */
      0, /* plus/%r0/%r0/%rR */
      0, /* plus/%r0/%r1/%r0 */
      0, /* plus/%r0/%r1/%r1 */
      0, /* plus/%r0/%r1/%rR */
      0, /* plus/%r0/%rR/%r0 */
      0, /* plus/%r0/%rR/%r1 */
      0, /* plus/%r0/%rR/%rR */
      0, /* plus/%r0/n1/%r0 */
      0, /* plus/%r0/n1/%r1 */
      0, /* plus/%r0/n1/%rR */
      0, /* plus/%r0/n2/%r0 */
      0, /* plus/%r0/n2/%r1 */
      0, /* plus/%r0/n2/%rR */
      0, /* plus/%r0/nR/%r0 */
      0, /* plus/%r0/nR/%r1 */
      0, /* plus/%r0/nR/%rR */
      0, /* plus/%r1/%r0/%r0 */
      0, /* plus/%r1/%r0/%r1 */
      0, /* plus/%r1/%r0/%rR */
      0, /* plus/%r1/%r1/%r0 */
      0, /* plus/%r1/%r1/%r1 */
      0, /* plus/%r1/%r1/%rR */
      0, /* plus/%r1/%rR/%r0 */
      0, /* plus/%r1/%rR/%r1 */
      0, /* plus/%r1/%rR/%rR */
      0, /* plus/%r1/n1/%r0 */
      0, /* plus/%r1/n1/%r1 */
      0, /* plus/%r1/n1/%rR */
      0, /* plus/%r1/n2/%r0 */
      0, /* plus/%r1/n2/%r1 */
      0, /* plus/%r1/n2/%rR */
      0, /* plus/%r1/nR/%r0 */
      0, /* plus/%r1/nR/%r1 */
      0, /* plus/%r1/nR/%rR */
      0, /* plus/%rR/%r0/%r0 */
      0, /* plus/%rR/%r0/%r1 */
      0, /* plus/%rR/%r0/%rR */
      0, /* plus/%rR/%r1/%r0 */
      0, /* plus/%rR/%r1/%r1 */
      0, /* plus/%rR/%r1/%rR */
      0, /* plus/%rR/%rR/%r0 */
      0, /* plus/%rR/%rR/%r1 */
      0, /* plus/%rR/%rR/%rR */
      0, /* plus/%rR/n1/%r0 */
      0, /* plus/%rR/n1/%r1 */
      0, /* plus/%rR/n1/%rR */
      0, /* plus/%rR/n2/%r0 */
      0, /* plus/%rR/n2/%r1 */
      0, /* plus/%rR/n2/%rR */
      0, /* plus/%rR/nR/%r0 */
      0, /* plus/%rR/nR/%r1 */
      0, /* plus/%rR/nR/%rR */
      0, /* plus/nR/%r0/%r0 */
      0, /* plus/nR/%r0/%r1 */
      0, /* plus/nR/%r0/%rR */
      0, /* plus/nR/%r1/%r0 */
      0, /* plus/nR/%r1/%r1 */
      0, /* plus/nR/%r1/%rR */
      0, /* plus/nR/%rR/%r0 */
      0, /* plus/nR/%rR/%r1 */
      0, /* plus/nR/%rR/%rR */
      0, /* plus/nR/n1/%r0 */
      0, /* plus/nR/n1/%r1 */
      0, /* plus/nR/n1/%rR */
      0, /* plus/nR/n2/%r0 */
      0, /* plus/nR/n2/%r1 */
      0, /* plus/nR/n2/%rR */
      0, /* plus/nR/nR/%r0 */
      0, /* plus/nR/nR/%r1 */
      0, /* plus/nR/nR/%rR */
      0, /* plus-stack */
      0, /* plusi-stack/n-1 */
      0, /* plusi-stack/n1 */
      0, /* plusi-stack/n2 */
      0, /* plusi-stack/nR */
      0, /* pop-stack/%r0 */
      0, /* pop-stack/%r1 */
      0, /* pop-stack/%rR */
      0, /* print/%r0/retR */
      0, /* print/%r1/retR */
      0, /* print/%rR/retR */
      0, /* print/nR/retR */
      0, /* print-stack/retR */
      0, /* push-stack/%r0 */
      0, /* push-stack/%r1 */
      0, /* push-stack/%rR */
      0, /* push-stack/n0 */
      0, /* push-stack/n1 */
      0, /* push-stack/n-1 */
      0, /* push-stack/n2 */
      0, /* push-stack/nR */
      0 | (1UL << 0), /* push-stack/lR */
      0 | (1UL << 0), /* pushr-beqr-stack/%r0/%r0/fR */
      0 | (1UL << 0), /* pushr-beqr-stack/%r0/%r1/fR */
      0 | (1UL << 1), /* pushr-beqr-stack/%r0/%rR/fR */
      0 | (1UL << 0), /* pushr-beqr-stack/%r1/%r0/fR */
      0 | (1UL << 0), /* pushr-beqr-stack/%r1/%r1/fR */
      0 | (1UL << 1), /* pushr-beqr-stack/%r1/%rR/fR */
      0 | (1UL << 1), /* pushr-beqr-stack/%rR/%r0/fR */
      0 | (1UL << 1), /* pushr-beqr-stack/%rR/%r1/fR */
      0 | (1UL << 2), /* pushr-beqr-stack/%rR/%rR/fR */
      0 | (1UL << 0), /* pushr-bger-stack/%r0/%r0/fR */
      0 | (1UL << 0), /* pushr-bger-stack/%r0/%r1/fR */
      0 | (1UL << 1), /* pushr-bger-stack/%r0/%rR/fR */
      0 | (1UL << 0), /* pushr-bger-stack/%r1/%r0/fR */
      0 | (1UL << 0), /* pushr-bger-stack/%r1/%r1/fR */
      0 | (1UL << 1), /* pushr-bger-stack/%r1/%rR/fR */
      0 | (1UL << 1), /* pushr-bger-stack/%rR/%r0/fR */
      0 | (1UL << 1), /* pushr-bger-stack/%rR/%r1/fR */
      0 | (1UL << 2), /* pushr-bger-stack/%rR/%rR/fR */
      0, /* pushr-minusr-pop-stack/%r0/%r0/%r0 */
      0, /* pushr-minusr-pop-stack/%r0/%r0/%r1 */
      0, /* pushr-minusr-pop-stack/%r0/%r0/%rR */
      0, /* pushr-minusr-pop-stack/%r0/%r1/%r0 */
      0, /* pushr-minusr-pop-stack/%r0/%r1/%r1 */
      0, /* pushr-minusr-pop-stack/%r0/%r1/%rR */
      0, /* pushr-minusr-pop-stack/%r0/%rR/%r0 */
      0, /* pushr-minusr-pop-stack/%r0/%rR/%r1 */
      0, /* pushr-minusr-pop-stack/%r0/%rR/%rR */
      0, /* pushr-minusr-pop-stack/%r1/%r0/%r0 */
      0, /* pushr-minusr-pop-stack/%r1/%r0/%r1 */
      0, /* pushr-minusr-pop-stack/%r1/%r0/%rR */
      0, /* pushr-minusr-pop-stack/%r1/%r1/%r0 */
      0, /* pushr-minusr-pop-stack/%r1/%r1/%r1 */
      0, /* pushr-minusr-pop-stack/%r1/%r1/%rR */
      0, /* pushr-minusr-pop-stack/%r1/%rR/%r0 */
      0, /* pushr-minusr-pop-stack/%r1/%rR/%r1 */
      0, /* pushr-minusr-pop-stack/%r1/%rR/%rR */
      0, /* pushr-minusr-pop-stack/%rR/%r0/%r0 */
      0, /* pushr-minusr-pop-stack/%rR/%r0/%r1 */
      0, /* pushr-minusr-pop-stack/%rR/%r0/%rR */
      0, /* pushr-minusr-pop-stack/%rR/%r1/%r0 */
      0, /* pushr-minusr-pop-stack/%rR/%r1/%r1 */
      0, /* pushr-minusr-pop-stack/%rR/%r1/%rR */
      0, /* pushr-minusr-pop-stack/%rR/%rR/%r0 */
      0, /* pushr-minusr-pop-stack/%rR/%rR/%r1 */
      0, /* pushr-minusr-pop-stack/%rR/%rR/%rR */
      0, /* remainder/%r0/%r0/%r0 */
      0, /* remainder/%r0/%r0/%r1 */
      0, /* remainder/%r0/%r0/%rR */
      0, /* remainder/%r0/%r1/%r0 */
      0, /* remainder/%r0/%r1/%r1 */
      0, /* remainder/%r0/%r1/%rR */
      0, /* remainder/%r0/%rR/%r0 */
      0, /* remainder/%r0/%rR/%r1 */
      0, /* remainder/%r0/%rR/%rR */
      0, /* remainder/%r0/n2/%r0 */
      0, /* remainder/%r0/n2/%r1 */
      0, /* remainder/%r0/n2/%rR */
      0, /* remainder/%r0/nR/%r0 */
      0, /* remainder/%r0/nR/%r1 */
      0, /* remainder/%r0/nR/%rR */
      0, /* remainder/%r1/%r0/%r0 */
      0, /* remainder/%r1/%r0/%r1 */
      0, /* remainder/%r1/%r0/%rR */
      0, /* remainder/%r1/%r1/%r0 */
      0, /* remainder/%r1/%r1/%r1 */
      0, /* remainder/%r1/%r1/%rR */
      0, /* remainder/%r1/%rR/%r0 */
      0, /* remainder/%r1/%rR/%r1 */
      0, /* remainder/%r1/%rR/%rR */
      0, /* remainder/%r1/n2/%r0 */
      0, /* remainder/%r1/n2/%r1 */
      0, /* remainder/%r1/n2/%rR */
      0, /* remainder/%r1/nR/%r0 */
      0, /* remainder/%r1/nR/%r1 */
      0, /* remainder/%r1/nR/%rR */
      0, /* remainder/%rR/%r0/%r0 */
      0, /* remainder/%rR/%r0/%r1 */
      0, /* remainder/%rR/%r0/%rR */
      0, /* remainder/%rR/%r1/%r0 */
      0, /* remainder/%rR/%r1/%r1 */
      0, /* remainder/%rR/%r1/%rR */
      0, /* remainder/%rR/%rR/%r0 */
      0, /* remainder/%rR/%rR/%r1 */
      0, /* remainder/%rR/%rR/%rR */
      0, /* remainder/%rR/n2/%r0 */
      0, /* remainder/%rR/n2/%r1 */
      0, /* remainder/%rR/n2/%rR */
      0, /* remainder/%rR/nR/%r0 */
      0, /* remainder/%rR/nR/%r1 */
      0, /* remainder/%rR/nR/%rR */
      0, /* remainder/nR/%r0/%r0 */
      0, /* remainder/nR/%r0/%r1 */
      0, /* remainder/nR/%r0/%rR */
      0, /* remainder/nR/%r1/%r0 */
      0, /* remainder/nR/%r1/%r1 */
      0, /* remainder/nR/%r1/%rR */
      0, /* remainder/nR/%rR/%r0 */
      0, /* remainder/nR/%rR/%r1 */
      0, /* remainder/nR/%rR/%rR */
      0, /* remainder/nR/n2/%r0 */
      0, /* remainder/nR/n2/%r1 */
      0, /* remainder/nR/n2/%rR */
      0, /* remainder/nR/nR/%r0 */
      0, /* remainder/nR/nR/%r1 */
      0, /* remainder/nR/nR/%rR */
      0, /* remainder-stack */
      0, /* times/%r0/%r0/%r0 */
      0, /* times/%r0/%r0/%r1 */
      0, /* times/%r0/%r0/%rR */
      0, /* times/%r0/%r1/%r0 */
      0, /* times/%r0/%r1/%r1 */
      0, /* times/%r0/%r1/%rR */
      0, /* times/%r0/%rR/%r0 */
      0, /* times/%r0/%rR/%r1 */
      0, /* times/%r0/%rR/%rR */
      0, /* times/%r0/n2/%r0 */
      0, /* times/%r0/n2/%r1 */
      0, /* times/%r0/n2/%rR */
      0, /* times/%r0/nR/%r0 */
      0, /* times/%r0/nR/%r1 */
      0, /* times/%r0/nR/%rR */
      0, /* times/%r1/%r0/%r0 */
      0, /* times/%r1/%r0/%r1 */
      0, /* times/%r1/%r0/%rR */
      0, /* times/%r1/%r1/%r0 */
      0, /* times/%r1/%r1/%r1 */
      0, /* times/%r1/%r1/%rR */
      0, /* times/%r1/%rR/%r0 */
      0, /* times/%r1/%rR/%r1 */
      0, /* times/%r1/%rR/%rR */
      0, /* times/%r1/n2/%r0 */
      0, /* times/%r1/n2/%r1 */
      0, /* times/%r1/n2/%rR */
      0, /* times/%r1/nR/%r0 */
      0, /* times/%r1/nR/%r1 */
      0, /* times/%r1/nR/%rR */
      0, /* times/%rR/%r0/%r0 */
      0, /* times/%rR/%r0/%r1 */
      0, /* times/%rR/%r0/%rR */
      0, /* times/%rR/%r1/%r0 */
      0, /* times/%rR/%r1/%r1 */
      0, /* times/%rR/%r1/%rR */
      0, /* times/%rR/%rR/%r0 */
      0, /* times/%rR/%rR/%r1 */
      0, /* times/%rR/%rR/%rR */
      0, /* times/%rR/n2/%r0 */
      0, /* times/%rR/n2/%r1 */
      0, /* times/%rR/n2/%rR */
      0, /* times/%rR/nR/%r0 */
      0, /* times/%rR/nR/%r1 */
      0, /* times/%rR/nR/%rR */
      0, /* times/nR/%r0/%r0 */
      0, /* times/nR/%r0/%r1 */
      0, /* times/nR/%r0/%rR */
      0, /* times/nR/%r1/%r0 */
      0, /* times/nR/%r1/%r1 */
      0, /* times/nR/%r1/%rR */
      0, /* times/nR/%rR/%r0 */
      0, /* times/nR/%rR/%r1 */
      0, /* times/nR/%rR/%rR */
      0, /* times/nR/n2/%r0 */
      0, /* times/nR/n2/%r1 */
      0, /* times/nR/n2/%rR */
      0, /* times/nR/nR/%r0 */
      0, /* times/nR/nR/%r1 */
      0, /* times/nR/nR/%rR */
      0, /* times-stack */
      0, /* uminus/%r0/%r0 */
      0, /* uminus/%r0/%r1 */
      0, /* uminus/%r0/%rR */
      0, /* uminus/%r1/%r0 */
      0, /* uminus/%r1/%r1 */
      0, /* uminus/%r1/%rR */
      0, /* uminus/%rR/%r0 */
      0, /* uminus/%rR/%r1 */
      0, /* uminus/%rR/%rR */
      0, /* uminus/nR/%r0 */
      0, /* uminus/nR/%r1 */
      0, /* uminus/nR/%rR */
      0, /* uminus-stack */
      0, /* unreachable */
      0 | (1UL << 0), /* *b/fR*-no-fast-branches */
      0 | (1UL << 0), /* *be/%r0/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *be/%r0/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *be/%r0/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *be/%r0/n0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *be/%r0/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *be/%r1/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *be/%r1/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *be/%r1/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *be/%r1/n0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *be/%r1/nR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *be/%rR/%r0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *be/%rR/%r1/fR*-no-fast-branches */
      0 | (1UL << 2), /* *be/%rR/%rR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *be/%rR/n0/fR*-no-fast-branches */
      0 | (1UL << 2), /* *be/%rR/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *be/n0/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *be/n0/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *be/n0/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *be/n0/n0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *be/n0/nR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *be/nR/%r0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *be/nR/%r1/fR*-no-fast-branches */
      0 | (1UL << 2), /* *be/nR/%rR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *be/nR/n0/fR*-no-fast-branches */
      0 | (1UL << 2), /* *be/nR/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *beqi-stack/n-1/fR*-no-fast-branches */
      0 | (1UL << 0), /* *beqi-stack/n0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *beqi-stack/n1/fR*-no-fast-branches */
      0 | (1UL << 0), /* *beqi-stack/n2/fR*-no-fast-branches */
      0 | (1UL << 1), /* *beqi-stack/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *beqr-stack/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *beqr-stack/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *beqr-stack/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bf-stack/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bg/%r0/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bg/%r0/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bg/%r0/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bg/%r0/n0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bg/%r0/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bg/%r1/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bg/%r1/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bg/%r1/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bg/%r1/n0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bg/%r1/nR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bg/%rR/%r0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bg/%rR/%r1/fR*-no-fast-branches */
      0 | (1UL << 2), /* *bg/%rR/%rR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bg/%rR/n0/fR*-no-fast-branches */
      0 | (1UL << 2), /* *bg/%rR/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bg/n0/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bg/n0/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bg/n0/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bg/n0/n0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bg/n0/nR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bg/nR/%r0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bg/nR/%r1/fR*-no-fast-branches */
      0 | (1UL << 2), /* *bg/nR/%rR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bg/nR/n0/fR*-no-fast-branches */
      0 | (1UL << 2), /* *bg/nR/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bge/%r0/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bge/%r0/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bge/%r0/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bge/%r0/n0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bge/%r0/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bge/%r1/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bge/%r1/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bge/%r1/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bge/%r1/n0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bge/%r1/nR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bge/%rR/%r0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bge/%rR/%r1/fR*-no-fast-branches */
      0 | (1UL << 2), /* *bge/%rR/%rR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bge/%rR/n0/fR*-no-fast-branches */
      0 | (1UL << 2), /* *bge/%rR/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bge/n0/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bge/n0/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bge/n0/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bge/n0/n0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bge/n0/nR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bge/nR/%r0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bge/nR/%r1/fR*-no-fast-branches */
      0 | (1UL << 2), /* *bge/nR/%rR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bge/nR/n0/fR*-no-fast-branches */
      0 | (1UL << 2), /* *bge/nR/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bger-stack/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bger-stack/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bger-stack/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bl/%r0/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bl/%r0/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bl/%r0/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bl/%r0/n0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bl/%r0/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bl/%r1/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bl/%r1/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bl/%r1/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bl/%r1/n0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bl/%r1/nR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bl/%rR/%r0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bl/%rR/%r1/fR*-no-fast-branches */
      0 | (1UL << 2), /* *bl/%rR/%rR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bl/%rR/n0/fR*-no-fast-branches */
      0 | (1UL << 2), /* *bl/%rR/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bl/n0/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bl/n0/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bl/n0/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bl/n0/n0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bl/n0/nR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bl/nR/%r0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bl/nR/%r1/fR*-no-fast-branches */
      0 | (1UL << 2), /* *bl/nR/%rR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bl/nR/n0/fR*-no-fast-branches */
      0 | (1UL << 2), /* *bl/nR/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *ble/%r0/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *ble/%r0/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *ble/%r0/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *ble/%r0/n0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *ble/%r0/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *ble/%r1/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *ble/%r1/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *ble/%r1/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *ble/%r1/n0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *ble/%r1/nR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *ble/%rR/%r0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *ble/%rR/%r1/fR*-no-fast-branches */
      0 | (1UL << 2), /* *ble/%rR/%rR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *ble/%rR/n0/fR*-no-fast-branches */
      0 | (1UL << 2), /* *ble/%rR/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *ble/n0/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *ble/n0/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *ble/n0/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *ble/n0/n0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *ble/n0/nR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *ble/nR/%r0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *ble/nR/%r1/fR*-no-fast-branches */
      0 | (1UL << 2), /* *ble/nR/%rR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *ble/nR/n0/fR*-no-fast-branches */
      0 | (1UL << 2), /* *ble/nR/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bne/%r0/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bne/%r0/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bne/%r0/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bne/%r0/n0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bne/%r0/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bne/%r1/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bne/%r1/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bne/%r1/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bne/%r1/n0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bne/%r1/nR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bne/%rR/%r0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bne/%rR/%r1/fR*-no-fast-branches */
      0 | (1UL << 2), /* *bne/%rR/%rR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bne/%rR/n0/fR*-no-fast-branches */
      0 | (1UL << 2), /* *bne/%rR/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bne/n0/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bne/n0/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bne/n0/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bne/n0/n0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bne/n0/nR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bne/nR/%r0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bne/nR/%r1/fR*-no-fast-branches */
      0 | (1UL << 2), /* *bne/nR/%rR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bne/nR/n0/fR*-no-fast-branches */
      0 | (1UL << 2), /* *bne/nR/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bneqi-stack/n-1/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bneqi-stack/n0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bneqi-stack/n1/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bneqi-stack/n2/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bneqi-stack/nR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bneqr-stack/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bneqr-stack/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *bneqr-stack/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *bt-stack/fR*-no-fast-branches */
      0 | (1UL << 0), /* *pushr-beqr-stack/%r0/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *pushr-beqr-stack/%r0/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *pushr-beqr-stack/%r0/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *pushr-beqr-stack/%r1/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *pushr-beqr-stack/%r1/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *pushr-beqr-stack/%r1/%rR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *pushr-beqr-stack/%rR/%r0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *pushr-beqr-stack/%rR/%r1/fR*-no-fast-branches */
      0 | (1UL << 2), /* *pushr-beqr-stack/%rR/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *pushr-bger-stack/%r0/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *pushr-bger-stack/%r0/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *pushr-bger-stack/%r0/%rR/fR*-no-fast-branches */
      0 | (1UL << 0), /* *pushr-bger-stack/%r1/%r0/fR*-no-fast-branches */
      0 | (1UL << 0), /* *pushr-bger-stack/%r1/%r1/fR*-no-fast-branches */
      0 | (1UL << 1), /* *pushr-bger-stack/%r1/%rR/fR*-no-fast-branches */
      0 | (1UL << 1), /* *pushr-bger-stack/%rR/%r0/fR*-no-fast-branches */
      0 | (1UL << 1), /* *pushr-bger-stack/%rR/%r1/fR*-no-fast-branches */
      0 | (1UL << 2) /* *pushr-bger-stack/%rR/%rR/fR*-no-fast-branches */
    };
#ifdef JITTER_HAVE_PATCH_IN
const unsigned long // FIXME: shall I use a shorter type when possible?
structuredvm_specialized_instruction_fast_label_bitmasks [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO]
  = {
      /* It's important that !BEGINBASICBLOCK has a zero here: it does not need residual patching. */
      0, /* !INVALID */
      0, /* !BEGINBASICBLOCK */
      0, /* !EXITVM */
      0, /* !DATALOCATIONS */
      0, /* !NOP */
      0, /* !UNREACHABLE0 */
      0, /* !UNREACHABLE1 */
      0, /* !UNREACHABLE2 */
      0 | (1UL << 0), /* b/fR */
      0 | (1UL << 0), /* be/%r0/%r0/fR */
      0 | (1UL << 0), /* be/%r0/%r1/fR */
      0 | (1UL << 1), /* be/%r0/%rR/fR */
      0 | (1UL << 0), /* be/%r0/n0/fR */
      0 | (1UL << 1), /* be/%r0/nR/fR */
      0 | (1UL << 0), /* be/%r1/%r0/fR */
      0 | (1UL << 0), /* be/%r1/%r1/fR */
      0 | (1UL << 1), /* be/%r1/%rR/fR */
      0 | (1UL << 0), /* be/%r1/n0/fR */
      0 | (1UL << 1), /* be/%r1/nR/fR */
      0 | (1UL << 1), /* be/%rR/%r0/fR */
      0 | (1UL << 1), /* be/%rR/%r1/fR */
      0 | (1UL << 2), /* be/%rR/%rR/fR */
      0 | (1UL << 1), /* be/%rR/n0/fR */
      0 | (1UL << 2), /* be/%rR/nR/fR */
      0 | (1UL << 0), /* be/n0/%r0/fR */
      0 | (1UL << 0), /* be/n0/%r1/fR */
      0 | (1UL << 1), /* be/n0/%rR/fR */
      0 | (1UL << 0), /* be/n0/n0/fR */
      0 | (1UL << 1), /* be/n0/nR/fR */
      0 | (1UL << 1), /* be/nR/%r0/fR */
      0 | (1UL << 1), /* be/nR/%r1/fR */
      0 | (1UL << 2), /* be/nR/%rR/fR */
      0 | (1UL << 1), /* be/nR/n0/fR */
      0 | (1UL << 2), /* be/nR/nR/fR */
      0 | (1UL << 0), /* beqi-stack/n-1/fR */
      0 | (1UL << 0), /* beqi-stack/n0/fR */
      0 | (1UL << 0), /* beqi-stack/n1/fR */
      0 | (1UL << 0), /* beqi-stack/n2/fR */
      0 | (1UL << 1), /* beqi-stack/nR/fR */
      0 | (1UL << 0), /* beqr-stack/%r0/fR */
      0 | (1UL << 0), /* beqr-stack/%r1/fR */
      0 | (1UL << 1), /* beqr-stack/%rR/fR */
      0 | (1UL << 0), /* bf-stack/fR */
      0 | (1UL << 0), /* bg/%r0/%r0/fR */
      0 | (1UL << 0), /* bg/%r0/%r1/fR */
      0 | (1UL << 1), /* bg/%r0/%rR/fR */
      0 | (1UL << 0), /* bg/%r0/n0/fR */
      0 | (1UL << 1), /* bg/%r0/nR/fR */
      0 | (1UL << 0), /* bg/%r1/%r0/fR */
      0 | (1UL << 0), /* bg/%r1/%r1/fR */
      0 | (1UL << 1), /* bg/%r1/%rR/fR */
      0 | (1UL << 0), /* bg/%r1/n0/fR */
      0 | (1UL << 1), /* bg/%r1/nR/fR */
      0 | (1UL << 1), /* bg/%rR/%r0/fR */
      0 | (1UL << 1), /* bg/%rR/%r1/fR */
      0 | (1UL << 2), /* bg/%rR/%rR/fR */
      0 | (1UL << 1), /* bg/%rR/n0/fR */
      0 | (1UL << 2), /* bg/%rR/nR/fR */
      0 | (1UL << 0), /* bg/n0/%r0/fR */
      0 | (1UL << 0), /* bg/n0/%r1/fR */
      0 | (1UL << 1), /* bg/n0/%rR/fR */
      0 | (1UL << 0), /* bg/n0/n0/fR */
      0 | (1UL << 1), /* bg/n0/nR/fR */
      0 | (1UL << 1), /* bg/nR/%r0/fR */
      0 | (1UL << 1), /* bg/nR/%r1/fR */
      0 | (1UL << 2), /* bg/nR/%rR/fR */
      0 | (1UL << 1), /* bg/nR/n0/fR */
      0 | (1UL << 2), /* bg/nR/nR/fR */
      0 | (1UL << 0), /* bge/%r0/%r0/fR */
      0 | (1UL << 0), /* bge/%r0/%r1/fR */
      0 | (1UL << 1), /* bge/%r0/%rR/fR */
      0 | (1UL << 0), /* bge/%r0/n0/fR */
      0 | (1UL << 1), /* bge/%r0/nR/fR */
      0 | (1UL << 0), /* bge/%r1/%r0/fR */
      0 | (1UL << 0), /* bge/%r1/%r1/fR */
      0 | (1UL << 1), /* bge/%r1/%rR/fR */
      0 | (1UL << 0), /* bge/%r1/n0/fR */
      0 | (1UL << 1), /* bge/%r1/nR/fR */
      0 | (1UL << 1), /* bge/%rR/%r0/fR */
      0 | (1UL << 1), /* bge/%rR/%r1/fR */
      0 | (1UL << 2), /* bge/%rR/%rR/fR */
      0 | (1UL << 1), /* bge/%rR/n0/fR */
      0 | (1UL << 2), /* bge/%rR/nR/fR */
      0 | (1UL << 0), /* bge/n0/%r0/fR */
      0 | (1UL << 0), /* bge/n0/%r1/fR */
      0 | (1UL << 1), /* bge/n0/%rR/fR */
      0 | (1UL << 0), /* bge/n0/n0/fR */
      0 | (1UL << 1), /* bge/n0/nR/fR */
      0 | (1UL << 1), /* bge/nR/%r0/fR */
      0 | (1UL << 1), /* bge/nR/%r1/fR */
      0 | (1UL << 2), /* bge/nR/%rR/fR */
      0 | (1UL << 1), /* bge/nR/n0/fR */
      0 | (1UL << 2), /* bge/nR/nR/fR */
      0 | (1UL << 0), /* bger-stack/%r0/fR */
      0 | (1UL << 0), /* bger-stack/%r1/fR */
      0 | (1UL << 1), /* bger-stack/%rR/fR */
      0 | (1UL << 0), /* bl/%r0/%r0/fR */
      0 | (1UL << 0), /* bl/%r0/%r1/fR */
      0 | (1UL << 1), /* bl/%r0/%rR/fR */
      0 | (1UL << 0), /* bl/%r0/n0/fR */
      0 | (1UL << 1), /* bl/%r0/nR/fR */
      0 | (1UL << 0), /* bl/%r1/%r0/fR */
      0 | (1UL << 0), /* bl/%r1/%r1/fR */
      0 | (1UL << 1), /* bl/%r1/%rR/fR */
      0 | (1UL << 0), /* bl/%r1/n0/fR */
      0 | (1UL << 1), /* bl/%r1/nR/fR */
      0 | (1UL << 1), /* bl/%rR/%r0/fR */
      0 | (1UL << 1), /* bl/%rR/%r1/fR */
      0 | (1UL << 2), /* bl/%rR/%rR/fR */
      0 | (1UL << 1), /* bl/%rR/n0/fR */
      0 | (1UL << 2), /* bl/%rR/nR/fR */
      0 | (1UL << 0), /* bl/n0/%r0/fR */
      0 | (1UL << 0), /* bl/n0/%r1/fR */
      0 | (1UL << 1), /* bl/n0/%rR/fR */
      0 | (1UL << 0), /* bl/n0/n0/fR */
      0 | (1UL << 1), /* bl/n0/nR/fR */
      0 | (1UL << 1), /* bl/nR/%r0/fR */
      0 | (1UL << 1), /* bl/nR/%r1/fR */
      0 | (1UL << 2), /* bl/nR/%rR/fR */
      0 | (1UL << 1), /* bl/nR/n0/fR */
      0 | (1UL << 2), /* bl/nR/nR/fR */
      0 | (1UL << 0), /* ble/%r0/%r0/fR */
      0 | (1UL << 0), /* ble/%r0/%r1/fR */
      0 | (1UL << 1), /* ble/%r0/%rR/fR */
      0 | (1UL << 0), /* ble/%r0/n0/fR */
      0 | (1UL << 1), /* ble/%r0/nR/fR */
      0 | (1UL << 0), /* ble/%r1/%r0/fR */
      0 | (1UL << 0), /* ble/%r1/%r1/fR */
      0 | (1UL << 1), /* ble/%r1/%rR/fR */
      0 | (1UL << 0), /* ble/%r1/n0/fR */
      0 | (1UL << 1), /* ble/%r1/nR/fR */
      0 | (1UL << 1), /* ble/%rR/%r0/fR */
      0 | (1UL << 1), /* ble/%rR/%r1/fR */
      0 | (1UL << 2), /* ble/%rR/%rR/fR */
      0 | (1UL << 1), /* ble/%rR/n0/fR */
      0 | (1UL << 2), /* ble/%rR/nR/fR */
      0 | (1UL << 0), /* ble/n0/%r0/fR */
      0 | (1UL << 0), /* ble/n0/%r1/fR */
      0 | (1UL << 1), /* ble/n0/%rR/fR */
      0 | (1UL << 0), /* ble/n0/n0/fR */
      0 | (1UL << 1), /* ble/n0/nR/fR */
      0 | (1UL << 1), /* ble/nR/%r0/fR */
      0 | (1UL << 1), /* ble/nR/%r1/fR */
      0 | (1UL << 2), /* ble/nR/%rR/fR */
      0 | (1UL << 1), /* ble/nR/n0/fR */
      0 | (1UL << 2), /* ble/nR/nR/fR */
      0 | (1UL << 0), /* bne/%r0/%r0/fR */
      0 | (1UL << 0), /* bne/%r0/%r1/fR */
      0 | (1UL << 1), /* bne/%r0/%rR/fR */
      0 | (1UL << 0), /* bne/%r0/n0/fR */
      0 | (1UL << 1), /* bne/%r0/nR/fR */
      0 | (1UL << 0), /* bne/%r1/%r0/fR */
      0 | (1UL << 0), /* bne/%r1/%r1/fR */
      0 | (1UL << 1), /* bne/%r1/%rR/fR */
      0 | (1UL << 0), /* bne/%r1/n0/fR */
      0 | (1UL << 1), /* bne/%r1/nR/fR */
      0 | (1UL << 1), /* bne/%rR/%r0/fR */
      0 | (1UL << 1), /* bne/%rR/%r1/fR */
      0 | (1UL << 2), /* bne/%rR/%rR/fR */
      0 | (1UL << 1), /* bne/%rR/n0/fR */
      0 | (1UL << 2), /* bne/%rR/nR/fR */
      0 | (1UL << 0), /* bne/n0/%r0/fR */
      0 | (1UL << 0), /* bne/n0/%r1/fR */
      0 | (1UL << 1), /* bne/n0/%rR/fR */
      0 | (1UL << 0), /* bne/n0/n0/fR */
      0 | (1UL << 1), /* bne/n0/nR/fR */
      0 | (1UL << 1), /* bne/nR/%r0/fR */
      0 | (1UL << 1), /* bne/nR/%r1/fR */
      0 | (1UL << 2), /* bne/nR/%rR/fR */
      0 | (1UL << 1), /* bne/nR/n0/fR */
      0 | (1UL << 2), /* bne/nR/nR/fR */
      0 | (1UL << 0), /* bneqi-stack/n-1/fR */
      0 | (1UL << 0), /* bneqi-stack/n0/fR */
      0 | (1UL << 0), /* bneqi-stack/n1/fR */
      0 | (1UL << 0), /* bneqi-stack/n2/fR */
      0 | (1UL << 1), /* bneqi-stack/nR/fR */
      0 | (1UL << 0), /* bneqr-stack/%r0/fR */
      0 | (1UL << 0), /* bneqr-stack/%r1/fR */
      0 | (1UL << 1), /* bneqr-stack/%rR/fR */
      0 | (1UL << 0), /* bt-stack/fR */
      0, /* copy-to-r-stack/%r0 */
      0, /* copy-to-r-stack/%r1 */
      0, /* copy-to-r-stack/%rR */
      0, /* different-stack */
      0, /* differenti-stack/n0 */
      0, /* differenti-stack/n1 */
      0, /* differenti-stack/n2 */
      0, /* differenti-stack/nR */
      0, /* divided/%r0/%r0/%r0 */
      0, /* divided/%r0/%r0/%r1 */
      0, /* divided/%r0/%r0/%rR */
      0, /* divided/%r0/%r1/%r0 */
      0, /* divided/%r0/%r1/%r1 */
      0, /* divided/%r0/%r1/%rR */
      0, /* divided/%r0/%rR/%r0 */
      0, /* divided/%r0/%rR/%r1 */
      0, /* divided/%r0/%rR/%rR */
      0, /* divided/%r0/n2/%r0 */
      0, /* divided/%r0/n2/%r1 */
      0, /* divided/%r0/n2/%rR */
      0, /* divided/%r0/nR/%r0 */
      0, /* divided/%r0/nR/%r1 */
      0, /* divided/%r0/nR/%rR */
      0, /* divided/%r1/%r0/%r0 */
      0, /* divided/%r1/%r0/%r1 */
      0, /* divided/%r1/%r0/%rR */
      0, /* divided/%r1/%r1/%r0 */
      0, /* divided/%r1/%r1/%r1 */
      0, /* divided/%r1/%r1/%rR */
      0, /* divided/%r1/%rR/%r0 */
      0, /* divided/%r1/%rR/%r1 */
      0, /* divided/%r1/%rR/%rR */
      0, /* divided/%r1/n2/%r0 */
      0, /* divided/%r1/n2/%r1 */
      0, /* divided/%r1/n2/%rR */
      0, /* divided/%r1/nR/%r0 */
      0, /* divided/%r1/nR/%r1 */
      0, /* divided/%r1/nR/%rR */
      0, /* divided/%rR/%r0/%r0 */
      0, /* divided/%rR/%r0/%r1 */
      0, /* divided/%rR/%r0/%rR */
      0, /* divided/%rR/%r1/%r0 */
      0, /* divided/%rR/%r1/%r1 */
      0, /* divided/%rR/%r1/%rR */
      0, /* divided/%rR/%rR/%r0 */
      0, /* divided/%rR/%rR/%r1 */
      0, /* divided/%rR/%rR/%rR */
      0, /* divided/%rR/n2/%r0 */
      0, /* divided/%rR/n2/%r1 */
      0, /* divided/%rR/n2/%rR */
      0, /* divided/%rR/nR/%r0 */
      0, /* divided/%rR/nR/%r1 */
      0, /* divided/%rR/nR/%rR */
      0, /* divided/nR/%r0/%r0 */
      0, /* divided/nR/%r0/%r1 */
      0, /* divided/nR/%r0/%rR */
      0, /* divided/nR/%r1/%r0 */
      0, /* divided/nR/%r1/%r1 */
      0, /* divided/nR/%r1/%rR */
      0, /* divided/nR/%rR/%r0 */
      0, /* divided/nR/%rR/%r1 */
      0, /* divided/nR/%rR/%rR */
      0, /* divided/nR/n2/%r0 */
      0, /* divided/nR/n2/%r1 */
      0, /* divided/nR/n2/%rR */
      0, /* divided/nR/nR/%r0 */
      0, /* divided/nR/nR/%r1 */
      0, /* divided/nR/nR/%rR */
      0, /* divided-stack */
      0, /* drop-stack */
      0, /* dup-stack */
      0, /* equal-stack */
      0, /* equali-stack/n0 */
      0, /* equali-stack/n1 */
      0, /* equali-stack/n2 */
      0, /* equali-stack/nR */
      0, /* exitvm */
      0, /* greater-stack */
      0, /* greaterorequal-stack */
      0, /* input/%r0/retR */
      0, /* input/%r1/retR */
      0, /* input/%rR/retR */
      0, /* input-stack/retR */
      0, /* isnonzero-stack */
      0, /* less-stack */
      0, /* lessorequal-stack */
      0, /* logicaland-stack */
      0, /* logicalnot-stack */
      0, /* logicalor-stack */
      0, /* minus/%r0/%r0/%r0 */
      0, /* minus/%r0/%r0/%r1 */
      0, /* minus/%r0/%r0/%rR */
      0, /* minus/%r0/%r1/%r0 */
      0, /* minus/%r0/%r1/%r1 */
      0, /* minus/%r0/%r1/%rR */
      0, /* minus/%r0/%rR/%r0 */
      0, /* minus/%r0/%rR/%r1 */
      0, /* minus/%r0/%rR/%rR */
      0, /* minus/%r0/n1/%r0 */
      0, /* minus/%r0/n1/%r1 */
      0, /* minus/%r0/n1/%rR */
      0, /* minus/%r0/n2/%r0 */
      0, /* minus/%r0/n2/%r1 */
      0, /* minus/%r0/n2/%rR */
      0, /* minus/%r0/nR/%r0 */
      0, /* minus/%r0/nR/%r1 */
      0, /* minus/%r0/nR/%rR */
      0, /* minus/%r1/%r0/%r0 */
      0, /* minus/%r1/%r0/%r1 */
      0, /* minus/%r1/%r0/%rR */
      0, /* minus/%r1/%r1/%r0 */
      0, /* minus/%r1/%r1/%r1 */
      0, /* minus/%r1/%r1/%rR */
      0, /* minus/%r1/%rR/%r0 */
      0, /* minus/%r1/%rR/%r1 */
      0, /* minus/%r1/%rR/%rR */
      0, /* minus/%r1/n1/%r0 */
      0, /* minus/%r1/n1/%r1 */
      0, /* minus/%r1/n1/%rR */
      0, /* minus/%r1/n2/%r0 */
      0, /* minus/%r1/n2/%r1 */
      0, /* minus/%r1/n2/%rR */
      0, /* minus/%r1/nR/%r0 */
      0, /* minus/%r1/nR/%r1 */
      0, /* minus/%r1/nR/%rR */
      0, /* minus/%rR/%r0/%r0 */
      0, /* minus/%rR/%r0/%r1 */
      0, /* minus/%rR/%r0/%rR */
      0, /* minus/%rR/%r1/%r0 */
      0, /* minus/%rR/%r1/%r1 */
      0, /* minus/%rR/%r1/%rR */
      0, /* minus/%rR/%rR/%r0 */
      0, /* minus/%rR/%rR/%r1 */
      0, /* minus/%rR/%rR/%rR */
      0, /* minus/%rR/n1/%r0 */
      0, /* minus/%rR/n1/%r1 */
      0, /* minus/%rR/n1/%rR */
      0, /* minus/%rR/n2/%r0 */
      0, /* minus/%rR/n2/%r1 */
      0, /* minus/%rR/n2/%rR */
      0, /* minus/%rR/nR/%r0 */
      0, /* minus/%rR/nR/%r1 */
      0, /* minus/%rR/nR/%rR */
      0, /* minus/nR/%r0/%r0 */
      0, /* minus/nR/%r0/%r1 */
      0, /* minus/nR/%r0/%rR */
      0, /* minus/nR/%r1/%r0 */
      0, /* minus/nR/%r1/%r1 */
      0, /* minus/nR/%r1/%rR */
      0, /* minus/nR/%rR/%r0 */
      0, /* minus/nR/%rR/%r1 */
      0, /* minus/nR/%rR/%rR */
      0, /* minus/nR/n1/%r0 */
      0, /* minus/nR/n1/%r1 */
      0, /* minus/nR/n1/%rR */
      0, /* minus/nR/n2/%r0 */
      0, /* minus/nR/n2/%r1 */
      0, /* minus/nR/n2/%rR */
      0, /* minus/nR/nR/%r0 */
      0, /* minus/nR/nR/%r1 */
      0, /* minus/nR/nR/%rR */
      0, /* minus-stack */
      0, /* minusi-stack/n1 */
      0, /* minusi-stack/n2 */
      0, /* minusi-stack/nR */
      0, /* minusr-stack/%r0 */
      0, /* minusr-stack/%r1 */
      0, /* minusr-stack/%rR */
      0, /* mov/%r0/%r0 */
      0, /* mov/%r0/%r1 */
      0, /* mov/%r0/%rR */
      0, /* mov/%r1/%r0 */
      0, /* mov/%r1/%r1 */
      0, /* mov/%r1/%rR */
      0, /* mov/%rR/%r0 */
      0, /* mov/%rR/%r1 */
      0, /* mov/%rR/%rR */
      0, /* mov/n0/%r0 */
      0, /* mov/n0/%r1 */
      0, /* mov/n0/%rR */
      0, /* mov/n1/%r0 */
      0, /* mov/n1/%r1 */
      0, /* mov/n1/%rR */
      0, /* mov/n-1/%r0 */
      0, /* mov/n-1/%r1 */
      0, /* mov/n-1/%rR */
      0, /* mov/n2/%r0 */
      0, /* mov/n2/%r1 */
      0, /* mov/n2/%rR */
      0, /* mov/nR/%r0 */
      0, /* mov/nR/%r1 */
      0, /* mov/nR/%rR */
      0, /* plus/%r0/%r0/%r0 */
      0, /* plus/%r0/%r0/%r1 */
      0, /* plus/%r0/%r0/%rR */
      0, /* plus/%r0/%r1/%r0 */
      0, /* plus/%r0/%r1/%r1 */
      0, /* plus/%r0/%r1/%rR */
      0, /* plus/%r0/%rR/%r0 */
      0, /* plus/%r0/%rR/%r1 */
      0, /* plus/%r0/%rR/%rR */
      0, /* plus/%r0/n1/%r0 */
      0, /* plus/%r0/n1/%r1 */
      0, /* plus/%r0/n1/%rR */
      0, /* plus/%r0/n2/%r0 */
      0, /* plus/%r0/n2/%r1 */
      0, /* plus/%r0/n2/%rR */
      0, /* plus/%r0/nR/%r0 */
      0, /* plus/%r0/nR/%r1 */
      0, /* plus/%r0/nR/%rR */
      0, /* plus/%r1/%r0/%r0 */
      0, /* plus/%r1/%r0/%r1 */
      0, /* plus/%r1/%r0/%rR */
      0, /* plus/%r1/%r1/%r0 */
      0, /* plus/%r1/%r1/%r1 */
      0, /* plus/%r1/%r1/%rR */
      0, /* plus/%r1/%rR/%r0 */
      0, /* plus/%r1/%rR/%r1 */
      0, /* plus/%r1/%rR/%rR */
      0, /* plus/%r1/n1/%r0 */
      0, /* plus/%r1/n1/%r1 */
      0, /* plus/%r1/n1/%rR */
      0, /* plus/%r1/n2/%r0 */
      0, /* plus/%r1/n2/%r1 */
      0, /* plus/%r1/n2/%rR */
      0, /* plus/%r1/nR/%r0 */
      0, /* plus/%r1/nR/%r1 */
      0, /* plus/%r1/nR/%rR */
      0, /* plus/%rR/%r0/%r0 */
      0, /* plus/%rR/%r0/%r1 */
      0, /* plus/%rR/%r0/%rR */
      0, /* plus/%rR/%r1/%r0 */
      0, /* plus/%rR/%r1/%r1 */
      0, /* plus/%rR/%r1/%rR */
      0, /* plus/%rR/%rR/%r0 */
      0, /* plus/%rR/%rR/%r1 */
      0, /* plus/%rR/%rR/%rR */
      0, /* plus/%rR/n1/%r0 */
      0, /* plus/%rR/n1/%r1 */
      0, /* plus/%rR/n1/%rR */
      0, /* plus/%rR/n2/%r0 */
      0, /* plus/%rR/n2/%r1 */
      0, /* plus/%rR/n2/%rR */
      0, /* plus/%rR/nR/%r0 */
      0, /* plus/%rR/nR/%r1 */
      0, /* plus/%rR/nR/%rR */
      0, /* plus/nR/%r0/%r0 */
      0, /* plus/nR/%r0/%r1 */
      0, /* plus/nR/%r0/%rR */
      0, /* plus/nR/%r1/%r0 */
      0, /* plus/nR/%r1/%r1 */
      0, /* plus/nR/%r1/%rR */
      0, /* plus/nR/%rR/%r0 */
      0, /* plus/nR/%rR/%r1 */
      0, /* plus/nR/%rR/%rR */
      0, /* plus/nR/n1/%r0 */
      0, /* plus/nR/n1/%r1 */
      0, /* plus/nR/n1/%rR */
      0, /* plus/nR/n2/%r0 */
      0, /* plus/nR/n2/%r1 */
      0, /* plus/nR/n2/%rR */
      0, /* plus/nR/nR/%r0 */
      0, /* plus/nR/nR/%r1 */
      0, /* plus/nR/nR/%rR */
      0, /* plus-stack */
      0, /* plusi-stack/n-1 */
      0, /* plusi-stack/n1 */
      0, /* plusi-stack/n2 */
      0, /* plusi-stack/nR */
      0, /* pop-stack/%r0 */
      0, /* pop-stack/%r1 */
      0, /* pop-stack/%rR */
      0, /* print/%r0/retR */
      0, /* print/%r1/retR */
      0, /* print/%rR/retR */
      0, /* print/nR/retR */
      0, /* print-stack/retR */
      0, /* push-stack/%r0 */
      0, /* push-stack/%r1 */
      0, /* push-stack/%rR */
      0, /* push-stack/n0 */
      0, /* push-stack/n1 */
      0, /* push-stack/n-1 */
      0, /* push-stack/n2 */
      0, /* push-stack/nR */
      0, /* push-stack/lR */
      0 | (1UL << 0), /* pushr-beqr-stack/%r0/%r0/fR */
      0 | (1UL << 0), /* pushr-beqr-stack/%r0/%r1/fR */
      0 | (1UL << 1), /* pushr-beqr-stack/%r0/%rR/fR */
      0 | (1UL << 0), /* pushr-beqr-stack/%r1/%r0/fR */
      0 | (1UL << 0), /* pushr-beqr-stack/%r1/%r1/fR */
      0 | (1UL << 1), /* pushr-beqr-stack/%r1/%rR/fR */
      0 | (1UL << 1), /* pushr-beqr-stack/%rR/%r0/fR */
      0 | (1UL << 1), /* pushr-beqr-stack/%rR/%r1/fR */
      0 | (1UL << 2), /* pushr-beqr-stack/%rR/%rR/fR */
      0 | (1UL << 0), /* pushr-bger-stack/%r0/%r0/fR */
      0 | (1UL << 0), /* pushr-bger-stack/%r0/%r1/fR */
      0 | (1UL << 1), /* pushr-bger-stack/%r0/%rR/fR */
      0 | (1UL << 0), /* pushr-bger-stack/%r1/%r0/fR */
      0 | (1UL << 0), /* pushr-bger-stack/%r1/%r1/fR */
      0 | (1UL << 1), /* pushr-bger-stack/%r1/%rR/fR */
      0 | (1UL << 1), /* pushr-bger-stack/%rR/%r0/fR */
      0 | (1UL << 1), /* pushr-bger-stack/%rR/%r1/fR */
      0 | (1UL << 2), /* pushr-bger-stack/%rR/%rR/fR */
      0, /* pushr-minusr-pop-stack/%r0/%r0/%r0 */
      0, /* pushr-minusr-pop-stack/%r0/%r0/%r1 */
      0, /* pushr-minusr-pop-stack/%r0/%r0/%rR */
      0, /* pushr-minusr-pop-stack/%r0/%r1/%r0 */
      0, /* pushr-minusr-pop-stack/%r0/%r1/%r1 */
      0, /* pushr-minusr-pop-stack/%r0/%r1/%rR */
      0, /* pushr-minusr-pop-stack/%r0/%rR/%r0 */
      0, /* pushr-minusr-pop-stack/%r0/%rR/%r1 */
      0, /* pushr-minusr-pop-stack/%r0/%rR/%rR */
      0, /* pushr-minusr-pop-stack/%r1/%r0/%r0 */
      0, /* pushr-minusr-pop-stack/%r1/%r0/%r1 */
      0, /* pushr-minusr-pop-stack/%r1/%r0/%rR */
      0, /* pushr-minusr-pop-stack/%r1/%r1/%r0 */
      0, /* pushr-minusr-pop-stack/%r1/%r1/%r1 */
      0, /* pushr-minusr-pop-stack/%r1/%r1/%rR */
      0, /* pushr-minusr-pop-stack/%r1/%rR/%r0 */
      0, /* pushr-minusr-pop-stack/%r1/%rR/%r1 */
      0, /* pushr-minusr-pop-stack/%r1/%rR/%rR */
      0, /* pushr-minusr-pop-stack/%rR/%r0/%r0 */
      0, /* pushr-minusr-pop-stack/%rR/%r0/%r1 */
      0, /* pushr-minusr-pop-stack/%rR/%r0/%rR */
      0, /* pushr-minusr-pop-stack/%rR/%r1/%r0 */
      0, /* pushr-minusr-pop-stack/%rR/%r1/%r1 */
      0, /* pushr-minusr-pop-stack/%rR/%r1/%rR */
      0, /* pushr-minusr-pop-stack/%rR/%rR/%r0 */
      0, /* pushr-minusr-pop-stack/%rR/%rR/%r1 */
      0, /* pushr-minusr-pop-stack/%rR/%rR/%rR */
      0, /* remainder/%r0/%r0/%r0 */
      0, /* remainder/%r0/%r0/%r1 */
      0, /* remainder/%r0/%r0/%rR */
      0, /* remainder/%r0/%r1/%r0 */
      0, /* remainder/%r0/%r1/%r1 */
      0, /* remainder/%r0/%r1/%rR */
      0, /* remainder/%r0/%rR/%r0 */
      0, /* remainder/%r0/%rR/%r1 */
      0, /* remainder/%r0/%rR/%rR */
      0, /* remainder/%r0/n2/%r0 */
      0, /* remainder/%r0/n2/%r1 */
      0, /* remainder/%r0/n2/%rR */
      0, /* remainder/%r0/nR/%r0 */
      0, /* remainder/%r0/nR/%r1 */
      0, /* remainder/%r0/nR/%rR */
      0, /* remainder/%r1/%r0/%r0 */
      0, /* remainder/%r1/%r0/%r1 */
      0, /* remainder/%r1/%r0/%rR */
      0, /* remainder/%r1/%r1/%r0 */
      0, /* remainder/%r1/%r1/%r1 */
      0, /* remainder/%r1/%r1/%rR */
      0, /* remainder/%r1/%rR/%r0 */
      0, /* remainder/%r1/%rR/%r1 */
      0, /* remainder/%r1/%rR/%rR */
      0, /* remainder/%r1/n2/%r0 */
      0, /* remainder/%r1/n2/%r1 */
      0, /* remainder/%r1/n2/%rR */
      0, /* remainder/%r1/nR/%r0 */
      0, /* remainder/%r1/nR/%r1 */
      0, /* remainder/%r1/nR/%rR */
      0, /* remainder/%rR/%r0/%r0 */
      0, /* remainder/%rR/%r0/%r1 */
      0, /* remainder/%rR/%r0/%rR */
      0, /* remainder/%rR/%r1/%r0 */
      0, /* remainder/%rR/%r1/%r1 */
      0, /* remainder/%rR/%r1/%rR */
      0, /* remainder/%rR/%rR/%r0 */
      0, /* remainder/%rR/%rR/%r1 */
      0, /* remainder/%rR/%rR/%rR */
      0, /* remainder/%rR/n2/%r0 */
      0, /* remainder/%rR/n2/%r1 */
      0, /* remainder/%rR/n2/%rR */
      0, /* remainder/%rR/nR/%r0 */
      0, /* remainder/%rR/nR/%r1 */
      0, /* remainder/%rR/nR/%rR */
      0, /* remainder/nR/%r0/%r0 */
      0, /* remainder/nR/%r0/%r1 */
      0, /* remainder/nR/%r0/%rR */
      0, /* remainder/nR/%r1/%r0 */
      0, /* remainder/nR/%r1/%r1 */
      0, /* remainder/nR/%r1/%rR */
      0, /* remainder/nR/%rR/%r0 */
      0, /* remainder/nR/%rR/%r1 */
      0, /* remainder/nR/%rR/%rR */
      0, /* remainder/nR/n2/%r0 */
      0, /* remainder/nR/n2/%r1 */
      0, /* remainder/nR/n2/%rR */
      0, /* remainder/nR/nR/%r0 */
      0, /* remainder/nR/nR/%r1 */
      0, /* remainder/nR/nR/%rR */
      0, /* remainder-stack */
      0, /* times/%r0/%r0/%r0 */
      0, /* times/%r0/%r0/%r1 */
      0, /* times/%r0/%r0/%rR */
      0, /* times/%r0/%r1/%r0 */
      0, /* times/%r0/%r1/%r1 */
      0, /* times/%r0/%r1/%rR */
      0, /* times/%r0/%rR/%r0 */
      0, /* times/%r0/%rR/%r1 */
      0, /* times/%r0/%rR/%rR */
      0, /* times/%r0/n2/%r0 */
      0, /* times/%r0/n2/%r1 */
      0, /* times/%r0/n2/%rR */
      0, /* times/%r0/nR/%r0 */
      0, /* times/%r0/nR/%r1 */
      0, /* times/%r0/nR/%rR */
      0, /* times/%r1/%r0/%r0 */
      0, /* times/%r1/%r0/%r1 */
      0, /* times/%r1/%r0/%rR */
      0, /* times/%r1/%r1/%r0 */
      0, /* times/%r1/%r1/%r1 */
      0, /* times/%r1/%r1/%rR */
      0, /* times/%r1/%rR/%r0 */
      0, /* times/%r1/%rR/%r1 */
      0, /* times/%r1/%rR/%rR */
      0, /* times/%r1/n2/%r0 */
      0, /* times/%r1/n2/%r1 */
      0, /* times/%r1/n2/%rR */
      0, /* times/%r1/nR/%r0 */
      0, /* times/%r1/nR/%r1 */
      0, /* times/%r1/nR/%rR */
      0, /* times/%rR/%r0/%r0 */
      0, /* times/%rR/%r0/%r1 */
      0, /* times/%rR/%r0/%rR */
      0, /* times/%rR/%r1/%r0 */
      0, /* times/%rR/%r1/%r1 */
      0, /* times/%rR/%r1/%rR */
      0, /* times/%rR/%rR/%r0 */
      0, /* times/%rR/%rR/%r1 */
      0, /* times/%rR/%rR/%rR */
      0, /* times/%rR/n2/%r0 */
      0, /* times/%rR/n2/%r1 */
      0, /* times/%rR/n2/%rR */
      0, /* times/%rR/nR/%r0 */
      0, /* times/%rR/nR/%r1 */
      0, /* times/%rR/nR/%rR */
      0, /* times/nR/%r0/%r0 */
      0, /* times/nR/%r0/%r1 */
      0, /* times/nR/%r0/%rR */
      0, /* times/nR/%r1/%r0 */
      0, /* times/nR/%r1/%r1 */
      0, /* times/nR/%r1/%rR */
      0, /* times/nR/%rR/%r0 */
      0, /* times/nR/%rR/%r1 */
      0, /* times/nR/%rR/%rR */
      0, /* times/nR/n2/%r0 */
      0, /* times/nR/n2/%r1 */
      0, /* times/nR/n2/%rR */
      0, /* times/nR/nR/%r0 */
      0, /* times/nR/nR/%r1 */
      0, /* times/nR/nR/%rR */
      0, /* times-stack */
      0, /* uminus/%r0/%r0 */
      0, /* uminus/%r0/%r1 */
      0, /* uminus/%r0/%rR */
      0, /* uminus/%r1/%r0 */
      0, /* uminus/%r1/%r1 */
      0, /* uminus/%r1/%rR */
      0, /* uminus/%rR/%r0 */
      0, /* uminus/%rR/%r1 */
      0, /* uminus/%rR/%rR */
      0, /* uminus/nR/%r0 */
      0, /* uminus/nR/%r1 */
      0, /* uminus/nR/%rR */
      0, /* uminus-stack */
      0, /* unreachable */
      0, /* *b/fR*-no-fast-branches */
      0, /* *be/%r0/%r0/fR*-no-fast-branches */
      0, /* *be/%r0/%r1/fR*-no-fast-branches */
      0, /* *be/%r0/%rR/fR*-no-fast-branches */
      0, /* *be/%r0/n0/fR*-no-fast-branches */
      0, /* *be/%r0/nR/fR*-no-fast-branches */
      0, /* *be/%r1/%r0/fR*-no-fast-branches */
      0, /* *be/%r1/%r1/fR*-no-fast-branches */
      0, /* *be/%r1/%rR/fR*-no-fast-branches */
      0, /* *be/%r1/n0/fR*-no-fast-branches */
      0, /* *be/%r1/nR/fR*-no-fast-branches */
      0, /* *be/%rR/%r0/fR*-no-fast-branches */
      0, /* *be/%rR/%r1/fR*-no-fast-branches */
      0, /* *be/%rR/%rR/fR*-no-fast-branches */
      0, /* *be/%rR/n0/fR*-no-fast-branches */
      0, /* *be/%rR/nR/fR*-no-fast-branches */
      0, /* *be/n0/%r0/fR*-no-fast-branches */
      0, /* *be/n0/%r1/fR*-no-fast-branches */
      0, /* *be/n0/%rR/fR*-no-fast-branches */
      0, /* *be/n0/n0/fR*-no-fast-branches */
      0, /* *be/n0/nR/fR*-no-fast-branches */
      0, /* *be/nR/%r0/fR*-no-fast-branches */
      0, /* *be/nR/%r1/fR*-no-fast-branches */
      0, /* *be/nR/%rR/fR*-no-fast-branches */
      0, /* *be/nR/n0/fR*-no-fast-branches */
      0, /* *be/nR/nR/fR*-no-fast-branches */
      0, /* *beqi-stack/n-1/fR*-no-fast-branches */
      0, /* *beqi-stack/n0/fR*-no-fast-branches */
      0, /* *beqi-stack/n1/fR*-no-fast-branches */
      0, /* *beqi-stack/n2/fR*-no-fast-branches */
      0, /* *beqi-stack/nR/fR*-no-fast-branches */
      0, /* *beqr-stack/%r0/fR*-no-fast-branches */
      0, /* *beqr-stack/%r1/fR*-no-fast-branches */
      0, /* *beqr-stack/%rR/fR*-no-fast-branches */
      0, /* *bf-stack/fR*-no-fast-branches */
      0, /* *bg/%r0/%r0/fR*-no-fast-branches */
      0, /* *bg/%r0/%r1/fR*-no-fast-branches */
      0, /* *bg/%r0/%rR/fR*-no-fast-branches */
      0, /* *bg/%r0/n0/fR*-no-fast-branches */
      0, /* *bg/%r0/nR/fR*-no-fast-branches */
      0, /* *bg/%r1/%r0/fR*-no-fast-branches */
      0, /* *bg/%r1/%r1/fR*-no-fast-branches */
      0, /* *bg/%r1/%rR/fR*-no-fast-branches */
      0, /* *bg/%r1/n0/fR*-no-fast-branches */
      0, /* *bg/%r1/nR/fR*-no-fast-branches */
      0, /* *bg/%rR/%r0/fR*-no-fast-branches */
      0, /* *bg/%rR/%r1/fR*-no-fast-branches */
      0, /* *bg/%rR/%rR/fR*-no-fast-branches */
      0, /* *bg/%rR/n0/fR*-no-fast-branches */
      0, /* *bg/%rR/nR/fR*-no-fast-branches */
      0, /* *bg/n0/%r0/fR*-no-fast-branches */
      0, /* *bg/n0/%r1/fR*-no-fast-branches */
      0, /* *bg/n0/%rR/fR*-no-fast-branches */
      0, /* *bg/n0/n0/fR*-no-fast-branches */
      0, /* *bg/n0/nR/fR*-no-fast-branches */
      0, /* *bg/nR/%r0/fR*-no-fast-branches */
      0, /* *bg/nR/%r1/fR*-no-fast-branches */
      0, /* *bg/nR/%rR/fR*-no-fast-branches */
      0, /* *bg/nR/n0/fR*-no-fast-branches */
      0, /* *bg/nR/nR/fR*-no-fast-branches */
      0, /* *bge/%r0/%r0/fR*-no-fast-branches */
      0, /* *bge/%r0/%r1/fR*-no-fast-branches */
      0, /* *bge/%r0/%rR/fR*-no-fast-branches */
      0, /* *bge/%r0/n0/fR*-no-fast-branches */
      0, /* *bge/%r0/nR/fR*-no-fast-branches */
      0, /* *bge/%r1/%r0/fR*-no-fast-branches */
      0, /* *bge/%r1/%r1/fR*-no-fast-branches */
      0, /* *bge/%r1/%rR/fR*-no-fast-branches */
      0, /* *bge/%r1/n0/fR*-no-fast-branches */
      0, /* *bge/%r1/nR/fR*-no-fast-branches */
      0, /* *bge/%rR/%r0/fR*-no-fast-branches */
      0, /* *bge/%rR/%r1/fR*-no-fast-branches */
      0, /* *bge/%rR/%rR/fR*-no-fast-branches */
      0, /* *bge/%rR/n0/fR*-no-fast-branches */
      0, /* *bge/%rR/nR/fR*-no-fast-branches */
      0, /* *bge/n0/%r0/fR*-no-fast-branches */
      0, /* *bge/n0/%r1/fR*-no-fast-branches */
      0, /* *bge/n0/%rR/fR*-no-fast-branches */
      0, /* *bge/n0/n0/fR*-no-fast-branches */
      0, /* *bge/n0/nR/fR*-no-fast-branches */
      0, /* *bge/nR/%r0/fR*-no-fast-branches */
      0, /* *bge/nR/%r1/fR*-no-fast-branches */
      0, /* *bge/nR/%rR/fR*-no-fast-branches */
      0, /* *bge/nR/n0/fR*-no-fast-branches */
      0, /* *bge/nR/nR/fR*-no-fast-branches */
      0, /* *bger-stack/%r0/fR*-no-fast-branches */
      0, /* *bger-stack/%r1/fR*-no-fast-branches */
      0, /* *bger-stack/%rR/fR*-no-fast-branches */
      0, /* *bl/%r0/%r0/fR*-no-fast-branches */
      0, /* *bl/%r0/%r1/fR*-no-fast-branches */
      0, /* *bl/%r0/%rR/fR*-no-fast-branches */
      0, /* *bl/%r0/n0/fR*-no-fast-branches */
      0, /* *bl/%r0/nR/fR*-no-fast-branches */
      0, /* *bl/%r1/%r0/fR*-no-fast-branches */
      0, /* *bl/%r1/%r1/fR*-no-fast-branches */
      0, /* *bl/%r1/%rR/fR*-no-fast-branches */
      0, /* *bl/%r1/n0/fR*-no-fast-branches */
      0, /* *bl/%r1/nR/fR*-no-fast-branches */
      0, /* *bl/%rR/%r0/fR*-no-fast-branches */
      0, /* *bl/%rR/%r1/fR*-no-fast-branches */
      0, /* *bl/%rR/%rR/fR*-no-fast-branches */
      0, /* *bl/%rR/n0/fR*-no-fast-branches */
      0, /* *bl/%rR/nR/fR*-no-fast-branches */
      0, /* *bl/n0/%r0/fR*-no-fast-branches */
      0, /* *bl/n0/%r1/fR*-no-fast-branches */
      0, /* *bl/n0/%rR/fR*-no-fast-branches */
      0, /* *bl/n0/n0/fR*-no-fast-branches */
      0, /* *bl/n0/nR/fR*-no-fast-branches */
      0, /* *bl/nR/%r0/fR*-no-fast-branches */
      0, /* *bl/nR/%r1/fR*-no-fast-branches */
      0, /* *bl/nR/%rR/fR*-no-fast-branches */
      0, /* *bl/nR/n0/fR*-no-fast-branches */
      0, /* *bl/nR/nR/fR*-no-fast-branches */
      0, /* *ble/%r0/%r0/fR*-no-fast-branches */
      0, /* *ble/%r0/%r1/fR*-no-fast-branches */
      0, /* *ble/%r0/%rR/fR*-no-fast-branches */
      0, /* *ble/%r0/n0/fR*-no-fast-branches */
      0, /* *ble/%r0/nR/fR*-no-fast-branches */
      0, /* *ble/%r1/%r0/fR*-no-fast-branches */
      0, /* *ble/%r1/%r1/fR*-no-fast-branches */
      0, /* *ble/%r1/%rR/fR*-no-fast-branches */
      0, /* *ble/%r1/n0/fR*-no-fast-branches */
      0, /* *ble/%r1/nR/fR*-no-fast-branches */
      0, /* *ble/%rR/%r0/fR*-no-fast-branches */
      0, /* *ble/%rR/%r1/fR*-no-fast-branches */
      0, /* *ble/%rR/%rR/fR*-no-fast-branches */
      0, /* *ble/%rR/n0/fR*-no-fast-branches */
      0, /* *ble/%rR/nR/fR*-no-fast-branches */
      0, /* *ble/n0/%r0/fR*-no-fast-branches */
      0, /* *ble/n0/%r1/fR*-no-fast-branches */
      0, /* *ble/n0/%rR/fR*-no-fast-branches */
      0, /* *ble/n0/n0/fR*-no-fast-branches */
      0, /* *ble/n0/nR/fR*-no-fast-branches */
      0, /* *ble/nR/%r0/fR*-no-fast-branches */
      0, /* *ble/nR/%r1/fR*-no-fast-branches */
      0, /* *ble/nR/%rR/fR*-no-fast-branches */
      0, /* *ble/nR/n0/fR*-no-fast-branches */
      0, /* *ble/nR/nR/fR*-no-fast-branches */
      0, /* *bne/%r0/%r0/fR*-no-fast-branches */
      0, /* *bne/%r0/%r1/fR*-no-fast-branches */
      0, /* *bne/%r0/%rR/fR*-no-fast-branches */
      0, /* *bne/%r0/n0/fR*-no-fast-branches */
      0, /* *bne/%r0/nR/fR*-no-fast-branches */
      0, /* *bne/%r1/%r0/fR*-no-fast-branches */
      0, /* *bne/%r1/%r1/fR*-no-fast-branches */
      0, /* *bne/%r1/%rR/fR*-no-fast-branches */
      0, /* *bne/%r1/n0/fR*-no-fast-branches */
      0, /* *bne/%r1/nR/fR*-no-fast-branches */
      0, /* *bne/%rR/%r0/fR*-no-fast-branches */
      0, /* *bne/%rR/%r1/fR*-no-fast-branches */
      0, /* *bne/%rR/%rR/fR*-no-fast-branches */
      0, /* *bne/%rR/n0/fR*-no-fast-branches */
      0, /* *bne/%rR/nR/fR*-no-fast-branches */
      0, /* *bne/n0/%r0/fR*-no-fast-branches */
      0, /* *bne/n0/%r1/fR*-no-fast-branches */
      0, /* *bne/n0/%rR/fR*-no-fast-branches */
      0, /* *bne/n0/n0/fR*-no-fast-branches */
      0, /* *bne/n0/nR/fR*-no-fast-branches */
      0, /* *bne/nR/%r0/fR*-no-fast-branches */
      0, /* *bne/nR/%r1/fR*-no-fast-branches */
      0, /* *bne/nR/%rR/fR*-no-fast-branches */
      0, /* *bne/nR/n0/fR*-no-fast-branches */
      0, /* *bne/nR/nR/fR*-no-fast-branches */
      0, /* *bneqi-stack/n-1/fR*-no-fast-branches */
      0, /* *bneqi-stack/n0/fR*-no-fast-branches */
      0, /* *bneqi-stack/n1/fR*-no-fast-branches */
      0, /* *bneqi-stack/n2/fR*-no-fast-branches */
      0, /* *bneqi-stack/nR/fR*-no-fast-branches */
      0, /* *bneqr-stack/%r0/fR*-no-fast-branches */
      0, /* *bneqr-stack/%r1/fR*-no-fast-branches */
      0, /* *bneqr-stack/%rR/fR*-no-fast-branches */
      0, /* *bt-stack/fR*-no-fast-branches */
      0, /* *pushr-beqr-stack/%r0/%r0/fR*-no-fast-branches */
      0, /* *pushr-beqr-stack/%r0/%r1/fR*-no-fast-branches */
      0, /* *pushr-beqr-stack/%r0/%rR/fR*-no-fast-branches */
      0, /* *pushr-beqr-stack/%r1/%r0/fR*-no-fast-branches */
      0, /* *pushr-beqr-stack/%r1/%r1/fR*-no-fast-branches */
      0, /* *pushr-beqr-stack/%r1/%rR/fR*-no-fast-branches */
      0, /* *pushr-beqr-stack/%rR/%r0/fR*-no-fast-branches */
      0, /* *pushr-beqr-stack/%rR/%r1/fR*-no-fast-branches */
      0, /* *pushr-beqr-stack/%rR/%rR/fR*-no-fast-branches */
      0, /* *pushr-bger-stack/%r0/%r0/fR*-no-fast-branches */
      0, /* *pushr-bger-stack/%r0/%r1/fR*-no-fast-branches */
      0, /* *pushr-bger-stack/%r0/%rR/fR*-no-fast-branches */
      0, /* *pushr-bger-stack/%r1/%r0/fR*-no-fast-branches */
      0, /* *pushr-bger-stack/%r1/%r1/fR*-no-fast-branches */
      0, /* *pushr-bger-stack/%r1/%rR/fR*-no-fast-branches */
      0, /* *pushr-bger-stack/%rR/%r0/fR*-no-fast-branches */
      0, /* *pushr-bger-stack/%rR/%r1/fR*-no-fast-branches */
      0 /* *pushr-bger-stack/%rR/%rR/fR*-no-fast-branches */
    };
#endif // #ifdef JITTER_HAVE_PATCH_IN

// FIXME: I may want to conditionalize this.
const bool
structuredvm_specialized_instruction_relocatables [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO]
  = {
      true, // !INVALID
      true, // !BEGINBASICBLOCK
      true, // !EXITVM
      true, // !DATALOCATIONS
      true, // !NOP
      true, // !UNREACHABLE0
      true, // !UNREACHABLE1
      true, // !UNREACHABLE2
      true, // b/fR
      true, // be/%r0/%r0/fR
      true, // be/%r0/%r1/fR
      true, // be/%r0/%rR/fR
      true, // be/%r0/n0/fR
      true, // be/%r0/nR/fR
      true, // be/%r1/%r0/fR
      true, // be/%r1/%r1/fR
      true, // be/%r1/%rR/fR
      true, // be/%r1/n0/fR
      true, // be/%r1/nR/fR
      true, // be/%rR/%r0/fR
      true, // be/%rR/%r1/fR
      true, // be/%rR/%rR/fR
      true, // be/%rR/n0/fR
      true, // be/%rR/nR/fR
      true, // be/n0/%r0/fR
      true, // be/n0/%r1/fR
      true, // be/n0/%rR/fR
      true, // be/n0/n0/fR
      true, // be/n0/nR/fR
      true, // be/nR/%r0/fR
      true, // be/nR/%r1/fR
      true, // be/nR/%rR/fR
      true, // be/nR/n0/fR
      true, // be/nR/nR/fR
      true, // beqi-stack/n-1/fR
      true, // beqi-stack/n0/fR
      true, // beqi-stack/n1/fR
      true, // beqi-stack/n2/fR
      true, // beqi-stack/nR/fR
      true, // beqr-stack/%r0/fR
      true, // beqr-stack/%r1/fR
      true, // beqr-stack/%rR/fR
      true, // bf-stack/fR
      true, // bg/%r0/%r0/fR
      true, // bg/%r0/%r1/fR
      true, // bg/%r0/%rR/fR
      true, // bg/%r0/n0/fR
      true, // bg/%r0/nR/fR
      true, // bg/%r1/%r0/fR
      true, // bg/%r1/%r1/fR
      true, // bg/%r1/%rR/fR
      true, // bg/%r1/n0/fR
      true, // bg/%r1/nR/fR
      true, // bg/%rR/%r0/fR
      true, // bg/%rR/%r1/fR
      true, // bg/%rR/%rR/fR
      true, // bg/%rR/n0/fR
      true, // bg/%rR/nR/fR
      true, // bg/n0/%r0/fR
      true, // bg/n0/%r1/fR
      true, // bg/n0/%rR/fR
      true, // bg/n0/n0/fR
      true, // bg/n0/nR/fR
      true, // bg/nR/%r0/fR
      true, // bg/nR/%r1/fR
      true, // bg/nR/%rR/fR
      true, // bg/nR/n0/fR
      true, // bg/nR/nR/fR
      true, // bge/%r0/%r0/fR
      true, // bge/%r0/%r1/fR
      true, // bge/%r0/%rR/fR
      true, // bge/%r0/n0/fR
      true, // bge/%r0/nR/fR
      true, // bge/%r1/%r0/fR
      true, // bge/%r1/%r1/fR
      true, // bge/%r1/%rR/fR
      true, // bge/%r1/n0/fR
      true, // bge/%r1/nR/fR
      true, // bge/%rR/%r0/fR
      true, // bge/%rR/%r1/fR
      true, // bge/%rR/%rR/fR
      true, // bge/%rR/n0/fR
      true, // bge/%rR/nR/fR
      true, // bge/n0/%r0/fR
      true, // bge/n0/%r1/fR
      true, // bge/n0/%rR/fR
      true, // bge/n0/n0/fR
      true, // bge/n0/nR/fR
      true, // bge/nR/%r0/fR
      true, // bge/nR/%r1/fR
      true, // bge/nR/%rR/fR
      true, // bge/nR/n0/fR
      true, // bge/nR/nR/fR
      true, // bger-stack/%r0/fR
      true, // bger-stack/%r1/fR
      true, // bger-stack/%rR/fR
      true, // bl/%r0/%r0/fR
      true, // bl/%r0/%r1/fR
      true, // bl/%r0/%rR/fR
      true, // bl/%r0/n0/fR
      true, // bl/%r0/nR/fR
      true, // bl/%r1/%r0/fR
      true, // bl/%r1/%r1/fR
      true, // bl/%r1/%rR/fR
      true, // bl/%r1/n0/fR
      true, // bl/%r1/nR/fR
      true, // bl/%rR/%r0/fR
      true, // bl/%rR/%r1/fR
      true, // bl/%rR/%rR/fR
      true, // bl/%rR/n0/fR
      true, // bl/%rR/nR/fR
      true, // bl/n0/%r0/fR
      true, // bl/n0/%r1/fR
      true, // bl/n0/%rR/fR
      true, // bl/n0/n0/fR
      true, // bl/n0/nR/fR
      true, // bl/nR/%r0/fR
      true, // bl/nR/%r1/fR
      true, // bl/nR/%rR/fR
      true, // bl/nR/n0/fR
      true, // bl/nR/nR/fR
      true, // ble/%r0/%r0/fR
      true, // ble/%r0/%r1/fR
      true, // ble/%r0/%rR/fR
      true, // ble/%r0/n0/fR
      true, // ble/%r0/nR/fR
      true, // ble/%r1/%r0/fR
      true, // ble/%r1/%r1/fR
      true, // ble/%r1/%rR/fR
      true, // ble/%r1/n0/fR
      true, // ble/%r1/nR/fR
      true, // ble/%rR/%r0/fR
      true, // ble/%rR/%r1/fR
      true, // ble/%rR/%rR/fR
      true, // ble/%rR/n0/fR
      true, // ble/%rR/nR/fR
      true, // ble/n0/%r0/fR
      true, // ble/n0/%r1/fR
      true, // ble/n0/%rR/fR
      true, // ble/n0/n0/fR
      true, // ble/n0/nR/fR
      true, // ble/nR/%r0/fR
      true, // ble/nR/%r1/fR
      true, // ble/nR/%rR/fR
      true, // ble/nR/n0/fR
      true, // ble/nR/nR/fR
      true, // bne/%r0/%r0/fR
      true, // bne/%r0/%r1/fR
      true, // bne/%r0/%rR/fR
      true, // bne/%r0/n0/fR
      true, // bne/%r0/nR/fR
      true, // bne/%r1/%r0/fR
      true, // bne/%r1/%r1/fR
      true, // bne/%r1/%rR/fR
      true, // bne/%r1/n0/fR
      true, // bne/%r1/nR/fR
      true, // bne/%rR/%r0/fR
      true, // bne/%rR/%r1/fR
      true, // bne/%rR/%rR/fR
      true, // bne/%rR/n0/fR
      true, // bne/%rR/nR/fR
      true, // bne/n0/%r0/fR
      true, // bne/n0/%r1/fR
      true, // bne/n0/%rR/fR
      true, // bne/n0/n0/fR
      true, // bne/n0/nR/fR
      true, // bne/nR/%r0/fR
      true, // bne/nR/%r1/fR
      true, // bne/nR/%rR/fR
      true, // bne/nR/n0/fR
      true, // bne/nR/nR/fR
      true, // bneqi-stack/n-1/fR
      true, // bneqi-stack/n0/fR
      true, // bneqi-stack/n1/fR
      true, // bneqi-stack/n2/fR
      true, // bneqi-stack/nR/fR
      true, // bneqr-stack/%r0/fR
      true, // bneqr-stack/%r1/fR
      true, // bneqr-stack/%rR/fR
      true, // bt-stack/fR
      true, // copy-to-r-stack/%r0
      true, // copy-to-r-stack/%r1
      true, // copy-to-r-stack/%rR
      true, // different-stack
      true, // differenti-stack/n0
      true, // differenti-stack/n1
      true, // differenti-stack/n2
      true, // differenti-stack/nR
      true, // divided/%r0/%r0/%r0
      true, // divided/%r0/%r0/%r1
      true, // divided/%r0/%r0/%rR
      true, // divided/%r0/%r1/%r0
      true, // divided/%r0/%r1/%r1
      true, // divided/%r0/%r1/%rR
      true, // divided/%r0/%rR/%r0
      true, // divided/%r0/%rR/%r1
      true, // divided/%r0/%rR/%rR
      true, // divided/%r0/n2/%r0
      true, // divided/%r0/n2/%r1
      true, // divided/%r0/n2/%rR
      true, // divided/%r0/nR/%r0
      true, // divided/%r0/nR/%r1
      true, // divided/%r0/nR/%rR
      true, // divided/%r1/%r0/%r0
      true, // divided/%r1/%r0/%r1
      true, // divided/%r1/%r0/%rR
      true, // divided/%r1/%r1/%r0
      true, // divided/%r1/%r1/%r1
      true, // divided/%r1/%r1/%rR
      true, // divided/%r1/%rR/%r0
      true, // divided/%r1/%rR/%r1
      true, // divided/%r1/%rR/%rR
      true, // divided/%r1/n2/%r0
      true, // divided/%r1/n2/%r1
      true, // divided/%r1/n2/%rR
      true, // divided/%r1/nR/%r0
      true, // divided/%r1/nR/%r1
      true, // divided/%r1/nR/%rR
      true, // divided/%rR/%r0/%r0
      true, // divided/%rR/%r0/%r1
      true, // divided/%rR/%r0/%rR
      true, // divided/%rR/%r1/%r0
      true, // divided/%rR/%r1/%r1
      true, // divided/%rR/%r1/%rR
      true, // divided/%rR/%rR/%r0
      true, // divided/%rR/%rR/%r1
      true, // divided/%rR/%rR/%rR
      true, // divided/%rR/n2/%r0
      true, // divided/%rR/n2/%r1
      true, // divided/%rR/n2/%rR
      true, // divided/%rR/nR/%r0
      true, // divided/%rR/nR/%r1
      true, // divided/%rR/nR/%rR
      true, // divided/nR/%r0/%r0
      true, // divided/nR/%r0/%r1
      true, // divided/nR/%r0/%rR
      true, // divided/nR/%r1/%r0
      true, // divided/nR/%r1/%r1
      true, // divided/nR/%r1/%rR
      true, // divided/nR/%rR/%r0
      true, // divided/nR/%rR/%r1
      true, // divided/nR/%rR/%rR
      true, // divided/nR/n2/%r0
      true, // divided/nR/n2/%r1
      true, // divided/nR/n2/%rR
      true, // divided/nR/nR/%r0
      true, // divided/nR/nR/%r1
      true, // divided/nR/nR/%rR
      true, // divided-stack
      true, // drop-stack
      true, // dup-stack
      true, // equal-stack
      true, // equali-stack/n0
      true, // equali-stack/n1
      true, // equali-stack/n2
      true, // equali-stack/nR
      true, // exitvm
      true, // greater-stack
      true, // greaterorequal-stack
      false, // input/%r0/retR
      false, // input/%r1/retR
      false, // input/%rR/retR
      false, // input-stack/retR
      true, // isnonzero-stack
      true, // less-stack
      true, // lessorequal-stack
      true, // logicaland-stack
      true, // logicalnot-stack
      true, // logicalor-stack
      true, // minus/%r0/%r0/%r0
      true, // minus/%r0/%r0/%r1
      true, // minus/%r0/%r0/%rR
      true, // minus/%r0/%r1/%r0
      true, // minus/%r0/%r1/%r1
      true, // minus/%r0/%r1/%rR
      true, // minus/%r0/%rR/%r0
      true, // minus/%r0/%rR/%r1
      true, // minus/%r0/%rR/%rR
      true, // minus/%r0/n1/%r0
      true, // minus/%r0/n1/%r1
      true, // minus/%r0/n1/%rR
      true, // minus/%r0/n2/%r0
      true, // minus/%r0/n2/%r1
      true, // minus/%r0/n2/%rR
      true, // minus/%r0/nR/%r0
      true, // minus/%r0/nR/%r1
      true, // minus/%r0/nR/%rR
      true, // minus/%r1/%r0/%r0
      true, // minus/%r1/%r0/%r1
      true, // minus/%r1/%r0/%rR
      true, // minus/%r1/%r1/%r0
      true, // minus/%r1/%r1/%r1
      true, // minus/%r1/%r1/%rR
      true, // minus/%r1/%rR/%r0
      true, // minus/%r1/%rR/%r1
      true, // minus/%r1/%rR/%rR
      true, // minus/%r1/n1/%r0
      true, // minus/%r1/n1/%r1
      true, // minus/%r1/n1/%rR
      true, // minus/%r1/n2/%r0
      true, // minus/%r1/n2/%r1
      true, // minus/%r1/n2/%rR
      true, // minus/%r1/nR/%r0
      true, // minus/%r1/nR/%r1
      true, // minus/%r1/nR/%rR
      true, // minus/%rR/%r0/%r0
      true, // minus/%rR/%r0/%r1
      true, // minus/%rR/%r0/%rR
      true, // minus/%rR/%r1/%r0
      true, // minus/%rR/%r1/%r1
      true, // minus/%rR/%r1/%rR
      true, // minus/%rR/%rR/%r0
      true, // minus/%rR/%rR/%r1
      true, // minus/%rR/%rR/%rR
      true, // minus/%rR/n1/%r0
      true, // minus/%rR/n1/%r1
      true, // minus/%rR/n1/%rR
      true, // minus/%rR/n2/%r0
      true, // minus/%rR/n2/%r1
      true, // minus/%rR/n2/%rR
      true, // minus/%rR/nR/%r0
      true, // minus/%rR/nR/%r1
      true, // minus/%rR/nR/%rR
      true, // minus/nR/%r0/%r0
      true, // minus/nR/%r0/%r1
      true, // minus/nR/%r0/%rR
      true, // minus/nR/%r1/%r0
      true, // minus/nR/%r1/%r1
      true, // minus/nR/%r1/%rR
      true, // minus/nR/%rR/%r0
      true, // minus/nR/%rR/%r1
      true, // minus/nR/%rR/%rR
      true, // minus/nR/n1/%r0
      true, // minus/nR/n1/%r1
      true, // minus/nR/n1/%rR
      true, // minus/nR/n2/%r0
      true, // minus/nR/n2/%r1
      true, // minus/nR/n2/%rR
      true, // minus/nR/nR/%r0
      true, // minus/nR/nR/%r1
      true, // minus/nR/nR/%rR
      true, // minus-stack
      true, // minusi-stack/n1
      true, // minusi-stack/n2
      true, // minusi-stack/nR
      true, // minusr-stack/%r0
      true, // minusr-stack/%r1
      true, // minusr-stack/%rR
      true, // mov/%r0/%r0
      true, // mov/%r0/%r1
      true, // mov/%r0/%rR
      true, // mov/%r1/%r0
      true, // mov/%r1/%r1
      true, // mov/%r1/%rR
      true, // mov/%rR/%r0
      true, // mov/%rR/%r1
      true, // mov/%rR/%rR
      true, // mov/n0/%r0
      true, // mov/n0/%r1
      true, // mov/n0/%rR
      true, // mov/n1/%r0
      true, // mov/n1/%r1
      true, // mov/n1/%rR
      true, // mov/n-1/%r0
      true, // mov/n-1/%r1
      true, // mov/n-1/%rR
      true, // mov/n2/%r0
      true, // mov/n2/%r1
      true, // mov/n2/%rR
      true, // mov/nR/%r0
      true, // mov/nR/%r1
      true, // mov/nR/%rR
      true, // plus/%r0/%r0/%r0
      true, // plus/%r0/%r0/%r1
      true, // plus/%r0/%r0/%rR
      true, // plus/%r0/%r1/%r0
      true, // plus/%r0/%r1/%r1
      true, // plus/%r0/%r1/%rR
      true, // plus/%r0/%rR/%r0
      true, // plus/%r0/%rR/%r1
      true, // plus/%r0/%rR/%rR
      true, // plus/%r0/n1/%r0
      true, // plus/%r0/n1/%r1
      true, // plus/%r0/n1/%rR
      true, // plus/%r0/n2/%r0
      true, // plus/%r0/n2/%r1
      true, // plus/%r0/n2/%rR
      true, // plus/%r0/nR/%r0
      true, // plus/%r0/nR/%r1
      true, // plus/%r0/nR/%rR
      true, // plus/%r1/%r0/%r0
      true, // plus/%r1/%r0/%r1
      true, // plus/%r1/%r0/%rR
      true, // plus/%r1/%r1/%r0
      true, // plus/%r1/%r1/%r1
      true, // plus/%r1/%r1/%rR
      true, // plus/%r1/%rR/%r0
      true, // plus/%r1/%rR/%r1
      true, // plus/%r1/%rR/%rR
      true, // plus/%r1/n1/%r0
      true, // plus/%r1/n1/%r1
      true, // plus/%r1/n1/%rR
      true, // plus/%r1/n2/%r0
      true, // plus/%r1/n2/%r1
      true, // plus/%r1/n2/%rR
      true, // plus/%r1/nR/%r0
      true, // plus/%r1/nR/%r1
      true, // plus/%r1/nR/%rR
      true, // plus/%rR/%r0/%r0
      true, // plus/%rR/%r0/%r1
      true, // plus/%rR/%r0/%rR
      true, // plus/%rR/%r1/%r0
      true, // plus/%rR/%r1/%r1
      true, // plus/%rR/%r1/%rR
      true, // plus/%rR/%rR/%r0
      true, // plus/%rR/%rR/%r1
      true, // plus/%rR/%rR/%rR
      true, // plus/%rR/n1/%r0
      true, // plus/%rR/n1/%r1
      true, // plus/%rR/n1/%rR
      true, // plus/%rR/n2/%r0
      true, // plus/%rR/n2/%r1
      true, // plus/%rR/n2/%rR
      true, // plus/%rR/nR/%r0
      true, // plus/%rR/nR/%r1
      true, // plus/%rR/nR/%rR
      true, // plus/nR/%r0/%r0
      true, // plus/nR/%r0/%r1
      true, // plus/nR/%r0/%rR
      true, // plus/nR/%r1/%r0
      true, // plus/nR/%r1/%r1
      true, // plus/nR/%r1/%rR
      true, // plus/nR/%rR/%r0
      true, // plus/nR/%rR/%r1
      true, // plus/nR/%rR/%rR
      true, // plus/nR/n1/%r0
      true, // plus/nR/n1/%r1
      true, // plus/nR/n1/%rR
      true, // plus/nR/n2/%r0
      true, // plus/nR/n2/%r1
      true, // plus/nR/n2/%rR
      true, // plus/nR/nR/%r0
      true, // plus/nR/nR/%r1
      true, // plus/nR/nR/%rR
      true, // plus-stack
      true, // plusi-stack/n-1
      true, // plusi-stack/n1
      true, // plusi-stack/n2
      true, // plusi-stack/nR
      true, // pop-stack/%r0
      true, // pop-stack/%r1
      true, // pop-stack/%rR
      false, // print/%r0/retR
      false, // print/%r1/retR
      false, // print/%rR/retR
      false, // print/nR/retR
      false, // print-stack/retR
      true, // push-stack/%r0
      true, // push-stack/%r1
      true, // push-stack/%rR
      true, // push-stack/n0
      true, // push-stack/n1
      true, // push-stack/n-1
      true, // push-stack/n2
      true, // push-stack/nR
      true, // push-stack/lR
      true, // pushr-beqr-stack/%r0/%r0/fR
      true, // pushr-beqr-stack/%r0/%r1/fR
      true, // pushr-beqr-stack/%r0/%rR/fR
      true, // pushr-beqr-stack/%r1/%r0/fR
      true, // pushr-beqr-stack/%r1/%r1/fR
      true, // pushr-beqr-stack/%r1/%rR/fR
      true, // pushr-beqr-stack/%rR/%r0/fR
      true, // pushr-beqr-stack/%rR/%r1/fR
      true, // pushr-beqr-stack/%rR/%rR/fR
      true, // pushr-bger-stack/%r0/%r0/fR
      true, // pushr-bger-stack/%r0/%r1/fR
      true, // pushr-bger-stack/%r0/%rR/fR
      true, // pushr-bger-stack/%r1/%r0/fR
      true, // pushr-bger-stack/%r1/%r1/fR
      true, // pushr-bger-stack/%r1/%rR/fR
      true, // pushr-bger-stack/%rR/%r0/fR
      true, // pushr-bger-stack/%rR/%r1/fR
      true, // pushr-bger-stack/%rR/%rR/fR
      true, // pushr-minusr-pop-stack/%r0/%r0/%r0
      true, // pushr-minusr-pop-stack/%r0/%r0/%r1
      true, // pushr-minusr-pop-stack/%r0/%r0/%rR
      true, // pushr-minusr-pop-stack/%r0/%r1/%r0
      true, // pushr-minusr-pop-stack/%r0/%r1/%r1
      true, // pushr-minusr-pop-stack/%r0/%r1/%rR
      true, // pushr-minusr-pop-stack/%r0/%rR/%r0
      true, // pushr-minusr-pop-stack/%r0/%rR/%r1
      true, // pushr-minusr-pop-stack/%r0/%rR/%rR
      true, // pushr-minusr-pop-stack/%r1/%r0/%r0
      true, // pushr-minusr-pop-stack/%r1/%r0/%r1
      true, // pushr-minusr-pop-stack/%r1/%r0/%rR
      true, // pushr-minusr-pop-stack/%r1/%r1/%r0
      true, // pushr-minusr-pop-stack/%r1/%r1/%r1
      true, // pushr-minusr-pop-stack/%r1/%r1/%rR
      true, // pushr-minusr-pop-stack/%r1/%rR/%r0
      true, // pushr-minusr-pop-stack/%r1/%rR/%r1
      true, // pushr-minusr-pop-stack/%r1/%rR/%rR
      true, // pushr-minusr-pop-stack/%rR/%r0/%r0
      true, // pushr-minusr-pop-stack/%rR/%r0/%r1
      true, // pushr-minusr-pop-stack/%rR/%r0/%rR
      true, // pushr-minusr-pop-stack/%rR/%r1/%r0
      true, // pushr-minusr-pop-stack/%rR/%r1/%r1
      true, // pushr-minusr-pop-stack/%rR/%r1/%rR
      true, // pushr-minusr-pop-stack/%rR/%rR/%r0
      true, // pushr-minusr-pop-stack/%rR/%rR/%r1
      true, // pushr-minusr-pop-stack/%rR/%rR/%rR
      true, // remainder/%r0/%r0/%r0
      true, // remainder/%r0/%r0/%r1
      true, // remainder/%r0/%r0/%rR
      true, // remainder/%r0/%r1/%r0
      true, // remainder/%r0/%r1/%r1
      true, // remainder/%r0/%r1/%rR
      true, // remainder/%r0/%rR/%r0
      true, // remainder/%r0/%rR/%r1
      true, // remainder/%r0/%rR/%rR
      true, // remainder/%r0/n2/%r0
      true, // remainder/%r0/n2/%r1
      true, // remainder/%r0/n2/%rR
      true, // remainder/%r0/nR/%r0
      true, // remainder/%r0/nR/%r1
      true, // remainder/%r0/nR/%rR
      true, // remainder/%r1/%r0/%r0
      true, // remainder/%r1/%r0/%r1
      true, // remainder/%r1/%r0/%rR
      true, // remainder/%r1/%r1/%r0
      true, // remainder/%r1/%r1/%r1
      true, // remainder/%r1/%r1/%rR
      true, // remainder/%r1/%rR/%r0
      true, // remainder/%r1/%rR/%r1
      true, // remainder/%r1/%rR/%rR
      true, // remainder/%r1/n2/%r0
      true, // remainder/%r1/n2/%r1
      true, // remainder/%r1/n2/%rR
      true, // remainder/%r1/nR/%r0
      true, // remainder/%r1/nR/%r1
      true, // remainder/%r1/nR/%rR
      true, // remainder/%rR/%r0/%r0
      true, // remainder/%rR/%r0/%r1
      true, // remainder/%rR/%r0/%rR
      true, // remainder/%rR/%r1/%r0
      true, // remainder/%rR/%r1/%r1
      true, // remainder/%rR/%r1/%rR
      true, // remainder/%rR/%rR/%r0
      true, // remainder/%rR/%rR/%r1
      true, // remainder/%rR/%rR/%rR
      true, // remainder/%rR/n2/%r0
      true, // remainder/%rR/n2/%r1
      true, // remainder/%rR/n2/%rR
      true, // remainder/%rR/nR/%r0
      true, // remainder/%rR/nR/%r1
      true, // remainder/%rR/nR/%rR
      true, // remainder/nR/%r0/%r0
      true, // remainder/nR/%r0/%r1
      true, // remainder/nR/%r0/%rR
      true, // remainder/nR/%r1/%r0
      true, // remainder/nR/%r1/%r1
      true, // remainder/nR/%r1/%rR
      true, // remainder/nR/%rR/%r0
      true, // remainder/nR/%rR/%r1
      true, // remainder/nR/%rR/%rR
      true, // remainder/nR/n2/%r0
      true, // remainder/nR/n2/%r1
      true, // remainder/nR/n2/%rR
      true, // remainder/nR/nR/%r0
      true, // remainder/nR/nR/%r1
      true, // remainder/nR/nR/%rR
      true, // remainder-stack
      true, // times/%r0/%r0/%r0
      true, // times/%r0/%r0/%r1
      true, // times/%r0/%r0/%rR
      true, // times/%r0/%r1/%r0
      true, // times/%r0/%r1/%r1
      true, // times/%r0/%r1/%rR
      true, // times/%r0/%rR/%r0
      true, // times/%r0/%rR/%r1
      true, // times/%r0/%rR/%rR
      true, // times/%r0/n2/%r0
      true, // times/%r0/n2/%r1
      true, // times/%r0/n2/%rR
      true, // times/%r0/nR/%r0
      true, // times/%r0/nR/%r1
      true, // times/%r0/nR/%rR
      true, // times/%r1/%r0/%r0
      true, // times/%r1/%r0/%r1
      true, // times/%r1/%r0/%rR
      true, // times/%r1/%r1/%r0
      true, // times/%r1/%r1/%r1
      true, // times/%r1/%r1/%rR
      true, // times/%r1/%rR/%r0
      true, // times/%r1/%rR/%r1
      true, // times/%r1/%rR/%rR
      true, // times/%r1/n2/%r0
      true, // times/%r1/n2/%r1
      true, // times/%r1/n2/%rR
      true, // times/%r1/nR/%r0
      true, // times/%r1/nR/%r1
      true, // times/%r1/nR/%rR
      true, // times/%rR/%r0/%r0
      true, // times/%rR/%r0/%r1
      true, // times/%rR/%r0/%rR
      true, // times/%rR/%r1/%r0
      true, // times/%rR/%r1/%r1
      true, // times/%rR/%r1/%rR
      true, // times/%rR/%rR/%r0
      true, // times/%rR/%rR/%r1
      true, // times/%rR/%rR/%rR
      true, // times/%rR/n2/%r0
      true, // times/%rR/n2/%r1
      true, // times/%rR/n2/%rR
      true, // times/%rR/nR/%r0
      true, // times/%rR/nR/%r1
      true, // times/%rR/nR/%rR
      true, // times/nR/%r0/%r0
      true, // times/nR/%r0/%r1
      true, // times/nR/%r0/%rR
      true, // times/nR/%r1/%r0
      true, // times/nR/%r1/%r1
      true, // times/nR/%r1/%rR
      true, // times/nR/%rR/%r0
      true, // times/nR/%rR/%r1
      true, // times/nR/%rR/%rR
      true, // times/nR/n2/%r0
      true, // times/nR/n2/%r1
      true, // times/nR/n2/%rR
      true, // times/nR/nR/%r0
      true, // times/nR/nR/%r1
      true, // times/nR/nR/%rR
      true, // times-stack
      true, // uminus/%r0/%r0
      true, // uminus/%r0/%r1
      true, // uminus/%r0/%rR
      true, // uminus/%r1/%r0
      true, // uminus/%r1/%r1
      true, // uminus/%r1/%rR
      true, // uminus/%rR/%r0
      true, // uminus/%rR/%r1
      true, // uminus/%rR/%rR
      true, // uminus/nR/%r0
      true, // uminus/nR/%r1
      true, // uminus/nR/%rR
      true, // uminus-stack
      true, // unreachable
      false, // *b/fR*-no-fast-branches
      false, // *be/%r0/%r0/fR*-no-fast-branches
      false, // *be/%r0/%r1/fR*-no-fast-branches
      false, // *be/%r0/%rR/fR*-no-fast-branches
      false, // *be/%r0/n0/fR*-no-fast-branches
      false, // *be/%r0/nR/fR*-no-fast-branches
      false, // *be/%r1/%r0/fR*-no-fast-branches
      false, // *be/%r1/%r1/fR*-no-fast-branches
      false, // *be/%r1/%rR/fR*-no-fast-branches
      false, // *be/%r1/n0/fR*-no-fast-branches
      false, // *be/%r1/nR/fR*-no-fast-branches
      false, // *be/%rR/%r0/fR*-no-fast-branches
      false, // *be/%rR/%r1/fR*-no-fast-branches
      false, // *be/%rR/%rR/fR*-no-fast-branches
      false, // *be/%rR/n0/fR*-no-fast-branches
      false, // *be/%rR/nR/fR*-no-fast-branches
      false, // *be/n0/%r0/fR*-no-fast-branches
      false, // *be/n0/%r1/fR*-no-fast-branches
      false, // *be/n0/%rR/fR*-no-fast-branches
      false, // *be/n0/n0/fR*-no-fast-branches
      false, // *be/n0/nR/fR*-no-fast-branches
      false, // *be/nR/%r0/fR*-no-fast-branches
      false, // *be/nR/%r1/fR*-no-fast-branches
      false, // *be/nR/%rR/fR*-no-fast-branches
      false, // *be/nR/n0/fR*-no-fast-branches
      false, // *be/nR/nR/fR*-no-fast-branches
      false, // *beqi-stack/n-1/fR*-no-fast-branches
      false, // *beqi-stack/n0/fR*-no-fast-branches
      false, // *beqi-stack/n1/fR*-no-fast-branches
      false, // *beqi-stack/n2/fR*-no-fast-branches
      false, // *beqi-stack/nR/fR*-no-fast-branches
      false, // *beqr-stack/%r0/fR*-no-fast-branches
      false, // *beqr-stack/%r1/fR*-no-fast-branches
      false, // *beqr-stack/%rR/fR*-no-fast-branches
      false, // *bf-stack/fR*-no-fast-branches
      false, // *bg/%r0/%r0/fR*-no-fast-branches
      false, // *bg/%r0/%r1/fR*-no-fast-branches
      false, // *bg/%r0/%rR/fR*-no-fast-branches
      false, // *bg/%r0/n0/fR*-no-fast-branches
      false, // *bg/%r0/nR/fR*-no-fast-branches
      false, // *bg/%r1/%r0/fR*-no-fast-branches
      false, // *bg/%r1/%r1/fR*-no-fast-branches
      false, // *bg/%r1/%rR/fR*-no-fast-branches
      false, // *bg/%r1/n0/fR*-no-fast-branches
      false, // *bg/%r1/nR/fR*-no-fast-branches
      false, // *bg/%rR/%r0/fR*-no-fast-branches
      false, // *bg/%rR/%r1/fR*-no-fast-branches
      false, // *bg/%rR/%rR/fR*-no-fast-branches
      false, // *bg/%rR/n0/fR*-no-fast-branches
      false, // *bg/%rR/nR/fR*-no-fast-branches
      false, // *bg/n0/%r0/fR*-no-fast-branches
      false, // *bg/n0/%r1/fR*-no-fast-branches
      false, // *bg/n0/%rR/fR*-no-fast-branches
      false, // *bg/n0/n0/fR*-no-fast-branches
      false, // *bg/n0/nR/fR*-no-fast-branches
      false, // *bg/nR/%r0/fR*-no-fast-branches
      false, // *bg/nR/%r1/fR*-no-fast-branches
      false, // *bg/nR/%rR/fR*-no-fast-branches
      false, // *bg/nR/n0/fR*-no-fast-branches
      false, // *bg/nR/nR/fR*-no-fast-branches
      false, // *bge/%r0/%r0/fR*-no-fast-branches
      false, // *bge/%r0/%r1/fR*-no-fast-branches
      false, // *bge/%r0/%rR/fR*-no-fast-branches
      false, // *bge/%r0/n0/fR*-no-fast-branches
      false, // *bge/%r0/nR/fR*-no-fast-branches
      false, // *bge/%r1/%r0/fR*-no-fast-branches
      false, // *bge/%r1/%r1/fR*-no-fast-branches
      false, // *bge/%r1/%rR/fR*-no-fast-branches
      false, // *bge/%r1/n0/fR*-no-fast-branches
      false, // *bge/%r1/nR/fR*-no-fast-branches
      false, // *bge/%rR/%r0/fR*-no-fast-branches
      false, // *bge/%rR/%r1/fR*-no-fast-branches
      false, // *bge/%rR/%rR/fR*-no-fast-branches
      false, // *bge/%rR/n0/fR*-no-fast-branches
      false, // *bge/%rR/nR/fR*-no-fast-branches
      false, // *bge/n0/%r0/fR*-no-fast-branches
      false, // *bge/n0/%r1/fR*-no-fast-branches
      false, // *bge/n0/%rR/fR*-no-fast-branches
      false, // *bge/n0/n0/fR*-no-fast-branches
      false, // *bge/n0/nR/fR*-no-fast-branches
      false, // *bge/nR/%r0/fR*-no-fast-branches
      false, // *bge/nR/%r1/fR*-no-fast-branches
      false, // *bge/nR/%rR/fR*-no-fast-branches
      false, // *bge/nR/n0/fR*-no-fast-branches
      false, // *bge/nR/nR/fR*-no-fast-branches
      false, // *bger-stack/%r0/fR*-no-fast-branches
      false, // *bger-stack/%r1/fR*-no-fast-branches
      false, // *bger-stack/%rR/fR*-no-fast-branches
      false, // *bl/%r0/%r0/fR*-no-fast-branches
      false, // *bl/%r0/%r1/fR*-no-fast-branches
      false, // *bl/%r0/%rR/fR*-no-fast-branches
      false, // *bl/%r0/n0/fR*-no-fast-branches
      false, // *bl/%r0/nR/fR*-no-fast-branches
      false, // *bl/%r1/%r0/fR*-no-fast-branches
      false, // *bl/%r1/%r1/fR*-no-fast-branches
      false, // *bl/%r1/%rR/fR*-no-fast-branches
      false, // *bl/%r1/n0/fR*-no-fast-branches
      false, // *bl/%r1/nR/fR*-no-fast-branches
      false, // *bl/%rR/%r0/fR*-no-fast-branches
      false, // *bl/%rR/%r1/fR*-no-fast-branches
      false, // *bl/%rR/%rR/fR*-no-fast-branches
      false, // *bl/%rR/n0/fR*-no-fast-branches
      false, // *bl/%rR/nR/fR*-no-fast-branches
      false, // *bl/n0/%r0/fR*-no-fast-branches
      false, // *bl/n0/%r1/fR*-no-fast-branches
      false, // *bl/n0/%rR/fR*-no-fast-branches
      false, // *bl/n0/n0/fR*-no-fast-branches
      false, // *bl/n0/nR/fR*-no-fast-branches
      false, // *bl/nR/%r0/fR*-no-fast-branches
      false, // *bl/nR/%r1/fR*-no-fast-branches
      false, // *bl/nR/%rR/fR*-no-fast-branches
      false, // *bl/nR/n0/fR*-no-fast-branches
      false, // *bl/nR/nR/fR*-no-fast-branches
      false, // *ble/%r0/%r0/fR*-no-fast-branches
      false, // *ble/%r0/%r1/fR*-no-fast-branches
      false, // *ble/%r0/%rR/fR*-no-fast-branches
      false, // *ble/%r0/n0/fR*-no-fast-branches
      false, // *ble/%r0/nR/fR*-no-fast-branches
      false, // *ble/%r1/%r0/fR*-no-fast-branches
      false, // *ble/%r1/%r1/fR*-no-fast-branches
      false, // *ble/%r1/%rR/fR*-no-fast-branches
      false, // *ble/%r1/n0/fR*-no-fast-branches
      false, // *ble/%r1/nR/fR*-no-fast-branches
      false, // *ble/%rR/%r0/fR*-no-fast-branches
      false, // *ble/%rR/%r1/fR*-no-fast-branches
      false, // *ble/%rR/%rR/fR*-no-fast-branches
      false, // *ble/%rR/n0/fR*-no-fast-branches
      false, // *ble/%rR/nR/fR*-no-fast-branches
      false, // *ble/n0/%r0/fR*-no-fast-branches
      false, // *ble/n0/%r1/fR*-no-fast-branches
      false, // *ble/n0/%rR/fR*-no-fast-branches
      false, // *ble/n0/n0/fR*-no-fast-branches
      false, // *ble/n0/nR/fR*-no-fast-branches
      false, // *ble/nR/%r0/fR*-no-fast-branches
      false, // *ble/nR/%r1/fR*-no-fast-branches
      false, // *ble/nR/%rR/fR*-no-fast-branches
      false, // *ble/nR/n0/fR*-no-fast-branches
      false, // *ble/nR/nR/fR*-no-fast-branches
      false, // *bne/%r0/%r0/fR*-no-fast-branches
      false, // *bne/%r0/%r1/fR*-no-fast-branches
      false, // *bne/%r0/%rR/fR*-no-fast-branches
      false, // *bne/%r0/n0/fR*-no-fast-branches
      false, // *bne/%r0/nR/fR*-no-fast-branches
      false, // *bne/%r1/%r0/fR*-no-fast-branches
      false, // *bne/%r1/%r1/fR*-no-fast-branches
      false, // *bne/%r1/%rR/fR*-no-fast-branches
      false, // *bne/%r1/n0/fR*-no-fast-branches
      false, // *bne/%r1/nR/fR*-no-fast-branches
      false, // *bne/%rR/%r0/fR*-no-fast-branches
      false, // *bne/%rR/%r1/fR*-no-fast-branches
      false, // *bne/%rR/%rR/fR*-no-fast-branches
      false, // *bne/%rR/n0/fR*-no-fast-branches
      false, // *bne/%rR/nR/fR*-no-fast-branches
      false, // *bne/n0/%r0/fR*-no-fast-branches
      false, // *bne/n0/%r1/fR*-no-fast-branches
      false, // *bne/n0/%rR/fR*-no-fast-branches
      false, // *bne/n0/n0/fR*-no-fast-branches
      false, // *bne/n0/nR/fR*-no-fast-branches
      false, // *bne/nR/%r0/fR*-no-fast-branches
      false, // *bne/nR/%r1/fR*-no-fast-branches
      false, // *bne/nR/%rR/fR*-no-fast-branches
      false, // *bne/nR/n0/fR*-no-fast-branches
      false, // *bne/nR/nR/fR*-no-fast-branches
      false, // *bneqi-stack/n-1/fR*-no-fast-branches
      false, // *bneqi-stack/n0/fR*-no-fast-branches
      false, // *bneqi-stack/n1/fR*-no-fast-branches
      false, // *bneqi-stack/n2/fR*-no-fast-branches
      false, // *bneqi-stack/nR/fR*-no-fast-branches
      false, // *bneqr-stack/%r0/fR*-no-fast-branches
      false, // *bneqr-stack/%r1/fR*-no-fast-branches
      false, // *bneqr-stack/%rR/fR*-no-fast-branches
      false, // *bt-stack/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%r0/%r0/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%r0/%r1/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%r0/%rR/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%r1/%r0/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%r1/%r1/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%r1/%rR/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%rR/%r0/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%rR/%r1/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%rR/%rR/fR*-no-fast-branches
      false, // *pushr-bger-stack/%r0/%r0/fR*-no-fast-branches
      false, // *pushr-bger-stack/%r0/%r1/fR*-no-fast-branches
      false, // *pushr-bger-stack/%r0/%rR/fR*-no-fast-branches
      false, // *pushr-bger-stack/%r1/%r0/fR*-no-fast-branches
      false, // *pushr-bger-stack/%r1/%r1/fR*-no-fast-branches
      false, // *pushr-bger-stack/%r1/%rR/fR*-no-fast-branches
      false, // *pushr-bger-stack/%rR/%r0/fR*-no-fast-branches
      false, // *pushr-bger-stack/%rR/%r1/fR*-no-fast-branches
      false // *pushr-bger-stack/%rR/%rR/fR*-no-fast-branches
    };

// FIXME: this is not currently accessed, and in fact may be useless.
const bool
structuredvm_specialized_instruction_callers [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO]
  = {
      false, // !INVALID
      false, // !BEGINBASICBLOCK
      false, // !EXITVM
      false, // !DATALOCATIONS
      false, // !NOP
      false, // !UNREACHABLE0
      false, // !UNREACHABLE1
      false, // !UNREACHABLE2
      false, // b/fR
      false, // be/%r0/%r0/fR
      false, // be/%r0/%r1/fR
      false, // be/%r0/%rR/fR
      false, // be/%r0/n0/fR
      false, // be/%r0/nR/fR
      false, // be/%r1/%r0/fR
      false, // be/%r1/%r1/fR
      false, // be/%r1/%rR/fR
      false, // be/%r1/n0/fR
      false, // be/%r1/nR/fR
      false, // be/%rR/%r0/fR
      false, // be/%rR/%r1/fR
      false, // be/%rR/%rR/fR
      false, // be/%rR/n0/fR
      false, // be/%rR/nR/fR
      false, // be/n0/%r0/fR
      false, // be/n0/%r1/fR
      false, // be/n0/%rR/fR
      false, // be/n0/n0/fR
      false, // be/n0/nR/fR
      false, // be/nR/%r0/fR
      false, // be/nR/%r1/fR
      false, // be/nR/%rR/fR
      false, // be/nR/n0/fR
      false, // be/nR/nR/fR
      false, // beqi-stack/n-1/fR
      false, // beqi-stack/n0/fR
      false, // beqi-stack/n1/fR
      false, // beqi-stack/n2/fR
      false, // beqi-stack/nR/fR
      false, // beqr-stack/%r0/fR
      false, // beqr-stack/%r1/fR
      false, // beqr-stack/%rR/fR
      false, // bf-stack/fR
      false, // bg/%r0/%r0/fR
      false, // bg/%r0/%r1/fR
      false, // bg/%r0/%rR/fR
      false, // bg/%r0/n0/fR
      false, // bg/%r0/nR/fR
      false, // bg/%r1/%r0/fR
      false, // bg/%r1/%r1/fR
      false, // bg/%r1/%rR/fR
      false, // bg/%r1/n0/fR
      false, // bg/%r1/nR/fR
      false, // bg/%rR/%r0/fR
      false, // bg/%rR/%r1/fR
      false, // bg/%rR/%rR/fR
      false, // bg/%rR/n0/fR
      false, // bg/%rR/nR/fR
      false, // bg/n0/%r0/fR
      false, // bg/n0/%r1/fR
      false, // bg/n0/%rR/fR
      false, // bg/n0/n0/fR
      false, // bg/n0/nR/fR
      false, // bg/nR/%r0/fR
      false, // bg/nR/%r1/fR
      false, // bg/nR/%rR/fR
      false, // bg/nR/n0/fR
      false, // bg/nR/nR/fR
      false, // bge/%r0/%r0/fR
      false, // bge/%r0/%r1/fR
      false, // bge/%r0/%rR/fR
      false, // bge/%r0/n0/fR
      false, // bge/%r0/nR/fR
      false, // bge/%r1/%r0/fR
      false, // bge/%r1/%r1/fR
      false, // bge/%r1/%rR/fR
      false, // bge/%r1/n0/fR
      false, // bge/%r1/nR/fR
      false, // bge/%rR/%r0/fR
      false, // bge/%rR/%r1/fR
      false, // bge/%rR/%rR/fR
      false, // bge/%rR/n0/fR
      false, // bge/%rR/nR/fR
      false, // bge/n0/%r0/fR
      false, // bge/n0/%r1/fR
      false, // bge/n0/%rR/fR
      false, // bge/n0/n0/fR
      false, // bge/n0/nR/fR
      false, // bge/nR/%r0/fR
      false, // bge/nR/%r1/fR
      false, // bge/nR/%rR/fR
      false, // bge/nR/n0/fR
      false, // bge/nR/nR/fR
      false, // bger-stack/%r0/fR
      false, // bger-stack/%r1/fR
      false, // bger-stack/%rR/fR
      false, // bl/%r0/%r0/fR
      false, // bl/%r0/%r1/fR
      false, // bl/%r0/%rR/fR
      false, // bl/%r0/n0/fR
      false, // bl/%r0/nR/fR
      false, // bl/%r1/%r0/fR
      false, // bl/%r1/%r1/fR
      false, // bl/%r1/%rR/fR
      false, // bl/%r1/n0/fR
      false, // bl/%r1/nR/fR
      false, // bl/%rR/%r0/fR
      false, // bl/%rR/%r1/fR
      false, // bl/%rR/%rR/fR
      false, // bl/%rR/n0/fR
      false, // bl/%rR/nR/fR
      false, // bl/n0/%r0/fR
      false, // bl/n0/%r1/fR
      false, // bl/n0/%rR/fR
      false, // bl/n0/n0/fR
      false, // bl/n0/nR/fR
      false, // bl/nR/%r0/fR
      false, // bl/nR/%r1/fR
      false, // bl/nR/%rR/fR
      false, // bl/nR/n0/fR
      false, // bl/nR/nR/fR
      false, // ble/%r0/%r0/fR
      false, // ble/%r0/%r1/fR
      false, // ble/%r0/%rR/fR
      false, // ble/%r0/n0/fR
      false, // ble/%r0/nR/fR
      false, // ble/%r1/%r0/fR
      false, // ble/%r1/%r1/fR
      false, // ble/%r1/%rR/fR
      false, // ble/%r1/n0/fR
      false, // ble/%r1/nR/fR
      false, // ble/%rR/%r0/fR
      false, // ble/%rR/%r1/fR
      false, // ble/%rR/%rR/fR
      false, // ble/%rR/n0/fR
      false, // ble/%rR/nR/fR
      false, // ble/n0/%r0/fR
      false, // ble/n0/%r1/fR
      false, // ble/n0/%rR/fR
      false, // ble/n0/n0/fR
      false, // ble/n0/nR/fR
      false, // ble/nR/%r0/fR
      false, // ble/nR/%r1/fR
      false, // ble/nR/%rR/fR
      false, // ble/nR/n0/fR
      false, // ble/nR/nR/fR
      false, // bne/%r0/%r0/fR
      false, // bne/%r0/%r1/fR
      false, // bne/%r0/%rR/fR
      false, // bne/%r0/n0/fR
      false, // bne/%r0/nR/fR
      false, // bne/%r1/%r0/fR
      false, // bne/%r1/%r1/fR
      false, // bne/%r1/%rR/fR
      false, // bne/%r1/n0/fR
      false, // bne/%r1/nR/fR
      false, // bne/%rR/%r0/fR
      false, // bne/%rR/%r1/fR
      false, // bne/%rR/%rR/fR
      false, // bne/%rR/n0/fR
      false, // bne/%rR/nR/fR
      false, // bne/n0/%r0/fR
      false, // bne/n0/%r1/fR
      false, // bne/n0/%rR/fR
      false, // bne/n0/n0/fR
      false, // bne/n0/nR/fR
      false, // bne/nR/%r0/fR
      false, // bne/nR/%r1/fR
      false, // bne/nR/%rR/fR
      false, // bne/nR/n0/fR
      false, // bne/nR/nR/fR
      false, // bneqi-stack/n-1/fR
      false, // bneqi-stack/n0/fR
      false, // bneqi-stack/n1/fR
      false, // bneqi-stack/n2/fR
      false, // bneqi-stack/nR/fR
      false, // bneqr-stack/%r0/fR
      false, // bneqr-stack/%r1/fR
      false, // bneqr-stack/%rR/fR
      false, // bt-stack/fR
      false, // copy-to-r-stack/%r0
      false, // copy-to-r-stack/%r1
      false, // copy-to-r-stack/%rR
      false, // different-stack
      false, // differenti-stack/n0
      false, // differenti-stack/n1
      false, // differenti-stack/n2
      false, // differenti-stack/nR
      false, // divided/%r0/%r0/%r0
      false, // divided/%r0/%r0/%r1
      false, // divided/%r0/%r0/%rR
      false, // divided/%r0/%r1/%r0
      false, // divided/%r0/%r1/%r1
      false, // divided/%r0/%r1/%rR
      false, // divided/%r0/%rR/%r0
      false, // divided/%r0/%rR/%r1
      false, // divided/%r0/%rR/%rR
      false, // divided/%r0/n2/%r0
      false, // divided/%r0/n2/%r1
      false, // divided/%r0/n2/%rR
      false, // divided/%r0/nR/%r0
      false, // divided/%r0/nR/%r1
      false, // divided/%r0/nR/%rR
      false, // divided/%r1/%r0/%r0
      false, // divided/%r1/%r0/%r1
      false, // divided/%r1/%r0/%rR
      false, // divided/%r1/%r1/%r0
      false, // divided/%r1/%r1/%r1
      false, // divided/%r1/%r1/%rR
      false, // divided/%r1/%rR/%r0
      false, // divided/%r1/%rR/%r1
      false, // divided/%r1/%rR/%rR
      false, // divided/%r1/n2/%r0
      false, // divided/%r1/n2/%r1
      false, // divided/%r1/n2/%rR
      false, // divided/%r1/nR/%r0
      false, // divided/%r1/nR/%r1
      false, // divided/%r1/nR/%rR
      false, // divided/%rR/%r0/%r0
      false, // divided/%rR/%r0/%r1
      false, // divided/%rR/%r0/%rR
      false, // divided/%rR/%r1/%r0
      false, // divided/%rR/%r1/%r1
      false, // divided/%rR/%r1/%rR
      false, // divided/%rR/%rR/%r0
      false, // divided/%rR/%rR/%r1
      false, // divided/%rR/%rR/%rR
      false, // divided/%rR/n2/%r0
      false, // divided/%rR/n2/%r1
      false, // divided/%rR/n2/%rR
      false, // divided/%rR/nR/%r0
      false, // divided/%rR/nR/%r1
      false, // divided/%rR/nR/%rR
      false, // divided/nR/%r0/%r0
      false, // divided/nR/%r0/%r1
      false, // divided/nR/%r0/%rR
      false, // divided/nR/%r1/%r0
      false, // divided/nR/%r1/%r1
      false, // divided/nR/%r1/%rR
      false, // divided/nR/%rR/%r0
      false, // divided/nR/%rR/%r1
      false, // divided/nR/%rR/%rR
      false, // divided/nR/n2/%r0
      false, // divided/nR/n2/%r1
      false, // divided/nR/n2/%rR
      false, // divided/nR/nR/%r0
      false, // divided/nR/nR/%r1
      false, // divided/nR/nR/%rR
      false, // divided-stack
      false, // drop-stack
      false, // dup-stack
      false, // equal-stack
      false, // equali-stack/n0
      false, // equali-stack/n1
      false, // equali-stack/n2
      false, // equali-stack/nR
      false, // exitvm
      false, // greater-stack
      false, // greaterorequal-stack
      false, // input/%r0/retR
      false, // input/%r1/retR
      false, // input/%rR/retR
      false, // input-stack/retR
      false, // isnonzero-stack
      false, // less-stack
      false, // lessorequal-stack
      false, // logicaland-stack
      false, // logicalnot-stack
      false, // logicalor-stack
      false, // minus/%r0/%r0/%r0
      false, // minus/%r0/%r0/%r1
      false, // minus/%r0/%r0/%rR
      false, // minus/%r0/%r1/%r0
      false, // minus/%r0/%r1/%r1
      false, // minus/%r0/%r1/%rR
      false, // minus/%r0/%rR/%r0
      false, // minus/%r0/%rR/%r1
      false, // minus/%r0/%rR/%rR
      false, // minus/%r0/n1/%r0
      false, // minus/%r0/n1/%r1
      false, // minus/%r0/n1/%rR
      false, // minus/%r0/n2/%r0
      false, // minus/%r0/n2/%r1
      false, // minus/%r0/n2/%rR
      false, // minus/%r0/nR/%r0
      false, // minus/%r0/nR/%r1
      false, // minus/%r0/nR/%rR
      false, // minus/%r1/%r0/%r0
      false, // minus/%r1/%r0/%r1
      false, // minus/%r1/%r0/%rR
      false, // minus/%r1/%r1/%r0
      false, // minus/%r1/%r1/%r1
      false, // minus/%r1/%r1/%rR
      false, // minus/%r1/%rR/%r0
      false, // minus/%r1/%rR/%r1
      false, // minus/%r1/%rR/%rR
      false, // minus/%r1/n1/%r0
      false, // minus/%r1/n1/%r1
      false, // minus/%r1/n1/%rR
      false, // minus/%r1/n2/%r0
      false, // minus/%r1/n2/%r1
      false, // minus/%r1/n2/%rR
      false, // minus/%r1/nR/%r0
      false, // minus/%r1/nR/%r1
      false, // minus/%r1/nR/%rR
      false, // minus/%rR/%r0/%r0
      false, // minus/%rR/%r0/%r1
      false, // minus/%rR/%r0/%rR
      false, // minus/%rR/%r1/%r0
      false, // minus/%rR/%r1/%r1
      false, // minus/%rR/%r1/%rR
      false, // minus/%rR/%rR/%r0
      false, // minus/%rR/%rR/%r1
      false, // minus/%rR/%rR/%rR
      false, // minus/%rR/n1/%r0
      false, // minus/%rR/n1/%r1
      false, // minus/%rR/n1/%rR
      false, // minus/%rR/n2/%r0
      false, // minus/%rR/n2/%r1
      false, // minus/%rR/n2/%rR
      false, // minus/%rR/nR/%r0
      false, // minus/%rR/nR/%r1
      false, // minus/%rR/nR/%rR
      false, // minus/nR/%r0/%r0
      false, // minus/nR/%r0/%r1
      false, // minus/nR/%r0/%rR
      false, // minus/nR/%r1/%r0
      false, // minus/nR/%r1/%r1
      false, // minus/nR/%r1/%rR
      false, // minus/nR/%rR/%r0
      false, // minus/nR/%rR/%r1
      false, // minus/nR/%rR/%rR
      false, // minus/nR/n1/%r0
      false, // minus/nR/n1/%r1
      false, // minus/nR/n1/%rR
      false, // minus/nR/n2/%r0
      false, // minus/nR/n2/%r1
      false, // minus/nR/n2/%rR
      false, // minus/nR/nR/%r0
      false, // minus/nR/nR/%r1
      false, // minus/nR/nR/%rR
      false, // minus-stack
      false, // minusi-stack/n1
      false, // minusi-stack/n2
      false, // minusi-stack/nR
      false, // minusr-stack/%r0
      false, // minusr-stack/%r1
      false, // minusr-stack/%rR
      false, // mov/%r0/%r0
      false, // mov/%r0/%r1
      false, // mov/%r0/%rR
      false, // mov/%r1/%r0
      false, // mov/%r1/%r1
      false, // mov/%r1/%rR
      false, // mov/%rR/%r0
      false, // mov/%rR/%r1
      false, // mov/%rR/%rR
      false, // mov/n0/%r0
      false, // mov/n0/%r1
      false, // mov/n0/%rR
      false, // mov/n1/%r0
      false, // mov/n1/%r1
      false, // mov/n1/%rR
      false, // mov/n-1/%r0
      false, // mov/n-1/%r1
      false, // mov/n-1/%rR
      false, // mov/n2/%r0
      false, // mov/n2/%r1
      false, // mov/n2/%rR
      false, // mov/nR/%r0
      false, // mov/nR/%r1
      false, // mov/nR/%rR
      false, // plus/%r0/%r0/%r0
      false, // plus/%r0/%r0/%r1
      false, // plus/%r0/%r0/%rR
      false, // plus/%r0/%r1/%r0
      false, // plus/%r0/%r1/%r1
      false, // plus/%r0/%r1/%rR
      false, // plus/%r0/%rR/%r0
      false, // plus/%r0/%rR/%r1
      false, // plus/%r0/%rR/%rR
      false, // plus/%r0/n1/%r0
      false, // plus/%r0/n1/%r1
      false, // plus/%r0/n1/%rR
      false, // plus/%r0/n2/%r0
      false, // plus/%r0/n2/%r1
      false, // plus/%r0/n2/%rR
      false, // plus/%r0/nR/%r0
      false, // plus/%r0/nR/%r1
      false, // plus/%r0/nR/%rR
      false, // plus/%r1/%r0/%r0
      false, // plus/%r1/%r0/%r1
      false, // plus/%r1/%r0/%rR
      false, // plus/%r1/%r1/%r0
      false, // plus/%r1/%r1/%r1
      false, // plus/%r1/%r1/%rR
      false, // plus/%r1/%rR/%r0
      false, // plus/%r1/%rR/%r1
      false, // plus/%r1/%rR/%rR
      false, // plus/%r1/n1/%r0
      false, // plus/%r1/n1/%r1
      false, // plus/%r1/n1/%rR
      false, // plus/%r1/n2/%r0
      false, // plus/%r1/n2/%r1
      false, // plus/%r1/n2/%rR
      false, // plus/%r1/nR/%r0
      false, // plus/%r1/nR/%r1
      false, // plus/%r1/nR/%rR
      false, // plus/%rR/%r0/%r0
      false, // plus/%rR/%r0/%r1
      false, // plus/%rR/%r0/%rR
      false, // plus/%rR/%r1/%r0
      false, // plus/%rR/%r1/%r1
      false, // plus/%rR/%r1/%rR
      false, // plus/%rR/%rR/%r0
      false, // plus/%rR/%rR/%r1
      false, // plus/%rR/%rR/%rR
      false, // plus/%rR/n1/%r0
      false, // plus/%rR/n1/%r1
      false, // plus/%rR/n1/%rR
      false, // plus/%rR/n2/%r0
      false, // plus/%rR/n2/%r1
      false, // plus/%rR/n2/%rR
      false, // plus/%rR/nR/%r0
      false, // plus/%rR/nR/%r1
      false, // plus/%rR/nR/%rR
      false, // plus/nR/%r0/%r0
      false, // plus/nR/%r0/%r1
      false, // plus/nR/%r0/%rR
      false, // plus/nR/%r1/%r0
      false, // plus/nR/%r1/%r1
      false, // plus/nR/%r1/%rR
      false, // plus/nR/%rR/%r0
      false, // plus/nR/%rR/%r1
      false, // plus/nR/%rR/%rR
      false, // plus/nR/n1/%r0
      false, // plus/nR/n1/%r1
      false, // plus/nR/n1/%rR
      false, // plus/nR/n2/%r0
      false, // plus/nR/n2/%r1
      false, // plus/nR/n2/%rR
      false, // plus/nR/nR/%r0
      false, // plus/nR/nR/%r1
      false, // plus/nR/nR/%rR
      false, // plus-stack
      false, // plusi-stack/n-1
      false, // plusi-stack/n1
      false, // plusi-stack/n2
      false, // plusi-stack/nR
      false, // pop-stack/%r0
      false, // pop-stack/%r1
      false, // pop-stack/%rR
      false, // print/%r0/retR
      false, // print/%r1/retR
      false, // print/%rR/retR
      false, // print/nR/retR
      false, // print-stack/retR
      false, // push-stack/%r0
      false, // push-stack/%r1
      false, // push-stack/%rR
      false, // push-stack/n0
      false, // push-stack/n1
      false, // push-stack/n-1
      false, // push-stack/n2
      false, // push-stack/nR
      false, // push-stack/lR
      false, // pushr-beqr-stack/%r0/%r0/fR
      false, // pushr-beqr-stack/%r0/%r1/fR
      false, // pushr-beqr-stack/%r0/%rR/fR
      false, // pushr-beqr-stack/%r1/%r0/fR
      false, // pushr-beqr-stack/%r1/%r1/fR
      false, // pushr-beqr-stack/%r1/%rR/fR
      false, // pushr-beqr-stack/%rR/%r0/fR
      false, // pushr-beqr-stack/%rR/%r1/fR
      false, // pushr-beqr-stack/%rR/%rR/fR
      false, // pushr-bger-stack/%r0/%r0/fR
      false, // pushr-bger-stack/%r0/%r1/fR
      false, // pushr-bger-stack/%r0/%rR/fR
      false, // pushr-bger-stack/%r1/%r0/fR
      false, // pushr-bger-stack/%r1/%r1/fR
      false, // pushr-bger-stack/%r1/%rR/fR
      false, // pushr-bger-stack/%rR/%r0/fR
      false, // pushr-bger-stack/%rR/%r1/fR
      false, // pushr-bger-stack/%rR/%rR/fR
      false, // pushr-minusr-pop-stack/%r0/%r0/%r0
      false, // pushr-minusr-pop-stack/%r0/%r0/%r1
      false, // pushr-minusr-pop-stack/%r0/%r0/%rR
      false, // pushr-minusr-pop-stack/%r0/%r1/%r0
      false, // pushr-minusr-pop-stack/%r0/%r1/%r1
      false, // pushr-minusr-pop-stack/%r0/%r1/%rR
      false, // pushr-minusr-pop-stack/%r0/%rR/%r0
      false, // pushr-minusr-pop-stack/%r0/%rR/%r1
      false, // pushr-minusr-pop-stack/%r0/%rR/%rR
      false, // pushr-minusr-pop-stack/%r1/%r0/%r0
      false, // pushr-minusr-pop-stack/%r1/%r0/%r1
      false, // pushr-minusr-pop-stack/%r1/%r0/%rR
      false, // pushr-minusr-pop-stack/%r1/%r1/%r0
      false, // pushr-minusr-pop-stack/%r1/%r1/%r1
      false, // pushr-minusr-pop-stack/%r1/%r1/%rR
      false, // pushr-minusr-pop-stack/%r1/%rR/%r0
      false, // pushr-minusr-pop-stack/%r1/%rR/%r1
      false, // pushr-minusr-pop-stack/%r1/%rR/%rR
      false, // pushr-minusr-pop-stack/%rR/%r0/%r0
      false, // pushr-minusr-pop-stack/%rR/%r0/%r1
      false, // pushr-minusr-pop-stack/%rR/%r0/%rR
      false, // pushr-minusr-pop-stack/%rR/%r1/%r0
      false, // pushr-minusr-pop-stack/%rR/%r1/%r1
      false, // pushr-minusr-pop-stack/%rR/%r1/%rR
      false, // pushr-minusr-pop-stack/%rR/%rR/%r0
      false, // pushr-minusr-pop-stack/%rR/%rR/%r1
      false, // pushr-minusr-pop-stack/%rR/%rR/%rR
      false, // remainder/%r0/%r0/%r0
      false, // remainder/%r0/%r0/%r1
      false, // remainder/%r0/%r0/%rR
      false, // remainder/%r0/%r1/%r0
      false, // remainder/%r0/%r1/%r1
      false, // remainder/%r0/%r1/%rR
      false, // remainder/%r0/%rR/%r0
      false, // remainder/%r0/%rR/%r1
      false, // remainder/%r0/%rR/%rR
      false, // remainder/%r0/n2/%r0
      false, // remainder/%r0/n2/%r1
      false, // remainder/%r0/n2/%rR
      false, // remainder/%r0/nR/%r0
      false, // remainder/%r0/nR/%r1
      false, // remainder/%r0/nR/%rR
      false, // remainder/%r1/%r0/%r0
      false, // remainder/%r1/%r0/%r1
      false, // remainder/%r1/%r0/%rR
      false, // remainder/%r1/%r1/%r0
      false, // remainder/%r1/%r1/%r1
      false, // remainder/%r1/%r1/%rR
      false, // remainder/%r1/%rR/%r0
      false, // remainder/%r1/%rR/%r1
      false, // remainder/%r1/%rR/%rR
      false, // remainder/%r1/n2/%r0
      false, // remainder/%r1/n2/%r1
      false, // remainder/%r1/n2/%rR
      false, // remainder/%r1/nR/%r0
      false, // remainder/%r1/nR/%r1
      false, // remainder/%r1/nR/%rR
      false, // remainder/%rR/%r0/%r0
      false, // remainder/%rR/%r0/%r1
      false, // remainder/%rR/%r0/%rR
      false, // remainder/%rR/%r1/%r0
      false, // remainder/%rR/%r1/%r1
      false, // remainder/%rR/%r1/%rR
      false, // remainder/%rR/%rR/%r0
      false, // remainder/%rR/%rR/%r1
      false, // remainder/%rR/%rR/%rR
      false, // remainder/%rR/n2/%r0
      false, // remainder/%rR/n2/%r1
      false, // remainder/%rR/n2/%rR
      false, // remainder/%rR/nR/%r0
      false, // remainder/%rR/nR/%r1
      false, // remainder/%rR/nR/%rR
      false, // remainder/nR/%r0/%r0
      false, // remainder/nR/%r0/%r1
      false, // remainder/nR/%r0/%rR
      false, // remainder/nR/%r1/%r0
      false, // remainder/nR/%r1/%r1
      false, // remainder/nR/%r1/%rR
      false, // remainder/nR/%rR/%r0
      false, // remainder/nR/%rR/%r1
      false, // remainder/nR/%rR/%rR
      false, // remainder/nR/n2/%r0
      false, // remainder/nR/n2/%r1
      false, // remainder/nR/n2/%rR
      false, // remainder/nR/nR/%r0
      false, // remainder/nR/nR/%r1
      false, // remainder/nR/nR/%rR
      false, // remainder-stack
      false, // times/%r0/%r0/%r0
      false, // times/%r0/%r0/%r1
      false, // times/%r0/%r0/%rR
      false, // times/%r0/%r1/%r0
      false, // times/%r0/%r1/%r1
      false, // times/%r0/%r1/%rR
      false, // times/%r0/%rR/%r0
      false, // times/%r0/%rR/%r1
      false, // times/%r0/%rR/%rR
      false, // times/%r0/n2/%r0
      false, // times/%r0/n2/%r1
      false, // times/%r0/n2/%rR
      false, // times/%r0/nR/%r0
      false, // times/%r0/nR/%r1
      false, // times/%r0/nR/%rR
      false, // times/%r1/%r0/%r0
      false, // times/%r1/%r0/%r1
      false, // times/%r1/%r0/%rR
      false, // times/%r1/%r1/%r0
      false, // times/%r1/%r1/%r1
      false, // times/%r1/%r1/%rR
      false, // times/%r1/%rR/%r0
      false, // times/%r1/%rR/%r1
      false, // times/%r1/%rR/%rR
      false, // times/%r1/n2/%r0
      false, // times/%r1/n2/%r1
      false, // times/%r1/n2/%rR
      false, // times/%r1/nR/%r0
      false, // times/%r1/nR/%r1
      false, // times/%r1/nR/%rR
      false, // times/%rR/%r0/%r0
      false, // times/%rR/%r0/%r1
      false, // times/%rR/%r0/%rR
      false, // times/%rR/%r1/%r0
      false, // times/%rR/%r1/%r1
      false, // times/%rR/%r1/%rR
      false, // times/%rR/%rR/%r0
      false, // times/%rR/%rR/%r1
      false, // times/%rR/%rR/%rR
      false, // times/%rR/n2/%r0
      false, // times/%rR/n2/%r1
      false, // times/%rR/n2/%rR
      false, // times/%rR/nR/%r0
      false, // times/%rR/nR/%r1
      false, // times/%rR/nR/%rR
      false, // times/nR/%r0/%r0
      false, // times/nR/%r0/%r1
      false, // times/nR/%r0/%rR
      false, // times/nR/%r1/%r0
      false, // times/nR/%r1/%r1
      false, // times/nR/%r1/%rR
      false, // times/nR/%rR/%r0
      false, // times/nR/%rR/%r1
      false, // times/nR/%rR/%rR
      false, // times/nR/n2/%r0
      false, // times/nR/n2/%r1
      false, // times/nR/n2/%rR
      false, // times/nR/nR/%r0
      false, // times/nR/nR/%r1
      false, // times/nR/nR/%rR
      false, // times-stack
      false, // uminus/%r0/%r0
      false, // uminus/%r0/%r1
      false, // uminus/%r0/%rR
      false, // uminus/%r1/%r0
      false, // uminus/%r1/%r1
      false, // uminus/%r1/%rR
      false, // uminus/%rR/%r0
      false, // uminus/%rR/%r1
      false, // uminus/%rR/%rR
      false, // uminus/nR/%r0
      false, // uminus/nR/%r1
      false, // uminus/nR/%rR
      false, // uminus-stack
      false, // unreachable
      false, // *b/fR*-no-fast-branches
      false, // *be/%r0/%r0/fR*-no-fast-branches
      false, // *be/%r0/%r1/fR*-no-fast-branches
      false, // *be/%r0/%rR/fR*-no-fast-branches
      false, // *be/%r0/n0/fR*-no-fast-branches
      false, // *be/%r0/nR/fR*-no-fast-branches
      false, // *be/%r1/%r0/fR*-no-fast-branches
      false, // *be/%r1/%r1/fR*-no-fast-branches
      false, // *be/%r1/%rR/fR*-no-fast-branches
      false, // *be/%r1/n0/fR*-no-fast-branches
      false, // *be/%r1/nR/fR*-no-fast-branches
      false, // *be/%rR/%r0/fR*-no-fast-branches
      false, // *be/%rR/%r1/fR*-no-fast-branches
      false, // *be/%rR/%rR/fR*-no-fast-branches
      false, // *be/%rR/n0/fR*-no-fast-branches
      false, // *be/%rR/nR/fR*-no-fast-branches
      false, // *be/n0/%r0/fR*-no-fast-branches
      false, // *be/n0/%r1/fR*-no-fast-branches
      false, // *be/n0/%rR/fR*-no-fast-branches
      false, // *be/n0/n0/fR*-no-fast-branches
      false, // *be/n0/nR/fR*-no-fast-branches
      false, // *be/nR/%r0/fR*-no-fast-branches
      false, // *be/nR/%r1/fR*-no-fast-branches
      false, // *be/nR/%rR/fR*-no-fast-branches
      false, // *be/nR/n0/fR*-no-fast-branches
      false, // *be/nR/nR/fR*-no-fast-branches
      false, // *beqi-stack/n-1/fR*-no-fast-branches
      false, // *beqi-stack/n0/fR*-no-fast-branches
      false, // *beqi-stack/n1/fR*-no-fast-branches
      false, // *beqi-stack/n2/fR*-no-fast-branches
      false, // *beqi-stack/nR/fR*-no-fast-branches
      false, // *beqr-stack/%r0/fR*-no-fast-branches
      false, // *beqr-stack/%r1/fR*-no-fast-branches
      false, // *beqr-stack/%rR/fR*-no-fast-branches
      false, // *bf-stack/fR*-no-fast-branches
      false, // *bg/%r0/%r0/fR*-no-fast-branches
      false, // *bg/%r0/%r1/fR*-no-fast-branches
      false, // *bg/%r0/%rR/fR*-no-fast-branches
      false, // *bg/%r0/n0/fR*-no-fast-branches
      false, // *bg/%r0/nR/fR*-no-fast-branches
      false, // *bg/%r1/%r0/fR*-no-fast-branches
      false, // *bg/%r1/%r1/fR*-no-fast-branches
      false, // *bg/%r1/%rR/fR*-no-fast-branches
      false, // *bg/%r1/n0/fR*-no-fast-branches
      false, // *bg/%r1/nR/fR*-no-fast-branches
      false, // *bg/%rR/%r0/fR*-no-fast-branches
      false, // *bg/%rR/%r1/fR*-no-fast-branches
      false, // *bg/%rR/%rR/fR*-no-fast-branches
      false, // *bg/%rR/n0/fR*-no-fast-branches
      false, // *bg/%rR/nR/fR*-no-fast-branches
      false, // *bg/n0/%r0/fR*-no-fast-branches
      false, // *bg/n0/%r1/fR*-no-fast-branches
      false, // *bg/n0/%rR/fR*-no-fast-branches
      false, // *bg/n0/n0/fR*-no-fast-branches
      false, // *bg/n0/nR/fR*-no-fast-branches
      false, // *bg/nR/%r0/fR*-no-fast-branches
      false, // *bg/nR/%r1/fR*-no-fast-branches
      false, // *bg/nR/%rR/fR*-no-fast-branches
      false, // *bg/nR/n0/fR*-no-fast-branches
      false, // *bg/nR/nR/fR*-no-fast-branches
      false, // *bge/%r0/%r0/fR*-no-fast-branches
      false, // *bge/%r0/%r1/fR*-no-fast-branches
      false, // *bge/%r0/%rR/fR*-no-fast-branches
      false, // *bge/%r0/n0/fR*-no-fast-branches
      false, // *bge/%r0/nR/fR*-no-fast-branches
      false, // *bge/%r1/%r0/fR*-no-fast-branches
      false, // *bge/%r1/%r1/fR*-no-fast-branches
      false, // *bge/%r1/%rR/fR*-no-fast-branches
      false, // *bge/%r1/n0/fR*-no-fast-branches
      false, // *bge/%r1/nR/fR*-no-fast-branches
      false, // *bge/%rR/%r0/fR*-no-fast-branches
      false, // *bge/%rR/%r1/fR*-no-fast-branches
      false, // *bge/%rR/%rR/fR*-no-fast-branches
      false, // *bge/%rR/n0/fR*-no-fast-branches
      false, // *bge/%rR/nR/fR*-no-fast-branches
      false, // *bge/n0/%r0/fR*-no-fast-branches
      false, // *bge/n0/%r1/fR*-no-fast-branches
      false, // *bge/n0/%rR/fR*-no-fast-branches
      false, // *bge/n0/n0/fR*-no-fast-branches
      false, // *bge/n0/nR/fR*-no-fast-branches
      false, // *bge/nR/%r0/fR*-no-fast-branches
      false, // *bge/nR/%r1/fR*-no-fast-branches
      false, // *bge/nR/%rR/fR*-no-fast-branches
      false, // *bge/nR/n0/fR*-no-fast-branches
      false, // *bge/nR/nR/fR*-no-fast-branches
      false, // *bger-stack/%r0/fR*-no-fast-branches
      false, // *bger-stack/%r1/fR*-no-fast-branches
      false, // *bger-stack/%rR/fR*-no-fast-branches
      false, // *bl/%r0/%r0/fR*-no-fast-branches
      false, // *bl/%r0/%r1/fR*-no-fast-branches
      false, // *bl/%r0/%rR/fR*-no-fast-branches
      false, // *bl/%r0/n0/fR*-no-fast-branches
      false, // *bl/%r0/nR/fR*-no-fast-branches
      false, // *bl/%r1/%r0/fR*-no-fast-branches
      false, // *bl/%r1/%r1/fR*-no-fast-branches
      false, // *bl/%r1/%rR/fR*-no-fast-branches
      false, // *bl/%r1/n0/fR*-no-fast-branches
      false, // *bl/%r1/nR/fR*-no-fast-branches
      false, // *bl/%rR/%r0/fR*-no-fast-branches
      false, // *bl/%rR/%r1/fR*-no-fast-branches
      false, // *bl/%rR/%rR/fR*-no-fast-branches
      false, // *bl/%rR/n0/fR*-no-fast-branches
      false, // *bl/%rR/nR/fR*-no-fast-branches
      false, // *bl/n0/%r0/fR*-no-fast-branches
      false, // *bl/n0/%r1/fR*-no-fast-branches
      false, // *bl/n0/%rR/fR*-no-fast-branches
      false, // *bl/n0/n0/fR*-no-fast-branches
      false, // *bl/n0/nR/fR*-no-fast-branches
      false, // *bl/nR/%r0/fR*-no-fast-branches
      false, // *bl/nR/%r1/fR*-no-fast-branches
      false, // *bl/nR/%rR/fR*-no-fast-branches
      false, // *bl/nR/n0/fR*-no-fast-branches
      false, // *bl/nR/nR/fR*-no-fast-branches
      false, // *ble/%r0/%r0/fR*-no-fast-branches
      false, // *ble/%r0/%r1/fR*-no-fast-branches
      false, // *ble/%r0/%rR/fR*-no-fast-branches
      false, // *ble/%r0/n0/fR*-no-fast-branches
      false, // *ble/%r0/nR/fR*-no-fast-branches
      false, // *ble/%r1/%r0/fR*-no-fast-branches
      false, // *ble/%r1/%r1/fR*-no-fast-branches
      false, // *ble/%r1/%rR/fR*-no-fast-branches
      false, // *ble/%r1/n0/fR*-no-fast-branches
      false, // *ble/%r1/nR/fR*-no-fast-branches
      false, // *ble/%rR/%r0/fR*-no-fast-branches
      false, // *ble/%rR/%r1/fR*-no-fast-branches
      false, // *ble/%rR/%rR/fR*-no-fast-branches
      false, // *ble/%rR/n0/fR*-no-fast-branches
      false, // *ble/%rR/nR/fR*-no-fast-branches
      false, // *ble/n0/%r0/fR*-no-fast-branches
      false, // *ble/n0/%r1/fR*-no-fast-branches
      false, // *ble/n0/%rR/fR*-no-fast-branches
      false, // *ble/n0/n0/fR*-no-fast-branches
      false, // *ble/n0/nR/fR*-no-fast-branches
      false, // *ble/nR/%r0/fR*-no-fast-branches
      false, // *ble/nR/%r1/fR*-no-fast-branches
      false, // *ble/nR/%rR/fR*-no-fast-branches
      false, // *ble/nR/n0/fR*-no-fast-branches
      false, // *ble/nR/nR/fR*-no-fast-branches
      false, // *bne/%r0/%r0/fR*-no-fast-branches
      false, // *bne/%r0/%r1/fR*-no-fast-branches
      false, // *bne/%r0/%rR/fR*-no-fast-branches
      false, // *bne/%r0/n0/fR*-no-fast-branches
      false, // *bne/%r0/nR/fR*-no-fast-branches
      false, // *bne/%r1/%r0/fR*-no-fast-branches
      false, // *bne/%r1/%r1/fR*-no-fast-branches
      false, // *bne/%r1/%rR/fR*-no-fast-branches
      false, // *bne/%r1/n0/fR*-no-fast-branches
      false, // *bne/%r1/nR/fR*-no-fast-branches
      false, // *bne/%rR/%r0/fR*-no-fast-branches
      false, // *bne/%rR/%r1/fR*-no-fast-branches
      false, // *bne/%rR/%rR/fR*-no-fast-branches
      false, // *bne/%rR/n0/fR*-no-fast-branches
      false, // *bne/%rR/nR/fR*-no-fast-branches
      false, // *bne/n0/%r0/fR*-no-fast-branches
      false, // *bne/n0/%r1/fR*-no-fast-branches
      false, // *bne/n0/%rR/fR*-no-fast-branches
      false, // *bne/n0/n0/fR*-no-fast-branches
      false, // *bne/n0/nR/fR*-no-fast-branches
      false, // *bne/nR/%r0/fR*-no-fast-branches
      false, // *bne/nR/%r1/fR*-no-fast-branches
      false, // *bne/nR/%rR/fR*-no-fast-branches
      false, // *bne/nR/n0/fR*-no-fast-branches
      false, // *bne/nR/nR/fR*-no-fast-branches
      false, // *bneqi-stack/n-1/fR*-no-fast-branches
      false, // *bneqi-stack/n0/fR*-no-fast-branches
      false, // *bneqi-stack/n1/fR*-no-fast-branches
      false, // *bneqi-stack/n2/fR*-no-fast-branches
      false, // *bneqi-stack/nR/fR*-no-fast-branches
      false, // *bneqr-stack/%r0/fR*-no-fast-branches
      false, // *bneqr-stack/%r1/fR*-no-fast-branches
      false, // *bneqr-stack/%rR/fR*-no-fast-branches
      false, // *bt-stack/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%r0/%r0/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%r0/%r1/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%r0/%rR/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%r1/%r0/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%r1/%r1/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%r1/%rR/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%rR/%r0/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%rR/%r1/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%rR/%rR/fR*-no-fast-branches
      false, // *pushr-bger-stack/%r0/%r0/fR*-no-fast-branches
      false, // *pushr-bger-stack/%r0/%r1/fR*-no-fast-branches
      false, // *pushr-bger-stack/%r0/%rR/fR*-no-fast-branches
      false, // *pushr-bger-stack/%r1/%r0/fR*-no-fast-branches
      false, // *pushr-bger-stack/%r1/%r1/fR*-no-fast-branches
      false, // *pushr-bger-stack/%r1/%rR/fR*-no-fast-branches
      false, // *pushr-bger-stack/%rR/%r0/fR*-no-fast-branches
      false, // *pushr-bger-stack/%rR/%r1/fR*-no-fast-branches
      false // *pushr-bger-stack/%rR/%rR/fR*-no-fast-branches
    };

// FIXME: this is not currently accessed, and in fact may be useless.
const bool
structuredvm_specialized_instruction_callees [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO]
  = {
      false, // !INVALID
      false, // !BEGINBASICBLOCK
      false, // !EXITVM
      false, // !DATALOCATIONS
      false, // !NOP
      false, // !UNREACHABLE0
      false, // !UNREACHABLE1
      false, // !UNREACHABLE2
      false, // b/fR
      false, // be/%r0/%r0/fR
      false, // be/%r0/%r1/fR
      false, // be/%r0/%rR/fR
      false, // be/%r0/n0/fR
      false, // be/%r0/nR/fR
      false, // be/%r1/%r0/fR
      false, // be/%r1/%r1/fR
      false, // be/%r1/%rR/fR
      false, // be/%r1/n0/fR
      false, // be/%r1/nR/fR
      false, // be/%rR/%r0/fR
      false, // be/%rR/%r1/fR
      false, // be/%rR/%rR/fR
      false, // be/%rR/n0/fR
      false, // be/%rR/nR/fR
      false, // be/n0/%r0/fR
      false, // be/n0/%r1/fR
      false, // be/n0/%rR/fR
      false, // be/n0/n0/fR
      false, // be/n0/nR/fR
      false, // be/nR/%r0/fR
      false, // be/nR/%r1/fR
      false, // be/nR/%rR/fR
      false, // be/nR/n0/fR
      false, // be/nR/nR/fR
      false, // beqi-stack/n-1/fR
      false, // beqi-stack/n0/fR
      false, // beqi-stack/n1/fR
      false, // beqi-stack/n2/fR
      false, // beqi-stack/nR/fR
      false, // beqr-stack/%r0/fR
      false, // beqr-stack/%r1/fR
      false, // beqr-stack/%rR/fR
      false, // bf-stack/fR
      false, // bg/%r0/%r0/fR
      false, // bg/%r0/%r1/fR
      false, // bg/%r0/%rR/fR
      false, // bg/%r0/n0/fR
      false, // bg/%r0/nR/fR
      false, // bg/%r1/%r0/fR
      false, // bg/%r1/%r1/fR
      false, // bg/%r1/%rR/fR
      false, // bg/%r1/n0/fR
      false, // bg/%r1/nR/fR
      false, // bg/%rR/%r0/fR
      false, // bg/%rR/%r1/fR
      false, // bg/%rR/%rR/fR
      false, // bg/%rR/n0/fR
      false, // bg/%rR/nR/fR
      false, // bg/n0/%r0/fR
      false, // bg/n0/%r1/fR
      false, // bg/n0/%rR/fR
      false, // bg/n0/n0/fR
      false, // bg/n0/nR/fR
      false, // bg/nR/%r0/fR
      false, // bg/nR/%r1/fR
      false, // bg/nR/%rR/fR
      false, // bg/nR/n0/fR
      false, // bg/nR/nR/fR
      false, // bge/%r0/%r0/fR
      false, // bge/%r0/%r1/fR
      false, // bge/%r0/%rR/fR
      false, // bge/%r0/n0/fR
      false, // bge/%r0/nR/fR
      false, // bge/%r1/%r0/fR
      false, // bge/%r1/%r1/fR
      false, // bge/%r1/%rR/fR
      false, // bge/%r1/n0/fR
      false, // bge/%r1/nR/fR
      false, // bge/%rR/%r0/fR
      false, // bge/%rR/%r1/fR
      false, // bge/%rR/%rR/fR
      false, // bge/%rR/n0/fR
      false, // bge/%rR/nR/fR
      false, // bge/n0/%r0/fR
      false, // bge/n0/%r1/fR
      false, // bge/n0/%rR/fR
      false, // bge/n0/n0/fR
      false, // bge/n0/nR/fR
      false, // bge/nR/%r0/fR
      false, // bge/nR/%r1/fR
      false, // bge/nR/%rR/fR
      false, // bge/nR/n0/fR
      false, // bge/nR/nR/fR
      false, // bger-stack/%r0/fR
      false, // bger-stack/%r1/fR
      false, // bger-stack/%rR/fR
      false, // bl/%r0/%r0/fR
      false, // bl/%r0/%r1/fR
      false, // bl/%r0/%rR/fR
      false, // bl/%r0/n0/fR
      false, // bl/%r0/nR/fR
      false, // bl/%r1/%r0/fR
      false, // bl/%r1/%r1/fR
      false, // bl/%r1/%rR/fR
      false, // bl/%r1/n0/fR
      false, // bl/%r1/nR/fR
      false, // bl/%rR/%r0/fR
      false, // bl/%rR/%r1/fR
      false, // bl/%rR/%rR/fR
      false, // bl/%rR/n0/fR
      false, // bl/%rR/nR/fR
      false, // bl/n0/%r0/fR
      false, // bl/n0/%r1/fR
      false, // bl/n0/%rR/fR
      false, // bl/n0/n0/fR
      false, // bl/n0/nR/fR
      false, // bl/nR/%r0/fR
      false, // bl/nR/%r1/fR
      false, // bl/nR/%rR/fR
      false, // bl/nR/n0/fR
      false, // bl/nR/nR/fR
      false, // ble/%r0/%r0/fR
      false, // ble/%r0/%r1/fR
      false, // ble/%r0/%rR/fR
      false, // ble/%r0/n0/fR
      false, // ble/%r0/nR/fR
      false, // ble/%r1/%r0/fR
      false, // ble/%r1/%r1/fR
      false, // ble/%r1/%rR/fR
      false, // ble/%r1/n0/fR
      false, // ble/%r1/nR/fR
      false, // ble/%rR/%r0/fR
      false, // ble/%rR/%r1/fR
      false, // ble/%rR/%rR/fR
      false, // ble/%rR/n0/fR
      false, // ble/%rR/nR/fR
      false, // ble/n0/%r0/fR
      false, // ble/n0/%r1/fR
      false, // ble/n0/%rR/fR
      false, // ble/n0/n0/fR
      false, // ble/n0/nR/fR
      false, // ble/nR/%r0/fR
      false, // ble/nR/%r1/fR
      false, // ble/nR/%rR/fR
      false, // ble/nR/n0/fR
      false, // ble/nR/nR/fR
      false, // bne/%r0/%r0/fR
      false, // bne/%r0/%r1/fR
      false, // bne/%r0/%rR/fR
      false, // bne/%r0/n0/fR
      false, // bne/%r0/nR/fR
      false, // bne/%r1/%r0/fR
      false, // bne/%r1/%r1/fR
      false, // bne/%r1/%rR/fR
      false, // bne/%r1/n0/fR
      false, // bne/%r1/nR/fR
      false, // bne/%rR/%r0/fR
      false, // bne/%rR/%r1/fR
      false, // bne/%rR/%rR/fR
      false, // bne/%rR/n0/fR
      false, // bne/%rR/nR/fR
      false, // bne/n0/%r0/fR
      false, // bne/n0/%r1/fR
      false, // bne/n0/%rR/fR
      false, // bne/n0/n0/fR
      false, // bne/n0/nR/fR
      false, // bne/nR/%r0/fR
      false, // bne/nR/%r1/fR
      false, // bne/nR/%rR/fR
      false, // bne/nR/n0/fR
      false, // bne/nR/nR/fR
      false, // bneqi-stack/n-1/fR
      false, // bneqi-stack/n0/fR
      false, // bneqi-stack/n1/fR
      false, // bneqi-stack/n2/fR
      false, // bneqi-stack/nR/fR
      false, // bneqr-stack/%r0/fR
      false, // bneqr-stack/%r1/fR
      false, // bneqr-stack/%rR/fR
      false, // bt-stack/fR
      false, // copy-to-r-stack/%r0
      false, // copy-to-r-stack/%r1
      false, // copy-to-r-stack/%rR
      false, // different-stack
      false, // differenti-stack/n0
      false, // differenti-stack/n1
      false, // differenti-stack/n2
      false, // differenti-stack/nR
      false, // divided/%r0/%r0/%r0
      false, // divided/%r0/%r0/%r1
      false, // divided/%r0/%r0/%rR
      false, // divided/%r0/%r1/%r0
      false, // divided/%r0/%r1/%r1
      false, // divided/%r0/%r1/%rR
      false, // divided/%r0/%rR/%r0
      false, // divided/%r0/%rR/%r1
      false, // divided/%r0/%rR/%rR
      false, // divided/%r0/n2/%r0
      false, // divided/%r0/n2/%r1
      false, // divided/%r0/n2/%rR
      false, // divided/%r0/nR/%r0
      false, // divided/%r0/nR/%r1
      false, // divided/%r0/nR/%rR
      false, // divided/%r1/%r0/%r0
      false, // divided/%r1/%r0/%r1
      false, // divided/%r1/%r0/%rR
      false, // divided/%r1/%r1/%r0
      false, // divided/%r1/%r1/%r1
      false, // divided/%r1/%r1/%rR
      false, // divided/%r1/%rR/%r0
      false, // divided/%r1/%rR/%r1
      false, // divided/%r1/%rR/%rR
      false, // divided/%r1/n2/%r0
      false, // divided/%r1/n2/%r1
      false, // divided/%r1/n2/%rR
      false, // divided/%r1/nR/%r0
      false, // divided/%r1/nR/%r1
      false, // divided/%r1/nR/%rR
      false, // divided/%rR/%r0/%r0
      false, // divided/%rR/%r0/%r1
      false, // divided/%rR/%r0/%rR
      false, // divided/%rR/%r1/%r0
      false, // divided/%rR/%r1/%r1
      false, // divided/%rR/%r1/%rR
      false, // divided/%rR/%rR/%r0
      false, // divided/%rR/%rR/%r1
      false, // divided/%rR/%rR/%rR
      false, // divided/%rR/n2/%r0
      false, // divided/%rR/n2/%r1
      false, // divided/%rR/n2/%rR
      false, // divided/%rR/nR/%r0
      false, // divided/%rR/nR/%r1
      false, // divided/%rR/nR/%rR
      false, // divided/nR/%r0/%r0
      false, // divided/nR/%r0/%r1
      false, // divided/nR/%r0/%rR
      false, // divided/nR/%r1/%r0
      false, // divided/nR/%r1/%r1
      false, // divided/nR/%r1/%rR
      false, // divided/nR/%rR/%r0
      false, // divided/nR/%rR/%r1
      false, // divided/nR/%rR/%rR
      false, // divided/nR/n2/%r0
      false, // divided/nR/n2/%r1
      false, // divided/nR/n2/%rR
      false, // divided/nR/nR/%r0
      false, // divided/nR/nR/%r1
      false, // divided/nR/nR/%rR
      false, // divided-stack
      false, // drop-stack
      false, // dup-stack
      false, // equal-stack
      false, // equali-stack/n0
      false, // equali-stack/n1
      false, // equali-stack/n2
      false, // equali-stack/nR
      false, // exitvm
      false, // greater-stack
      false, // greaterorequal-stack
      false, // input/%r0/retR
      false, // input/%r1/retR
      false, // input/%rR/retR
      false, // input-stack/retR
      false, // isnonzero-stack
      false, // less-stack
      false, // lessorequal-stack
      false, // logicaland-stack
      false, // logicalnot-stack
      false, // logicalor-stack
      false, // minus/%r0/%r0/%r0
      false, // minus/%r0/%r0/%r1
      false, // minus/%r0/%r0/%rR
      false, // minus/%r0/%r1/%r0
      false, // minus/%r0/%r1/%r1
      false, // minus/%r0/%r1/%rR
      false, // minus/%r0/%rR/%r0
      false, // minus/%r0/%rR/%r1
      false, // minus/%r0/%rR/%rR
      false, // minus/%r0/n1/%r0
      false, // minus/%r0/n1/%r1
      false, // minus/%r0/n1/%rR
      false, // minus/%r0/n2/%r0
      false, // minus/%r0/n2/%r1
      false, // minus/%r0/n2/%rR
      false, // minus/%r0/nR/%r0
      false, // minus/%r0/nR/%r1
      false, // minus/%r0/nR/%rR
      false, // minus/%r1/%r0/%r0
      false, // minus/%r1/%r0/%r1
      false, // minus/%r1/%r0/%rR
      false, // minus/%r1/%r1/%r0
      false, // minus/%r1/%r1/%r1
      false, // minus/%r1/%r1/%rR
      false, // minus/%r1/%rR/%r0
      false, // minus/%r1/%rR/%r1
      false, // minus/%r1/%rR/%rR
      false, // minus/%r1/n1/%r0
      false, // minus/%r1/n1/%r1
      false, // minus/%r1/n1/%rR
      false, // minus/%r1/n2/%r0
      false, // minus/%r1/n2/%r1
      false, // minus/%r1/n2/%rR
      false, // minus/%r1/nR/%r0
      false, // minus/%r1/nR/%r1
      false, // minus/%r1/nR/%rR
      false, // minus/%rR/%r0/%r0
      false, // minus/%rR/%r0/%r1
      false, // minus/%rR/%r0/%rR
      false, // minus/%rR/%r1/%r0
      false, // minus/%rR/%r1/%r1
      false, // minus/%rR/%r1/%rR
      false, // minus/%rR/%rR/%r0
      false, // minus/%rR/%rR/%r1
      false, // minus/%rR/%rR/%rR
      false, // minus/%rR/n1/%r0
      false, // minus/%rR/n1/%r1
      false, // minus/%rR/n1/%rR
      false, // minus/%rR/n2/%r0
      false, // minus/%rR/n2/%r1
      false, // minus/%rR/n2/%rR
      false, // minus/%rR/nR/%r0
      false, // minus/%rR/nR/%r1
      false, // minus/%rR/nR/%rR
      false, // minus/nR/%r0/%r0
      false, // minus/nR/%r0/%r1
      false, // minus/nR/%r0/%rR
      false, // minus/nR/%r1/%r0
      false, // minus/nR/%r1/%r1
      false, // minus/nR/%r1/%rR
      false, // minus/nR/%rR/%r0
      false, // minus/nR/%rR/%r1
      false, // minus/nR/%rR/%rR
      false, // minus/nR/n1/%r0
      false, // minus/nR/n1/%r1
      false, // minus/nR/n1/%rR
      false, // minus/nR/n2/%r0
      false, // minus/nR/n2/%r1
      false, // minus/nR/n2/%rR
      false, // minus/nR/nR/%r0
      false, // minus/nR/nR/%r1
      false, // minus/nR/nR/%rR
      false, // minus-stack
      false, // minusi-stack/n1
      false, // minusi-stack/n2
      false, // minusi-stack/nR
      false, // minusr-stack/%r0
      false, // minusr-stack/%r1
      false, // minusr-stack/%rR
      false, // mov/%r0/%r0
      false, // mov/%r0/%r1
      false, // mov/%r0/%rR
      false, // mov/%r1/%r0
      false, // mov/%r1/%r1
      false, // mov/%r1/%rR
      false, // mov/%rR/%r0
      false, // mov/%rR/%r1
      false, // mov/%rR/%rR
      false, // mov/n0/%r0
      false, // mov/n0/%r1
      false, // mov/n0/%rR
      false, // mov/n1/%r0
      false, // mov/n1/%r1
      false, // mov/n1/%rR
      false, // mov/n-1/%r0
      false, // mov/n-1/%r1
      false, // mov/n-1/%rR
      false, // mov/n2/%r0
      false, // mov/n2/%r1
      false, // mov/n2/%rR
      false, // mov/nR/%r0
      false, // mov/nR/%r1
      false, // mov/nR/%rR
      false, // plus/%r0/%r0/%r0
      false, // plus/%r0/%r0/%r1
      false, // plus/%r0/%r0/%rR
      false, // plus/%r0/%r1/%r0
      false, // plus/%r0/%r1/%r1
      false, // plus/%r0/%r1/%rR
      false, // plus/%r0/%rR/%r0
      false, // plus/%r0/%rR/%r1
      false, // plus/%r0/%rR/%rR
      false, // plus/%r0/n1/%r0
      false, // plus/%r0/n1/%r1
      false, // plus/%r0/n1/%rR
      false, // plus/%r0/n2/%r0
      false, // plus/%r0/n2/%r1
      false, // plus/%r0/n2/%rR
      false, // plus/%r0/nR/%r0
      false, // plus/%r0/nR/%r1
      false, // plus/%r0/nR/%rR
      false, // plus/%r1/%r0/%r0
      false, // plus/%r1/%r0/%r1
      false, // plus/%r1/%r0/%rR
      false, // plus/%r1/%r1/%r0
      false, // plus/%r1/%r1/%r1
      false, // plus/%r1/%r1/%rR
      false, // plus/%r1/%rR/%r0
      false, // plus/%r1/%rR/%r1
      false, // plus/%r1/%rR/%rR
      false, // plus/%r1/n1/%r0
      false, // plus/%r1/n1/%r1
      false, // plus/%r1/n1/%rR
      false, // plus/%r1/n2/%r0
      false, // plus/%r1/n2/%r1
      false, // plus/%r1/n2/%rR
      false, // plus/%r1/nR/%r0
      false, // plus/%r1/nR/%r1
      false, // plus/%r1/nR/%rR
      false, // plus/%rR/%r0/%r0
      false, // plus/%rR/%r0/%r1
      false, // plus/%rR/%r0/%rR
      false, // plus/%rR/%r1/%r0
      false, // plus/%rR/%r1/%r1
      false, // plus/%rR/%r1/%rR
      false, // plus/%rR/%rR/%r0
      false, // plus/%rR/%rR/%r1
      false, // plus/%rR/%rR/%rR
      false, // plus/%rR/n1/%r0
      false, // plus/%rR/n1/%r1
      false, // plus/%rR/n1/%rR
      false, // plus/%rR/n2/%r0
      false, // plus/%rR/n2/%r1
      false, // plus/%rR/n2/%rR
      false, // plus/%rR/nR/%r0
      false, // plus/%rR/nR/%r1
      false, // plus/%rR/nR/%rR
      false, // plus/nR/%r0/%r0
      false, // plus/nR/%r0/%r1
      false, // plus/nR/%r0/%rR
      false, // plus/nR/%r1/%r0
      false, // plus/nR/%r1/%r1
      false, // plus/nR/%r1/%rR
      false, // plus/nR/%rR/%r0
      false, // plus/nR/%rR/%r1
      false, // plus/nR/%rR/%rR
      false, // plus/nR/n1/%r0
      false, // plus/nR/n1/%r1
      false, // plus/nR/n1/%rR
      false, // plus/nR/n2/%r0
      false, // plus/nR/n2/%r1
      false, // plus/nR/n2/%rR
      false, // plus/nR/nR/%r0
      false, // plus/nR/nR/%r1
      false, // plus/nR/nR/%rR
      false, // plus-stack
      false, // plusi-stack/n-1
      false, // plusi-stack/n1
      false, // plusi-stack/n2
      false, // plusi-stack/nR
      false, // pop-stack/%r0
      false, // pop-stack/%r1
      false, // pop-stack/%rR
      false, // print/%r0/retR
      false, // print/%r1/retR
      false, // print/%rR/retR
      false, // print/nR/retR
      false, // print-stack/retR
      false, // push-stack/%r0
      false, // push-stack/%r1
      false, // push-stack/%rR
      false, // push-stack/n0
      false, // push-stack/n1
      false, // push-stack/n-1
      false, // push-stack/n2
      false, // push-stack/nR
      false, // push-stack/lR
      false, // pushr-beqr-stack/%r0/%r0/fR
      false, // pushr-beqr-stack/%r0/%r1/fR
      false, // pushr-beqr-stack/%r0/%rR/fR
      false, // pushr-beqr-stack/%r1/%r0/fR
      false, // pushr-beqr-stack/%r1/%r1/fR
      false, // pushr-beqr-stack/%r1/%rR/fR
      false, // pushr-beqr-stack/%rR/%r0/fR
      false, // pushr-beqr-stack/%rR/%r1/fR
      false, // pushr-beqr-stack/%rR/%rR/fR
      false, // pushr-bger-stack/%r0/%r0/fR
      false, // pushr-bger-stack/%r0/%r1/fR
      false, // pushr-bger-stack/%r0/%rR/fR
      false, // pushr-bger-stack/%r1/%r0/fR
      false, // pushr-bger-stack/%r1/%r1/fR
      false, // pushr-bger-stack/%r1/%rR/fR
      false, // pushr-bger-stack/%rR/%r0/fR
      false, // pushr-bger-stack/%rR/%r1/fR
      false, // pushr-bger-stack/%rR/%rR/fR
      false, // pushr-minusr-pop-stack/%r0/%r0/%r0
      false, // pushr-minusr-pop-stack/%r0/%r0/%r1
      false, // pushr-minusr-pop-stack/%r0/%r0/%rR
      false, // pushr-minusr-pop-stack/%r0/%r1/%r0
      false, // pushr-minusr-pop-stack/%r0/%r1/%r1
      false, // pushr-minusr-pop-stack/%r0/%r1/%rR
      false, // pushr-minusr-pop-stack/%r0/%rR/%r0
      false, // pushr-minusr-pop-stack/%r0/%rR/%r1
      false, // pushr-minusr-pop-stack/%r0/%rR/%rR
      false, // pushr-minusr-pop-stack/%r1/%r0/%r0
      false, // pushr-minusr-pop-stack/%r1/%r0/%r1
      false, // pushr-minusr-pop-stack/%r1/%r0/%rR
      false, // pushr-minusr-pop-stack/%r1/%r1/%r0
      false, // pushr-minusr-pop-stack/%r1/%r1/%r1
      false, // pushr-minusr-pop-stack/%r1/%r1/%rR
      false, // pushr-minusr-pop-stack/%r1/%rR/%r0
      false, // pushr-minusr-pop-stack/%r1/%rR/%r1
      false, // pushr-minusr-pop-stack/%r1/%rR/%rR
      false, // pushr-minusr-pop-stack/%rR/%r0/%r0
      false, // pushr-minusr-pop-stack/%rR/%r0/%r1
      false, // pushr-minusr-pop-stack/%rR/%r0/%rR
      false, // pushr-minusr-pop-stack/%rR/%r1/%r0
      false, // pushr-minusr-pop-stack/%rR/%r1/%r1
      false, // pushr-minusr-pop-stack/%rR/%r1/%rR
      false, // pushr-minusr-pop-stack/%rR/%rR/%r0
      false, // pushr-minusr-pop-stack/%rR/%rR/%r1
      false, // pushr-minusr-pop-stack/%rR/%rR/%rR
      false, // remainder/%r0/%r0/%r0
      false, // remainder/%r0/%r0/%r1
      false, // remainder/%r0/%r0/%rR
      false, // remainder/%r0/%r1/%r0
      false, // remainder/%r0/%r1/%r1
      false, // remainder/%r0/%r1/%rR
      false, // remainder/%r0/%rR/%r0
      false, // remainder/%r0/%rR/%r1
      false, // remainder/%r0/%rR/%rR
      false, // remainder/%r0/n2/%r0
      false, // remainder/%r0/n2/%r1
      false, // remainder/%r0/n2/%rR
      false, // remainder/%r0/nR/%r0
      false, // remainder/%r0/nR/%r1
      false, // remainder/%r0/nR/%rR
      false, // remainder/%r1/%r0/%r0
      false, // remainder/%r1/%r0/%r1
      false, // remainder/%r1/%r0/%rR
      false, // remainder/%r1/%r1/%r0
      false, // remainder/%r1/%r1/%r1
      false, // remainder/%r1/%r1/%rR
      false, // remainder/%r1/%rR/%r0
      false, // remainder/%r1/%rR/%r1
      false, // remainder/%r1/%rR/%rR
      false, // remainder/%r1/n2/%r0
      false, // remainder/%r1/n2/%r1
      false, // remainder/%r1/n2/%rR
      false, // remainder/%r1/nR/%r0
      false, // remainder/%r1/nR/%r1
      false, // remainder/%r1/nR/%rR
      false, // remainder/%rR/%r0/%r0
      false, // remainder/%rR/%r0/%r1
      false, // remainder/%rR/%r0/%rR
      false, // remainder/%rR/%r1/%r0
      false, // remainder/%rR/%r1/%r1
      false, // remainder/%rR/%r1/%rR
      false, // remainder/%rR/%rR/%r0
      false, // remainder/%rR/%rR/%r1
      false, // remainder/%rR/%rR/%rR
      false, // remainder/%rR/n2/%r0
      false, // remainder/%rR/n2/%r1
      false, // remainder/%rR/n2/%rR
      false, // remainder/%rR/nR/%r0
      false, // remainder/%rR/nR/%r1
      false, // remainder/%rR/nR/%rR
      false, // remainder/nR/%r0/%r0
      false, // remainder/nR/%r0/%r1
      false, // remainder/nR/%r0/%rR
      false, // remainder/nR/%r1/%r0
      false, // remainder/nR/%r1/%r1
      false, // remainder/nR/%r1/%rR
      false, // remainder/nR/%rR/%r0
      false, // remainder/nR/%rR/%r1
      false, // remainder/nR/%rR/%rR
      false, // remainder/nR/n2/%r0
      false, // remainder/nR/n2/%r1
      false, // remainder/nR/n2/%rR
      false, // remainder/nR/nR/%r0
      false, // remainder/nR/nR/%r1
      false, // remainder/nR/nR/%rR
      false, // remainder-stack
      false, // times/%r0/%r0/%r0
      false, // times/%r0/%r0/%r1
      false, // times/%r0/%r0/%rR
      false, // times/%r0/%r1/%r0
      false, // times/%r0/%r1/%r1
      false, // times/%r0/%r1/%rR
      false, // times/%r0/%rR/%r0
      false, // times/%r0/%rR/%r1
      false, // times/%r0/%rR/%rR
      false, // times/%r0/n2/%r0
      false, // times/%r0/n2/%r1
      false, // times/%r0/n2/%rR
      false, // times/%r0/nR/%r0
      false, // times/%r0/nR/%r1
      false, // times/%r0/nR/%rR
      false, // times/%r1/%r0/%r0
      false, // times/%r1/%r0/%r1
      false, // times/%r1/%r0/%rR
      false, // times/%r1/%r1/%r0
      false, // times/%r1/%r1/%r1
      false, // times/%r1/%r1/%rR
      false, // times/%r1/%rR/%r0
      false, // times/%r1/%rR/%r1
      false, // times/%r1/%rR/%rR
      false, // times/%r1/n2/%r0
      false, // times/%r1/n2/%r1
      false, // times/%r1/n2/%rR
      false, // times/%r1/nR/%r0
      false, // times/%r1/nR/%r1
      false, // times/%r1/nR/%rR
      false, // times/%rR/%r0/%r0
      false, // times/%rR/%r0/%r1
      false, // times/%rR/%r0/%rR
      false, // times/%rR/%r1/%r0
      false, // times/%rR/%r1/%r1
      false, // times/%rR/%r1/%rR
      false, // times/%rR/%rR/%r0
      false, // times/%rR/%rR/%r1
      false, // times/%rR/%rR/%rR
      false, // times/%rR/n2/%r0
      false, // times/%rR/n2/%r1
      false, // times/%rR/n2/%rR
      false, // times/%rR/nR/%r0
      false, // times/%rR/nR/%r1
      false, // times/%rR/nR/%rR
      false, // times/nR/%r0/%r0
      false, // times/nR/%r0/%r1
      false, // times/nR/%r0/%rR
      false, // times/nR/%r1/%r0
      false, // times/nR/%r1/%r1
      false, // times/nR/%r1/%rR
      false, // times/nR/%rR/%r0
      false, // times/nR/%rR/%r1
      false, // times/nR/%rR/%rR
      false, // times/nR/n2/%r0
      false, // times/nR/n2/%r1
      false, // times/nR/n2/%rR
      false, // times/nR/nR/%r0
      false, // times/nR/nR/%r1
      false, // times/nR/nR/%rR
      false, // times-stack
      false, // uminus/%r0/%r0
      false, // uminus/%r0/%r1
      false, // uminus/%r0/%rR
      false, // uminus/%r1/%r0
      false, // uminus/%r1/%r1
      false, // uminus/%r1/%rR
      false, // uminus/%rR/%r0
      false, // uminus/%rR/%r1
      false, // uminus/%rR/%rR
      false, // uminus/nR/%r0
      false, // uminus/nR/%r1
      false, // uminus/nR/%rR
      false, // uminus-stack
      false, // unreachable
      false, // *b/fR*-no-fast-branches
      false, // *be/%r0/%r0/fR*-no-fast-branches
      false, // *be/%r0/%r1/fR*-no-fast-branches
      false, // *be/%r0/%rR/fR*-no-fast-branches
      false, // *be/%r0/n0/fR*-no-fast-branches
      false, // *be/%r0/nR/fR*-no-fast-branches
      false, // *be/%r1/%r0/fR*-no-fast-branches
      false, // *be/%r1/%r1/fR*-no-fast-branches
      false, // *be/%r1/%rR/fR*-no-fast-branches
      false, // *be/%r1/n0/fR*-no-fast-branches
      false, // *be/%r1/nR/fR*-no-fast-branches
      false, // *be/%rR/%r0/fR*-no-fast-branches
      false, // *be/%rR/%r1/fR*-no-fast-branches
      false, // *be/%rR/%rR/fR*-no-fast-branches
      false, // *be/%rR/n0/fR*-no-fast-branches
      false, // *be/%rR/nR/fR*-no-fast-branches
      false, // *be/n0/%r0/fR*-no-fast-branches
      false, // *be/n0/%r1/fR*-no-fast-branches
      false, // *be/n0/%rR/fR*-no-fast-branches
      false, // *be/n0/n0/fR*-no-fast-branches
      false, // *be/n0/nR/fR*-no-fast-branches
      false, // *be/nR/%r0/fR*-no-fast-branches
      false, // *be/nR/%r1/fR*-no-fast-branches
      false, // *be/nR/%rR/fR*-no-fast-branches
      false, // *be/nR/n0/fR*-no-fast-branches
      false, // *be/nR/nR/fR*-no-fast-branches
      false, // *beqi-stack/n-1/fR*-no-fast-branches
      false, // *beqi-stack/n0/fR*-no-fast-branches
      false, // *beqi-stack/n1/fR*-no-fast-branches
      false, // *beqi-stack/n2/fR*-no-fast-branches
      false, // *beqi-stack/nR/fR*-no-fast-branches
      false, // *beqr-stack/%r0/fR*-no-fast-branches
      false, // *beqr-stack/%r1/fR*-no-fast-branches
      false, // *beqr-stack/%rR/fR*-no-fast-branches
      false, // *bf-stack/fR*-no-fast-branches
      false, // *bg/%r0/%r0/fR*-no-fast-branches
      false, // *bg/%r0/%r1/fR*-no-fast-branches
      false, // *bg/%r0/%rR/fR*-no-fast-branches
      false, // *bg/%r0/n0/fR*-no-fast-branches
      false, // *bg/%r0/nR/fR*-no-fast-branches
      false, // *bg/%r1/%r0/fR*-no-fast-branches
      false, // *bg/%r1/%r1/fR*-no-fast-branches
      false, // *bg/%r1/%rR/fR*-no-fast-branches
      false, // *bg/%r1/n0/fR*-no-fast-branches
      false, // *bg/%r1/nR/fR*-no-fast-branches
      false, // *bg/%rR/%r0/fR*-no-fast-branches
      false, // *bg/%rR/%r1/fR*-no-fast-branches
      false, // *bg/%rR/%rR/fR*-no-fast-branches
      false, // *bg/%rR/n0/fR*-no-fast-branches
      false, // *bg/%rR/nR/fR*-no-fast-branches
      false, // *bg/n0/%r0/fR*-no-fast-branches
      false, // *bg/n0/%r1/fR*-no-fast-branches
      false, // *bg/n0/%rR/fR*-no-fast-branches
      false, // *bg/n0/n0/fR*-no-fast-branches
      false, // *bg/n0/nR/fR*-no-fast-branches
      false, // *bg/nR/%r0/fR*-no-fast-branches
      false, // *bg/nR/%r1/fR*-no-fast-branches
      false, // *bg/nR/%rR/fR*-no-fast-branches
      false, // *bg/nR/n0/fR*-no-fast-branches
      false, // *bg/nR/nR/fR*-no-fast-branches
      false, // *bge/%r0/%r0/fR*-no-fast-branches
      false, // *bge/%r0/%r1/fR*-no-fast-branches
      false, // *bge/%r0/%rR/fR*-no-fast-branches
      false, // *bge/%r0/n0/fR*-no-fast-branches
      false, // *bge/%r0/nR/fR*-no-fast-branches
      false, // *bge/%r1/%r0/fR*-no-fast-branches
      false, // *bge/%r1/%r1/fR*-no-fast-branches
      false, // *bge/%r1/%rR/fR*-no-fast-branches
      false, // *bge/%r1/n0/fR*-no-fast-branches
      false, // *bge/%r1/nR/fR*-no-fast-branches
      false, // *bge/%rR/%r0/fR*-no-fast-branches
      false, // *bge/%rR/%r1/fR*-no-fast-branches
      false, // *bge/%rR/%rR/fR*-no-fast-branches
      false, // *bge/%rR/n0/fR*-no-fast-branches
      false, // *bge/%rR/nR/fR*-no-fast-branches
      false, // *bge/n0/%r0/fR*-no-fast-branches
      false, // *bge/n0/%r1/fR*-no-fast-branches
      false, // *bge/n0/%rR/fR*-no-fast-branches
      false, // *bge/n0/n0/fR*-no-fast-branches
      false, // *bge/n0/nR/fR*-no-fast-branches
      false, // *bge/nR/%r0/fR*-no-fast-branches
      false, // *bge/nR/%r1/fR*-no-fast-branches
      false, // *bge/nR/%rR/fR*-no-fast-branches
      false, // *bge/nR/n0/fR*-no-fast-branches
      false, // *bge/nR/nR/fR*-no-fast-branches
      false, // *bger-stack/%r0/fR*-no-fast-branches
      false, // *bger-stack/%r1/fR*-no-fast-branches
      false, // *bger-stack/%rR/fR*-no-fast-branches
      false, // *bl/%r0/%r0/fR*-no-fast-branches
      false, // *bl/%r0/%r1/fR*-no-fast-branches
      false, // *bl/%r0/%rR/fR*-no-fast-branches
      false, // *bl/%r0/n0/fR*-no-fast-branches
      false, // *bl/%r0/nR/fR*-no-fast-branches
      false, // *bl/%r1/%r0/fR*-no-fast-branches
      false, // *bl/%r1/%r1/fR*-no-fast-branches
      false, // *bl/%r1/%rR/fR*-no-fast-branches
      false, // *bl/%r1/n0/fR*-no-fast-branches
      false, // *bl/%r1/nR/fR*-no-fast-branches
      false, // *bl/%rR/%r0/fR*-no-fast-branches
      false, // *bl/%rR/%r1/fR*-no-fast-branches
      false, // *bl/%rR/%rR/fR*-no-fast-branches
      false, // *bl/%rR/n0/fR*-no-fast-branches
      false, // *bl/%rR/nR/fR*-no-fast-branches
      false, // *bl/n0/%r0/fR*-no-fast-branches
      false, // *bl/n0/%r1/fR*-no-fast-branches
      false, // *bl/n0/%rR/fR*-no-fast-branches
      false, // *bl/n0/n0/fR*-no-fast-branches
      false, // *bl/n0/nR/fR*-no-fast-branches
      false, // *bl/nR/%r0/fR*-no-fast-branches
      false, // *bl/nR/%r1/fR*-no-fast-branches
      false, // *bl/nR/%rR/fR*-no-fast-branches
      false, // *bl/nR/n0/fR*-no-fast-branches
      false, // *bl/nR/nR/fR*-no-fast-branches
      false, // *ble/%r0/%r0/fR*-no-fast-branches
      false, // *ble/%r0/%r1/fR*-no-fast-branches
      false, // *ble/%r0/%rR/fR*-no-fast-branches
      false, // *ble/%r0/n0/fR*-no-fast-branches
      false, // *ble/%r0/nR/fR*-no-fast-branches
      false, // *ble/%r1/%r0/fR*-no-fast-branches
      false, // *ble/%r1/%r1/fR*-no-fast-branches
      false, // *ble/%r1/%rR/fR*-no-fast-branches
      false, // *ble/%r1/n0/fR*-no-fast-branches
      false, // *ble/%r1/nR/fR*-no-fast-branches
      false, // *ble/%rR/%r0/fR*-no-fast-branches
      false, // *ble/%rR/%r1/fR*-no-fast-branches
      false, // *ble/%rR/%rR/fR*-no-fast-branches
      false, // *ble/%rR/n0/fR*-no-fast-branches
      false, // *ble/%rR/nR/fR*-no-fast-branches
      false, // *ble/n0/%r0/fR*-no-fast-branches
      false, // *ble/n0/%r1/fR*-no-fast-branches
      false, // *ble/n0/%rR/fR*-no-fast-branches
      false, // *ble/n0/n0/fR*-no-fast-branches
      false, // *ble/n0/nR/fR*-no-fast-branches
      false, // *ble/nR/%r0/fR*-no-fast-branches
      false, // *ble/nR/%r1/fR*-no-fast-branches
      false, // *ble/nR/%rR/fR*-no-fast-branches
      false, // *ble/nR/n0/fR*-no-fast-branches
      false, // *ble/nR/nR/fR*-no-fast-branches
      false, // *bne/%r0/%r0/fR*-no-fast-branches
      false, // *bne/%r0/%r1/fR*-no-fast-branches
      false, // *bne/%r0/%rR/fR*-no-fast-branches
      false, // *bne/%r0/n0/fR*-no-fast-branches
      false, // *bne/%r0/nR/fR*-no-fast-branches
      false, // *bne/%r1/%r0/fR*-no-fast-branches
      false, // *bne/%r1/%r1/fR*-no-fast-branches
      false, // *bne/%r1/%rR/fR*-no-fast-branches
      false, // *bne/%r1/n0/fR*-no-fast-branches
      false, // *bne/%r1/nR/fR*-no-fast-branches
      false, // *bne/%rR/%r0/fR*-no-fast-branches
      false, // *bne/%rR/%r1/fR*-no-fast-branches
      false, // *bne/%rR/%rR/fR*-no-fast-branches
      false, // *bne/%rR/n0/fR*-no-fast-branches
      false, // *bne/%rR/nR/fR*-no-fast-branches
      false, // *bne/n0/%r0/fR*-no-fast-branches
      false, // *bne/n0/%r1/fR*-no-fast-branches
      false, // *bne/n0/%rR/fR*-no-fast-branches
      false, // *bne/n0/n0/fR*-no-fast-branches
      false, // *bne/n0/nR/fR*-no-fast-branches
      false, // *bne/nR/%r0/fR*-no-fast-branches
      false, // *bne/nR/%r1/fR*-no-fast-branches
      false, // *bne/nR/%rR/fR*-no-fast-branches
      false, // *bne/nR/n0/fR*-no-fast-branches
      false, // *bne/nR/nR/fR*-no-fast-branches
      false, // *bneqi-stack/n-1/fR*-no-fast-branches
      false, // *bneqi-stack/n0/fR*-no-fast-branches
      false, // *bneqi-stack/n1/fR*-no-fast-branches
      false, // *bneqi-stack/n2/fR*-no-fast-branches
      false, // *bneqi-stack/nR/fR*-no-fast-branches
      false, // *bneqr-stack/%r0/fR*-no-fast-branches
      false, // *bneqr-stack/%r1/fR*-no-fast-branches
      false, // *bneqr-stack/%rR/fR*-no-fast-branches
      false, // *bt-stack/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%r0/%r0/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%r0/%r1/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%r0/%rR/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%r1/%r0/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%r1/%r1/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%r1/%rR/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%rR/%r0/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%rR/%r1/fR*-no-fast-branches
      false, // *pushr-beqr-stack/%rR/%rR/fR*-no-fast-branches
      false, // *pushr-bger-stack/%r0/%r0/fR*-no-fast-branches
      false, // *pushr-bger-stack/%r0/%r1/fR*-no-fast-branches
      false, // *pushr-bger-stack/%r0/%rR/fR*-no-fast-branches
      false, // *pushr-bger-stack/%r1/%r0/fR*-no-fast-branches
      false, // *pushr-bger-stack/%r1/%r1/fR*-no-fast-branches
      false, // *pushr-bger-stack/%r1/%rR/fR*-no-fast-branches
      false, // *pushr-bger-stack/%rR/%r0/fR*-no-fast-branches
      false, // *pushr-bger-stack/%rR/%r1/fR*-no-fast-branches
      false // *pushr-bger-stack/%rR/%rR/fR*-no-fast-branches
    };

/* An array whose indices are specialised instruction opcodes, and
   whose elements are the corresponding unspecialised instructions
   opcodes -- or -1 when there is no mapping mapping having */
const int
structuredvm_specialized_instruction_to_unspecialized_instruction
   [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO]
  = {
    -1, /* !INVALID */
    -1, /* !BEGINBASICBLOCK */
    -1, /* !EXITVM */
    -1, /* !DATALOCATIONS */
    -1, /* !NOP */
    -1, /* !UNREACHABLE0 */
    -1, /* !UNREACHABLE1 */
    -1, /* !UNREACHABLE2 */
    structuredvm_meta_instruction_id_b, /* b/fR */
    structuredvm_meta_instruction_id_be, /* be/%r0/%r0/fR */
    structuredvm_meta_instruction_id_be, /* be/%r0/%r1/fR */
    structuredvm_meta_instruction_id_be, /* be/%r0/%rR/fR */
    structuredvm_meta_instruction_id_be, /* be/%r0/n0/fR */
    structuredvm_meta_instruction_id_be, /* be/%r0/nR/fR */
    structuredvm_meta_instruction_id_be, /* be/%r1/%r0/fR */
    structuredvm_meta_instruction_id_be, /* be/%r1/%r1/fR */
    structuredvm_meta_instruction_id_be, /* be/%r1/%rR/fR */
    structuredvm_meta_instruction_id_be, /* be/%r1/n0/fR */
    structuredvm_meta_instruction_id_be, /* be/%r1/nR/fR */
    structuredvm_meta_instruction_id_be, /* be/%rR/%r0/fR */
    structuredvm_meta_instruction_id_be, /* be/%rR/%r1/fR */
    structuredvm_meta_instruction_id_be, /* be/%rR/%rR/fR */
    structuredvm_meta_instruction_id_be, /* be/%rR/n0/fR */
    structuredvm_meta_instruction_id_be, /* be/%rR/nR/fR */
    structuredvm_meta_instruction_id_be, /* be/n0/%r0/fR */
    structuredvm_meta_instruction_id_be, /* be/n0/%r1/fR */
    structuredvm_meta_instruction_id_be, /* be/n0/%rR/fR */
    structuredvm_meta_instruction_id_be, /* be/n0/n0/fR */
    structuredvm_meta_instruction_id_be, /* be/n0/nR/fR */
    structuredvm_meta_instruction_id_be, /* be/nR/%r0/fR */
    structuredvm_meta_instruction_id_be, /* be/nR/%r1/fR */
    structuredvm_meta_instruction_id_be, /* be/nR/%rR/fR */
    structuredvm_meta_instruction_id_be, /* be/nR/n0/fR */
    structuredvm_meta_instruction_id_be, /* be/nR/nR/fR */
    structuredvm_meta_instruction_id_beqi_mstack, /* beqi-stack/n-1/fR */
    structuredvm_meta_instruction_id_beqi_mstack, /* beqi-stack/n0/fR */
    structuredvm_meta_instruction_id_beqi_mstack, /* beqi-stack/n1/fR */
    structuredvm_meta_instruction_id_beqi_mstack, /* beqi-stack/n2/fR */
    structuredvm_meta_instruction_id_beqi_mstack, /* beqi-stack/nR/fR */
    structuredvm_meta_instruction_id_beqr_mstack, /* beqr-stack/%r0/fR */
    structuredvm_meta_instruction_id_beqr_mstack, /* beqr-stack/%r1/fR */
    structuredvm_meta_instruction_id_beqr_mstack, /* beqr-stack/%rR/fR */
    structuredvm_meta_instruction_id_bf_mstack, /* bf-stack/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r0/%r0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r0/%r1/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r0/%rR/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r0/n0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r0/nR/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r1/%r0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r1/%r1/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r1/%rR/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r1/n0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r1/nR/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%rR/%r0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%rR/%r1/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%rR/%rR/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%rR/n0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%rR/nR/fR */
    structuredvm_meta_instruction_id_bg, /* bg/n0/%r0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/n0/%r1/fR */
    structuredvm_meta_instruction_id_bg, /* bg/n0/%rR/fR */
    structuredvm_meta_instruction_id_bg, /* bg/n0/n0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/n0/nR/fR */
    structuredvm_meta_instruction_id_bg, /* bg/nR/%r0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/nR/%r1/fR */
    structuredvm_meta_instruction_id_bg, /* bg/nR/%rR/fR */
    structuredvm_meta_instruction_id_bg, /* bg/nR/n0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/nR/nR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r0/%r0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r0/%r1/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r0/%rR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r0/n0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r0/nR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r1/%r0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r1/%r1/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r1/%rR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r1/n0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r1/nR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%rR/%r0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%rR/%r1/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%rR/%rR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%rR/n0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%rR/nR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/n0/%r0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/n0/%r1/fR */
    structuredvm_meta_instruction_id_bge, /* bge/n0/%rR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/n0/n0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/n0/nR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/nR/%r0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/nR/%r1/fR */
    structuredvm_meta_instruction_id_bge, /* bge/nR/%rR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/nR/n0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/nR/nR/fR */
    structuredvm_meta_instruction_id_bger_mstack, /* bger-stack/%r0/fR */
    structuredvm_meta_instruction_id_bger_mstack, /* bger-stack/%r1/fR */
    structuredvm_meta_instruction_id_bger_mstack, /* bger-stack/%rR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r0/%r0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r0/%r1/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r0/%rR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r0/n0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r0/nR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r1/%r0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r1/%r1/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r1/%rR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r1/n0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r1/nR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%rR/%r0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%rR/%r1/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%rR/%rR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%rR/n0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%rR/nR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/n0/%r0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/n0/%r1/fR */
    structuredvm_meta_instruction_id_bl, /* bl/n0/%rR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/n0/n0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/n0/nR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/nR/%r0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/nR/%r1/fR */
    structuredvm_meta_instruction_id_bl, /* bl/nR/%rR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/nR/n0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/nR/nR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r0/%r0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r0/%r1/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r0/%rR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r0/n0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r0/nR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r1/%r0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r1/%r1/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r1/%rR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r1/n0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r1/nR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%rR/%r0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%rR/%r1/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%rR/%rR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%rR/n0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%rR/nR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/n0/%r0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/n0/%r1/fR */
    structuredvm_meta_instruction_id_ble, /* ble/n0/%rR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/n0/n0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/n0/nR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/nR/%r0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/nR/%r1/fR */
    structuredvm_meta_instruction_id_ble, /* ble/nR/%rR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/nR/n0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/nR/nR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r0/%r0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r0/%r1/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r0/%rR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r0/n0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r0/nR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r1/%r0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r1/%r1/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r1/%rR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r1/n0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r1/nR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%rR/%r0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%rR/%r1/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%rR/%rR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%rR/n0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%rR/nR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/n0/%r0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/n0/%r1/fR */
    structuredvm_meta_instruction_id_bne, /* bne/n0/%rR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/n0/n0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/n0/nR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/nR/%r0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/nR/%r1/fR */
    structuredvm_meta_instruction_id_bne, /* bne/nR/%rR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/nR/n0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/nR/nR/fR */
    structuredvm_meta_instruction_id_bneqi_mstack, /* bneqi-stack/n-1/fR */
    structuredvm_meta_instruction_id_bneqi_mstack, /* bneqi-stack/n0/fR */
    structuredvm_meta_instruction_id_bneqi_mstack, /* bneqi-stack/n1/fR */
    structuredvm_meta_instruction_id_bneqi_mstack, /* bneqi-stack/n2/fR */
    structuredvm_meta_instruction_id_bneqi_mstack, /* bneqi-stack/nR/fR */
    structuredvm_meta_instruction_id_bneqr_mstack, /* bneqr-stack/%r0/fR */
    structuredvm_meta_instruction_id_bneqr_mstack, /* bneqr-stack/%r1/fR */
    structuredvm_meta_instruction_id_bneqr_mstack, /* bneqr-stack/%rR/fR */
    structuredvm_meta_instruction_id_bt_mstack, /* bt-stack/fR */
    structuredvm_meta_instruction_id_copy_mto_mr_mstack, /* copy-to-r-stack/%r0 */
    structuredvm_meta_instruction_id_copy_mto_mr_mstack, /* copy-to-r-stack/%r1 */
    structuredvm_meta_instruction_id_copy_mto_mr_mstack, /* copy-to-r-stack/%rR */
    structuredvm_meta_instruction_id_different_mstack, /* different-stack */
    structuredvm_meta_instruction_id_differenti_mstack, /* differenti-stack/n0 */
    structuredvm_meta_instruction_id_differenti_mstack, /* differenti-stack/n1 */
    structuredvm_meta_instruction_id_differenti_mstack, /* differenti-stack/n2 */
    structuredvm_meta_instruction_id_differenti_mstack, /* differenti-stack/nR */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/%r0/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/%r0/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/%r0/%rR */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/%r1/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/%r1/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/%r1/%rR */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/%rR/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/%rR/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/%rR/%rR */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/n2/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/n2/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/n2/%rR */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/nR/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/nR/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/nR/%rR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/%r0/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/%r0/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/%r0/%rR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/%r1/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/%r1/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/%r1/%rR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/%rR/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/%rR/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/%rR/%rR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/n2/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/n2/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/n2/%rR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/nR/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/nR/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/nR/%rR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/%r0/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/%r0/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/%r0/%rR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/%r1/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/%r1/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/%r1/%rR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/%rR/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/%rR/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/%rR/%rR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/n2/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/n2/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/n2/%rR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/nR/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/nR/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/nR/%rR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/%r0/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/nR/%r0/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/nR/%r0/%rR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/%r1/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/nR/%r1/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/nR/%r1/%rR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/%rR/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/nR/%rR/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/nR/%rR/%rR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/n2/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/nR/n2/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/nR/n2/%rR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/nR/%r0 */
    structuredvm_meta_instruction_id_divided, /* divided/nR/nR/%r1 */
    structuredvm_meta_instruction_id_divided, /* divided/nR/nR/%rR */
    structuredvm_meta_instruction_id_divided_mstack, /* divided-stack */
    structuredvm_meta_instruction_id_drop_mstack, /* drop-stack */
    structuredvm_meta_instruction_id_dup_mstack, /* dup-stack */
    structuredvm_meta_instruction_id_equal_mstack, /* equal-stack */
    structuredvm_meta_instruction_id_equali_mstack, /* equali-stack/n0 */
    structuredvm_meta_instruction_id_equali_mstack, /* equali-stack/n1 */
    structuredvm_meta_instruction_id_equali_mstack, /* equali-stack/n2 */
    structuredvm_meta_instruction_id_equali_mstack, /* equali-stack/nR */
    structuredvm_meta_instruction_id_exitvm, /* exitvm */
    structuredvm_meta_instruction_id_greater_mstack, /* greater-stack */
    structuredvm_meta_instruction_id_greaterorequal_mstack, /* greaterorequal-stack */
    structuredvm_meta_instruction_id_input, /* input/%r0/retR */
    structuredvm_meta_instruction_id_input, /* input/%r1/retR */
    structuredvm_meta_instruction_id_input, /* input/%rR/retR */
    structuredvm_meta_instruction_id_input_mstack, /* input-stack/retR */
    structuredvm_meta_instruction_id_isnonzero_mstack, /* isnonzero-stack */
    structuredvm_meta_instruction_id_less_mstack, /* less-stack */
    structuredvm_meta_instruction_id_lessorequal_mstack, /* lessorequal-stack */
    structuredvm_meta_instruction_id_logicaland_mstack, /* logicaland-stack */
    structuredvm_meta_instruction_id_logicalnot_mstack, /* logicalnot-stack */
    structuredvm_meta_instruction_id_logicalor_mstack, /* logicalor-stack */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/%r0/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/%r0/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/%r0/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/%r1/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/%r1/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/%r1/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/%rR/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/%rR/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/%rR/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/n1/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/n1/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/n1/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/n2/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/n2/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/n2/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/nR/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/nR/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/nR/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/%r0/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/%r0/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/%r0/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/%r1/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/%r1/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/%r1/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/%rR/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/%rR/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/%rR/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/n1/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/n1/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/n1/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/n2/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/n2/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/n2/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/nR/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/nR/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/nR/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/%r0/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/%r0/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/%r0/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/%r1/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/%r1/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/%r1/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/%rR/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/%rR/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/%rR/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/n1/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/n1/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/n1/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/n2/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/n2/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/n2/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/nR/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/nR/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/nR/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/nR/%r0/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/%r0/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/%r0/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/nR/%r1/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/%r1/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/%r1/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/nR/%rR/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/%rR/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/%rR/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/nR/n1/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/n1/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/n1/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/nR/n2/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/n2/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/n2/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/nR/nR/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/nR/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/nR/%rR */
    structuredvm_meta_instruction_id_minus_mstack, /* minus-stack */
    structuredvm_meta_instruction_id_minusi_mstack, /* minusi-stack/n1 */
    structuredvm_meta_instruction_id_minusi_mstack, /* minusi-stack/n2 */
    structuredvm_meta_instruction_id_minusi_mstack, /* minusi-stack/nR */
    structuredvm_meta_instruction_id_minusr_mstack, /* minusr-stack/%r0 */
    structuredvm_meta_instruction_id_minusr_mstack, /* minusr-stack/%r1 */
    structuredvm_meta_instruction_id_minusr_mstack, /* minusr-stack/%rR */
    structuredvm_meta_instruction_id_mov, /* mov/%r0/%r0 */
    structuredvm_meta_instruction_id_mov, /* mov/%r0/%r1 */
    structuredvm_meta_instruction_id_mov, /* mov/%r0/%rR */
    structuredvm_meta_instruction_id_mov, /* mov/%r1/%r0 */
    structuredvm_meta_instruction_id_mov, /* mov/%r1/%r1 */
    structuredvm_meta_instruction_id_mov, /* mov/%r1/%rR */
    structuredvm_meta_instruction_id_mov, /* mov/%rR/%r0 */
    structuredvm_meta_instruction_id_mov, /* mov/%rR/%r1 */
    structuredvm_meta_instruction_id_mov, /* mov/%rR/%rR */
    structuredvm_meta_instruction_id_mov, /* mov/n0/%r0 */
    structuredvm_meta_instruction_id_mov, /* mov/n0/%r1 */
    structuredvm_meta_instruction_id_mov, /* mov/n0/%rR */
    structuredvm_meta_instruction_id_mov, /* mov/n1/%r0 */
    structuredvm_meta_instruction_id_mov, /* mov/n1/%r1 */
    structuredvm_meta_instruction_id_mov, /* mov/n1/%rR */
    structuredvm_meta_instruction_id_mov, /* mov/n-1/%r0 */
    structuredvm_meta_instruction_id_mov, /* mov/n-1/%r1 */
    structuredvm_meta_instruction_id_mov, /* mov/n-1/%rR */
    structuredvm_meta_instruction_id_mov, /* mov/n2/%r0 */
    structuredvm_meta_instruction_id_mov, /* mov/n2/%r1 */
    structuredvm_meta_instruction_id_mov, /* mov/n2/%rR */
    structuredvm_meta_instruction_id_mov, /* mov/nR/%r0 */
    structuredvm_meta_instruction_id_mov, /* mov/nR/%r1 */
    structuredvm_meta_instruction_id_mov, /* mov/nR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/%r0/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/%r0/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/%r0/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/%r1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/%r1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/%r1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/%rR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/%rR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/%rR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/n1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/n1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/n1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/n2/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/n2/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/n2/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/nR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/nR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/nR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/%r0/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/%r0/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/%r0/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/%r1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/%r1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/%r1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/%rR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/%rR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/%rR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/n1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/n1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/n1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/n2/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/n2/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/n2/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/nR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/nR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/nR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/%r0/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/%r0/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/%r0/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/%r1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/%r1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/%r1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/%rR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/%rR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/%rR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/n1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/n1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/n1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/n2/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/n2/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/n2/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/nR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/nR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/nR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/nR/%r0/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/%r0/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/%r0/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/nR/%r1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/%r1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/%r1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/nR/%rR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/%rR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/%rR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/nR/n1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/n1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/n1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/nR/n2/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/n2/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/n2/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/nR/nR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/nR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/nR/%rR */
    structuredvm_meta_instruction_id_plus_mstack, /* plus-stack */
    structuredvm_meta_instruction_id_plusi_mstack, /* plusi-stack/n-1 */
    structuredvm_meta_instruction_id_plusi_mstack, /* plusi-stack/n1 */
    structuredvm_meta_instruction_id_plusi_mstack, /* plusi-stack/n2 */
    structuredvm_meta_instruction_id_plusi_mstack, /* plusi-stack/nR */
    structuredvm_meta_instruction_id_pop_mstack, /* pop-stack/%r0 */
    structuredvm_meta_instruction_id_pop_mstack, /* pop-stack/%r1 */
    structuredvm_meta_instruction_id_pop_mstack, /* pop-stack/%rR */
    structuredvm_meta_instruction_id_print, /* print/%r0/retR */
    structuredvm_meta_instruction_id_print, /* print/%r1/retR */
    structuredvm_meta_instruction_id_print, /* print/%rR/retR */
    structuredvm_meta_instruction_id_print, /* print/nR/retR */
    structuredvm_meta_instruction_id_print_mstack, /* print-stack/retR */
    structuredvm_meta_instruction_id_push_mstack, /* push-stack/%r0 */
    structuredvm_meta_instruction_id_push_mstack, /* push-stack/%r1 */
    structuredvm_meta_instruction_id_push_mstack, /* push-stack/%rR */
    structuredvm_meta_instruction_id_push_mstack, /* push-stack/n0 */
    structuredvm_meta_instruction_id_push_mstack, /* push-stack/n1 */
    structuredvm_meta_instruction_id_push_mstack, /* push-stack/n-1 */
    structuredvm_meta_instruction_id_push_mstack, /* push-stack/n2 */
    structuredvm_meta_instruction_id_push_mstack, /* push-stack/nR */
    structuredvm_meta_instruction_id_push_mstack, /* push-stack/lR */
    structuredvm_meta_instruction_id_pushr_mbeqr_mstack, /* pushr-beqr-stack/%r0/%r0/fR */
    structuredvm_meta_instruction_id_pushr_mbeqr_mstack, /* pushr-beqr-stack/%r0/%r1/fR */
    structuredvm_meta_instruction_id_pushr_mbeqr_mstack, /* pushr-beqr-stack/%r0/%rR/fR */
    structuredvm_meta_instruction_id_pushr_mbeqr_mstack, /* pushr-beqr-stack/%r1/%r0/fR */
    structuredvm_meta_instruction_id_pushr_mbeqr_mstack, /* pushr-beqr-stack/%r1/%r1/fR */
    structuredvm_meta_instruction_id_pushr_mbeqr_mstack, /* pushr-beqr-stack/%r1/%rR/fR */
    structuredvm_meta_instruction_id_pushr_mbeqr_mstack, /* pushr-beqr-stack/%rR/%r0/fR */
    structuredvm_meta_instruction_id_pushr_mbeqr_mstack, /* pushr-beqr-stack/%rR/%r1/fR */
    structuredvm_meta_instruction_id_pushr_mbeqr_mstack, /* pushr-beqr-stack/%rR/%rR/fR */
    structuredvm_meta_instruction_id_pushr_mbger_mstack, /* pushr-bger-stack/%r0/%r0/fR */
    structuredvm_meta_instruction_id_pushr_mbger_mstack, /* pushr-bger-stack/%r0/%r1/fR */
    structuredvm_meta_instruction_id_pushr_mbger_mstack, /* pushr-bger-stack/%r0/%rR/fR */
    structuredvm_meta_instruction_id_pushr_mbger_mstack, /* pushr-bger-stack/%r1/%r0/fR */
    structuredvm_meta_instruction_id_pushr_mbger_mstack, /* pushr-bger-stack/%r1/%r1/fR */
    structuredvm_meta_instruction_id_pushr_mbger_mstack, /* pushr-bger-stack/%r1/%rR/fR */
    structuredvm_meta_instruction_id_pushr_mbger_mstack, /* pushr-bger-stack/%rR/%r0/fR */
    structuredvm_meta_instruction_id_pushr_mbger_mstack, /* pushr-bger-stack/%rR/%r1/fR */
    structuredvm_meta_instruction_id_pushr_mbger_mstack, /* pushr-bger-stack/%rR/%rR/fR */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%r0/%r0/%r0 */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%r0/%r0/%r1 */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%r0/%r0/%rR */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%r0/%r1/%r0 */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%r0/%r1/%r1 */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%r0/%r1/%rR */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%r0/%rR/%r0 */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%r0/%rR/%r1 */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%r0/%rR/%rR */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%r1/%r0/%r0 */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%r1/%r0/%r1 */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%r1/%r0/%rR */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%r1/%r1/%r0 */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%r1/%r1/%r1 */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%r1/%r1/%rR */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%r1/%rR/%r0 */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%r1/%rR/%r1 */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%r1/%rR/%rR */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%rR/%r0/%r0 */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%rR/%r0/%r1 */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%rR/%r0/%rR */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%rR/%r1/%r0 */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%rR/%r1/%r1 */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%rR/%r1/%rR */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%rR/%rR/%r0 */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%rR/%rR/%r1 */
    structuredvm_meta_instruction_id_pushr_mminusr_mpop_mstack, /* pushr-minusr-pop-stack/%rR/%rR/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/%r0/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/%r0/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/%r0/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/%r1/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/%r1/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/%r1/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/%rR/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/%rR/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/%rR/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/n2/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/n2/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/n2/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/nR/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/nR/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/nR/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/%r0/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/%r0/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/%r0/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/%r1/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/%r1/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/%r1/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/%rR/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/%rR/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/%rR/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/n2/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/n2/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/n2/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/nR/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/nR/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/nR/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/%r0/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/%r0/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/%r0/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/%r1/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/%r1/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/%r1/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/%rR/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/%rR/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/%rR/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/n2/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/n2/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/n2/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/nR/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/nR/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/nR/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/%r0/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/%r0/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/%r0/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/%r1/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/%r1/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/%r1/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/%rR/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/%rR/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/%rR/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/n2/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/n2/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/n2/%rR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/nR/%r0 */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/nR/%r1 */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/nR/%rR */
    structuredvm_meta_instruction_id_remainder_mstack, /* remainder-stack */
    structuredvm_meta_instruction_id_times, /* times/%r0/%r0/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r0/%r0/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r0/%r0/%rR */
    structuredvm_meta_instruction_id_times, /* times/%r0/%r1/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r0/%r1/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r0/%r1/%rR */
    structuredvm_meta_instruction_id_times, /* times/%r0/%rR/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r0/%rR/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r0/%rR/%rR */
    structuredvm_meta_instruction_id_times, /* times/%r0/n2/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r0/n2/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r0/n2/%rR */
    structuredvm_meta_instruction_id_times, /* times/%r0/nR/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r0/nR/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r0/nR/%rR */
    structuredvm_meta_instruction_id_times, /* times/%r1/%r0/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r1/%r0/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r1/%r0/%rR */
    structuredvm_meta_instruction_id_times, /* times/%r1/%r1/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r1/%r1/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r1/%r1/%rR */
    structuredvm_meta_instruction_id_times, /* times/%r1/%rR/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r1/%rR/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r1/%rR/%rR */
    structuredvm_meta_instruction_id_times, /* times/%r1/n2/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r1/n2/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r1/n2/%rR */
    structuredvm_meta_instruction_id_times, /* times/%r1/nR/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r1/nR/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r1/nR/%rR */
    structuredvm_meta_instruction_id_times, /* times/%rR/%r0/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%rR/%r0/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%rR/%r0/%rR */
    structuredvm_meta_instruction_id_times, /* times/%rR/%r1/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%rR/%r1/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%rR/%r1/%rR */
    structuredvm_meta_instruction_id_times, /* times/%rR/%rR/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%rR/%rR/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%rR/%rR/%rR */
    structuredvm_meta_instruction_id_times, /* times/%rR/n2/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%rR/n2/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%rR/n2/%rR */
    structuredvm_meta_instruction_id_times, /* times/%rR/nR/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%rR/nR/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%rR/nR/%rR */
    structuredvm_meta_instruction_id_times, /* times/nR/%r0/%r0 */
    structuredvm_meta_instruction_id_times, /* times/nR/%r0/%r1 */
    structuredvm_meta_instruction_id_times, /* times/nR/%r0/%rR */
    structuredvm_meta_instruction_id_times, /* times/nR/%r1/%r0 */
    structuredvm_meta_instruction_id_times, /* times/nR/%r1/%r1 */
    structuredvm_meta_instruction_id_times, /* times/nR/%r1/%rR */
    structuredvm_meta_instruction_id_times, /* times/nR/%rR/%r0 */
    structuredvm_meta_instruction_id_times, /* times/nR/%rR/%r1 */
    structuredvm_meta_instruction_id_times, /* times/nR/%rR/%rR */
    structuredvm_meta_instruction_id_times, /* times/nR/n2/%r0 */
    structuredvm_meta_instruction_id_times, /* times/nR/n2/%r1 */
    structuredvm_meta_instruction_id_times, /* times/nR/n2/%rR */
    structuredvm_meta_instruction_id_times, /* times/nR/nR/%r0 */
    structuredvm_meta_instruction_id_times, /* times/nR/nR/%r1 */
    structuredvm_meta_instruction_id_times, /* times/nR/nR/%rR */
    structuredvm_meta_instruction_id_times_mstack, /* times-stack */
    structuredvm_meta_instruction_id_uminus, /* uminus/%r0/%r0 */
    structuredvm_meta_instruction_id_uminus, /* uminus/%r0/%r1 */
    structuredvm_meta_instruction_id_uminus, /* uminus/%r0/%rR */
    structuredvm_meta_instruction_id_uminus, /* uminus/%r1/%r0 */
    structuredvm_meta_instruction_id_uminus, /* uminus/%r1/%r1 */
    structuredvm_meta_instruction_id_uminus, /* uminus/%r1/%rR */
    structuredvm_meta_instruction_id_uminus, /* uminus/%rR/%r0 */
    structuredvm_meta_instruction_id_uminus, /* uminus/%rR/%r1 */
    structuredvm_meta_instruction_id_uminus, /* uminus/%rR/%rR */
    structuredvm_meta_instruction_id_uminus, /* uminus/nR/%r0 */
    structuredvm_meta_instruction_id_uminus, /* uminus/nR/%r1 */
    structuredvm_meta_instruction_id_uminus, /* uminus/nR/%rR */
    structuredvm_meta_instruction_id_uminus_mstack, /* uminus-stack */
    structuredvm_meta_instruction_id_unreachable, /* unreachable */
    structuredvm_meta_instruction_id_b, /* *b/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/%r0/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/%r0/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/%r0/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/%r0/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/%r0/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/%r1/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/%r1/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/%r1/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/%r1/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/%r1/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/%rR/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/%rR/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/%rR/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/%rR/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/%rR/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/n0/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/n0/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/n0/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/n0/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/n0/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/nR/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/nR/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/nR/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/nR/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_be, /* *be/nR/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_beqi_mstack, /* *beqi-stack/n-1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_beqi_mstack, /* *beqi-stack/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_beqi_mstack, /* *beqi-stack/n1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_beqi_mstack, /* *beqi-stack/n2/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_beqi_mstack, /* *beqi-stack/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_beqr_mstack, /* *beqr-stack/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_beqr_mstack, /* *beqr-stack/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_beqr_mstack, /* *beqr-stack/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bf_mstack, /* *bf-stack/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/%r0/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/%r0/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/%r0/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/%r0/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/%r0/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/%r1/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/%r1/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/%r1/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/%r1/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/%r1/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/%rR/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/%rR/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/%rR/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/%rR/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/%rR/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/n0/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/n0/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/n0/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/n0/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/n0/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/nR/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/nR/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/nR/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/nR/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bg, /* *bg/nR/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/%r0/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/%r0/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/%r0/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/%r0/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/%r0/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/%r1/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/%r1/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/%r1/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/%r1/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/%r1/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/%rR/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/%rR/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/%rR/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/%rR/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/%rR/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/n0/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/n0/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/n0/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/n0/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/n0/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/nR/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/nR/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/nR/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/nR/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bge, /* *bge/nR/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bger_mstack, /* *bger-stack/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bger_mstack, /* *bger-stack/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bger_mstack, /* *bger-stack/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/%r0/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/%r0/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/%r0/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/%r0/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/%r0/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/%r1/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/%r1/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/%r1/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/%r1/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/%r1/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/%rR/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/%rR/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/%rR/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/%rR/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/%rR/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/n0/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/n0/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/n0/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/n0/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/n0/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/nR/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/nR/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/nR/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/nR/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bl, /* *bl/nR/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/%r0/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/%r0/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/%r0/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/%r0/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/%r0/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/%r1/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/%r1/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/%r1/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/%r1/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/%r1/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/%rR/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/%rR/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/%rR/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/%rR/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/%rR/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/n0/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/n0/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/n0/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/n0/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/n0/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/nR/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/nR/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/nR/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/nR/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_ble, /* *ble/nR/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/%r0/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/%r0/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/%r0/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/%r0/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/%r0/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/%r1/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/%r1/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/%r1/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/%r1/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/%r1/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/%rR/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/%rR/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/%rR/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/%rR/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/%rR/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/n0/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/n0/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/n0/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/n0/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/n0/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/nR/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/nR/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/nR/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/nR/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bne, /* *bne/nR/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bneqi_mstack, /* *bneqi-stack/n-1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bneqi_mstack, /* *bneqi-stack/n0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bneqi_mstack, /* *bneqi-stack/n1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bneqi_mstack, /* *bneqi-stack/n2/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bneqi_mstack, /* *bneqi-stack/nR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bneqr_mstack, /* *bneqr-stack/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bneqr_mstack, /* *bneqr-stack/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bneqr_mstack, /* *bneqr-stack/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_bt_mstack, /* *bt-stack/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_pushr_mbeqr_mstack, /* *pushr-beqr-stack/%r0/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_pushr_mbeqr_mstack, /* *pushr-beqr-stack/%r0/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_pushr_mbeqr_mstack, /* *pushr-beqr-stack/%r0/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_pushr_mbeqr_mstack, /* *pushr-beqr-stack/%r1/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_pushr_mbeqr_mstack, /* *pushr-beqr-stack/%r1/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_pushr_mbeqr_mstack, /* *pushr-beqr-stack/%r1/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_pushr_mbeqr_mstack, /* *pushr-beqr-stack/%rR/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_pushr_mbeqr_mstack, /* *pushr-beqr-stack/%rR/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_pushr_mbeqr_mstack, /* *pushr-beqr-stack/%rR/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_pushr_mbger_mstack, /* *pushr-bger-stack/%r0/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_pushr_mbger_mstack, /* *pushr-bger-stack/%r0/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_pushr_mbger_mstack, /* *pushr-bger-stack/%r0/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_pushr_mbger_mstack, /* *pushr-bger-stack/%r1/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_pushr_mbger_mstack, /* *pushr-bger-stack/%r1/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_pushr_mbger_mstack, /* *pushr-bger-stack/%r1/%rR/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_pushr_mbger_mstack, /* *pushr-bger-stack/%rR/%r0/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_pushr_mbger_mstack, /* *pushr-bger-stack/%rR/%r1/fR*-no-fast-branches */
    structuredvm_meta_instruction_id_pushr_mbger_mstack /* *pushr-bger-stack/%rR/%rR/fR*-no-fast-branches */
    };

#ifdef JITTER_HAVE_PATCH_IN
/* Worst-case defect table. */
const jitter_uint
structuredvm_worst_case_defect_table [] =
  {
    structuredvm_specialized_instruction_opcode__eINVALID, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eBEGINBASICBLOCK, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eEXITVM, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eDATALOCATIONS, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eNOP, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eUNREACHABLE0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eUNREACHABLE1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eUNREACHABLE2, /* NOT potentially defective. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Ab__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe___rr0___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe___rr0___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe___rr0___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe___rr0__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe___rr0__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe___rr1___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe___rr1___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe___rr1___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe___rr1__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe___rr1__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe___rrR___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe___rrR___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe___rrR___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe___rrR__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe___rrR__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe__n0___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe__n0___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe__n0___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe__n0__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe__n0__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe__nR___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe__nR___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe__nR___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe__nR__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abe__nR__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abeqi_mstack__n_m1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abeqi_mstack__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abeqi_mstack__n1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abeqi_mstack__n2__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abeqi_mstack__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abeqr_mstack___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abeqr_mstack___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abeqr_mstack___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abf_mstack__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg___rr0___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg___rr0___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg___rr0___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg___rr0__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg___rr0__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg___rr1___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg___rr1___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg___rr1___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg___rr1__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg___rr1__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg___rrR___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg___rrR___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg___rrR___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg___rrR__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg___rrR__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg__n0___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg__n0___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg__n0___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg__n0__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg__n0__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg__nR___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg__nR___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg__nR___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg__nR__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abg__nR__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge___rr0___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge___rr0___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge___rr0___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge___rr0__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge___rr0__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge___rr1___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge___rr1___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge___rr1___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge___rr1__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge___rr1__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge___rrR___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge___rrR___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge___rrR___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge___rrR__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge___rrR__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge__n0___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge__n0___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge__n0___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge__n0__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge__n0__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge__nR___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge__nR___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge__nR___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge__nR__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abge__nR__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abger_mstack___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abger_mstack___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abger_mstack___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl___rr0___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl___rr0___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl___rr0___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl___rr0__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl___rr0__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl___rr1___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl___rr1___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl___rr1___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl___rr1__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl___rr1__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl___rrR___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl___rrR___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl___rrR___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl___rrR__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl___rrR__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl__n0___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl__n0___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl__n0___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl__n0__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl__n0__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl__nR___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl__nR___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl__nR___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl__nR__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abl__nR__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able___rr0___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able___rr0___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able___rr0___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able___rr0__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able___rr0__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able___rr1___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able___rr1___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able___rr1___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able___rr1__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able___rr1__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able___rrR___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able___rrR___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able___rrR___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able___rrR__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able___rrR__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able__n0___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able__n0___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able__n0___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able__n0__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able__n0__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able__nR___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able__nR___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able__nR___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able__nR__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Able__nR__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne___rr0___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne___rr0___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne___rr0___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne___rr0__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne___rr0__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne___rr1___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne___rr1___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne___rr1___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne___rr1__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne___rr1__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne___rrR___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne___rrR___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne___rrR___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne___rrR__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne___rrR__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne__n0___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne__n0___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne__n0___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne__n0__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne__n0__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne__nR___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne__nR___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne__nR___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne__nR__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abne__nR__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abneqi_mstack__n_m1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abneqi_mstack__n0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abneqi_mstack__n1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abneqi_mstack__n2__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abneqi_mstack__nR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abneqr_mstack___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abneqr_mstack___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abneqr_mstack___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Abt_mstack__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    structuredvm_specialized_instruction_opcode_copy_mto_mr_mstack___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_copy_mto_mr_mstack___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_copy_mto_mr_mstack___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_different_mstack, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_differenti_mstack__n0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_differenti_mstack__n1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_differenti_mstack__n2, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_differenti_mstack__nR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided_mstack, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_drop_mstack, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_dup_mstack, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_equal_mstack, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_equali_mstack__n0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_equali_mstack__n1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_equali_mstack__n2, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_equali_mstack__nR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_exitvm, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_greater_mstack, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_greaterorequal_mstack, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_input___rr0__retR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_input___rr1__retR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_input___rrR__retR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_input_mstack__retR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_isnonzero_mstack, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_less_mstack, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_lessorequal_mstack, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_logicaland_mstack, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_logicalnot_mstack, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_logicalor_mstack, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0__n1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0__n1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0__n1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1__n1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1__n1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1__n1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR__n1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR__n1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR__n1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR__n1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR__n1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR__n1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus_mstack, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minusi_mstack__n1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minusi_mstack__n2, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minusi_mstack__nR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minusr_mstack___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minusr_mstack___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minusr_mstack___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n_m1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n_m1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n_m1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0__n1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0__n1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0__n1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1__n1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1__n1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1__n1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR__n1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR__n1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR__n1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR__n1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR__n1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR__n1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus_mstack, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plusi_mstack__n_m1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plusi_mstack__n1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plusi_mstack__n2, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plusi_mstack__nR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pop_mstack___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pop_mstack___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pop_mstack___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_print___rr0__retR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_print___rr1__retR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_print___rrR__retR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_print__nR__retR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_print_mstack__retR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mstack___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mstack___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mstack___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mstack__n0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mstack__n1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mstack__n_m1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mstack__n2, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mstack__nR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mstack__lR, /* NOT potentially defective. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Apushr_mbeqr_mstack___rr0___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Apushr_mbeqr_mstack___rr0___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Apushr_mbeqr_mstack___rr0___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Apushr_mbeqr_mstack___rr1___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Apushr_mbeqr_mstack___rr1___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Apushr_mbeqr_mstack___rr1___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Apushr_mbeqr_mstack___rrR___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Apushr_mbeqr_mstack___rrR___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Apushr_mbeqr_mstack___rrR___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Apushr_mbger_mstack___rr0___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Apushr_mbger_mstack___rr0___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Apushr_mbger_mstack___rr0___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Apushr_mbger_mstack___rr1___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Apushr_mbger_mstack___rr1___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Apushr_mbger_mstack___rr1___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Apushr_mbger_mstack___rrR___rr0__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Apushr_mbger_mstack___rrR___rr1__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    /*structuredvm_specialized_instruction_opcode__eINVALID*/structuredvm_specialized_instruction_opcode__Apushr_mbger_mstack___rrR___rrR__fR_A_mno_mfast_mbranches, /* POTENTIALLY DEFECTIVE. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rr0___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rr0___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rr0___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rr0___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rr0___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rr0___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rr0___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rr0___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rr0___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rr1___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rr1___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rr1___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rr1___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rr1___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rr1___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rr1___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rr1___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rr1___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rrR___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rrR___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rrR___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rrR___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rrR___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rrR___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rrR___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rrR___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pushr_mminusr_mpop_mstack___rrR___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder_mstack, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR__n2___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR__n2___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR__n2___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times_mstack, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus___rr0___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus___rr0___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus___rr0___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus___rr1___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus___rr1___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus___rr1___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus___rrR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus___rrR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus___rrR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus__nR___rr0, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus__nR___rr1, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus__nR___rrR, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus_mstack, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_unreachable, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Ab__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe___rr0___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe___rr0___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe___rr0___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe___rr0__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe___rr0__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe___rr1___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe___rr1___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe___rr1___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe___rr1__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe___rr1__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe___rrR___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe___rrR___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe___rrR___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe___rrR__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe___rrR__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe__n0___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe__n0___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe__n0___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe__n0__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe__n0__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe__nR___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe__nR___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe__nR___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe__nR__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abe__nR__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abeqi_mstack__n_m1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abeqi_mstack__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abeqi_mstack__n1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abeqi_mstack__n2__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abeqi_mstack__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abeqr_mstack___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abeqr_mstack___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abeqr_mstack___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abf_mstack__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg___rr0___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg___rr0___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg___rr0___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg___rr0__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg___rr0__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg___rr1___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg___rr1___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg___rr1___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg___rr1__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg___rr1__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg___rrR___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg___rrR___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg___rrR___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg___rrR__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg___rrR__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg__n0___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg__n0___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg__n0___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg__n0__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg__n0__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg__nR___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg__nR___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg__nR___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg__nR__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abg__nR__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge___rr0___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge___rr0___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge___rr0___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge___rr0__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge___rr0__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge___rr1___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge___rr1___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge___rr1___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge___rr1__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge___rr1__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge___rrR___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge___rrR___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge___rrR___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge___rrR__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge___rrR__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge__n0___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge__n0___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge__n0___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge__n0__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge__n0__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge__nR___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge__nR___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge__nR___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge__nR__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abge__nR__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abger_mstack___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abger_mstack___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abger_mstack___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl___rr0___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl___rr0___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl___rr0___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl___rr0__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl___rr0__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl___rr1___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl___rr1___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl___rr1___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl___rr1__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl___rr1__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl___rrR___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl___rrR___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl___rrR___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl___rrR__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl___rrR__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl__n0___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl__n0___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl__n0___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl__n0__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl__n0__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl__nR___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl__nR___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl__nR___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl__nR__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abl__nR__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able___rr0___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able___rr0___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able___rr0___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able___rr0__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able___rr0__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able___rr1___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able___rr1___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able___rr1___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able___rr1__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able___rr1__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able___rrR___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able___rrR___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able___rrR___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able___rrR__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able___rrR__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able__n0___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able__n0___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able__n0___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able__n0__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able__n0__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able__nR___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able__nR___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able__nR___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able__nR__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Able__nR__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne___rr0___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne___rr0___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne___rr0___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne___rr0__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne___rr0__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne___rr1___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne___rr1___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne___rr1___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne___rr1__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne___rr1__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne___rrR___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne___rrR___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne___rrR___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne___rrR__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne___rrR__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne__n0___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne__n0___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne__n0___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne__n0__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne__n0__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne__nR___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne__nR___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne__nR___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne__nR__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abne__nR__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abneqi_mstack__n_m1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abneqi_mstack__n0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abneqi_mstack__n1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abneqi_mstack__n2__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abneqi_mstack__nR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abneqr_mstack___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abneqr_mstack___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abneqr_mstack___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Abt_mstack__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Apushr_mbeqr_mstack___rr0___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Apushr_mbeqr_mstack___rr0___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Apushr_mbeqr_mstack___rr0___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Apushr_mbeqr_mstack___rr1___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Apushr_mbeqr_mstack___rr1___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Apushr_mbeqr_mstack___rr1___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Apushr_mbeqr_mstack___rrR___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Apushr_mbeqr_mstack___rrR___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Apushr_mbeqr_mstack___rrR___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Apushr_mbger_mstack___rr0___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Apushr_mbger_mstack___rr0___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Apushr_mbger_mstack___rr0___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Apushr_mbger_mstack___rr1___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Apushr_mbger_mstack___rr1___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Apushr_mbger_mstack___rr1___rrR__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Apushr_mbger_mstack___rrR___rr0__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Apushr_mbger_mstack___rrR___rr1__fR_A_mno_mfast_mbranches, /* NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__Apushr_mbger_mstack___rrR___rrR__fR_A_mno_mfast_mbranches /* NOT potentially defective. */
  };
#endif // #ifdef JITTER_HAVE_PATCH_IN


void
structuredvm_rewrite (struct jitter_mutable_routine *jitter_mutable_routine_p)
{
  JITTTER_REWRITE_FUNCTION_PROLOG_;

/* User-specified code, rewriter part: beginning. */

/* User-specified code, rewriter part: end */


//asm volatile ("\n# checking not-not--nothing");
//fprintf (stderr, "Trying rule 1 of 24, \"not-not--nothing\" (line 312)\n");
/* Rewrite rule "not-not--nothing" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, logicalnot_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, logicalnot_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule not-not--nothing (line 312) fires...\n");
    //fprintf (stderr, "  ...End of the rule not-not--nothing\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking not-bf--bt");
//fprintf (stderr, "Trying rule 2 of 24, \"not-bf--bt\" (line 313)\n");
/* Rewrite rule "not-bf--bt" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, logicalnot_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, bf_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule not-bf--bt (line 313) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction bt-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(bt_mstack);
    //fprintf (stderr, "    instantiating the 0-th argument of bt-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "  ...End of the rule not-bf--bt\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking not-bt--bf");
//fprintf (stderr, "Trying rule 3 of 24, \"not-bt--bf\" (line 314)\n");
/* Rewrite rule "not-bt--bf" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, logicalnot_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, bt_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule not-bt--bf (line 314) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction bf-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(bf_mstack);
    //fprintf (stderr, "    instantiating the 0-th argument of bf-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "  ...End of the rule not-bt--bf\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking less-not--greaterorequal");
//fprintf (stderr, "Trying rule 4 of 24, \"less-not--greaterorequal\" (line 315)\n");
/* Rewrite rule "less-not--greaterorequal" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, less_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, logicalnot_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule less-not--greaterorequal (line 315) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction greaterorequal-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(greaterorequal_mstack);
    //fprintf (stderr, "  ...End of the rule less-not--greaterorequal\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking lessorequal-not--greater");
//fprintf (stderr, "Trying rule 5 of 24, \"lessorequal-not--greater\" (line 316)\n");
/* Rewrite rule "lessorequal-not--greater" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, lessorequal_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, logicalnot_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule lessorequal-not--greater (line 316) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction greater-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(greater_mstack);
    //fprintf (stderr, "  ...End of the rule lessorequal-not--greater\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking greater-not--lessorequal");
//fprintf (stderr, "Trying rule 6 of 24, \"greater-not--lessorequal\" (line 317)\n");
/* Rewrite rule "greater-not--lessorequal" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, greater_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, logicalnot_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule greater-not--lessorequal (line 317) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction lessorequal-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(lessorequal_mstack);
    //fprintf (stderr, "  ...End of the rule greater-not--lessorequal\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking greaterorequal-not--less");
//fprintf (stderr, "Trying rule 7 of 24, \"greaterorequal-not--less\" (line 318)\n");
/* Rewrite rule "greaterorequal-not--less" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, greaterorequal_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, logicalnot_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule greaterorequal-not--less (line 318) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction less-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(less_mstack);
    //fprintf (stderr, "  ...End of the rule greaterorequal-not--less\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking pop-push--copytor");
//fprintf (stderr, "Trying rule 8 of 24, \"pop-push--copytor\" (line 319)\n");
/* Rewrite rule "pop-push--copytor" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, pop_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, push_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_REGISTER(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_REGISTER(1, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule pop-push--copytor (line 319) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction copy-to-r-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(copy_mto_mr_mstack);
    //fprintf (stderr, "    instantiating the 0-th argument of copy-to-r-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "  ...End of the rule pop-push--copytor\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-pop--");
//fprintf (stderr, "Trying rule 9 of 24, \"push-pop--\" (line 320)\n");
/* Rewrite rule "push-pop--" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, pop_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_REGISTER(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_REGISTER(1, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-pop-- (line 320) fires...\n");
    //fprintf (stderr, "  ...End of the rule push-pop--\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-pop--movr");
//fprintf (stderr, "Trying rule 10 of 24, \"push-pop--movr\" (line 321)\n");
/* Rewrite rule "push-pop--movr" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
    JITTER_RULE_DECLARE_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, pop_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_REGISTER(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_REGISTER(1, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, b)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
    JITTER_RULE_CLONE_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-pop--movr (line 321) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction mov\n");
    JITTER_RULE_APPEND_INSTRUCTION_(mov);
    //fprintf (stderr, "    instantiating the 0-th argument of mov\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "    instantiating the 1-th argument of mov\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(b)
                                 );
    //fprintf (stderr, "  ...End of the rule push-pop--movr\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
    JITTER_RULE_DESTROY_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-pop--movn");
//fprintf (stderr, "Trying rule 11 of 24, \"push-pop--movn\" (line 322)\n");
/* Rewrite rule "push-pop--movn" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
    JITTER_RULE_DECLARE_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, pop_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_REGISTER(1, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, b)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
    JITTER_RULE_CLONE_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-pop--movn (line 322) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction mov\n");
    JITTER_RULE_APPEND_INSTRUCTION_(mov);
    //fprintf (stderr, "    instantiating the 0-th argument of mov\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "    instantiating the 1-th argument of mov\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(b)
                                 );
    //fprintf (stderr, "  ...End of the rule push-pop--movn\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
    JITTER_RULE_DESTROY_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-plus--plusi");
//fprintf (stderr, "Trying rule 12 of 24, \"push-plus--plusi\" (line 323)\n");
/* Rewrite rule "push-plus--plusi" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, plus_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-plus--plusi (line 323) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction plusi-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(plusi_mstack);
    //fprintf (stderr, "    instantiating the 0-th argument of plusi-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "  ...End of the rule push-plus--plusi\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-minus--minusi");
//fprintf (stderr, "Trying rule 13 of 24, \"push-minus--minusi\" (line 324)\n");
/* Rewrite rule "push-minus--minusi" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, minus_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-minus--minusi (line 324) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction minusi-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(minusi_mstack);
    //fprintf (stderr, "    instantiating the 0-th argument of minusi-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "  ...End of the rule push-minus--minusi\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-equal--equali");
//fprintf (stderr, "Trying rule 14 of 24, \"push-equal--equali\" (line 327)\n");
/* Rewrite rule "push-equal--equali" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, equal_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-equal--equali (line 327) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction equali-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(equali_mstack);
    //fprintf (stderr, "    instantiating the 0-th argument of equali-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "  ...End of the rule push-equal--equali\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking equali-bt--beqi");
//fprintf (stderr, "Trying rule 15 of 24, \"equali-bt--beqi\" (line 328)\n");
/* Rewrite rule "equali-bt--beqi" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
    JITTER_RULE_DECLARE_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, equali_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, bt_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, b)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
    JITTER_RULE_CLONE_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule equali-bt--beqi (line 328) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction beqi-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(beqi_mstack);
    //fprintf (stderr, "    instantiating the 0-th argument of beqi-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "    instantiating the 1-th argument of beqi-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(b)
                                 );
    //fprintf (stderr, "  ...End of the rule equali-bt--beqi\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
    JITTER_RULE_DESTROY_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking equali-bf--bneqi");
//fprintf (stderr, "Trying rule 16 of 24, \"equali-bf--bneqi\" (line 329)\n");
/* Rewrite rule "equali-bf--bneqi" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
    JITTER_RULE_DECLARE_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, equali_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, bf_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, b)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
    JITTER_RULE_CLONE_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule equali-bf--bneqi (line 329) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction bneqi-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(bneqi_mstack);
    //fprintf (stderr, "    instantiating the 0-th argument of bneqi-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "    instantiating the 1-th argument of bneqi-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(b)
                                 );
    //fprintf (stderr, "  ...End of the rule equali-bf--bneqi\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
    JITTER_RULE_DESTROY_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-drop--");
//fprintf (stderr, "Trying rule 17 of 24, \"push-drop--\" (line 331)\n");
/* Rewrite rule "push-drop--" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, drop_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-drop-- (line 331) fires...\n");
    //fprintf (stderr, "  ...End of the rule push-drop--\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-push--push-dup");
//fprintf (stderr, "Trying rule 18 of 24, \"push-push--push-dup\" (line 332)\n");
/* Rewrite rule "push-push--push-dup" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, push_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-push--push-dup (line 332) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction push-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(push_mstack);
    //fprintf (stderr, "    instantiating the 0-th argument of push-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "    rewrite: adding instruction dup-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(dup_mstack);
    //fprintf (stderr, "  ...End of the rule push-push--push-dup\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-bf--b");
//fprintf (stderr, "Trying rule 19 of 24, \"push-bf--b\" (line 335)\n");
/* Rewrite rule "push-bf--b" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, bf_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_LITERAL_ARGUMENT(0, 0, 0)
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-bf--b (line 335) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction b\n");
    JITTER_RULE_APPEND_INSTRUCTION_(b);
    //fprintf (stderr, "    instantiating the 0-th argument of b\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "  ...End of the rule push-bf--b\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-bt--");
//fprintf (stderr, "Trying rule 20 of 24, \"push-bt--\" (line 337)\n");
/* Rewrite rule "push-bt--" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, bt_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_LITERAL_ARGUMENT(0, 0, 0)
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-bt-- (line 337) fires...\n");
    //fprintf (stderr, "  ...End of the rule push-bt--\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking plusi-minusi--");
//fprintf (stderr, "Trying rule 21 of 24, \"plusi-minusi--\" (line 339)\n");
/* Rewrite rule "plusi-minusi--" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, plusi_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, minusi_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule plusi-minusi-- (line 339) fires...\n");
    //fprintf (stderr, "  ...End of the rule plusi-minusi--\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking minusi-plusi--");
//fprintf (stderr, "Trying rule 22 of 24, \"minusi-plusi--\" (line 340)\n");
/* Rewrite rule "minusi-plusi--" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, minusi_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, plusi_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule minusi-plusi-- (line 340) fires...\n");
    //fprintf (stderr, "  ...End of the rule minusi-plusi--\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking plusi--");
//fprintf (stderr, "Trying rule 23 of 24, \"plusi--\" (line 341)\n");
/* Rewrite rule "plusi--" */
JITTER_RULE_BEGIN(1)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, plusi_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_LITERAL_ARGUMENT(0, 0, 0)
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule plusi-- (line 341) fires...\n");
    //fprintf (stderr, "  ...End of the rule plusi--\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking minusi--");
//fprintf (stderr, "Trying rule 24 of 24, \"minusi--\" (line 342)\n");
/* Rewrite rule "minusi--" */
JITTER_RULE_BEGIN(1)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, minusi_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_LITERAL_ARGUMENT(0, 0, 0)
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule minusi-- (line 342) fires...\n");
    //fprintf (stderr, "  ...End of the rule minusi--\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//fprintf (stderr, "No more rules to try\n");
}


//#include <jitter/jitter-fatal.h>

//#include <jitter/jitter.h>
//#include <jitter/jitter-instruction.h>
//#include <jitter/jitter-specialize.h>

//#include "structuredvm-vm.h"
//#include "structuredvm-meta-instructions.h"
//#include "structuredvm-specialized-instructions.h"


/* Recognizer function prototypes. */
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_b (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_b__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n_m1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n2__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqr_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqr_mstack___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqr_mstack___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqr_mstack___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqr_mstack___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqr_mstack___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqr_mstack___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bf_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bf_mstack__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bger_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bger_mstack___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bger_mstack___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bger_mstack___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bger_mstack___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bger_mstack___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bger_mstack___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n_m1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n2__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqr_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqr_mstack___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqr_mstack___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqr_mstack___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqr_mstack___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqr_mstack___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqr_mstack___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bt_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bt_mstack__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_copy_mto_mr_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_copy_mto_mr_mstack___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_copy_mto_mr_mstack___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_copy_mto_mr_mstack___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_different_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_differenti_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_differenti_mstack__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_differenti_mstack__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_differenti_mstack__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_differenti_mstack__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_drop_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_dup_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_equal_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_equali_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_equali_mstack__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_equali_mstack__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_equali_mstack__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_equali_mstack__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_exitvm (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_greater_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_greaterorequal_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_input (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_input___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_input___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_input___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_input_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_isnonzero_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_less_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_lessorequal_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_logicaland_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_logicalnot_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_logicalor_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minusi_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minusi_mstack__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minusi_mstack__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minusi_mstack__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minusr_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minusr_mstack___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minusr_mstack___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minusr_mstack___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n_m1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n_m1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n_m1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plusi_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plusi_mstack__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plusi_mstack__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plusi_mstack__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plusi_mstack__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pop_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pop_mstack___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pop_mstack___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pop_mstack___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_print (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_print___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_print___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_print___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_print__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_print_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack__lR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbeqr_mstack___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mbger_mstack___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr0___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr0___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr0___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr0___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr0___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr0___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr0___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr0___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr0___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr1___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr1___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr1___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr1___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr1___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr1___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr1___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr1___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rr1___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rrR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rrR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rrR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rrR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rrR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rrR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rrR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rrR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pushr_mminusr_mpop_mstack___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_unreachable (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));


/* Recognizer function definitions. */
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_b (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_b__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_b__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_b__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_be__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_be__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr1___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr1___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr1___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr1__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr1__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rrR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rrR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rrR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rrR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rrR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_be__n0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_be__n0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_be__n0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_be__n0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_be__n0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__n0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__n0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__n0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__n0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__n0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__n0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__n0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__n0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__n0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__n0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_be__nR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_be__nR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_be__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_be__nR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_be__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__nR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__nR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__nR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__nR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__nR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__nR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__nR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__nR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == -1 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__n_m1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 2 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__n2 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__n_m1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n_m1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_beqi_mstack__n_m1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_beqi_mstack__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_beqi_mstack__n1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__n2__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n2__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_beqi_mstack__n2__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_beqi_mstack__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqr_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_beqr_mstack___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_beqr_mstack___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_beqr_mstack___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqr_mstack___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_beqr_mstack___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqr_mstack___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_beqr_mstack___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqr_mstack___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_beqr_mstack___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqr_mstack___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_beqr_mstack___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqr_mstack___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_beqr_mstack___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqr_mstack___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_beqr_mstack___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bf_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bf_mstack__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bf_mstack__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bf_mstack__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr1___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr1___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr1___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr1__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr1__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rrR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rrR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rrR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rrR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rrR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__n0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__n0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__n0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__n0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__n0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__nR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__nR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__nR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__nR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__nR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr1___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr1___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr1___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr1__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr1__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rrR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rrR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rrR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rrR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rrR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__n0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__n0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__n0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__n0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__n0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__nR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__nR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__nR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__nR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__nR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bger_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bger_mstack___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bger_mstack___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bger_mstack___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bger_mstack___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bger_mstack___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bger_mstack___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bger_mstack___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bger_mstack___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bger_mstack___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bger_mstack___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bger_mstack___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bger_mstack___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bger_mstack___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bger_mstack___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bger_mstack___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr1___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr1___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr1___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr1__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr1__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rrR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rrR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rrR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rrR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rrR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__n0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__n0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__n0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__n0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__n0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__nR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__nR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__nR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__nR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__nR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr1___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr1___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr1___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr1__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr1__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rrR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rrR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rrR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rrR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rrR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__n0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__n0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__n0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__n0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__n0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__nR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__nR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__nR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__nR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__nR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bne___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bne__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bne__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rr0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rr0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rr0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rr0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rr0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr1___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr1___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr1__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr1___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rr1___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr1___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rr1___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rr1___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr1__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rr1__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr1__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rr1__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bne___rrR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bne___rrR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bne___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bne___rrR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bne___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rrR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rrR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rrR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rrR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rrR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rrR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rrR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rrR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bne__n0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bne__n0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bne__n0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bne__n0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bne__n0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne__n0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne__n0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne__n0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne__n0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne__n0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne__n0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne__n0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne__n0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne__n0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne__n0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bne__nR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bne__nR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bne__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bne__nR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bne__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne__nR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne__nR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne__nR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne__nR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne__nR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne__nR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne__nR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne__nR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == -1 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bneqi_mstack__n_m1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bneqi_mstack__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bneqi_mstack__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 2 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bneqi_mstack__n2 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bneqi_mstack__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bneqi_mstack__n_m1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n_m1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bneqi_mstack__n_m1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bneqi_mstack__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bneqi_mstack__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bneqi_mstack__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bneqi_mstack__n1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bneqi_mstack__n2__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n2__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bneqi_mstack__n2__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bneqi_mstack__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bneqi_mstack__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqr_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bneqr_mstack___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bneqr_mstack___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bneqr_mstack___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqr_mstack___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bneqr_mstack___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqr_mstack___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bneqr_mstack___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqr_mstack___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bneqr_mstack___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqr_mstack___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bneqr_mstack___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqr_mstack___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bneqr_mstack___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqr_mstack___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bneqr_mstack___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bt_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bt_mstack__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bt_mstack__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bt_mstack__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_copy_mto_mr_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_copy_mto_mr_mstack___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_copy_mto_mr_mstack___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_copy_mto_mr_mstack___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_copy_mto_mr_mstack___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_copy_mto_mr_mstack___rr0;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_copy_mto_mr_mstack___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_copy_mto_mr_mstack___rr1;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_copy_mto_mr_mstack___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_copy_mto_mr_mstack___rrR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_different_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_different_mstack;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_differenti_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_differenti_mstack__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_differenti_mstack__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 2 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_differenti_mstack__n2 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_differenti_mstack__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_differenti_mstack__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_differenti_mstack__n0;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_differenti_mstack__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_differenti_mstack__n1;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_differenti_mstack__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_differenti_mstack__n2;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_differenti_mstack__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_differenti_mstack__nR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_divided___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_divided___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_divided___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_divided__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_divided___rr0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_divided___rr0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_divided___rr0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 2 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_divided___rr0__n2 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_divided___rr0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_divided___rr0___rr0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_divided___rr0___rr0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_divided___rr0___rr0___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_divided___rr0___rr0___rr0;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_divided___rr0___rr0___rr1;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_divided___rr0___rr0___rrR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_divided___rr0___rr1___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_divided___rr0___rr1___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_divided___rr0___rr1___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_divided___rr0___rr1___rr0;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_divided___rr0___rr1___rr1;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefi