/*  Motti -- a strategy game
    Copyright (C) 1999 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <getopt.h>

#include "xinit.h"
#include "xwin.h"
#include "xevent.h"
#include "wrappers.h"

static void
help_msg ()
{
  puts ("Usage: motti map-file [OPTIONS]\n");
  puts ("  -d, --display display	set display for X");
  puts ("  -g, --geometry geometry	set geometry");
  puts ("  -n, --no-windows		prohibit the use of X");
  puts ("  -m, --mono			do not use color");
  puts ("      --help			display this help and exit");
  puts ("      --version		output version information and exit");
  puts ("Report bugs to bug-motti@gnu.org");
  exit (0);
}

static void
version_msg ()
{
  printf ("Motti %s\n", VERSION);
  puts ("Copyright (C) 1999 Free Software Foundation, Inc.");
  puts ("Motti comes with NO WARRANTY,");
  puts ("to the extent permitted by law.");
  puts ("You may redistribute copies of Motti");
  puts ("under the terms of the GNU General Public License.");
  puts ("For more information about these matters,");
  puts ("see the files named COPYING.");
  exit (0);
}

/*static void
remove_first_arg (argc, argv)
     int argc;
     char **argv[];
{
  register int i;
  for (i = 1; i < argc; i++)
    *argv[i] = *argv[i+1];
  *argv[i] = "";
}*/

int
main (argc, argv)
     int argc;
     char *argv[];
{
  char *status_msg, *display_name = (char *) NULL;
  char def_map_name[] = "map";
  int use_x = 1, color = 1;

  while (1)
    {
      int c;
      const struct option long_options[] =
      {
	{"display", 1, 0, 'd'},
	{"geometry", 1, 0, 'g'},
	{"no-windows", 0, 0, 'n'},
	{"mono", 0, 0, 'm'},
	{"help", 0, 0, 1000},
	{"version", 0, 0, 1001}
      };

      c = getopt_long (argc, argv, "d:g:nm",
		       long_options, (int *) NULL);
      if (c == -1)
	break;

      switch (c)
	{
	case 'd':
	  display_name = optarg;
	  break;
	case 'g':
	  db_val_tab.geom_str = optarg;
	  break;
	case 'n':
	  use_x = 0;
	  break;
	case 'm':
	  color = 0;
	  break;
	case 1000:
	  help_msg ();
	case 1001:
	  version_msg ();
	}
    }
  /* Use default map if no map specified.  */
  status_msg = load_map (optind < argc ? argv[optind] : def_map_name);
  if (status_msg)
    die (status_msg);

  srand (time ((time_t *) NULL));

  puts ("motti 0.1");
  puts ("Copyright 1999 Free Software Foundation, Inc.");
  puts ("This is free software with ABSOLUTELY NO WARRANTY.");
  puts ("For details read file 'COPYING'.");

  if (use_x)
    {
      /* Search for display name in files.  */
      
      if (open_display (display_name))
	{
	  atexit (kill_x);
	  create_DB ();
	  if (color)
	    color = alloc_colors ();
	  if (!color)
	    die ("no color");
	  open_windows (argc, argv);
	  //create_cursors ();
	  event_loop ();
	}
      else
	{
	  die (alloc_err_str (ERR_NOX, display_name));
	}
    }
  /* Use text mode.  */
  die ("text mode not implemented");
  return 0;
}
