/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ClassFile;
import gnu.jel.OPfunction;
import gnu.jel.OPlist;
import gnu.jel.OPload;
import gnu.jel.TypesStack;
import gnu.jel.debug.Debug;
import gnu.jel.reflect.Method;

public class OPunary
extends OPfunction {
    protected int code;
    private boolean str_to_tsb = false;
    private boolean tsb_to_str = false;
    private static Method sb_constructor;
    private static Method sb_toString;
    protected static Class sb_class;
    protected static Class string_class;
    protected static final int[] unary_prmtns;
    private static final int[][] una;
    private static final String[] opSymbols;
    private static final String[] opNames;

    public OPunary(TypesStack typesStk, int code) throws IllegalStateException {
        Debug.assert(code >= 0 && code <= 3);
        if (code == 3) {
            code = 12;
        }
        this.code = code;
        int opTypeID = typesStk.peekID();
        if (una[code][opTypeID] == 255) {
            throw new IllegalStateException("The '" + opNames[code] + "' operation " + "is not supported on " + TypesStack.primitiveTypeNames[opTypeID] + "s");
        }
        typesStk.pop();
        if (code != 12) {
            this.resID = unary_prmtns[opTypeID];
            typesStk.pushID(this.resID, null);
        } else {
            this.resID = opTypeID;
        }
    }

    public OPunary(TypesStack typesStk, int clsID, Class cls, boolean allownarrowing) {
        Debug.assert(clsID >= 0 && clsID <= 8 && (clsID != 8 || cls != null));
        this.code = clsID + 3;
        this.resID = clsID;
        Class currentClass = typesStk.peek();
        if (clsID == 8) {
            this.str_to_tsb = TypesStack.isString(currentClass) && TypesStack.isTSB(cls);
            this.tsb_to_str = TypesStack.isString(cls) && TypesStack.isTSB(currentClass);
            this.resType = cls;
        } else {
            this.resType = TypesStack.primitiveTypes[this.resID];
        }
        if (una[this.code][typesStk.peekID()] == 255) {
            throw new IllegalStateException("Can not convert " + typesStk.peek() + " to " + this.resType + " .");
        }
        if (!allownarrowing && !TypesStack.isWidening(currentClass, this.resType)) {
            throw new IllegalStateException("You must specify narrowing conversion from " + typesStk.peek() + " to " + this.resType + " explicitly.");
        }
        typesStk.pop();
        typesStk.pushID(this.resID, this.resType);
    }

    public OPunary(TypesStack typesStk, Class cls, boolean allownarrowing) {
        this(typesStk, TypesStack.primitiveID(cls), cls, allownarrowing);
    }

    public int getNParams() {
        return 1;
    }

    protected void compile_pre(ClassFile cf) {
        if (this.code == 2) {
            cf.labels_block();
        }
        if (this.str_to_tsb) {
            cf.code(187);
            cf.codeI(cf.getIndex(sb_class, 9));
            cf.code(89);
            cf.typesStk.pushID(8, sb_class);
            cf.typesStk.pushID(8, sb_class);
        }
    }

    protected void compile(ClassFile cf) {
        if (this.str_to_tsb) {
            cf.code(183);
            cf.codeI(cf.getIndex(sb_constructor, 10));
            cf.typesStk.pop();
            cf.typesStk.pop();
        } else if (this.tsb_to_str) {
            cf.code(182);
            cf.codeI(cf.getIndex(sb_toString, 10));
            cf.typesStk.pop();
            cf.typesStk.pushID(8, string_class);
        } else if (this.code == 2) {
            cf.labels_unblock_not();
        } else {
            cf.ensure_value();
            cf.code(una[this.code][cf.typesStk.peekID()]);
            if (this.code == 1) {
                cf.typesStk.tempExcessWords(TypesStack.stkoccup[this.resID]);
            } else if (this.code == 11) {
                cf.codeI(cf.getIndex(this.resType, 9));
            }
            cf.typesStk.pop();
            if (this.code != 12) {
                cf.typesStk.pushID(this.resID, this.resType);
            }
        }
    }

    protected void eval(OPlist list) {
        if (this.code == 12) {
            return;
        }
        if (!(this.prev instanceof OPload)) {
            return;
        }
        OPload opl = (OPload)this.prev;
        if (this.code == 2) {
            opl.what = ((Boolean)opl.what).booleanValue() ? Boolean.FALSE : Boolean.TRUE;
        } else if (this.code < 2) {
            Number val = TypesStack.widen(opl.what, opl.resID);
            switch (this.code) {
                case 0: {
                    if (opl.resID > 5) {
                        val = new Double(-val.doubleValue());
                        break;
                    }
                    val = new Long(-val.longValue());
                    break;
                }
                case 1: {
                    val = new Long(val.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                    break;
                }
                default: {
                    Debug.assert(this.code >= 0, "Wrong unary opcode.");
                }
            }
            opl.what = TypesStack.narrow(val, this.resID);
            opl.resID = this.resID;
        } else if (opl.resID != this.resID) {
            opl.what = TypesStack.narrow(TypesStack.widen(opl.what, opl.resID), this.resID);
            opl.resID = this.resID;
        } else if (this.code == 11) {
            if (this.tsb_to_str) {
                opl.what = opl.what.toString();
            }
            if (this.str_to_tsb) {
                opl.what = new StringBuffer((String)opl.what);
            }
        }
        list.remove(this);
    }

    public String toString() {
        if (this.str_to_tsb) {
            return "->TSB";
        }
        if (this.tsb_to_str) {
            return "TSB->";
        }
        return opSymbols[this.code];
    }

    static {
        try {
            sb_class = Class.forName("java.lang.StringBuffer");
            string_class = Class.forName("java.lang.String");
            Class[] params = new Class[]{string_class};
            sb_constructor = new Method(sb_class.getConstructor(params));
            params = new Class[]{};
            sb_toString = new Method(sb_class.getMethod("toString", params));
        }
        catch (Exception e) {
            Debug.reportThrowable(e);
        }
        unary_prmtns = new int[]{0, 4, 4, 4, 4, 5, 6, 7, 8, 9};
        una = new int[][]{{116, 116, 255, 116, 116, 117, 118, 119, 255, 255}, {255, 33282, 33282, 33282, 33282, 8619266, 255, 255, 255, 255}, {0, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {0, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {145, 0, 145, 145, 145, 37256, 37259, 37262, 255, 255}, {146, 146, 0, 146, 146, 37512, 37515, 37518, 255, 255}, {147, 147, 147, 0, 147, 37768, 37771, 37774, 255, 255}, {0, 0, 0, 0, 0, 136, 139, 142, 255, 255}, {133, 133, 133, 133, 133, 0, 140, 143, 255, 255}, {134, 134, 134, 134, 134, 137, 0, 144, 255, 255}, {135, 135, 135, 135, 135, 138, 141, 0, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 192, 255}, {172, 172, 172, 172, 172, 173, 174, 175, 176, 177}};
        opSymbols = new String[]{"--", "~", "!", "(Z)", "(B)", "(C)", "(S)", "(I)", "(J)", "(F)", "(D)", "(L)", "<RET>"};
        opNames = new String[]{"negation", "bitwise inversion", "logical inversion", "cast to boolean", "cast to byte", "cast to char", "cast to short", "cast to int", "cast to long", "cast to float", "cast to double", "cast to reference", "return"};
        Debug.assert(opNames.length == opSymbols.length && opNames.length == una.length);
    }
}

