/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * WARNING: This file is automatically generated by
 * generate_GrFreqXlatingFIRfilterXXX.py Any changes made to this file
 * will be overwritten.
 */

#ifndef _GrFreqXlatingFIRfilterSCF_H_
#define	_GrFreqXlatingFIRfilterSCF_H_

#include <VrDecimatingSigProc.h>
#include <VrComplex.h>
#include <gr_fir_builderF.h>
#include <gr_rotator.h>
#include <vector>

class gr_fir_SCC;

/*!
 * \brief FIR filter combined with frequency translation with short input, VrComplex output and float taps
 *
 * This class efficiently combines a frequency translation
 * (typically "down conversion") with a FIR filter (typically low-pass)
 * and decimation.  It is ideally suited for a "channel selection filter"
 * and can be efficiently used to select and decimate a narrow band signal
 * out of wide bandwidth input.
 *
 * Uses a single input array to produce a single output array.
 * Additional inputs and/or outputs are ignored.
 */

class GrFreqXlatingFIRfilterSCF : public VrDecimatingSigProc<short, VrComplex>
{
 public:
  /*!
   * Construct a FIR filter with the given taps and a composite frequency
   * translation that shifts center_freq down to zero Hz.  The frequency 
   * translation logically comes before the filtering operation.
   */
  GrFreqXlatingFIRfilterSCF (int decimation_factor,
			  const std::vector<float> &taps,
			  float center_freq);

  /*!
   * Construct a FIR filter where the taps will be determined
   * at initialization time by invoking builder->taps (sampling_freq).
   * The resulting filter will be preceeded by a frequency translation 
   * that shifts center_freq down to zero Hz.
   *
   * GrFreqXlatingFIRfilterSCF becomes responsible for life time management
   * of builder.
   */
  GrFreqXlatingFIRfilterSCF (int decimation_factor,
			  gr_fir_builderF *builder,
			  float center_freq);

  virtual ~GrFreqXlatingFIRfilterSCF ();

  virtual const char *name () { return "GrFreqXlatingFIRfilterSCF"; }
  virtual void initialize ();
  virtual int work (VrSampleRange output, void *o[],
		    VrSampleRange inputs[], void *i[]);

  void setCenterFreq (float center_freq);
  void setTaps (const std::vector<float> &taps);

 protected:
  gr_fir_builderF		       *d_builder;
  std::vector<float>	d_proto_taps;
  gr_fir_SCC		       *d_composite_fir;
  gr_rotator			d_r;
  float				d_center_freq;
  int				d_updated;

  virtual void build_composite_fir ();
};

#endif /* _GrFreqXlatingFIRfilterSCF_H_ */
