/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pki.provider;

import gnu.crypto.der.BitString;
import gnu.crypto.der.DERValue;
import gnu.crypto.der.OID;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

public class GnuDHPublicKey
implements DHPublicKey {
    private byte[] encoded;
    private final DHParameterSpec params;
    private final BigInteger Y;
    private final BigInteger q;

    public BigInteger getY() {
        return this.Y;
    }

    public DHParameterSpec getParams() {
        return this.params;
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        if (this.encoded != null) {
            return (byte[])this.encoded.clone();
        }
        ArrayList<DERValue> spki = new ArrayList<DERValue>(2);
        ArrayList<DERValue> alg = new ArrayList<DERValue>(2);
        alg.add(new DERValue(6, new OID("1.2.840.10046.2.1")));
        ArrayList<DERValue> param = new ArrayList<DERValue>(3);
        param.add(new DERValue(2, this.params.getP()));
        param.add(new DERValue(2, this.params.getG()));
        param.add(new DERValue(2, this.q));
        alg.add(new DERValue(48, param));
        spki.add(new DERValue(48, alg));
        spki.add(new DERValue(3, new BitString(this.Y.toByteArray())));
        this.encoded = new DERValue(48, spki).getEncoded();
        if (this.encoded != null) {
            return (byte[])this.encoded.clone();
        }
        return null;
    }

    public GnuDHPublicKey(DHParameterSpec params, BigInteger Y, BigInteger q) {
        this.params = params;
        this.Y = Y;
        this.q = q;
    }
}

