$!
$! This command file creates a VMSINSTAL-able distribution of GCC.  The
$! kit is written to the device pointed to by the logical name "dist".
$! The version should be a 3 digit number, two major, and one minor.
$! (VMSINSTAL restriction).
$!
$! In order to do this, you need a tar writer that runs on VMS.  VMSINSTAL
$! unpacks all of the files into one directory (losing the directory 
$! structure).  I could have nested backup save-sets, but this is a waste
$! of space.  Tar is much more efficient.
$!
$! This procedure assumes that the files are layed out in the directory 
$! tree structure with subdirectories bison, gcc-src, and gcc.  It assumes
$! that kitinstal.com is in the current directory.
$!
$ define dist $diska:[eric]
$vers:=014
$!
$!
$tarwrite:=$tarwrite
$assign [-]gcc-src.tar tape
$set def [.gcc-src]
$tarwrite cv
$assign [--]gcc-include.tar tape
$set def [-.gcc.include]
$tarwrite cv
$set def [--]
$deassign tape
$!
$!
$backup_flag := /block=8192
$!
$if f$getdvi("dist","devclass").ne.2 then goto noinit
$! initialize the dist
$init dist gcc
$ mount /foreign dist:
$backup_flag := /verify/label=""GCC""
$noinit:
$backup/interchange 'backup_flag' kitinstal.com; dist:gcc'vers'.a/save
$backup/interchange 'backup_flag'   -
	[.gcc]*.*;,[]gcc-src.tar,[]gcc-include.tar, -
	[]tarread.exe; dist:gcc'vers'.b/save
$backup/interchange 'backup_flag'   [.bison]*.*; dist:gcc'vers'.c/save
$if f$getdvi("dist","devclass").eq.2 then dismount dist:
$!
$! Now clean up a little
$!
$delete gcc-src.tar;/nolog
$delete gcc-include.tar;/nolog
$exit
