// $G -S $D/$F.go | egrep initdone >/dev/null && echo FAIL || true

// Copyright 2010 The Go Authors.  All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package p

// Should be no init func in the assembly.
// All these initializations should be done at link time.

type	S	struct{ a,b,c int }
type	SS	struct{ aa,bb,cc S }
type	SA	struct{ a,b,c [3]int }
type	SC	struct{ a,b,c []int }

var (
	zero = 2
	one = 1
	pi = 3.14
	slice = []byte{1,2,3}
	sliceInt = []int{1,2,3}
	hello = "hello, world"
	bytes = []byte("hello, world")
	four, five = 4, 5
	x, y = 0.1, "hello"
	nilslice []byte = nil
	nilmap map[string]int = nil
	nilfunc func() = nil
	nilchan chan int = nil
	nilptr *byte = nil
)

var	a	= [3]int{1001, 1002, 1003}
var	s	= S{1101, 1102, 1103}
var	c	= []int{1201, 1202, 1203}

var	aa	= [3][3]int{[3]int{2001,2002,2003}, [3]int{2004,2005,2006}, [3]int{2007,2008,2009}}
var	as	= [3]S{S{2101,2102,2103},S{2104,2105,2106},S{2107,2108,2109}}
var	ac	= [3][]int{[]int{2201,2202,2203}, []int{2204,2205,2206}, []int{2207,2208,2209}}

var	sa	= SA{[3]int{3001,3002,3003},[3]int{3004,3005,3006},[3]int{3007,3008,3009}}
var	ss	= SS{S{3101,3102,3103},S{3104,3105,3106},S{3107,3108,3109}}
var	sc	= SC{[]int{3201,3202,3203},[]int{3204,3205,3206},[]int{3207,3208,3209}}

var	ca	= [][3]int{[3]int{4001,4002,4003}, [3]int{4004,4005,4006}, [3]int{4007,4008,4009}}
var	cs	= []S{S{4101,4102,4103},S{4104,4105,4106},S{4107,4108,4109}}
var	cc	= [][]int{[]int{4201,4202,4203}, []int{4204,4205,4206}, []int{4207,4208,4209}}

var	answers	= [...]int {
	// s
	1101, 1102, 1103,

	// ss
	3101, 3102, 3103,
	3104, 3105, 3106,
	3107, 3108, 3109,

	// [0]
	1001, 1201, 1301,
	2101, 2102, 2103,
	4101, 4102, 4103,
	5101, 5102, 5103,
	3001, 3004, 3007,
	3201, 3204, 3207,
	3301, 3304, 3307,

	// [0][j]
	2001, 2201, 2301, 4001, 4201, 4301, 5001, 5201, 5301,
	2002, 2202, 2302, 4002, 4202, 4302, 5002, 5202, 5302,
	2003, 2203, 2303, 4003, 4203, 4303, 5003, 5203, 5303,

	// [1]
	1002, 1202, 1302,
	2104, 2105, 2106,
	4104, 4105, 4106,
	5104, 5105, 5106,
	3002, 3005, 3008,
	3202, 3205, 3208,
	3302, 3305, 3308,

	// [1][j]
	2004, 2204, 2304, 4004, 4204, 4304, 5004, 5204, 5304,
	2005, 2205, 2305, 4005, 4205, 4305, 5005, 5205, 5305,
	2006, 2206, 2306, 4006, 4206, 4306, 5006, 5206, 5306,

	// [2]
	1003, 1203, 1303,
	2107, 2108, 2109,
	4107, 4108, 4109,
	5107, 5108, 5109,
	3003, 3006, 3009,
	3203, 3206, 3209,
	3303, 3306, 3309,

	// [2][j]
	2007, 2207, 2307, 4007, 4207, 4307, 5007, 5207, 5307,
	2008, 2208, 2308, 4008, 4208, 4308, 5008, 5208, 5308,
	2009, 2209, 2309, 4009, 4209, 4309, 5009, 5209, 5309,
}
