/*
  Graphical IDF Wizard
  Copyright (C) 1998,1999,2002,2005,2010 David Martnez Oliveira

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  
 */
/* Revisions:
 * November, 17th, 2001
 * Compile warnning removal and code cleanup
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>
//#include <gnome.h>
#include <gtk/gtk.h>
#include <edma.h>

#include "propform.h"

#define NETYPES   16
#define NEACCESS  3

EPChar   e_types[]={"EUINT32",
		    "ESINT32",
		    "EUINT16",
		    "ESINT16",
		    "EUINT8",
		    "ESINT8",
		    "EBYTE",
		    "EWORD",
		    "EDWORD",
		    "ECHAR",
		    "EBOOL",
		    "EREAL32",
		    "EREAL64",
		    "EZSTRING",
		    "EBUFFER",
		    "EOBJECT"};

EPChar     e_access[]={"READ/WRITE",
		       "READ",
		       "WRITE"};

void 
prop_click( GtkWidget *clist, gint row, gint column,
	    GdkEventButton *event, gpointer data)
{
  gchar           text[80];
  gchar           *aux;
  EChar           name[80], type[40], access[20], array[20];
  gchar           *prop_data[] = {name, type, access, array};
  PropertyWidgets *gw;

  gw = (PropertyWidgets*) data;
  gw->actual = row;
  printf ("\nselected %d superclass to add", row);
  
  /* Update widgets contents */
  gtk_clist_get_text (GTK_CLIST(clist), row, 0, &aux);
  gtk_entry_set_text (GTK_ENTRY(gw->Name), aux);
  gtk_clist_get_text (GTK_CLIST(clist), row, 1, &aux);
  gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(gw->Type)->entry), aux);
  gtk_clist_get_text (GTK_CLIST(clist), row, 2, &aux);
  gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(gw->Access)->entry), aux);
  gtk_clist_get_text (GTK_CLIST(clist), row, 3, &aux);
  gtk_entry_set_text (GTK_ENTRY(gw->Array), aux);

}

void 
Prop_add_click( GtkWidget *bot, gpointer data)
{
  EPChar          text;
  EUint32         n,i;
  PropertyWidgets *gw;
  EChar           name[80], type[40], access[20], array[20];
  const gchar     *aux;
  gchar           *prop_data[] = {name, type, access, array};
  gchar           *met_data[] = {name, type, array};

  gw = (PropertyWidgets*) data;

  aux = gtk_entry_get_text (GTK_ENTRY(gw->Name));
  strcpy (name, aux);

  aux = gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(gw->Type)->entry));
  strcpy (type, aux);

  aux = gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(gw->Access)->entry));
  strcpy (access, aux);

  aux = gtk_entry_get_text (GTK_ENTRY(gw->Array));
  strcpy (array, aux);

  gtk_clist_append (GTK_CLIST(gw->the_list), prop_data); 
  /* Store data in the props field */
  strcpy (gw->props[gw->n].Name, name);
  for (i = 0; i < NETYPES; i++)
    if (strcmp (type, e_types[i]) == 0)
      break;
  if (i == NETYPES)
    printf ("ERROR!!! type %s not exists", type);

  gw->props[gw->n].Type = i;
  for (i = 0; i < NEACCESS; i++)
    if (strcmp (access, e_access[i]) == 0)
      break;
  if (i == NEACCESS)
    printf ("ERROR!!! access %s not exists", access);
  gw->props[gw->n].Access = i;
  gw->props[gw->n].Array = atoi(array);
  gw->n++;

}

void 
Prop_set_click( GtkWidget *bot, gpointer data)
{
  EPChar          text;
  EUint32         n, i;
  PropertyWidgets *gw;
  EChar           name[80], type[40], access[20], array[20];
  const gchar     *aux;
  gchar           *prop_data[]={name, type, access, array};
  gchar           *met_data[] = {name, type, array};


  gw = (PropertyWidgets*) data;

  aux = gtk_entry_get_text (GTK_ENTRY(gw->Name));
  strcpy (name, aux);

  aux = gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(gw->Type)->entry));
  strcpy (type, aux);

  aux = gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(gw->Access)->entry));
  strcpy (access, aux);

  aux = gtk_entry_get_text (GTK_ENTRY(gw->Array));
  strcpy (array, aux);

  /* Store data in the props field */
  strcpy (gw->props[gw->actual].Name, name);

  for (i = 0; i < NETYPES; i++)
    if (strcmp (type, e_types[i]) == 0)
      break;
  if (i == NETYPES)
    printf ("ERROR!!! type %s not exists", type);
  gw->props[gw->actual].Type = i;


  for (i = 0; i < NEACCESS; i++)
    if (strcmp (access, e_access[i]) == 0)
      break;
  if (i == NEACCESS)
    printf ("ERROR!!! access %s not exists", access);

  printf ("\n Access mode %d (%s)",i,e_access[i]);

  gw->props[gw->actual].Access = i;
  gw->props[gw->actual].Array = atoi(array);

  gtk_clist_set_text (GTK_CLIST(gw->the_list), gw->actual, 0, name);
  gtk_clist_set_text (GTK_CLIST(gw->the_list), gw->actual, 1, type);
  gtk_clist_set_text (GTK_CLIST(gw->the_list), gw->actual, 2, access);
  gtk_clist_set_text (GTK_CLIST(gw->the_list), gw->actual, 3, array);

}

void 
Prop_del_click( GtkWidget *bot, gpointer data)
{
  
  EPChar          text;
  EUint32         n,i;
  PropertyWidgets *gw;


  gw = (PropertyWidgets*) data;
  gtk_clist_remove (GTK_CLIST(gw->the_list), gw->actual);
  for (i = gw->actual; i < gw->n; i++)
    gw->props[i] = gw->props[i + 1];
  gw->n--;
  
}

ESint32 
InitPropForm (PropertyWidgets *gw)
{
  EUint32 i;

  gw->build_form = BuildPropForm;
  /* Init lists */
  gw->types = NULL;
  for (i = 0; i < NETYPES; i++)
    gw->types = g_list_append (gw->types, e_types[i]);

  gw->access_mode = NULL;
  for (i = 0; i < 3; i++)
    gw->access_mode = g_list_append (gw->access_mode, e_access[i]);

  return 0;
}

ESint32 
BuildPropForm (PropertyWidgets *gw,GtkWidget *note)
{   
  GtkWidget *label, *aux, *swindow, *box;

  /* General Info Page */
  gw->table = gtk_table_new (1, 3, TRUE);

  swindow = gtk_scrolled_window_new  (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swindow),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
  gw->the_list = gtk_clist_new (4);
  
  gtk_clist_set_column_title (GTK_CLIST(gw->the_list), 0, "Name");
  gtk_clist_set_column_width (GTK_CLIST(gw->the_list), 0, 100);
  gtk_clist_set_column_title (GTK_CLIST(gw->the_list), 1, "Type");
  gtk_clist_set_column_width (GTK_CLIST(gw->the_list), 1, 60);
  gtk_clist_set_column_title (GTK_CLIST(gw->the_list), 2,"Access");
  gtk_clist_set_column_width (GTK_CLIST(gw->the_list), 2, 100);
  gtk_clist_set_column_title (GTK_CLIST(gw->the_list), 3, "Array");
  gtk_clist_set_column_width (GTK_CLIST(gw->the_list), 3, 20);

  gtk_clist_column_titles_show (GTK_CLIST(gw->the_list));
  gtk_container_add (GTK_CONTAINER(swindow), gw->the_list);

  gtk_table_attach_defaults (GTK_TABLE(gw->table), swindow, 0, 2, 0, 1);

  gtk_widget_show (gw->the_list);
  gtk_widget_show (swindow);

  box = gtk_vbox_new (FALSE, FALSE);
  label = gtk_label_new ("Name");
  gtk_box_pack_start (GTK_BOX(box), label, FALSE, FALSE, 2);
  gtk_widget_show (label);
  gw->Name = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX(box), gw->Name, FALSE, FALSE, 2);
  gtk_widget_show (gw->Name);

  label = gtk_label_new ("Type");
  gtk_box_pack_start (GTK_BOX(box), label, FALSE, FALSE, 2);
  gtk_widget_show (label);

  gw->Type = gtk_combo_new ();
  gtk_combo_set_popdown_strings (GTK_COMBO(gw->Type), gw->types);
  gtk_widget_show (gw->Type);
  gtk_box_pack_start (GTK_BOX(box), gw->Type, FALSE, FALSE, 2);

  label = gtk_label_new ("Access");
  gtk_box_pack_start (GTK_BOX(box), label, FALSE, FALSE, 2);
  gtk_widget_show (label);

  gw->Access = gtk_combo_new ();
  gtk_combo_set_popdown_strings (GTK_COMBO(gw->Access), gw->access_mode);
  gtk_widget_show (gw->Access);
  gtk_box_pack_start (GTK_BOX(box), gw->Access, FALSE, FALSE, 2);

  label = gtk_label_new ("Array");
  gtk_box_pack_start (GTK_BOX(box), label, FALSE, FALSE, 2);
  gtk_widget_show (label);

  gw->Array = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX(box), gw->Array, FALSE, FALSE, 2);
  gtk_widget_show (gw->Array);
  gtk_widget_show (box);

  gw->Add = gtk_button_new_with_label ("Add");
  gtk_box_pack_start (GTK_BOX(box), gw->Add, FALSE, FALSE, 2);
  gtk_widget_show (gw->Add);
  gw->Del = gtk_button_new_with_label ("Del");
  gtk_box_pack_start (GTK_BOX(box), gw->Del, FALSE, FALSE, 2);
  gtk_widget_show (gw->Del);
  gw->Set = gtk_button_new_with_label ("Set");
  gtk_box_pack_start (GTK_BOX(box), gw->Set, FALSE, FALSE, 2);
  gtk_widget_show (gw->Set);

  gtk_signal_connect (GTK_OBJECT (gw->Add), "clicked",
		      GTK_SIGNAL_FUNC (Prop_add_click), (gpointer) gw);
  gtk_signal_connect (GTK_OBJECT (gw->Del), "clicked",
		      GTK_SIGNAL_FUNC (Prop_del_click), (gpointer) gw);
  gtk_signal_connect (GTK_OBJECT (gw->Set), "clicked",
		      GTK_SIGNAL_FUNC (Prop_set_click), (gpointer) gw);

  gtk_signal_connect (GTK_OBJECT (gw->the_list), "select_row",
		      GTK_SIGNAL_FUNC (prop_click), gw);

  gtk_table_attach_defaults (GTK_TABLE(gw->table), box, 2, 3, 0, 1);
  gtk_widget_show  (gw->table);

  label = gtk_label_new ("Properties");
  gtk_notebook_append_page (GTK_NOTEBOOK (note), gw->table, label);
  
  return 0;
}

ESint32 
PropGetNP (PropertyWidgets *gw)
{
  return gw->n;
}

ESint32 
PropGetName (PropertyWidgets *gw, ESint32 i, EPChar r)
{
  strcpy (r, gw->props[i].Name);

  return 0;
}

ESint32 
PropGetAccess (PropertyWidgets *gw, ESint32 i, EPChar r)
{
  strcpy (r, e_access[gw->props[i].Access]);

  return 0;
}

ESint32 
PropGetType (PropertyWidgets *gw, ESint32 i, EPChar r)
{
  strcpy (r, e_types[gw->props[i].Type]);

  return 0;
}

ESint32 
PropGetArray (PropertyWidgets *gw, ESint32 i)
{
  return gw->props[i].Array;
}

void 
PropInit(PropertyWidgets *gw)
{
  gw->actual = 0;
  gw->n = 0;
  gtk_clist_clear (GTK_CLIST(gw->the_list));
}

void 
PropSet( PropertyWidgets *gw, EPChar Name,
	 EPChar Type, EPChar Access, EUint32 ne)
{
  EPChar   text;
  EUint32  n,i;
  EChar    *aux, name[80], type[40], access[20], array[20];
  gchar    *prop_data[] = {name, type, access, array};
  gchar    *met_data[] = {name, type, array};

  strcpy (name, Name);
  strcpy (type, Type);
  strcpy (access, Access);
  sprintf (array, "%d", ne);

  /* Store data in the props field */
  strcpy (gw->props[gw->n].Name, name);
  for (i = 0; i < NETYPES; i++)
    if (strcmp (type, e_types[i]) == 0)
      break;
  if (i == NETYPES)
    printf ("ERROR!!! type %s not exists", type);
  gw->props[gw->n].Type = i;

  for (i = 0; i < NEACCESS; i++)
    if (strcmp (access, e_access[i]) == 0)
      break;
  if (i == NEACCESS)
    printf ("ERROR!!! access %s not exists", access);

  printf ("\n Access mode %d (%s)", i, e_access[i]);
  gw->props[gw->n].Access = i;
  gw->props[gw->n].Array = atoi (array);
    gw->n++;

  gtk_clist_append (GTK_CLIST(gw->the_list), prop_data);

}



