/* basic.c generated by valac 0.52.3, the Vala compiler
 * generated from basic.vala, do not modify */

/* Basic movement functions

   Copyright (c) 1997-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#define TYPE_WINDOW (window_get_type ())
#define WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WINDOW, Window))
#define WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WINDOW, WindowClass))
#define IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WINDOW))
#define IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WINDOW))
#define WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WINDOW, WindowClass))

typedef struct _Window Window;
typedef struct _WindowClass WindowClass;

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;
typedef struct _WindowPrivate WindowPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;
typedef enum  {
	FLAGS_NEED_RESYNC = 1 << 0,
	FLAGS_SET_UNIARG = 1 << 1,
	FLAGS_UNIARG_EMPTY = 1 << 2,
	FLAGS_DEFINING_MACRO = 1 << 3
} Flags;

#define TYPE_FLAGS (flags_get_type ())
typedef gboolean (*Function) (glong uniarg, GeeQueue* args);

#define TYPE_LISP_FUNC (lisp_func_get_type ())
#define LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISP_FUNC, LispFunc))
#define LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISP_FUNC, LispFuncClass))
#define IS_LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISP_FUNC))
#define IS_LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISP_FUNC))
#define LISP_FUNC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISP_FUNC, LispFuncClass))

typedef struct _LispFunc LispFunc;
typedef struct _LispFuncClass LispFuncClass;
#define _lisp_func_unref0(var) ((var == NULL) ? NULL : (var = (lisp_func_unref (var), NULL)))
typedef struct _BufferPrivate BufferPrivate;

#define TYPE_UNDO (undo_get_type ())
#define UNDO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO, Undo))
#define UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO, UndoClass))
#define IS_UNDO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO))
#define IS_UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO))
#define UNDO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO, UndoClass))

typedef struct _Undo Undo;
typedef struct _UndoClass UndoClass;

#define TYPE_VAR_ENTRY (var_entry_get_type ())
#define VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAR_ENTRY, VarEntry))
#define VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAR_ENTRY, VarEntryClass))
#define IS_VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAR_ENTRY))
#define IS_VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAR_ENTRY))
#define VAR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAR_ENTRY, VarEntryClass))

typedef struct _VarEntry VarEntry;
typedef struct _VarEntryClass VarEntryClass;
typedef gboolean (*MovementDelegate) (gpointer user_data);

struct _Window {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WindowPrivate * priv;
	Window* next;
	Buffer* bp;
	gsize topdelta;
	gsize start_column;
	Marker* saved_pt;
	gsize fwidth;
	gsize fheight;
	gsize ewidth;
	gsize eheight;
	gboolean all_displayed;
	gsize lastpointn;
};

struct _WindowClass {
	GTypeClass parent_class;
	void (*finalize) (Window *self);
};

struct _Buffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BufferPrivate * priv;
	gchar* name;
	gchar* filename;
	Buffer* next;
	gsize goalc;
	Marker* mark;
	Marker* markers;
	GList* last_undop;
	GList* next_undop;
	GHashTable* vars;
	gboolean modified;
	gboolean nosave;
	gboolean needname;
	gboolean temporary;
	gboolean readonly;
	gboolean backup;
	gboolean noundo;
	gboolean autofill;
	gboolean isearch;
	gboolean mark_active;
	gchar* dir;
};

struct _BufferClass {
	GTypeClass parent_class;
	void (*finalize) (Buffer *self);
	gsize (*get_length) (Buffer* self);
	const gchar* (*get_eol) (Buffer* self);
};

extern Window* cur_wp;
extern Buffer* cur_bp;
extern Flags thisflag;

gboolean scroll_down (void);
gpointer window_ref (gpointer instance);
void window_unref (gpointer instance);
GParamSpec* param_spec_window (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_window (GValue* value,
                       gpointer v_object);
void value_take_window (GValue* value,
                        gpointer v_object);
gpointer value_get_window (const GValue* value);
GType window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Window, window_unref)
gboolean window_top_visible (Window* self);
gpointer buffer_ref (gpointer instance);
void buffer_unref (gpointer instance);
GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_buffer (GValue* value,
                       gpointer v_object);
void value_take_buffer (GValue* value,
                        gpointer v_object);
gpointer value_get_buffer (const GValue* value);
GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
gboolean buffer_move_line (Buffer* self,
                           glong n);
gpointer marker_ref (gpointer instance);
void marker_unref (gpointer instance);
GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_marker (GValue* value,
                       gpointer v_object);
void value_take_marker (GValue* value,
                        gpointer v_object);
gpointer value_get_marker (const GValue* value);
GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
void minibuf_error (const gchar* fmt,
                    ...);
gboolean scroll_up (void);
gboolean window_bottom_visible (Window* self);
void ding (void);
GType flags_get_type (void) G_GNUC_CONST ;
void cancel_kbd_macro (void);
gboolean get_variable_bool (const gchar* name);
void term_beep (void);
void basic_init (void);
static gboolean __lambda10_ (glong uniarg,
                      GeeQueue* args);
void buffer_goto_offset (Buffer* self,
                         gsize o);
gsize buffer_line_o (Buffer* self);
static gboolean ___lambda10__function (glong uniarg,
                                GeeQueue* args);
LispFunc* lisp_func_new (const gchar* name,
                         Function func,
                         gboolean interactive,
                         const gchar* doc);
LispFunc* lisp_func_construct (GType object_type,
                               const gchar* name,
                               Function func,
                               gboolean interactive,
                               const gchar* doc);
gpointer lisp_func_ref (gpointer instance);
void lisp_func_unref (gpointer instance);
GParamSpec* param_spec_lisp_func (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_lisp_func (GValue* value,
                          gpointer v_object);
void value_take_lisp_func (GValue* value,
                           gpointer v_object);
gpointer value_get_lisp_func (const GValue* value);
GType lisp_func_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LispFunc, lisp_func_unref)
static gboolean __lambda11_ (glong uniarg,
                      GeeQueue* args);
gsize buffer_line_len (Buffer* self,
                       gsize o);
gsize buffer_get_pt (Buffer* self);
gpointer undo_ref (gpointer instance);
void undo_unref (gpointer instance);
GParamSpec* param_spec_undo (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_undo (GValue* value,
                     gpointer v_object);
void value_take_undo (GValue* value,
                      gpointer v_object);
gpointer value_get_undo (const GValue* value);
GType undo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Undo, undo_unref)
gpointer var_entry_ref (gpointer instance);
void var_entry_unref (gpointer instance);
GParamSpec* param_spec_var_entry (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_var_entry (GValue* value,
                          gpointer v_object);
void value_take_var_entry (GValue* value,
                           gpointer v_object);
gpointer value_get_var_entry (const GValue* value);
GType var_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VarEntry, var_entry_unref)
static gboolean ___lambda11__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda12_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda12__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda13_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda13__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda14_ (glong uniarg,
                      GeeQueue* args);
gboolean noarg (GeeQueue* args);
glong minibuf_read_number (const gchar* fmt,
                           ...);
gboolean int_or_uniarg (GeeQueue* args,
                        glong* n,
                        glong uniarg);
gsize buffer_get_length (Buffer* self);
static gboolean ___lambda14__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda15_ (glong uniarg,
                      GeeQueue* args);
gsize buffer_offset_to_line (Buffer* self,
                             gsize offset);
gboolean funcall (const gchar* name,
                  glong* maybe_uniarg,
                  GeeQueue* args);
static gboolean ___lambda15__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda16_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda16__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda17_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda17__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda18_ (glong uniarg,
                      GeeQueue* args);
gboolean buffer_move_char (Buffer* self,
                           glong offset);
static gboolean ___lambda18__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda19_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda19__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda20_ (glong uniarg,
                      GeeQueue* args);
gboolean execute_with_uniarg (glong uniarg,
                              MovementDelegate forward,
                              gpointer forward_target,
                              MovementDelegate backward,
                              gpointer backward_target);
static gboolean _scroll_down_movement_delegate (gpointer self);
static gboolean _scroll_up_movement_delegate (gpointer self);
static gboolean ___lambda20__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda21_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda21__function (glong uniarg,
                                GeeQueue* args);

gboolean
scroll_down (void)
{
	Window* _tmp0_;
	gboolean result = FALSE;
#line 21 "src/basic.vala"
	_tmp0_ = cur_wp;
#line 21 "src/basic.vala"
	if (!window_top_visible (_tmp0_)) {
#line 354 "basic.c"
		Buffer* _tmp1_;
		Window* _tmp2_;
#line 22 "src/basic.vala"
		_tmp1_ = cur_bp;
#line 22 "src/basic.vala"
		_tmp2_ = cur_wp;
#line 22 "src/basic.vala"
		result = buffer_move_line (_tmp1_, -((glong) _tmp2_->eheight));
#line 22 "src/basic.vala"
		return result;
#line 365 "basic.c"
	}
#line 24 "src/basic.vala"
	minibuf_error ("Beginning of buffer", NULL);
#line 25 "src/basic.vala"
	result = FALSE;
#line 25 "src/basic.vala"
	return result;
#line 373 "basic.c"
}

gboolean
scroll_up (void)
{
	Window* _tmp0_;
	gboolean result = FALSE;
#line 29 "src/basic.vala"
	_tmp0_ = cur_wp;
#line 29 "src/basic.vala"
	if (!window_bottom_visible (_tmp0_)) {
#line 385 "basic.c"
		Buffer* _tmp1_;
		Window* _tmp2_;
#line 30 "src/basic.vala"
		_tmp1_ = cur_bp;
#line 30 "src/basic.vala"
		_tmp2_ = cur_wp;
#line 30 "src/basic.vala"
		result = buffer_move_line (_tmp1_, (glong) _tmp2_->eheight);
#line 30 "src/basic.vala"
		return result;
#line 396 "basic.c"
	}
#line 32 "src/basic.vala"
	minibuf_error ("End of buffer", NULL);
#line 33 "src/basic.vala"
	result = FALSE;
#line 33 "src/basic.vala"
	return result;
#line 404 "basic.c"
}

void
ding (void)
{
	Flags _tmp0_;
#line 38 "src/basic.vala"
	_tmp0_ = thisflag;
#line 38 "src/basic.vala"
	if ((_tmp0_ & FLAGS_DEFINING_MACRO) == FLAGS_DEFINING_MACRO) {
#line 39 "src/basic.vala"
		cancel_kbd_macro ();
#line 417 "basic.c"
	}
#line 41 "src/basic.vala"
	if (get_variable_bool ("ring-bell")) {
#line 42 "src/basic.vala"
		term_beep ();
#line 423 "basic.c"
	}
}

static gboolean
__lambda10_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	Buffer* _tmp1_;
	gboolean result = FALSE;
#line 50 "src/basic.vala"
	_tmp0_ = cur_bp;
#line 50 "src/basic.vala"
	_tmp1_ = cur_bp;
#line 50 "src/basic.vala"
	buffer_goto_offset (_tmp0_, buffer_line_o (_tmp1_));
#line 51 "src/basic.vala"
	result = TRUE;
#line 51 "src/basic.vala"
	return result;
#line 444 "basic.c"
}

static gboolean
___lambda10__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda10_ (uniarg, args);
#line 47 "src/basic.vala"
	return result;
#line 455 "basic.c"
}

static gboolean
__lambda11_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	Buffer* _tmp1_;
	Buffer* _tmp2_;
	Buffer* _tmp3_;
	gsize _tmp4_;
	gsize _tmp5_;
	Buffer* _tmp6_;
	gboolean result = FALSE;
#line 60 "src/basic.vala"
	_tmp0_ = cur_bp;
#line 60 "src/basic.vala"
	_tmp1_ = cur_bp;
#line 60 "src/basic.vala"
	_tmp2_ = cur_bp;
#line 60 "src/basic.vala"
	_tmp3_ = cur_bp;
#line 60 "src/basic.vala"
	_tmp4_ = buffer_get_pt (_tmp3_);
#line 60 "src/basic.vala"
	_tmp5_ = _tmp4_;
#line 60 "src/basic.vala"
	buffer_goto_offset (_tmp0_, buffer_line_o (_tmp1_) + buffer_line_len (_tmp2_, _tmp5_));
#line 61 "src/basic.vala"
	_tmp6_ = cur_bp;
#line 61 "src/basic.vala"
	_tmp6_->goalc = (gsize) G_MAXSIZE;
#line 62 "src/basic.vala"
	result = TRUE;
#line 62 "src/basic.vala"
	return result;
#line 492 "basic.c"
}

static gboolean
___lambda11__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda11_ (uniarg, args);
#line 57 "src/basic.vala"
	return result;
#line 503 "basic.c"
}

static gboolean
__lambda12_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	gboolean result = FALSE;
#line 71 "src/basic.vala"
	_tmp0_ = cur_bp;
#line 71 "src/basic.vala"
	result = buffer_move_line (_tmp0_, -uniarg);
#line 71 "src/basic.vala"
	return result;
#line 518 "basic.c"
}

static gboolean
___lambda12__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda12_ (uniarg, args);
#line 68 "src/basic.vala"
	return result;
#line 529 "basic.c"
}

static gboolean
__lambda13_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	gboolean result = FALSE;
#line 83 "src/basic.vala"
	_tmp0_ = cur_bp;
#line 83 "src/basic.vala"
	result = buffer_move_line (_tmp0_, uniarg);
#line 83 "src/basic.vala"
	return result;
#line 544 "basic.c"
}

static gboolean
___lambda13__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda13_ (uniarg, args);
#line 80 "src/basic.vala"
	return result;
#line 555 "basic.c"
}

static gboolean
__lambda14_ (glong uniarg,
             GeeQueue* args)
{
	gboolean ok = FALSE;
	glong n = 0L;
	gboolean _tmp1_ = FALSE;
	Buffer* _tmp2_;
	Buffer* _tmp3_;
	gsize _tmp4_;
	gsize _tmp5_;
	gboolean result = FALSE;
#line 95 "src/basic.vala"
	ok = TRUE;
#line 96 "src/basic.vala"
	n = (glong) 1;
#line 97 "src/basic.vala"
	if (noarg (args)) {
#line 98 "src/basic.vala"
		n = minibuf_read_number ("Goto char: ", NULL);
#line 578 "basic.c"
	} else {
		gboolean _tmp0_;
#line 99 "src/basic.vala"
		_tmp0_ = int_or_uniarg (args, &n, uniarg);
#line 99 "src/basic.vala"
		if (!_tmp0_) {
#line 100 "src/basic.vala"
			ok = FALSE;
#line 587 "basic.c"
		}
	}
#line 102 "src/basic.vala"
	if (ok == FALSE) {
#line 102 "src/basic.vala"
		_tmp1_ = TRUE;
#line 594 "basic.c"
	} else {
#line 102 "src/basic.vala"
		_tmp1_ = n >= (G_MAXLONG - 1);
#line 598 "basic.c"
	}
#line 102 "src/basic.vala"
	if (_tmp1_) {
#line 103 "src/basic.vala"
		result = FALSE;
#line 103 "src/basic.vala"
		return result;
#line 606 "basic.c"
	}
#line 105 "src/basic.vala"
	_tmp2_ = cur_bp;
#line 105 "src/basic.vala"
	_tmp3_ = cur_bp;
#line 105 "src/basic.vala"
	_tmp4_ = buffer_get_length (_tmp3_);
#line 105 "src/basic.vala"
	_tmp5_ = _tmp4_;
#line 105 "src/basic.vala"
	buffer_goto_offset (_tmp2_, MIN (_tmp5_, ((gsize) MAX (n, (glong) 1)) - 1));
#line 106 "src/basic.vala"
	result = ok;
#line 106 "src/basic.vala"
	return result;
#line 622 "basic.c"
}

static gboolean
___lambda14__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda14_ (uniarg, args);
#line 92 "src/basic.vala"
	return result;
#line 633 "basic.c"
}

static gboolean
__lambda15_ (glong uniarg,
             GeeQueue* args)
{
	gboolean ok = FALSE;
	glong n = 0L;
	gboolean _tmp1_ = FALSE;
	Buffer* _tmp2_;
	Buffer* _tmp3_;
	Buffer* _tmp4_;
	gsize _tmp5_;
	gsize _tmp6_;
	gboolean result = FALSE;
#line 116 "src/basic.vala"
	ok = TRUE;
#line 117 "src/basic.vala"
	n = (glong) 1;
#line 118 "src/basic.vala"
	if (noarg (args)) {
#line 119 "src/basic.vala"
		n = minibuf_read_number ("Goto line: ", NULL);
#line 657 "basic.c"
	} else {
		gboolean _tmp0_;
#line 120 "src/basic.vala"
		_tmp0_ = int_or_uniarg (args, &n, uniarg);
#line 120 "src/basic.vala"
		if (!_tmp0_) {
#line 121 "src/basic.vala"
			ok = FALSE;
#line 666 "basic.c"
		}
	}
#line 123 "src/basic.vala"
	if (!ok) {
#line 123 "src/basic.vala"
		_tmp1_ = TRUE;
#line 673 "basic.c"
	} else {
#line 123 "src/basic.vala"
		_tmp1_ = n >= (G_MAXLONG - 1);
#line 677 "basic.c"
	}
#line 123 "src/basic.vala"
	if (_tmp1_) {
#line 124 "src/basic.vala"
		result = FALSE;
#line 124 "src/basic.vala"
		return result;
#line 685 "basic.c"
	}
#line 126 "src/basic.vala"
	_tmp2_ = cur_bp;
#line 126 "src/basic.vala"
	_tmp3_ = cur_bp;
#line 126 "src/basic.vala"
	_tmp4_ = cur_bp;
#line 126 "src/basic.vala"
	_tmp5_ = buffer_get_pt (_tmp4_);
#line 126 "src/basic.vala"
	_tmp6_ = _tmp5_;
#line 126 "src/basic.vala"
	buffer_move_line (_tmp2_, (MAX (n, (glong) 1) - 1) - ((glong) buffer_offset_to_line (_tmp3_, _tmp6_)));
#line 127 "src/basic.vala"
	funcall ("beginning-of-line", NULL, NULL);
#line 128 "src/basic.vala"
	result = ok;
#line 128 "src/basic.vala"
	return result;
#line 705 "basic.c"
}

static gboolean
___lambda15__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda15_ (uniarg, args);
#line 113 "src/basic.vala"
	return result;
#line 716 "basic.c"
}

static gboolean
__lambda16_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	gboolean result = FALSE;
#line 137 "src/basic.vala"
	_tmp0_ = cur_bp;
#line 137 "src/basic.vala"
	buffer_goto_offset (_tmp0_, (gsize) 0);
#line 138 "src/basic.vala"
	result = TRUE;
#line 138 "src/basic.vala"
	return result;
#line 733 "basic.c"
}

static gboolean
___lambda16__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda16_ (uniarg, args);
#line 134 "src/basic.vala"
	return result;
#line 744 "basic.c"
}

static gboolean
__lambda17_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	Buffer* _tmp1_;
	gsize _tmp2_;
	gsize _tmp3_;
	gboolean result = FALSE;
#line 147 "src/basic.vala"
	_tmp0_ = cur_bp;
#line 147 "src/basic.vala"
	_tmp1_ = cur_bp;
#line 147 "src/basic.vala"
	_tmp2_ = buffer_get_length (_tmp1_);
#line 147 "src/basic.vala"
	_tmp3_ = _tmp2_;
#line 147 "src/basic.vala"
	buffer_goto_offset (_tmp0_, _tmp3_);
#line 148 "src/basic.vala"
	result = TRUE;
#line 148 "src/basic.vala"
	return result;
#line 770 "basic.c"
}

static gboolean
___lambda17__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda17_ (uniarg, args);
#line 144 "src/basic.vala"
	return result;
#line 781 "basic.c"
}

static gboolean
__lambda18_ (glong uniarg,
             GeeQueue* args)
{
	gboolean ok = FALSE;
	Buffer* _tmp0_;
	gboolean result = FALSE;
#line 157 "src/basic.vala"
	_tmp0_ = cur_bp;
#line 157 "src/basic.vala"
	ok = buffer_move_char (_tmp0_, -uniarg);
#line 158 "src/basic.vala"
	if (!ok) {
#line 159 "src/basic.vala"
		minibuf_error ("Beginning of buffer", NULL);
#line 799 "basic.c"
	}
#line 160 "src/basic.vala"
	result = ok;
#line 160 "src/basic.vala"
	return result;
#line 805 "basic.c"
}

static gboolean
___lambda18__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda18_ (uniarg, args);
#line 154 "src/basic.vala"
	return result;
#line 816 "basic.c"
}

static gboolean
__lambda19_ (glong uniarg,
             GeeQueue* args)
{
	gboolean ok = FALSE;
	Buffer* _tmp0_;
	gboolean result = FALSE;
#line 170 "src/basic.vala"
	_tmp0_ = cur_bp;
#line 170 "src/basic.vala"
	ok = buffer_move_char (_tmp0_, uniarg);
#line 171 "src/basic.vala"
	if (!ok) {
#line 172 "src/basic.vala"
		minibuf_error ("End of buffer", NULL);
#line 834 "basic.c"
	}
#line 173 "src/basic.vala"
	result = ok;
#line 173 "src/basic.vala"
	return result;
#line 840 "basic.c"
}

static gboolean
___lambda19__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda19_ (uniarg, args);
#line 167 "src/basic.vala"
	return result;
#line 851 "basic.c"
}

static gboolean
_scroll_down_movement_delegate (gpointer self)
{
	gboolean result;
	result = scroll_down ();
#line 183 "src/basic.vala"
	return result;
#line 861 "basic.c"
}

static gboolean
_scroll_up_movement_delegate (gpointer self)
{
	gboolean result;
	result = scroll_up ();
#line 183 "src/basic.vala"
	return result;
#line 871 "basic.c"
}

static gboolean
__lambda20_ (glong uniarg,
             GeeQueue* args)
{
	gboolean result = FALSE;
#line 183 "src/basic.vala"
	result = execute_with_uniarg (uniarg, _scroll_down_movement_delegate, NULL, _scroll_up_movement_delegate, NULL);
#line 183 "src/basic.vala"
	return result;
#line 883 "basic.c"
}

static gboolean
___lambda20__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda20_ (uniarg, args);
#line 180 "src/basic.vala"
	return result;
#line 894 "basic.c"
}

static gboolean
__lambda21_ (glong uniarg,
             GeeQueue* args)
{
	gboolean result = FALSE;
#line 192 "src/basic.vala"
	result = execute_with_uniarg (uniarg, _scroll_up_movement_delegate, NULL, _scroll_down_movement_delegate, NULL);
#line 192 "src/basic.vala"
	return result;
#line 906 "basic.c"
}

static gboolean
___lambda21__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda21_ (uniarg, args);
#line 189 "src/basic.vala"
	return result;
#line 917 "basic.c"
}

void
basic_init (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
	LispFunc* _tmp4_;
	LispFunc* _tmp5_;
	LispFunc* _tmp6_;
	LispFunc* _tmp7_;
	LispFunc* _tmp8_;
	LispFunc* _tmp9_;
	LispFunc* _tmp10_;
	LispFunc* _tmp11_;
	LispFunc* _tmp12_;
	LispFunc* _tmp13_;
	LispFunc* _tmp14_;
	LispFunc* _tmp15_;
	LispFunc* _tmp16_;
	LispFunc* _tmp17_;
	LispFunc* _tmp18_;
	LispFunc* _tmp19_;
	LispFunc* _tmp20_;
	LispFunc* _tmp21_;
	LispFunc* _tmp22_;
	LispFunc* _tmp23_;
#line 47 "src/basic.vala"
	_tmp0_ = lisp_func_new ("beginning-of-line", ___lambda10__function, TRUE, "Move point to beginning of current line.");
#line 47 "src/basic.vala"
	_tmp1_ = _tmp0_;
#line 47 "src/basic.vala"
	_lisp_func_unref0 (_tmp1_);
#line 57 "src/basic.vala"
	_tmp2_ = lisp_func_new ("end-of-line", ___lambda11__function, TRUE, "Move point to end of current line.");
#line 57 "src/basic.vala"
	_tmp3_ = _tmp2_;
#line 57 "src/basic.vala"
	_lisp_func_unref0 (_tmp3_);
#line 68 "src/basic.vala"
	_tmp4_ = lisp_func_new ("previous-line", ___lambda12__function, TRUE, "Move cursor vertically up one line.\n" \
"If there is no character in the target line exactly over the current c" \
"olumn,\n" \
"the cursor is positioned after the character in that line which spans " \
"this\n" \
"column, or at the end of the line if it is not long enough.");
#line 68 "src/basic.vala"
	_tmp5_ = _tmp4_;
#line 68 "src/basic.vala"
	_lisp_func_unref0 (_tmp5_);
#line 80 "src/basic.vala"
	_tmp6_ = lisp_func_new ("next-line", ___lambda13__function, TRUE, "Move cursor vertically down one line.\n" \
"If there is no character in the target line exactly under the current " \
"column,\n" \
"the cursor is positioned after the character in that line which spans " \
"this\n" \
"column, or at the end of the line if it is not long enough.");
#line 80 "src/basic.vala"
	_tmp7_ = _tmp6_;
#line 80 "src/basic.vala"
	_lisp_func_unref0 (_tmp7_);
#line 92 "src/basic.vala"
	_tmp8_ = lisp_func_new ("goto-char", ___lambda14__function, TRUE, "Set point to POSITION, a number.\nBeginning of buffer is position 1.");
#line 92 "src/basic.vala"
	_tmp9_ = _tmp8_;
#line 92 "src/basic.vala"
	_lisp_func_unref0 (_tmp9_);
#line 113 "src/basic.vala"
	_tmp10_ = lisp_func_new ("goto-line", ___lambda15__function, TRUE, "Go to LINE, counting from line 1 at beginning of buffer.");
#line 113 "src/basic.vala"
	_tmp11_ = _tmp10_;
#line 113 "src/basic.vala"
	_lisp_func_unref0 (_tmp11_);
#line 134 "src/basic.vala"
	_tmp12_ = lisp_func_new ("beginning-of-buffer", ___lambda16__function, TRUE, "Move point to the beginning of the buffer; leave mark at previous posi" \
"tion.");
#line 134 "src/basic.vala"
	_tmp13_ = _tmp12_;
#line 134 "src/basic.vala"
	_lisp_func_unref0 (_tmp13_);
#line 144 "src/basic.vala"
	_tmp14_ = lisp_func_new ("end-of-buffer", ___lambda17__function, TRUE, "Move point to the end of the buffer; leave mark at previous position.");
#line 144 "src/basic.vala"
	_tmp15_ = _tmp14_;
#line 144 "src/basic.vala"
	_lisp_func_unref0 (_tmp15_);
#line 154 "src/basic.vala"
	_tmp16_ = lisp_func_new ("backward-char", ___lambda18__function, TRUE, "Move point left N characters (right if N is negative).\n" \
"On attempt to pass beginning or end of buffer, stop and signal error.");
#line 154 "src/basic.vala"
	_tmp17_ = _tmp16_;
#line 154 "src/basic.vala"
	_lisp_func_unref0 (_tmp17_);
#line 167 "src/basic.vala"
	_tmp18_ = lisp_func_new ("forward-char", ___lambda19__function, TRUE, "Move point right N characters (left if N is negative).\n" \
"On reaching end of buffer, stop and signal error.");
#line 167 "src/basic.vala"
	_tmp19_ = _tmp18_;
#line 167 "src/basic.vala"
	_lisp_func_unref0 (_tmp19_);
#line 180 "src/basic.vala"
	_tmp20_ = lisp_func_new ("scroll-down", ___lambda20__function, TRUE, "Scroll text of current window downward near full screen.");
#line 180 "src/basic.vala"
	_tmp21_ = _tmp20_;
#line 180 "src/basic.vala"
	_lisp_func_unref0 (_tmp21_);
#line 189 "src/basic.vala"
	_tmp22_ = lisp_func_new ("scroll-up", ___lambda21__function, TRUE, "Scroll text of current window upward near full screen.");
#line 189 "src/basic.vala"
	_tmp23_ = _tmp22_;
#line 189 "src/basic.vala"
	_lisp_func_unref0 (_tmp23_);
#line 1019 "basic.c"
}

