/* file.c generated by valac 0.52.0, the Vala compiler
 * generated from file.vala, do not modify */

/* Disk file handling

   Copyright (c) 1997-2021 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <pwd.h>
#include <unistd.h>
#include <glib-object.h>
#include <glib/gstdio.h>
#include <estr.h>
#include <sys/types.h>
#include <fcntl.h>
#include <gio/gio.h>
#include <sys/stat.h>
#include <errno.h>
#include <gee.h>

#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;
#define _buffer_unref0(var) ((var == NULL) ? NULL : (var = (buffer_unref (var), NULL)))
typedef struct _BufferPrivate BufferPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;

#define TYPE_UNDO (undo_get_type ())
#define UNDO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO, Undo))
#define UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO, UndoClass))
#define IS_UNDO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO))
#define IS_UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO))
#define UNDO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO, UndoClass))

typedef struct _Undo Undo;
typedef struct _UndoClass UndoClass;

#define TYPE_VAR_ENTRY (var_entry_get_type ())
#define VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAR_ENTRY, VarEntry))
#define VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAR_ENTRY, VarEntryClass))
#define IS_VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAR_ENTRY))
#define IS_VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAR_ENTRY))
#define VAR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAR_ENTRY, VarEntryClass))

typedef struct _VarEntry VarEntry;
typedef struct _VarEntryClass VarEntryClass;
#define _immutable_estr_unref0(var) ((var == NULL) ? NULL : (var = (immutable_estr_unref (var), NULL)))
typedef enum  {
	FLAGS_NEED_RESYNC = 1 << 0,
	FLAGS_SET_UNIARG = 1 << 1,
	FLAGS_UNIARG_EMPTY = 1 << 2,
	FLAGS_DEFINING_MACRO = 1 << 3
} Flags;

#define TYPE_FLAGS (flags_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef guint Keystroke;
typedef gboolean (*Function) (glong uniarg, GeeQueue* args);

#define TYPE_LISP_FUNC (lisp_func_get_type ())
#define LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISP_FUNC, LispFunc))
#define LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISP_FUNC, LispFuncClass))
#define IS_LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISP_FUNC))
#define IS_LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISP_FUNC))
#define LISP_FUNC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISP_FUNC, LispFuncClass))

typedef struct _LispFunc LispFunc;
typedef struct _LispFuncClass LispFuncClass;
#define _lisp_func_unref0(var) ((var == NULL) ? NULL : (var = (lisp_func_unref (var), NULL)))
typedef struct _LispFuncPrivate LispFuncPrivate;

#define TYPE_COMPLETION (completion_get_type ())
#define COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION, Completion))
#define COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION, CompletionClass))
#define IS_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION))
#define IS_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION))
#define COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION, CompletionClass))

typedef struct _Completion Completion;
typedef struct _CompletionClass CompletionClass;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;
#define _completion_unref0(var) ((var == NULL) ? NULL : (var = (completion_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Buffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BufferPrivate * priv;
	gchar* name;
	gchar* filename;
	Buffer* next;
	gsize goalc;
	Marker* mark;
	Marker* markers;
	GList* last_undop;
	GList* next_undop;
	GHashTable* vars;
	gboolean modified;
	gboolean nosave;
	gboolean needname;
	gboolean temporary;
	gboolean readonly;
	gboolean backup;
	gboolean noundo;
	gboolean autofill;
	gboolean isearch;
	gboolean mark_active;
	gchar* dir;
};

struct _BufferClass {
	GTypeClass parent_class;
	void (*finalize) (Buffer *self);
	gsize (*get_length) (Buffer* self);
	const gchar* (*get_eol) (Buffer* self);
};

struct _LispFunc {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LispFuncPrivate * priv;
	gchar* name;
	Function func;
	gboolean interactive;
	gchar* doc;
};

struct _LispFuncClass {
	GTypeClass parent_class;
	void (*finalize) (LispFunc *self);
};

extern Buffer* head_bp;
extern Flags thisflag;
extern Buffer* cur_bp;

gchar* expand_path (const gchar* path);
gchar* compact_path (const gchar* in_path);
gboolean check_writable (const gchar* filename);
gboolean find_file (const gchar* filename);
gpointer buffer_ref (gpointer instance);
void buffer_unref (gpointer instance);
GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_buffer (GValue* value,
                       gpointer v_object);
void value_take_buffer (GValue* value,
                        gpointer v_object);
gpointer value_get_buffer (const GValue* value);
GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
gpointer marker_ref (gpointer instance);
void marker_unref (gpointer instance);
GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_marker (GValue* value,
                       gpointer v_object);
void value_take_marker (GValue* value,
                        gpointer v_object);
gpointer value_get_marker (const GValue* value);
GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
gpointer undo_ref (gpointer instance);
void undo_unref (gpointer instance);
GParamSpec* param_spec_undo (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_undo (GValue* value,
                     gpointer v_object);
void value_take_undo (GValue* value,
                      gpointer v_object);
gpointer value_get_undo (const GValue* value);
GType undo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Undo, undo_unref)
gpointer var_entry_ref (gpointer instance);
void var_entry_unref (gpointer instance);
GParamSpec* param_spec_var_entry (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_var_entry (GValue* value,
                          gpointer v_object);
void value_take_var_entry (GValue* value,
                           gpointer v_object);
gpointer value_get_var_entry (const GValue* value);
GType var_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VarEntry, var_entry_unref)
void minibuf_error (const gchar* fmt,
                    ...);
Buffer* buffer_new (Estr* es);
Buffer* buffer_construct (GType object_type,
                          Estr* es);
void buffer_set_names (Buffer* self,
                       const gchar* new_filename);
void buffer_switch_to (Buffer* self);
GType flags_get_type (void) G_GNUC_CONST ;
gint write_all (gint fd,
                gchar* data,
                gsize length);
gint write_to_disk (Buffer* bp,
                    const gchar* filename,
                    mode_t mode);
ImmutableEstr* buffer_pre_point (Buffer* self);
ImmutableEstr* buffer_post_point (Buffer* self);
gchar* create_backup_filename (const gchar* filename,
                               const gchar* backupdir);
gboolean backup_and_write (Buffer* bp,
                           const gchar* filename);
gboolean get_variable_bool (const gchar* name);
const gchar* get_variable (const gchar* name);
void waitkey (void);
gboolean write_buffer (Buffer* bp,
                       gboolean needname,
                       gboolean confirm,
                       const gchar* name0,
                       const gchar* prompt);
gchar* minibuf_read_filename (const gchar* fmt,
                              const gchar* value,
                              const gchar* file,
                              ...);
gboolean funcall (const gchar* name,
                  glong* maybe_uniarg,
                  GeeQueue* args);
void minibuf_write (const gchar* fmt,
                    ...);
Keystroke getkeystroke (gint delay);
#define GETKEY_DEFAULT -1
#define KBD_RET ((Keystroke) 00403)
#define KBD_DEL ((Keystroke) 00410)
#define KBD_CTRL ((Keystroke) 01000)
void undo_set_unchanged (GList* l);
gboolean save_buffer (Buffer* bp);
void file_init (void);
static gboolean __lambda35_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda35__function (glong uniarg,
                                GeeQueue* args);
LispFunc* lisp_func_new (const gchar* name,
                         Function func,
                         gboolean interactive,
                         const gchar* doc);
LispFunc* lisp_func_construct (GType object_type,
                               const gchar* name,
                               Function func,
                               gboolean interactive,
                               const gchar* doc);
gpointer lisp_func_ref (gpointer instance);
void lisp_func_unref (gpointer instance);
GParamSpec* param_spec_lisp_func (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_lisp_func (GValue* value,
                          gpointer v_object);
void value_take_lisp_func (GValue* value,
                           gpointer v_object);
gpointer value_get_lisp_func (const GValue* value);
GType lisp_func_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LispFunc, lisp_func_unref)
static gboolean __lambda36_ (glong uniarg,
                      GeeQueue* args);
LispFunc* lisp_func_find (const gchar* name);
static gboolean ___lambda36__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda37_ (glong uniarg,
                      GeeQueue* args);
gboolean buffer_check_modified (Buffer* self);
void buffer_kill (Buffer* self);
static gboolean ___lambda37__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda38_ (glong uniarg,
                      GeeQueue* args);
gpointer completion_ref (gpointer instance);
void completion_unref (gpointer instance);
GParamSpec* param_spec_completion (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_completion (GValue* value,
                           gpointer v_object);
void value_take_completion (GValue* value,
                            gpointer v_object);
gpointer value_get_completion (const GValue* value);
GType completion_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Completion, completion_unref)
Completion* buffer_make_buffer_completion (void);
gpointer history_ref (gpointer instance);
void history_unref (gpointer instance);
GParamSpec* param_spec_history (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
void value_set_history (GValue* value,
                        gpointer v_object);
void value_take_history (GValue* value,
                         gpointer v_object);
gpointer value_get_history (const GValue* value);
GType history_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (History, history_unref)
gchar* minibuf_read_completion (const gchar* fmt,
                                const gchar* val,
                                Completion* cp,
                                History* hp,
                                ...);
Buffer* buffer_find (const gchar* name);
static gboolean ___lambda38__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda39_ (glong uniarg,
                      GeeQueue* args);
gboolean buffer_warn_if_readonly (Buffer* self);
void buffer_insert_buffer (Buffer* self,
                           Buffer* bp);
static gboolean ___lambda39__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda40_ (glong uniarg,
                      GeeQueue* args);
gboolean buffer_insert_estr (Buffer* self,
                             ImmutableEstr* es);
static gboolean ___lambda40__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda41_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda41__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda42_ (glong uniarg,
                      GeeQueue* args);
gboolean noarg (GeeQueue* args);
static gboolean ___lambda42__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda43_ (glong uniarg,
                      GeeQueue* args);
gchar* buffer_get_filename_or_name (Buffer* self);
Keystroke getkey (gint delay);
void minibuf_clear (void);
#define KBD_CANCEL (KBD_CTRL | 'g')
static gboolean ___lambda43__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda44_ (glong uniarg,
                      GeeQueue* args);
gboolean* minibuf_read_yesno (const gchar* fmt,
                              ...);
static gboolean _bool_equal (const gboolean * s1,
                      const gboolean * s2);
void zile_exit (gint reason);
static gboolean ___lambda44__function (glong uniarg,
                                GeeQueue* args);
static gboolean __lambda45_ (glong uniarg,
                      GeeQueue* args);
static gboolean ___lambda45__function (glong uniarg,
                                GeeQueue* args);

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1232 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1233 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1233 "glib-2.0.vapi"
	result = _tmp0_;
#line 1233 "glib-2.0.vapi"
	return result;
#line 426 "file.c"
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
#line 1480 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1481 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1481 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1481 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1482 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1483 "glib-2.0.vapi"
		start = string_length + start;
#line 453 "file.c"
	}
#line 1485 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1486 "glib-2.0.vapi"
		end = string_length + end;
#line 459 "file.c"
	}
#line 1488 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1488 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 465 "file.c"
	} else {
#line 1488 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 469 "file.c"
	}
#line 1488 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1489 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1489 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 477 "file.c"
	} else {
#line 1489 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 481 "file.c"
	}
#line 1489 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1490 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1491 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1491 "glib-2.0.vapi"
	result = _tmp4_;
#line 1491 "glib-2.0.vapi"
	return result;
#line 493 "file.c"
}

gchar*
expand_path (const gchar* path)
{
	gboolean ok = FALSE;
	gchar* epath = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp90_ = NULL;
	gchar* _tmp92_;
	gchar* result = NULL;
#line 34 "src/file.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 35 "src/file.vala"
	ok = TRUE;
#line 36 "src/file.vala"
	_tmp0_ = g_strdup ("");
#line 36 "src/file.vala"
	epath = _tmp0_;
#line 38 "src/file.vala"
	if (string_get (path, (glong) 0) != '/') {
#line 38 "src/file.vala"
		_tmp1_ = string_get (path, (glong) 0) != '~';
#line 518 "file.c"
	} else {
#line 38 "src/file.vala"
		_tmp1_ = FALSE;
#line 522 "file.c"
	}
#line 38 "src/file.vala"
	if (_tmp1_) {
#line 526 "file.c"
		gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
#line 39 "src/file.vala"
		_tmp2_ = g_get_current_dir ();
#line 39 "src/file.vala"
		_g_free0 (epath);
#line 39 "src/file.vala"
		epath = _tmp2_;
#line 40 "src/file.vala"
		_tmp4_ = epath;
#line 40 "src/file.vala"
		_tmp5_ = strlen (_tmp4_);
#line 40 "src/file.vala"
		_tmp6_ = _tmp5_;
#line 40 "src/file.vala"
		if (_tmp6_ == 0) {
#line 40 "src/file.vala"
			_tmp3_ = TRUE;
#line 548 "file.c"
		} else {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
#line 40 "src/file.vala"
			_tmp7_ = epath;
#line 40 "src/file.vala"
			_tmp8_ = epath;
#line 40 "src/file.vala"
			_tmp9_ = strlen (_tmp8_);
#line 40 "src/file.vala"
			_tmp10_ = _tmp9_;
#line 40 "src/file.vala"
			_tmp3_ = string_get (_tmp7_, (glong) (_tmp10_ - 1)) != '/';
#line 564 "file.c"
		}
#line 40 "src/file.vala"
		if (_tmp3_) {
#line 568 "file.c"
			const gchar* _tmp11_;
			gchar* _tmp12_;
#line 41 "src/file.vala"
			_tmp11_ = epath;
#line 41 "src/file.vala"
			_tmp12_ = g_strconcat (_tmp11_, "/", NULL);
#line 41 "src/file.vala"
			_g_free0 (epath);
#line 41 "src/file.vala"
			epath = _tmp12_;
#line 579 "file.c"
		}
	}
	{
		guint i = 0U;
#line 44 "src/file.vala"
		i = (guint) 0;
#line 586 "file.c"
		{
			gboolean _tmp13_ = FALSE;
#line 44 "src/file.vala"
			_tmp13_ = TRUE;
#line 44 "src/file.vala"
			while (TRUE) {
#line 593 "file.c"
				gint _tmp14_;
				gint _tmp15_;
#line 44 "src/file.vala"
				if (!_tmp13_) {
#line 598 "file.c"
				}
#line 44 "src/file.vala"
				_tmp13_ = FALSE;
#line 44 "src/file.vala"
				_tmp14_ = strlen (path);
#line 44 "src/file.vala"
				_tmp15_ = _tmp14_;
#line 44 "src/file.vala"
				if (!(i < ((guint) _tmp15_))) {
#line 44 "src/file.vala"
					break;
#line 610 "file.c"
				}
#line 45 "src/file.vala"
				if (string_get (path, (glong) i) == '/') {
#line 614 "file.c"
					const gchar* _tmp16_;
					guint _tmp17_;
					gboolean _tmp20_ = FALSE;
					const gchar* _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
#line 46 "src/file.vala"
					_tmp16_ = path;
#line 46 "src/file.vala"
					i = i + 1;
#line 46 "src/file.vala"
					_tmp17_ = i;
#line 46 "src/file.vala"
					if (string_get (_tmp16_, (glong) _tmp17_) == '/') {
#line 629 "file.c"
						gchar* _tmp19_;
#line 48 "src/file.vala"
						while (TRUE) {
#line 633 "file.c"
							guint _tmp18_;
#line 48 "src/file.vala"
							if (!(string_get (path, (glong) i) == '/')) {
#line 48 "src/file.vala"
								break;
#line 639 "file.c"
							}
#line 49 "src/file.vala"
							_tmp18_ = i;
#line 49 "src/file.vala"
							i = _tmp18_ + 1;
#line 645 "file.c"
						}
#line 50 "src/file.vala"
						_tmp19_ = g_strdup ("");
#line 50 "src/file.vala"
						_g_free0 (epath);
#line 50 "src/file.vala"
						epath = _tmp19_;
#line 653 "file.c"
					}
#line 52 "src/file.vala"
					_tmp21_ = epath;
#line 52 "src/file.vala"
					_tmp22_ = strlen (_tmp21_);
#line 52 "src/file.vala"
					_tmp23_ = _tmp22_;
#line 52 "src/file.vala"
					if (_tmp23_ == 0) {
#line 52 "src/file.vala"
						_tmp20_ = TRUE;
#line 665 "file.c"
					} else {
						const gchar* _tmp24_;
						const gchar* _tmp25_;
						gint _tmp26_;
						gint _tmp27_;
#line 52 "src/file.vala"
						_tmp24_ = epath;
#line 52 "src/file.vala"
						_tmp25_ = epath;
#line 52 "src/file.vala"
						_tmp26_ = strlen (_tmp25_);
#line 52 "src/file.vala"
						_tmp27_ = _tmp26_;
#line 52 "src/file.vala"
						_tmp20_ = string_get (_tmp24_, (glong) (_tmp27_ - 1)) != '/';
#line 681 "file.c"
					}
#line 52 "src/file.vala"
					if (_tmp20_) {
#line 685 "file.c"
						const gchar* _tmp28_;
						gchar* _tmp29_;
#line 53 "src/file.vala"
						_tmp28_ = epath;
#line 53 "src/file.vala"
						_tmp29_ = g_strconcat (_tmp28_, "/", NULL);
#line 53 "src/file.vala"
						_g_free0 (epath);
#line 53 "src/file.vala"
						epath = _tmp29_;
#line 696 "file.c"
					}
				} else {
					gboolean _tmp30_ = FALSE;
#line 54 "src/file.vala"
					if (string_get (path, (glong) i) == '~') {
#line 702 "file.c"
						gboolean _tmp31_ = FALSE;
#line 54 "src/file.vala"
						if (i == ((guint) 0)) {
#line 54 "src/file.vala"
							_tmp31_ = TRUE;
#line 708 "file.c"
						} else {
#line 54 "src/file.vala"
							_tmp31_ = string_get (path, (glong) (i - 1)) == '/';
#line 712 "file.c"
						}
#line 54 "src/file.vala"
						_tmp30_ = _tmp31_;
#line 716 "file.c"
					} else {
#line 54 "src/file.vala"
						_tmp30_ = FALSE;
#line 720 "file.c"
					}
#line 54 "src/file.vala"
					if (_tmp30_) {
#line 724 "file.c"
						gchar* _tmp32_;
						guint _tmp33_;
#line 56 "src/file.vala"
						_tmp32_ = g_strdup ("");
#line 56 "src/file.vala"
						_g_free0 (epath);
#line 56 "src/file.vala"
						epath = _tmp32_;
#line 57 "src/file.vala"
						i = i + 1;
#line 57 "src/file.vala"
						_tmp33_ = i;
#line 59 "src/file.vala"
						if (string_get (path, (glong) i) == '/') {
#line 739 "file.c"
							struct passwd* pw = NULL;
							struct passwd* _tmp34_;
							struct passwd* _tmp35_;
							struct passwd* _tmp36_;
							const gchar* _tmp37_;
#line 61 "src/file.vala"
							_tmp34_ = getpwuid (getuid ());
#line 61 "src/file.vala"
							pw = _tmp34_;
#line 62 "src/file.vala"
							_tmp35_ = pw;
#line 62 "src/file.vala"
							if (_tmp35_ == NULL) {
#line 63 "src/file.vala"
								ok = FALSE;
#line 64 "src/file.vala"
								break;
#line 757 "file.c"
							}
#line 66 "src/file.vala"
							_tmp36_ = pw;
#line 66 "src/file.vala"
							_tmp37_ = _tmp36_->pw_dir;
#line 66 "src/file.vala"
							if (g_strcmp0 (_tmp37_, "/") != 0) {
#line 765 "file.c"
								const gchar* _tmp38_;
								struct passwd* _tmp39_;
								const gchar* _tmp40_;
								gchar* _tmp41_;
#line 67 "src/file.vala"
								_tmp38_ = epath;
#line 67 "src/file.vala"
								_tmp39_ = pw;
#line 67 "src/file.vala"
								_tmp40_ = _tmp39_->pw_dir;
#line 67 "src/file.vala"
								_tmp41_ = g_strconcat (_tmp38_, _tmp40_, NULL);
#line 67 "src/file.vala"
								_g_free0 (epath);
#line 67 "src/file.vala"
								epath = _tmp41_;
#line 782 "file.c"
							}
						} else {
							gchar* a = NULL;
							gchar* _tmp42_;
							struct passwd* pw = NULL;
							const gchar* _tmp50_;
							struct passwd* _tmp51_;
							struct passwd* _tmp52_;
							const gchar* _tmp53_;
							struct passwd* _tmp54_;
							const gchar* _tmp55_;
							gchar* _tmp56_;
#line 70 "src/file.vala"
							_tmp42_ = g_strdup ("");
#line 70 "src/file.vala"
							a = _tmp42_;
#line 71 "src/file.vala"
							while (TRUE) {
#line 801 "file.c"
								gboolean _tmp43_ = FALSE;
								const gchar* _tmp44_;
								const gchar* _tmp45_;
								guint _tmp46_;
								gchar* _tmp47_;
								gchar* _tmp48_;
								gchar* _tmp49_;
#line 71 "src/file.vala"
								if (string_get (path, (glong) i) != '\0') {
#line 71 "src/file.vala"
									_tmp43_ = string_get (path, (glong) i) != '/';
#line 813 "file.c"
								} else {
#line 71 "src/file.vala"
									_tmp43_ = FALSE;
#line 817 "file.c"
								}
#line 71 "src/file.vala"
								if (!_tmp43_) {
#line 71 "src/file.vala"
									break;
#line 823 "file.c"
								}
#line 72 "src/file.vala"
								_tmp44_ = a;
#line 72 "src/file.vala"
								_tmp45_ = path;
#line 72 "src/file.vala"
								_tmp46_ = i;
#line 72 "src/file.vala"
								i = _tmp46_ + 1;
#line 72 "src/file.vala"
								_tmp47_ = g_strdup_printf ("%c", string_get (_tmp45_, (glong) _tmp46_));
#line 72 "src/file.vala"
								_tmp48_ = _tmp47_;
#line 72 "src/file.vala"
								_tmp49_ = g_strconcat (_tmp44_, _tmp48_, NULL);
#line 72 "src/file.vala"
								_g_free0 (a);
#line 72 "src/file.vala"
								a = _tmp49_;
#line 72 "src/file.vala"
								_g_free0 (_tmp48_);
#line 845 "file.c"
							}
#line 73 "src/file.vala"
							_tmp50_ = a;
#line 73 "src/file.vala"
							_tmp51_ = getpwnam (_tmp50_);
#line 73 "src/file.vala"
							pw = _tmp51_;
#line 74 "src/file.vala"
							_tmp52_ = pw;
#line 74 "src/file.vala"
							if (_tmp52_ == NULL) {
#line 75 "src/file.vala"
								ok = FALSE;
#line 76 "src/file.vala"
								_g_free0 (a);
#line 76 "src/file.vala"
								break;
#line 863 "file.c"
							}
#line 78 "src/file.vala"
							_tmp53_ = epath;
#line 78 "src/file.vala"
							_tmp54_ = pw;
#line 78 "src/file.vala"
							_tmp55_ = _tmp54_->pw_dir;
#line 78 "src/file.vala"
							_tmp56_ = g_strconcat (_tmp53_, _tmp55_, NULL);
#line 78 "src/file.vala"
							_g_free0 (epath);
#line 78 "src/file.vala"
							epath = _tmp56_;
#line 59 "src/file.vala"
							_g_free0 (a);
#line 879 "file.c"
						}
					} else {
						gboolean _tmp57_ = FALSE;
#line 80 "src/file.vala"
						if (string_get (path, (glong) i) == '.') {
#line 885 "file.c"
							gboolean _tmp58_ = FALSE;
#line 80 "src/file.vala"
							if (string_get (path, (glong) (i + 1)) == '/') {
#line 80 "src/file.vala"
								_tmp58_ = TRUE;
#line 891 "file.c"
							} else {
#line 80 "src/file.vala"
								_tmp58_ = string_get (path, (glong) (i + 1)) == '\0';
#line 895 "file.c"
							}
#line 80 "src/file.vala"
							_tmp57_ = _tmp58_;
#line 899 "file.c"
						} else {
#line 80 "src/file.vala"
							_tmp57_ = FALSE;
#line 903 "file.c"
						}
#line 80 "src/file.vala"
						if (_tmp57_) {
#line 907 "file.c"
							guint _tmp59_;
#line 82 "src/file.vala"
							i = i + 1;
#line 82 "src/file.vala"
							_tmp59_ = i;
#line 913 "file.c"
						} else {
							gboolean _tmp60_ = FALSE;
							gboolean _tmp61_ = FALSE;
#line 83 "src/file.vala"
							if (string_get (path, (glong) i) == '.') {
#line 83 "src/file.vala"
								_tmp61_ = string_get (path, (glong) (i + 1)) == '.';
#line 921 "file.c"
							} else {
#line 83 "src/file.vala"
								_tmp61_ = FALSE;
#line 925 "file.c"
							}
#line 83 "src/file.vala"
							if (_tmp61_) {
#line 929 "file.c"
								gboolean _tmp62_ = FALSE;
#line 83 "src/file.vala"
								if (string_get (path, (glong) (i + 2)) == '/') {
#line 83 "src/file.vala"
									_tmp62_ = TRUE;
#line 935 "file.c"
								} else {
#line 83 "src/file.vala"
									_tmp62_ = string_get (path, (glong) (i + 2)) == '\0';
#line 939 "file.c"
								}
#line 83 "src/file.vala"
								_tmp60_ = _tmp62_;
#line 943 "file.c"
							} else {
#line 83 "src/file.vala"
								_tmp60_ = FALSE;
#line 947 "file.c"
							}
#line 83 "src/file.vala"
							if (_tmp60_) {
#line 951 "file.c"
								gboolean _tmp63_ = FALSE;
								const gchar* _tmp64_;
								gint _tmp65_;
								gint _tmp66_;
#line 85 "src/file.vala"
								_tmp64_ = epath;
#line 85 "src/file.vala"
								_tmp65_ = strlen (_tmp64_);
#line 85 "src/file.vala"
								_tmp66_ = _tmp65_;
#line 85 "src/file.vala"
								if (_tmp66_ >= 1) {
#line 964 "file.c"
									const gchar* _tmp67_;
									const gchar* _tmp68_;
									gint _tmp69_;
									gint _tmp70_;
#line 85 "src/file.vala"
									_tmp67_ = epath;
#line 85 "src/file.vala"
									_tmp68_ = epath;
#line 85 "src/file.vala"
									_tmp69_ = strlen (_tmp68_);
#line 85 "src/file.vala"
									_tmp70_ = _tmp69_;
#line 85 "src/file.vala"
									_tmp63_ = string_get (_tmp67_, (glong) (_tmp70_ - 1)) == '/';
#line 979 "file.c"
								} else {
#line 85 "src/file.vala"
									_tmp63_ = FALSE;
#line 983 "file.c"
								}
#line 85 "src/file.vala"
								if (_tmp63_) {
#line 987 "file.c"
									const gchar* _tmp71_;
									gchar* _tmp72_;
#line 86 "src/file.vala"
									_tmp71_ = epath;
#line 86 "src/file.vala"
									_tmp72_ = string_slice (_tmp71_, (glong) 0, (glong) -1);
#line 86 "src/file.vala"
									_g_free0 (epath);
#line 86 "src/file.vala"
									epath = _tmp72_;
#line 998 "file.c"
								}
#line 87 "src/file.vala"
								while (TRUE) {
#line 1002 "file.c"
									gboolean _tmp73_ = FALSE;
									const gchar* _tmp74_;
									const gchar* _tmp75_;
									gint _tmp76_;
									gint _tmp77_;
									const gchar* _tmp81_;
									gchar* _tmp82_;
#line 87 "src/file.vala"
									_tmp74_ = epath;
#line 87 "src/file.vala"
									_tmp75_ = epath;
#line 87 "src/file.vala"
									_tmp76_ = strlen (_tmp75_);
#line 87 "src/file.vala"
									_tmp77_ = _tmp76_;
#line 87 "src/file.vala"
									if (string_get (_tmp74_, (glong) (_tmp77_ - 1)) != '/') {
#line 1020 "file.c"
										const gchar* _tmp78_;
										gint _tmp79_;
										gint _tmp80_;
#line 87 "src/file.vala"
										_tmp78_ = epath;
#line 87 "src/file.vala"
										_tmp79_ = strlen (_tmp78_);
#line 87 "src/file.vala"
										_tmp80_ = _tmp79_;
#line 87 "src/file.vala"
										_tmp73_ = _tmp80_ >= 1;
#line 1032 "file.c"
									} else {
#line 87 "src/file.vala"
										_tmp73_ = FALSE;
#line 1036 "file.c"
									}
#line 87 "src/file.vala"
									if (!_tmp73_) {
#line 87 "src/file.vala"
										break;
#line 1042 "file.c"
									}
#line 88 "src/file.vala"
									_tmp81_ = epath;
#line 88 "src/file.vala"
									_tmp82_ = string_slice (_tmp81_, (glong) 0, (glong) -1);
#line 88 "src/file.vala"
									_g_free0 (epath);
#line 88 "src/file.vala"
									epath = _tmp82_;
#line 1052 "file.c"
								}
#line 89 "src/file.vala"
								i += (guint) 2;
#line 1056 "file.c"
							}
						}
					}
				}
#line 92 "src/file.vala"
				if (string_get (path, (glong) i) != '~') {
#line 93 "src/file.vala"
					while (TRUE) {
#line 1065 "file.c"
						gboolean _tmp83_ = FALSE;
						const gchar* _tmp84_;
						const gchar* _tmp85_;
						guint _tmp86_;
						gchar* _tmp87_;
						gchar* _tmp88_;
						gchar* _tmp89_;
#line 93 "src/file.vala"
						if (string_get (path, (glong) i) != '\0') {
#line 93 "src/file.vala"
							_tmp83_ = string_get (path, (glong) i) != '/';
#line 1077 "file.c"
						} else {
#line 93 "src/file.vala"
							_tmp83_ = FALSE;
#line 1081 "file.c"
						}
#line 93 "src/file.vala"
						if (!_tmp83_) {
#line 93 "src/file.vala"
							break;
#line 1087 "file.c"
						}
#line 94 "src/file.vala"
						_tmp84_ = epath;
#line 94 "src/file.vala"
						_tmp85_ = path;
#line 94 "src/file.vala"
						_tmp86_ = i;
#line 94 "src/file.vala"
						i = _tmp86_ + 1;
#line 94 "src/file.vala"
						_tmp87_ = g_strdup_printf ("%c", string_get (_tmp85_, (glong) _tmp86_));
#line 94 "src/file.vala"
						_tmp88_ = _tmp87_;
#line 94 "src/file.vala"
						_tmp89_ = g_strconcat (_tmp84_, _tmp88_, NULL);
#line 94 "src/file.vala"
						_g_free0 (epath);
#line 94 "src/file.vala"
						epath = _tmp89_;
#line 94 "src/file.vala"
						_g_free0 (_tmp88_);
#line 1109 "file.c"
					}
				}
			}
		}
	}
#line 97 "src/file.vala"
	if (ok) {
#line 1117 "file.c"
		const gchar* _tmp91_;
#line 97 "src/file.vala"
		_tmp91_ = epath;
#line 97 "src/file.vala"
		_tmp90_ = _tmp91_;
#line 1123 "file.c"
	} else {
#line 97 "src/file.vala"
		_tmp90_ = NULL;
#line 1127 "file.c"
	}
#line 97 "src/file.vala"
	_tmp92_ = g_strdup (_tmp90_);
#line 97 "src/file.vala"
	result = _tmp92_;
#line 97 "src/file.vala"
	_g_free0 (epath);
#line 97 "src/file.vala"
	return result;
#line 1137 "file.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
#line 1447 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1447 "glib-2.0.vapi"
	end = _tmp0_;
#line 1448 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1448 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1449 "glib-2.0.vapi"
		result = maxlen;
#line 1449 "glib-2.0.vapi"
		return result;
#line 1160 "file.c"
	} else {
		gchar* _tmp2_;
#line 1451 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1451 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1451 "glib-2.0.vapi"
		return result;
#line 1169 "file.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 1458 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1460 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 1188 "file.c"
	} else {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1192 "file.c"
	}
#line 1460 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1462 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 1198 "file.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1464 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1464 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1464 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 1208 "file.c"
	}
#line 1467 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1468 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1469 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 1216 "file.c"
	} else {
#line 1471 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 1220 "file.c"
	}
#line 1473 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1474 "glib-2.0.vapi"
		len = string_length - offset;
#line 1226 "file.c"
	}
#line 1476 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1477 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1477 "glib-2.0.vapi"
	result = _tmp3_;
#line 1477 "glib-2.0.vapi"
	return result;
#line 1236 "file.c"
}

gchar*
compact_path (const gchar* in_path)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	struct passwd* pw = NULL;
	struct passwd* _tmp1_;
	struct passwd* _tmp2_;
	gchar* result = NULL;
#line 104 "src/file.vala"
	g_return_val_if_fail (in_path != NULL, NULL);
#line 105 "src/file.vala"
	_tmp0_ = g_strdup (in_path);
#line 105 "src/file.vala"
	path = _tmp0_;
#line 106 "src/file.vala"
	_tmp1_ = getpwuid (getuid ());
#line 106 "src/file.vala"
	pw = _tmp1_;
#line 108 "src/file.vala"
	_tmp2_ = pw;
#line 108 "src/file.vala"
	if (_tmp2_ != NULL) {
#line 1262 "file.c"
		guint homelen = 0U;
		struct passwd* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
#line 110 "src/file.vala"
		_tmp3_ = pw;
#line 110 "src/file.vala"
		_tmp4_ = _tmp3_->pw_dir;
#line 110 "src/file.vala"
		_tmp5_ = strlen (_tmp4_);
#line 110 "src/file.vala"
		_tmp6_ = _tmp5_;
#line 110 "src/file.vala"
		homelen = (guint) _tmp6_;
#line 111 "src/file.vala"
		if (homelen > ((guint) 0)) {
#line 1286 "file.c"
			struct passwd* _tmp8_;
			const gchar* _tmp9_;
#line 111 "src/file.vala"
			_tmp8_ = pw;
#line 111 "src/file.vala"
			_tmp9_ = _tmp8_->pw_dir;
#line 111 "src/file.vala"
			_tmp7_ = string_get (_tmp9_, (glong) (homelen - 1)) == '/';
#line 1295 "file.c"
		} else {
#line 111 "src/file.vala"
			_tmp7_ = FALSE;
#line 1299 "file.c"
		}
#line 111 "src/file.vala"
		if (_tmp7_) {
#line 1303 "file.c"
			guint _tmp10_;
#line 112 "src/file.vala"
			_tmp10_ = homelen;
#line 112 "src/file.vala"
			homelen = _tmp10_ - 1;
#line 1309 "file.c"
		}
#line 114 "src/file.vala"
		_tmp13_ = path;
#line 114 "src/file.vala"
		_tmp14_ = strlen (_tmp13_);
#line 114 "src/file.vala"
		_tmp15_ = _tmp14_;
#line 114 "src/file.vala"
		if (((guint) _tmp15_) > homelen) {
#line 1319 "file.c"
			struct passwd* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
#line 115 "src/file.vala"
			_tmp16_ = pw;
#line 115 "src/file.vala"
			_tmp17_ = _tmp16_->pw_dir;
#line 115 "src/file.vala"
			_tmp18_ = path;
#line 115 "src/file.vala"
			_tmp12_ = strncmp (_tmp17_, _tmp18_, (gsize) homelen) == 0;
#line 1331 "file.c"
		} else {
#line 114 "src/file.vala"
			_tmp12_ = FALSE;
#line 1335 "file.c"
		}
#line 114 "src/file.vala"
		if (_tmp12_) {
#line 1339 "file.c"
			const gchar* _tmp19_;
#line 116 "src/file.vala"
			_tmp19_ = path;
#line 116 "src/file.vala"
			_tmp11_ = string_get (_tmp19_, (glong) homelen) == '/';
#line 1345 "file.c"
		} else {
#line 114 "src/file.vala"
			_tmp11_ = FALSE;
#line 1349 "file.c"
		}
#line 114 "src/file.vala"
		if (_tmp11_) {
#line 1353 "file.c"
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
#line 117 "src/file.vala"
			_tmp20_ = path;
#line 117 "src/file.vala"
			_tmp21_ = string_substring (_tmp20_, (glong) (homelen + 1), (glong) -1);
#line 117 "src/file.vala"
			_tmp22_ = _tmp21_;
#line 117 "src/file.vala"
			_tmp23_ = g_strconcat ("~/", _tmp22_, NULL);
#line 117 "src/file.vala"
			_g_free0 (path);
#line 117 "src/file.vala"
			path = _tmp23_;
#line 117 "src/file.vala"
			_g_free0 (_tmp22_);
#line 1372 "file.c"
		}
	}
#line 120 "src/file.vala"
	result = path;
#line 120 "src/file.vala"
	return result;
#line 1379 "file.c"
}

gboolean
check_writable (const gchar* filename)
{
	gboolean result = FALSE;
#line 124 "src/file.vala"
	g_return_val_if_fail (filename != NULL, FALSE);
#line 125 "src/file.vala"
	result = euidaccess (filename, W_OK) >= 0;
#line 125 "src/file.vala"
	return result;
#line 1392 "file.c"
}

static gpointer
_buffer_ref0 (gpointer self)
{
#line 130 "src/file.vala"
	return self ? buffer_ref (self) : NULL;
#line 1400 "file.c"
}

gboolean
find_file (const gchar* filename)
{
	Buffer* bp = NULL;
	Buffer* _tmp9_;
	Buffer* _tmp27_;
	Flags _tmp28_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
#line 128 "src/file.vala"
	g_return_val_if_fail (filename != NULL, FALSE);
#line 1414 "file.c"
	{
		Buffer* _tmp0_;
		Buffer* _tmp1_;
		gboolean _tmp2_ = FALSE;
#line 130 "src/file.vala"
		_tmp0_ = head_bp;
#line 130 "src/file.vala"
		_tmp1_ = _buffer_ref0 (_tmp0_);
#line 130 "src/file.vala"
		_buffer_unref0 (bp);
#line 130 "src/file.vala"
		bp = _tmp1_;
#line 130 "src/file.vala"
		_tmp2_ = TRUE;
#line 130 "src/file.vala"
		while (TRUE) {
#line 1431 "file.c"
			Buffer* _tmp6_;
			Buffer* _tmp7_;
			const gchar* _tmp8_;
#line 130 "src/file.vala"
			if (!_tmp2_) {
#line 1437 "file.c"
				Buffer* _tmp3_;
				Buffer* _tmp4_;
				Buffer* _tmp5_;
#line 130 "src/file.vala"
				_tmp3_ = bp;
#line 130 "src/file.vala"
				_tmp4_ = _tmp3_->next;
#line 130 "src/file.vala"
				_tmp5_ = _buffer_ref0 (_tmp4_);
#line 130 "src/file.vala"
				_buffer_unref0 (bp);
#line 130 "src/file.vala"
				bp = _tmp5_;
#line 1451 "file.c"
			}
#line 130 "src/file.vala"
			_tmp2_ = FALSE;
#line 130 "src/file.vala"
			_tmp6_ = bp;
#line 130 "src/file.vala"
			if (!(_tmp6_ != NULL)) {
#line 130 "src/file.vala"
				break;
#line 1461 "file.c"
			}
#line 131 "src/file.vala"
			_tmp7_ = bp;
#line 131 "src/file.vala"
			_tmp8_ = _tmp7_->filename;
#line 131 "src/file.vala"
			if (g_strcmp0 (_tmp8_, filename) == 0) {
#line 132 "src/file.vala"
				break;
#line 1471 "file.c"
			}
		}
	}
#line 134 "src/file.vala"
	_tmp9_ = bp;
#line 134 "src/file.vala"
	if (_tmp9_ == NULL) {
#line 1479 "file.c"
		gboolean _tmp10_ = FALSE;
#line 135 "src/file.vala"
		if (g_file_test (filename, G_FILE_TEST_EXISTS)) {
#line 136 "src/file.vala"
			_tmp10_ = !g_file_test (filename, G_FILE_TEST_IS_REGULAR);
#line 1485 "file.c"
		} else {
#line 135 "src/file.vala"
			_tmp10_ = FALSE;
#line 1489 "file.c"
		}
#line 135 "src/file.vala"
		if (_tmp10_) {
#line 137 "src/file.vala"
			minibuf_error ("File exists but could not be read", NULL);
#line 138 "src/file.vala"
			result = FALSE;
#line 138 "src/file.vala"
			_buffer_unref0 (bp);
#line 138 "src/file.vala"
			return result;
#line 1501 "file.c"
		} else {
			Estr* es = NULL;
			Buffer* _tmp21_;
			Buffer* _tmp22_;
			gchar* _tmp23_;
			Buffer* _tmp24_;
			Buffer* _tmp25_;
			Buffer* _tmp26_;
			{
				Estr* _tmp11_ = NULL;
				Estr* _tmp12_;
				Estr* _tmp13_;
				Estr* _tmp14_;
				Buffer* _tmp15_;
				Buffer* _tmp16_;
#line 142 "src/file.vala"
				_tmp12_ = estr_from_file (filename, &_inner_error0_);
#line 142 "src/file.vala"
				_tmp11_ = _tmp12_;
#line 142 "src/file.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1523 "file.c"
					goto __catch0_g_error;
				}
#line 142 "src/file.vala"
				_tmp13_ = _tmp11_;
#line 142 "src/file.vala"
				_tmp11_ = NULL;
#line 142 "src/file.vala"
				_immutable_estr_unref0 (es);
#line 142 "src/file.vala"
				es = _tmp13_;
#line 143 "src/file.vala"
				_tmp14_ = es;
#line 143 "src/file.vala"
				_tmp15_ = buffer_new (_tmp14_);
#line 143 "src/file.vala"
				_buffer_unref0 (bp);
#line 143 "src/file.vala"
				bp = _tmp15_;
#line 144 "src/file.vala"
				_tmp16_ = bp;
#line 144 "src/file.vala"
				_tmp16_->readonly = !check_writable (filename);
#line 141 "src/file.vala"
				_immutable_estr_unref0 (_tmp11_);
#line 1548 "file.c"
			}
			goto __finally0;
			__catch0_g_error:
			{
				Estr* _tmp17_;
				Estr* _tmp18_;
				Buffer* _tmp19_;
#line 141 "src/file.vala"
				g_clear_error (&_inner_error0_);
#line 146 "src/file.vala"
				_tmp17_ = estr_of_empty (IMMUTABLE_ESTR_eol_lf);
#line 146 "src/file.vala"
				_tmp18_ = _tmp17_;
#line 146 "src/file.vala"
				_tmp19_ = buffer_new (_tmp18_);
#line 146 "src/file.vala"
				_buffer_unref0 (bp);
#line 146 "src/file.vala"
				bp = _tmp19_;
#line 146 "src/file.vala"
				_immutable_estr_unref0 (_tmp18_);
#line 1570 "file.c"
			}
			__finally0:
#line 141 "src/file.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1575 "file.c"
				gboolean _tmp20_ = FALSE;
#line 141 "src/file.vala"
				_immutable_estr_unref0 (es);
#line 141 "src/file.vala"
				_buffer_unref0 (bp);
#line 141 "src/file.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 141 "src/file.vala"
				g_clear_error (&_inner_error0_);
#line 141 "src/file.vala"
				return _tmp20_;
#line 1587 "file.c"
			}
#line 148 "src/file.vala"
			_tmp21_ = bp;
#line 148 "src/file.vala"
			buffer_set_names (_tmp21_, filename);
#line 149 "src/file.vala"
			_tmp22_ = bp;
#line 149 "src/file.vala"
			_tmp23_ = g_path_get_dirname (filename);
#line 149 "src/file.vala"
			_g_free0 (_tmp22_->dir);
#line 149 "src/file.vala"
			_tmp22_->dir = _tmp23_;
#line 152 "src/file.vala"
			_tmp24_ = bp;
#line 152 "src/file.vala"
			_tmp24_->next_undop = NULL;
#line 153 "src/file.vala"
			_tmp25_ = bp;
#line 153 "src/file.vala"
			_tmp25_->last_undop = NULL;
#line 154 "src/file.vala"
			_tmp26_ = bp;
#line 154 "src/file.vala"
			_tmp26_->modified = FALSE;
#line 135 "src/file.vala"
			_immutable_estr_unref0 (es);
#line 1615 "file.c"
		}
	}
#line 158 "src/file.vala"
	_tmp27_ = bp;
#line 158 "src/file.vala"
	buffer_switch_to (_tmp27_);
#line 159 "src/file.vala"
	_tmp28_ = thisflag;
#line 159 "src/file.vala"
	thisflag = _tmp28_ | FLAGS_NEED_RESYNC;
#line 160 "src/file.vala"
	result = TRUE;
#line 160 "src/file.vala"
	_buffer_unref0 (bp);
#line 160 "src/file.vala"
	return result;
#line 1632 "file.c"
}

gint
write_all (gint fd,
           gchar* data,
           gsize length)
{
	gint result = 0;
	{
		gsize tot_written = 0UL;
#line 165 "src/file.vala"
		tot_written = (gsize) 0;
#line 1645 "file.c"
		{
			gboolean _tmp0_ = FALSE;
#line 165 "src/file.vala"
			_tmp0_ = TRUE;
#line 165 "src/file.vala"
			while (TRUE) {
#line 1652 "file.c"
				gssize written = 0L;
#line 165 "src/file.vala"
				if (!_tmp0_) {
#line 1656 "file.c"
				}
#line 165 "src/file.vala"
				_tmp0_ = FALSE;
#line 165 "src/file.vala"
				if (!(tot_written < length)) {
#line 165 "src/file.vala"
					break;
#line 1664 "file.c"
				}
#line 166 "src/file.vala"
				written = write (fd, data, length);
#line 167 "src/file.vala"
				if (written < ((gssize) 0)) {
#line 168 "src/file.vala"
					result = (gint) written;
#line 168 "src/file.vala"
					return result;
#line 1674 "file.c"
				}
#line 169 "src/file.vala"
				if (written == ((gssize) 0)) {
#line 170 "src/file.vala"
					result = 1;
#line 170 "src/file.vala"
					return result;
#line 1682 "file.c"
				}
#line 171 "src/file.vala"
				tot_written += (gsize) written;
#line 1686 "file.c"
			}
		}
	}
#line 173 "src/file.vala"
	result = 0;
#line 173 "src/file.vala"
	return result;
#line 1694 "file.c"
}

gint
write_to_disk (Buffer* bp,
               const gchar* filename,
               mode_t mode)
{
	gint fd = 0;
	ImmutableEstr* es = NULL;
	ImmutableEstr* _tmp0_;
	gint ret = 0;
	ImmutableEstr* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ImmutableEstr* _tmp4_;
	gsize _tmp5_;
	gsize _tmp6_;
	gboolean _tmp14_ = FALSE;
	gint result = 0;
#line 179 "src/file.vala"
	g_return_val_if_fail (bp != NULL, 0);
#line 179 "src/file.vala"
	g_return_val_if_fail (filename != NULL, 0);
#line 180 "src/file.vala"
	fd = creat (filename, mode);
#line 181 "src/file.vala"
	if (fd < 0) {
#line 182 "src/file.vala"
		result = -1;
#line 182 "src/file.vala"
		return result;
#line 1726 "file.c"
	}
#line 184 "src/file.vala"
	_tmp0_ = buffer_pre_point (bp);
#line 184 "src/file.vala"
	es = _tmp0_;
#line 185 "src/file.vala"
	_tmp1_ = es;
#line 185 "src/file.vala"
	_tmp2_ = immutable_estr_get_text (_tmp1_);
#line 185 "src/file.vala"
	_tmp3_ = _tmp2_;
#line 185 "src/file.vala"
	_tmp4_ = es;
#line 185 "src/file.vala"
	_tmp5_ = immutable_estr_get_length (_tmp4_);
#line 185 "src/file.vala"
	_tmp6_ = _tmp5_;
#line 185 "src/file.vala"
	ret = write_all (fd, _tmp3_, _tmp6_);
#line 186 "src/file.vala"
	if (ret == 0) {
#line 1748 "file.c"
		ImmutableEstr* _tmp7_;
		ImmutableEstr* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		ImmutableEstr* _tmp11_;
		gsize _tmp12_;
		gsize _tmp13_;
#line 187 "src/file.vala"
		_tmp7_ = buffer_post_point (bp);
#line 187 "src/file.vala"
		_immutable_estr_unref0 (es);
#line 187 "src/file.vala"
		es = _tmp7_;
#line 188 "src/file.vala"
		_tmp8_ = es;
#line 188 "src/file.vala"
		_tmp9_ = immutable_estr_get_text (_tmp8_);
#line 188 "src/file.vala"
		_tmp10_ = _tmp9_;
#line 188 "src/file.vala"
		_tmp11_ = es;
#line 188 "src/file.vala"
		_tmp12_ = immutable_estr_get_length (_tmp11_);
#line 188 "src/file.vala"
		_tmp13_ = _tmp12_;
#line 188 "src/file.vala"
		ret = write_all (fd, _tmp10_, _tmp13_);
#line 1776 "file.c"
	}
#line 191 "src/file.vala"
	if (close (fd) < 0) {
#line 191 "src/file.vala"
		_tmp14_ = ret == 0;
#line 1782 "file.c"
	} else {
#line 191 "src/file.vala"
		_tmp14_ = FALSE;
#line 1786 "file.c"
	}
#line 191 "src/file.vala"
	if (_tmp14_) {
#line 192 "src/file.vala"
		ret = -1;
#line 1792 "file.c"
	}
#line 194 "src/file.vala"
	result = ret;
#line 194 "src/file.vala"
	_immutable_estr_unref0 (es);
#line 194 "src/file.vala"
	return result;
#line 1800 "file.c"
}

gchar*
create_backup_filename (const gchar* filename,
                        const gchar* backupdir)
{
	gchar* res = NULL;
	const gchar* _tmp19_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* result = NULL;
#line 200 "src/file.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 201 "src/file.vala"
	res = NULL;
#line 204 "src/file.vala"
	if (backupdir != NULL) {
#line 1818 "file.c"
		gchar* buf = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
#line 205 "src/file.vala"
		_tmp0_ = g_strdup (backupdir);
#line 205 "src/file.vala"
		buf = _tmp0_;
#line 206 "src/file.vala"
		_tmp1_ = buf;
#line 206 "src/file.vala"
		_tmp2_ = buf;
#line 206 "src/file.vala"
		_tmp3_ = strlen (_tmp2_);
#line 206 "src/file.vala"
		_tmp4_ = _tmp3_;
#line 206 "src/file.vala"
		if (string_get (_tmp1_, (glong) (_tmp4_ - 1)) != '/') {
#line 1841 "file.c"
			const gchar* _tmp5_;
			gchar* _tmp6_;
#line 207 "src/file.vala"
			_tmp5_ = buf;
#line 207 "src/file.vala"
			_tmp6_ = g_strconcat (_tmp5_, "/", NULL);
#line 207 "src/file.vala"
			_g_free0 (buf);
#line 207 "src/file.vala"
			buf = _tmp6_;
#line 1852 "file.c"
		}
		{
			guint i = 0U;
#line 208 "src/file.vala"
			i = (guint) 0;
#line 1858 "file.c"
			{
				gboolean _tmp7_ = FALSE;
#line 208 "src/file.vala"
				_tmp7_ = TRUE;
#line 208 "src/file.vala"
				while (TRUE) {
#line 1865 "file.c"
					gint _tmp9_;
					gint _tmp10_;
#line 208 "src/file.vala"
					if (!_tmp7_) {
#line 1870 "file.c"
						guint _tmp8_;
#line 208 "src/file.vala"
						_tmp8_ = i;
#line 208 "src/file.vala"
						i = _tmp8_ + 1;
#line 1876 "file.c"
					}
#line 208 "src/file.vala"
					_tmp7_ = FALSE;
#line 208 "src/file.vala"
					_tmp9_ = strlen (filename);
#line 208 "src/file.vala"
					_tmp10_ = _tmp9_;
#line 208 "src/file.vala"
					if (!(i < ((guint) _tmp10_))) {
#line 208 "src/file.vala"
						break;
#line 1888 "file.c"
					}
#line 209 "src/file.vala"
					if (string_get (filename, (glong) i) == '/') {
#line 1892 "file.c"
						const gchar* _tmp11_;
						gchar* _tmp12_;
#line 210 "src/file.vala"
						_tmp11_ = buf;
#line 210 "src/file.vala"
						_tmp12_ = g_strconcat (_tmp11_, "!", NULL);
#line 210 "src/file.vala"
						_g_free0 (buf);
#line 210 "src/file.vala"
						buf = _tmp12_;
#line 1903 "file.c"
					} else {
						const gchar* _tmp13_;
						gchar* _tmp14_;
						gchar* _tmp15_;
						gchar* _tmp16_;
#line 212 "src/file.vala"
						_tmp13_ = buf;
#line 212 "src/file.vala"
						_tmp14_ = g_strdup_printf ("%c", string_get (filename, (glong) i));
#line 212 "src/file.vala"
						_tmp15_ = _tmp14_;
#line 212 "src/file.vala"
						_tmp16_ = g_strconcat (_tmp13_, _tmp15_, NULL);
#line 212 "src/file.vala"
						_g_free0 (buf);
#line 212 "src/file.vala"
						buf = _tmp16_;
#line 212 "src/file.vala"
						_g_free0 (_tmp15_);
#line 1923 "file.c"
					}
				}
			}
		}
#line 214 "src/file.vala"
		_tmp17_ = buf;
#line 214 "src/file.vala"
		_tmp18_ = expand_path (_tmp17_);
#line 214 "src/file.vala"
		_g_free0 (res);
#line 214 "src/file.vala"
		res = _tmp18_;
#line 204 "src/file.vala"
		_g_free0 (buf);
#line 1938 "file.c"
	}
#line 217 "src/file.vala"
	_tmp19_ = res;
#line 217 "src/file.vala"
	if (_tmp19_ == NULL) {
#line 1944 "file.c"
		gchar* _tmp20_;
#line 218 "src/file.vala"
		_tmp20_ = g_strdup (filename);
#line 218 "src/file.vala"
		_g_free0 (res);
#line 218 "src/file.vala"
		res = _tmp20_;
#line 1952 "file.c"
	}
#line 220 "src/file.vala"
	_tmp21_ = res;
#line 220 "src/file.vala"
	_tmp22_ = g_strconcat (_tmp21_, "~", NULL);
#line 220 "src/file.vala"
	result = _tmp22_;
#line 220 "src/file.vala"
	_g_free0 (res);
#line 220 "src/file.vala"
	return result;
#line 1964 "file.c"
}

gboolean
backup_and_write (Buffer* bp,
                  const gchar* filename)
{
	gint fd = 0;
	gboolean backup = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint ret = 0;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
#line 227 "src/file.vala"
	g_return_val_if_fail (bp != NULL, FALSE);
#line 227 "src/file.vala"
	g_return_val_if_fail (filename != NULL, FALSE);
#line 229 "src/file.vala"
	fd = 0;
#line 230 "src/file.vala"
	backup = get_variable_bool ("make-backup-files");
#line 231 "src/file.vala"
	if (bp->backup) {
#line 231 "src/file.vala"
		_tmp1_ = backup;
#line 1990 "file.c"
	} else {
#line 231 "src/file.vala"
		_tmp1_ = FALSE;
#line 1994 "file.c"
	}
#line 231 "src/file.vala"
	if (_tmp1_) {
#line 231 "src/file.vala"
		fd = open (filename, O_RDWR, (mode_t) 0);
#line 231 "src/file.vala"
		_tmp0_ = fd != -1;
#line 2002 "file.c"
	} else {
#line 231 "src/file.vala"
		_tmp0_ = FALSE;
#line 2006 "file.c"
	}
#line 231 "src/file.vala"
	if (_tmp0_) {
#line 2010 "file.c"
		const gchar* _tmp2_ = NULL;
		gchar* backupdir = NULL;
		gchar* _tmp4_;
		gchar* bfilename = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
#line 232 "src/file.vala"
		close (fd);
#line 234 "src/file.vala"
		if (get_variable_bool ("backup-directory")) {
#line 2022 "file.c"
			const gchar* _tmp3_;
#line 235 "src/file.vala"
			_tmp3_ = get_variable ("backup-directory");
#line 235 "src/file.vala"
			_tmp2_ = _tmp3_;
#line 2028 "file.c"
		} else {
#line 235 "src/file.vala"
			_tmp2_ = NULL;
#line 2032 "file.c"
		}
#line 234 "src/file.vala"
		_tmp4_ = g_strdup (_tmp2_);
#line 234 "src/file.vala"
		backupdir = _tmp4_;
#line 236 "src/file.vala"
		_tmp5_ = backupdir;
#line 236 "src/file.vala"
		_tmp6_ = create_backup_filename (filename, _tmp5_);
#line 236 "src/file.vala"
		bfilename = _tmp6_;
#line 237 "src/file.vala"
		_tmp7_ = bfilename;
#line 237 "src/file.vala"
		if (_tmp7_ != NULL) {
#line 2048 "file.c"
			{
				GFile* _tmp8_;
				GFile* _tmp9_;
				const gchar* _tmp10_;
				GFile* _tmp11_;
				GFile* _tmp12_;
#line 239 "src/file.vala"
				_tmp8_ = g_file_new_for_path (filename);
#line 239 "src/file.vala"
				_tmp9_ = _tmp8_;
#line 239 "src/file.vala"
				_tmp10_ = bfilename;
#line 239 "src/file.vala"
				_tmp11_ = g_file_new_for_path (_tmp10_);
#line 239 "src/file.vala"
				_tmp12_ = _tmp11_;
#line 239 "src/file.vala"
				g_file_copy (_tmp9_, _tmp12_, G_FILE_COPY_ALL_METADATA, NULL, NULL, NULL, &_inner_error0_);
#line 239 "src/file.vala"
				_g_object_unref0 (_tmp12_);
#line 239 "src/file.vala"
				_g_object_unref0 (_tmp9_);
#line 239 "src/file.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2073 "file.c"
					goto __catch0_g_error;
				}
#line 241 "src/file.vala"
				bp->backup = TRUE;
#line 2078 "file.c"
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp13_;
				const gchar* _tmp14_;
#line 238 "src/file.vala"
				e = _inner_error0_;
#line 238 "src/file.vala"
				_inner_error0_ = NULL;
#line 243 "src/file.vala"
				_tmp13_ = e;
#line 243 "src/file.vala"
				_tmp14_ = _tmp13_->message;
#line 243 "src/file.vala"
				minibuf_error ("Cannot make backup file: %s", _tmp14_, NULL);
#line 244 "src/file.vala"
				waitkey ();
#line 238 "src/file.vala"
				_g_error_free0 (e);
#line 2100 "file.c"
			}
			__finally0:
#line 238 "src/file.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2105 "file.c"
				gboolean _tmp15_ = FALSE;
#line 238 "src/file.vala"
				_g_free0 (bfilename);
#line 238 "src/file.vala"
				_g_free0 (backupdir);
#line 238 "src/file.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 238 "src/file.vala"
				g_clear_error (&_inner_error0_);
#line 238 "src/file.vala"
				return _tmp15_;
#line 2117 "file.c"
			}
		}
#line 231 "src/file.vala"
		_g_free0 (bfilename);
#line 231 "src/file.vala"
		_g_free0 (backupdir);
#line 2124 "file.c"
	}
#line 248 "src/file.vala"
	ret = write_to_disk (bp, filename, ((((S_IRUSR | S_IWUSR) | S_IRGRP) | S_IWGRP) | S_IROTH) | S_IWOTH);
#line 249 "src/file.vala"
	if (ret == 0) {
#line 250 "src/file.vala"
		result = TRUE;
#line 250 "src/file.vala"
		return result;
#line 2134 "file.c"
	}
#line 252 "src/file.vala"
	if (ret == -1) {
#line 2138 "file.c"
		const gchar* _tmp16_;
#line 253 "src/file.vala"
		_tmp16_ = strerror (errno);
#line 253 "src/file.vala"
		minibuf_error ("Error writing `%s': %s", filename, _tmp16_, NULL);
#line 2144 "file.c"
	} else {
#line 255 "src/file.vala"
		minibuf_error ("Error writing `%s'", filename, NULL);
#line 2148 "file.c"
	}
#line 256 "src/file.vala"
	result = FALSE;
#line 256 "src/file.vala"
	return result;
#line 2154 "file.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1570 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1571 "glib-2.0.vapi"
	result = self;
#line 1571 "glib-2.0.vapi"
	return result;
#line 2167 "file.c"
}

gboolean
write_buffer (Buffer* bp,
              gboolean needname,
              gboolean confirm,
              const gchar* name0,
              const gchar* prompt)
{
	gint ans = 0;
	gboolean ok = FALSE;
	gchar* name = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean result = FALSE;
#line 259 "src/file.vala"
	g_return_val_if_fail (bp != NULL, FALSE);
#line 259 "src/file.vala"
	g_return_val_if_fail (prompt != NULL, FALSE);
#line 260 "src/file.vala"
	ans = 1;
#line 261 "src/file.vala"
	ok = TRUE;
#line 262 "src/file.vala"
	name = NULL;
#line 264 "src/file.vala"
	if (!needname) {
#line 2194 "file.c"
		gchar* _tmp0_;
#line 265 "src/file.vala"
		_vala_assert (name0 != NULL, "name0 != null");
#line 266 "src/file.vala"
		_tmp0_ = g_strdup (name0);
#line 266 "src/file.vala"
		_g_free0 (name);
#line 266 "src/file.vala"
		name = _tmp0_;
#line 2204 "file.c"
	} else {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 268 "src/file.vala"
		_tmp1_ = minibuf_read_filename ("%s", "", NULL, prompt, NULL);
#line 268 "src/file.vala"
		_g_free0 (name);
#line 268 "src/file.vala"
		name = _tmp1_;
#line 269 "src/file.vala"
		_tmp2_ = name;
#line 269 "src/file.vala"
		if (_tmp2_ == NULL) {
#line 270 "src/file.vala"
			result = funcall ("keyboard-quit", NULL, NULL);
#line 270 "src/file.vala"
			_g_free0 (name);
#line 270 "src/file.vala"
			return result;
#line 2227 "file.c"
		}
#line 271 "src/file.vala"
		_tmp3_ = name;
#line 271 "src/file.vala"
		_tmp4_ = strlen (_tmp3_);
#line 271 "src/file.vala"
		_tmp5_ = _tmp4_;
#line 271 "src/file.vala"
		if (_tmp5_ == 0) {
#line 272 "src/file.vala"
			result = FALSE;
#line 272 "src/file.vala"
			_g_free0 (name);
#line 272 "src/file.vala"
			return result;
#line 2243 "file.c"
		}
#line 273 "src/file.vala"
		confirm = TRUE;
#line 2247 "file.c"
	}
#line 276 "src/file.vala"
	if (confirm) {
#line 2251 "file.c"
		const gchar* _tmp7_;
#line 276 "src/file.vala"
		_tmp7_ = name;
#line 276 "src/file.vala"
		_tmp6_ = g_file_test (_tmp7_, G_FILE_TEST_EXISTS);
#line 2257 "file.c"
	} else {
#line 276 "src/file.vala"
		_tmp6_ = FALSE;
#line 2261 "file.c"
	}
#line 276 "src/file.vala"
	if (_tmp6_) {
#line 2265 "file.c"
		gchar* buf = NULL;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* errmsg = NULL;
		gchar* _tmp11_;
#line 277 "src/file.vala"
		_tmp8_ = name;
#line 277 "src/file.vala"
		_tmp9_ = string_to_string (_tmp8_);
#line 277 "src/file.vala"
		_tmp10_ = g_strconcat ("File `", _tmp9_, "' exists; overwrite? (y or n) ", NULL);
#line 277 "src/file.vala"
		buf = _tmp10_;
#line 278 "src/file.vala"
		_tmp11_ = g_strdup ("");
#line 278 "src/file.vala"
		errmsg = _tmp11_;
#line 2284 "file.c"
		{
			gboolean _tmp12_ = FALSE;
#line 280 "src/file.vala"
			ans = -2;
#line 280 "src/file.vala"
			_tmp12_ = TRUE;
#line 280 "src/file.vala"
			while (TRUE) {
#line 2293 "file.c"
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				Keystroke key = 0U;
				gboolean _tmp15_ = FALSE;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
#line 280 "src/file.vala"
				if (!_tmp12_) {
#line 2302 "file.c"
				}
#line 280 "src/file.vala"
				_tmp12_ = FALSE;
#line 280 "src/file.vala"
				if (!(ans == -2)) {
#line 280 "src/file.vala"
					break;
#line 2310 "file.c"
				}
#line 281 "src/file.vala"
				_tmp13_ = errmsg;
#line 281 "src/file.vala"
				_tmp14_ = buf;
#line 281 "src/file.vala"
				minibuf_write ("%s%s", _tmp13_, _tmp14_, NULL);
#line 282 "src/file.vala"
				key = getkeystroke (GETKEY_DEFAULT);
#line 283 "src/file.vala"
				if (key == ((Keystroke) 'y')) {
#line 283 "src/file.vala"
					_tmp17_ = TRUE;
#line 2324 "file.c"
				} else {
#line 283 "src/file.vala"
					_tmp17_ = key == ((Keystroke) 'Y');
#line 2328 "file.c"
				}
#line 283 "src/file.vala"
				if (_tmp17_) {
#line 283 "src/file.vala"
					_tmp16_ = TRUE;
#line 2334 "file.c"
				} else {
#line 283 "src/file.vala"
					_tmp16_ = key == ((Keystroke) ' ');
#line 2338 "file.c"
				}
#line 283 "src/file.vala"
				if (_tmp16_) {
#line 283 "src/file.vala"
					_tmp15_ = TRUE;
#line 2344 "file.c"
				} else {
#line 283 "src/file.vala"
					_tmp15_ = key == KBD_RET;
#line 2348 "file.c"
				}
#line 283 "src/file.vala"
				if (_tmp15_) {
#line 284 "src/file.vala"
					ans = 1;
#line 2354 "file.c"
				} else {
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
#line 285 "src/file.vala"
					if (key == ((Keystroke) 'N')) {
#line 285 "src/file.vala"
						_tmp19_ = TRUE;
#line 2362 "file.c"
					} else {
#line 285 "src/file.vala"
						_tmp19_ = key == ((Keystroke) 'n');
#line 2366 "file.c"
					}
#line 285 "src/file.vala"
					if (_tmp19_) {
#line 285 "src/file.vala"
						_tmp18_ = TRUE;
#line 2372 "file.c"
					} else {
#line 285 "src/file.vala"
						_tmp18_ = key == KBD_DEL;
#line 2376 "file.c"
					}
#line 285 "src/file.vala"
					if (_tmp18_) {
#line 286 "src/file.vala"
						ans = 0;
#line 2382 "file.c"
					} else {
#line 287 "src/file.vala"
						if (key == (KBD_CTRL | 'g')) {
#line 288 "src/file.vala"
							ans = -1;
#line 2388 "file.c"
						} else {
							gchar* _tmp20_;
#line 290 "src/file.vala"
							_tmp20_ = g_strdup ("Please answer y or n.  ");
#line 290 "src/file.vala"
							_g_free0 (errmsg);
#line 290 "src/file.vala"
							errmsg = _tmp20_;
#line 2397 "file.c"
						}
					}
				}
			}
		}
#line 293 "src/file.vala"
		if (ans == -1) {
#line 294 "src/file.vala"
			funcall ("keyboard-quit", NULL, NULL);
#line 2407 "file.c"
		} else {
#line 295 "src/file.vala"
			if (ans == 0) {
#line 296 "src/file.vala"
				minibuf_error ("Canceled", NULL);
#line 2413 "file.c"
			}
		}
#line 297 "src/file.vala"
		if (ans != 1) {
#line 298 "src/file.vala"
			ok = FALSE;
#line 2420 "file.c"
		}
#line 276 "src/file.vala"
		_g_free0 (errmsg);
#line 276 "src/file.vala"
		_g_free0 (buf);
#line 2426 "file.c"
	}
#line 301 "src/file.vala"
	if (ans == 1) {
#line 2430 "file.c"
		gboolean _tmp21_ = FALSE;
		const gchar* _tmp22_;
		const gchar* _tmp26_;
#line 302 "src/file.vala"
		_tmp22_ = bp->filename;
#line 302 "src/file.vala"
		if (_tmp22_ == NULL) {
#line 302 "src/file.vala"
			_tmp21_ = TRUE;
#line 2440 "file.c"
		} else {
			const gchar* _tmp23_;
			const gchar* _tmp24_;
#line 302 "src/file.vala"
			_tmp23_ = name;
#line 302 "src/file.vala"
			_tmp24_ = bp->filename;
#line 302 "src/file.vala"
			_tmp21_ = !(g_strcmp0 (_tmp23_, _tmp24_) == 0);
#line 2450 "file.c"
		}
#line 302 "src/file.vala"
		if (_tmp21_) {
#line 2454 "file.c"
			const gchar* _tmp25_;
#line 303 "src/file.vala"
			_tmp25_ = name;
#line 303 "src/file.vala"
			buffer_set_names (bp, _tmp25_);
#line 2460 "file.c"
		}
#line 304 "src/file.vala"
		bp->needname = FALSE;
#line 305 "src/file.vala"
		bp->temporary = FALSE;
#line 306 "src/file.vala"
		bp->nosave = FALSE;
#line 307 "src/file.vala"
		_tmp26_ = name;
#line 307 "src/file.vala"
		if (backup_and_write (bp, _tmp26_)) {
#line 2472 "file.c"
			const gchar* _tmp27_;
			GList* _tmp28_;
#line 308 "src/file.vala"
			_tmp27_ = name;
#line 308 "src/file.vala"
			minibuf_write ("Wrote %s", _tmp27_, NULL);
#line 309 "src/file.vala"
			bp->modified = FALSE;
#line 310 "src/file.vala"
			_tmp28_ = bp->last_undop;
#line 310 "src/file.vala"
			undo_set_unchanged (_tmp28_);
#line 2485 "file.c"
		} else {
#line 312 "src/file.vala"
			ok = FALSE;
#line 2489 "file.c"
		}
	}
#line 315 "src/file.vala"
	result = ok;
#line 315 "src/file.vala"
	_g_free0 (name);
#line 315 "src/file.vala"
	return result;
#line 2498 "file.c"
}

gboolean
save_buffer (Buffer* bp)
{
	gboolean result = FALSE;
#line 318 "src/file.vala"
	g_return_val_if_fail (bp != NULL, FALSE);
#line 319 "src/file.vala"
	if (bp->modified) {
#line 2509 "file.c"
		const gchar* _tmp0_;
#line 320 "src/file.vala"
		_tmp0_ = bp->filename;
#line 320 "src/file.vala"
		result = write_buffer (bp, bp->needname, FALSE, _tmp0_, "File to save in: ");
#line 320 "src/file.vala"
		return result;
#line 2517 "file.c"
	}
#line 322 "src/file.vala"
	minibuf_write ("(No changes need to be saved)", NULL);
#line 323 "src/file.vala"
	result = TRUE;
#line 323 "src/file.vala"
	return result;
#line 2525 "file.c"
}

static gboolean
__lambda35_ (glong uniarg,
             GeeQueue* args)
{
	gboolean ok = FALSE;
	gchar* filename = NULL;
	gpointer _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gboolean result = FALSE;
#line 331 "src/file.vala"
	ok = TRUE;
#line 332 "src/file.vala"
	_tmp0_ = gee_queue_poll (args);
#line 332 "src/file.vala"
	filename = (gchar*) _tmp0_;
#line 333 "src/file.vala"
	_tmp1_ = filename;
#line 333 "src/file.vala"
	if (_tmp1_ == NULL) {
#line 2549 "file.c"
		Buffer* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
#line 334 "src/file.vala"
		_tmp2_ = cur_bp;
#line 334 "src/file.vala"
		_tmp3_ = _tmp2_->dir;
#line 334 "src/file.vala"
		_tmp4_ = minibuf_read_filename ("Find file: ", _tmp3_, NULL, NULL);
#line 334 "src/file.vala"
		_g_free0 (filename);
#line 334 "src/file.vala"
		filename = _tmp4_;
#line 335 "src/file.vala"
		_tmp5_ = filename;
#line 335 "src/file.vala"
		if (_tmp5_ == NULL) {
#line 336 "src/file.vala"
			ok = funcall ("keyboard-quit", NULL, NULL);
#line 2570 "file.c"
		}
	}
#line 338 "src/file.vala"
	_tmp7_ = filename;
#line 338 "src/file.vala"
	if (_tmp7_ == NULL) {
#line 338 "src/file.vala"
		_tmp6_ = TRUE;
#line 2579 "file.c"
	} else {
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
#line 338 "src/file.vala"
		_tmp8_ = filename;
#line 338 "src/file.vala"
		_tmp9_ = strlen (_tmp8_);
#line 338 "src/file.vala"
		_tmp10_ = _tmp9_;
#line 338 "src/file.vala"
		_tmp6_ = _tmp10_ == 0;
#line 2592 "file.c"
	}
#line 338 "src/file.vala"
	if (_tmp6_) {
#line 339 "src/file.vala"
		ok = FALSE;
#line 2598 "file.c"
	}
#line 341 "src/file.vala"
	if (ok) {
#line 2602 "file.c"
		const gchar* _tmp11_;
#line 342 "src/file.vala"
		_tmp11_ = filename;
#line 342 "src/file.vala"
		ok = find_file (_tmp11_);
#line 2608 "file.c"
	}
#line 344 "src/file.vala"
	result = ok;
#line 344 "src/file.vala"
	_g_free0 (filename);
#line 344 "src/file.vala"
	return result;
#line 2616 "file.c"
}

static gboolean
___lambda35__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda35_ (uniarg, args);
#line 328 "src/file.vala"
	return result;
#line 2627 "file.c"
}

static gboolean
__lambda36_ (glong uniarg,
             GeeQueue* args)
{
	gboolean ok = FALSE;
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	Function _tmp2_;
	gboolean _tmp3_;
	gboolean result = FALSE;
#line 355 "src/file.vala"
	_tmp0_ = lisp_func_find ("find-file");
#line 355 "src/file.vala"
	_tmp1_ = _tmp0_;
#line 355 "src/file.vala"
	_tmp2_ = _tmp1_->func;
#line 355 "src/file.vala"
	_tmp3_ = _tmp2_ (uniarg, args);
#line 355 "src/file.vala"
	_lisp_func_unref0 (_tmp1_);
#line 355 "src/file.vala"
	ok = _tmp3_;
#line 356 "src/file.vala"
	if (ok) {
#line 2654 "file.c"
		Buffer* _tmp4_;
#line 357 "src/file.vala"
		_tmp4_ = cur_bp;
#line 357 "src/file.vala"
		_tmp4_->readonly = TRUE;
#line 2660 "file.c"
	}
#line 358 "src/file.vala"
	result = ok;
#line 358 "src/file.vala"
	return result;
#line 2666 "file.c"
}

static gboolean
___lambda36__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda36_ (uniarg, args);
#line 352 "src/file.vala"
	return result;
#line 2677 "file.c"
}

static gboolean
__lambda37_ (glong uniarg,
             GeeQueue* args)
{
	gchar* buf = NULL;
	Buffer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* basename = NULL;
	const gchar* _tmp3_;
	gchar* ms = NULL;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean ok = FALSE;
	const gchar* _tmp12_;
	gboolean result = FALSE;
#line 369 "src/file.vala"
	_tmp0_ = cur_bp;
#line 369 "src/file.vala"
	_tmp1_ = _tmp0_->filename;
#line 369 "src/file.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 369 "src/file.vala"
	buf = _tmp2_;
#line 370 "src/file.vala"
	basename = NULL;
#line 372 "src/file.vala"
	_tmp3_ = buf;
#line 372 "src/file.vala"
	if (_tmp3_ == NULL) {
#line 2711 "file.c"
		Buffer* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
#line 373 "src/file.vala"
		_tmp4_ = cur_bp;
#line 373 "src/file.vala"
		_tmp5_ = _tmp4_->dir;
#line 373 "src/file.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 373 "src/file.vala"
		_g_free0 (buf);
#line 373 "src/file.vala"
		buf = _tmp6_;
#line 2725 "file.c"
	} else {
		const gchar* _tmp7_;
		gchar* _tmp8_;
#line 375 "src/file.vala"
		_tmp7_ = buf;
#line 375 "src/file.vala"
		_tmp8_ = g_path_get_basename (_tmp7_);
#line 375 "src/file.vala"
		_g_free0 (basename);
#line 375 "src/file.vala"
		basename = _tmp8_;
#line 2737 "file.c"
	}
#line 376 "src/file.vala"
	_tmp9_ = buf;
#line 376 "src/file.vala"
	_tmp10_ = basename;
#line 376 "src/file.vala"
	_tmp11_ = minibuf_read_filename ("Find alternate: ", _tmp9_, _tmp10_, NULL);
#line 376 "src/file.vala"
	ms = _tmp11_;
#line 378 "src/file.vala"
	ok = FALSE;
#line 379 "src/file.vala"
	_tmp12_ = ms;
#line 379 "src/file.vala"
	if (_tmp12_ == NULL) {
#line 380 "src/file.vala"
		ok = funcall ("keyboard-quit", NULL, NULL);
#line 2755 "file.c"
	} else {
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
#line 381 "src/file.vala"
		_tmp14_ = ms;
#line 381 "src/file.vala"
		_tmp15_ = strlen (_tmp14_);
#line 381 "src/file.vala"
		_tmp16_ = _tmp15_;
#line 381 "src/file.vala"
		if (_tmp16_ > 0) {
#line 2769 "file.c"
			Buffer* _tmp17_;
#line 381 "src/file.vala"
			_tmp17_ = cur_bp;
#line 381 "src/file.vala"
			_tmp13_ = buffer_check_modified (_tmp17_);
#line 2775 "file.c"
		} else {
#line 381 "src/file.vala"
			_tmp13_ = FALSE;
#line 2779 "file.c"
		}
#line 381 "src/file.vala"
		if (_tmp13_) {
#line 2783 "file.c"
			Buffer* _tmp18_;
			const gchar* _tmp19_;
#line 382 "src/file.vala"
			_tmp18_ = cur_bp;
#line 382 "src/file.vala"
			buffer_kill (_tmp18_);
#line 383 "src/file.vala"
			_tmp19_ = ms;
#line 383 "src/file.vala"
			ok = find_file (_tmp19_);
#line 2794 "file.c"
		}
	}
#line 385 "src/file.vala"
	result = ok;
#line 385 "src/file.vala"
	_g_free0 (ms);
#line 385 "src/file.vala"
	_g_free0 (basename);
#line 385 "src/file.vala"
	_g_free0 (buf);
#line 385 "src/file.vala"
	return result;
#line 2807 "file.c"
}

static gboolean
___lambda37__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda37_ (uniarg, args);
#line 366 "src/file.vala"
	return result;
#line 2818 "file.c"
}

static gboolean
__lambda38_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_ = NULL;
	Buffer* _tmp1_;
	Buffer* _tmp2_;
	Buffer* bp = NULL;
	Buffer* _tmp4_;
	gboolean ok = FALSE;
	gchar* buf = NULL;
	gpointer _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp13_;
	gboolean result = FALSE;
#line 396 "src/file.vala"
	_tmp1_ = cur_bp;
#line 396 "src/file.vala"
	_tmp2_ = _tmp1_->next;
#line 396 "src/file.vala"
	_tmp0_ = _tmp2_;
#line 396 "src/file.vala"
	if (_tmp0_ == NULL) {
#line 2844 "file.c"
		Buffer* _tmp3_;
#line 396 "src/file.vala"
		_tmp3_ = head_bp;
#line 396 "src/file.vala"
		_tmp0_ = _tmp3_;
#line 2850 "file.c"
	}
#line 396 "src/file.vala"
	_tmp4_ = _buffer_ref0 (_tmp0_);
#line 396 "src/file.vala"
	bp = _tmp4_;
#line 398 "src/file.vala"
	ok = TRUE;
#line 399 "src/file.vala"
	_tmp5_ = gee_queue_poll (args);
#line 399 "src/file.vala"
	buf = (gchar*) _tmp5_;
#line 400 "src/file.vala"
	_tmp6_ = buf;
#line 400 "src/file.vala"
	if (_tmp6_ == NULL) {
#line 2866 "file.c"
		Completion* cp = NULL;
		Completion* _tmp7_;
		Completion* _tmp8_;
		Buffer* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
#line 401 "src/file.vala"
		_tmp7_ = buffer_make_buffer_completion ();
#line 401 "src/file.vala"
		cp = _tmp7_;
#line 402 "src/file.vala"
		_tmp8_ = cp;
#line 402 "src/file.vala"
		_tmp9_ = bp;
#line 402 "src/file.vala"
		_tmp10_ = _tmp9_->name;
#line 402 "src/file.vala"
		_tmp11_ = minibuf_read_completion ("Switch to buffer (default %s): ", "", _tmp8_, NULL, _tmp10_, NULL);
#line 402 "src/file.vala"
		_g_free0 (buf);
#line 402 "src/file.vala"
		buf = _tmp11_;
#line 405 "src/file.vala"
		_tmp12_ = buf;
#line 405 "src/file.vala"
		if (_tmp12_ == NULL) {
#line 406 "src/file.vala"
			ok = funcall ("keyboard-quit", NULL, NULL);
#line 2896 "file.c"
		}
#line 400 "src/file.vala"
		_completion_unref0 (cp);
#line 2900 "file.c"
	}
#line 408 "src/file.vala"
	_tmp13_ = buf;
#line 408 "src/file.vala"
	if (_tmp13_ == NULL) {
#line 409 "src/file.vala"
		ok = FALSE;
#line 2908 "file.c"
	}
#line 411 "src/file.vala"
	if (ok) {
#line 2912 "file.c"
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_;
		Buffer* _tmp30_;
#line 412 "src/file.vala"
		_tmp15_ = buf;
#line 412 "src/file.vala"
		if (_tmp15_ != NULL) {
#line 2920 "file.c"
			const gchar* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
#line 412 "src/file.vala"
			_tmp16_ = buf;
#line 412 "src/file.vala"
			_tmp17_ = strlen (_tmp16_);
#line 412 "src/file.vala"
			_tmp18_ = _tmp17_;
#line 412 "src/file.vala"
			_tmp14_ = _tmp18_ > 0;
#line 2932 "file.c"
		} else {
#line 412 "src/file.vala"
			_tmp14_ = FALSE;
#line 2936 "file.c"
		}
#line 412 "src/file.vala"
		if (_tmp14_) {
#line 2940 "file.c"
			const gchar* _tmp19_;
			Buffer* _tmp20_;
			Buffer* _tmp21_;
#line 413 "src/file.vala"
			_tmp19_ = buf;
#line 413 "src/file.vala"
			_tmp20_ = buffer_find (_tmp19_);
#line 413 "src/file.vala"
			_buffer_unref0 (bp);
#line 413 "src/file.vala"
			bp = _tmp20_;
#line 414 "src/file.vala"
			_tmp21_ = bp;
#line 414 "src/file.vala"
			if (_tmp21_ == NULL) {
#line 2956 "file.c"
				Estr* _tmp22_;
				Estr* _tmp23_;
				Buffer* _tmp24_;
				Buffer* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				Buffer* _tmp28_;
				Buffer* _tmp29_;
#line 415 "src/file.vala"
				_tmp22_ = estr_of_empty (IMMUTABLE_ESTR_eol_lf);
#line 415 "src/file.vala"
				_tmp23_ = _tmp22_;
#line 415 "src/file.vala"
				_tmp24_ = buffer_new (_tmp23_);
#line 415 "src/file.vala"
				_buffer_unref0 (bp);
#line 415 "src/file.vala"
				bp = _tmp24_;
#line 415 "src/file.vala"
				_immutable_estr_unref0 (_tmp23_);
#line 416 "src/file.vala"
				_tmp25_ = bp;
#line 416 "src/file.vala"
				_tmp26_ = buf;
#line 416 "src/file.vala"
				_tmp27_ = g_strdup (_tmp26_);
#line 416 "src/file.vala"
				_g_free0 (_tmp25_->name);
#line 416 "src/file.vala"
				_tmp25_->name = _tmp27_;
#line 417 "src/file.vala"
				_tmp28_ = bp;
#line 417 "src/file.vala"
				_tmp28_->needname = TRUE;
#line 418 "src/file.vala"
				_tmp29_ = bp;
#line 418 "src/file.vala"
				_tmp29_->nosave = TRUE;
#line 2995 "file.c"
			}
		}
#line 422 "src/file.vala"
		_tmp30_ = bp;
#line 422 "src/file.vala"
		buffer_switch_to (_tmp30_);
#line 3002 "file.c"
	}
#line 425 "src/file.vala"
	result = ok;
#line 425 "src/file.vala"
	_g_free0 (buf);
#line 425 "src/file.vala"
	_buffer_unref0 (bp);
#line 425 "src/file.vala"
	return result;
#line 3012 "file.c"
}

static gboolean
___lambda38__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda38_ (uniarg, args);
#line 393 "src/file.vala"
	return result;
#line 3023 "file.c"
}

static gboolean
__lambda39_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_ = NULL;
	Buffer* _tmp1_;
	Buffer* _tmp2_;
	Buffer* def_bp = NULL;
	Buffer* _tmp4_;
	Buffer* _tmp5_;
	gboolean ok = FALSE;
	gchar* buf = NULL;
	gpointer _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp14_;
	gboolean result = FALSE;
#line 434 "src/file.vala"
	_tmp1_ = cur_bp;
#line 434 "src/file.vala"
	_tmp2_ = _tmp1_->next;
#line 434 "src/file.vala"
	_tmp0_ = _tmp2_;
#line 434 "src/file.vala"
	if (_tmp0_ == NULL) {
#line 3050 "file.c"
		Buffer* _tmp3_;
#line 434 "src/file.vala"
		_tmp3_ = head_bp;
#line 434 "src/file.vala"
		_tmp0_ = _tmp3_;
#line 3056 "file.c"
	}
#line 434 "src/file.vala"
	_tmp4_ = _buffer_ref0 (_tmp0_);
#line 434 "src/file.vala"
	def_bp = _tmp4_;
#line 436 "src/file.vala"
	_tmp5_ = cur_bp;
#line 436 "src/file.vala"
	if (buffer_warn_if_readonly (_tmp5_)) {
#line 437 "src/file.vala"
		result = FALSE;
#line 437 "src/file.vala"
		_buffer_unref0 (def_bp);
#line 437 "src/file.vala"
		return result;
#line 3072 "file.c"
	}
#line 439 "src/file.vala"
	ok = TRUE;
#line 440 "src/file.vala"
	_tmp6_ = gee_queue_poll (args);
#line 440 "src/file.vala"
	buf = (gchar*) _tmp6_;
#line 441 "src/file.vala"
	_tmp7_ = buf;
#line 441 "src/file.vala"
	if (_tmp7_ == NULL) {
#line 3084 "file.c"
		Completion* cp = NULL;
		Completion* _tmp8_;
		Completion* _tmp9_;
		Buffer* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
#line 442 "src/file.vala"
		_tmp8_ = buffer_make_buffer_completion ();
#line 442 "src/file.vala"
		cp = _tmp8_;
#line 443 "src/file.vala"
		_tmp9_ = cp;
#line 443 "src/file.vala"
		_tmp10_ = def_bp;
#line 443 "src/file.vala"
		_tmp11_ = _tmp10_->name;
#line 443 "src/file.vala"
		_tmp12_ = minibuf_read_completion ("Insert buffer (default %s): ", "", _tmp9_, NULL, _tmp11_, NULL);
#line 443 "src/file.vala"
		_g_free0 (buf);
#line 443 "src/file.vala"
		buf = _tmp12_;
#line 445 "src/file.vala"
		_tmp13_ = buf;
#line 445 "src/file.vala"
		if (_tmp13_ == NULL) {
#line 446 "src/file.vala"
			ok = funcall ("keyboard-quit", NULL, NULL);
#line 3114 "file.c"
		}
#line 441 "src/file.vala"
		_completion_unref0 (cp);
#line 3118 "file.c"
	}
#line 448 "src/file.vala"
	_tmp14_ = buf;
#line 448 "src/file.vala"
	if (_tmp14_ == NULL) {
#line 449 "src/file.vala"
		ok = FALSE;
#line 3126 "file.c"
	}
#line 451 "src/file.vala"
	if (ok) {
#line 3130 "file.c"
		Buffer* bp = NULL;
		gboolean _tmp15_ = FALSE;
		const gchar* _tmp16_;
#line 454 "src/file.vala"
		_tmp16_ = buf;
#line 454 "src/file.vala"
		if (_tmp16_ != NULL) {
#line 3138 "file.c"
			const gchar* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
#line 454 "src/file.vala"
			_tmp17_ = buf;
#line 454 "src/file.vala"
			_tmp18_ = strlen (_tmp17_);
#line 454 "src/file.vala"
			_tmp19_ = _tmp18_;
#line 454 "src/file.vala"
			_tmp15_ = _tmp19_ > 0;
#line 3150 "file.c"
		} else {
#line 454 "src/file.vala"
			_tmp15_ = FALSE;
#line 3154 "file.c"
		}
#line 454 "src/file.vala"
		if (_tmp15_) {
#line 3158 "file.c"
			const gchar* _tmp20_;
			Buffer* _tmp21_;
			Buffer* _tmp22_;
#line 455 "src/file.vala"
			_tmp20_ = buf;
#line 455 "src/file.vala"
			_tmp21_ = buffer_find (_tmp20_);
#line 455 "src/file.vala"
			_buffer_unref0 (bp);
#line 455 "src/file.vala"
			bp = _tmp21_;
#line 456 "src/file.vala"
			_tmp22_ = bp;
#line 456 "src/file.vala"
			if (_tmp22_ == NULL) {
#line 3174 "file.c"
				const gchar* _tmp23_;
#line 457 "src/file.vala"
				_tmp23_ = buf;
#line 457 "src/file.vala"
				minibuf_error ("Buffer `%s' not found", _tmp23_, NULL);
#line 458 "src/file.vala"
				ok = FALSE;
#line 3182 "file.c"
			}
		} else {
			Buffer* _tmp24_;
			Buffer* _tmp25_;
#line 461 "src/file.vala"
			_tmp24_ = def_bp;
#line 461 "src/file.vala"
			_tmp25_ = _buffer_ref0 (_tmp24_);
#line 461 "src/file.vala"
			_buffer_unref0 (bp);
#line 461 "src/file.vala"
			bp = _tmp25_;
#line 3195 "file.c"
		}
#line 463 "src/file.vala"
		if (ok) {
#line 3199 "file.c"
			Buffer* _tmp26_;
			Buffer* _tmp27_;
#line 464 "src/file.vala"
			_tmp26_ = cur_bp;
#line 464 "src/file.vala"
			_tmp27_ = bp;
#line 464 "src/file.vala"
			buffer_insert_buffer (_tmp26_, _tmp27_);
#line 465 "src/file.vala"
			funcall ("set-mark-command", NULL, NULL);
#line 3210 "file.c"
		}
#line 451 "src/file.vala"
		_buffer_unref0 (bp);
#line 3214 "file.c"
	}
#line 469 "src/file.vala"
	result = ok;
#line 469 "src/file.vala"
	_g_free0 (buf);
#line 469 "src/file.vala"
	_buffer_unref0 (def_bp);
#line 469 "src/file.vala"
	return result;
#line 3224 "file.c"
}

static gboolean
___lambda39__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda39_ (uniarg, args);
#line 431 "src/file.vala"
	return result;
#line 3235 "file.c"
}

static gboolean
__lambda40_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	gboolean ok = FALSE;
	gchar* file = NULL;
	gpointer _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
#line 479 "src/file.vala"
	_tmp0_ = cur_bp;
#line 479 "src/file.vala"
	if (buffer_warn_if_readonly (_tmp0_)) {
#line 480 "src/file.vala"
		result = FALSE;
#line 480 "src/file.vala"
		return result;
#line 3259 "file.c"
	}
#line 482 "src/file.vala"
	ok = TRUE;
#line 483 "src/file.vala"
	_tmp1_ = gee_queue_poll (args);
#line 483 "src/file.vala"
	file = (gchar*) _tmp1_;
#line 484 "src/file.vala"
	_tmp2_ = file;
#line 484 "src/file.vala"
	if (_tmp2_ == NULL) {
#line 3271 "file.c"
		Buffer* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
#line 485 "src/file.vala"
		_tmp3_ = cur_bp;
#line 485 "src/file.vala"
		_tmp4_ = _tmp3_->dir;
#line 485 "src/file.vala"
		_tmp5_ = minibuf_read_filename ("Insert file: ", _tmp4_, NULL, NULL);
#line 485 "src/file.vala"
		_g_free0 (file);
#line 485 "src/file.vala"
		file = _tmp5_;
#line 486 "src/file.vala"
		_tmp6_ = file;
#line 486 "src/file.vala"
		if (_tmp6_ == NULL) {
#line 487 "src/file.vala"
			ok = funcall ("keyboard-quit", NULL, NULL);
#line 3292 "file.c"
		}
	}
#line 490 "src/file.vala"
	_tmp8_ = file;
#line 490 "src/file.vala"
	if (_tmp8_ == NULL) {
#line 490 "src/file.vala"
		_tmp7_ = TRUE;
#line 3301 "file.c"
	} else {
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
#line 490 "src/file.vala"
		_tmp9_ = file;
#line 490 "src/file.vala"
		_tmp10_ = strlen (_tmp9_);
#line 490 "src/file.vala"
		_tmp11_ = _tmp10_;
#line 490 "src/file.vala"
		_tmp7_ = _tmp11_ == 0;
#line 3314 "file.c"
	}
#line 490 "src/file.vala"
	if (_tmp7_) {
#line 491 "src/file.vala"
		ok = FALSE;
#line 3320 "file.c"
	}
#line 493 "src/file.vala"
	if (ok) {
#line 3324 "file.c"
		Estr* es = NULL;
		Buffer* _tmp19_;
		Estr* _tmp20_;
		{
			Estr* _tmp12_ = NULL;
			const gchar* _tmp13_;
			Estr* _tmp14_;
			Estr* _tmp15_;
#line 496 "src/file.vala"
			_tmp13_ = file;
#line 496 "src/file.vala"
			_tmp14_ = estr_from_file (_tmp13_, &_inner_error0_);
#line 496 "src/file.vala"
			_tmp12_ = _tmp14_;
#line 496 "src/file.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3341 "file.c"
				goto __catch0_g_error;
			}
#line 496 "src/file.vala"
			_tmp15_ = _tmp12_;
#line 496 "src/file.vala"
			_tmp12_ = NULL;
#line 496 "src/file.vala"
			_immutable_estr_unref0 (es);
#line 496 "src/file.vala"
			es = _tmp15_;
#line 495 "src/file.vala"
			_immutable_estr_unref0 (_tmp12_);
#line 3354 "file.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			const gchar* _tmp16_;
			const gchar* _tmp17_;
#line 495 "src/file.vala"
			g_clear_error (&_inner_error0_);
#line 498 "src/file.vala"
			_tmp16_ = file;
#line 498 "src/file.vala"
			_tmp17_ = strerror (errno);
#line 498 "src/file.vala"
			minibuf_error ("%s: %s", _tmp16_, _tmp17_, NULL);
#line 499 "src/file.vala"
			result = FALSE;
#line 499 "src/file.vala"
			_immutable_estr_unref0 (es);
#line 499 "src/file.vala"
			_g_free0 (file);
#line 499 "src/file.vala"
			return result;
#line 3377 "file.c"
		}
		__finally0:
#line 495 "src/file.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3382 "file.c"
			gboolean _tmp18_ = FALSE;
#line 495 "src/file.vala"
			_immutable_estr_unref0 (es);
#line 495 "src/file.vala"
			_g_free0 (file);
#line 495 "src/file.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 495 "src/file.vala"
			g_clear_error (&_inner_error0_);
#line 495 "src/file.vala"
			return _tmp18_;
#line 3394 "file.c"
		}
#line 501 "src/file.vala"
		_tmp19_ = cur_bp;
#line 501 "src/file.vala"
		_tmp20_ = es;
#line 501 "src/file.vala"
		buffer_insert_estr (_tmp19_, (ImmutableEstr*) _tmp20_);
#line 502 "src/file.vala"
		funcall ("set-mark-command", NULL, NULL);
#line 493 "src/file.vala"
		_immutable_estr_unref0 (es);
#line 3406 "file.c"
	}
#line 504 "src/file.vala"
	result = ok;
#line 504 "src/file.vala"
	_g_free0 (file);
#line 504 "src/file.vala"
	return result;
#line 3414 "file.c"
}

static gboolean
___lambda40__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda40_ (uniarg, args);
#line 476 "src/file.vala"
	return result;
#line 3425 "file.c"
}

static gboolean
__lambda41_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	gboolean result = FALSE;
#line 514 "src/file.vala"
	_tmp0_ = cur_bp;
#line 514 "src/file.vala"
	result = save_buffer (_tmp0_);
#line 514 "src/file.vala"
	return result;
#line 3440 "file.c"
}

static gboolean
___lambda41__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda41_ (uniarg, args);
#line 511 "src/file.vala"
	return result;
#line 3451 "file.c"
}

static gboolean
__lambda42_ (glong uniarg,
             GeeQueue* args)
{
	Buffer* _tmp0_;
	gboolean result = FALSE;
#line 524 "src/file.vala"
	_tmp0_ = cur_bp;
#line 524 "src/file.vala"
	result = write_buffer (_tmp0_, TRUE, noarg (args), NULL, "Write file: ");
#line 524 "src/file.vala"
	return result;
#line 3466 "file.c"
}

static gboolean
___lambda42__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda42_ (uniarg, args);
#line 521 "src/file.vala"
	return result;
#line 3477 "file.c"
}

static gboolean
__lambda43_ (glong uniarg,
             GeeQueue* args)
{
	gboolean noask = FALSE;
	gboolean result = FALSE;
#line 536 "src/file.vala"
	noask = FALSE;
#line 3488 "file.c"
	{
		Buffer* bp = NULL;
		Buffer* _tmp0_;
		Buffer* _tmp1_;
#line 538 "src/file.vala"
		_tmp0_ = head_bp;
#line 538 "src/file.vala"
		_tmp1_ = _buffer_ref0 (_tmp0_);
#line 538 "src/file.vala"
		bp = _tmp1_;
#line 3499 "file.c"
		{
			gboolean _tmp2_ = FALSE;
#line 538 "src/file.vala"
			_tmp2_ = TRUE;
#line 538 "src/file.vala"
			while (TRUE) {
#line 3506 "file.c"
				Buffer* _tmp7_;
				gboolean _tmp8_ = FALSE;
				Buffer* _tmp9_;
#line 538 "src/file.vala"
				if (!_tmp2_) {
#line 3512 "file.c"
					Buffer* _tmp3_;
					Buffer* _tmp4_;
					Buffer* _tmp5_;
					Buffer* _tmp6_;
#line 538 "src/file.vala"
					_tmp3_ = bp;
#line 538 "src/file.vala"
					_tmp4_ = _tmp3_->next;
#line 538 "src/file.vala"
					_tmp5_ = _buffer_ref0 (_tmp4_);
#line 538 "src/file.vala"
					_buffer_unref0 (bp);
#line 538 "src/file.vala"
					bp = _tmp5_;
#line 538 "src/file.vala"
					_tmp6_ = bp;
#line 3529 "file.c"
				}
#line 538 "src/file.vala"
				_tmp2_ = FALSE;
#line 538 "src/file.vala"
				_tmp7_ = bp;
#line 538 "src/file.vala"
				if (!(_tmp7_ != NULL)) {
#line 538 "src/file.vala"
					break;
#line 3539 "file.c"
				}
#line 539 "src/file.vala"
				_tmp9_ = bp;
#line 539 "src/file.vala"
				if (_tmp9_->modified) {
#line 3545 "file.c"
					Buffer* _tmp10_;
#line 539 "src/file.vala"
					_tmp10_ = bp;
#line 539 "src/file.vala"
					_tmp8_ = !_tmp10_->nosave;
#line 3551 "file.c"
				} else {
#line 539 "src/file.vala"
					_tmp8_ = FALSE;
#line 3555 "file.c"
				}
#line 539 "src/file.vala"
				if (_tmp8_) {
#line 3559 "file.c"
					gchar* fname = NULL;
					Buffer* _tmp11_;
					gchar* _tmp12_;
#line 540 "src/file.vala"
					_tmp11_ = bp;
#line 540 "src/file.vala"
					_tmp12_ = buffer_get_filename_or_name (_tmp11_);
#line 540 "src/file.vala"
					fname = _tmp12_;
#line 541 "src/file.vala"
					if (noask) {
#line 3571 "file.c"
						Buffer* _tmp13_;
#line 542 "src/file.vala"
						_tmp13_ = bp;
#line 542 "src/file.vala"
						save_buffer (_tmp13_);
#line 3577 "file.c"
					} else {
						{
							gboolean _tmp14_ = FALSE;
#line 544 "src/file.vala"
							_tmp14_ = TRUE;
#line 544 "src/file.vala"
							while (TRUE) {
#line 3585 "file.c"
								const gchar* _tmp15_;
								Keystroke c = 0U;
#line 544 "src/file.vala"
								if (!_tmp14_) {
#line 3590 "file.c"
								}
#line 544 "src/file.vala"
								_tmp14_ = FALSE;
#line 545 "src/file.vala"
								_tmp15_ = fname;
#line 545 "src/file.vala"
								minibuf_write ("Save file %s? (y, n, !, ., q) ", _tmp15_, NULL);
#line 546 "src/file.vala"
								c = getkey (GETKEY_DEFAULT);
#line 547 "src/file.vala"
								minibuf_clear ();
#line 549 "src/file.vala"
								if (c == KBD_CANCEL) {
#line 550 "src/file.vala"
									funcall ("keyboard-quit", NULL, NULL);
#line 551 "src/file.vala"
									result = FALSE;
#line 551 "src/file.vala"
									_g_free0 (fname);
#line 551 "src/file.vala"
									_buffer_unref0 (bp);
#line 551 "src/file.vala"
									return result;
#line 3614 "file.c"
								} else {
#line 552 "src/file.vala"
									if (c == ((Keystroke) 'q')) {
#line 553 "src/file.vala"
										result = TRUE;
#line 553 "src/file.vala"
										_g_free0 (fname);
#line 553 "src/file.vala"
										_buffer_unref0 (bp);
#line 553 "src/file.vala"
										return result;
#line 3626 "file.c"
									} else {
#line 554 "src/file.vala"
										if (c == ((Keystroke) '.')) {
#line 3630 "file.c"
											Buffer* _tmp16_;
#line 555 "src/file.vala"
											_tmp16_ = bp;
#line 555 "src/file.vala"
											save_buffer (_tmp16_);
#line 556 "src/file.vala"
											result = TRUE;
#line 556 "src/file.vala"
											_g_free0 (fname);
#line 556 "src/file.vala"
											_buffer_unref0 (bp);
#line 556 "src/file.vala"
											return result;
#line 3644 "file.c"
										} else {
#line 557 "src/file.vala"
											if (c == ((Keystroke) '!')) {
#line 3648 "file.c"
												Buffer* _tmp17_;
#line 558 "src/file.vala"
												noask = TRUE;
#line 559 "src/file.vala"
												_tmp17_ = bp;
#line 559 "src/file.vala"
												save_buffer (_tmp17_);
#line 560 "src/file.vala"
												break;
#line 3658 "file.c"
											} else {
												gboolean _tmp18_ = FALSE;
#line 561 "src/file.vala"
												if (c == ((Keystroke) ' ')) {
#line 561 "src/file.vala"
													_tmp18_ = TRUE;
#line 3665 "file.c"
												} else {
#line 561 "src/file.vala"
													_tmp18_ = c == ((Keystroke) 'y');
#line 3669 "file.c"
												}
#line 561 "src/file.vala"
												if (_tmp18_) {
#line 3673 "file.c"
													Buffer* _tmp19_;
#line 562 "src/file.vala"
													_tmp19_ = bp;
#line 562 "src/file.vala"
													save_buffer (_tmp19_);
#line 563 "src/file.vala"
													break;
#line 3681 "file.c"
												} else {
													gboolean _tmp20_ = FALSE;
													gboolean _tmp21_ = FALSE;
#line 564 "src/file.vala"
													if (c == ((Keystroke) 'n')) {
#line 564 "src/file.vala"
														_tmp21_ = TRUE;
#line 3689 "file.c"
													} else {
#line 564 "src/file.vala"
														_tmp21_ = c == KBD_RET;
#line 3693 "file.c"
													}
#line 564 "src/file.vala"
													if (_tmp21_) {
#line 564 "src/file.vala"
														_tmp20_ = TRUE;
#line 3699 "file.c"
													} else {
#line 564 "src/file.vala"
														_tmp20_ = c == KBD_DEL;
#line 3703 "file.c"
													}
#line 564 "src/file.vala"
													if (_tmp20_) {
#line 565 "src/file.vala"
														break;
#line 3709 "file.c"
													} else {
#line 567 "src/file.vala"
														minibuf_error ("Please answer y, n, !, . or q.", NULL);
#line 568 "src/file.vala"
														waitkey ();
#line 3715 "file.c"
													}
												}
											}
										}
									}
								}
							}
						}
					}
#line 539 "src/file.vala"
					_g_free0 (fname);
#line 3727 "file.c"
				}
			}
		}
#line 538 "src/file.vala"
		_buffer_unref0 (bp);
#line 3733 "file.c"
	}
#line 574 "src/file.vala"
	minibuf_write ("(No files need saving)", NULL);
#line 575 "src/file.vala"
	result = TRUE;
#line 575 "src/file.vala"
	return result;
#line 3741 "file.c"
}

static gboolean
___lambda43__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda43_ (uniarg, args);
#line 533 "src/file.vala"
	return result;
#line 3752 "file.c"
}

static gboolean
_bool_equal (const gboolean * s1,
             const gboolean * s2)
{
#line 593 "src/file.vala"
	if (s1 == s2) {
#line 593 "src/file.vala"
		return TRUE;
#line 3763 "file.c"
	}
#line 593 "src/file.vala"
	if (s1 == NULL) {
#line 593 "src/file.vala"
		return FALSE;
#line 3769 "file.c"
	}
#line 593 "src/file.vala"
	if (s2 == NULL) {
#line 593 "src/file.vala"
		return FALSE;
#line 3775 "file.c"
	}
#line 593 "src/file.vala"
	return (*s1) == (*s2);
#line 3779 "file.c"
}

static gboolean
__lambda44_ (glong uniarg,
             GeeQueue* args)
{
	gboolean result = FALSE;
#line 584 "src/file.vala"
	if (!funcall ("save-some-buffers", NULL, NULL)) {
#line 585 "src/file.vala"
		result = FALSE;
#line 585 "src/file.vala"
		return result;
#line 3793 "file.c"
	}
	{
		Buffer* bp = NULL;
		Buffer* _tmp0_;
		Buffer* _tmp1_;
#line 587 "src/file.vala"
		_tmp0_ = head_bp;
#line 587 "src/file.vala"
		_tmp1_ = _buffer_ref0 (_tmp0_);
#line 587 "src/file.vala"
		bp = _tmp1_;
#line 3805 "file.c"
		{
			gboolean _tmp2_ = FALSE;
#line 587 "src/file.vala"
			_tmp2_ = TRUE;
#line 587 "src/file.vala"
			while (TRUE) {
#line 3812 "file.c"
				Buffer* _tmp6_;
				gboolean _tmp7_ = FALSE;
				Buffer* _tmp8_;
#line 587 "src/file.vala"
				if (!_tmp2_) {
#line 3818 "file.c"
					Buffer* _tmp3_;
					Buffer* _tmp4_;
					Buffer* _tmp5_;
#line 587 "src/file.vala"
					_tmp3_ = bp;
#line 587 "src/file.vala"
					_tmp4_ = _tmp3_->next;
#line 587 "src/file.vala"
					_tmp5_ = _buffer_ref0 (_tmp4_);
#line 587 "src/file.vala"
					_buffer_unref0 (bp);
#line 587 "src/file.vala"
					bp = _tmp5_;
#line 3832 "file.c"
				}
#line 587 "src/file.vala"
				_tmp2_ = FALSE;
#line 587 "src/file.vala"
				_tmp6_ = bp;
#line 587 "src/file.vala"
				if (!(_tmp6_ != NULL)) {
#line 587 "src/file.vala"
					break;
#line 3842 "file.c"
				}
#line 588 "src/file.vala"
				_tmp8_ = bp;
#line 588 "src/file.vala"
				if (_tmp8_->modified) {
#line 3848 "file.c"
					Buffer* _tmp9_;
#line 588 "src/file.vala"
					_tmp9_ = bp;
#line 588 "src/file.vala"
					_tmp7_ = !_tmp9_->needname;
#line 3854 "file.c"
				} else {
#line 588 "src/file.vala"
					_tmp7_ = FALSE;
#line 3858 "file.c"
				}
#line 588 "src/file.vala"
				if (_tmp7_) {
#line 3862 "file.c"
					{
						gboolean _tmp10_ = FALSE;
#line 589 "src/file.vala"
						_tmp10_ = TRUE;
#line 589 "src/file.vala"
						while (TRUE) {
#line 3869 "file.c"
							gboolean* ans = NULL;
							gboolean* _tmp11_;
							gboolean* _tmp12_;
#line 589 "src/file.vala"
							if (!_tmp10_) {
#line 3875 "file.c"
							}
#line 589 "src/file.vala"
							_tmp10_ = FALSE;
#line 590 "src/file.vala"
							_tmp11_ = minibuf_read_yesno ("Modified buffers exist; exit anyway? (yes or no) ", NULL);
#line 590 "src/file.vala"
							ans = _tmp11_;
#line 591 "src/file.vala"
							_tmp12_ = ans;
#line 591 "src/file.vala"
							if (_tmp12_ == NULL) {
#line 592 "src/file.vala"
								result = funcall ("keyboard-quit", NULL, NULL);
#line 592 "src/file.vala"
								_g_free0 (ans);
#line 592 "src/file.vala"
								_buffer_unref0 (bp);
#line 592 "src/file.vala"
								return result;
#line 3895 "file.c"
							} else {
								gboolean* _tmp13_;
								gboolean _tmp14_;
#line 593 "src/file.vala"
								_tmp13_ = ans;
#line 593 "src/file.vala"
								_tmp14_ = FALSE;
#line 593 "src/file.vala"
								if (_bool_equal (_tmp13_, &_tmp14_) == TRUE) {
#line 594 "src/file.vala"
									result = FALSE;
#line 594 "src/file.vala"
									_g_free0 (ans);
#line 594 "src/file.vala"
									_buffer_unref0 (bp);
#line 594 "src/file.vala"
									return result;
#line 3913 "file.c"
								}
							}
#line 595 "src/file.vala"
							_g_free0 (ans);
#line 595 "src/file.vala"
							break;
#line 3920 "file.c"
						}
					}
#line 597 "src/file.vala"
					break;
#line 3925 "file.c"
				}
			}
		}
#line 587 "src/file.vala"
		_buffer_unref0 (bp);
#line 3931 "file.c"
	}
#line 600 "src/file.vala"
	zile_exit (EXIT_SUCCESS);
#line 601 "src/file.vala"
	result = TRUE;
#line 601 "src/file.vala"
	return result;
#line 3939 "file.c"
}

static gboolean
___lambda44__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda44_ (uniarg, args);
#line 581 "src/file.vala"
	return result;
#line 3950 "file.c"
}

static gboolean
__lambda45_ (glong uniarg,
             GeeQueue* args)
{
	gboolean ok = FALSE;
	gchar* dir = NULL;
	gpointer _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp5_;
	gboolean result = FALSE;
#line 610 "src/file.vala"
	ok = TRUE;
#line 611 "src/file.vala"
	_tmp0_ = gee_queue_poll (args);
#line 611 "src/file.vala"
	dir = (gchar*) _tmp0_;
#line 612 "src/file.vala"
	_tmp1_ = dir;
#line 612 "src/file.vala"
	if (_tmp1_ == NULL) {
#line 3973 "file.c"
		Buffer* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
#line 613 "src/file.vala"
		_tmp2_ = cur_bp;
#line 613 "src/file.vala"
		_tmp3_ = _tmp2_->dir;
#line 613 "src/file.vala"
		_tmp4_ = minibuf_read_filename ("Change default directory: ", _tmp3_, NULL, NULL);
#line 613 "src/file.vala"
		_g_free0 (dir);
#line 613 "src/file.vala"
		dir = _tmp4_;
#line 3987 "file.c"
	}
#line 615 "src/file.vala"
	_tmp5_ = dir;
#line 615 "src/file.vala"
	if (_tmp5_ == NULL) {
#line 616 "src/file.vala"
		ok = funcall ("keyboard-quit", NULL, NULL);
#line 3995 "file.c"
	} else {
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
#line 617 "src/file.vala"
		_tmp6_ = dir;
#line 617 "src/file.vala"
		_tmp7_ = strlen (_tmp6_);
#line 617 "src/file.vala"
		_tmp8_ = _tmp7_;
#line 617 "src/file.vala"
		if (_tmp8_ > 0) {
#line 4008 "file.c"
			const gchar* _tmp9_;
#line 618 "src/file.vala"
			_tmp9_ = dir;
#line 618 "src/file.vala"
			if (!g_file_test (_tmp9_, G_FILE_TEST_IS_DIR)) {
#line 4014 "file.c"
				const gchar* _tmp10_;
#line 619 "src/file.vala"
				_tmp10_ = dir;
#line 619 "src/file.vala"
				minibuf_error ("`%s' is not a directory", _tmp10_, NULL);
#line 620 "src/file.vala"
				ok = FALSE;
#line 4022 "file.c"
			} else {
				const gchar* _tmp11_;
#line 621 "src/file.vala"
				_tmp11_ = dir;
#line 621 "src/file.vala"
				if (chdir (_tmp11_) == -1) {
#line 4029 "file.c"
					const gchar* _tmp12_;
					const gchar* _tmp13_;
#line 622 "src/file.vala"
					_tmp12_ = dir;
#line 622 "src/file.vala"
					_tmp13_ = strerror (errno);
#line 622 "src/file.vala"
					minibuf_write ("%s: %s", _tmp12_, _tmp13_, NULL);
#line 623 "src/file.vala"
					ok = FALSE;
#line 4040 "file.c"
				}
			}
		}
	}
#line 626 "src/file.vala"
	result = TRUE;
#line 626 "src/file.vala"
	_g_free0 (dir);
#line 626 "src/file.vala"
	return result;
#line 4051 "file.c"
}

static gboolean
___lambda45__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda45_ (uniarg, args);
#line 607 "src/file.vala"
	return result;
#line 4062 "file.c"
}

void
file_init (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
	LispFunc* _tmp4_;
	LispFunc* _tmp5_;
	LispFunc* _tmp6_;
	LispFunc* _tmp7_;
	LispFunc* _tmp8_;
	LispFunc* _tmp9_;
	LispFunc* _tmp10_;
	LispFunc* _tmp11_;
	LispFunc* _tmp12_;
	LispFunc* _tmp13_;
	LispFunc* _tmp14_;
	LispFunc* _tmp15_;
	LispFunc* _tmp16_;
	LispFunc* _tmp17_;
	LispFunc* _tmp18_;
	LispFunc* _tmp19_;
	LispFunc* _tmp20_;
	LispFunc* _tmp21_;
#line 328 "src/file.vala"
	_tmp0_ = lisp_func_new ("find-file", ___lambda35__function, TRUE, "Edit file FILENAME.\n" \
"Switch to a buffer visiting file FILENAME,\n" \
"creating one if none already exists.");
#line 328 "src/file.vala"
	_tmp1_ = _tmp0_;
#line 328 "src/file.vala"
	_lisp_func_unref0 (_tmp1_);
#line 352 "src/file.vala"
	_tmp2_ = lisp_func_new ("find-file-read-only", ___lambda36__function, TRUE, "Edit file FILENAME but don't allow changes.\n" \
"Like `find-file', but marks buffer as read-only.\n" \
"Use M-x toggle-read-only to permit editing.");
#line 352 "src/file.vala"
	_tmp3_ = _tmp2_;
#line 352 "src/file.vala"
	_lisp_func_unref0 (_tmp3_);
#line 366 "src/file.vala"
	_tmp4_ = lisp_func_new ("find-alternate-file", ___lambda37__function, TRUE, "Find the file specified by the user, select its buffer, kill previous " \
"buffer.\n" \
"If the current buffer now contains an empty file that you just visited" \
"\n" \
"(presumably by mistake), use this command to visit the file you really" \
" want.");
#line 366 "src/file.vala"
	_tmp5_ = _tmp4_;
#line 366 "src/file.vala"
	_lisp_func_unref0 (_tmp5_);
#line 393 "src/file.vala"
	_tmp6_ = lisp_func_new ("switch-to-buffer", ___lambda38__function, TRUE, "Select buffer BUFFER in the current window.");
#line 393 "src/file.vala"
	_tmp7_ = _tmp6_;
#line 393 "src/file.vala"
	_lisp_func_unref0 (_tmp7_);
#line 431 "src/file.vala"
	_tmp8_ = lisp_func_new ("insert-buffer", ___lambda39__function, TRUE, "Insert after point the contents of BUFFER.\n" \
"Puts mark after the inserted text.");
#line 431 "src/file.vala"
	_tmp9_ = _tmp8_;
#line 431 "src/file.vala"
	_lisp_func_unref0 (_tmp9_);
#line 476 "src/file.vala"
	_tmp10_ = lisp_func_new ("insert-file", ___lambda40__function, TRUE, "Insert contents of file FILENAME into buffer after point.\n" \
"Set mark after the inserted text.");
#line 476 "src/file.vala"
	_tmp11_ = _tmp10_;
#line 476 "src/file.vala"
	_lisp_func_unref0 (_tmp11_);
#line 511 "src/file.vala"
	_tmp12_ = lisp_func_new ("save-buffer", ___lambda41__function, TRUE, "Save current buffer in visited file if modified.  By default, makes th" \
"e\n" \
"previous version into a backup file if this is the first save.");
#line 511 "src/file.vala"
	_tmp13_ = _tmp12_;
#line 511 "src/file.vala"
	_lisp_func_unref0 (_tmp13_);
#line 521 "src/file.vala"
	_tmp14_ = lisp_func_new ("write-file", ___lambda42__function, TRUE, "Write current buffer into file FILENAME.\n" \
"This makes the buffer visit that file, and marks it as not modified.\n" \
"\n" \
"Interactively, confirmation is required unless you supply a prefix arg" \
"ument.");
#line 521 "src/file.vala"
	_tmp15_ = _tmp14_;
#line 521 "src/file.vala"
	_lisp_func_unref0 (_tmp15_);
#line 533 "src/file.vala"
	_tmp16_ = lisp_func_new ("save-some-buffers", ___lambda43__function, TRUE, "Save some modified file-visiting buffers.  Asks user about each one.");
#line 533 "src/file.vala"
	_tmp17_ = _tmp16_;
#line 533 "src/file.vala"
	_lisp_func_unref0 (_tmp17_);
#line 581 "src/file.vala"
	_tmp18_ = lisp_func_new ("save-buffers-kill-emacs", ___lambda44__function, TRUE, "Offer to save each buffer, then kill this Zile process.");
#line 581 "src/file.vala"
	_tmp19_ = _tmp18_;
#line 581 "src/file.vala"
	_lisp_func_unref0 (_tmp19_);
#line 607 "src/file.vala"
	_tmp20_ = lisp_func_new ("cd", ___lambda45__function, TRUE, "Make DIR become the current buffer's default directory.");
#line 607 "src/file.vala"
	_tmp21_ = _tmp20_;
#line 607 "src/file.vala"
	_lisp_func_unref0 (_tmp21_);
#line 4156 "file.c"
}

