/* ,file-id archive://[lord]/434/rx/nfa.h/1998-05-18
 */
/* classes: h_files */

#ifndef NFAH
#define NFAH
/*	Copyright (C) 1997 Tom Lord
 * 
 * This program is provided to you under the terms of the Liberty Software
 * License.  You are NOT permitted to redistribute, modify, or use it
 * except in very specific ways described by that license.
 *
 * This software comes with NO WARRANTY.
 * 
 * You should have received a copy of the Liberty Software License
 * along with this software; see the file =LICENSE.  If not, write to
 * the Tom Lord, 1810 Francisco St. #2, Berkeley CA, 94703, USA.  
 */



struct rx_nfa;
struct rx_nfa_state;
struct rx_superset;


/* One way to describe regexps is as non-deterministic
 * finite automata.
 *
 * "nfa.h" delcares functions and data types for constructing
 * NFAs for regexps.
 *
 * NFAs can be built directly, or by translation from a 
 * regexp syntax tree.  The interface for building a 
 * regexp syntax tree is described in "rexp.h"
 */

struct rx_nfa
{
  unsigned long rx_id;
  int local_cset_size;
  struct rx_nfa_state * nfa_states;
  struct rx_nfa_state * start_nfa_state;
  struct hashtab set_list_memo;
  struct rx_superset * start_set;
  unsigned int nfa_state_id;
};

struct rx_nfa_state
{
  unsigned int id;
  unsigned long state_label;
  struct rx_nfa_edge *edges;

  unsigned int is_start:1;
  int has_cset_edges:1;

  int closure_computed:1;
  struct rx_nfa_state_set * closure;

  unsigned int mark:1;
  struct rx_nfa_state *next;
};

enum rx_nfa_etype
{
  ne_cset,
  ne_epsilon
};

struct rx_nfa_edge
{
  enum rx_nfa_etype type;
  struct rx_nfa_state *dest;
  bitset cset;

  struct rx_nfa_edge *next;
};

struct rx_nfa_state_set
{
  struct rx_nfa_state * car;
  struct rx_nfa_state_set * cdr;
};


/* automatically generated __STDC__ prototypes */
extern struct rx_nfa * rx_nfa_xalloc (int cset_size);
extern void rx_free_nfa (struct rx_nfa * rx);
extern void rx_build_nfa (struct rx_nfa *rx,
			  struct rx_exp_node *rexp,
			  struct rx_nfa_state **start,
			  struct rx_nfa_state **end);
extern void rx_set_start_state (struct rx_nfa * rx, struct rx_nfa_state * n);
extern struct rx_nfa_state * rx_nfa_state (struct rx_nfa *rx);
extern struct rx_nfa_edge * rx_nfa_edge (struct rx_nfa *rx,
					 enum rx_nfa_etype type,
					 struct rx_nfa_state *start,
					 struct rx_nfa_state *dest);
extern struct rx_nfa_state_set * rx_state_closure (struct rx_nfa * rx, struct rx_nfa_state * n);
#endif  /* NFAH */
