/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import { AbsoluteTime } from "@gnu-taler/taler-util";
import * as tests from "@gnu-taler/web-util/testing";
import { DeveloperPage as TestedComponent } from "./DeveloperPage.js";

export default {
  title: "developer",
  component: TestedComponent,
  argTypes: {
    setDeviceName: () => Promise.resolve(),
  },
};

export const AllOff = tests.createExample(TestedComponent, {
  onDownloadDatabase: async () => "this is the content of the database",
  operations: [
    {
      id: " ",
      type: "exchange-update",
      exchangeBaseUrl: "http://exchange.url.",
      givesLifeness: false,
      lastError: undefined,
      timestampDue: AbsoluteTime.fromMilliseconds(123123213),
      retryInfo: undefined,
      isDue: false,
      isLongpolling: false,
    },
  ],
  coins: [],
});
