/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { AmlProgramParams, KycConverterParams } from "./types-taler-kyc-aml.js";

// https://docs.taler.net/taler-kyc-manual.html#implementing-your-own-aml-programs

export function parseKycConverterParams(): KycConverterParams {
  return process.argv.reduce((prev, arg, idx, list) => {
    if (idx === 0) {
      prev.name = arg;
    }
    if (arg === "-v") {
      prev.showVersion = true;
    } else if (arg === "-V") {
      prev.debug = true;
    } else if (arg === "--list-outputs") {
      prev.showOutputs = true;
    } else if (arg === "-h") {
      prev.showHelp = true;
    } else if (arg === "-c") {
      prev.config = list[idx + 1];
    }
    return prev;
  }, {} as KycConverterParams);
}

export function parseAmlProgramParams(): AmlProgramParams {
  return process.argv.reduce((prev, arg, idx, list) => {
    if (idx === 0) {
      prev.name = arg;
    }
    if (arg === "-v") {
      prev.showVersion = true;
    } else if (arg === "-V") {
      prev.debug = true;
    } else if (arg === "-r") {
      prev.showRequiredContext = true;
    } else if (arg === "-a") {
      prev.showRequiredAttributes = true;
    } else if (arg === "-i") {
      prev.showRequiredInputs = true;
    } else if (arg === "-h") {
      prev.showHelp = true;
    } else if (arg === "-c") {
      prev.config = list[idx + 1];
    }
    return prev;
  }, {} as AmlProgramParams);
}
