/*
 This file is part of GNU Taler
 (C) 2020 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Imports.
 */
import { j2s, Logger } from "@gnu-taler/taler-util";
import { WalletApiOperation } from "@gnu-taler/taler-wallet-core";
import { GlobalTestState } from "../harness/harness.js";
import { createSimpleTestkudosEnvironmentV3 } from "../harness/environments.js";

const logger = new Logger("test-withdrawal-prepare.ts");

/**
 * Test the separate prepare step of a bank-integrated withdrawal.
 */
export async function runWithdrawalPrepareTest(t: GlobalTestState) {
  // Set up test environment

  const { walletClient, bankClient, exchange } =
    await createSimpleTestkudosEnvironmentV3(t);

  // Create a withdrawal operation
  const user = await bankClient.createRandomBankUser();
  bankClient.setAuth(user);
  const wop = await bankClient.createWithdrawalOperation(
    user.username,
    "TESTKUDOS:20",
  );

  const r1 = await walletClient.call(
    WalletApiOperation.GetWithdrawalDetailsForUri,
    {
      talerWithdrawUri: wop.taler_withdraw_uri,
    },
  );

  console.log(j2s(r1));

  //t.assertTrue(!r1.amount);

  // Withdraw

  const prepRes = await walletClient.call(
    WalletApiOperation.PrepareBankIntegratedWithdrawal,
    {
      talerWithdrawUri: wop.taler_withdraw_uri,
    },
  );

  logger.info(`Prep res: ${j2s(prepRes)}`);

  // Make sure that we can get the transaction details for the prepared transaction

  const txDetail = await walletClient.call(
    WalletApiOperation.GetTransactionById,
    {
      transactionId: prepRes.transactionId,
    },
  );

  logger.info(`Transaction details: ${j2s(txDetail)}`);
}

runWithdrawalPrepareTest.suites = ["wallet"];
