/*
 This file is part of GNU Taler
 (C) 2021-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * @author Nic Eigel
 */

import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { Fragment, h, VNode } from "preact";
import { useConfigContext } from "../../context/config.js";

export function Sidebar(props: any): VNode {
  const configData = useConfigContext();
  const { i18n } = useTranslationContext();
  console.log(configData);

  return (
    <aside class="aside is-placed-left is-expanded" style={{ overflowY: "scroll" }}>
      <div class="aside-tools">
        <div class="aside-tools-label">
          <div>
            <b>Taler</b> Backoffice
          </div>
          <div
            class="is-size-7 has-text-right"
            style={{ lineHeight: 0, marginTop: -10 }}
          >
            (Version {configData.version})
          </div>
        </div>
      </div>
      <div class="menu is-menu-main">
        <Fragment>
          <ul class="menu-list">
            <li>
              <a href={"/key-figures"} class="has-icon">
                  <span class="icon">
                    <i class="mdi mdi-bank" />
                  </span>
                <span class="menu-item-label">
                    <i18n.Translate>Key figures</i18n.Translate>
                  </span>
              </a>
            </li>
            <li>
              <a href={"/critical-errors"} class="has-icon">
                  <span class="icon">
                    <i class="mdi mdi-alert" />
                  </span>
                <span class="menu-item-label">
                    <i18n.Translate>Critical errors</i18n.Translate>
                  </span>
              </a>
            </li>
            <li>
              <a href={"/operating-status"} class="has-icon">
                  <span class="icon">
                    <i class="mdi mdi-close-network" />
                  </span>
                <span class="menu-item-label">
                    <i18n.Translate>Operating status</i18n.Translate>
                  </span>
              </a>
            </li>
            <li>
              <a href={"/detail-view"} class="has-icon">
                  <span class="icon">
                    <i class="mdi mdi-format-wrap-tight" />
                  </span>
                <span class="menu-item-label">
                    <i18n.Translate>Inconsistencies</i18n.Translate>
                  </span>
              </a>
            </li>
            <li>
              <a href={"/settings"} class="has-icon">
                  <span class="icon">
                    <i class="mdi mdi-square-edit-outline" />
                  </span>
                <span class="menu-item-label">
                    <i18n.Translate>Settings</i18n.Translate>
                  </span>
              </a>
            </li>
          </ul>
        </Fragment>
      </div>
    </aside>
  );
}