/*
   This file is part of TALER
   Copyright (C) 2024 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_update_donau_instance.c
 * @brief Implementation of the update_donau_instance function for Postgres
 * @author Bohdan Potuzhnyi
 * @author Vlada Svirsh
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "donau/donau_service.h"
#include "pg_update_donau_instance.h"
#include "pg_helper.h"


enum GNUNET_DB_QueryStatus
TMH_PG_update_donau_instance (
  void *cls,
  const char *donau_url,
  const struct DONAU_Charity *charity,
  uint64_t charity_id)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_string (donau_url),
    GNUNET_PQ_query_param_string (charity->name),
    GNUNET_PQ_query_param_auto_from_type (&charity->charity_pub),
    GNUNET_PQ_query_param_uint64 (&charity_id),
    TALER_PQ_query_param_amount_with_currency (pg->conn,
                                               &charity->max_per_year),
    TALER_PQ_query_param_amount_with_currency (pg->conn,
                                               &charity->receipts_to_date),
    GNUNET_PQ_query_param_uint64 (&charity->current_year),
    GNUNET_PQ_query_param_end
  };

  check_connection (pg);

  PREPARE (pg,
           "update_existing_donau_instance",
           "UPDATE merchant_donau_instances SET"
           "  charity_name             = $2,"
           "  charity_max_per_year     = $5,"
           "  charity_receipts_to_date = $6,"
           "  current_year             = $7"
           " WHERE charity_id = $4"
           " AND merchant_instance_serial "
           "  = (SELECT merchant_serial"
           "      FROM merchant_instances mi"
           "     WHERE mi.merchant_pub = $3),"
           "  AND donau_url = $1;");

  return GNUNET_PQ_eval_prepared_non_select (pg->conn,
                                             "update_existing_donau_instance",
                                             params);
}
