/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_solve_mfa_challenge.h
 * @brief implementation of the solve_mfa_challenge function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_SOLVE_MFA_CHALLENGE_H
#define PG_SOLVE_MFA_CHALLENGE_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"

/**
 * Attempt to solve new multi-factor authorization (MFA) challenge.
 * Checks the solution against the code in the database and updates
 * the solution state and (on failure) retry counter depending on
 * the result.
 *
 * @param cls closure
 * @param challenge_id challenge ID to be solved
 * @param h_body body of the operation the challenge authorizes
 * @param solution proposed solution to be checked against the actual code
 * @param[out] solved set to true if the challenge was solved by
 *             @a solution
 * @param[out] retry_counter set to the number of attempts that remain
 *             for solving the challenge (after this time)
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_solve_mfa_challenge (
  void *cls,
  uint64_t challenge_id,
  const struct TALER_MERCHANT_MFA_BodyHash *h_body,
  const char *solution,
  bool *solved,
  uint32_t *retry_counter);

#endif
