/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_select_product_groups.h
 * @brief implementation of the select_product_groups function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_SELECT_PRODUCT_GROUPS_H
#define PG_SELECT_PRODUCT_GROUPS_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"

/**
 * Lookup all of the product groups the given instance has configured.
 *
 * @param cls closure
 * @param instance_id instance to lookup product groups for
 * @param limit number of entries to return, negative for descending in execution time,
 *                positive for ascending in execution time
 * @param offset expected_transfer_serial number of the transfer we want to offset from
 * @param cb function to call on all groups found
 * @param cb_cls closure for @a cb
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_select_product_groups (void *cls,
                              const char *instance_id,
                              int64_t limit,
                              uint64_t offset,
                              TALER_MERCHANTDB_ProductGroupsCallback cb,
                              void *cb_cls);


#endif
