/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_select_money_pot.h
 * @brief implementation of the select_money_pot function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_SELECT_MONEY_POT_H
#define PG_SELECT_MONEY_POT_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"


/**
 * Lookup details about a particular money pot.
 *
 * @param cls closure
 * @param instance_id instance to lookup token family for
 * @param money_pot_id serial number of the pot to lookup
 * @param [out] name set to name of the pot
 * @param[out] description set to description of the pot
 * @param[out] pot_total_len set to length of @a pot_totals
 * @param[out] pot_totals set to amount currently in the pot
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_select_money_pot (void *cls,
                         const char *instance_id,
                         uint64_t money_pot_id,
                         char **name,
                         char **description,
                         size_t *pot_total_len,
                         struct TALER_Amount **pot_totals);

#endif
