/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_insert_report.h
 * @brief implementation of the insert_report function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_INSERT_REPORT_H
#define PG_INSERT_REPORT_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"


/**
 * Insert details about a particular pot.
 *
 * @param cls closure
 * @param instance_id instance to insert pot for
 * @param report_program_section configuration section of program
 *   for report generation
 * @param report_description text describing the report
 * @param mime_type mime type to request from the @a data_source
 * @param data_source relative URL (to instance base URL)
 *   to request report data from
 * @param target_address where to send report data
 * @param frequency report frequency
 * @param frequency_shift how much to shift the report time from a
 *   multiple of the report @a frequency
 * @param[out] report_id serial number of the new pot
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_insert_report (
  void *cls,
  const char *instance_id,
  const char *report_program_section,
  const char *report_description,
  const char *mime_type,
  const char *data_source,
  const char *target_address,
  struct GNUNET_TIME_Relative frequency,
  struct GNUNET_TIME_Relative frequency_shift,
  uint64_t *report_id);


#endif
