/*
  This file is part of TALER
  Copyright (C) 2021-2025 Taler Systems SA

  TALER is free software; you can redistribute it and/or modify it under the
  terms of the GNU Affero General Public License as published by the Free Software
  Foundation; either version 3, or (at your option) any later version.

  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more details.

  You should have received a copy of the GNU Affero General Public License along with
  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
*/
/**
 * @file taler-merchant-httpd_dispatcher.h
 * @brief request dispatch logic
 * @author Christian Grothoff
 */
#ifndef TALER_MERCHANT_HTTPD_DISPATCHER_H
#define TALER_MERCHANT_HTTPD_DISPATCHER_H

#include "taler-merchant-httpd.h"


/**
 * Find the request handler for the given request based on
 * the @a url and @a method. Only considers applicable
 * request handlers, thus we need @a use_admin to see if admin
 * handlers are in scope.
 *
 * @param[in,out] hc handler context to update with request handler
 * @param url URL to match against the handlers
 * @param method HTTP access method to consider
 * @param use_admin true if we are using the admin instance
 * @param[out] is_public set to true if the handler is a public endpoint
 * @return #GNUNET_OK on success,
 *         #GNUNET_NO if an error was queued (return #MHD_YES)
 *         #GNUNET_SYSERR to close the connection (return #MHD_NO)
 */
enum GNUNET_GenericReturnValue
TMH_dispatch_request (struct TMH_HandlerContext *hc,
                      const char *url,
                      const char *method,
                      bool use_admin,
                      bool *is_public);

#endif
