/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_lookup_mfa_challenge.h
 * @brief implementation of the lookup_mfa_challenge function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_LOOKUP_MFA_CHALLENGE_H
#define PG_LOOKUP_MFA_CHALLENGE_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"


/**
 * Check if a new multi-factor authorization (MFA) challenge
 * matching the body exists in the database.
 *
 * @param cls closure
 * @param challenge_id set to the ID of the challenge
 * @param h_body hash of the request body
 * @param[out] salt salt used to compute @a h_body
 * @param[out] required address set to where the challenge is to be send
 * @param[out] op operation that triggered the MFA request
 * @param[out] confirmation_date when was the challenge solved,
 *             set to "GNUNET_TIME_ABSOLUTE_NEVER" if unsolved
 * @param[out] retransmission_date set to when a fresh challenge
 *             may be transmitted
 * @param[out] retry_counter set to the number of attempts that remain
 *             for solving the challenge (after this time)
 * @param[out] tan_channel which channel was used
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_lookup_mfa_challenge (
  void *cls,
  uint64_t challenge_id,
  const struct TALER_MERCHANT_MFA_BodyHash *h_body,
  struct TALER_MERCHANT_MFA_BodySalt *salt,
  char **required_address,
  enum TALER_MERCHANT_MFA_CriticalOperation *op,
  struct GNUNET_TIME_Absolute *confirmation_date,
  struct GNUNET_TIME_Absolute *retransmission_date,
  uint32_t *retry_counter,
  enum TALER_MERCHANT_MFA_Channel *tan_channel);


#endif
