// VQF 902.1 Identification Form Template
// Pass JSON data as content dictionary

#let form(data) = {
  set page(
    paper: "a4",
    margin: (left: 2cm, right: 2cm, top: 2cm, bottom: 2.5cm),
    footer: context [
      #grid(
        columns: (1fr, 1fr),
        align: (left, right),
        text(size: 8pt)[
          VQF doc. Nr. 902.1-officer#linebreak()
          Version of 1 September 2021
        ],
        text(size: 8pt)[
          Page #here().page() of #counter(page).final().first()
        ]
      )
    ]
  )

  set text(font: "Liberation Sans", size: 10pt)
  set par(justify: false, leading: 0.65em)

  // Helper function to get value or empty string
  let get(key, default: "") = {
    data.at(key, default: default)
  }

  // Helper function to get value or false
  let getb(key, default: false) = {
    data.at(key, default: default)
  }

  // Helper function for checkbox
  let checkbox(checked) = {
    box(
      width: 3mm,
      height: 3mm,
      stroke: 0.5pt + black,
      inset: 0.3mm,
      if checked == true or checked == "true" {
        place(center + horizon, text(size: 8pt, sym.checkmark))
      }
    )
  }

  // Header
  align(center, text(size: 11pt, weight: "bold")[CONFIDENTIAL])

  v(0.5em)


  grid(
    columns: (50%, 50%),
    gutter: 1em,
    image("vss_vqf_verein.png", width: 80%),

    align(right)[
      #table(
        columns: (1fr, 1fr),
        stroke: 0.5pt + black,
        inset: 5pt,
        align: (left, left),
        [VQF member no.], [AMLA File No.],
        [#get("VQF_MEMBER_NUMBER")], [#get("FILE_NUMBER")]
      )
    ]
  )

  v(1em)

  align(left, text(size: 14pt, weight: "bold")[Identification Form])

  v(-1em)
  line(length:100%)

  grid(
    columns: (auto, 1fr),
    gutter: 0.5em,
    align: (left, left),
    image("pointing_finger.svg", height: 2em),
    text(size: 9pt)[
      The customer has to be identified on entering into a permanent business relationship or on concluding a cash transaction, which meets the according threshold.
    ]
  )

  v(1em)

  text(weight: "bold")[This form was completed by:]

  v(0.3em)

  table(
    columns: (1fr, 1fr),
    stroke: 0.5pt + black,
    inset: 5pt,
    align: (left, left),
    [Full name], [#get("AML_STAFF_NAME")],
    [Date], [#get("FILING_DATE")],
  )

  v(1.5em)

  // Section 3: Acceptance of business relationship
  text(size: 11pt, weight: "bold")[3. Acceptance of business relationship]

  v(0.5em)

  let acceptance = get("ACCEPTANCE_METHOD")
  table(
    columns: (35%, 65%),
    stroke: 0.5pt + black,
    inset: 5pt,
    [Date (conclusion of contract)], get("ACCEPTANCE_DATE"),
    [Accepted by],
    [#grid(
      columns: (auto, 1fr),
      gutter: 0.5em,
      checkbox(acceptance == "FACE_TO_FACE"),
      [Face-to-face meeting with customer],
      checkbox(acceptance == "WAY_OF_CORRESPONDENCE"),
      [Way of correspondence:
       \ #v(-0.7em) #grid(
         columns: (0.2em, auto),
         gutter: 0.5em,
         row-gutter: 0.3em,
         [],
         [#checkbox(acceptance == "AUTHENTICATED_COPY")
          authenticated copy of identification document obtained],
         [],
         [#checkbox(acceptance == "RESIDENTIAL_ADDRESS_VALIDATED")
          residential address validated]
       )
     ]
    )],
    [Type of correspondence service],
    [#grid(
      columns: (auto),
      gutter: 0.2em,
      [#checkbox(true) to the customer],
      [#checkbox(false) hold at bank],
      [#checkbox(false) to the member],
      [#checkbox(false)
       to a third party (full name and address):],
    )],
    [Further information],
    [#get("ACCEPTANCE_FURTHER_INFO")]
  )

  v(2em)

  // Section 5: Embargo/terrorism evaluation
  text(size: 11pt, weight: "bold")[5. Evaluation with regard to embargo procedures/terrorism lists on establishing the business relationship]

  v(0.5em)

  table(
    columns: (35%, 65%),
    stroke: 0.5pt + black,
    inset: 5pt,
    [Verification whether the customer, beneficial owners of the assets, controlling persons, authorised representatives or other involved persons are listed on an embargo-/terrorism list (date of verification/result)#footnote[The evaluation must be made at the beginning of the business relationship and has to be repeated in the case of permanent business relationship every time the according lists are updated.]],
    [Date: #get("EMBARGO_TERRORISM_CHECK_DATE")
     \ Result: #get("EMBARGO_TERRORISM_CHECK_RESULT")],
  )

  v(2em)

  // Section 6: Cash transactions
  text(size: 11pt, weight: "bold")[6. In the case of cash transactions/occasional customers: Information on type and purpose of business relationship]

  v(0.5em)

  grid(
    columns: (auto, 1fr),
    gutter: 0.5em,
    align: (left, left),
    image("pointing_finger.svg", height: 2em),
    text(size: 9pt)[
      These details are only necessary for occasional customers, i.e. money exchange, money and asset transfer or other cash transactions provided that #underline([no]) customer profile (VQF doc. No. 902.5) is created
    ]
  )

  v(1em)

  table(
    columns: (35%, 65%),
    stroke: 0.5pt + black,
    inset: 5pt,
    [Type of business relationship],
    [#grid(
      columns: (auto),
      gutter: 0.2em,
      [#checkbox(false) Money exchange],
      [#checkbox(false) Money and asset transfer],
      [#checkbox(false) Other cash transaction, specify?],
    )],
    [Purpose of the business relationship\ (purpose of service requested)], [],
  )

  // Section 7: Enclosures
  text(size: 11pt, weight: "bold")[7. Enclosures]

  v(0.5em)

  grid(
    columns: (auto, 1fr),
    stroke: 0.5pt + black,
    inset: 5pt,
    checkbox("" != get("CUSTOMER_ID_AMLA_FILE_REFERENCE_NO")), [Customer identification documents (or: reference#footnote[If the identification document is lists kept in another AMLA-File (in the case of Art. 15 para. 3 SRO Regulations) a reference to the according AMLA-File is sufficient.] to AMLA File No.: #underline([#get("CUSTOMER_ID_AMLA_FILE_REFERENCE_NO")]))],
    checkbox("" != get("ESTABLISHER_ID_AMLA_FILE_REFERENCE_NO")), [Identification document of persons establishing the business relationship (or: reference to AMLA File No.: #underline([#get("ESTABLISHER_ID_AMLA_FILE_REFERENCE_NO")]))],
    checkbox(getb("HAVE_vqf_902_9") or getb("HAVE_vqf_902_11_customer") or getb("HAVE_vqf_902_11_officer") or getb("HAVE_vqf_902_12") or getb("HAVE_vqf_902_13") or getb("HAVE_vqf_902_15")), [Establishing of the beneficial owner of the assets/controlling person (VQF Doc No. 902.15, 902.9, 902.11, 902.12 or 902.13)],
    checkbox(getb("HAVE_vqf_902_5")), [Customer profile (VQF doc. No. 902.5; only in the case of permanent business relationship and regular customers)],
    checkbox(getb("HAVE_vqf_902_4")), [Risk profile (VQF doc. No. 902.4)],
  )

  v(1em)

  text(size: 9pt, style: "italic")[⚠ *This form has to be updated when changes occur.*]

}

// Example usage:
#form((
   "VQF_MEMBER_NUMBER": "12345",
   "FILE_NUMBER": "42",
   "AML_STAFF_NAME": "Manuela",
   "FILING_DATE": "2000-4-1",
   "ACCEPTANCE_DATE": "2000-4-1",
   "ACCEPTANCE_METHOD" : "FACE_TO_FACE",
   // ... other fields
 ))
