--
-- This file is part of TALER
-- Copyright (C) 2024 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

CREATE TABLE kyc_events (
  kyc_event_serial_id BIGINT GENERATED BY DEFAULT AS IDENTITY
 ,event_timestamp INT8 NOT NULL
 ,event_type TEXT NOT NULL
);

COMMENT ON TABLE kyc_events
  IS 'Records of key events for statistics. Populated via triggers.';
COMMENT ON COLUMN kyc_events.event_type
  IS 'Name of the event, such as account-open or sar-filed';

CREATE INDEX kyc_event_index
  ON kyc_events(event_type,event_timestamp);
