//****************************************************************************//
//      Untabifier class:
//
//      Derived Pretranslator to convert tabs to spaces before HTML generation
//
//      Don Stauffer Revision: June 2003
//      Lorenzo Bettini Revision: November 2004, mostly rewritten
//****************************************************************************//
#ifndef	srcUntabifier_H
#define	srcUntabifier_H

#include "textformatter.h"

using std::string;

class Untabifier : public TextFormatter
{
 public:

  Untabifier (int nSpacesPerTab, TextFormatterPtr f = TextFormatterPtr()) :
    TextFormatter(f), nSpacesPerTab_ (nSpacesPerTab), n_ (0)
    {
    }

  virtual const string preformat( const std::string &text );

 private:

  const int nSpacesPerTab_;
  int n_;
};

#endif //      #ifndef srcUntabifier_H
