//****************************************************************************//
//      Untabifier class:
//
//      Derived Pretranslator to convert tabs to spaces before HTML generation
//
//      Don Stauffer Revision: June 2003
//****************************************************************************//
#ifndef	srcUntabifier_H
#define	srcUntabifier_H

#include	<string>

#include	"srcpretranslator.h"

using std::string;

class Untabifier : public Pretranslator
{
 public:

  Untabifier (int nSpacesPerTab):nSpacesPerTab_ (nSpacesPerTab), n_ (0)
    {
    }

  void generate (const string & s);

  void generate (const string & s, int start, int end);

  void generateln (const string & s);

  void generate_preproc (const string & s);

  void generate_normal (const string & s);

  void generateTab (void);

  void generateComment (const string & s);

  void generateString (const string & s);

  void generateKeyWord (const string & s);

  void generateBaseType (const string & s);

  void generatePreProc (const string & s);

  void generateNumber (const string & s);

  void generateSymbol (const string & s);

  void generateFunction (const string & s);

  void generateCBracket (const string & s);

  virtual void generate( const std::string &elem, const std::string &s );
  virtual void generate( const std::string &elem, const std::string &s, int start, int end );
  virtual void generate_preproc(const std::string &elem, const std::string &s);

  virtual void generateln( const std::string &elem, const std::string &s );

  virtual void generateEntire( const std::string &elem, const std::string &s );

  virtual void beginText( const std::string &elem, const std::string &s );
  virtual void endText( const std::string &elem, const std::string &s );

 private:

  const int nSpacesPerTab_;
  int n_;

};				//      class   Untabifier

#endif //      #ifndef srcUntabifier_H
