#!/usr/bin/python

# Warning: This setup.py script is *only* used to create the MS Windows
# installer. It will break on a real OS.

import glob
from distutils.core import setup
import py2exe
import src.configureoutput
import sys, os

def get_files(file_spec):
    path = os.path.normpath(file_spec)
    ret = filter(lambda x: not x.endswith('CVS'), glob.glob(path))
    ret = filter(os.path.isfile, ret)
    return ret

setup(name="solfege",
      version=src.configureoutput.VERSION_STRING,
      author="Tom Cato Amundsen",
      author_email="tca@gnu.org",
      url="http://www.solfege.org",
      data_files=[('graphics', get_files('graphics/*.png')),
                  ('soundcard', ['soundcard/winmidi.pyd']),
                  ('feta', get_files('feta/*.xpm')),
                  ('gnomeemu/xpm', get_files('gnomeemu/xpm/*.xpm')),
                  ('online-docs/C', get_files('online-docs/C/*.html')),
                  ('online-docs/no', get_files('online-docs/no/*.html')),
                  ('online-docs/nl', get_files('online-docs/nl/*.html')),
                  ('online-docs/fr', get_files('online-docs/fr/*.html')),
                  ('online-docs/ru', get_files('online-docs/ru/*.html')),
                  ('online-docs/es_MX', get_files('online-docs/es_MX/*.html')),
                  ('online-docs/png', get_files('online-docs/png/*.png')),
                  ('online-docs/midi', get_files('online-docs/midi/*.png')),
                  ('share/locale/da/LC_MESSAGES', get_files('share/locale/da/LC_MESSAGES/*.mo')),
                  ('share/locale/de/LC_MESSAGES', get_files('share/locale/de/LC_MESSAGES/*.mo')),
                  ('share/locale/es/LC_MESSAGES', get_files('share/locale/es/LC_MESSAGES/*.mo')),
                  ('share/locale/es_MX/LC_MESSAGES', get_files('share/locale/es_MX/LC_MESSAGES/*.mo')),
                  ('share/locale/fr/LC_MESSAGES', get_files('share/locale/fr/LC_MESSAGES/*.mo')),
                  ('share/locale/it/LC_MESSAGES', get_files('share/locale/it/LC_MESSAGES/*.mo')),
                  ('share/locale/nl/LC_MESSAGES', get_files('share/locale/nl/LC_MESSAGES/*.mo')),
                  ('share/locale/no/LC_MESSAGES', get_files('share/locale/no/LC_MESSAGES/*.mo')),
                  ('share/locale/ru/LC_MESSAGES', get_files('share/locale/ru/LC_MESSAGES/*.mo')),
                  ('lesson-files', get_files('lesson-files/*')),
                  ('.', ['solfege.py', 'default.config', 'solfege.gtkrc',
                         'AUTHORS.txt', 'COPYING.txt', 'README.txt',
                         'INSTALL.txt', 'INSTALL.win32.txt', 'FAQ.txt',
                         'solfege.bat', 'ui.xml'])
      ],
      packages=['gnomeemu','mpd', 'src', 'soundcard'],
      scripts=["solfege.py"],
      console=["solfege.py"],
)
