@c  Copyright (C) 2000, 2001, 2002  Tom Cato Amundsen
@c  Permission is granted to copy, distribute and/or modify this document
@c  under the terms of the GNU Free Documentation License, Version 1.1
@c  or any later version published by the Free Software Foundation;
@c  with no Invariant Sections.

@c  $Id: id-tone-help.texi.m4,v 1.10.2.2 2002/02/17 22:42:35 tom Exp $

m4_include(texidefinitions.m4)

@section Identify tone

This is a combined tone memory and interval exercise. Some
people believe this kind of exercise can give you perfect pitch
(absolute pitch), but I don't believe so.

The basics are: the program play a tone and you must
identify it by comparing it with the last tone played for you.
    
To get you started the program will play one tone and display
its name on the status bar. You identify the tones by clicking
on the piano keyboard or using the keyboard shortcuts that
are the letters written on each key.

Right click on the piano keyboard to hear a note without
actually guessing it. (Some will call that cheating....)

There are several ways you can use this exercise. Personally, I
have not used this exercise very much, and the sections below
are only suggestions.

@subsection Note by note
Start with only the notes @uref{solfege:practise/id-tone?c_weight=1;cis_weight=0;d_weight=1;dis_weight=0;e_weight=1;f_weight=0;fis_weight=0;g_weight=0;gis_weight=0;a_weight=0;ais_weight=0;b_weight=0, c-d-e} at weight 1.
When your score is at least 96% correct, you 
@uref{solfege:practise/id-tone?c_weight=1;cis_weight=0;d_weight=1;dis_weight=0;e_weight=1;f_weight=1;fis_weight=0;g_weight=0;gis_weight=0;a_weight=0;ais_weight=0;b_weight=0, add the tone f} and continue. Add one and one tone
by giving it weight 1 at the @uref{solfege:config/id-tone, config page}
as your skills improve. Add first all the white tones, then the black.

@subsection Heavy A
@uref{solfege:practise/id-tone?c_weight=1;cis_weight=1;d_weight=1;dis_weight=1;e_weight=1;f_weight=1;fis_weight=1;g_weight=1;gis_weight=1;a_weight=11;ais_weight=1;b_weight=1, Configure with the tone @emph{a} at weight 11} (or
higher) and the rest of the tones at weight 1. This way the
program will play the tone @emph{a} very often, so you will remember
the tone, and then you use @emph{a} as a reference tone to identify
the other tones. When you have practised a while, you can reduce the
weight of @emph{a} to make the exercise harder.

@subsection Key bindings
@itemize @bullet
@item New tone: _ctrl_key(id-tone/new_ak, n)
@item Repeat: _ctrl_key(id-tone/repeat_ak, r)
@item Give up: _ctrl_key(id-tone/give_up_ak, g)
@end itemize

@subsection Config
On the top of the config page you tell the program how important the
different tones are. If you for example give the tone @emph{a}
11 points and the rest 1 point each, then (11+11*1)/11*100 = 50%
of the random tones will be an @emph{a}.

Below that you select what octaves the random tones can be from.

In the frame below you can set some pretty self explaining options
about what happens if you answer wrong.

The keyboard shortcuts can be configured from
@file{$HOME/.solfegerc`'SOLFEGESHORTVERSION}.

