/* PSPP - computes sample statistics.
   Copyright (C) 1997-9, 2000 Free Software Foundation, Inc.
   Written by Ben Pfaff <blp@gnu.org>.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301, USA. */

#if !settings_h
#define settings_h 1

/* Table of mode settings (x=X, w=Windows, p=PC+, f=has relevance for
   PSPP):

   AUTOMENU: p
   BEEP: p
   BLANKS: xwpf
   BLKSIZE: x (only on SHOW, not on SET)
   BLOCK: xwp
   BOX/BOXSTRING: xwp
   BUFNO: x (only on SHOW, not on SET)
   CASE: xw
   CCA...CCE: xwf
   COLOR: p
   COMP/COMPRESSION: xwpf (meaning varies between p and xw)
   CPI: xwp
   CPROMPT: pf
   DECIMAL: wf
   DPROMPT: f
   ECHO: pf
   EJECT: p
   EMULATION: f
   ENDCMD: xpf
   ERRORBREAK: pf
   ERRORS: wf
   FORMAT: xwf
   HEADERS: xwf
   HELPWINDOWS: p
   HIGHRES: w
   HISTOGRAM: xp
   INCLUDE: pf
   JOURNAL: wf (equivalent to LOG)
   LENGTH: xwp
   LISTING: xpf
   LOG: pf (equivalent to JOURNAL)
   LOWRES: w
   LPI: xwp
   MENUS: p
   MESSAGES: wf
   MEXPAND: xwf
   MITERATE: xwf
   MNEST: xwf
   MORE: pf
   MPRINT: xwf
   MXERRS: xf
   MXLOOPS: xwf
   MXMEMORY: w
   MXWARNS: xwf
   N: xw (only on SHOW, not on SET)
   NULLINE: xpf
   NUMBERED: x (only on SHOW, not on SET)
   PAGER: f
   PRINTBACK: xwf
   PRINTER: pf
   PROMPT: pf
   PTRANSLATE: p
   RCOLOR: p
   RESULTS: wpf (semantics differ)
   RUNREVIEW: p
   SCOMP/SCOMPRESSION: xwf
   SCREEN: pf
   SCRIPTTAB: xw
   SEED: xwpf (semantics differ)
   SYSMIS: xwf (only on SHOW, not on SET)
   TBFONTS: xw
   TB1: xw
   TB2: x
   UNDEFINED: xwf
   VIEWLENGTH: pf
   VIEWWIDTH: f
   WEIGHT: xwf (only on SHOW, not on SET)
   WIDTH: xwp
   WORKDEV: p
   WORKSPACE: w
   XSORT: x
   $VARS: wf (only on SHOW, not on SET)

 */

#include <stddef.h>
#include <float.h>


/* Describes one custom currency specification. */
struct set_cust_currency
  {
    char buf[32];		/* Buffer for strings. */
    char *neg_prefix;		/* Negative prefix. */
    char *prefix;		/* Prefix. */
    char *suffix;		/* Suffix. */
    char *neg_suffix;		/* Negative suffix. */
    int decimal;		/* Decimal point. */
    int grouping;		/* Grouping character. */
  };




/* Types of routing. */
enum
  {
    SET_ROUTE_SCREEN = 001,	/* Output to screen devices? */
    SET_ROUTE_LISTING = 002,	/* Output to listing devices? */
    SET_ROUTE_OTHER = 004,	/* Output to other devices? */
    SET_ROUTE_DISABLE = 010	/* Disable output--overrides all other bits. */
  };


/* Set view width to a very long value, and prevent it from 
   ever changing */
void force_long_view(void);


/* Requested "view length" in lines. */
int get_viewlength(void);

/* Screen width. */
int get_viewwidth(void);

void init_settings(void) ;
void done_settings(void) ;

/* Whether pspp can erase and overwrite files */
int safer_mode(void);

/* Put into safer mode */
void make_safe(void);

/* The character used for a decimal point: ',' or '.'.  Only respected
   for data input and output. */
char get_decimal(void);

/* The character used for grouping in numbers: '.' or ','; the
   opposite of set_decimal.  Only used in COMMA data input and
   output. */

char get_grouping(void);

char *get_prompt(void);

/* Prompt used for lines between BEGIN DATA and END DATA. */
char *get_dprompt(void);

/* Continuation prompt. */
char *get_cprompt(void);


/* Whether we echo commands to the listing file/printer;*/
int get_echo(void);

/* What year to use as the start of the epoch. */
int get_epoch (void);

/* If echo is on, whether commands from include files are echoed */
int get_include(void);

/* Whether an error stops execution; */
int  get_errorbreak(void);

/* Whether save files should be compressed by default. */
int get_scompression(void);

/* Whether to warn on undefined values in numeric data. */
int get_undefined(void);

/* Maximum number of warnings + errors. */
int get_mxwarns(void);

/* Maximum number of errors. */
int get_mxerrs(void);

/* 0=macro expansion is disabled, 1=macro expansion is enabled. */
int get_mexpand(void);

/* Whether commands are written to the display */
int get_printback(void);

/* Independent of get_printback, controls whether the commands
   generated by macro invocations are displayed. */
int get_mprint(void);

/* Implied limit of unbounded loop. */
int get_mxloops(void);

/* Whether a blank line is a command terminator */
int get_nullline(void);

/* The character used to terminate commands. */
unsigned char get_endcmd(void);

/* Approximate maximum amount of memory to use for cases, in
   bytes. */
size_t get_max_workspace(void);

/* The value that blank numeric fields are set to when read in;
   normally SYSMIS. */
double get_blanks(void);


/* Default format for variables created by transformations and by DATA
   LIST {FREE,LIST}. */
struct fmt_spec get_format(void);

/* CCA through CCE. */
const struct set_cust_currency *get_cc(int i);

#if !USE_INTERNAL_PAGER
/* Name of the pager program. */
const char *get_pager(void);
#endif /* !USE_INTERNAL_PAGER */


#include <gsl/gsl_rng.h>
gsl_rng *get_rng (void);


enum {ENHANCED,COMPATIBLE};


/* Set the algorithm option globally */
void set_algorithm(int x);

/* Set the algorithm option for this command only */
void set_cmd_algorithm(int x);

/* Unset the algorithm option for this command */
void unset_cmd_algorithm(void);

/* Return the current algorithm setting */
int get_algorithm(void);

/* Set the syntax option */
void set_syntax(int x);

/* Get the current syntax setting */
int get_syntax(void);


#endif /* !settings_h */
