/* grecs - Gray's Extensible Configuration System
   Copyright (C) 2007, 2008, 2009 Sergey Poznyakoff

   Grecs is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 3 of the License, or (at your
   option) any later version.

   Grecs is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with Grecs. If not, see <http://www.gnu.org/licenses/>. */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include <grecs.h>
#include <string.h>
#include <hash.h>
#include <xalloc.h>

static Hash_table *text_table;

/* Calculate the hash of a string.  */
static size_t
text_hasher (void const *data, size_t n_buckets)
{
  return hash_string (data, n_buckets);
}

/* Compare two strings for equality.  */
static bool
text_compare (void const *data1, void const *data2)
{
  return strcmp (data1, data2) == 0;
}

static void
text_free (void *data)
{
  free (data);
}

/* Lookup a text. If it does not exist, create it. */
char *
grecs_install_text (const char *str)
{
  char *text, *s;

  s = xstrdup (str);

  if (!((text_table
	 || (text_table = hash_initialize (0, 0,
					   text_hasher,
					   text_compare,
					   text_free)))
	&& (text = hash_insert (text_table, s))))
    xalloc_die ();

  if (s != text)
    free (s);
  return text;
}

void
grecs_destroy_text ()
{
  if (text_table)
    hash_free (text_table);
}
