#Utilities for Grader. Used for centering dialogues 
#stolen from TkNet.

###############################################################
# TkNet - Utilities Module
# Charlie KEMPSON - charlie@siren.demon.co.uk
# http://public.logica.com/~kempsonc/tknet.htm
# Version 1.1
###############################################################

###############################################################
#
#    Copyright (c) 1995-1996 Charlie Kempson
#
#    This program is free software; you can redistribute it 
#    and/or modify it under the terms of the GNU General 
#    Public License as published by the Free Software 
#    Foundation (version 2 of the License).
#
#    This program is distributed in the hope that it will 
#    be useful, but WITHOUT ANY WARRANTY; without even the 
#    implied warranty of MERCHANTABILITY or FITNESS FOR A 
#    PARTICULAR PURPOSE.  See the GNU General Public License 
#    for more details.
#
#    For a copy of the GNU General Public License, write to the 
#    Free Software Foundation, Inc. 59 Temple Place, Suite 330, 
#    Boston, MA 02111, USA.
###############################################################
###############################################################
# Centre a window on the screen (or parent)
proc Centre_Dialog {window {position ""} {parent ""}} {

   # Withdraw dialog and update all windows
   wm withdraw $window
   update idletasks
   set win_width [winfo reqwidth $window]
   set win_height [winfo reqheight $window]

   # Read the positioning argument (pointer, widget, default)
   switch -glob -- $position {
      p* {
         # place at POINTER (centered is $a == center)
         wm geometry $window +[expr \
            [winfo pointerx $window]-$win_width \
            /2]+[expr [winfo pointery $window]-\
            $win_height/2]
      }
      w* {
         # center about WIDGET $parent
         wm geometry $window +[expr [winfo rootx $parent]+ \
            ([winfo width $parent]-$win_width)/2]+[expr \
            [winfo rooty $parent]+([winfo height \
            $parent]-$win_height)/2]
      }
      default {
         wm geometry $window +[expr ([winfo screenwidth \
            $window]-$win_width) / 2]+[expr ([winfo screenheight \
            $window]- $win_height) / 2]
      }
   }

   # Now show the window
   wm deiconify $window
}
