/*  Motti -- a strategy game
    Copyright (C) 1999-2014 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "StdAfx.h"
#include "AiPlayer.h"
#include "Board.h"

#include <math.h>
AiPlayer::AiPlayer(Player *name,MottiRulesManager *aa):player_(name),attackprecision_(10.0),rules_(aa)
{
	
}


AiPlayer::~AiPlayer(void)
{
	
}


void AiPlayer::think( Board *b){
	vectEnnemyHouse_.clear();
	vectColorizedCoord_.clear();
	//where are the ennemies
	searchEnnemyHouse(b);
	//colors
	colorize(b);
	orderByPrecision();
	play(b);
}

void AiPlayer::attack(Board *b){
	if (b->getActualPlayer()->getName()=="a") {
		int i=0;
	}
	std::vector<coordinate2DM>::iterator ittCopy=lastChoice_.begin();
	while(ittCopy!=lastChoice_.end())
	{
		
			if (randGen_.nextBoolean()){
				rules_->attack(player_,(*ittCopy).x,(*ittCopy).y);
			}
		
		ittCopy++;
	}
	

}

void AiPlayer::guerilla(Board *b){
	std::vector<coordinate2DM>::iterator ittCopy=lastChoice_.begin();
	while(ittCopy!=lastChoice_.end())
	{
		if ((*ittCopy).caseCoord->getPreviousPlayer()->getName()!=player_->getName())
		{
			if (randGen_.nextBoolean()){
				rules_->guerilla(player_,(*ittCopy).x,(*ittCopy).y);
			}
		}
		ittCopy++;
	}
	

}

void AiPlayer::play(Board *b){
	bool isgueri=isGuerillable();
	if (randGen_.nextBoolean()&&isgueri)
	{
		guerilla(b);
	}
	attack(b);

}

bool AiPlayer::isGuerillable(){
	std::vector<coordinate2DM>::iterator ittCopy=lastChoice_.begin();
	while(ittCopy!=lastChoice_.end())
	{
		if ((*ittCopy).caseCoord->getPreviousPlayer()->getName()!=player_->getName())
		{
			return true;
		}
		ittCopy++;
	}
	return false;
}

AiPlayer::coordinate2DM AiPlayer::calculateMinValue(){
	double minactualValue=999999;
	coordinate2DM min(-1,-1);
	std::vector<coordinate2DM>::iterator ittCopy=lastChoice_.begin();
	while(ittCopy!=lastChoice_.end())
	{
		if ((*ittCopy).value<minactualValue)
		{
			min=*ittCopy;
			minactualValue=(*ittCopy).value;
		}
		ittCopy++;
	}
	return min;
}

void AiPlayer::orderByPrecision(){
	if (vectColorizedCoord_.size()<=10)
	{
		lastChoice_=vectColorizedCoord_;
		return;
	}
	std::vector<coordinate2DM>::iterator itt= vectColorizedCoord_.begin();
	double minactualValue=0;
	coordinate2DM min(-1,-1);

	int maxVal=(int)(vectColorizedCoord_.size()*attackprecision_/100.0);
	if (maxVal<10) maxVal=10;

	while (itt!=vectColorizedCoord_.end())
	{
		
		if ((*itt).value>=minactualValue||(int)lastChoice_.size()<maxVal)
		{
			if ((*itt).caseCoord->getPlayer()->getName()=="a") {
				int i=0;
			}
			
			if ((int)lastChoice_.size()>=maxVal)
			{
				
				
				std::vector<coordinate2DM>::iterator ittCopy=lastChoice_.begin();
				while(ittCopy!=lastChoice_.end())
				{
					if ((*ittCopy).x==min.x&&(*ittCopy).y==min.y)
					{
						lastChoice_.erase(ittCopy);
						break;
					}
					ittCopy++;
				}
				
			}
			
			lastChoice_.push_back(*itt);
			min=calculateMinValue();
			minactualValue=min.value;
			
			
		}
		itt++;
	}

}

void AiPlayer::colorize( Board *b){
	int i=0,j=0;
	maxdistance_=(double)(b->getWidth()*b->getWidth()+b->getHeight()*b->getHeight());
	maxdistance_=sqrt(maxdistance_);
	for (i=0;i<b->getWidth();i++)
		for (j=0;j<b->getHeight();j++)
		{
			Case *casesz=b->getCaseNoThrow(i,j);
			if (casesz!=NULL)
			{
				if (casesz->getPlayer() != NULL&&player_!=NULL)
				{
					if ((casesz->getPlayer()->getName() == player_->getName()&&casesz->getType()==Case::FREE)||nearIsLocked(b,i,j))
					{
						double value=calculateValue(b,i,j);
						coordinate2DM mm(i,j,casesz);
						mm.value=value;
						vectColorizedCoord_.push_back(mm);
					}
				}
			}
		}


	
}
bool AiPlayer::nearIsLocked(Board *b,int x,int y){
	Case *eed=b->getCaseNoThrow(x,y);
	if (eed==NULL) return false;
	//if (eed->getType()!=Case::FREE&&eed->getType()!=Case::LOCKED) return false; 
	if (eed->getPlayer()==NULL) return false;

	if (eed->getPlayer()->getName()!=player_->getName())
	{
		int i=0,j=0;
		for (i=-1;i<2;i++)
			for (j=-1;j<2;j++)
			{
				Case *eed=b->getCaseNoThrow(x+i,y+j);
				if (eed!=NULL)
				{
					if (eed->getPlayer()!=NULL)
					{
						if(eed->getPlayer()->getName()==player_->getName()&&eed->getType()==Case::LOCKED)
						{
							return true;
						}
					}
				}
			}
	}
	return false;

}

double AiPlayer::calculateValue(Board *b,int x,int y){
	if (b->getActualPlayer()->getName()=="a") {
		int i=0;
	}
	double ret=maxdistance_;
	//calculate distance from ennemy
	std::vector<coordinate2DM>::iterator itt= vectEnnemyHouse_.begin();
	while(itt!=vectEnnemyHouse_.end())
	{
		int xdiff=x-(*itt).x;
		int ydiff=y-(*itt).y;

		double distance=sqrt((double)(xdiff*xdiff+ydiff*ydiff));
		ret=maxdistance_-distance;
		itt++;
	}
	int i=0,j=0;
	for (i=-1;i<2;i++)
			for (j=-1;j<2;j++)
			{
				Case *eed=b->getCaseNoThrow(x+i,y+j);
				if (eed!=NULL)
				{
					if (eed->getPlayer()!=NULL)
					{

						if(eed->getPlayer()->getName()==player_->getName()&&eed->getType()==Case::LOCKED)
						{
							ret=ret*1.001;
						}
						if(eed->isCityCenter()&&eed->getPlayer()->getName()==player_->getName())
						{
							ret=ret*1.1;
						}
						if(eed->getPlayer()->getName()!=player_->getName()&&eed->getType()==Case::LOCKED)
						{
							ret=ret*1.01;
						}
						if(eed->getPlayer()->getName()!=player_->getName())
						{
							ret=ret*1.001;
						}
					}
				}
			}
	

	return ret;
}

void AiPlayer::searchEnnemyHouse(Board *b){
	
	int i=0,j=0;
	for (i=0;i<b->getWidth();i++)
		for (j=0;j<b->getHeight();j++)
		{
			Case *casesz=b->getCaseNoThrow(i,j);
			if (casesz!=NULL)
			{
				if (casesz->getPlayer() != NULL&&player_!=NULL)
				{
					if (casesz->isCityCenter()&&casesz->getPlayer()->getName()!=player_->getName())
					{
						vectEnnemyHouse_.push_back(coordinate2DM(i,j,casesz));
					}
				}
			}
		}
}


RandomGenerator &AiPlayer::getRandomGenerator(){
	return randGen_;

}

