/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "StdAfx.h"
#include "MapManagerTest.h"
#include <string>
#include "MapManager.h"
#include <iostream>

MapManagerTest::MapManagerTest(void)
{
}


MapManagerTest::~MapManagerTest(void)
{
}

int MapManagerTest::testStringParsing(){
	std::string myMap="width 32\n";
	myMap+="height 23\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="  a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a a a a   a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a   a     a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a             a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a               b b b \n";
	myMap+="a a a a a a a a   a a     a a a a a a a a       b b       b b b \n";
	myMap+="a a a a a a         a a     a a a a a a   b b b b b b b b b b b \n";
	myMap+="a a a a a           a.a     a a a a a   b b b b b b.b b b b b b \n";
	myMap+="  a a a a             a a     a a a     b b b b b b b b b b b b \n";
	myMap+="  a a a a             a a a     a a       b b b b b b b b b b b \n";
	myMap+="    a               a a   a       a               b b b b b b b \n";
	myMap+="    c             a                                 b b b b b b \n";
	myMap+="  c c c           a a                               b b b b b b \n";
	myMap+="c c c c c c c c c                                   b b b b b b \n";
	myMap+="c c c c c c c c c               c c c               b b b b b b \n";
	myMap+="c c c c c c c c c c c.        c c c c c c       b b b b b b b b \n";
	myMap+="c c c c c c c c c c c c       c c c c c c c c b b b b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c b b   b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c       b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c     b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c       b b b b b ";
	Board myBoard=MapManager::loadStringMap(myMap);
	bool testOk=true;
	if (myBoard.getWidth()!=32||myBoard.getHeight()!=23)
	{
		testOk=false;
		std::cout <<"ERROR : Bad width("<<myBoard.getWidth()<<") or height("<<myBoard.getHeight()<<")"<<std::endl;
	}
	if (myBoard.getCaseNoThrow(1,0)->getPlayer()==NULL)
	{
		testOk=false;
		std::cout <<"ERROR : Bad Case ("<<myBoard.getCaseNoThrow(1,0)->getPlayer()<<")" <<std::endl;
	}
	if (myBoard.getCaseNoThrow(1,0)->getPlayer()->getName().compare("a")&&!myBoard.getCaseNoThrow(2,0)->isCityCenter())
	{
		testOk=false;
		std::cout <<"ERROR : Bad Case ("<<myBoard.getCaseNoThrow(1,0)->getPlayer()->getName()<<") City Center "<<myBoard.getCaseNoThrow(1,0)->isCityCenter() <<std::endl;
	}
	if (myBoard.getCaseNoThrow(2,0)->getPlayer()->getName().compare("a")&&myBoard.getCaseNoThrow(2,0)->isCityCenter())
	{
		testOk=false;
		std::cout <<"ERROR : Bad Case ("<<myBoard.getCaseNoThrow(2,0)->getPlayer()->getName()<<") City Center "<<myBoard.getCaseNoThrow(2,0)->isCityCenter() <<std::endl;
	}
	if (myBoard.getCaseNoThrow(2,0)->getPlayer()==NULL&&!myBoard.getCaseNoThrow(0,0)->isCityCenter())
	{
		testOk=false;
		std::cout <<"ERROR : Bad Case ("<<myBoard.getCaseNoThrow(0,0)->getPlayer()<<") City Center "<<myBoard.getCaseNoThrow(2,0)->isCityCenter() <<std::endl;
	}
	if (myBoard.getCaseNoThrow(0,15)->getPlayer()->getName().compare("c")&&!myBoard.getCaseNoThrow(0,15)->isCityCenter())
	{
		testOk=false;
		std::cout <<"ERROR : Bad Case ("<<myBoard.getCaseNoThrow(0,15)->getPlayer()->getName()<<") City Center "<<myBoard.getCaseNoThrow(0,15)->isCityCenter() <<std::endl;
	}
	if (testOk)
	{
		std::cout <<"OK : good width and height"<<std::endl;
		return 0;
	}
	else
	return 1;

}
