/* matutilo.c

   written by Don Robert Maszle
   18 September 1992

   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   -- Revisions -----
     Logfile:  SCCS/s.matutilo.c
    Revision:  1.5
        Date:  28 Jan 1995
     Modtime:  03:43:30
      Author:  @a
   -- SCCS  ---------

   Matrix utilitites.  Output routines.
*/

#include <stdio.h>
#include <math.h>

#include "matutilo.h"

/* -----------------------------------------------------------------------------
   WriteArray

   writes the elements of an array, tab separated, to a specified file.

   The trailing tab is not printed, nor is  carriage return.
*/

void WriteArray (FILE *pfile, long cElems, double *rg)
{
  register long i;
  register long cElems_minus_1 = cElems - 1;

  for (i = 0; i < cElems; i++) {
    fprintf(pfile, "%g", rg[i]);
    if (i < cElems_minus_1) fputc ('\t', pfile);
  } /* for */
} /* WriteArray */


void WriteArrayExp (FILE *pfile, long cElems, double *rg)
{
  register long i;
  register long cElems_minus_1 = cElems - 1;

  for (i = 0; i < cElems; i++) {
    fprintf(pfile, "%g", exp(rg[i]));
    if (i < cElems_minus_1) fputc ('\t', pfile);
  } /* for */
} /* WriteArrayExp */


void _walog (long cElems, double *rg)
{
  int i;
  double dSum = 0.0;
  printf ("{");
  for (i = 0; i < cElems; i++) {
    dSum += exp(rg[i]);
    printf("%s%g", (i ? ", " : ""), exp(rg[i]));
  } /* for */
  printf ("} => %g [%g]\n", dSum, 1.0-dSum);
} /* _walog */

