#ifndef __EDIT_WIDGET_H
#define __EDIT_WIDGET_H

struct macro {
    short command;
    short ch;
};

struct syntax_rule {
    unsigned short keyword;
    unsigned char end;
    unsigned char context;
    unsigned char _context;
#define RULE_ON_LEFT_BORDER 1
#define RULE_ON_RIGHT_BORDER 2
    unsigned char border;
};

/*there are a maximum of ... */
#define MAXBUFF 1024
#define MAX_MACRO_LENGTH 1024

struct _syntax_marker {
    long offset;
    struct syntax_rule rule;
    struct _syntax_marker *next;
};

struct _book_mark {
    int line;		/* line number */
/* #define BOOK_MARK_COLOR ((0 << 8) | 26) */		/* black on white */
#define BOOK_MARK_COLOR ((25 << 8) | 5)
#define BOOK_MARK_FOUND_COLOR ((26 << 8) | 4)
    int c;		/* colour */
    struct _book_mark *next;
    struct _book_mark *prev;
};

struct editor_widget {
    Widget widget;
#define from_here num_widget_lines
    int num_widget_lines;
    int num_widget_columns;

    int have_frame;

    char *filename;		/* Name of the file */
    char *dir;			/* current directory */

/* dynamic buffers and cursor position for editor: */
    long curs1;			/*position of the cursor from the beginning of the file. */
    long curs2;			/*position from the end of the file */
    unsigned char *buffers1[MAXBUFF + 1];	/*all data up to curs1 */
    unsigned char *buffers2[MAXBUFF + 1];	/*all data from end of file down to curs2 */

/* search variables */
    long search_start;		/* First character to start searching from */
    int found_len;		/* Length of found string or 0 if none was found */
    long found_start;		/* the found word from a search - start position */

/* display information */
    long last_byte;		/* Last byte of file */
    long start_display;		/* First char displayed */
    long start_col;		/* First displayed column, negative */
    long max_column;		/* The maximum cursor position ever reached used to calc hori scroll bar */
    long curs_row;		/*row position of cursor on the screen */
    long curs_col;		/*column position on screen */
    int force;			/* how much of the screen do we redraw? */
    unsigned char overwrite;
    unsigned char modified;	/*has the file been changed?: 1 if char inserted or
				   deleted at all since last load or save */
    unsigned char screen_modified;	/* has the file been changed since the last screen draw? */
    int delete_file;			/* has the file been created in edit_load_file? Delete
			           it at end of editing when it hasn't been modified 
				   or saved */
    unsigned char highlight;
    long prev_col;		/*recent column position of the cursor - used when moving
				   up or down past lines that are shorter than the current line */
    long curs_line;		/*line number of the cursor. */
    long start_line;		/*line nummber of the top of the page */

/* file info */
    long total_lines;		/*total lines in the file */
    long mark1;			/*position of highlight start */
    long mark2;			/*position of highlight end */
    int column1;			/*position of column highlight start */
    int column2;			/*position of column highlight end */
    long bracket;		/*position of a matching bracket */

/* cache speedup for line lookups */
#define N_LINE_CACHES	32
    int caches_valid;
    int line_numbers[N_LINE_CACHES];
    long line_offsets[N_LINE_CACHES];

    struct _book_mark *book_mark;

/* undo stack and pointers */
    unsigned long stack_pointer;
    long *undo_stack;
    unsigned long stack_size;
    unsigned long stack_size_mask;
    unsigned long stack_bottom;
    struct stat stat1;

/* syntax higlighting */
    struct _syntax_marker *syntax_marker;
    struct context_rule **rules;
    long last_get_rule;
    struct syntax_rule rule;
    char *syntax_type;		/* description of syntax highlighting type being used */
    int explicit_syntax;	/* have we forced the syntax hi. type in spite of the filename? */

    int to_here;		/* dummy marker */


/* macro stuff */
    int macro_i;		/* -1 if not recording index to macro[] otherwise */
    struct macro macro[MAX_MACRO_LENGTH];
};

typedef struct editor_widget WEdit;

#define EDIT_DIR           PATH_SEP_STR ".mc" PATH_SEP_STR "cedit"
#define SYNTAX_FILE        EDIT_DIR PATH_SEP_STR "Syntax"
#define CLIP_FILE          EDIT_DIR PATH_SEP_STR "cooledit.clip"
#define MACRO_FILE         EDIT_DIR PATH_SEP_STR "cooledit.macros"
#define BLOCK_FILE         EDIT_DIR PATH_SEP_STR "cooledit.block"
#define ERROR_FILE         EDIT_DIR PATH_SEP_STR "cooledit.error"
#define TEMP_FILE          EDIT_DIR PATH_SEP_STR "cooledit.temp"

#endif /* !__EDIT_WIDGET_H */
