/*
 * Decompiled with CFR 0.152.
 */
package org.domterm.pty;

import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.domterm.Backend;
import org.domterm.pty.PTY;
import org.domterm.util.Util;
import org.domterm.util.WTDebug;

public class PtyBackend
extends Backend {
    public Writer pin;
    public Reader pout;
    public PTY pty;
    String[] childArgs;
    static String[] defaultArgs = new String[]{"/bin/bash"};

    public PtyBackend() {
        this(null);
    }

    public PtyBackend(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            stringArray = defaultArgs;
        }
        this.childArgs = stringArray;
    }

    @Override
    public void run(Writer writer) throws Exception {
        this.addVersionInfo("PtyClient");
        this.pty = new PTY(this.childArgs, "xterm-256color", this.getVersionInfo());
        try {
            this.pin = new OutputStreamWriter(this.pty.toChildInput);
            this.pout = new InputStreamReader(this.pty.fromChildOutput, "UTF-8");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(-1);
        }
        this.termWriter = writer;
        this.sendInputMode(this.lineEditingMode);
        Util.copyThread(this.pout, false, writer);
    }

    @Override
    public boolean isCanonicalMode() {
        int n = this.pty.getTtyMode();
        return (n & 2) != 0;
    }

    @Override
    public boolean isEchoingMode() {
        int n = this.pty.getTtyMode();
        return (n & 8) != 0;
    }

    @Override
    public void processInputCharacters(String string) {
        if (this.verbosity > 0) {
            WTDebug.println("processInputCharacters[" + WTDebug.toQuoted(string) + "]");
        }
        try {
            this.pin.write(string);
            this.pin.flush();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public void setWindowSize(int n, int n2, int n3, int n4) {
        if (this.pty != null) {
            this.pty.setWindowSize(n, n2, n3, n4);
        }
    }
}

